/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.transazioni.IdTransazioneApplicativoServer;
import org.openspcoop2.pdd.config.ConfigurazioneCoda;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.RichiestaApplicativa;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.MessaggioServizioApplicativo;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.behaviour.BehaviourForwardToConfiguration;
import org.openspcoop2.pdd.core.behaviour.StatoFunzionalita;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.ConfigurazioneGestioneConsegnaNotifiche;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.GestioneConsegnaNotificheUtils;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.MultiDeliverUtils;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateDBManager;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativiBehaviourMessage;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativiMessage;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.state.RequestConfig;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.threads.IRunnableInstance;
import org.openspcoop2.utils.threads.RunnableLogger;

public class TimerConsegnaContenutiApplicativiSender
implements IRunnableInstance {
    private OpenSPCoop2Properties propertiesReader = null;
    private RegistroServiziManager registroServiziReader;
    private ConfigurazionePdDManager configurazionePdDReader;
    private MessaggioServizioApplicativo messaggioServizioApplicativo;
    private RunnableLogger log;
    private RunnableLogger logSql;
    private boolean debug;
    private String clusterId;
    private int minTimeoutResend;

    public TimerConsegnaContenutiApplicativiSender(MessaggioServizioApplicativo messaggioServizioApplicativo, RegistroServiziManager registroServiziReader, ConfigurazionePdDManager configurazionePdDReader, String clusterId, ConfigurazioneCoda configurazioneCoda) {
        this.messaggioServizioApplicativo = messaggioServizioApplicativo;
        this.propertiesReader = OpenSPCoop2Properties.getInstance();
        this.registroServiziReader = registroServiziReader;
        this.configurazionePdDReader = configurazionePdDReader;
        this.debug = configurazioneCoda.isDebug();
        this.clusterId = clusterId;
        this.minTimeoutResend = configurazioneCoda.getConsegnaFallita_intervalloMinimoRiconsegna();
    }

    public String getIdentifier() {
        return "(" + this.messaggioServizioApplicativo.getIdTransazione() + "_" + this.messaggioServizioApplicativo.getServizioApplicativo() + "_" + this.messaggioServizioApplicativo.getIdMessaggio() + ")";
    }

    public boolean isContinuousRunning() {
        return false;
    }

    public void initialize(RunnableLogger log) throws UtilsException {
        this.log = log;
        this.logSql = new RunnableLogger(log.getThreadName(), OpenSPCoop2Logger.getLoggerOpenSPCoopConsegnaContenutiSql(this.debug));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws UtilsException {
        String idTransazione = this.messaggioServizioApplicativo.getIdTransazione();
        String servizioApplicativo = this.messaggioServizioApplicativo.getServizioApplicativo();
        String idMsgDaInoltrare = this.messaggioServizioApplicativo.getIdMessaggio();
        String identificativo = "redelivery_" + idTransazione + "_" + servizioApplicativo + "_" + idMsgDaInoltrare;
        Date oraRegistrazione = this.messaggioServizioApplicativo.getOraRegistrazione();
        MsgDiagnostico msgDiag = MsgDiagnostico.newInstance("TimerConsegnaContenutiApplicativi");
        PdDContext pddContext = new PdDContext();
        pddContext.addObject(Costanti.ID_TRANSAZIONE, idTransazione);
        msgDiag.setPrefixMsgPersonalizzati("timerConsegnaContenutiApplicativi.");
        msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
        msgDiag.addKeyword("@ID_MESSAGGIO_DA_INOLTRARE@", idMsgDaInoltrare);
        msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", servizioApplicativo);
        OpenSPCoopStateful openspcoopstateGestore = new OpenSPCoopStateful();
        try {
            this.log.debug("Riconsegna in corso del messaggio '" + idMsgDaInoltrare + "' per l'applicativo '" + servizioApplicativo + "' ...");
            openspcoopstateGestore.initResource(this.propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), "TimerConsegnaContenutiApplicativi", identificativo, OpenSPCoopStateDBManager.consegnePreseInCarico);
            GestoreMessaggi messaggioDaInviare = null;
            try {
                IDServizio servizioBusta;
                RepositoryBuste repositoryBuste = new RepositoryBuste(openspcoopstateGestore.getStatoRichiesta(), true, null);
                Busta bustaToSend = repositoryBuste.getBustaFromInBox(idMsgDaInoltrare, true);
                msgDiag.addKeywords(bustaToSend, true);
                IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(bustaToSend.getProtocollo());
                RequestInfo requestInfoForMemoryOptimization = new RequestInfo();
                requestInfoForMemoryOptimization.setProtocolFactory(protocolFactory);
                msgDiag.updateRequestInfo(requestInfoForMemoryOptimization);
                messaggioDaInviare = new GestoreMessaggi(openspcoopstateGestore, true, idMsgDaInoltrare, "INBOX", this.logSql.getLog(), msgDiag, null);
                pddContext = messaggioDaInviare.getPdDContext(true);
                pddContext.addObject(Costanti.REQUEST_INFO, requestInfoForMemoryOptimization);
                pddContext.addObject(Costanti.REQUEST_INFO_IN_MEMORY, true);
                IDSoggetto soggettoFruitore = null;
                if (bustaToSend.getMittente() != null) {
                    soggettoFruitore = new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente());
                }
                if ((servizioBusta = IDServizioFactory.getInstance().getIDServizioFromValues(bustaToSend.getTipoServizio(), bustaToSend.getServizio(), bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario(), bustaToSend.getVersioneServizio().intValue())) != null) {
                    servizioBusta.setAzione(bustaToSend.getAzione());
                }
                requestInfoForMemoryOptimization.setRequestConfig(new RequestConfig());
                if (servizioBusta != null && servizioBusta.getSoggettoErogatore() != null) {
                    requestInfoForMemoryOptimization.getRequestConfig().setIdServizio(servizioBusta);
                    try {
                        Soggetto soggettoRegistry = this.registroServiziReader.getSoggetto(servizioBusta.getSoggettoErogatore(), null, null);
                        requestInfoForMemoryOptimization.getRequestConfig().setSoggettoErogatoreRegistry(soggettoRegistry);
                    }
                    catch (Exception e) {
                        this.log.getLog().debug("Recupero soggetto erogatore dal registro fallito: " + e.getMessage(), (Throwable)e);
                    }
                    try {
                        org.openspcoop2.core.config.Soggetto soggettoConfig = this.configurazionePdDReader.getSoggetto(servizioBusta.getSoggettoErogatore(), null);
                        requestInfoForMemoryOptimization.getRequestConfig().setSoggettoErogatoreConfig(soggettoConfig);
                    }
                    catch (Exception e) {
                        this.log.getLog().debug("Recupero soggetto erogatore dal registro fallito: " + e.getMessage(), (Throwable)e);
                    }
                    try {
                        String idPorta = this.configurazionePdDReader.getIdentificativoPorta(servizioBusta.getSoggettoErogatore(), protocolFactory, null);
                        requestInfoForMemoryOptimization.getRequestConfig().setSoggettoErogatoreIdentificativoPorta(idPorta);
                    }
                    catch (Exception e) {
                        this.log.getLog().debug("Recupero dati soggetto erogatore (identificativoPorta) dal registro fallito: " + e.getMessage(), (Throwable)e);
                    }
                    try {
                        if (requestInfoForMemoryOptimization.getRequestConfig().getSoggettoErogatoreRegistry() != null) {
                            if (requestInfoForMemoryOptimization.getRequestConfig().getSoggettoErogatoreRegistry().getPortaDominio() != null && StringUtils.isNotEmpty((String)requestInfoForMemoryOptimization.getRequestConfig().getSoggettoErogatoreRegistry().getPortaDominio())) {
                                PortaDominio pdd = this.registroServiziReader.getPortaDominio(requestInfoForMemoryOptimization.getRequestConfig().getSoggettoErogatoreRegistry().getPortaDominio(), null, null);
                                requestInfoForMemoryOptimization.getRequestConfig().setSoggettoErogatorePddReaded(Boolean.valueOf(true));
                                requestInfoForMemoryOptimization.getRequestConfig().setSoggettoErogatorePdd(pdd);
                            } else {
                                requestInfoForMemoryOptimization.getRequestConfig().setSoggettoErogatorePddReaded(Boolean.valueOf(true));
                            }
                        }
                    }
                    catch (Exception e) {
                        this.log.getLog().debug("Recupero dati soggetto erogatore (pdd) dal registro fallito: " + e.getMessage(), (Throwable)e);
                    }
                }
                String implementazioneDestinatario = this.registroServiziReader.getImplementazionePdD(new IDSoggetto(bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario()), null, requestInfoForMemoryOptimization);
                requestInfoForMemoryOptimization.getRequestConfig().setSoggettoErogatoreImplementazionePdd(implementazioneDestinatario);
                String implementazioneMittente = null;
                if (bustaToSend.getTipoMittente() != null && bustaToSend.getMittente() != null) {
                    implementazioneMittente = this.registroServiziReader.getImplementazionePdD(new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente()), null, requestInfoForMemoryOptimization);
                    requestInfoForMemoryOptimization.getRequestConfig().setSoggettoFruitoreImplementazionePdd(implementazioneMittente);
                }
                IDAccordo idAccordo = null;
                AccordoServizioParteSpecifica asps = null;
                try {
                    asps = this.registroServiziReader.getAccordoServizioParteSpecifica(servizioBusta, null, Boolean.valueOf(false), requestInfoForMemoryOptimization);
                    idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
                    requestInfoForMemoryOptimization.getRequestConfig().setAsps(asps);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "ConsegnaAsincrona getAccordoServizioParteSpecifica(" + servizioBusta + ")");
                }
                IDSoggetto identitaPdD = null;
                String dominioRD = null;
                try {
                    if (servizioBusta != null) {
                        dominioRD = this.configurazionePdDReader.getIdentificativoPorta(servizioBusta.getSoggettoErogatore(), protocolFactory, requestInfoForMemoryOptimization);
                    }
                    if (dominioRD == null) {
                        throw new Exception("Dominio is null");
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "ConsegnaAsincrona getDominio(" + servizioBusta.getSoggettoErogatore() + ")");
                }
                identitaPdD = dominioRD == null ? this.propertiesReader.getIdentitaPortaDefault(null, requestInfoForMemoryOptimization) : new IDSoggetto(bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario(), dominioRD);
                requestInfoForMemoryOptimization.setIdentitaPdD(identitaPdD);
                requestInfoForMemoryOptimization.setIdServizio(servizioBusta);
                requestInfoForMemoryOptimization.setFruitore(soggettoFruitore);
                IDPortaApplicativa idPA = this.configurazionePdDReader.getIDPortaApplicativa(this.messaggioServizioApplicativo.getNomePorta(), requestInfoForMemoryOptimization, protocolFactory);
                requestInfoForMemoryOptimization.getRequestConfig().setIdPortaApplicativa(idPA);
                RichiestaApplicativa richiestaApplicativa = new RichiestaApplicativa(soggettoFruitore, identitaPdD, idPA);
                richiestaApplicativa.setServizioApplicativo(servizioApplicativo);
                richiestaApplicativa.setIdentitaServizioApplicativoFruitore(bustaToSend.getServizioApplicativoFruitore());
                richiestaApplicativa.setIdAccordo(idAccordo);
                if (servizioBusta != null) {
                    IDServizioApplicativo idSA = new IDServizioApplicativo();
                    idSA.setNome(richiestaApplicativa.getServizioApplicativo());
                    idSA.setIdSoggettoProprietario(servizioBusta.getSoggettoErogatore());
                    try {
                        ServizioApplicativo sa = this.configurazionePdDReader.getServizioApplicativo(idSA, requestInfoForMemoryOptimization);
                        requestInfoForMemoryOptimization.getRequestConfig().addServizioApplicativoErogatore(sa, idTransazione);
                    }
                    catch (Exception e) {
                        this.log.getLog().debug("Recupero dati soggetto erogatore (pdd) dal registro fallito: " + e.getMessage(), (Throwable)e);
                    }
                }
                ConsegnaContenutiApplicativiMessage consegnaMSG = new ConsegnaContenutiApplicativiMessage();
                consegnaMSG.setBusta(bustaToSend);
                consegnaMSG.setOneWayVersione11(false);
                consegnaMSG.setStateless(true);
                consegnaMSG.setImplementazionePdDSoggettoMittente(implementazioneMittente);
                consegnaMSG.setImplementazionePdDSoggettoDestinatario(implementazioneDestinatario);
                consegnaMSG.setPddContext(pddContext);
                consegnaMSG.setRichiestaApplicativa(richiestaApplicativa);
                BehaviourForwardToConfiguration behaviourForwardToConfiguration = new BehaviourForwardToConfiguration();
                if (this.messaggioServizioApplicativo.isSbustamentoSoap()) {
                    behaviourForwardToConfiguration.setSbustamentoSoap(StatoFunzionalita.ABILITATA);
                } else {
                    behaviourForwardToConfiguration.setSbustamentoSoap(StatoFunzionalita.DISABILITATA);
                }
                if (this.messaggioServizioApplicativo.isSbustamentoInformazioniProtocollo()) {
                    behaviourForwardToConfiguration.setSbustamentoInformazioniProtocollo(StatoFunzionalita.ABILITATA);
                } else {
                    behaviourForwardToConfiguration.setSbustamentoInformazioniProtocollo(StatoFunzionalita.DISABILITATA);
                }
                ConsegnaContenutiApplicativiBehaviourMessage behaviourMsg = new ConsegnaContenutiApplicativiBehaviourMessage();
                behaviourMsg.setIdMessaggioPreBehaviour(bustaToSend.getRiferimentoMessaggio());
                behaviourMsg.setBehaviourForwardToConfiguration(behaviourForwardToConfiguration);
                IdTransazioneApplicativoServer idTransazioneApplicativoServer = new IdTransazioneApplicativoServer();
                idTransazioneApplicativoServer.setIdTransazione(PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, pddContext));
                idTransazioneApplicativoServer.setServizioApplicativoErogatore(servizioApplicativo);
                PortaApplicativa pa = this.configurazionePdDReader.getPortaApplicativaSafeMethod(idPA, requestInfoForMemoryOptimization);
                requestInfoForMemoryOptimization.getRequestConfig().setPortaApplicativa(pa);
                if (pa != null && pa.getServizioApplicativoList() != null) {
                    for (PortaApplicativaServizioApplicativo pasa : pa.getServizioApplicativoList()) {
                        if (!pasa.getNome().equals(servizioApplicativo)) continue;
                        if (pasa.getDatiConnettore() != null) {
                            idTransazioneApplicativoServer.setConnettoreNome(pasa.getDatiConnettore().getNome());
                        }
                        ConfigurazioneGestioneConsegnaNotifiche configGestioneConsegna = MultiDeliverUtils.read(pasa);
                        GestioneErrore gestioneErroreBehaviour = GestioneConsegnaNotificheUtils.toGestioneErrore(configGestioneConsegna);
                        behaviourMsg.setGestioneErrore(gestioneErroreBehaviour);
                        break;
                    }
                }
                behaviourMsg.setIdTransazioneApplicativoServer(idTransazioneApplicativoServer);
                behaviourMsg.setOraRegistrazioneTransazioneApplicativoServer(oraRegistrazione);
                consegnaMSG.setBehaviour(behaviourMsg);
                openspcoopstateGestore.releaseResource();
                EsitoLib result = null;
                OpenSPCoopState openspcoopstateMessaggio = null;
                try {
                    ConsegnaContenutiApplicativi lib = new ConsegnaContenutiApplicativi(OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
                    openspcoopstateMessaggio = new OpenSPCoopStateful();
                    openspcoopstateMessaggio.setMessageLib(consegnaMSG);
                    result = lib.onMessage(openspcoopstateMessaggio);
                }
                finally {
                    try {
                        if (openspcoopstateMessaggio != null && !openspcoopstateMessaggio.resourceReleased()) {
                            openspcoopstateMessaggio.releaseResource();
                        }
                    }
                    catch (Exception lib) {}
                    openspcoopstateGestore.updateResource(identificativo);
                    messaggioDaInviare.updateOpenSPCoopState(openspcoopstateGestore);
                }
                if (this.debug) {
                    this.log.debug("Invocato ConsegnaContenutiApplicativi per [" + bustaToSend.getID() + "] con esito: " + result.getStatoInvocazione(), result.getErroreNonGestito());
                }
                if (3 == result.getStatoInvocazione()) {
                    Timestamp tMinTimeoutResend = new Timestamp(DateManager.getTimeMillis() + (long)(this.minTimeoutResend * 1000));
                    if (result.getDataRispedizioneAggiornata() == null || result.getDataRispedizioneAggiornata().before(tMinTimeoutResend)) {
                        messaggioDaInviare.aggiornaDataRispedizione(tMinTimeoutResend, servizioApplicativo);
                    }
                    if (!result.isErroreProcessamentoMessaggioAggiornato()) {
                        if (result.getErroreNonGestito() != null) {
                            messaggioDaInviare.aggiornaErroreProcessamentoMessaggio("[TimerConsegnaContenutiApplicativi] " + result.getErroreNonGestito().getMessage(), servizioApplicativo);
                        } else if (result.getMotivazioneErroreNonGestito() != null) {
                            messaggioDaInviare.aggiornaErroreProcessamentoMessaggio("[TimerConsegnaContenutiApplicativi] " + result.getMotivazioneErroreNonGestito(), servizioApplicativo);
                        } else {
                            messaggioDaInviare.aggiornaErroreProcessamentoMessaggio("[TimerConsegnaContenutiApplicativi] Invocato ConsegnaContenutiApplicativi per [" + bustaToSend.getID() + "] con esito: " + result.getStatoInvocazione(), servizioApplicativo);
                        }
                    }
                } else {
                    msgDiag.logPersonalizzato("inoltroMessaggio");
                    if (this.debug) {
                        this.log.debug(msgDiag.getMessaggio_replaceKeywords("inoltroMessaggio"));
                    }
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "InoltroMessaggioInbox(" + idMsgDaInoltrare + ")");
                this.log.error("ErroreInoltroMessaggioInbox(" + idMsgDaInoltrare + "): " + e.getMessage(), (Throwable)e);
                if (openspcoopstateGestore != null && !openspcoopstateGestore.resourceReleased()) {
                    messaggioDaInviare.aggiornaDataRispedizione(new Timestamp(DateManager.getTimeMillis() + (long)(this.minTimeoutResend * 1000)), servizioApplicativo);
                    messaggioDaInviare.aggiornaErroreProcessamentoMessaggio("[TimerConsegnaContenutiApplicativi] " + e.getMessage(), servizioApplicativo);
                }
            }
            finally {
                if (openspcoopstateGestore != null && !openspcoopstateGestore.resourceReleased()) {
                    messaggioDaInviare.releaseMessaggioPresaInCosegna(servizioApplicativo, this.clusterId, this.debug, this.logSql);
                }
            }
            this.log.debug("Riconsegna in corso del messaggio '" + idMsgDaInoltrare + "' per l'applicativo '" + servizioApplicativo + "' terminata");
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "GestioneRiconsegnaMessaggio");
            this.log.error("Riscontrato errore durante la consegna del messaggio '" + idMsgDaInoltrare + "' per l'applicativo '" + servizioApplicativo + "': " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (openspcoopstateGestore != null) {
                openspcoopstateGestore.releaseResource();
            }
        }
    }
}

