/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.core.config.utils.OpenSPCoopAppenderUtilities;
import org.openspcoop2.core.eventi.dao.IServiceManager;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryConfig;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryLibrary;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryObjectType;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.logger.DumpOpenSPCoopProtocolAppender;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.MsgDiagnosticoOpenSPCoopProtocolAppender;
import org.openspcoop2.pdd.logger.TracciamentoOpenSPCoopProtocolAppender;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerLock;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.pdd.timers.TipoLock;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticProducer;
import org.openspcoop2.protocol.sdk.dump.IDumpProducer;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaProducer;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.semaphore.Semaphore;
import org.openspcoop2.utils.semaphore.SemaphoreConfiguration;
import org.openspcoop2.utils.semaphore.SemaphoreMapping;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerFileSystemRecoveryThread
extends BaseThread {
    private static TimerState STATE = TimerState.OFF;
    public static final String ID_MODULO = "TimerFileSystemRecovery";
    private static final int MAX_ITERATIONS = 10000;
    private Logger logCore = null;
    private Logger logSql = null;
    private Logger logTimer = null;
    private boolean debug = false;
    private boolean recoveryEventi;
    private boolean recoveryTransazioni;
    private long recoveryEventiProcessingFileAfterMs;
    private long recoveryTransazioniProcessingFileAfterMs;
    private long recoveryMaxFileLimit;
    private OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
    private String tipoDatabaseRuntime = null;
    private DAOFactory daoFactory = null;
    private Logger daoFactoryLogger = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesTransazioni = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesPluginsEventi = null;
    private ITracciaProducer loggerTracciamentoOpenSPCoopAppender = null;
    private IDiagnosticProducer loggerMsgDiagnosticoOpenSPCoopAppender = null;
    private IDumpProducer loggerDumpOpenSPCoopAppender = null;
    private boolean transazioniRegistrazioneDumpHeadersCompactEnabled = false;
    private static final String ID_TIMER = "__timerFileSystemRecovery";
    private TimerLock timerLock = null;
    private Semaphore semaphore = null;
    private InfoStatistics semaphore_statistics;
    private MsgDiagnostico msgDiag = null;
    private FSRecoveryConfig conf = null;

    public static TimerState getSTATE() {
        return STATE;
    }

    public static void setSTATE(TimerState sTATE) {
        STATE = sTATE;
    }

    public TimerFileSystemRecoveryThread(Logger logCore, Logger logSql, Logger logTimer) throws TimerException, CoreException {
        this.logCore = logCore;
        this.logSql = logSql;
        this.logTimer = logTimer;
        this.setTimeout(this.properties.getFileSystemRecoveryTimerIntervalSeconds());
        try {
            this.msgDiag = MsgDiagnostico.newInstance(ID_MODULO);
            this.msgDiag.setPrefixMsgPersonalizzati("timerFileSystemRecovery.");
            this.msgDiag.addKeyword("@ID_TIMER@", ID_MODULO);
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato Errore durante l'inizializzazione del MsgDiagnostico";
            this.logTimerError(msgErrore, e);
            throw new TimerException(msgErrore, e);
        }
        this.msgDiag.logPersonalizzato("avvioInCorso");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioInCorso"));
        this.debug = this.properties.isFileSystemRecoveryDebug();
        this.recoveryEventi = this.properties.isFileSystemRecoveryTimerEventEnabled();
        this.recoveryTransazioni = this.properties.isFileSystemRecoveryTimerTransactionEnabled();
        this.recoveryEventiProcessingFileAfterMs = this.properties.getFileSystemRecoveryEventsProcessingFileAfterMs();
        this.recoveryTransazioniProcessingFileAfterMs = this.properties.getFileSystemRecoveryTransactionProcessingFileAfterMs();
        this.recoveryMaxFileLimit = this.properties.getFileSystemRecoveryMaxFileLimit();
        DAOFactoryProperties daoFactoryProperties = null;
        try {
            this.tipoDatabaseRuntime = this.properties.getDatabaseType();
            if (this.tipoDatabaseRuntime == null) {
                throw new TimerException("Tipo Database non definito");
            }
            this.daoFactoryLogger = this.logSql;
            this.daoFactory = DAOFactory.getInstance((Logger)this.daoFactoryLogger);
            daoFactoryProperties = DAOFactoryProperties.getInstance((Logger)this.daoFactoryLogger);
            if (this.recoveryTransazioni) {
                this.daoFactoryServiceManagerPropertiesTransazioni = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)ProjectInfo.getInstance());
                this.daoFactoryServiceManagerPropertiesTransazioni.setShowSql(this.debug);
                this.daoFactoryServiceManagerPropertiesTransazioni.setDatabaseType(DBTransazioniManager.getInstance().getTipoDatabase());
            }
            if (this.recoveryEventi) {
                this.daoFactoryServiceManagerPropertiesPluginsEventi = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)org.openspcoop2.core.eventi.utils.ProjectInfo.getInstance());
                this.daoFactoryServiceManagerPropertiesPluginsEventi.setShowSql(this.debug);
                this.daoFactoryServiceManagerPropertiesPluginsEventi.setDatabaseType(DBTransazioniManager.getInstance().getTipoDatabase());
            }
        }
        catch (Exception e) {
            throw new TimerException("Errore durante l'inizializzazione del datasource: " + e.getMessage(), e);
        }
        if (this.recoveryTransazioni) {
            boolean usePdDConnection = true;
            try {
                this.loggerTracciamentoOpenSPCoopAppender = new TracciamentoOpenSPCoopProtocolAppender();
                OpenspcoopAppender tracciamentoOpenSPCoopAppender = new OpenspcoopAppender();
                tracciamentoOpenSPCoopAppender.setTipo(ID_TIMER);
                ArrayList tracciamentoOpenSPCoopAppenderProperties = new ArrayList();
                OpenSPCoopAppenderUtilities.addParameters((Logger)this.daoFactoryLogger, tracciamentoOpenSPCoopAppenderProperties, null, null, null, null, null, (String)this.tipoDatabaseRuntime, (boolean)usePdDConnection, (boolean)this.debug);
                OpenSPCoopAppenderUtilities.addCheckProperties(tracciamentoOpenSPCoopAppenderProperties, (boolean)false);
                tracciamentoOpenSPCoopAppender.setPropertyList(tracciamentoOpenSPCoopAppenderProperties);
                this.loggerTracciamentoOpenSPCoopAppender.initializeAppender(tracciamentoOpenSPCoopAppender);
                this.loggerTracciamentoOpenSPCoopAppender.isAlive();
            }
            catch (Exception e) {
                throw new TimerException("Errore durante l'inizializzazione del TracciamentoAppender: " + e.getMessage(), e);
            }
            try {
                this.loggerMsgDiagnosticoOpenSPCoopAppender = new MsgDiagnosticoOpenSPCoopProtocolAppender();
                OpenspcoopAppender diagnosticoOpenSPCoopAppender = new OpenspcoopAppender();
                diagnosticoOpenSPCoopAppender.setTipo(ID_TIMER);
                ArrayList diagnosticoOpenSPCoopAppenderProperties = new ArrayList();
                OpenSPCoopAppenderUtilities.addParameters((Logger)this.daoFactoryLogger, diagnosticoOpenSPCoopAppenderProperties, null, null, null, null, null, (String)this.tipoDatabaseRuntime, (boolean)usePdDConnection, (boolean)this.debug);
                OpenSPCoopAppenderUtilities.addCheckProperties(diagnosticoOpenSPCoopAppenderProperties, (boolean)false);
                diagnosticoOpenSPCoopAppender.setPropertyList(diagnosticoOpenSPCoopAppenderProperties);
                this.loggerMsgDiagnosticoOpenSPCoopAppender.initializeAppender(diagnosticoOpenSPCoopAppender);
                this.loggerMsgDiagnosticoOpenSPCoopAppender.isAlive();
            }
            catch (Exception e) {
                throw new TimerException("Errore durante l'inizializzazione del DiagnosticoAppender: " + e.getMessage(), e);
            }
            try {
                this.loggerDumpOpenSPCoopAppender = new DumpOpenSPCoopProtocolAppender();
                OpenspcoopAppender dumpOpenSPCoopAppender = new OpenspcoopAppender();
                dumpOpenSPCoopAppender.setTipo(ID_TIMER);
                ArrayList dumpOpenSPCoopAppenderProperties = new ArrayList();
                OpenSPCoopAppenderUtilities.addParameters((Logger)this.daoFactoryLogger, dumpOpenSPCoopAppenderProperties, null, null, null, null, null, (String)this.tipoDatabaseRuntime, (boolean)usePdDConnection, (boolean)this.debug);
                OpenSPCoopAppenderUtilities.addCheckProperties(dumpOpenSPCoopAppenderProperties, (boolean)false);
                dumpOpenSPCoopAppender.setPropertyList(dumpOpenSPCoopAppenderProperties);
                this.loggerDumpOpenSPCoopAppender.initializeAppender(dumpOpenSPCoopAppender);
                this.loggerDumpOpenSPCoopAppender.isAlive();
                this.transazioniRegistrazioneDumpHeadersCompactEnabled = this.properties.isTransazioniRegistrazioneDumpHeadersCompactEnabled();
            }
            catch (Exception e) {
                throw new TimerException("Errore durante l'inizializzazione del DumpAppender: " + e.getMessage(), e);
            }
        }
        if (this.properties.isFileSystemRecoveryLockEnabled()) {
            this.timerLock = new TimerLock(TipoLock.GESTIONE_FILESYSTEM_TRACE_RECOVERY);
            if (this.properties.isTimerLockByDatabase()) {
                this.semaphore_statistics = new InfoStatistics();
                SemaphoreConfiguration config = GestoreMessaggi.newSemaphoreConfiguration(this.properties.getFileSystemRecoveryLockMaxLife(), this.properties.getFileSystemRecoveryLockIdleTime());
                TipiDatabase databaseType = TipiDatabase.toEnumConstant((String)this.properties.getDatabaseType());
                try {
                    this.semaphore = new Semaphore(this.semaphore_statistics, SemaphoreMapping.newInstance((String)this.timerLock.getIdLock()), config, databaseType, this.logTimer);
                }
                catch (Exception e) {
                    throw new TimerException(e.getMessage(), e);
                }
            }
        }
        String sec = "secondi";
        if (this.getTimeout() == 1) {
            sec = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.getTimeout() + " " + sec);
        this.msgDiag.logPersonalizzato("avvioEffettuato");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioEffettuato"));
    }

    public boolean initialize() {
        try {
            this.conf = new FSRecoveryConfig(false);
            this.conf.setLogCore(this.logCore);
            this.conf.setLogSql(this.logSql);
            this.conf.setDebug(this.debug);
            this.conf.setDefaultProtocol(this.properties.getDefaultProtocolName());
            this.conf.setRepository(this.properties.getFileSystemRecoveryRepository().getAbsolutePath());
            this.conf.setRipristinoEventi(this.recoveryEventi);
            this.conf.setRipristinoTransazioni(this.recoveryTransazioni);
            this.conf.setTentativi(this.properties.getFileSystemRecoveryMaxAttempts());
            this.conf.setProcessingEventFileAfterMs(this.recoveryEventiProcessingFileAfterMs);
            this.conf.setProcessingTransactionFileAfterMs(this.recoveryTransazioniProcessingFileAfterMs);
            this.conf.setMaxFileLimit(this.recoveryMaxFileLimit);
            return true;
        }
        catch (Exception e) {
            this.logCore.error("Errore durante il recovery da file system (InitConfigurazione): " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process() {
        if (TimerState.ENABLED.equals((Object)STATE)) {
            DBTransazioniManager dbManager = null;
            Resource r = null;
            try {
                dbManager = DBTransazioniManager.getInstance();
                r = dbManager.getResource(this.properties.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, null);
                if (r == null) {
                    throw new CoreException("Risorsa al database non disponibile");
                }
                Connection con = (Connection)r.getResource();
                if (con == null) {
                    throw new TimerException("Connessione non disponibile");
                }
                org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM = null;
                if (this.recoveryTransazioni) {
                    transazioniSM = (org.openspcoop2.core.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, this.daoFactoryServiceManagerPropertiesTransazioni, this.daoFactoryLogger);
                }
                IServiceManager pluginsSM = null;
                if (this.recoveryEventi) {
                    pluginsSM = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.eventi.utils.ProjectInfo.getInstance(), con, this.daoFactoryServiceManagerPropertiesPluginsEventi, this.daoFactoryLogger);
                }
                String causa = "Recupero transazioni da file system";
                try {
                    List transazioni;
                    List eventi;
                    if (this.properties.isFileSystemRecoveryLockEnabled()) {
                        GestoreMessaggi.acquireLock(this.semaphore, con, this.timerLock, this.msgDiag, causa, this.properties.getFileSystemRecoveryGetLockAttesaAttiva(), this.properties.getFileSystemRecoveryGetLockCheckInterval());
                    }
                    if ((eventi = FSRecoveryObjectType.getOperazioniEventi()) != null && !eventi.isEmpty()) {
                        boolean maxIterationsReached = false;
                        for (FSRecoveryObjectType fsRecoveryObjectType : eventi) {
                            int iteration = 0;
                            long processed = 0L;
                            do {
                                processed = this.process(fsRecoveryObjectType, con, transazioniSM, pluginsSM);
                                if (++iteration < 10000) continue;
                                String msg = "Raggiunto numero massimo di iterazioni (10000) per il tipo '" + fsRecoveryObjectType + "' (Eventi)";
                                this.logCore.warn(msg);
                                this.logTimer.warn(msg);
                                maxIterationsReached = true;
                                break;
                            } while (processed > 0L);
                            if (!maxIterationsReached) continue;
                            break;
                        }
                    }
                    if ((transazioni = FSRecoveryObjectType.getOperazioniTransazioni()) == null || transazioni.isEmpty()) return;
                    boolean maxIterationsReached = false;
                    for (FSRecoveryObjectType fsRecoveryObjectType : transazioni) {
                        int iteration = 0;
                        long processed = 0L;
                        do {
                            processed = this.process(fsRecoveryObjectType, con, transazioniSM, pluginsSM);
                            if (++iteration < 10000) continue;
                            String msg = "Raggiunto numero massimo di iterazioni (10000) per il tipo '" + fsRecoveryObjectType + "' (Transazioni)";
                            this.logCore.warn(msg);
                            this.logTimer.warn(msg);
                            maxIterationsReached = true;
                            break;
                        } while (processed > 0L);
                        if (!maxIterationsReached) continue;
                        return;
                    }
                    return;
                }
                finally {
                    if (this.properties.isFileSystemRecoveryLockEnabled()) {
                        try {
                            GestoreMessaggi.releaseLock(this.semaphore, con, this.timerLock, this.msgDiag, causa);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                this.logCore.error("Errore durante il recovery da file system: " + e.getMessage(), (Throwable)e);
                return;
            }
            finally {
                try {
                    if (r != null) {
                        dbManager.releaseResource(this.properties.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, r);
                    }
                }
                catch (Exception exception) {}
            }
        }
        this.logCore.info("Timer TimerFileSystemRecovery disabilitato");
        this.msgDiag.logPersonalizzato("disabilitato");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("disabilitato"));
    }

    public void close() {
        this.logCore.info("Thread per il recovery da file system terminato");
    }

    private long process(FSRecoveryObjectType objectType, Connection con, org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM, IServiceManager pluginsSM) {
        long startGenerazione = DateManager.getTimeMillis();
        this.msgDiag.addKeyword("@TIPO_RECORD@", objectType.name());
        this.msgDiag.logPersonalizzato("recovery.inCorso");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("recovery.inCorso"));
        if (this.properties.isFileSystemRecoveryLockEnabled()) {
            try {
                GestoreMessaggi.updateLock(this.semaphore, con, this.timerLock, this.msgDiag, "Recovery  '" + objectType + "' ...");
            }
            catch (Throwable e) {
                this.msgDiag.logErroreGenerico(e, "TimerFileSystemRecovery-UpdateLock");
                this.logTimer.error("TimerFileSystemRecovery-UpdateLock: " + e.getMessage(), e);
                return -1L;
            }
        }
        long l = FSRecoveryLibrary.generate((FSRecoveryConfig)this.conf, (DAOFactory)this.daoFactory, (Logger)this.daoFactoryLogger, (ServiceManagerProperties)this.daoFactoryServiceManagerPropertiesTransazioni, (long)this.properties.getGestioneSerializableDBAttesaAttiva(), (int)this.properties.getGestioneSerializableDBCheckInterval(), (org.openspcoop2.core.transazioni.dao.IServiceManager)transazioniSM, (ITracciaProducer)this.loggerTracciamentoOpenSPCoopAppender, (IDiagnosticProducer)this.loggerMsgDiagnosticoOpenSPCoopAppender, (IDumpProducer)this.loggerDumpOpenSPCoopAppender, (boolean)this.transazioniRegistrazioneDumpHeadersCompactEnabled, (IServiceManager)pluginsSM, (Connection)con, (FSRecoveryObjectType)objectType);
        long endGenerazione = DateManager.getTimeMillis();
        String tempoImpiegato = Utilities.convertSystemTimeIntoStringMillisecondi((long)(endGenerazione - startGenerazione), (boolean)true);
        this.msgDiag.addKeyword("@TEMPO_GENERAZIONE@", tempoImpiegato);
        this.msgDiag.addKeyword("@NUMERO_RECORD@", "" + l);
        this.msgDiag.logPersonalizzato("recovery.effettuata");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("recovery.effettuata"));
        return l;
    }

    private void logTimerError(String msgErrore, Exception e) {
        if (this.logTimer != null) {
            this.logTimer.error(msgErrore, (Throwable)e);
        }
    }
}

