/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.EJBUtilsException;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.node.INodeSender;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.mdb.InoltroBusteMessage;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerLock;
import org.openspcoop2.pdd.timers.TimerLockNotAvailableException;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.pdd.timers.TipoLock;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.driver.BustaNonRiscontrata;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.driver.Riscontri;
import org.openspcoop2.protocol.engine.driver.RollbackRepositoryBuste;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.StatelessMessage;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.semaphore.Semaphore;
import org.openspcoop2.utils.semaphore.SemaphoreConfiguration;
import org.openspcoop2.utils.semaphore.SemaphoreMapping;
import org.slf4j.Logger;

public class TimerGestoreBusteNonRiscontrateLib {
    private static TimerState STATE_ONEWAY = TimerState.OFF;
    private static TimerState STATE_ASINCRONI = TimerState.OFF;
    private MsgDiagnostico msgDiag = null;
    private Logger logTimer = null;
    private OpenSPCoop2Properties propertiesReader = null;
    private boolean logQuery = false;
    private int limit = 50;
    private long timeout = 10L;
    private ConfigurazionePdDManager configurazionePdDReader;
    private RegistroServiziManager registroServiziReader;
    private static String tipoNodeSender = null;
    private ProtocolFactoryManager protocolFactoryManager = null;
    private TimerLock timerLock = null;
    private Semaphore semaphore = null;
    private InfoStatistics semaphore_statistics;

    public static TimerState getSTATE_ONEWAY() {
        return STATE_ONEWAY;
    }

    public static void setSTATE_ONEWAY(TimerState sTATE_ONEWAY) {
        STATE_ONEWAY = sTATE_ONEWAY;
    }

    public static TimerState getSTATE_ASINCRONI() {
        return STATE_ASINCRONI;
    }

    public static void setSTATE_ASINCRONI(TimerState sTATE_ASINCRONI) {
        STATE_ASINCRONI = sTATE_ASINCRONI;
    }

    public TimerGestoreBusteNonRiscontrateLib(MsgDiagnostico msgDiag, Logger log, OpenSPCoop2Properties p, boolean logQuery, int limit, long timeout, ConfigurazionePdDManager configurazionePdDReader, RegistroServiziManager registroServiziReader) throws TimerException {
        this.msgDiag = msgDiag;
        this.logTimer = log;
        this.propertiesReader = p;
        this.logQuery = logQuery;
        this.limit = limit;
        this.timeout = timeout;
        this.configurazionePdDReader = configurazionePdDReader;
        this.registroServiziReader = registroServiziReader;
        try {
            this.protocolFactoryManager = ProtocolFactoryManager.getInstance();
        }
        catch (Exception e) {
            throw new TimerException("Riscontrato errore durante l'inizializzazione del ProtocolFactoryManager: " + e.getMessage(), e);
        }
        if (tipoNodeSender == null) {
            try {
                tipoNodeSender = this.propertiesReader.getNodeSender();
            }
            catch (Exception e) {
                throw new TimerException("Riscontrato errore durante l'inizializzazione del Thread GestoreBusteNonRiscontrate (NodeSender): " + e.getMessage(), e);
            }
        }
        this.timerLock = new TimerLock(TipoLock.GESTIONE_BUSTE_NON_RISCONTRATE);
        if (this.propertiesReader.isTimerLockByDatabase()) {
            this.semaphore_statistics = new InfoStatistics();
            SemaphoreConfiguration config = GestoreMessaggi.newSemaphoreConfiguration(this.propertiesReader.getTimerGestoreRiscontriRicevuteLockMaxLife(), this.propertiesReader.getTimerGestoreRiscontriRicevuteLockIdleTime());
            TipiDatabase databaseType = TipiDatabase.toEnumConstant((String)this.propertiesReader.getDatabaseType());
            try {
                this.semaphore = new Semaphore(this.semaphore_statistics, SemaphoreMapping.newInstance((String)this.timerLock.getIdLock()), config, databaseType, this.logTimer);
            }
            catch (Exception e) {
                throw new TimerException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws TimerException {
        if (OpenSPCoop2Startup.contextDestroyed) {
            this.logTimer.error("[GestoreBusteNonRiscontrate] Rilevato sistema in shutdown");
            return;
        }
        if (!OpenSPCoop2Startup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            String msgErrore = "Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata";
            this.logTimer.error(msgErrore);
            throw new TimerException(msgErrore);
        }
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            this.logTimer.error("[GestoreBusteNonRiscontrate] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), (Throwable)TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.logTimer.error("[GestoreBusteNonRiscontrate] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        if (!TimerState.ENABLED.equals((Object)STATE_ONEWAY) && !TimerState.ENABLED.equals((Object)STATE_ASINCRONI)) {
            this.msgDiag.logPersonalizzato("disabilitato");
            this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("disabilitato"));
            return;
        }
        if (this.configurazionePdDReader.getTimeoutRiscontro() < 1L) {
            String msgErrore = "Riscontrato errore durante la lettura del timeout per le buste non riscontrate (<=0 ??)";
            this.msgDiag.logErroreGenerico(msgErrore, "getTimeoutRiscontro()");
            this.logTimer.error(msgErrore);
            return;
        }
        this.timeout = this.configurazionePdDReader.getTimeoutRiscontro();
        String minuti = "minuti";
        if (this.timeout == 1L) {
            minuti = "minuto";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.timeout + " " + minuti);
        this.msgDiag.addKeyword("@LIMIT@", "" + this.limit);
        this.msgDiag.logPersonalizzato("controlloInCorso");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("controlloInCorso"));
        long startControlloBusteNonRiscontrate = DateManager.getTimeMillis();
        GestoreMessaggi gestoreMsg = null;
        GestoreMessaggi messaggioDaInviare = null;
        RepositoryBuste repositoryBuste = null;
        Riscontri gestoreRiscontri = null;
        RollbackRepositoryBuste rollbackRepositoryBuste = null;
        OpenSPCoopStateful openspcoopState = new OpenSPCoopStateful();
        try {
            boolean cerca;
            String msgErrore;
            IDServizioApplicativo idSA;
            String servizioApplicativo;
            ServizioApplicativo sa;
            RichiestaDelegata richiestaDelegata;
            IDPortaDelegata idPD;
            ProprietaErroreApplicativo erroreAppl;
            Integrazione infoIntegrazione;
            IDServizio servizioBusta;
            String dominioRD;
            IDSoggetto identitaPdD;
            IDSoggetto soggettoBustaNonRiscontrata;
            Timestamp now;
            Date scadenza;
            Busta bustaToSend;
            IProtocolFactory protocolFactory;
            PdDContext pddContext;
            String idBustaDaRispedire;
            BustaNonRiscontrata bustaNonRiscontrata;
            int i;
            openspcoopState.initResource(this.propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), "GestoreBusteNonRiscontrate", null);
            Connection connectionDB = ((StateMessage)openspcoopState.getStatoRichiesta()).getConnectionDB();
            if (TimerState.ENABLED.equals((Object)STATE_ONEWAY)) {
                Riscontri rBuste = new Riscontri(openspcoopState.getStatoRichiesta(), this.logTimer);
                int offsetRiscontri = 0;
                String causaBusteOneWayToSend = "Rispedizione buste con profilo oneway non riscontrate";
                List busteOneWayToSend = null;
                try {
                    GestoreMessaggi.acquireLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaBusteOneWayToSend, this.propertiesReader.getTimerGestoreRiscontriRicevuteGetLockAttesaAttiva(), this.propertiesReader.getTimerGestoreRiscontriRicevuteGetLockCheckInterval());
                    busteOneWayToSend = rBuste.getBustePerUlterioreInoltro(this.timeout, this.limit, offsetRiscontri, this.logQuery);
                    if (this.logQuery && busteOneWayToSend != null && busteOneWayToSend.isEmpty()) {
                        this.logTimer.info("Non sono state trovate buste con profilo oneway non riscontrate da rispedire");
                    }
                    while (busteOneWayToSend != null && !busteOneWayToSend.isEmpty()) {
                        if (this.logQuery) {
                            this.logTimer.info("Trovate " + busteOneWayToSend.size() + " buste con profilo oneway non riscontrate da rispedire ...");
                        }
                        int gestiti = 0;
                        for (i = 0; i < busteOneWayToSend.size(); ++i) {
                            block114: {
                                block115: {
                                    bustaNonRiscontrata = (BustaNonRiscontrata)busteOneWayToSend.get(i);
                                    idBustaDaRispedire = bustaNonRiscontrata.getIdentificativo();
                                    this.msgDiag.addKeyword("@ID_MESSAGGIO_RICHIESTA@", idBustaDaRispedire);
                                    this.msgDiag.addKeyword("@PROFILO_COLLABORAZIONE@", bustaNonRiscontrata.getProfiloCollaborazione().name());
                                    this.msgDiag.logPersonalizzato("bustaNonRiscontrata");
                                    if (this.logQuery) {
                                        this.logTimer.debug(this.msgDiag.getMessaggio_replaceKeywords("bustaNonRiscontrata"));
                                    }
                                    try {
                                        GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, "Rispedizione busta con profilo oneway con id [" + idBustaDaRispedire + "] ...");
                                    }
                                    catch (Throwable e) {
                                        this.msgDiag.logErroreGenerico(e, "RispedizioneBustaNonRiscontrataOneWay(" + idBustaDaRispedire + ")-UpdateLock");
                                        this.logTimer.error("ErroreRispedizioneBustaNonRiscontrataOneWay(" + idBustaDaRispedire + ")-UpdateLock: " + e.getMessage(), e);
                                        break;
                                    }
                                    messaggioDaInviare = new GestoreMessaggi(openspcoopState, true, idBustaDaRispedire, "OUTBOX", this.logTimer, this.msgDiag, null);
                                    if (!messaggioDaInviare.existsMessage_noCache()) {
                                        this.msgDiag.logPersonalizzato("bustaNonRiscontrata.messaggioNonEsistente");
                                        this.logTimer.error(this.msgDiag.getMessaggio_replaceKeywords("bustaNonRiscontrata.messaggioNonEsistente"));
                                        try {
                                            repositoryBuste = new RepositoryBuste(openspcoopState.getStatoRichiesta(), true, null);
                                            repositoryBuste.eliminaUtilizzoPdDFromOutBox(idBustaDaRispedire);
                                            gestoreRiscontri = new Riscontri(openspcoopState.getStatoRichiesta(), null);
                                            gestoreRiscontri.validazioneRiscontroRicevuto(idBustaDaRispedire);
                                            ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                                            ++gestiti;
                                        }
                                        catch (Exception e) {
                                            this.msgDiag.logErroreGenerico(e, "EliminazioneBustaNonRiscontrataNonEsistente(" + idBustaDaRispedire + ")");
                                            this.logTimer.error("ErroreEliminazioneBustaNonRiscontrataNonEsistente(" + idBustaDaRispedire + "): " + e.getMessage(), (Throwable)e);
                                        }
                                        continue;
                                    }
                                    pddContext = messaggioDaInviare.getPdDContext(true);
                                    protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME));
                                    repositoryBuste = new RepositoryBuste(openspcoopState.getStatoRichiesta(), this.logTimer, true, protocolFactory);
                                    bustaToSend = repositoryBuste.getBustaFromOutBox(idBustaDaRispedire);
                                    this.msgDiag.addKeywords(bustaToSend, true);
                                    scadenza = bustaToSend.getScadenza();
                                    now = DateManager.getTimestamp();
                                    if (scadenza.before(now)) {
                                        this.msgDiag.logPersonalizzato("bustaNonRiscontrataScaduta");
                                        if (this.logQuery) {
                                            this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("bustaNonRiscontrataScaduta"));
                                        }
                                        try {
                                            repositoryBuste = new RepositoryBuste(openspcoopState.getStatoRichiesta(), true, protocolFactory);
                                            repositoryBuste.eliminaUtilizzoPdDFromOutBox(bustaToSend.getID());
                                            ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                                            gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag, pddContext);
                                            gestoreMsg.validateAndDeleteMsgOneWayRiscontrato();
                                        }
                                        catch (Exception e) {
                                            this.msgDiag.logErroreGenerico(e, "EliminazioneBustaNonRiscontrataScaduta(" + bustaToSend.getID() + ")");
                                            this.logTimer.error("ErroreEliminazioneBustaNonRiscontrataScaduta(" + bustaToSend.getID() + "): " + e.getMessage(), (Throwable)e);
                                        }
                                        break block114;
                                    }
                                    soggettoBustaNonRiscontrata = new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente());
                                    identitaPdD = null;
                                    dominioRD = null;
                                    try {
                                        dominioRD = this.configurazionePdDReader.getIdentificativoPorta(soggettoBustaNonRiscontrata, protocolFactory, null);
                                        if (dominioRD == null) {
                                            throw new Exception("Dominio is null");
                                        }
                                    }
                                    catch (Exception e) {
                                        this.msgDiag.logErroreGenerico(e, "BustaNonRiscontrata getDominio(" + soggettoBustaNonRiscontrata + ")");
                                    }
                                    identitaPdD = dominioRD == null ? this.propertiesReader.getIdentitaPortaDefaultWithoutProtocol() : new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente(), dominioRD);
                                    servizioBusta = IDServizioFactory.getInstance().getIDServizioFromValues(bustaToSend.getTipoServizio(), bustaToSend.getServizio(), bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario(), bustaToSend.getVersioneServizio().intValue());
                                    servizioBusta.setAzione(bustaToSend.getAzione());
                                    repositoryBuste = new RepositoryBuste(openspcoopState.getStatoRichiesta(), true, protocolFactory);
                                    infoIntegrazione = repositoryBuste.getInfoIntegrazioneFromOutBox(bustaToSend.getID());
                                    erroreAppl = this.propertiesReader.getProprietaGestioneErrorePD(protocolFactory.createProtocolManager());
                                    erroreAppl.setDominio(identitaPdD.getCodicePorta());
                                    idPD = this.configurazionePdDReader.getIDPortaDelegata(infoIntegrazione.getNomePorta(), null, protocolFactory);
                                    richiestaDelegata = new RichiestaDelegata(idPD, infoIntegrazione.getServizioApplicativo(), infoIntegrazione.getIdModuloInAttesa(), erroreAppl, identitaPdD);
                                    richiestaDelegata.setScenario(infoIntegrazione.getScenario());
                                    richiestaDelegata.setUtilizzoConsegnaAsincrona(true);
                                    richiestaDelegata.setIdCollaborazione(bustaToSend.getCollaborazione());
                                    richiestaDelegata.setProfiloCollaborazione(bustaToSend.getProfiloDiCollaborazione(), bustaToSend.getProfiloDiCollaborazioneValue());
                                    try {
                                        richiestaDelegata.setIdCorrelazioneApplicativa(messaggioDaInviare.getIDCorrelazioneApplicativa());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    sa = null;
                                    servizioApplicativo = richiestaDelegata.getServizioApplicativo();
                                    try {
                                        if (servizioApplicativo != null) {
                                            idSA = new IDServizioApplicativo();
                                            idSA.setNome(servizioApplicativo);
                                            idSA.setIdSoggettoProprietario(richiestaDelegata.getIdSoggettoFruitore());
                                            sa = this.configurazionePdDReader.getServizioApplicativo(idSA, null);
                                        }
                                    }
                                    catch (Exception e) {
                                        if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(servizioApplicativo)) break block115;
                                        throw e;
                                    }
                                }
                                String implementazioneMittente = this.registroServiziReader.getImplementazionePdD(new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente()), null, null);
                                String implementazioneDestinatario = this.registroServiziReader.getImplementazionePdD(new IDSoggetto(bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario()), null, null);
                                this.configurazionePdDReader.aggiornaProprietaGestioneErrorePD(erroreAppl, sa);
                                String profiloGestione = this.registroServiziReader.getProfiloGestioneFruizioneServizio(servizioBusta, null, null);
                                richiestaDelegata.setProfiloGestione(profiloGestione);
                                PortaDelegata pd = this.configurazionePdDReader.getPortaDelegataSafeMethod(idPD, null);
                                boolean oneWayStateless = this.configurazionePdDReader.isModalitaStateless(pd, bustaToSend.getProfiloDiCollaborazione());
                                boolean oneWayVersione11 = this.propertiesReader.isGestioneOnewayStateful_1_1() && !oneWayStateless;
                                InoltroBusteMessage inoltroMSG = new InoltroBusteMessage();
                                inoltroMSG.setRichiestaDelegata(richiestaDelegata);
                                inoltroMSG.setBusta(bustaToSend);
                                inoltroMSG.setOneWayVersione11(oneWayVersione11);
                                if (oneWayVersione11) {
                                    OpenSPCoopStateless stateless = new OpenSPCoopStateless();
                                    StatelessMessage statelessMessage = new StatelessMessage();
                                    statelessMessage.setBusta(bustaToSend);
                                    stateless.setStatoRichiesta((IState)statelessMessage);
                                    inoltroMSG.setOpenspcoopstate(stateless);
                                }
                                inoltroMSG.setImplementazionePdDSoggettoMittente(implementazioneMittente);
                                inoltroMSG.setImplementazionePdDSoggettoDestinatario(implementazioneDestinatario);
                                inoltroMSG.setPddContext(pddContext);
                                gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag, pddContext);
                                if ("db".equals(tipoNodeSender)) {
                                    gestoreMsg.ripristinaMessaggio();
                                    break block114;
                                }
                                try {
                                    String classTypeNodeSender = null;
                                    INodeSender nodeSender = null;
                                    try {
                                        classTypeNodeSender = ClassNameProperties.getInstance().getNodeSender(tipoNodeSender);
                                        nodeSender = (INodeSender)Loader.getInstance().newInstance(classTypeNodeSender);
                                        AbstractCore.init(nodeSender, pddContext, protocolFactory, new Object[0]);
                                    }
                                    catch (Exception e) {
                                        throw new EJBUtilsException("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage(), e);
                                    }
                                    nodeSender.send(inoltroMSG, "InoltroBuste", this.msgDiag, this.propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), "GestoreBusteNonRiscontrate", bustaToSend.getID(), gestoreMsg);
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(InoltroBuste)");
                                    this.logTimer.error("Spedizione->InoltroBuste non riuscita", (Throwable)e);
                                    try {
                                        GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaBusteOneWayToSend);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (openspcoopState != null) {
                                        openspcoopState.releaseResource();
                                    }
                                    return;
                                }
                            }
                            try {
                                if (this.logQuery) {
                                    this.logTimer.debug("Gestita/Reinviata busta OneWay non riscontrata con ID [" + bustaToSend.getID() + "]");
                                }
                                ++gestiti;
                                continue;
                            }
                            catch (Exception e) {
                                msgErrore = "RespedizioneBustaNonRiscontrata ErroreGenerale(" + idBustaDaRispedire + ")";
                                this.msgDiag.logErroreGenerico(e, msgErrore);
                                this.logTimer.error(msgErrore + ": " + e.getMessage(), (Throwable)e);
                            }
                        }
                        if (this.logQuery) {
                            this.logTimer.info("Gestite " + gestiti + " buste con profilo oneway non riscontrate da rispedire");
                        }
                        cerca = true;
                        try {
                            GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, "Ricerca nuovo buste con profilo oneway non riscontrate ...");
                        }
                        catch (Throwable e) {
                            this.msgDiag.logErroreGenerico(e, "RicercaNuoveBusteOneWayNonRiscontrate-UpdateLock");
                            this.logTimer.error("ErroreRicercaNuoveBusteOneWayNonRiscontrate-UpdateLock: " + e.getMessage(), e);
                            cerca = false;
                        }
                        if (cerca) {
                            busteOneWayToSend = rBuste.getBustePerUlterioreInoltro(this.timeout, this.limit, offsetRiscontri += busteOneWayToSend.size(), this.logQuery);
                            continue;
                        }
                        busteOneWayToSend = new ArrayList();
                    }
                }
                finally {
                    try {
                        GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaBusteOneWayToSend);
                    }
                    catch (Exception gestiti) {}
                }
            }
            if (this.logQuery) {
                this.logTimer.info("Gestione buste, con profilo oneway, disabilitata");
            }
            if (TimerState.ENABLED.equals((Object)STATE_ASINCRONI)) {
                org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione pBuste = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopState.getStatoRichiesta(), this.logTimer, null);
                int offsetBusteAsincrone = 0;
                String causaBusteAsincroneToSend = "Rispedizione buste con profilo asincrono non riscontrate";
                try {
                    GestoreMessaggi.acquireLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaBusteAsincroneToSend, this.propertiesReader.getTimerGestoreRiscontriRicevuteGetLockAttesaAttiva(), this.propertiesReader.getTimerGestoreRiscontriRicevuteGetLockCheckInterval());
                    List busteAsincroneToSend = null;
                    busteAsincroneToSend = pBuste.asincrono_getBusteAsincronePerUlterioreInoltro(this.timeout, this.limit, offsetBusteAsincrone, this.logQuery);
                    if (this.logQuery && busteAsincroneToSend != null && busteAsincroneToSend.size() <= 0) {
                        this.logTimer.info("Non sono state trovate buste con profilo asincrono non riscontrate da rispedire");
                    }
                    while (busteAsincroneToSend != null && busteAsincroneToSend.size() > 0) {
                        if (this.logQuery) {
                            this.logTimer.info("Trovate " + busteAsincroneToSend.size() + " buste con profilo asincrono non riscontrate da rispedire ...");
                        }
                        int gestiti = 0;
                        for (i = 0; i < busteAsincroneToSend.size(); ++i) {
                            block116: {
                                block117: {
                                    bustaNonRiscontrata = (BustaNonRiscontrata)busteAsincroneToSend.get(i);
                                    idBustaDaRispedire = bustaNonRiscontrata.getIdentificativo();
                                    this.msgDiag.addKeyword("@ID_MESSAGGIO_RICHIESTA@", idBustaDaRispedire);
                                    this.msgDiag.addKeyword("@PROFILO_COLLABORAZIONE@", bustaNonRiscontrata.getProfiloCollaborazione().name());
                                    this.msgDiag.logPersonalizzato("ricevutaAsincronaNonRicevuta");
                                    if (this.logQuery) {
                                        this.logTimer.debug(this.msgDiag.getMessaggio_replaceKeywords("ricevutaAsincronaNonRicevuta"));
                                    }
                                    try {
                                        GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, "Rispedizione busta con profilo asincrono con id [" + idBustaDaRispedire + "] ...");
                                    }
                                    catch (Throwable e) {
                                        this.msgDiag.logErroreGenerico(e, "RispedizioneBustaNonRiscontrataAsincrona(" + idBustaDaRispedire + ")-UpdateLock");
                                        this.logTimer.error("ErroreRispedizioneBustaNonRiscontrataAsincrona(" + idBustaDaRispedire + ")-UpdateLock: " + e.getMessage(), e);
                                        break;
                                    }
                                    messaggioDaInviare = new GestoreMessaggi(openspcoopState, true, idBustaDaRispedire, "OUTBOX", this.logTimer, this.msgDiag, null);
                                    if (!messaggioDaInviare.existsMessage_noCache()) {
                                        this.msgDiag.logPersonalizzato("ricevutaAsincronaNonRicevuta.messaggioNonEsistente");
                                        this.logTimer.error(this.msgDiag.getMessaggio_replaceKeywords("ricevutaAsincronaNonRicevuta.messaggioNonEsistente"));
                                        try {
                                            repositoryBuste = new RepositoryBuste(openspcoopState.getStatoRichiesta(), true, null);
                                            repositoryBuste.eliminaUtilizzoPdDFromOutBox(idBustaDaRispedire);
                                            rollbackRepositoryBuste = new RollbackRepositoryBuste(idBustaDaRispedire, openspcoopState.getStatoRichiesta(), true);
                                            rollbackRepositoryBuste.rollbackBustaIntoOutBox();
                                            ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                                            ++gestiti;
                                        }
                                        catch (Exception e) {
                                            this.msgDiag.logErroreGenerico(e, "EliminazioneBustaAsincronaNonEsistente(" + idBustaDaRispedire + ")");
                                            this.logTimer.error("ErroreEliminazioneBustaAsincronaNonEsistente(" + idBustaDaRispedire + "): " + e.getMessage(), (Throwable)e);
                                        }
                                        continue;
                                    }
                                    pddContext = messaggioDaInviare.getPdDContext(true);
                                    protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME));
                                    repositoryBuste = new RepositoryBuste(openspcoopState.getStatoRichiesta(), this.logTimer, true, protocolFactory);
                                    bustaToSend = repositoryBuste.getBustaFromOutBox(idBustaDaRispedire);
                                    this.msgDiag.addKeywords(bustaToSend, true);
                                    scadenza = bustaToSend.getScadenza();
                                    now = DateManager.getTimestamp();
                                    if (scadenza.before(now)) {
                                        this.msgDiag.logPersonalizzato("ricevutaAsincronaNonRicevuta.bustaScaduta");
                                        if (this.logQuery) {
                                            this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("ricevutaAsincronaNonRicevuta.bustaScaduta"));
                                        }
                                        try {
                                            rollbackRepositoryBuste = new RollbackRepositoryBuste(bustaToSend.getID(), openspcoopState.getStatoRichiesta(), true);
                                            rollbackRepositoryBuste.rollbackBustaIntoOutBox();
                                            ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                                            gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag, pddContext);
                                            gestoreMsg.logicDeleteMessage();
                                        }
                                        catch (Exception e) {
                                            this.msgDiag.logErroreGenerico(e, "EliminazioneBustaAsincronaScaduta(" + bustaToSend.getID() + ")");
                                            this.logTimer.error("ErroreEliminazioneBustaAsincronaScaduta(" + bustaToSend.getID() + "): " + e.getMessage(), (Throwable)e);
                                        }
                                        break block116;
                                    }
                                    soggettoBustaNonRiscontrata = new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente());
                                    identitaPdD = null;
                                    dominioRD = null;
                                    try {
                                        dominioRD = this.configurazionePdDReader.getIdentificativoPorta(soggettoBustaNonRiscontrata, protocolFactory, null);
                                        if (dominioRD == null) {
                                            throw new Exception("Dominio is null");
                                        }
                                    }
                                    catch (Exception e) {
                                        this.msgDiag.logErroreGenerico(e, "BustaAsincrona getDominio(" + soggettoBustaNonRiscontrata + ")");
                                        this.logTimer.error("ErroreBustaAsincrona getDominio(" + soggettoBustaNonRiscontrata + "): " + e.getMessage(), (Throwable)e);
                                    }
                                    identitaPdD = dominioRD == null ? this.propertiesReader.getIdentitaPortaDefaultWithoutProtocol() : new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente(), dominioRD);
                                    servizioBusta = IDServizioFactory.getInstance().getIDServizioFromValues(bustaToSend.getTipoServizio(), bustaToSend.getServizio(), bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario(), bustaToSend.getVersioneServizio().intValue());
                                    servizioBusta.setAzione(bustaToSend.getAzione());
                                    repositoryBuste = new RepositoryBuste(openspcoopState.getStatoRichiesta(), true, protocolFactory);
                                    infoIntegrazione = repositoryBuste.getInfoIntegrazioneFromOutBox(bustaToSend.getID());
                                    erroreAppl = this.propertiesReader.getProprietaGestioneErrorePD(protocolFactory.createProtocolManager());
                                    erroreAppl.setDominio(identitaPdD.getCodicePorta());
                                    idPD = this.configurazionePdDReader.getIDPortaDelegata(infoIntegrazione.getNomePorta(), null, protocolFactory);
                                    richiestaDelegata = new RichiestaDelegata(idPD, infoIntegrazione.getServizioApplicativo(), infoIntegrazione.getIdModuloInAttesa(), erroreAppl, identitaPdD);
                                    richiestaDelegata.setScenario(infoIntegrazione.getScenario());
                                    if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaToSend.getProfiloDiCollaborazione()) && bustaToSend.getRiferimentoMessaggio() == null) {
                                        richiestaDelegata.setUtilizzoConsegnaAsincrona(false);
                                    } else {
                                        richiestaDelegata.setUtilizzoConsegnaAsincrona(true);
                                    }
                                    richiestaDelegata.setRicevutaAsincrona(false);
                                    sa = null;
                                    servizioApplicativo = richiestaDelegata.getServizioApplicativo();
                                    try {
                                        if (servizioApplicativo != null) {
                                            idSA = new IDServizioApplicativo();
                                            idSA.setNome(servizioApplicativo);
                                            idSA.setIdSoggettoProprietario(richiestaDelegata.getIdSoggettoFruitore());
                                            sa = this.configurazionePdDReader.getServizioApplicativo(idSA, null);
                                        }
                                    }
                                    catch (Exception e) {
                                        if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(servizioApplicativo)) break block117;
                                        throw e;
                                    }
                                }
                                this.configurazionePdDReader.aggiornaProprietaGestioneErrorePD(erroreAppl, sa);
                                InoltroBusteMessage inoltroMSG = new InoltroBusteMessage();
                                inoltroMSG.setRichiestaDelegata(richiestaDelegata);
                                inoltroMSG.setBusta(bustaToSend);
                                gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag, pddContext);
                                inoltroMSG.setPddContext(pddContext);
                                if ("db".equals(tipoNodeSender)) {
                                    gestoreMsg.ripristinaMessaggio();
                                    break block116;
                                }
                                try {
                                    String classTypeNodeSender = null;
                                    INodeSender nodeSender = null;
                                    try {
                                        classTypeNodeSender = ClassNameProperties.getInstance().getNodeSender(tipoNodeSender);
                                        nodeSender = (INodeSender)Loader.getInstance().newInstance(classTypeNodeSender);
                                        AbstractCore.init(nodeSender, pddContext, protocolFactory, new Object[0]);
                                    }
                                    catch (Exception e) {
                                        throw new EJBUtilsException("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage(), e);
                                    }
                                    nodeSender.send(inoltroMSG, "InoltroBuste", this.msgDiag, this.propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), "GestoreBusteNonRiscontrate", bustaToSend.getID(), gestoreMsg);
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "Asincrono GenericLib.nodeSender.send(InoltroBuste)");
                                    this.logTimer.error("Spedizione->InoltroBuste non riuscita", (Throwable)e);
                                    try {
                                        GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaBusteAsincroneToSend);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (openspcoopState != null) {
                                        openspcoopState.releaseResource();
                                    }
                                    return;
                                }
                            }
                            try {
                                if (this.logQuery) {
                                    this.logTimer.info("Gestita/Reinviata busta asincrona, la cui ricevuta non e' pervenuta, con ID [" + bustaToSend.getID() + "]");
                                }
                                ++gestiti;
                                continue;
                            }
                            catch (Exception e) {
                                msgErrore = "RespedizioneBustaAsincrona ErroreGenerale(" + idBustaDaRispedire + ")";
                                this.msgDiag.logErroreGenerico(e, msgErrore);
                                this.logTimer.error(msgErrore + ": " + e.getMessage(), (Throwable)e);
                            }
                        }
                        if (this.logQuery) {
                            this.logTimer.info("Gestite " + gestiti + " buste con profilo asincrono non riscontrate da rispedire");
                        }
                        cerca = true;
                        try {
                            GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, "Ricerca nuovo buste con profilo asincrono non riscontrate ...");
                        }
                        catch (Throwable e) {
                            this.msgDiag.logErroreGenerico(e, "RicercaNuoveBusteAsincroneNonRiscontrate-UpdateLock");
                            this.logTimer.error("ErroreRicercaNuoveBusteAsincroneNonRiscontrate-UpdateLock: " + e.getMessage(), e);
                            cerca = false;
                        }
                        if (cerca) {
                            busteAsincroneToSend = pBuste.asincrono_getBusteAsincronePerUlterioreInoltro(this.timeout, this.limit, offsetBusteAsincrone += busteAsincroneToSend.size(), this.logQuery);
                            continue;
                        }
                        busteAsincroneToSend = new ArrayList();
                    }
                }
                finally {
                    try {
                        GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaBusteAsincroneToSend);
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.logQuery) {
                this.logTimer.info("Gestione buste, con profilo asincrono, disabilitata");
            }
            long endControlloBusteNonRiscontrate = DateManager.getTimeMillis();
            long diff = endControlloBusteNonRiscontrate - startControlloBusteNonRiscontrate;
            this.logTimer.info("Controllo Buste in attesa di riscontro terminato in " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diff, (boolean)true));
        }
        catch (TimerLockNotAvailableException t) {
            this.logTimer.info(t.getMessage(), (Throwable)t);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneBusteNonRiscontrate");
            this.logTimer.error("Riscontrato errore durante la gestione delle buste non riscontrate: " + e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            if (openspcoopState != null) {
                openspcoopState.releaseResource();
            }
        }
    }
}

