/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.util.ArrayList;
import java.util.Date;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.GestoreCorrelazioneApplicativa;
import org.openspcoop2.pdd.core.GestoreCorrelazioneApplicativaConfig;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.JMSReceiver;
import org.openspcoop2.pdd.core.MessaggioServizioApplicativo;
import org.openspcoop2.pdd.core.connettori.RepositoryConnettori;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.transazioni.GestoreConsegnaMultipla;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerLock;
import org.openspcoop2.pdd.timers.TimerLockNotAvailableException;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.pdd.timers.TipoLock;
import org.openspcoop2.protocol.engine.driver.RollbackRepositoryBuste;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.semaphore.Semaphore;
import org.openspcoop2.utils.semaphore.SemaphoreConfiguration;
import org.openspcoop2.utils.semaphore.SemaphoreMapping;
import org.slf4j.Logger;

public class TimerGestoreMessaggiLib {
    private static TimerState STATE_MESSAGGI_ELIMINATI = TimerState.OFF;
    private static TimerState STATE_MESSAGGI_SCADUTI = TimerState.OFF;
    private static TimerState STATE_MESSAGGI_NON_GESTITI = TimerState.OFF;
    private static TimerState STATE_CORRELAZIONE_APPLICATIVA = TimerState.OFF;
    private static TimerState STATE_VERIFICA_CONNESSIONI_ATTIVE = TimerState.OFF;
    private MsgDiagnostico msgDiag = null;
    private Logger logTimer = null;
    private OpenSPCoop2Properties propertiesReader = null;
    private long scadenzaMessaggio = -1L;
    private boolean logQuery = false;
    private int limit = 50;
    private boolean orderByQuery;
    private long scadenzaCorrelazioneApplicativa;
    private boolean filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione;
    private boolean filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata;
    private TimerLock timerLock = null;
    private TimerLock timerLockCorrelazioneApplicativa = null;
    private Semaphore semaphore = null;
    private InfoStatistics semaphore_statistics;

    public static TimerState getSTATE_MESSAGGI_ELIMINATI() {
        return STATE_MESSAGGI_ELIMINATI;
    }

    public static void setSTATE_MESSAGGI_ELIMINATI(TimerState sTATE_MESSAGGI_ELIMINATI) {
        STATE_MESSAGGI_ELIMINATI = sTATE_MESSAGGI_ELIMINATI;
    }

    public static TimerState getSTATE_MESSAGGI_SCADUTI() {
        return STATE_MESSAGGI_SCADUTI;
    }

    public static void setSTATE_MESSAGGI_SCADUTI(TimerState sTATE_MESSAGGI_SCADUTI) {
        STATE_MESSAGGI_SCADUTI = sTATE_MESSAGGI_SCADUTI;
    }

    public static TimerState getSTATE_MESSAGGI_NON_GESTITI() {
        return STATE_MESSAGGI_NON_GESTITI;
    }

    public static void setSTATE_MESSAGGI_NON_GESTITI(TimerState sTATE_MESSAGGI_NON_GESTITI) {
        STATE_MESSAGGI_NON_GESTITI = sTATE_MESSAGGI_NON_GESTITI;
    }

    public static TimerState getSTATE_CORRELAZIONE_APPLICATIVA() {
        return STATE_CORRELAZIONE_APPLICATIVA;
    }

    public static void setSTATE_CORRELAZIONE_APPLICATIVA(TimerState sTATE_CORRELAZIONE_APPLICATIVA) {
        STATE_CORRELAZIONE_APPLICATIVA = sTATE_CORRELAZIONE_APPLICATIVA;
    }

    public static TimerState getSTATE_VERIFICA_CONNESSIONI_ATTIVE() {
        return STATE_VERIFICA_CONNESSIONI_ATTIVE;
    }

    public static void setSTATE_VERIFICA_CONNESSIONI_ATTIVE(TimerState sTATE_VERIFICA_CONNESSIONI_ATTIVE) {
        STATE_VERIFICA_CONNESSIONI_ATTIVE = sTATE_VERIFICA_CONNESSIONI_ATTIVE;
    }

    public TimerGestoreMessaggiLib(MsgDiagnostico msgDiag, Logger log, OpenSPCoop2Properties p, long scadenzaMessaggio, boolean logQuery, int limit, boolean orderByQuery, long scadenzaCorrelazioneApplicativa, boolean filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione, boolean filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata) throws TimerException {
        this.msgDiag = msgDiag;
        this.logTimer = log;
        this.propertiesReader = p;
        this.scadenzaMessaggio = scadenzaMessaggio;
        this.logQuery = logQuery;
        this.limit = limit;
        this.orderByQuery = orderByQuery;
        this.scadenzaCorrelazioneApplicativa = scadenzaCorrelazioneApplicativa;
        this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione = filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione;
        this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata = filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata;
        this.timerLock = this.propertiesReader.isMsgGiaInProcessamentoUseLock() ? new TimerLock(TipoLock._getLockGestioneRepositoryMessaggi()) : new TimerLock(TipoLock.GESTIONE_PULIZIA_REPOSITORY_MESSAGGI);
        this.timerLockCorrelazioneApplicativa = new TimerLock(TipoLock.GESTIONE_CORRELAZIONE_APPLICATIVA);
        if (this.propertiesReader.isTimerLockByDatabase()) {
            this.semaphore_statistics = new InfoStatistics();
            SemaphoreConfiguration config = GestoreMessaggi.newSemaphoreConfiguration(this.propertiesReader.getTimerGestoreMessaggiLockMaxLife(), this.propertiesReader.getTimerGestoreMessaggiLockIdleTime());
            TipiDatabase databaseType = TipiDatabase.toEnumConstant((String)this.propertiesReader.getDatabaseType());
            try {
                this.semaphore = new Semaphore(this.semaphore_statistics, SemaphoreMapping.newInstance((String)this.timerLock.getIdLock()), config, databaseType, this.logTimer);
            }
            catch (Exception e) {
                throw new TimerException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void check() throws TimerException {
        if (OpenSPCoop2Startup.contextDestroyed) {
            this.logTimer.error("[GestoreMessaggi] Rilevato sistema in shutdown");
            return;
        }
        if (!OpenSPCoop2Startup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            msgErrore = "Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata";
            this.logTimer.error(msgErrore);
            throw new TimerException(msgErrore);
        }
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            this.logTimer.error("[GestoreMessaggi] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), (Throwable)TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.logTimer.error("[GestoreMessaggi] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        if (!(TimerState.ENABLED.equals((Object)TimerGestoreMessaggiLib.STATE_MESSAGGI_ELIMINATI) || TimerState.ENABLED.equals((Object)TimerGestoreMessaggiLib.STATE_MESSAGGI_SCADUTI) || TimerState.ENABLED.equals((Object)TimerGestoreMessaggiLib.STATE_MESSAGGI_NON_GESTITI) || TimerState.ENABLED.equals((Object)TimerGestoreMessaggiLib.STATE_CORRELAZIONE_APPLICATIVA) || TimerState.ENABLED.equals((Object)TimerGestoreMessaggiLib.STATE_VERIFICA_CONNESSIONI_ATTIVE))) {
            this.msgDiag.logPersonalizzato("disabilitato");
            this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("disabilitato"));
            return;
        }
        this.msgDiag.logPersonalizzato("controlloInCorso");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("controlloInCorso"));
        startControlloRepositoryMessaggi = DateManager.getTimeMillis();
        gestoreMsg = null;
        rollbackMessaggio = null;
        rollbackRepository = null;
        openspcoopstate = new OpenSPCoopStateful();
        try {
            openspcoopstate.initResource(this.propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), "GestoreMessaggi", null);
            connectionDB = ((StateMessage)openspcoopstate.getStatoRichiesta()).getConnectionDB();
            receiverJMS = null;
            if ("jms".equals(this.propertiesReader.getNodeReceiver())) {
                receiverJMS = new JMSReceiver(this.propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), "ForcedDeleteMessage", this.propertiesReader.singleConnectionNodeReceiver(), this.logTimer, null);
            }
            gestoreMsgSearch = new GestoreMessaggi(openspcoopstate, true, this.logTimer, this.msgDiag, null);
            timeoutRicezioneContenutiApplicativiNonGestiti = this.propertiesReader.getNodeReceiverTimeoutRicezioneContenutiApplicativi() * 3L;
            timeoutRicezioneBusteNonGestiti = this.propertiesReader.getNodeReceiverTimeoutRicezioneBuste() * 3L;
            trovatiMessaggi = true;
            while (trovatiMessaggi) {
                trovatiMessaggi = false;
                now = null;
                if (!this.propertiesReader.isMsgGiaInProcessamentoUseLock()) {
                    now = DateManager.getDate();
                }
                idMsgInutiliINBOX = null;
                idMsgInutiliOUTBOX = null;
                if (TimerState.ENABLED.equals((Object)TimerGestoreMessaggiLib.STATE_MESSAGGI_ELIMINATI)) {
                    block234: {
                        causaMessaggiINBOXDaEliminareNonScaduti = "Eliminazione messaggi INBOX marcati logicamente da eliminare";
                        try {
                            GestoreMessaggi.acquireLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiINBOXDaEliminareNonScaduti, this.propertiesReader.getTimerGestoreMessaggi_getLockAttesaAttiva(), this.propertiesReader.getTimerGestoreMessaggi_getLockCheckInterval());
                            idMsgInutiliINBOX = gestoreMsgSearch.readMessaggiInutiliIntoInbox("GestoreMessaggi", this.limit, this.logQuery, this.orderByQuery, now);
                            gestiti = 0;
                            if (idMsgInutiliINBOX.size() > 0) {
                                if (this.logQuery) {
                                    this.logTimer.info("Trovati " + idMsgInutiliINBOX.size() + " messaggi (cancellazione logica) da eliminare nel repository (INBOX) ...");
                                }
                                trovatiMessaggi = true;
                                this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiCompletati");
                                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                                for (i = 0; i < idMsgInutiliINBOX.size(); ++i) {
                                    idMsgDaEliminare = idMsgInutiliINBOX.get(i);
                                    this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                                    try {
                                        try {
                                            GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, "Eliminazione messaggio INBOX con id [" + idMsgDaEliminare + "] ...");
                                        }
                                        catch (Throwable e) {
                                            this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioInbox(" + idMsgDaEliminare + ")-UpdateLock");
                                            this.logTimer.error("ErroreEliminazioneMessaggioInbox(" + idMsgDaEliminare + ")-UpdateLock: " + e.getMessage(), e);
                                            break;
                                        }
                                        gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "INBOX", this.msgDiag, null);
                                        if (this.propertiesReader.isMsgGiaInProcessamentoUseLock()) {
                                            gestoreMsg._deleteMessageWithoutLock();
                                        } else {
                                            gestoreMsg.deleteMessageByOraRegistrazione(now);
                                        }
                                        this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                                        if (this.logQuery) {
                                            this.logTimer.debug(this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                                        }
                                        ++gestiti;
                                        continue;
                                    }
                                    catch (Exception e) {
                                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioInbox(" + idMsgDaEliminare + ")");
                                        this.logTimer.error("ErroreEliminazioneMessaggioInbox(" + idMsgDaEliminare + "): " + e.getMessage(), (Throwable)e);
                                    }
                                }
                                if (this.logQuery) {
                                    this.logTimer.info("Eliminati " + gestiti + " messaggi (cancellazione logica) nel repository (INBOX)");
                                }
                                break block234;
                            }
                            if (this.logQuery) {
                                this.logTimer.info("Non sono stati trovati messaggi (cancellazione logica) da eliminare nel repository (INBOX)");
                            }
                        }
                        finally {
                            try {
                                GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiINBOXDaEliminareNonScaduti);
                            }
                            catch (Exception gestiti) {}
                        }
                    }
                    causaMessaggiOUTBOXDaEliminareNonScaduti = "Eliminazione messaggi OUTBOX marcati logicamente da eliminare";
                    try {
                        GestoreMessaggi.acquireLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiOUTBOXDaEliminareNonScaduti, this.propertiesReader.getTimerGestoreMessaggi_getLockAttesaAttiva(), this.propertiesReader.getTimerGestoreMessaggi_getLockCheckInterval());
                        idMsgInutiliOUTBOX = gestoreMsgSearch.readMessaggiInutiliIntoOutbox("GestoreMessaggi", this.limit, this.logQuery, this.orderByQuery, now);
                        gestiti = 0;
                        if (idMsgInutiliOUTBOX.size() > 0) {
                            if (this.logQuery) {
                                this.logTimer.info("Trovati " + idMsgInutiliOUTBOX.size() + " messaggi (cancellazione logica) da eliminare nel repository (OUTBOX) ...");
                            }
                            trovatiMessaggi = true;
                            this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiCompletati");
                            this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                            for (i = 0; i < idMsgInutiliOUTBOX.size(); ++i) {
                                idMsgDaEliminare = idMsgInutiliOUTBOX.get(i);
                                this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                                try {
                                    try {
                                        GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, "Eliminazione messaggio OUTBOX con id [" + idMsgDaEliminare + "] ...");
                                    }
                                    catch (Throwable e) {
                                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioOutbox(" + idMsgDaEliminare + ")-UpdateLock");
                                        this.logTimer.error("ErroreEliminazioneMessaggioOutbox(" + idMsgDaEliminare + ")-UpdateLock: " + e.getMessage(), e);
                                        break;
                                    }
                                    gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "OUTBOX", this.msgDiag, null);
                                    if (this.propertiesReader.isMsgGiaInProcessamentoUseLock()) {
                                        gestoreMsg._deleteMessageWithoutLock();
                                    } else {
                                        gestoreMsg.deleteMessageByOraRegistrazione(now);
                                    }
                                    this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                                    if (this.logQuery) {
                                        this.logTimer.debug(this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                                    }
                                    ++gestiti;
                                    continue;
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioOutbox(" + idMsgDaEliminare + ")");
                                    this.logTimer.error("ErroreEliminazioneMessaggioOutbox(" + idMsgDaEliminare + "): " + e.getMessage(), (Throwable)e);
                                }
                            }
                            if (!this.logQuery) ** GOTO lbl143
                            this.logTimer.info("Eliminati " + gestiti + " messaggi (cancellazione logica) nel repository (OUTBOX)");
                        }
                        if (!this.logQuery) ** GOTO lbl143
                        this.logTimer.info("Non sono stati trovati messaggi (cancellazione logica) da eliminare nel repository (OUTBOX)");
                    }
                    finally {
                        try {
                            GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiOUTBOXDaEliminareNonScaduti);
                        }
                        catch (Exception gestiti) {}
                    }
                } else if (this.logQuery) {
                    this.logTimer.info("Gestione messaggi (cancellazione logica) disabilitata");
                }
lbl143:
                // 7 sources

                idMsgScadutiINBOX = null;
                idMsgScadutiOUTBOX = null;
                if (TimerState.ENABLED.equals((Object)TimerGestoreMessaggiLib.STATE_MESSAGGI_SCADUTI)) {
                    block235: {
                        causaMessaggiINBOXScaduti = "Eliminazione messaggi INBOX scaduti";
                        try {
                            GestoreMessaggi.acquireLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiINBOXScaduti, this.propertiesReader.getTimerGestoreMessaggi_getLockAttesaAttiva(), this.propertiesReader.getTimerGestoreMessaggi_getLockCheckInterval());
                            idMsgScadutiINBOX = gestoreMsgSearch.readMessaggiScadutiIntoInbox(this.scadenzaMessaggio, this.limit, this.logQuery, this.orderByQuery, now);
                            gestiti = 0;
                            if (idMsgScadutiINBOX.size() > 0) {
                                if (this.logQuery) {
                                    this.logTimer.info("Trovati " + idMsgScadutiINBOX.size() + " messaggi (scaduti) da eliminare nel repository (INBOX) ...");
                                }
                                trovatiMessaggi = true;
                                this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiScaduti");
                                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                                for (i = 0; i < idMsgScadutiINBOX.size(); ++i) {
                                    idMsgDaEliminare = idMsgScadutiINBOX.get(i);
                                    this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                                    try {
                                        try {
                                            GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, "Eliminazione messaggio scaduto INBOX con id [" + idMsgDaEliminare + "] ...");
                                        }
                                        catch (Throwable e) {
                                            this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioScadutoInbox(" + idMsgDaEliminare + ")-UpdateLock");
                                            this.logTimer.error("ErroreEliminazioneMessaggioScadutoInbox(" + idMsgDaEliminare + ")-UpdateLock: " + e.getMessage(), e);
                                            break;
                                        }
                                        gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "INBOX", this.msgDiag, null);
                                        rollbackMessaggio = new RollbackRepositoryBuste(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                                        rollbackMessaggio.rollbackBustaIntoInBox();
                                        rifMsg = gestoreMsg.getRiferimentoMessaggio();
                                        if (rifMsg == null) {
                                            if (receiverJMS != null && receiverJMS.clean("RicezioneBuste", strMessageSelector = "ID = '" + idMsgDaEliminare + "'")) {
                                                this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneBuste");
                                                this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "false");
                                                this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                                            }
                                        } else {
                                            rollbackRepository = new RollbackRepositoryBuste(rifMsg, openspcoopstate.getStatoRichiesta(), true);
                                            rollbackRepository.rollbackBustaIntoOutBox(false);
                                            if (receiverJMS != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector = "ID = '" + rifMsg + "'")) {
                                                this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneContenutiApplicativi");
                                                this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "true");
                                                this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                                            }
                                        }
                                        try {
                                            listMsgServiziApplicativi = gestoreMsg.readInfoDestinatari(this.logQuery, this.logTimer);
                                            if (listMsgServiziApplicativi != null && !listMsgServiziApplicativi.isEmpty()) {
                                                for (MessaggioServizioApplicativo messaggioServizioApplicativo : listMsgServiziApplicativi) {
                                                    transazioneApplicativoServer = new TransazioneApplicativoServer();
                                                    transazioneApplicativoServer.setIdTransazione(messaggioServizioApplicativo.getIdTransazione());
                                                    transazioneApplicativoServer.setServizioApplicativoErogatore(messaggioServizioApplicativo.getServizioApplicativo());
                                                    transazioneApplicativoServer.setDataRegistrazione(messaggioServizioApplicativo.getOraRegistrazione());
                                                    transazioneApplicativoServer.setDataMessaggioScaduto(DateManager.getDate());
                                                    transazioneApplicativoServer.setProtocollo(this.propertiesReader.getDefaultProtocolName());
                                                    idPA = new IDPortaApplicativa();
                                                    idPA.setNome(messaggioServizioApplicativo.getNomePorta());
                                                    try {
                                                        GestoreConsegnaMultipla.getInstance().safeUpdateMessaggioScaduto(transazioneApplicativoServer, idPA, openspcoopstate);
                                                    }
                                                    catch (Throwable t) {
                                                        this.logTimer.error("[" + transazioneApplicativoServer.getIdTransazione() + "][" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "] Errore durante il salvataggio delle informazioni relative al servizio applicativo: " + t.getMessage(), t);
                                                    }
                                                }
                                            }
                                        }
                                        catch (Throwable t) {
                                            this.logTimer.error("Errore durante l'aggiornamento dello stato degli applicativi nelle transazioni: " + t.getMessage(), t);
                                        }
                                        ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                                        if (this.propertiesReader.isMsgGiaInProcessamentoUseLock()) {
                                            gestoreMsg._deleteMessageWithoutLock();
                                        } else {
                                            gestoreMsg.deleteMessageByOraRegistrazione(now);
                                        }
                                        this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                                        if (this.logQuery) {
                                            this.logTimer.debug(this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                                        }
                                        ++gestiti;
                                        continue;
                                    }
                                    catch (Exception e) {
                                        ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioScadutoInbox(" + idMsgDaEliminare + ")");
                                        this.logTimer.error("ErroreEliminazioneMessaggioScadutoInbox(" + idMsgDaEliminare + "): " + e.getMessage(), (Throwable)e);
                                    }
                                }
                                if (this.logQuery) {
                                    this.logTimer.info("Eliminati " + gestiti + " messaggi (scaduti) nel repository (INBOX)");
                                }
                                break block235;
                            }
                            if (this.logQuery) {
                                this.logTimer.info("Non sono stati trovati messaggi (scaduti) da eliminare nel repository (INBOX)");
                            }
                        }
                        finally {
                            try {
                                GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiINBOXScaduti);
                            }
                            catch (Exception gestiti) {}
                        }
                    }
                    causaMessaggiOUTBOXScaduti = "Eliminazione messaggi OUTBOX scaduti";
                    try {
                        GestoreMessaggi.acquireLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiOUTBOXScaduti, this.propertiesReader.getTimerGestoreMessaggi_getLockAttesaAttiva(), this.propertiesReader.getTimerGestoreMessaggi_getLockCheckInterval());
                        idMsgScadutiOUTBOX = gestoreMsgSearch.readMessaggiScadutiIntoOutbox(this.scadenzaMessaggio, this.limit, this.logQuery, this.orderByQuery, now);
                        gestiti = 0;
                        if (idMsgScadutiOUTBOX.size() > 0) {
                            if (this.logQuery) {
                                this.logTimer.info("Trovati " + idMsgScadutiOUTBOX.size() + " messaggi (scaduti) da eliminare nel repository (OUTBOX) ...");
                            }
                            trovatiMessaggi = true;
                            this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiScaduti");
                            this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                            for (i = 0; i < idMsgScadutiOUTBOX.size(); ++i) {
                                idMsgDaEliminare = idMsgScadutiOUTBOX.get(i);
                                this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                                try {
                                    try {
                                        GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, "Eliminazione messaggio scaduto OUTBOX con id [" + idMsgDaEliminare + "] ...");
                                    }
                                    catch (Throwable e) {
                                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioScadutoOutbox(" + idMsgDaEliminare + ")-UpdateLock");
                                        this.logTimer.error("ErroreEliminazioneMessaggioScadutoOutbox(" + idMsgDaEliminare + ")-UpdateLock: " + e.getMessage(), e);
                                        break;
                                    }
                                    gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "OUTBOX", this.msgDiag, null);
                                    rollbackMessaggio = new RollbackRepositoryBuste(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                                    rollbackMessaggio.rollbackBustaIntoOutBox();
                                    rifMsg = gestoreMsg.getRiferimentoMessaggio();
                                    if (rifMsg == null) {
                                        if (receiverJMS != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector = "ID = '" + idMsgDaEliminare + "'")) {
                                            this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneContenutiApplicativi");
                                            this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "false");
                                            this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                                        }
                                    } else {
                                        rollbackRepository = new RollbackRepositoryBuste(rifMsg, openspcoopstate.getStatoRichiesta(), true);
                                        rollbackRepository.rollbackBustaIntoInBox(false);
                                        if (receiverJMS != null && receiverJMS.clean("RicezioneBuste", strMessageSelector = "ID = '" + rifMsg + "'")) {
                                            this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneBuste");
                                            this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "true");
                                            this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                                        }
                                    }
                                    ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                                    if (this.propertiesReader.isMsgGiaInProcessamentoUseLock()) {
                                        gestoreMsg._deleteMessageWithoutLock();
                                    } else {
                                        gestoreMsg.deleteMessageByOraRegistrazione(now);
                                    }
                                    this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                                    if (this.logQuery) {
                                        this.logTimer.debug(this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                                    }
                                    ++gestiti;
                                    continue;
                                }
                                catch (Exception e) {
                                    ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                                    this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioScadutoOutbox(" + idMsgDaEliminare + ")");
                                    this.logTimer.error("ErroreEliminazioneMessaggioScadutoOutbox(" + idMsgDaEliminare + "): " + e.getMessage(), (Throwable)e);
                                }
                            }
                            if (!this.logQuery) ** GOTO lbl300
                            this.logTimer.info("Eliminati " + gestiti + " messaggi (scaduti) nel repository (OUTBOX)");
                        }
                        if (!this.logQuery) ** GOTO lbl300
                        this.logTimer.info("Non sono stati trovati messaggi (scaduti) da eliminare nel repository (OUTBOX)");
                    }
                    finally {
                        try {
                            GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiOUTBOXScaduti);
                        }
                        catch (Exception gestiti) {}
                    }
                } else if (this.logQuery) {
                    this.logTimer.info("Gestione messaggi (scaduti) disabilitata");
                }
lbl300:
                // 7 sources

                idMsgServizioRicezioneContenutiApplicativiNonGestiti = null;
                idMsgServizioRicezioneBusteNonGestiti = null;
                if (TimerState.ENABLED.equals((Object)TimerGestoreMessaggiLib.STATE_MESSAGGI_NON_GESTITI)) {
                    block236: {
                        causaMessaggiINBOXNonGestitiRicezioneContenutiApplicativi = "Eliminazione messaggi INBOX non gestiti dal servizio RicezioneContenutiApplicativi";
                        try {
                            GestoreMessaggi.acquireLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiINBOXNonGestitiRicezioneContenutiApplicativi, this.propertiesReader.getTimerGestoreMessaggi_getLockAttesaAttiva(), this.propertiesReader.getTimerGestoreMessaggi_getLockCheckInterval());
                            idMsgServizioRicezioneContenutiApplicativiNonGestiti = gestoreMsgSearch.readMsgForRicezioneContenutiApplicativiNonGestiti(timeoutRicezioneContenutiApplicativiNonGestiti, this.limit, this.logQuery, this.orderByQuery);
                            gestiti = 0;
                            if (idMsgServizioRicezioneContenutiApplicativiNonGestiti.size() > 0) {
                                if (this.logQuery) {
                                    this.logTimer.info("Trovati " + idMsgServizioRicezioneContenutiApplicativiNonGestiti.size() + " messaggi (non gestiti da 'RicezioneContenutiApplicativi') da eliminare nel repository (INBOX) ...");
                                }
                                trovatiMessaggi = true;
                                this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiNonGestitiRicezioneContenutiApplicativi");
                                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                                for (i = 0; i < idMsgServizioRicezioneContenutiApplicativiNonGestiti.size(); ++i) {
                                    idMsgDaEliminare = idMsgServizioRicezioneContenutiApplicativiNonGestiti.get(i);
                                    idBustaDaEliminare = idMsgDaEliminare.split("@")[0];
                                    servizioApplicativoDaEliminare = idMsgDaEliminare.split("@")[1];
                                    this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idBustaDaEliminare);
                                    try {
                                        try {
                                            GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, "Eliminazione messaggio INBOX non gestiti dal servizio RicezioneContenutiApplicativi con id [" + idMsgDaEliminare + "] ...");
                                        }
                                        catch (Throwable e) {
                                            this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioRicezioneContenutiApplicativiNonGestiti(" + idMsgDaEliminare + ")-UpdateLock");
                                            this.logTimer.error("ErroreEliminazioneMessaggioRicezioneContenutiApplicativiNonGestiti(" + idMsgDaEliminare + ")-UpdateLock: " + e.getMessage(), e);
                                            break;
                                        }
                                        gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idBustaDaEliminare, "INBOX", this.msgDiag, null);
                                        if (receiverJMS != null && (rifMsg = gestoreMsg.getRiferimentoMessaggio()) != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector = "ID = '" + rifMsg + "'")) {
                                            this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneContenutiApplicativi");
                                            this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "true");
                                            this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                                        }
                                        gestoreMsg.eliminaDestinatarioMessaggio(servizioApplicativoDaEliminare, gestoreMsg.getRiferimentoMessaggio());
                                        if (!gestoreMsg.existsServiziApplicativiDestinatariMessaggio()) {
                                            rollbackMessaggio = new RollbackRepositoryBuste(idBustaDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                                            rollbackMessaggio.rollbackBustaIntoInBox();
                                            ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                                        }
                                        this.msgDiag.logPersonalizzato("eliminazioneDestinatarioMessaggio");
                                        if (this.logQuery) {
                                            this.logTimer.debug(this.msgDiag.getMessaggio_replaceKeywords("eliminazioneDestinatarioMessaggio"));
                                        }
                                        ++gestiti;
                                        continue;
                                    }
                                    catch (Exception e) {
                                        if (rollbackMessaggio != null) {
                                            ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                                            rollbackMessaggio = null;
                                        }
                                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioRicezioneContenutiApplicativiNonGestiti(" + idMsgDaEliminare + ")");
                                        this.logTimer.error("ErroreEliminazioneMessaggioRicezioneContenutiApplicativiNonGestiti(" + idMsgDaEliminare + "): " + e.getMessage(), (Throwable)e);
                                    }
                                }
                                if (this.logQuery) {
                                    this.logTimer.info("Eliminati " + gestiti + " messaggi (non gestiti da 'RicezioneContenutiApplicativi') nel repository (INBOX)");
                                }
                                break block236;
                            }
                            if (this.logQuery) {
                                this.logTimer.info("Non sono stati trovati messaggi (non gestiti da 'RicezioneContenutiApplicativi') da eliminare nel repository (INBOX)");
                            }
                        }
                        finally {
                            try {
                                GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiINBOXNonGestitiRicezioneContenutiApplicativi);
                            }
                            catch (Exception gestiti) {}
                        }
                    }
                    causaMessaggiOUTBOXNonGestitiRicezioneBuste = "Eliminazione messaggi OUTBOX non gestiti dal servizio RicezioneBuste";
                    try {
                        GestoreMessaggi.acquireLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiOUTBOXNonGestitiRicezioneBuste, this.propertiesReader.getTimerGestoreMessaggi_getLockAttesaAttiva(), this.propertiesReader.getTimerGestoreMessaggi_getLockCheckInterval());
                        idMsgServizioRicezioneBusteNonGestiti = gestoreMsgSearch.readMsgForRicezioneBusteNonGestiti(timeoutRicezioneBusteNonGestiti, this.limit, this.logQuery, this.orderByQuery);
                        gestiti = 0;
                        if (idMsgServizioRicezioneBusteNonGestiti.size() > 0) {
                            if (this.logQuery) {
                                this.logTimer.info("Trovati " + idMsgServizioRicezioneBusteNonGestiti.size() + " messaggi (non gestiti da 'RicezioneBuste') da eliminare nel repository (OUTBOX) ...");
                            }
                            trovatiMessaggi = true;
                            this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiNonGestitiRicezioneBuste");
                            this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                            for (i = 0; i < idMsgServizioRicezioneBusteNonGestiti.size(); ++i) {
                                idMsgDaEliminare = idMsgServizioRicezioneBusteNonGestiti.get(i);
                                this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                                try {
                                    try {
                                        GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, "Eliminazione messaggio OUTBOX non gestiti dal servizio RicezioneBuste con id [" + idMsgDaEliminare + "] ...");
                                    }
                                    catch (Throwable e) {
                                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioRicezioneBusteNonGestiti(" + idMsgDaEliminare + ")-UpdateLock");
                                        this.logTimer.error("ErroreEliminazioneMessaggioRicezioneBusteNonGestiti(" + idMsgDaEliminare + ")-UpdateLock: " + e.getMessage(), e);
                                        break;
                                    }
                                    gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "OUTBOX", this.msgDiag, null);
                                    rollbackMessaggio = new RollbackRepositoryBuste(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                                    rollbackMessaggio.rollbackBustaIntoOutBox();
                                    ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                                    if (receiverJMS != null && (rifMsg = gestoreMsg.getRiferimentoMessaggio()) != null && receiverJMS.clean("RicezioneBuste", strMessageSelector = "ID = '" + rifMsg + "'")) {
                                        this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneBuste");
                                        this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "false");
                                        this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                                    }
                                    if (this.propertiesReader.isMsgGiaInProcessamentoUseLock()) {
                                        gestoreMsg._deleteMessageWithoutLock();
                                    } else {
                                        gestoreMsg.deleteMessageByOraRegistrazione(now);
                                    }
                                    this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                                    if (this.logQuery) {
                                        this.logTimer.debug(this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                                    }
                                    ++gestiti;
                                    continue;
                                }
                                catch (Exception e) {
                                    if (rollbackMessaggio != null) {
                                        ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                                        rollbackMessaggio = null;
                                    }
                                    this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioRicezioneBusteNonGestiti(" + idMsgDaEliminare + ")");
                                    this.logTimer.error("ErroreEliminazioneMessaggioRicezioneBusteNonGestiti(" + idMsgDaEliminare + "): " + e.getMessage(), (Throwable)e);
                                }
                            }
                            if (!this.logQuery) ** GOTO lbl422
                            this.logTimer.info("Eliminati " + gestiti + " messaggi (non gestiti da 'RicezioneBuste') nel repository (OUTBOX)");
                        }
                        if (!this.logQuery) ** GOTO lbl422
                        this.logTimer.info("Non sono stati trovati messaggi (non gestiti da 'RicezioneBuste') da eliminare nel repository (OUTBOX)");
                    }
                    finally {
                        try {
                            GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiOUTBOXNonGestitiRicezioneBuste);
                        }
                        catch (Exception gestiti) {}
                    }
                } else if (this.logQuery) {
                    this.logTimer.info("Gestione messaggi (non gestiti) disabilitata");
                }
lbl422:
                // 7 sources

                if (!trovatiMessaggi) continue;
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_COMPLETATI_INBOX@", (String)(idMsgInutiliINBOX != null ? "" + idMsgInutiliINBOX.size() : "0"));
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_COMPLETATI_OUTBOX@", (String)(idMsgInutiliOUTBOX != null ? "" + idMsgInutiliOUTBOX.size() : "0"));
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_SCADUTI_INBOX@", (String)(idMsgScadutiINBOX != null ? "" + idMsgScadutiINBOX.size() : "0"));
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_SCADUTI_OUTBOX@", (String)(idMsgScadutiOUTBOX != null ? "" + idMsgScadutiOUTBOX.size() : "0"));
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_NON_GESTITI_RICEZIONE_CONTENUTI_APPLICATIVI@", (String)(idMsgServizioRicezioneContenutiApplicativiNonGestiti != null ? "" + idMsgServizioRicezioneContenutiApplicativiNonGestiti.size() : "0"));
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_NON_GESTITI_RICEZIONE_BUSTE@", (String)(idMsgServizioRicezioneBusteNonGestiti != null ? "" + idMsgServizioRicezioneBusteNonGestiti.size() : "0"));
                this.msgDiag.logPersonalizzato("ricercaMessaggiDaEliminare");
            }
            if (TimerState.ENABLED.equals((Object)TimerGestoreMessaggiLib.STATE_CORRELAZIONE_APPLICATIVA)) {
                caConfig = new GestoreCorrelazioneApplicativaConfig();
                caConfig.setState(openspcoopstate.getStatoRichiesta());
                caConfig.setAlog(this.logTimer);
                gestoreCorrelazioneApplicativa = new GestoreCorrelazioneApplicativa(caConfig);
                causaCorrelazioniApplicativeScadute = "Eliminazione correlazioni applicative scadute";
                try {
                    GestoreMessaggi.acquireLock(this.semaphore, connectionDB, this.timerLockCorrelazioneApplicativa, this.msgDiag, causaCorrelazioniApplicativeScadute, this.propertiesReader.getGestioneSerializableDBAttesaAttiva(), this.propertiesReader.getGestioneSerializableDBCheckInterval());
                    correlazioniScadute = gestoreCorrelazioneApplicativa.getCorrelazioniScadute(this.limit, this.logQuery, this.orderByQuery);
                    this.msgDiag.addKeyword("@TIPO_RICERCA@", "CorrelazioniApplicative");
                    if (this.logQuery && correlazioniScadute.size() <= 0) {
                        this.logTimer.info("Non sono state trovate correlazioni applicative (scadute) da eliminare");
                    }
                    while (correlazioniScadute.size() > 0) {
                        if (this.logQuery) {
                            this.logTimer.info("Trovate " + correlazioniScadute.size() + " correlazioni applicative (scadute) da eliminare ...");
                        }
                        this.msgDiag.addKeyword("@NUMERO_CORRELAZIONI_APPLICATIVE@", "" + correlazioniScadute.size());
                        this.msgDiag.logPersonalizzato("ricercaCorrelazioniApplicativeScadute");
                        gestiti = 0;
                        while (correlazioniScadute.size() > 0) {
                            idCorrelazioneScaduta = correlazioniScadute.remove(0);
                            idCorrelato = null;
                            idApplicativo = null;
                            try {
                                id = gestoreCorrelazioneApplicativa.getIDMappingCorrelazioneApplicativa(idCorrelazioneScaduta);
                                idCorrelato = id[0];
                                idApplicativo = id[1];
                                try {
                                    GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLockCorrelazioneApplicativa, this.msgDiag, "Eliminazione correlazione applicativa scaduta (id_applicativo:" + idApplicativo + ",id_busta:" + idCorrelato + ") ...");
                                }
                                catch (Throwable e) {
                                    this.msgDiag.logErroreGenerico(e, "EliminazioneCorrelazioni(id_applicativo:" + idApplicativo + ",id_busta:" + idCorrelato + ")-UpdateLock");
                                    this.logTimer.error("ErroreEliminazioneCorrelazioni(id_applicativo:" + idApplicativo + ",id_busta:" + idCorrelato + ")-UpdateLock: " + e.getMessage(), e);
                                    break;
                                }
                                this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idCorrelato);
                                this.msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", idApplicativo);
                                gestoreCorrelazioneApplicativa.deleteCorrelazioneApplicativa(idCorrelazioneScaduta);
                                this.msgDiag.logPersonalizzato("eliminazioneCorrelazioneApplicativaScaduta");
                                if (this.logQuery) {
                                    this.logTimer.debug(this.msgDiag.getMessaggio_replaceKeywords("eliminazioneCorrelazioneApplicativaScaduta"));
                                }
                                ++gestiti;
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "EliminazioneCorrelazioni(id_applicativo:" + idApplicativo + ",id_busta:" + idCorrelato + ")");
                                this.logTimer.error("ErroreEliminazioneCorrelazioni(id_applicativo:" + idApplicativo + ",id_busta:" + idCorrelato + "): " + e.getMessage(), (Throwable)e);
                            }
                        }
                        if (this.logQuery) {
                            this.logTimer.info("Eliminate " + gestiti + " correlazioni applicative (scadute)");
                        }
                        cerca = true;
                        try {
                            GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLockCorrelazioneApplicativa, this.msgDiag, "Ricerca nuove correlazioni scadute  ...");
                        }
                        catch (Throwable e) {
                            this.msgDiag.logErroreGenerico(e, "RicercaNuoveCorrelazioni-UpdateLock");
                            this.logTimer.error("RicercaNuoveCorrelazioni-UpdateLock: " + e.getMessage(), e);
                            cerca = false;
                        }
                        if (cerca) {
                            correlazioniScadute = gestoreCorrelazioneApplicativa.getCorrelazioniScadute(this.limit, this.logQuery, this.orderByQuery);
                            continue;
                        }
                        correlazioniScadute = new ArrayList<Long>();
                    }
                }
                finally {
                    try {
                        GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLockCorrelazioneApplicativa, this.msgDiag, causaCorrelazioniApplicativeScadute);
                    }
                    catch (Exception gestiti) {}
                }
                if (this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione) {
                    causaCorrelazioniApplicativeScaduteRispettoOraRegistrazione = "Eliminazione correlazioni applicative scadute rispetto ora registrazione";
                    correlazioniScaduteRispettoOraRegistrazione = null;
                    try {
                        GestoreMessaggi.acquireLock(this.semaphore, connectionDB, this.timerLockCorrelazioneApplicativa, this.msgDiag, causaCorrelazioniApplicativeScaduteRispettoOraRegistrazione, this.propertiesReader.getGestioneSerializableDBAttesaAttiva(), this.propertiesReader.getGestioneSerializableDBCheckInterval());
                        correlazioniScaduteRispettoOraRegistrazione = gestoreCorrelazioneApplicativa.getCorrelazioniScaduteRispettoOraRegistrazione(this.limit, this.scadenzaCorrelazioneApplicativa, this.logQuery, this.orderByQuery, this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata);
                        if (this.logQuery && correlazioniScaduteRispettoOraRegistrazione.size() <= 0) {
                            this.logTimer.info("Non sono state trovate correlazioni applicative (scadute rispetto ora registrazione) da eliminare");
                        }
                        while (correlazioniScaduteRispettoOraRegistrazione.size() > 0) {
                            if (this.logQuery) {
                                this.logTimer.info("Trovate " + correlazioniScaduteRispettoOraRegistrazione.size() + " correlazioni applicative (scadute rispetto ora registrazione) da eliminare ...");
                            }
                            this.msgDiag.addKeyword("@NUMERO_CORRELAZIONI_APPLICATIVE@", "" + correlazioniScaduteRispettoOraRegistrazione.size());
                            this.msgDiag.logPersonalizzato("ricercaCorrelazioniApplicativeScaduteRispettoOraRegistrazione");
                            gestiti = 0;
                            while (correlazioniScaduteRispettoOraRegistrazione.size() > 0) {
                                idCorrelazioneScaduta = correlazioniScaduteRispettoOraRegistrazione.remove(0);
                                idCorrelato = null;
                                idApplicativo = null;
                                try {
                                    id = gestoreCorrelazioneApplicativa.getIDMappingCorrelazioneApplicativa(idCorrelazioneScaduta);
                                    idCorrelato = id[0];
                                    idApplicativo = id[1];
                                    try {
                                        GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLockCorrelazioneApplicativa, this.msgDiag, "Eliminazione correlazione applicativa scaduta rispetto ora registrazione (id_applicativo:" + idApplicativo + ",id_busta:" + idCorrelato + ") ...");
                                    }
                                    catch (Throwable e) {
                                        this.msgDiag.logErroreGenerico(e, "EliminazioneCorrelazioniRispettoOraRegistrazione(id_applicativo:" + idApplicativo + ",id_busta:" + idCorrelato + ")-UpdateLock");
                                        this.logTimer.error("ErroreEliminazioneCorrelazioniRispettoOraRegistrazione(id_applicativo:" + idApplicativo + ",id_busta:" + idCorrelato + ")-UpdateLock: " + e.getMessage(), e);
                                        break;
                                    }
                                    this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idCorrelato);
                                    this.msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", idApplicativo);
                                    gestoreCorrelazioneApplicativa.deleteCorrelazioneApplicativa(idCorrelazioneScaduta);
                                    this.msgDiag.logPersonalizzato("eliminazioneCorrelazioneApplicativaScaduta");
                                    if (this.logQuery) {
                                        this.logTimer.debug(this.msgDiag.getMessaggio_replaceKeywords("eliminazioneCorrelazioneApplicativaScaduta"));
                                    }
                                    ++gestiti;
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "EliminazioneCorrelazioniRispettoOraRegistrazione(id_applicativo:" + idApplicativo + ",id_busta:" + idCorrelato + ")");
                                    this.logTimer.error("ErroreEliminazioneCorrelazioniRispettoOraRegistrazione(id_applicativo:" + idApplicativo + ",id_busta:" + idCorrelato + "): " + e.getMessage(), (Throwable)e);
                                }
                            }
                            if (this.logQuery) {
                                this.logTimer.info("Eliminate " + gestiti + " correlazioni applicative (scadute rispetto ora registrazione)");
                            }
                            cerca = true;
                            try {
                                GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLockCorrelazioneApplicativa, this.msgDiag, "Ricerca nuove correlazioni scadute rispetto ora registrazione ...");
                            }
                            catch (Throwable e) {
                                this.msgDiag.logErroreGenerico(e, "RicercaNuoveCorrelazioni-UpdateLock");
                                this.logTimer.error("RicercaNuoveCorrelazioni-UpdateLock: " + e.getMessage(), e);
                                cerca = false;
                            }
                            if (cerca) {
                                correlazioniScaduteRispettoOraRegistrazione = gestoreCorrelazioneApplicativa.getCorrelazioniScaduteRispettoOraRegistrazione(this.limit, this.scadenzaCorrelazioneApplicativa, this.logQuery, this.orderByQuery, this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata);
                                continue;
                            }
                            correlazioniScaduteRispettoOraRegistrazione = new ArrayList<Long>();
                        }
                    }
                    finally {
                        try {
                            GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLockCorrelazioneApplicativa, this.msgDiag, causaCorrelazioniApplicativeScaduteRispettoOraRegistrazione);
                        }
                        catch (Exception var21_60) {}
                    }
                }
            } else if (this.logQuery) {
                this.logTimer.info("Gestione correlazione applicativa disabilitata");
            }
            endControlloRepositoryMessaggi = DateManager.getTimeMillis();
            diff = endControlloRepositoryMessaggi - startControlloRepositoryMessaggi;
            this.logTimer.info("Controllo Repository Messaggi terminato in " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diff, (boolean)true));
        }
        catch (TimerLockNotAvailableException t) {
            this.logTimer.info(t.getMessage(), (Throwable)t);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneMessaggi");
            this.logTimer.error("Riscontrato errore durante la gestione del repository dei messaggi: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (openspcoopstate != null) {
                openspcoopstate.releaseResource();
            }
        }
        try {
            if (TimerState.ENABLED.equals((Object)TimerGestoreMessaggiLib.STATE_VERIFICA_CONNESSIONI_ATTIVE)) {
                startControlloRepositoryMessaggi = DateManager.getTimeMillis();
                this.logTimer.info("Verifico connessioni attive...");
                identificatoriConnettoriPD = RepositoryConnettori.getIdentificatoriConnettori_pd();
                if (this.logQuery && (identificatoriConnettoriPD == null || identificatoriConnettoriPD.isEmpty())) {
                    this.logTimer.info("Non sono state trovate connessioni attive sulle PorteDelegate");
                }
                if (identificatoriConnettoriPD != null) {
                    verificaEffettuata = false;
                    if (this.logQuery && !identificatoriConnettoriPD.isEmpty()) {
                        this.logTimer.info("Sono state trovate connessioni attive sulle PorteDelegate, verifica in corso ...");
                    }
                    for (String identificatoreConnessione : identificatoriConnettoriPD) {
                        verificaEffettuata = true;
                        tipoConnettore = null;
                        connettore = null;
                        try {
                            connettore = RepositoryConnettori.getConnettorePD(identificatoreConnessione);
                            if (connettore != null) {
                                tipoConnettore = connettore.getClass().getSimpleName();
                            }
                            millisecondiScadenza = this.propertiesReader.getConnectionLife_inoltroBuste();
                            now = DateManager.getDate();
                            scadenza = new Date(now.getTime() - (long)millisecondiScadenza);
                            tipoConnessione = "tipo:" + tipoConnettore + " porta:delegata id_busta:" + identificatoreConnessione;
                            this.logTimer.debug("--------------------------------------");
                            this.logTimer.debug(tipoConnessione);
                            this.logTimer.debug("SCADENZA [" + scadenza.toString() + "]   CONNETTORE [" + (connettore != null && connettore.getCreationDate() != null ? connettore.getCreationDate().toString() : null) + "]");
                            if (connettore != null && connettore.getCreationDate() != null && connettore.getCreationDate().before(scadenza)) {
                                this.logTimer.info("SCADUTO");
                                this.msgDiag.addKeyword("@TIPO_CONNESSIONE@", tipoConnessione);
                                this.msgDiag.addKeyword("@DATA_CREAZIONE_CONNESSIONE@", connettore.getCreationDate().toString());
                                this.msgDiag.logPersonalizzato("connessioneScaduta.EliminazioneInCorso");
                                connettore = RepositoryConnettori.removeConnettorePD(identificatoreConnessione);
                                if (connettore != null) {
                                    connettore.disconnect();
                                }
                                this.msgDiag.logPersonalizzato("connessioneScaduta.EliminazioneEffettuata");
                            } else if (connettore == null) {
                                this.logTimer.debug("NON PIU' PRESENTE");
                            } else if (connettore.getCreationDate() == null) {
                                this.logTimer.debug("SENZA DATA DI CREAZIONE");
                            } else {
                                this.logTimer.debug("NON SCADUTO");
                            }
                            this.logTimer.debug("--------------------------------------");
                        }
                        catch (Exception e) {
                            if (tipoConnettore != null) {
                                msgErrore = "EliminazioneConnessione(tipo:" + tipoConnettore + " porta:delegata id_busta:" + identificatoreConnessione + ")";
                                this.msgDiag.logErroreGenerico(e, msgErrore);
                                this.logTimer.error("Errore" + (String)msgErrore + ": " + e.getMessage(), (Throwable)e);
                                continue;
                            }
                            msgErrore = "EliminazioneConnessione(porta:delegata id_busta:" + identificatoreConnessione + ")";
                            this.msgDiag.logErroreGenerico(e, msgErrore);
                            this.logTimer.error("Errore" + msgErrore + ": " + e.getMessage(), (Throwable)e);
                        }
                        catch (Throwable e) {
                            if (tipoConnettore != null) {
                                msgErrore = "EliminazioneConnessione(tipo:" + tipoConnettore + " porta:delegata id_busta:" + identificatoreConnessione + ")";
                                this.msgDiag.logErroreGenerico(e, msgErrore);
                                this.logTimer.error("Errore" + msgErrore + ": " + e.getMessage(), e);
                                continue;
                            }
                            msgErrore = "EliminazioneConnessione(porta:delegata id_busta:" + identificatoreConnessione + ")";
                            this.msgDiag.logErroreGenerico(e, msgErrore);
                            this.logTimer.error("Errore" + msgErrore + ": " + e.getMessage(), e);
                        }
                    }
                    if (this.logQuery && verificaEffettuata) {
                        this.logTimer.info("Terminata verifica connessioni attive sulle PorteDelegate");
                    }
                }
                identificatoriConnettoriPA = RepositoryConnettori.getIdentificatoriConnettori_pa();
                if (this.logQuery && (identificatoriConnettoriPA == null || !identificatoriConnettoriPA.isEmpty())) {
                    this.logTimer.info("Non sono state trovate connessioni attive sulle PorteApplicative");
                }
                if (identificatoriConnettoriPA != null) {
                    verificaEffettuata = false;
                    if (this.logQuery && !identificatoriConnettoriPA.isEmpty()) {
                        this.logTimer.info("Sono state trovate connessioni attive sulle PorteApplicative, verifica in corso ...");
                    }
                    for (String identificatoreConnessione : identificatoriConnettoriPA) {
                        verificaEffettuata = true;
                        tipoConnettore = null;
                        connettore = null;
                        try {
                            connettore = RepositoryConnettori.getConnettorePA(identificatoreConnessione);
                            if (connettore != null) {
                                tipoConnettore = connettore.getClass().getSimpleName();
                            }
                            millisecondiScadenza = this.propertiesReader.getConnectionLife_consegnaContenutiApplicativi();
                            now = DateManager.getDate();
                            scadenza = new Date(now.getTime() - (long)millisecondiScadenza);
                            tipoConnessione = "tipo:" + tipoConnettore + " porta:applicativa id_busta:" + identificatoreConnessione;
                            this.logTimer.debug("--------------------------------------");
                            this.logTimer.debug(tipoConnessione);
                            this.logTimer.debug("SCADENZA [" + scadenza.toString() + "]   CONNETTORE [" + (connettore != null && connettore.getCreationDate() != null ? connettore.getCreationDate().toString() : null) + "]");
                            if (connettore != null && connettore.getCreationDate() != null && connettore.getCreationDate().before(scadenza)) {
                                this.logTimer.info("SCADUTO");
                                this.msgDiag.addKeyword("@TIPO_CONNESSIONE@", tipoConnessione);
                                this.msgDiag.addKeyword("@DATA_CREAZIONE_CONNESSIONE@", connettore.getCreationDate().toString());
                                this.msgDiag.logPersonalizzato("connessioneScaduta.EliminazioneInCorso");
                                connettore = RepositoryConnettori.removeConnettorePA(identificatoreConnessione);
                                if (connettore != null) {
                                    connettore.disconnect();
                                }
                                this.msgDiag.logPersonalizzato("connessioneScaduta.EliminazioneEffettuata");
                            } else if (connettore == null) {
                                this.logTimer.debug("NON PIU' PRESENTE");
                            } else if (connettore.getCreationDate() == null) {
                                this.logTimer.debug("SENZA DATA DI CREAZIONE");
                            } else {
                                this.logTimer.debug("NON SCADUTO");
                            }
                            this.logTimer.debug("--------------------------------------");
                        }
                        catch (Exception e) {
                            if (tipoConnettore != null) {
                                msgErrore = "EliminazioneConnessione(tipo:" + tipoConnettore + " porta:applicativa id_busta:" + identificatoreConnessione + ")";
                                this.msgDiag.logErroreGenerico(e, msgErrore);
                                this.logTimer.error("Errore" + (String)msgErrore + ": " + e.getMessage(), (Throwable)e);
                                continue;
                            }
                            msgErrore = "EliminazioneConnessione(porta:applicativa id_busta:" + identificatoreConnessione + ")";
                            this.msgDiag.logErroreGenerico(e, msgErrore);
                            this.logTimer.error("Errore" + msgErrore + ": " + e.getMessage(), (Throwable)e);
                        }
                        catch (Throwable e) {
                            if (tipoConnettore != null) {
                                msgErrore = "EliminazioneConnessione(tipo:" + tipoConnettore + " porta:applicativa id_busta:" + identificatoreConnessione + ")";
                                this.msgDiag.logErroreGenerico(e, msgErrore);
                                this.logTimer.error("Errore" + msgErrore + ": " + e.getMessage(), e);
                                continue;
                            }
                            msgErrore = "EliminazioneConnessione(porta:applicativa id_busta:" + identificatoreConnessione + ")";
                            this.msgDiag.logErroreGenerico(e, msgErrore);
                            this.logTimer.error("Errore" + msgErrore + ": " + e.getMessage(), e);
                        }
                    }
                    if (this.logQuery && verificaEffettuata) {
                        this.logTimer.info("Terminata verifica connessioni attive sulle PorteApplicative");
                    }
                }
                endControlloRepositoryMessaggi = DateManager.getTimeMillis();
                diff = endControlloRepositoryMessaggi - startControlloRepositoryMessaggi;
                this.logTimer.info("Terminata verifica connessioni attive in " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diff, (boolean)true));
            } else {
                this.logTimer.warn("Non verifico connessioni attive");
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneMessaggi");
            this.logTimer.error("Riscontrato errore durante la gestione del repository dei messaggi: " + e.getMessage(), (Throwable)e);
        }
    }
}

