/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.io.Serializable;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerGestorePuliziaMessaggiAnomaliLib;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class TimerGestorePuliziaMessaggiAnomaliImpl
implements SessionBean,
TimedObject {
    private static final long serialVersionUID = 1L;
    private SessionContext sessionContext;
    private Timer timer;
    private long timeout = 10L;
    private OpenSPCoop2Properties propertiesReader;
    private MsgDiagnostico msgDiag;
    private Logger logTimer = null;
    private boolean deployFromOpenSPCoop = false;
    private boolean gestioneAttiva = false;
    private boolean logQuery = false;
    private int limit = 50;
    private boolean orderByQuery = false;
    private static Semaphore SEMAPHORE = new Semaphore("GestoreConsistenzaDatabase");
    private static Boolean LOCK = false;

    public void ejbCreate() throws CreateException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoop2Startup.initialize && secondi < attesa; ++secondi) {
            Utilities.sleep((long)1000L);
        }
        if (secondi >= 90) {
            throw new CreateException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.logTimer = OpenSPCoop2Logger.getLoggerOpenSPCoopTimers();
        try {
            this.msgDiag = MsgDiagnostico.newInstance("GestoreConsistenzaDatabase");
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreMessaggiInconsistenti.");
            this.msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI_INCONSISTENTI@", "GestoreConsistenzaDatabase");
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato Errore durante l'inizializzazione del MsgDiagnostico: " + e.getMessage();
            this.logTimer.error(msgErrore, (Throwable)e);
            throw new CreateException(msgErrore);
        }
        try {
            this.propertiesReader = OpenSPCoop2Properties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneProperties");
            String msgErrore = "Riscontrato errore durante l'inizializzazione del Reader delle Properties di OpenSPCoop: " + e.getMessage();
            this.logTimer.error(msgErrore, (Throwable)e);
            throw new CreateException(msgErrore);
        }
        this.timeout = this.propertiesReader.getRepositoryIntervalloEliminazioneMessaggi();
        String s = "secondi";
        if (this.timeout == 1L) {
            s = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.timeout + " " + s);
        this.logQuery = this.propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitatoLog();
        this.orderByQuery = this.propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitatoOrderBy();
        this.limit = this.propertiesReader.getTimerGestorePuliziaMessaggiAnomaliLimit();
        if (this.limit <= 0) {
            this.limit = 50;
        }
        this.msgDiag.addKeyword("@LIMIT@", "" + this.limit);
    }

    public void ejbRemove() throws EJBException {
    }

    public void ejbActivate() throws EJBException {
    }

    public void ejbPassivate() throws EJBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbTimeout(Timer timer) throws EJBException {
        SemaphoreLock lock;
        if (!this.propertiesReader.isServerJ2EE().booleanValue()) {
            this.stop(timer);
            return;
        }
        if (!this.deployFromOpenSPCoop) {
            if (this.propertiesReader.isTimerAutoStart_StopTimer()) {
                this.stop(timer);
                return;
            }
            lock = SEMAPHORE.acquireThrowRuntime("ejbTimeout");
            try {
                if (LOCK.booleanValue()) {
                    this.msgDiag.logPersonalizzato("precedenteEsecuzioneInCorso.stopTimer");
                    this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("precedenteEsecuzioneInCorso.stopTimer"));
                    this.stop(timer);
                    return;
                }
                LOCK = true;
                for (int i = 0; i < 10; ++i) {
                    Utilities.sleep((long)500L);
                }
            }
            finally {
                SEMAPHORE.release(lock, "ejbTimeout");
            }
        }
        try {
            String msgErrore;
            if (!this.propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitato()) {
                this.msgDiag.logPersonalizzato("disabilitato");
                this.logTimer.warn(this.msgDiag.getMessaggio_replaceKeywords("disabilitato"));
                this.stop(timer);
                return;
            }
            if (timer == null) {
                msgErrore = "inizializzazione del Timer non effettuata";
                this.msgDiag.logFatalError(msgErrore, "Check inizializzazione");
                this.logTimer.error(msgErrore);
                this.stop(timer);
                return;
            }
            if (!OpenSPCoop2Startup.initialize) {
                msgErrore = "inizializzazione di OpenSPCoop non effettuata";
                this.msgDiag.logFatalError(msgErrore, "Check inizializzazione");
                this.logTimer.error(msgErrore);
                this.stop(timer);
                return;
            }
            if (this.gestioneAttiva) {
                this.msgDiag.logPersonalizzato("precedenteEsecuzioneInCorso");
                this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("precedenteEsecuzioneInCorso"));
                return;
            }
            try {
                this.gestioneAttiva = true;
                TimerGestorePuliziaMessaggiAnomaliLib gestoreMessaggiLib = new TimerGestorePuliziaMessaggiAnomaliLib(this.msgDiag, this.logTimer, this.propertiesReader, this.logQuery, this.limit, this.orderByQuery);
                gestoreMessaggiLib.check();
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "GestorePuliziaMessaggiTimerEJB");
                this.logTimer.error("Errore generale: " + e.getMessage(), (Throwable)e);
            }
            finally {
                this.gestioneAttiva = false;
            }
        }
        finally {
            lock = SEMAPHORE.acquireThrowRuntime("ejbTimeoutCheck2");
            try {
                LOCK = false;
            }
            finally {
                SEMAPHORE.release(lock, "ejbTimeoutCheck2");
            }
        }
    }

    public void setSessionContext(SessionContext aContext) throws EJBException {
        this.sessionContext = aContext;
    }

    public boolean start() throws EJBException {
        if (this.timer != null) {
            this.msgDiag.logPersonalizzato("timerGiaAvviato");
            this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("timerGiaAvviato"));
            return false;
        }
        if (this.propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitato()) {
            this.deployFromOpenSPCoop = true;
            this.msgDiag.logPersonalizzato("avvioInCorso");
            this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioInCorso"));
            Utilities.sleep((long)1000L);
            Date now = DateManager.getDate();
            long timeout = 1000L * this.timeout;
            try {
                TimerService ts = this.sessionContext.getTimerService();
                this.timer = ts.createTimer(now, timeout, (Serializable)((Object)"GestoreConsistenzaDatabase"));
                this.msgDiag.logPersonalizzato("avvioEffettuato");
                this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioEffettuato"));
            }
            catch (Exception e) {
                this.stop();
                this.msgDiag.logFatalError(e, "Creazione timer EJB gestore della pulizia dei messaggi non consistenti");
                this.logTimer.error("Errore durante la creazione del timer: " + e.getMessage(), (Throwable)e);
            }
            return this.timer != null;
        }
        this.msgDiag.logPersonalizzato("disabilitato");
        this.logTimer.warn(this.msgDiag.getMessaggio_replaceKeywords("disabilitato"));
        return false;
    }

    public boolean isStarted() throws EJBException {
        return this.timer != null;
    }

    public void stop(Timer atimer) throws EJBException {
        if (atimer != null) {
            atimer.cancel();
        }
    }

    public void stop() throws EJBException {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

