/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.HazelcastManager;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerHazelcastOrphanedProxiesCleanup
extends BaseThread {
    private Logger log = null;

    public TimerHazelcastOrphanedProxiesCleanup(Logger log) {
        this.log = log;
    }

    protected void process() {
        try {
            this.log.debug("Cleanup Hazelcast orphaned proxies ...");
            Long thresholdMs = OpenSPCoop2Properties.getInstance().getControlloTrafficoGestorePolicyInMemoryHazelcastOrphanedProxyThresholdMs();
            int removedProxies = HazelcastManager.cleanupOrphanedProxies(thresholdMs);
            if (removedProxies > 0) {
                String msg = "Cleanup Hazelcast orphaned proxies finished: removed " + removedProxies + " proxies";
                this.log.info(msg);
            } else {
                this.log.debug("Cleanup Hazelcast orphaned proxies finished: no proxies removed");
            }
        }
        catch (Throwable e) {
            this.log.error("Errore durante cleanup Hazelcast orphaned proxies: " + e.getMessage(), e);
        }
    }
}

