/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import org.openspcoop2.core.statistiche.constants.TipoIntervalloStatistico;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerStatisticheLib;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerStatisticheThread
extends BaseThread {
    public static final String ID_MODULO = "TimerStatistiche";
    private TipoIntervalloStatistico tipoStatistica;
    private Logger logTimer = null;
    private MsgDiagnostico msgDiag = null;
    private OpenSPCoop2Properties op2Properties = null;

    private void logError(String msgErrore, Exception e) {
        if (this.logTimer != null) {
            this.logTimer.error(msgErrore, (Throwable)e);
        }
    }

    public TimerStatisticheThread(long timeout, TipoIntervalloStatistico tipo) throws TimerException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoop2Startup.initialize && secondi < attesa; ++secondi) {
            Utilities.sleep((long)1000L);
        }
        if (secondi >= 90) {
            throw new TimerException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.logTimer = OpenSPCoop2Logger.getLoggerOpenSPCoopTimers();
        try {
            this.msgDiag = MsgDiagnostico.newInstance(ID_MODULO);
            this.msgDiag.setPrefixMsgPersonalizzati("timerStatistiche.");
            this.msgDiag.addKeyword("@ID_TIMER@", "Timer" + tipo.getValue());
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato Errore durante l'inizializzazione del MsgDiagnostico";
            this.logError(msgErrore, e);
            throw new TimerException(msgErrore, e);
        }
        this.msgDiag.logPersonalizzato("avvioInCorso");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioInCorso"));
        try {
            this.op2Properties = OpenSPCoop2Properties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            String msgErrore = "Riscontrato errore durante l'inizializzazione del Reader delle Properties di OpenSPCoop: " + e.getMessage();
            this.logError(msgErrore, e);
            throw new TimerException(msgErrore, e);
        }
        this.tipoStatistica = tipo;
        this.setTimeout((int)timeout);
        String sec = "secondi";
        if (this.getTimeout() == 1) {
            sec = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.getTimeout() + " " + sec);
        this.msgDiag.logPersonalizzato("avvioEffettuato");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioEffettuato"));
    }

    public void process() {
        try {
            TimerStatisticheLib timerStatistiche = new TimerStatisticheLib(this.tipoStatistica, this.msgDiag, this.logTimer, this.op2Properties);
            timerStatistiche.check();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerStatisticheLib.check()");
            this.logError("Errore generale: " + e.getMessage(), e);
        }
    }
}

