/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import org.openspcoop2.message.ForcedResponseMessage;
import org.openspcoop2.message.ForwardConfig;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageProperties;
import org.openspcoop2.message.OpenSPCoop2RestBinaryMessage;
import org.openspcoop2.message.OpenSPCoop2RestJsonMessage;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.OpenSPCoop2RestMimeMultipartMessage;
import org.openspcoop2.message.OpenSPCoop2RestXmlMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.context.ContentLength;
import org.openspcoop2.message.context.ContentTypeParameters;
import org.openspcoop2.message.context.Credentials;
import org.openspcoop2.message.context.ForcedResponse;
import org.openspcoop2.message.context.HeaderParameters;
import org.openspcoop2.message.context.MessageContext;
import org.openspcoop2.message.context.SerializedContext;
import org.openspcoop2.message.context.SerializedParameter;
import org.openspcoop2.message.context.StringParameter;
import org.openspcoop2.message.context.TransportRequestContext;
import org.openspcoop2.message.context.TransportResponseContext;
import org.openspcoop2.message.context.UrlParameters;
import org.openspcoop2.message.context.utils.serializer.JaxbDeserializer;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.message.exception.ParseExceptionUtils;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.message.utils.TransportUtilities;
import org.openspcoop2.message.xml.MessageDynamicNamespaceContextFactory;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.beans.BaseBeanWithId;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.io.notifier.NotifierInputStream;
import org.openspcoop2.utils.serialization.JavaDeserializer;
import org.openspcoop2.utils.serialization.JavaSerializer;
import org.openspcoop2.utils.transport.Credential;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.w3c.dom.Node;

public abstract class AbstractBaseOpenSPCoop2Message
implements OpenSPCoop2Message {
    protected OpenSPCoop2MessageFactory messageFactory;
    public org.openspcoop2.utils.transport.TransportRequestContext transportRequestContext;
    public org.openspcoop2.utils.transport.TransportResponseContext transportResponseContext;
    public Map<String, List<String>> forceTransportHeaders = new HashMap<String, List<String>>();
    public Map<String, List<String>> forceUrlProperties = new HashMap<String, List<String>>();
    public OpenSPCoop2MessageProperties forwardTransportHeader = new OpenSPCoop2MessageProperties();
    public OpenSPCoop2MessageProperties forwardUrlProperties = new OpenSPCoop2MessageProperties();
    public String forcedResponseCode;
    public boolean forcedEmptyResponse;
    public ForcedResponseMessage forcedResponse;
    public org.openspcoop2.utils.Map<Object> context = new org.openspcoop2.utils.Map();
    private String transactionId;
    public Map<String, String> contentTypeParamaters = new HashMap<String, String>();
    public MessageType messageType;
    public MessageRole messageRole;
    public long outgoingsize = -1L;
    public long incomingsize = -1L;
    public Long incomingSizeForced = null;
    public ParseException parseException;
    public String protocolName;
    public NotifierInputStream notifierInputStream;
    private static boolean normalizeNamespaceXSITypeDefault = false;
    private boolean normalizeNamespaceXSIType = false;

    public static boolean isNormalizeNamespaceXSITypeDefault() {
        return normalizeNamespaceXSITypeDefault;
    }

    public static void setNormalizeNamespaceXSITypeDefault(boolean normalizeNamespaceXSITypeDefault) {
        AbstractBaseOpenSPCoop2Message.normalizeNamespaceXSITypeDefault = normalizeNamespaceXSITypeDefault;
    }

    public boolean isNormalizeNamespaceXSIType() {
        return this.normalizeNamespaceXSIType;
    }

    public void setNormalizeNamespaceXSIType(boolean normalizeNamespaceXSIType) {
        this.normalizeNamespaceXSIType = normalizeNamespaceXSIType;
    }

    protected AbstractBaseOpenSPCoop2Message(OpenSPCoop2MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
        this.normalizeNamespaceXSIType = AbstractBaseOpenSPCoop2Message.isNormalizeNamespaceXSITypeDefault();
    }

    @Override
    public OpenSPCoop2MessageFactory getFactory() {
        return this.messageFactory;
    }

    @Override
    public OpenSPCoop2Message normalizeToSaajImpl() throws MessageException {
        return this;
    }

    @Override
    public void copyResourcesTo(OpenSPCoop2Message newInstance) throws MessageException {
        this.copyResourcesTo(newInstance, false);
    }

    @Override
    public void copyResourcesTo(OpenSPCoop2Message newInstance, boolean skipTransportInfo) throws MessageException {
        if (this.parseException != null) {
            throw new MessageException(this.getParseException().getSourceException());
        }
        if (newInstance instanceof AbstractBaseOpenSPCoop2Message) {
            AbstractBaseOpenSPCoop2Message base = (AbstractBaseOpenSPCoop2Message)newInstance;
            if (!skipTransportInfo) {
                base.transportRequestContext = this.transportRequestContext;
                base.transportResponseContext = this.transportResponseContext;
                base.forceTransportHeaders = this.forceTransportHeaders;
                base.forceUrlProperties = this.forceUrlProperties;
                base.forwardTransportHeader = this.forwardTransportHeader;
                base.forwardUrlProperties = this.forwardUrlProperties;
                base.forcedResponseCode = this.forcedResponseCode;
                base.forcedEmptyResponse = this.forcedEmptyResponse;
                base.forcedResponse = this.forcedResponse;
            }
            base.context = this.context;
            base.transactionId = this.transactionId;
            base.messageRole = this.messageRole;
            if (!skipTransportInfo) {
                base.incomingsize = this.incomingsize;
                base.incomingSizeForced = this.incomingSizeForced;
            }
            base.protocolName = this.protocolName;
        } else {
            if (!skipTransportInfo) {
                List<String> values;
                newInstance.setTransportRequestContext(this.transportRequestContext);
                newInstance.setTransportResponseContext(this.transportResponseContext);
                if (this.forceTransportHeaders != null && !this.forceTransportHeaders.isEmpty()) {
                    for (String key : this.forceTransportHeaders.keySet()) {
                        values = this.forceTransportHeaders.get(key);
                        newInstance.forceTransportHeader(key, values);
                    }
                }
                if (this.forceUrlProperties != null && !this.forceUrlProperties.isEmpty()) {
                    for (String key : this.forceUrlProperties.keySet()) {
                        values = this.forceUrlProperties.get(key);
                        newInstance.forceUrlProperty(key, values);
                    }
                }
                newInstance.setForcedResponseCode(this.forcedResponseCode);
                if (this.forcedEmptyResponse) {
                    newInstance.forceEmptyResponse();
                }
                if (this.forcedResponse != null) {
                    newInstance.forceResponse(this.forcedResponse);
                }
                newInstance.setForcedResponseCode(this.forcedResponseCode);
            }
            if (this.context.size() > 0) {
                for (MapKey contextKey : this.context.keySet()) {
                    newInstance.addContextProperty((MapKey<String>)contextKey, this.context.get(contextKey));
                }
            }
            newInstance.setTransactionId(this.transactionId);
            newInstance.setMessageRole(this.messageRole);
            newInstance.setProtocolName(this.protocolName);
        }
    }

    @Override
    public MessageContext serializeResourcesTo() throws MessageException {
        try {
            HeaderParameters headerParameters;
            List<StringParameter> l;
            BaseBeanWithId ctx;
            MessageContext msgContext = new MessageContext();
            if (this.transportRequestContext != null) {
                ctx = new TransportRequestContext();
                if (this.transportRequestContext.getParameters() != null && !this.transportRequestContext.getParameters().isEmpty() && (l = this._msgContext_convertTo(this.transportRequestContext.getParameters())) != null && l.size() > 0) {
                    UrlParameters urlParameters = new UrlParameters();
                    urlParameters.getUrlParameterList().addAll(l);
                    ctx.setUrlParameters(urlParameters);
                }
                if (this.transportRequestContext.getHeaders() != null && !this.transportRequestContext.getHeaders().isEmpty() && (l = this._msgContext_convertTo(this.transportRequestContext.getHeaders())) != null && l.size() > 0) {
                    headerParameters = new HeaderParameters();
                    headerParameters.getHeaderParameterList().addAll(l);
                    ctx.setHeaderParameters(headerParameters);
                }
                if (this.transportRequestContext.getCredential() != null) {
                    Credentials credentials = new Credentials();
                    credentials.setPrincipal(this.transportRequestContext.getCredential().getPrincipal());
                    credentials.setSubject(this.transportRequestContext.getCredential().getSubject());
                    credentials.setUsername(this.transportRequestContext.getCredential().getUsername());
                    credentials.setPassword(this.transportRequestContext.getCredential().getPassword());
                    ctx.setCredentials(credentials);
                }
                ctx.setWebContext(this.transportRequestContext.getWebContext());
                ctx.setRequestUri(this.transportRequestContext.getRequestURI());
                ctx.setRequestType(this.transportRequestContext.getRequestType());
                ctx.setSource(this.transportRequestContext.getSource());
                ctx.setProtocolName(this.transportRequestContext.getProtocolName());
                ctx.setProtocolWebContext(this.transportRequestContext.getProtocolWebContext());
                ctx.setFunction(this.transportRequestContext.getFunction());
                ctx.setFunctionParameters(this.transportRequestContext.getFunctionParameters());
                ctx.setInterfaceName(this.transportRequestContext.getInterfaceName());
                msgContext.setTransportRequestContext((TransportRequestContext)ctx);
            }
            if (this.transportResponseContext != null) {
                ctx = new TransportResponseContext();
                if (this.transportResponseContext.getHeaders() != null && !this.transportResponseContext.getHeaders().isEmpty() && (l = this._msgContext_convertTo(this.transportResponseContext.getHeaders())) != null && l.size() > 0) {
                    headerParameters = new HeaderParameters();
                    headerParameters.getHeaderParameterList().addAll(l);
                    ctx.setHeaderParameters(headerParameters);
                }
                ctx.setTransportCode(this.transportResponseContext.getCodiceTrasporto());
                if (this.transportResponseContext.getContentLength() >= 0L) {
                    ctx.setContentLength(this.transportResponseContext.getContentLength());
                }
                ctx.setError(this.transportResponseContext.getErrore());
                msgContext.setTransportResponseContext((TransportResponseContext)ctx);
            }
            if (this.forcedResponseCode != null || this.forcedEmptyResponse || this.forcedResponse != null) {
                ForcedResponse forcedResponse = new ForcedResponse();
                forcedResponse.setResponseCode(this.forcedResponseCode);
                forcedResponse.setEmptyResponse(this.forcedEmptyResponse);
                if (this.forcedResponse != null) {
                    List<StringParameter> l2;
                    org.openspcoop2.message.context.ForcedResponseMessage forcedResponseMessage = new org.openspcoop2.message.context.ForcedResponseMessage();
                    forcedResponseMessage.setContent(this.forcedResponse.getContent());
                    forcedResponseMessage.setContentType(this.forcedResponse.getContentType());
                    forcedResponseMessage.setResponseCode(this.forcedResponse.getResponseCode());
                    if (this.forcedResponse.getHeadersValues() != null && !this.forcedResponse.getHeadersValues().isEmpty() && (l2 = this._msgContext_convertTo(this.forcedResponse.getHeadersValues())) != null && l2.size() > 0) {
                        HeaderParameters headerParameters2 = new HeaderParameters();
                        headerParameters2.getHeaderParameterList().addAll(l2);
                        forcedResponseMessage.setHeaderParameters(headerParameters2);
                    }
                    forcedResponse.setResponseMessage(forcedResponseMessage);
                }
                msgContext.setForcedResponse(forcedResponse);
            }
            if (this.context != null && this.context.size() > 0) {
                SerializedContext serializedContext = null;
                Iterator<Object> it = this.context.keySet().iterator();
                JavaSerializer jSerializer = new JavaSerializer();
                while (it.hasNext()) {
                    MapKey key = (MapKey)it.next();
                    Object o = this.context.get(key);
                    if (!(o instanceof Serializable)) continue;
                    if (serializedContext == null) {
                        serializedContext = new SerializedContext();
                    }
                    SerializedParameter p = new SerializedParameter();
                    p.setNome((String)((Object)key.getValue()));
                    p.setClasse(o.getClass().getName());
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    try {
                        jSerializer.writeObject(o, (OutputStream)bout);
                    }
                    catch (Throwable t) {
                        throw new Exception("Serialization error (nome:" + p.getNome() + " classe:" + p.getClasse() + "): " + t.getMessage(), t);
                    }
                    bout.flush();
                    bout.close();
                    p.setBase(bout.toByteArray());
                    serializedContext.addProperty(p);
                }
                msgContext.setSerializedContext(serializedContext);
            }
            if (this.contentTypeParamaters != null && this.contentTypeParamaters.size() > 0) {
                ContentTypeParameters contentTypeParameters = new ContentTypeParameters();
                for (String key : this.contentTypeParamaters.keySet()) {
                    String value = this.contentTypeParamaters.get(key);
                    StringParameter parameter = new StringParameter();
                    parameter.setNome(key);
                    parameter.setBase(value);
                    contentTypeParameters.addParameter(parameter);
                }
                msgContext.setContentTypeParameters(contentTypeParameters);
            }
            msgContext.setMessageType(this.messageType.name());
            msgContext.setMessageRole(this.messageRole.name());
            if (this.outgoingsize >= 0L || this.incomingsize >= 0L || this.incomingSizeForced != null) {
                ContentLength contentLength = new ContentLength();
                if (this.outgoingsize >= 0L) {
                    contentLength.setOutgoingSize(this.outgoingsize);
                }
                if (this.incomingsize >= 0L) {
                    contentLength.setIncomingSize(this.incomingsize);
                }
                if (this.incomingSizeForced != null) {
                    contentLength.setIncomingSizeForced(this.incomingSizeForced);
                }
                msgContext.setContentLength(contentLength);
            }
            msgContext.setProtocol(this.protocolName);
            return msgContext;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    protected List<StringParameter> _msgContext_convertTo(Map<String, List<String>> p) {
        ArrayList<StringParameter> l = new ArrayList<StringParameter>();
        if (p.size() > 0) {
            for (String key : p.keySet()) {
                List<String> values = p.get(key);
                if (values == null || values.isEmpty()) continue;
                for (String value : values) {
                    StringParameter sp = new StringParameter();
                    sp.setBase(value);
                    sp.setNome(key);
                    l.add(sp);
                }
            }
        }
        return l;
    }

    @Override
    public void serializeResourcesTo(OutputStream os) throws MessageException {
        try {
            MessageContext messageContext = this.serializeResourcesTo();
            messageContext.writeTo(os, WriteToSerializerType.XML_JAXB);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public void readResourcesFrom(MessageContext messageContext) throws MessageException {
        try {
            MessageType mt;
            Map<String, List<String>> p;
            if (messageContext.getTransportRequestContext() != null) {
                this.transportRequestContext = new org.openspcoop2.utils.transport.TransportRequestContext();
                if (messageContext.getTransportRequestContext().getUrlParameters() != null && messageContext.getTransportRequestContext().getUrlParameters().sizeUrlParameterList() > 0 && (p = this._msgContext_convertTo(messageContext.getTransportRequestContext().getUrlParameters().getUrlParameterList())) != null && p.size() > 0) {
                    this.transportRequestContext.setParameters(p);
                }
                if (messageContext.getTransportRequestContext().getHeaderParameters() != null && messageContext.getTransportRequestContext().getHeaderParameters().sizeHeaderParameterList() > 0 && (p = this._msgContext_convertTo(messageContext.getTransportRequestContext().getHeaderParameters().getHeaderParameterList())) != null && p.size() > 0) {
                    this.transportRequestContext.setHeaders(p);
                }
                if (messageContext.getTransportRequestContext().getCredentials() != null) {
                    Credential credentials = new Credential();
                    credentials.setPrincipal(messageContext.getTransportRequestContext().getCredentials().getPrincipal());
                    credentials.setSubject(messageContext.getTransportRequestContext().getCredentials().getSubject());
                    credentials.setUsername(messageContext.getTransportRequestContext().getCredentials().getUsername());
                    credentials.setPassword(messageContext.getTransportRequestContext().getCredentials().getPassword());
                    this.transportRequestContext.setCredentials(credentials);
                }
                if (messageContext.getTransportRequestContext().getWebContext() != null) {
                    this.transportRequestContext.setWebContext(messageContext.getTransportRequestContext().getWebContext());
                }
                if (messageContext.getTransportRequestContext().getRequestUri() != null) {
                    this.transportRequestContext.setRequestURI(messageContext.getTransportRequestContext().getRequestUri());
                }
                if (messageContext.getTransportRequestContext().getRequestType() != null) {
                    this.transportRequestContext.setRequestType(messageContext.getTransportRequestContext().getRequestType());
                }
                if (messageContext.getTransportRequestContext().getSource() != null) {
                    this.transportRequestContext.setSource(messageContext.getTransportRequestContext().getSource());
                }
                if (messageContext.getTransportRequestContext().getProtocolName() != null) {
                    this.transportRequestContext.setProtocol(messageContext.getTransportRequestContext().getProtocolName(), messageContext.getTransportRequestContext().getProtocolWebContext());
                }
                if (messageContext.getTransportRequestContext().getFunction() != null) {
                    this.transportRequestContext.setFunction(messageContext.getTransportRequestContext().getFunction());
                }
                if (messageContext.getTransportRequestContext().getFunctionParameters() != null) {
                    this.transportRequestContext.setFunctionParameters(messageContext.getTransportRequestContext().getFunctionParameters());
                }
                if (messageContext.getTransportRequestContext().getInterfaceName() != null) {
                    this.transportRequestContext.setInterfaceName(messageContext.getTransportRequestContext().getInterfaceName());
                }
            }
            if (messageContext.getTransportResponseContext() != null) {
                this.transportResponseContext = new org.openspcoop2.utils.transport.TransportResponseContext();
                if (messageContext.getTransportResponseContext().getHeaderParameters() != null && messageContext.getTransportResponseContext().getHeaderParameters().sizeHeaderParameterList() > 0 && (p = this._msgContext_convertTo(messageContext.getTransportResponseContext().getHeaderParameters().getHeaderParameterList())) != null && p.size() > 0) {
                    this.transportResponseContext.setHeaders(p);
                }
                this.transportResponseContext.setCodiceTrasporto(messageContext.getTransportResponseContext().getTransportCode());
                if (messageContext.getTransportResponseContext().getContentLength() != null) {
                    this.transportResponseContext.setContentLength(messageContext.getTransportResponseContext().getContentLength().longValue());
                }
                this.transportResponseContext.setErrore(messageContext.getTransportResponseContext().getError());
            }
            if (messageContext.getForcedResponse() != null) {
                this.forcedResponseCode = messageContext.getForcedResponse().getResponseCode();
                this.forcedEmptyResponse = messageContext.getForcedResponse().isEmptyResponse();
                if (messageContext.getForcedResponse().getResponseMessage() != null) {
                    Object p2;
                    ForcedResponseMessage f = new ForcedResponseMessage();
                    f.setContent(messageContext.getForcedResponse().getResponseMessage().getContent());
                    f.setContentType(messageContext.getForcedResponse().getResponseMessage().getContentType());
                    f.setResponseCode(messageContext.getForcedResponse().getResponseMessage().getResponseCode());
                    if (messageContext.getForcedResponse().getResponseMessage().getHeaderParameters() != null && messageContext.getForcedResponse().getResponseMessage().getHeaderParameters().sizeHeaderParameterList() > 0 && (p2 = this._msgContext_convertTo(messageContext.getForcedResponse().getResponseMessage().getHeaderParameters().getHeaderParameterList())) != null && p2.size() > 0) {
                        f.setHeadersValues((Map<String, List<String>>)p2);
                    }
                    this.forcedResponse = f;
                }
            }
            if (messageContext.getSerializedContext() != null) {
                JavaDeserializer jDeserializer = new JavaDeserializer();
                for (SerializedParameter p3 : messageContext.getSerializedContext().getPropertyList()) {
                    Object o = jDeserializer.readObject((InputStream)new ByteArrayInputStream(p3.getBase()), Class.forName(p3.getClasse()));
                    this.context.addObject(org.openspcoop2.utils.Map.newMapKey((String)p3.getNome()), o);
                }
            }
            if (messageContext.getContentTypeParameters() != null && messageContext.getContentTypeParameters().sizeParameterList() > 0) {
                for (StringParameter par : messageContext.getContentTypeParameters().getParameterList()) {
                    this.contentTypeParamaters.put(par.getNome(), par.getBase());
                }
            }
            if ((mt = MessageType.valueOf(messageContext.getMessageType())) == null) {
                throw new Exception("MessageType [" + messageContext.getMessageType() + "] unknown");
            }
            if (!mt.equals(this.messageType)) {
                throw new Exception("MessageType [" + mt + "] different from instance value [" + this.messageType + "]");
            }
            MessageRole mr = MessageRole.valueOf(messageContext.getMessageRole());
            if (mr == null) {
                throw new Exception("MessageRole [" + messageContext.getMessageRole() + "] unknown");
            }
            if (!mr.equals(this.messageRole)) {
                throw new Exception("MessageRole [" + mr + "] different from instance value [" + this.messageRole + "]");
            }
            if (messageContext.getContentLength() != null) {
                if (messageContext.getContentLength().getOutgoingSize() != null) {
                    this.outgoingsize = messageContext.getContentLength().getOutgoingSize();
                }
                if (messageContext.getContentLength().getIncomingSize() != null) {
                    this.incomingsize = messageContext.getContentLength().getIncomingSize();
                }
                if (messageContext.getContentLength().getIncomingSizeForced() != null) {
                    this.incomingSizeForced = messageContext.getContentLength().getIncomingSizeForced();
                }
            }
            if (messageContext.getProtocol() != null) {
                this.protocolName = messageContext.getProtocol();
            }
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    protected Map<String, List<String>> _msgContext_convertTo(List<StringParameter> list) {
        HashMap<String, List<String>> p = new HashMap<String, List<String>>();
        if (list.size() > 0) {
            for (StringParameter stringParameter : list) {
                TransportUtils.put(p, (String)stringParameter.getNome(), (String)stringParameter.getBase(), (boolean)true);
            }
        }
        return p;
    }

    @Override
    public void readResourcesFrom(InputStream is) throws MessageException {
        MessageContext messageContext = null;
        try {
            JaxbDeserializer deserializer = new JaxbDeserializer();
            messageContext = deserializer.readMessageContext(is);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
        this.readResourcesFrom(messageContext);
    }

    @Override
    public OpenSPCoop2SoapMessage castAsSoap() throws MessageException {
        if (this instanceof OpenSPCoop2SoapMessage) {
            return (OpenSPCoop2SoapMessage)((Object)this);
        }
        throw new MessageException("Instance (type:" + this.getMessageType() + " class:" + this.getClass().getName() + ") not usable in SOAP Context");
    }

    @Override
    public OpenSPCoop2RestMessage<?> castAsRest() throws MessageException {
        if (this instanceof OpenSPCoop2RestMessage) {
            return (OpenSPCoop2RestMessage)((Object)this);
        }
        throw new MessageException("Instance (type:" + this.getMessageType() + " class:" + this.getClass().getName() + ") not usable in REST Context");
    }

    @Override
    public OpenSPCoop2RestXmlMessage castAsRestXml() throws MessageException {
        if (this instanceof OpenSPCoop2RestXmlMessage) {
            return (OpenSPCoop2RestXmlMessage)((Object)this);
        }
        throw new MessageException("Instance (type:" + this.getMessageType() + " class:" + this.getClass().getName() + ") not usable in REST-Xml Context");
    }

    @Override
    public OpenSPCoop2RestJsonMessage castAsRestJson() throws MessageException {
        if (this instanceof OpenSPCoop2RestJsonMessage) {
            return (OpenSPCoop2RestJsonMessage)((Object)this);
        }
        throw new MessageException("Instance (type:" + this.getMessageType() + " class:" + this.getClass().getName() + ") not usable in REST-Json Context");
    }

    @Override
    public OpenSPCoop2RestBinaryMessage castAsRestBinary() throws MessageException {
        if (this instanceof OpenSPCoop2RestBinaryMessage) {
            return (OpenSPCoop2RestBinaryMessage)((Object)this);
        }
        throw new MessageException("Instance (type:" + this.getMessageType() + " class:" + this.getClass().getName() + ") not usable in REST-Binary Context");
    }

    @Override
    public OpenSPCoop2RestMimeMultipartMessage castAsRestMimeMultipart() throws MessageException {
        if (this instanceof OpenSPCoop2RestMimeMultipartMessage) {
            return (OpenSPCoop2RestMimeMultipartMessage)((Object)this);
        }
        throw new MessageException("Instance (type:" + this.getMessageType() + " class:" + this.getClass().getName() + ") not usable in REST-MimeMultipart Context");
    }

    @Override
    public void setTransportRequestContext(org.openspcoop2.utils.transport.TransportRequestContext transportRequestContext) {
        this.transportRequestContext = transportRequestContext;
    }

    @Override
    public org.openspcoop2.utils.transport.TransportRequestContext getTransportRequestContext() {
        return this.transportRequestContext;
    }

    @Override
    public void setTransportResponseContext(org.openspcoop2.utils.transport.TransportResponseContext transportResponseContext) {
        this.transportResponseContext = transportResponseContext;
    }

    @Override
    public org.openspcoop2.utils.transport.TransportResponseContext getTransportResponseContext() {
        return this.transportResponseContext;
    }

    @Override
    public void forceTransportHeader(String name, String value) {
        TransportUtils.setHeader(this.forceTransportHeaders, (String)name, (String)value);
    }

    @Override
    public void forceTransportHeader(String name, List<String> values) {
        TransportUtils.removeObject(this.forceTransportHeaders, (String)name);
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                TransportUtils.addHeader(this.forceTransportHeaders, (String)name, (String)value);
            }
        }
    }

    @Override
    public Map<String, List<String>> getForceTransportHeaders() {
        return this.forceTransportHeaders != null ? new HashMap<String, List<String>>(this.forceTransportHeaders) : null;
    }

    @Override
    public void forceUrlProperty(String name, String value) {
        TransportUtils.setParameter(this.forceUrlProperties, (String)name, (String)value);
    }

    @Override
    public void forceUrlProperty(String name, List<String> values) {
        TransportUtils.removeObject(this.forceUrlProperties, (String)name);
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                TransportUtils.addParameter(this.forceUrlProperties, (String)name, (String)value);
            }
        }
    }

    @Override
    public Map<String, List<String>> getForceUrlProperties() {
        return this.forceUrlProperties != null ? new HashMap<String, List<String>>(this.forceUrlProperties) : null;
    }

    @Override
    public OpenSPCoop2MessageProperties getForwardTransportHeader(ForwardConfig forwardConfig) throws MessageException {
        OpenSPCoop2MessageProperties msg = this._getForwardTransportHeader(forwardConfig);
        if (msg == null) {
            msg = new OpenSPCoop2MessageProperties();
        }
        if (this.forceTransportHeaders != null && this.forceTransportHeaders.size() > 0) {
            for (String key : this.forceTransportHeaders.keySet()) {
                List<String> values = this.forceTransportHeaders.get(key);
                msg.removePropertyValues(key);
                msg.setProperty(key, values);
            }
        }
        return msg;
    }

    protected OpenSPCoop2MessageProperties _getForwardTransportHeader(ForwardConfig forwardConfig) throws MessageException {
        try {
            if (forwardConfig == null || !forwardConfig.isForwardEnable()) {
                return this.forwardTransportHeader;
            }
            if (!this.forwardTransportHeader.isInitialize()) {
                Map transportHeaders = null;
                if (MessageRole.REQUEST.equals(this.messageRole)) {
                    if (this.transportRequestContext != null) {
                        transportHeaders = this.transportRequestContext.getHeaders();
                    }
                } else if (this.transportResponseContext != null) {
                    transportHeaders = this.transportResponseContext.getHeaders();
                }
                if (transportHeaders != null && transportHeaders.size() > 0) {
                    TransportUtilities.initializeTransportHeaders(this.forwardTransportHeader, this.messageRole, transportHeaders, forwardConfig);
                    this.forwardTransportHeader.setInitialize(true);
                }
            }
            return this.forwardTransportHeader;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public OpenSPCoop2MessageProperties getForwardUrlProperties(ForwardConfig forwardConfig) throws MessageException {
        OpenSPCoop2MessageProperties msg = this._getForwardUrlProperties(forwardConfig);
        if (msg == null) {
            msg = new OpenSPCoop2MessageProperties();
        }
        if (this.forceUrlProperties != null && this.forceUrlProperties.size() > 0) {
            for (String key : this.forceUrlProperties.keySet()) {
                List<String> values = this.forceUrlProperties.get(key);
                msg.removePropertyValues(key);
                msg.setProperty(key, values);
            }
        }
        return msg;
    }

    protected OpenSPCoop2MessageProperties _getForwardUrlProperties(ForwardConfig forwardConfig) throws MessageException {
        try {
            if (forwardConfig == null || !forwardConfig.isForwardEnable()) {
                return this.forwardUrlProperties;
            }
            if (!this.forwardUrlProperties.isInitialize()) {
                Map forwardUrlParamters = null;
                if (this.transportRequestContext != null) {
                    forwardUrlParamters = this.transportRequestContext.getParameters();
                }
                if (forwardUrlParamters != null && forwardUrlParamters.size() > 0) {
                    TransportUtilities.initializeForwardUrlParameters(this.forwardUrlProperties, this.messageRole, forwardUrlParamters, forwardConfig);
                    this.forwardUrlProperties.setInitialize(true);
                }
            }
            return this.forwardUrlProperties;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public void setForcedResponseCode(String code) {
        this.forcedResponseCode = code;
    }

    @Override
    public String getForcedResponseCode() {
        return this.forcedResponseCode;
    }

    @Override
    public boolean isForcedEmptyResponse() {
        return this.forcedEmptyResponse;
    }

    @Override
    public void forceEmptyResponse() {
        this.forcedEmptyResponse = true;
    }

    @Override
    public void forceResponse(ForcedResponseMessage msg) {
        this.forcedResponse = msg;
    }

    @Override
    public ForcedResponseMessage getForcedResponse() {
        return this.forcedResponse;
    }

    @Override
    public void addContextProperty(MapKey<String> property, Object value) {
        this.context.put(property, value);
    }

    @Override
    public Iterator<MapKey<String>> keysContextProperty() {
        return this.context.keySet().iterator();
    }

    @Override
    public Object getContextProperty(MapKey<String> property) {
        return this.context.get(property);
    }

    @Override
    public Object removeContextProperty(MapKey<String> property) {
        return this.context.remove(property);
    }

    @Override
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public void addContentTypeParameter(String name, String value) throws MessageException {
        this.contentTypeParamaters.put(name, value);
    }

    @Override
    public void removeContentTypeParameter(String name) throws MessageException {
        this.contentTypeParamaters.remove(name);
    }

    @Override
    public MessageType getMessageType() {
        return this.messageType;
    }

    @Override
    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    @Override
    public MessageRole getMessageRole() {
        return this.messageRole;
    }

    @Override
    public void setMessageRole(MessageRole messageRole) {
        this.messageRole = messageRole;
    }

    protected SOAPBody _getSOAPBody_internalAnalyze() throws MessageException, MessageNotSupportedException {
        OpenSPCoop2SoapMessage soapMsg = this.castAsSoap();
        return soapMsg.getSOAPBody();
    }

    @Override
    public boolean isFault() throws MessageException {
        try {
            boolean isFault = false;
            if (ServiceBinding.SOAP.equals(this.getServiceBinding())) {
                if (MessageRole.FAULT.equals(this.getMessageRole())) {
                    isFault = true;
                } else {
                    OpenSPCoop2SoapMessage soapMsg = this.castAsSoap();
                    OpenSPCoop2MessageSoapStreamReader soapReader = soapMsg.getSoapReader();
                    if (soapReader != null && soapReader.isParsingComplete()) {
                        isFault = soapReader.isFault();
                    } else {
                        boolean hasContent;
                        SOAPBody soapBody = this._getSOAPBody_internalAnalyze();
                        boolean bl = hasContent = soapBody != null;
                        if (hasContent) {
                            hasContent = SoapUtils.getFirstNotEmptyChildNode(this.messageFactory, (Node)soapBody, false) != null;
                        }
                        isFault = hasContent && soapBody.hasFault();
                    }
                }
            } else if (MessageRole.FAULT.equals(this.getMessageRole())) {
                isFault = true;
            } else {
                OpenSPCoop2RestMessage<?> restMsg = this.castAsRest();
                isFault = restMsg.isProblemDetailsForHttpApis_RFC7807();
            }
            return isFault;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public ServiceBinding getServiceBinding() {
        if (this instanceof OpenSPCoop2SoapMessage) {
            return ServiceBinding.SOAP;
        }
        return ServiceBinding.REST;
    }

    @Override
    public void updateIncomingMessageContentLength() {
    }

    @Override
    public void updateIncomingMessageContentLength(long incomingsize) {
        this.incomingSizeForced = incomingsize;
    }

    @Override
    public long getIncomingMessageContentLength() {
        if (this.incomingSizeForced != null) {
            return this.incomingSizeForced;
        }
        return this.incomingsize;
    }

    @Override
    public void updateOutgoingMessageContentLength(long outgoingsize) {
        this.outgoingsize = outgoingsize;
    }

    @Override
    public long getOutgoingMessageContentLength() {
        return this.outgoingsize;
    }

    @Override
    public String getAsString(Node ele, boolean consume) {
        try {
            return MessageXMLUtils.getInstance(this.messageFactory).toString(ele, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getAsByte(Node ele, boolean consume) {
        try {
            return MessageXMLUtils.getInstance(this.messageFactory).toByteArray(ele, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addNamespaceXSITypeIfNotExists(Node element, Node root) throws MessageException {
        try {
            if (this.normalizeNamespaceXSIType) {
                SOAPEnvelope soapEnvelope;
                DynamicNamespaceContext dnc = null;
                MessageDynamicNamespaceContextFactory dncFactory = MessageDynamicNamespaceContextFactory.getInstance(this.messageFactory);
                dnc = root instanceof SOAPEnvelope ? ("http://www.w3.org/2003/05/soap-envelope".equals((soapEnvelope = (SOAPEnvelope)root).getNamespaceURI()) ? dncFactory.getNamespaceContextFromSoapEnvelope12(soapEnvelope) : dncFactory.getNamespaceContextFromSoapEnvelope11(soapEnvelope)) : dncFactory.getNamespaceContext(root);
                MessageXMLUtils.getInstance(this.messageFactory).addNamespaceXSITypeIfNotExists(element, dnc, true);
            }
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public ParseException getParseException() {
        return this.parseException;
    }

    @Override
    public void setParseException(ParseException e) {
        this.parseException = e;
    }

    @Override
    public void setParseException(Throwable e) {
        this.parseException = ParseExceptionUtils.buildParseException(e, this.messageRole);
    }

    @Override
    public void setProtocolName(String protocolName) {
        this.protocolName = protocolName;
    }

    @Override
    public String getProtocolName() {
        return this.protocolName;
    }

    @Override
    public void setNotifierInputStream(NotifierInputStream is) {
        this.notifierInputStream = is;
    }

    @Override
    public NotifierInputStream getNotifierInputStream() {
        return this.notifierInputStream;
    }
}

