/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message;

import com.sun.xml.messaging.saaj.client.p2p.HttpSOAPConnectionFactory;
import com.sun.xml.messaging.saaj.soap.MessageFactoryImpl;
import com.sun.xml.messaging.saaj.soap.ver1_1.SOAPFactory1_1Impl;
import com.sun.xml.messaging.saaj.soap.ver1_2.SOAPFactory1_2Impl;
import java.io.InputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.openspcoop2.message.AbstractBaseOpenSPCoop2Message;
import org.openspcoop2.message.AttachmentsProcessingMode;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.rest.OpenSPCoop2Message_binary_impl;
import org.openspcoop2.message.rest.OpenSPCoop2Message_json_impl;
import org.openspcoop2.message.rest.OpenSPCoop2Message_mimeMultipart_impl;
import org.openspcoop2.message.rest.OpenSPCoop2Message_xml_impl;
import org.openspcoop2.message.soap.AbstractOpenSPCoop2Message_saaj_impl;
import org.openspcoop2.message.soap.OpenSPCoop2Message_saaj_11_impl;
import org.openspcoop2.message.soap.OpenSPCoop2Message_saaj_12_impl;
import org.openspcoop2.message.soap.OpenSPCoop2Message_soap11_impl;
import org.openspcoop2.message.soap.OpenSPCoop2Message_soap12_impl;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportResponseContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpenSPCoop2MessageFactory_impl
extends OpenSPCoop2MessageFactory {
    private static volatile boolean soapPassthroughImpl = true;

    public static void setSoapPassthroughImpl(boolean soapPassthroughImpl) {
        OpenSPCoop2MessageFactory_impl.soapPassthroughImpl = soapPassthroughImpl;
    }

    @Override
    protected synchronized void initSoapFactory() {
        try {
            if (OpenSPCoop2MessageFactory.soapFactory11 == null || OpenSPCoop2MessageFactory.soapFactory12 == null) {
                OpenSPCoop2MessageFactory.initSoapFactory11((SOAPFactory)new SOAPFactory1_1Impl());
                OpenSPCoop2MessageFactory.initSoapFactory12((SOAPFactory)new SOAPFactory1_2Impl());
            }
        }
        catch (Exception e) {
            System.out.println("ERRORE: " + e.getMessage());
        }
    }

    @Override
    protected synchronized void initSoapMessageFactory() throws SOAPException {
        if (OpenSPCoop2MessageFactory.soapMessageFactory == null) {
            OpenSPCoop2MessageFactory.initSoapMessageFactory((MessageFactory)new MessageFactoryImpl());
        }
    }

    @Override
    public SOAPConnectionFactory getSOAPConnectionFactory() throws SOAPException {
        return new HttpSOAPConnectionFactory();
    }

    @Override
    public String getDocumentBuilderFactoryClass() {
        return DocumentBuilderFactoryImpl.class.getName();
    }

    @Override
    public String getSAXParserFactoryClass() {
        return SAXParserFactoryImpl.class.getName();
    }

    @Override
    public Element convertoForXPathSearch(Element contenutoAsElement) {
        return contenutoAsElement;
    }

    @Override
    public void normalizeDocument(Document document) {
        document.normalizeDocument();
    }

    @Override
    public OpenSPCoop2Message _createMessage(MessageType messageType, SOAPMessage soapMsg) throws MessageException {
        AbstractOpenSPCoop2Message_saaj_impl msg = null;
        if (MessageType.SOAP_11.equals(messageType)) {
            msg = new OpenSPCoop2Message_saaj_11_impl(this, soapMsg);
        } else if (MessageType.SOAP_12.equals(messageType)) {
            msg = new OpenSPCoop2Message_saaj_12_impl(this, soapMsg);
        } else {
            throw new MessageException("Message Type [" + messageType + "] unsupported");
        }
        return msg;
    }

    @Override
    public OpenSPCoop2Message _createEmptyMessage(MessageType messageType) throws MessageException {
        AbstractBaseOpenSPCoop2Message msg = null;
        switch (messageType) {
            case SOAP_11: {
                msg = new OpenSPCoop2Message_saaj_11_impl(this);
                break;
            }
            case SOAP_12: {
                msg = new OpenSPCoop2Message_saaj_12_impl(this);
                break;
            }
            case XML: {
                msg = new OpenSPCoop2Message_xml_impl(this);
                break;
            }
            case JSON: {
                msg = new OpenSPCoop2Message_json_impl(this);
                break;
            }
            case BINARY: {
                msg = new OpenSPCoop2Message_binary_impl(this);
                break;
            }
            case MIME_MULTIPART: {
                msg = new OpenSPCoop2Message_mimeMultipart_impl(this);
            }
        }
        return msg;
    }

    @Override
    protected OpenSPCoop2Message _createMessage(MessageType messageType, TransportRequestContext requestContext, InputStream is, AttachmentsProcessingMode attachmentsProcessingMode, long overhead, OpenSPCoop2MessageSoapStreamReader soapStreamReader) throws MessageException {
        return this._createMessageEngine(messageType, requestContext, is, attachmentsProcessingMode, overhead, soapStreamReader);
    }

    @Override
    protected OpenSPCoop2Message _createMessage(MessageType messageType, TransportResponseContext responseContext, InputStream is, AttachmentsProcessingMode attachmentsProcessingMode, long overhead, OpenSPCoop2MessageSoapStreamReader soapStreamReader) throws MessageException {
        return this._createMessageEngine(messageType, responseContext, is, attachmentsProcessingMode, overhead, soapStreamReader);
    }

    @Override
    protected OpenSPCoop2Message _createMessage(MessageType messageType, String contentType, InputStream is, AttachmentsProcessingMode attachmentsProcessingMode, long overhead, OpenSPCoop2MessageSoapStreamReader soapStreamReader) throws MessageException {
        return this._createMessageEngine(messageType, contentType, is, attachmentsProcessingMode, overhead, soapStreamReader);
    }

    private OpenSPCoop2Message _createMessageEngine(MessageType messageType, Object context, InputStream is, AttachmentsProcessingMode attachmentsProcessingMode, long overhead, OpenSPCoop2MessageSoapStreamReader soapStreamReader) throws MessageException {
        try {
            AbstractBaseOpenSPCoop2Message msg = null;
            String contentType = null;
            TransportRequestContext transportRequestContext = null;
            TransportResponseContext transportResponseContext = null;
            if (context instanceof TransportRequestContext) {
                transportRequestContext = (TransportRequestContext)context;
                contentType = transportRequestContext.getHeaderFirstValue("Content-Type");
            } else if (context instanceof TransportResponseContext) {
                transportResponseContext = (TransportResponseContext)context;
                contentType = transportResponseContext.getHeaderFirstValue("Content-Type");
            } else if (context instanceof String) {
                contentType = (String)context;
            } else if (context == null) {
                if (!MessageType.BINARY.equals(messageType)) {
                    throw new MessageException("Unsupported Empty Context for message '" + messageType + "' (No Content Type?)");
                }
            } else {
                throw new MessageException("Unsupported Context [" + context + "]");
            }
            switch (messageType) {
                case SOAP_11: 
                case SOAP_12: {
                    MimeHeaders mhs = new MimeHeaders();
                    if (contentType != null) {
                        mhs.setHeader("Content-Type", contentType);
                    }
                    if (soapPassthroughImpl) {
                        if (MessageType.SOAP_11.equals(messageType)) {
                            msg = new OpenSPCoop2Message_soap11_impl((OpenSPCoop2MessageFactory)this, mhs, is, overhead, soapStreamReader);
                            break;
                        }
                        msg = new OpenSPCoop2Message_soap12_impl((OpenSPCoop2MessageFactory)this, mhs, is, overhead, soapStreamReader);
                        break;
                    }
                    if (MessageType.SOAP_11.equals(messageType)) {
                        msg = new OpenSPCoop2Message_saaj_11_impl(this, mhs, is);
                        ((OpenSPCoop2Message_saaj_11_impl)msg).initialize(overhead);
                        break;
                    }
                    msg = new OpenSPCoop2Message_saaj_12_impl(this, mhs, is);
                    ((OpenSPCoop2Message_saaj_12_impl)msg).initialize(overhead);
                    break;
                }
                case XML: {
                    msg = new OpenSPCoop2Message_xml_impl(this, is, contentType);
                    break;
                }
                case JSON: {
                    msg = new OpenSPCoop2Message_json_impl(this, is, contentType);
                    break;
                }
                case BINARY: {
                    msg = new OpenSPCoop2Message_binary_impl(this, is, contentType);
                    break;
                }
                case MIME_MULTIPART: {
                    msg = new OpenSPCoop2Message_mimeMultipart_impl(this, is, contentType);
                }
            }
            return msg;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }
}

