/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.message.config.AbstractConfigurationServiceBinding;
import org.openspcoop2.message.config.IntegrationErrorCollection;
import org.openspcoop2.message.config.RestBinding;
import org.openspcoop2.message.config.RestMediaTypeCollection;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageException;

public class ConfigurationServiceBindingRest
extends AbstractConfigurationServiceBinding
implements Serializable {
    private static final long serialVersionUID = 1L;
    private RestBinding binding;

    public ConfigurationServiceBindingRest(boolean enabled, RestBinding binding, IntegrationErrorCollection internalIntegrationErrorConfiguration, IntegrationErrorCollection externalIntegrationErrorConfiguration) throws MessageException {
        super(ServiceBinding.REST, enabled, internalIntegrationErrorConfiguration, externalIntegrationErrorConfiguration);
        if (this.enabled) {
            if (binding == null) {
                throw new MessageException("RestBinding not defined");
            }
            this.binding = binding;
        }
    }

    @Override
    public void init() {
        if (this.enabled) {
            this.request = new RestMediaTypeCollection(this.binding);
            this.response = new RestMediaTypeCollection(this.binding);
        }
    }

    public RestBinding getBinding() {
        return this.binding;
    }

    @Override
    public List<MessageType> getMessageTypeSupported() {
        ArrayList<MessageType> list = new ArrayList<MessageType>();
        if (this.binding != null) {
            if (this.binding.isBinding_xml()) {
                list.add(MessageType.XML);
            }
            if (this.binding.isBinding_json()) {
                list.add(MessageType.JSON);
            }
            if (this.binding.isBinding_binary()) {
                list.add(MessageType.BINARY);
            }
            if (this.binding.isBinding_mimeMultipart()) {
                list.add(MessageType.MIME_MULTIPART);
            }
        }
        return list;
    }
}

