/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.config;

import java.io.Serializable;
import org.openspcoop2.message.config.AbstractMediaTypeCollection;
import org.openspcoop2.message.config.SoapBinding;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;

public class SoapMediaTypeCollection
extends AbstractMediaTypeCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SoapBinding binding;

    public SoapMediaTypeCollection(SoapBinding binding) {
        this.binding = binding;
    }

    private void checkVersion(MessageType version) throws MessageException {
        if (MessageType.SOAP_11.equals(version)) {
            if (!this.binding.isBinding_soap11()) {
                throw new MessageException("MessageType [" + version + "] not supported in SoapBinding; Soap11 disabled");
            }
        } else if (MessageType.SOAP_12.equals(version)) {
            if (!this.binding.isBinding_soap12()) {
                throw new MessageException("MessageType [" + version + "] not supported in SoapBinding; Soap12 disabled");
            }
        } else {
            throw new MessageException("MessageType [" + version + "] not supported in SoapBinding");
        }
    }

    @Override
    public void addDefaultMediaType(MessageType version) throws MessageException {
        this.checkVersion(version);
        super.addDefaultMediaType(version);
    }

    @Override
    public void addUndefinedMediaType(MessageType version) throws MessageException {
        this.checkVersion(version);
        super.addUndefinedMediaType(version);
    }

    @Override
    public void addMediaType(String mediaType, MessageType version, boolean regExpr) throws MessageException {
        this.checkVersion(version);
        super.addMediaType(mediaType, version, regExpr);
    }
}

