/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.rest;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpServletTransportRequestContext;
import org.slf4j.Logger;

public class RestUtilities {
    public static String getUrlWithoutInterface(TransportRequestContext requestContext, String normalizedInterfaceName) {
        String resourcePath = requestContext.getFunctionParameters();
        if (resourcePath != null) {
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.substring(1);
            }
            if (requestContext.getInterfaceName() != null) {
                if (resourcePath.startsWith(requestContext.getInterfaceName())) {
                    resourcePath = resourcePath.substring(requestContext.getInterfaceName().length());
                } else if (normalizedInterfaceName != null && resourcePath.startsWith(normalizedInterfaceName)) {
                    resourcePath = resourcePath.substring(normalizedInterfaceName.length());
                }
            }
        }
        return resourcePath;
    }

    public static String buildUrl(Logger log, String url, Map<String, List<String>> p, TransportRequestContext requestContext, String normalizedInterfaceName) {
        String[] split;
        String resourcePath;
        String baseUrl = url;
        String parameterOriginalUrl = null;
        if (url.contains("?")) {
            baseUrl = url.split("\\?")[0];
            if (baseUrl != null) {
                baseUrl = baseUrl.trim();
            }
            if ((parameterOriginalUrl = url.split("\\?")[1]) != null) {
                parameterOriginalUrl = parameterOriginalUrl.trim();
            }
        }
        StringBuilder newUrl = new StringBuilder();
        newUrl.append(baseUrl);
        if (requestContext != null && (resourcePath = RestUtilities.getUrlWithoutInterface(requestContext, normalizedInterfaceName)) != null) {
            boolean extraPathApplicativoStartWithSlash = false;
            if (resourcePath.startsWith("/")) {
                extraPathApplicativoStartWithSlash = true;
                resourcePath = resourcePath.substring(1);
            }
            if (resourcePath != null && !"".equals(resourcePath)) {
                if (!baseUrl.endsWith("/")) {
                    newUrl.append("/");
                }
                newUrl.append(resourcePath);
            } else if (extraPathApplicativoStartWithSlash && !baseUrl.endsWith("/")) {
                newUrl.append("/");
            }
        }
        if (parameterOriginalUrl != null && (split = parameterOriginalUrl.split("&")) != null) {
            String nome;
            int indexOf;
            int i;
            if (p == null) {
                p = new HashMap<String, List<String>>();
            }
            for (i = 0; i < split.length; ++i) {
                if (!split[i].contains("=")) continue;
                indexOf = split[i].indexOf("=");
                nome = null;
                if (indexOf > 0) {
                    nome = split[i].substring(0, indexOf);
                }
                if (nome != null) {
                    nome = nome.trim();
                }
                if (nome == null) continue;
                TransportUtils.removeRawObject(p, (String)nome);
            }
            for (i = 0; i < split.length; ++i) {
                if (!split[i].contains("=")) continue;
                indexOf = split[i].indexOf("=");
                nome = null;
                if (indexOf > 0) {
                    nome = split[i].substring(0, indexOf);
                }
                if (nome != null) {
                    nome = nome.trim();
                }
                String valore = null;
                if (indexOf + 1 <= split[i].length() - 1) {
                    valore = split[i].substring(indexOf + 1);
                }
                valore = valore != null ? valore.trim() : "";
                if (nome == null || valore == null) continue;
                TransportUtils.addParameter(p, (String)nome, (String)valore);
            }
        }
        return TransportUtils.buildUrlWithParameters(p, (String)newUrl.toString(), (Logger)log);
    }

    public static String buildPassReverseUrl(TransportRequestContext transportRequestContext, String baseUrl, String redirectLocationUrlParam, String prefixGatewayUrl, String interfaceName) throws MalformedURLException {
        Object r = baseUrl;
        if (((String)r).contains("?")) {
            r = baseUrl.split("\\?")[0];
        }
        URL uri = new URL((String)r);
        Object rRelative = uri.getPath();
        String redirectLocationUrl = null;
        String redirectLocationUrlParameters = null;
        if (redirectLocationUrlParam.contains("?")) {
            String[] tmp = redirectLocationUrlParam.split("\\?");
            redirectLocationUrl = tmp[0];
            if (tmp.length > 1) {
                StringBuilder sbc = new StringBuilder();
                for (int i = 1; i < tmp.length; ++i) {
                    if (sbc.length() > 0) {
                        sbc.append("?");
                    }
                    sbc.append(tmp[i]);
                }
                redirectLocationUrlParameters = sbc.toString();
            }
        } else {
            redirectLocationUrl = redirectLocationUrlParam;
        }
        if (redirectLocationUrl.endsWith("/")) {
            if (!((String)r).endsWith("/")) {
                r = (String)r + "/";
            }
            if (!((String)rRelative).endsWith("/")) {
                rRelative = (String)rRelative + "/";
            }
        } else {
            if (((String)r).endsWith("/")) {
                Object object = r = ((String)r).length() <= 1 ? "" : ((String)r).substring(0, ((String)r).length() - 1);
            }
            if (((String)rRelative).endsWith("/")) {
                Object object = rRelative = ((String)rRelative).length() <= 1 ? "" : ((String)rRelative).substring(0, ((String)rRelative).length() - 1);
            }
        }
        if (redirectLocationUrl.startsWith((String)r) || redirectLocationUrl.startsWith((String)rRelative)) {
            Object contextPath = null;
            if (prefixGatewayUrl == null) {
                String protocollo;
                contextPath = transportRequestContext.getWebContext();
                if (!((String)contextPath).endsWith("/")) {
                    contextPath = (String)contextPath + "/";
                }
                if (!"@EMPTY@".equals(protocollo = transportRequestContext.getProtocolWebContext())) {
                    contextPath = (String)contextPath + protocollo + "/";
                }
                contextPath = (String)contextPath + transportRequestContext.getFunction();
            }
            String suffix = "";
            if (redirectLocationUrl.startsWith((String)r)) {
                if (!redirectLocationUrl.equals(r)) {
                    suffix = redirectLocationUrl.substring(((String)r).length());
                }
            } else if (!redirectLocationUrl.equals(rRelative)) {
                suffix = redirectLocationUrl.substring(((String)rRelative).length());
            }
            StringBuilder bf = new StringBuilder();
            if (redirectLocationUrl.startsWith((String)r)) {
                if (prefixGatewayUrl != null) {
                    prefixGatewayUrl = prefixGatewayUrl.trim();
                    bf.append(prefixGatewayUrl);
                    if (!prefixGatewayUrl.endsWith("/")) {
                        bf.append("/");
                    }
                } else {
                    bf.append((String)contextPath);
                    if (!((String)contextPath).endsWith("/")) {
                        bf.append("/");
                    }
                }
            } else if (prefixGatewayUrl != null) {
                URL urlPrefixGatewayUrl = new URL(prefixGatewayUrl);
                String urlPrefixGatewayUrlAsString = urlPrefixGatewayUrl.getPath();
                bf.append(urlPrefixGatewayUrlAsString);
                if (!urlPrefixGatewayUrlAsString.endsWith("/")) {
                    bf.append("/");
                }
            } else {
                bf.append((String)contextPath);
                if (!((String)contextPath).endsWith("/")) {
                    bf.append("/");
                }
            }
            String interfaceNameTmp = null;
            interfaceNameTmp = interfaceName != null ? interfaceName : transportRequestContext.getInterfaceName();
            if (interfaceNameTmp != null) {
                if (interfaceNameTmp.startsWith("/")) {
                    if (interfaceNameTmp.length() > 1) {
                        bf.append(interfaceNameTmp.substring(1));
                    }
                } else {
                    bf.append(interfaceNameTmp);
                }
            }
            if (suffix.equals("")) {
                if (redirectLocationUrl.endsWith("/") && !bf.toString().endsWith("/")) {
                    bf.append("/");
                }
            } else {
                if (!suffix.startsWith("/")) {
                    bf.append("/");
                }
                bf.append(suffix);
            }
            Object url = bf.toString();
            if (redirectLocationUrlParameters != null && !"".equals(redirectLocationUrlParameters)) {
                url = ((String)url).contains("?") ? (String)url + "&" : (String)url + "?";
                url = (String)url + redirectLocationUrlParameters;
            }
            return url;
        }
        return redirectLocationUrlParam;
    }

    public static String buildCookiePassReversePath(TransportRequestContext transportRequestContext, String baseUrl, String cookiePathParam, String prefixGatewayUrl, String interfaceName) throws MalformedURLException {
        String r = baseUrl;
        if (r.contains("?")) {
            r = baseUrl.split("\\?")[0];
        }
        URL uri = new URL(r);
        Object rRelative = uri.getPath();
        String cookiePath = null;
        String cookieParameters = null;
        if (cookiePathParam.contains("?")) {
            String[] tmp = cookiePathParam.split("\\?");
            cookiePath = tmp[0];
            if (tmp.length > 1) {
                StringBuilder sbc = new StringBuilder();
                for (int i = 1; i < tmp.length; ++i) {
                    if (sbc.length() > 0) {
                        sbc.append("?");
                    }
                    sbc.append(tmp[i]);
                }
                cookieParameters = sbc.toString();
            }
        } else {
            cookiePath = cookiePathParam;
        }
        if (cookiePath.endsWith("/")) {
            if (!((String)rRelative).endsWith("/")) {
                rRelative = (String)rRelative + "/";
            }
        } else if (((String)rRelative).endsWith("/")) {
            Object object = rRelative = ((String)rRelative).length() <= 1 ? "" : ((String)rRelative).substring(0, ((String)rRelative).length() - 1);
        }
        if (cookiePath.startsWith((String)rRelative)) {
            Object contextPath = null;
            if (prefixGatewayUrl == null) {
                String protocollo;
                contextPath = transportRequestContext.getWebContext();
                if (!((String)contextPath).endsWith("/")) {
                    contextPath = (String)contextPath + "/";
                }
                if (!"@EMPTY@".equals(protocollo = transportRequestContext.getProtocolWebContext())) {
                    contextPath = (String)contextPath + protocollo + "/";
                }
                contextPath = (String)contextPath + transportRequestContext.getFunction();
            }
            String suffix = "";
            if (!cookiePath.equals(rRelative)) {
                suffix = cookiePath.substring(((String)rRelative).length());
            }
            StringBuilder bf = new StringBuilder();
            if (prefixGatewayUrl != null) {
                URL urlPrefixGatewayUrl = new URL(prefixGatewayUrl);
                String urlPrefixGatewayUrlAsString = urlPrefixGatewayUrl.getPath();
                bf.append(urlPrefixGatewayUrlAsString);
                if (!urlPrefixGatewayUrlAsString.endsWith("/")) {
                    bf.append("/");
                }
            } else {
                bf.append((String)contextPath);
                if (!((String)contextPath).endsWith("/")) {
                    bf.append("/");
                }
            }
            String interfaceNameTmp = null;
            interfaceNameTmp = interfaceName != null ? interfaceName : transportRequestContext.getInterfaceName();
            if (interfaceNameTmp != null) {
                if (interfaceNameTmp.startsWith("/")) {
                    if (interfaceNameTmp.length() > 1) {
                        bf.append(interfaceNameTmp.substring(1));
                    }
                } else {
                    bf.append(interfaceNameTmp);
                }
            }
            if (suffix.equals("")) {
                if (cookiePath.endsWith("/") && !bf.toString().endsWith("/")) {
                    bf.append("/");
                }
            } else {
                if (!suffix.startsWith("/")) {
                    bf.append("/");
                }
                bf.append(suffix);
            }
            Object url = bf.toString();
            if (cookieParameters != null && !"".equals(cookieParameters)) {
                url = ((String)url).contains("?") ? (String)url + "&" : (String)url + "?";
                url = (String)url + cookieParameters;
            }
            return url;
        }
        return cookiePath;
    }

    public static String buildCookiePassReverseDomain(TransportRequestContext transportRequestContext, String baseUrl, String cookieDomain, String prefixGatewayUrl) throws MalformedURLException {
        String r = baseUrl;
        if (r.contains("?")) {
            r = baseUrl.split("\\?")[0];
        }
        URL uri = new URL(r);
        String rDomain = uri.getHost();
        if (cookieDomain != null && cookieDomain.equalsIgnoreCase(rDomain)) {
            String newDomain = null;
            if (prefixGatewayUrl == null) {
                HttpServletTransportRequestContext http;
                if (transportRequestContext != null && transportRequestContext instanceof HttpServletTransportRequestContext && (http = (HttpServletTransportRequestContext)transportRequestContext).getHttpServletRequest() != null) {
                    String requestUrl = http.getHttpServletRequest().getRequestURL().toString();
                    URL uriRequestUrl = new URL(requestUrl);
                    newDomain = uriRequestUrl.getHost();
                }
            } else {
                URL uriRequestUrl = new URL(prefixGatewayUrl);
                newDomain = uriRequestUrl.getHost();
            }
            if (newDomain != null) {
                return newDomain;
            }
            return cookieDomain;
        }
        return cookieDomain;
    }
}

