/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.io.output.CountingOutputStream;
import org.openspcoop2.message.OpenSPCoop2DataContentHandler;
import org.openspcoop2.message.OpenSPCoop2DataContentHandlerInputStream;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.dch.InputStreamDataSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TunnelSoapUtils {
    public static void allegaBody(OpenSPCoop2Message message, String ns) throws MessageException {
        if (!ServiceBinding.SOAP.equals(message.getServiceBinding())) {
            throw new MessageException("Funzionalita 'ScartaBody' valida solamente per Service Binding SOAP");
        }
        OpenSPCoop2SoapMessage soapMessage = message.castAsSoap();
        try {
            if (soapMessage.countAttachments() > 0) {
                throw new MessageException("La funzionalita' non e' permessa per messaggi SOAP With Attachments");
            }
            SOAPBody body = soapMessage.getSOAPPart().getEnvelope().getBody();
            if (body == null) {
                throw new Exception("Body non presente");
            }
            if (body.hasFault()) {
                throw new Exception("Body contenente un SOAPFault");
            }
            List<Node> listNode = SoapUtils.getNotEmptyChildNodes(message.getFactory(), (Node)body, false);
            boolean bodyWithMultiRootElement = false;
            if (listNode != null && listNode.size() > 1) {
                bodyWithMultiRootElement = true;
            }
            byte[] bodySbustato = TunnelSoapUtils.sbustamentoSOAPEnvelope(message.getFactory(), soapMessage.getSOAPPart().getEnvelope());
            AttachmentPart ap = null;
            if (bodyWithMultiRootElement) {
                InputStreamDataSource isSource = new InputStreamDataSource("MultiRootElement", "application/octet-stream", bodySbustato);
                ap = soapMessage.createAttachmentPart(new DataHandler((DataSource)isSource));
            } else {
                Element e = null;
                try {
                    e = MessageXMLUtils.getInstance(message.getFactory()).newElement(bodySbustato);
                    DOMSource streamSource = new DOMSource(e);
                    ap = soapMessage.createAttachmentPart();
                    ap.setContent((Object)streamSource, "text/xml");
                }
                catch (Exception eParse) {
                    InputStreamDataSource isSource = new InputStreamDataSource("BodyNotParsable", "application/octet-stream", bodySbustato);
                    ap = soapMessage.createAttachmentPart(new DataHandler((DataSource)isSource));
                }
            }
            ap.setContentId(soapMessage.createContentID(ns));
            soapMessage.addAttachmentPart(ap);
            soapMessage.getSOAPPart().addMimeHeader("Content-ID", soapMessage.createContentID(ns));
            soapMessage.getSOAPBody().removeContents();
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static boolean isTunnelOpenSPCoopSoap(OpenSPCoop2SoapMessage message) throws MessageException, MessageNotSupportedException {
        return TunnelSoapUtils.isTunnelOpenSPCoopSoap(message.getFactory(), message.getSOAPBody());
    }

    public static boolean isTunnelOpenSPCoopSoap(OpenSPCoop2MessageFactory messageFactory, SOAPBody body) {
        List<Node> bodyChildren = SoapUtils.getNotEmptyChildNodes(messageFactory, (Node)body);
        return body != null && bodyChildren.size() > 0 && bodyChildren.get(0) != null && "SOAPTunnel".equals(bodyChildren.get(0).getLocalName()) && "http://www.govway.org/out/xml2soap".equals(bodyChildren.get(0).getNamespaceURI()) && "GovWay".equals(bodyChildren.get(0).getPrefix());
    }

    public static String getContentTypeTunnelOpenSPCoopSoap(SOAPBody body) throws MessageException {
        if (body != null && body.hasChildNodes()) {
            return ((SOAPElement)body.getChildElements().next()).getValue();
        }
        throw new MessageException("Body non presente");
    }

    public static void sbustamentoMessaggio(OpenSPCoop2Message msgParam, OutputStream streamParam) throws MessageException, MessageNotSupportedException {
        if (!MessageType.SOAP_11.equals(msgParam.getMessageType()) && !MessageType.SOAP_12.equals(msgParam.getMessageType())) {
            throw MessageNotSupportedException.newMessageNotSupportedException(msgParam.getMessageType());
        }
        OpenSPCoop2SoapMessage msg = msgParam.castAsSoap();
        CountingOutputStream cout = null;
        try {
            cout = new CountingOutputStream(streamParam);
            if (msg.countAttachments() == 0) {
                SOAPBody bd = msg.getSOAPBody();
                if (bd.hasFault()) {
                    SOAPFault fault = bd.getFault();
                    cout.write(msg.getAsByte((Node)fault, true));
                } else {
                    Iterator it = bd.getChildElements();
                    while (it.hasNext()) {
                        Object bodyObject = it.next();
                        if (!(bodyObject instanceof SOAPElement)) continue;
                        SOAPElement bodyElement = (SOAPElement)bodyObject;
                        cout.write(msg.getAsByte((Node)bodyElement, true));
                    }
                }
            } else {
                SOAPBody body = msg.getSOAPBody();
                if (TunnelSoapUtils.isTunnelOpenSPCoopSoap(msgParam.getFactory(), body)) {
                    AttachmentPart ap = (AttachmentPart)msg.getAttachments().next();
                    Object o = ap.getContent();
                    InputStream inputDH = null;
                    if (o instanceof OpenSPCoop2DataContentHandlerInputStream) {
                        inputDH = (OpenSPCoop2DataContentHandlerInputStream)o;
                    } else if (o instanceof InputStream) {
                        inputDH = (InputStream)OpenSPCoop2DataContentHandler.getContent((InputStream)o);
                    } else if (o instanceof byte[]) {
                        inputDH = (InputStream)OpenSPCoop2DataContentHandler.getContent(new ByteArrayInputStream((byte[])o));
                    } else {
                        throw new Exception("Tipo non gestito: " + o.getClass().getName());
                    }
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    byte[] readB = new byte[8192];
                    int readByte = 0;
                    while ((readByte = inputDH.read(readB)) != -1) {
                        bout.write(readB, 0, readByte);
                    }
                    inputDH.close();
                    bout.close();
                    cout.write(bout.toByteArray());
                } else {
                    ByteArrayOutputStream sbustamentoAttachments = new ByteArrayOutputStream();
                    msg.writeTo(sbustamentoAttachments, true);
                    String msgString = sbustamentoAttachments.toString();
                    byte[] msgByte = sbustamentoAttachments.toByteArray();
                    String soapEnvelopeStart = "<" + msg.getSOAPPart().getEnvelope().getPrefix() + ":" + msg.getSOAPPart().getEnvelope().getLocalName();
                    String xmlTagDecode = "<?xml";
                    String soapEnvelopeStop = "</" + msg.getSOAPPart().getEnvelope().getPrefix() + ":" + msg.getSOAPPart().getEnvelope().getLocalName() + ">";
                    if (msgString.indexOf(xmlTagDecode) != -1) {
                        cout.write(msgByte, 0, msgString.indexOf(xmlTagDecode));
                    } else {
                        cout.write(msgByte, 0, msgString.indexOf(soapEnvelopeStart));
                    }
                    SOAPBody bd = msg.getSOAPBody();
                    if (bd.hasFault()) {
                        SOAPFault fault = bd.getFault();
                        cout.write(msg.getAsByte((Node)fault, true));
                    } else {
                        cout.write(msg.getAsByte(msg.getFirstChildElement((SOAPElement)bd), true));
                    }
                    int indexOf = msgString.indexOf(soapEnvelopeStop) + soapEnvelopeStop.length();
                    cout.write(msgByte, indexOf, msgByte.length - indexOf);
                }
            }
            msg.updateIncomingMessageContentLength();
            cout.flush();
            msg.updateOutgoingMessageContentLength(cout.getByteCount());
        }
        catch (MessageException e) {
            throw e;
        }
        catch (MessageNotSupportedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException("Sbustamento msg_inputStream non riuscito: " + e.getMessage(), e);
        }
        finally {
            try {
                if (cout != null) {
                    cout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] sbustamentoMessaggio(OpenSPCoop2Message msg) throws MessageException, MessageNotSupportedException {
        ByteArrayOutputStream bodySbustato = new ByteArrayOutputStream();
        try {
            TunnelSoapUtils.sbustamentoMessaggio(msg, bodySbustato);
            return bodySbustato.toByteArray();
        }
        catch (MessageException e) {
            throw e;
        }
        catch (MessageNotSupportedException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (bodySbustato != null) {
                    bodySbustato.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new MessageException("Sbustamento msg non riuscito: " + e.getMessage(), e);
        }
    }

    public static byte[] sbustamentoSOAPEnvelope(OpenSPCoop2MessageFactory messageFactory, SOAPEnvelope env) throws MessageException, MessageNotSupportedException {
        return TunnelSoapUtils.sbustamentoSOAPEnvelope(messageFactory, env, true);
    }

    public static byte[] sbustamentoSOAPEnvelope(OpenSPCoop2MessageFactory messageFactory, SOAPEnvelope env, boolean consume) throws MessageException, MessageNotSupportedException {
        ByteArrayOutputStream bout = null;
        try {
            SOAPBody bd = env.getBody();
            byte[] body = null;
            if (bd.hasFault()) {
                SOAPFault fault = bd.getFault();
                body = OpenSPCoop2MessageFactory.getAsByte(messageFactory, (Node)fault, consume);
            } else {
                bout = new ByteArrayOutputStream();
                Iterator it = bd.getChildElements();
                while (it.hasNext()) {
                    Object bodyElementObj = it.next();
                    if (!(bodyElementObj instanceof SOAPElement)) continue;
                    SOAPElement bodyElement = (SOAPElement)bodyElementObj;
                    bout.write(OpenSPCoop2MessageFactory.getAsByte(messageFactory, (Node)bodyElement, consume));
                }
                bout.flush();
                bout.close();
                body = bout.toByteArray();
                bout = null;
            }
            byte[] byArray = body;
            return byArray;
        }
        catch (Exception e) {
            throw new MessageException("Sbustamento SoapEnvelope non riuscito: " + e.getMessage(), e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static OpenSPCoop2Message imbustamentoMessaggioConAttachment(OpenSPCoop2MessageFactory messageFactory, MessageType messageType, MessageRole messageRole, InputStream inputBody, String tipoAttachment, boolean buildAsDataHandler, String contentTypeMessaggioOriginale, String ns) throws MessageException, MessageNotSupportedException {
        if (!MessageType.SOAP_11.equals(messageType) && !MessageType.SOAP_12.equals(messageType)) {
            throw MessageNotSupportedException.newMessageNotSupportedException(messageType);
        }
        try {
            ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
            CopyStream.copy((InputStream)inputBody, (OutputStream)byteBuffer);
            inputBody.close();
            if (byteBuffer.size() == 0) {
                throw new MessageException("Contenuto da imbustare non presente");
            }
            return TunnelSoapUtils.imbustamentoMessaggioConAttachment(messageFactory, messageType, messageRole, byteBuffer.toByteArray(), tipoAttachment, buildAsDataHandler, contentTypeMessaggioOriginale, ns);
        }
        catch (MessageException e) {
            throw e;
        }
        catch (MessageNotSupportedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException("Imbustamento msgConAttachment_inputStream non riuscito: " + e.getMessage(), e);
        }
    }

    public static OpenSPCoop2Message imbustamentoMessaggioConAttachment(OpenSPCoop2MessageFactory messageFactory, MessageType messageType, MessageRole messageRole, byte[] inputBody, String tipoAttachment, boolean buildAsDataHandler, String contentTypeMessaggioOriginale, String ns) throws MessageException, MessageNotSupportedException {
        if (!MessageType.SOAP_11.equals(messageType) && !MessageType.SOAP_12.equals(messageType)) {
            throw MessageNotSupportedException.newMessageNotSupportedException(messageType);
        }
        OpenSPCoop2Message msg = null;
        try {
            msg = messageFactory.createEmptyMessage(messageType, messageRole);
            return TunnelSoapUtils.imbustamentoMessaggioConAttachment(msg, inputBody, tipoAttachment, buildAsDataHandler, contentTypeMessaggioOriginale, ns);
        }
        catch (MessageException e) {
            throw e;
        }
        catch (MessageNotSupportedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException("Imbustamento msgConAttachment_inputStream non riuscito: " + e.getMessage(), e);
        }
    }

    public static OpenSPCoop2Message imbustamentoMessaggioConAttachment(OpenSPCoop2Message msgParam, byte[] inputBody, String tipoAttachment, boolean buildAsDataHandler, String contentTypeMessaggioOriginale, String ns) throws MessageException, MessageNotSupportedException {
        if (!MessageType.SOAP_11.equals(msgParam.getMessageType()) && !MessageType.SOAP_12.equals(msgParam.getMessageType())) {
            throw MessageNotSupportedException.newMessageNotSupportedException(msgParam.getMessageType());
        }
        OpenSPCoop2SoapMessage msg = msgParam.castAsSoap();
        try {
            if (inputBody == null || inputBody.length <= 0) {
                throw new UtilsException("Contenuto da imbustare non presente");
            }
            SOAPBody soapBody = msg.getSOAPBody();
            QName name = null;
            name = "application/openspcoop2".equals(tipoAttachment) ? new QName("http://www.govway.org/out/xml2soap", "SOAPTunnel", "GovWay") : new QName("http://www.govway.org/out/xml2soap", "Attachments", "GovWay");
            SOAPElement bodyElement = soapBody.addChildElement(name);
            if ("application/openspcoop2".equals(tipoAttachment)) {
                if (contentTypeMessaggioOriginale == null) {
                    throw new Exception("ContentType messaggio per cui applicare il tunnel non definito?");
                }
                bodyElement.setValue(contentTypeMessaggioOriginale);
            }
            AttachmentPart ap = msg.createAttachmentPart();
            if (buildAsDataHandler) {
                ap.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(inputBody, tipoAttachment)));
                TunnelSoapUtils.saveAttachmentOpenSPCoop(ap);
            } else {
                ap.setRawContentBytes(inputBody, 0, inputBody.length, tipoAttachment);
            }
            ap.setContentId(msg.createContentID(ns));
            msg.addAttachmentPart(ap);
            return msg;
        }
        catch (MessageException e) {
            throw e;
        }
        catch (MessageNotSupportedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException("Imbustamento msgConAttachment_inputStream non riuscito: " + e.getMessage(), e);
        }
    }

    private static void saveAttachmentOpenSPCoop(AttachmentPart ap) throws MessageException {
        try {
            DataHandler dh = ap.getDataHandler();
            InputStream inputDH = dh.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] readB = new byte[8192];
            int readByte = 0;
            while ((readByte = inputDH.read(readB)) != -1) {
                bout.write(readB, 0, readByte);
            }
            inputDH.close();
            bout.flush();
            bout.close();
            ap.setDataHandler(new DataHandler((Object)bout.toByteArray(), ap.getContentType()));
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static OpenSPCoop2Message imbustamentoMessaggioConAttachment(OpenSPCoop2MessageFactory messageFactory, MessageType messageType, MessageRole messageRole, byte[] body, String contentTypeMessaggioOriginale, String ns) throws MessageException, MessageNotSupportedException {
        if (!MessageType.SOAP_11.equals(messageType) && !MessageType.SOAP_12.equals(messageType)) {
            throw MessageNotSupportedException.newMessageNotSupportedException(messageType);
        }
        OpenSPCoop2Message risposta = null;
        try {
            risposta = TunnelSoapUtils.imbustamentoMessaggioConAttachment(messageFactory, messageType, messageRole, body, "text/plain", false, contentTypeMessaggioOriginale, ns);
            return risposta;
        }
        catch (MessageException e) {
            throw e;
        }
        catch (MessageNotSupportedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException("Imbustamento msgConAttachment non riuscito: " + e.getMessage(), e);
        }
    }
}

