/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap.mtom;

import com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPPart;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.mtom.MtomXomPackageInfo;
import org.openspcoop2.message.soap.mtom.MtomXomReference;
import org.openspcoop2.message.xml.MessageDynamicNamespaceContextFactory;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XPathNotFoundException;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MTOMUtilities {
    public static boolean isMtom(String cType) throws MessageException {
        try {
            return ContentTypeUtilities.isMtom((String)cType);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static String readInternalMultipartMtomContentType(String contentType) throws MessageException {
        try {
            return MTOMUtilities.readInternalMultipartMtomContentType(new ContentType(contentType));
        }
        catch (MessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static String readInternalMultipartMtomContentType(ContentType contentType) throws MessageException {
        try {
            return ContentTypeUtilities.readInternalMultipartMtomContentType((ContentType)contentType);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static List<MtomXomReference> unpackaging(OpenSPCoop2Message msgParam, boolean fast, boolean body) throws MessageException, MessageNotSupportedException {
        if (!MessageType.SOAP_11.equals(msgParam.getMessageType()) && !MessageType.SOAP_12.equals(msgParam.getMessageType())) {
            throw MessageNotSupportedException.newMessageNotSupportedException(msgParam.getMessageType());
        }
        OpenSPCoop2SoapMessage message = msgParam.castAsSoap();
        try {
            ArrayList<MtomXomReference> list = new ArrayList<MtomXomReference>();
            Object element = null;
            element = body ? message.getSOAPBody() : message.getSOAPPart().getEnvelope();
            if (element == null) {
                return list;
            }
            boolean restoredXomReference = false;
            XPathExpressionEngine xpathEngine = new XPathExpressionEngine(msgParam.getFactory());
            DynamicNamespaceContext dnc = MessageDynamicNamespaceContextFactory.getInstance(msgParam.getFactory()).getNamespaceContext((Node)element);
            Object oNode = null;
            try {
                oNode = xpathEngine.getMatchPattern((Element)element, dnc, "//{http://www.w3.org/2004/08/xop/include}:Include", XPathReturnType.NODESET);
            }
            catch (XPathNotFoundException xPathNotFoundException) {
                // empty catch block
            }
            if (oNode == null) {
                return list;
            }
            if (!(oNode instanceof NodeList)) {
                throw new MessageException("XpathEngine (expr://{http://www.w3.org/2004/08/xop/include}:Include) return wrong type (expected: " + NodeList.class.getName() + "): " + oNode.getClass().getName());
            }
            NodeList nodeList = (NodeList)oNode;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node xomReference = nodeList.item(i);
                if (xomReference.getAttributes() == null || xomReference.getAttributes().getLength() <= 0) {
                    throw new MessageException("Found XOM Reference without attributes ('href' attribute required)");
                }
                Node xomHref = xomReference.getAttributes().getNamedItem("href");
                if (xomHref == null) {
                    throw new MessageException("Found XOM Reference without attribute 'href'");
                }
                String contentId = xomHref.getNodeValue();
                if (contentId == null) {
                    throw new MessageException("Found XOM Reference with attribute 'href' without value?");
                }
                if (contentId.startsWith("cid:")) {
                    contentId = contentId.substring("cid:".length());
                }
                MimeHeaders mhs = new MimeHeaders();
                mhs.addHeader("Content-ID", contentId);
                Iterator<?> itAttachments = message.getAttachments(mhs);
                if (itAttachments == null || !itAttachments.hasNext()) {
                    throw new MessageException("Found XOM Reference with attribute [href]=[" + contentId + "] but the message hasn't attachments");
                }
                AttachmentPart ap = null;
                while (itAttachments.hasNext()) {
                    if (ap != null) {
                        throw new MessageException("Found XOM Reference with attribute [href]=[" + contentId + "] but exists more than one attachment with same id");
                    }
                    ap = (AttachmentPart)itAttachments.next();
                }
                if (ap == null) {
                    throw new MessageException("Found XOM Reference with attribute [href]=[" + contentId + "] but not exists attachment with same id");
                }
                Node elementBase64Binary = xomReference.getParentNode();
                if (elementBase64Binary == null) {
                    throw new MessageException("Found XOM Reference without parent node?");
                }
                QName qname = new QName(elementBase64Binary.getNamespaceURI(), elementBase64Binary.getLocalName());
                String base64Binary = null;
                if (fast) {
                    base64Binary = Base64Utilities.encodeAsString((byte[])"FAST".getBytes());
                } else {
                    base64Binary = Utilities.getAsByteArrayOuputStream((InputStream)ap.getBase64Content()).toString();
                    message.removeAttachments(mhs);
                    restoredXomReference = true;
                }
                elementBase64Binary.removeChild(xomReference);
                elementBase64Binary.setTextContent(base64Binary);
                MtomXomReference reference = new MtomXomReference();
                reference.setNodeName(qname);
                reference.setXomReference(xomReference);
                reference.setNode(elementBase64Binary);
                reference.setContentId(contentId);
                list.add(reference);
            }
            if (restoredXomReference) {
                message.removeContentTypeParameter("type");
                message.removeContentTypeParameter("start-info");
                if (message.countAttachments() > 0) {
                    if (MessageType.SOAP_11.equals(message.getMessageType())) {
                        message.addContentTypeParameter("type", "text/xml");
                    } else if (MessageType.SOAP_12.equals(message.getMessageType())) {
                        message.addContentTypeParameter("type", "application/soap+xml");
                    }
                } else {
                    ContentType cType = null;
                    if (MessageType.SOAP_11.equals(message.getMessageType())) {
                        cType = new ContentType("text/xml");
                    } else if (MessageType.SOAP_12.equals(message.getMessageType())) {
                        cType = new ContentType("application/soap+xml");
                    }
                    String charsetParam = ContentTypeUtilities.readCharsetFromContentType((String)message.getContentType());
                    if (charsetParam != null && !"".equals(charsetParam) && cType != null) {
                        cType.setParameter("charset", charsetParam);
                    }
                    if (cType != null) {
                        message.setContentType(cType.toString());
                    }
                }
            }
            return list;
        }
        catch (MessageException e) {
            throw e;
        }
        catch (MessageNotSupportedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static List<MtomXomReference> packaging(OpenSPCoop2Message msgParam, List<MtomXomPackageInfo> packageInfos, boolean body) throws MessageException, MessageNotSupportedException {
        if (!MessageType.SOAP_11.equals(msgParam.getMessageType()) && !MessageType.SOAP_12.equals(msgParam.getMessageType())) {
            throw MessageNotSupportedException.newMessageNotSupportedException(msgParam.getMessageType());
        }
        OpenSPCoop2SoapMessage message = msgParam.castAsSoap();
        try {
            ArrayList<MtomXomReference> list = new ArrayList<MtomXomReference>();
            Object element = null;
            SOAPPart documentSOAPPart = message.getSOAPPart();
            element = body ? message.getSOAPBody() : message.getSOAPPart().getEnvelope();
            if (element == null) {
                return list;
            }
            XPathExpressionEngine xpathEngine = new XPathExpressionEngine(msgParam.getFactory());
            DynamicNamespaceContext dnc = MessageDynamicNamespaceContextFactory.getInstance(msgParam.getFactory()).getNamespaceContext((Node)element);
            boolean addAttachment = false;
            if (packageInfos == null || packageInfos.size() <= 0) {
                return list;
            }
            for (MtomXomPackageInfo mtomXomPackageInfo : packageInfos) {
                String xpathExpressionName = mtomXomPackageInfo.getName();
                String xpathExpression = mtomXomPackageInfo.getXpathExpression();
                Object oNode = null;
                try {
                    oNode = xpathEngine.getMatchPattern((Element)element, dnc, xpathExpression, XPathReturnType.NODESET);
                }
                catch (XPathNotFoundException xPathNotFoundException) {
                    // empty catch block
                }
                if (oNode == null) {
                    if (!mtomXomPackageInfo.isRequired()) continue;
                    throw new MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") not found reference");
                }
                if (!(oNode instanceof NodeList)) {
                    throw new MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") return wrong type (expected: " + NodeList.class.getName() + "): " + oNode.getClass().getName());
                }
                NodeList nodeList = (NodeList)oNode;
                if (nodeList.getLength() <= 0) {
                    if (!mtomXomPackageInfo.isRequired()) continue;
                    throw new MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") not found reference (node list is empty)");
                }
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String base64Content;
                    NamedNodeMap attr;
                    Node elementBase64Binary = nodeList.item(i);
                    if (MTOMUtilities.getIfExistsXomReference(msgParam.getFactory(), (Element)elementBase64Binary) != null) continue;
                    QName qname = new QName(elementBase64Binary.getNamespaceURI(), elementBase64Binary.getLocalName());
                    List<Node> elementBase64BinaryChilds = SoapUtils.getNotEmptyChildNodes(msgParam.getFactory(), elementBase64Binary, false);
                    if (elementBase64BinaryChilds != null && elementBase64BinaryChilds.size() > 0) {
                        throw new MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") found element (" + qname + ") with childs, mtom optimize packaging is only valid for base64Binary xsd element");
                    }
                    String contentTypeXMIMEAttribute = null;
                    if (elementBase64Binary.hasAttributes() && (attr = elementBase64Binary.getAttributes()) != null) {
                        for (int j = 0; j < attr.getLength(); ++j) {
                            Node n = attr.item(j);
                            String localName = n.getNodeName();
                            if (localName.contains(":")) {
                                localName = localName.split(":")[1];
                            }
                            if ("http://www.w3.org/2000/xmlns/".equals(n.getNamespaceURI()) && "xmlns".equals(localName)) continue;
                            if ("http://www.w3.org/2005/05/xmlmime".equals(n.getNamespaceURI()) && "contentType".equals(localName)) {
                                contentTypeXMIMEAttribute = n.getNodeValue();
                                continue;
                            }
                            throw new MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") found element (" + qname + ") with attribute ({" + n.getNamespaceURI() + "}" + localName + "), mtom optimize packaging is only valid for base64Binary xsd element (permit only {http://www.w3.org/2005/05/xmlmime}contentType)");
                        }
                    }
                    if ((base64Content = elementBase64Binary.getTextContent()) == null) {
                        throw new MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") found element (" + qname + ") without base64 value (textContent), mtom optimize packaging is only valid for base64Binary xsd element");
                    }
                    String contentId = null;
                    try {
                        AttachmentPart ap = message.createAttachmentPart();
                        String contentType = mtomXomPackageInfo.getContentType();
                        if (contentType == null) {
                            contentType = contentTypeXMIMEAttribute != null ? contentTypeXMIMEAttribute : "application/octet-stream";
                        }
                        ap.setContentId(message.createContentID("http://www.openspcoop2.org/core/mtom"));
                        contentId = ap.getContentId();
                        if (contentId.startsWith("<")) {
                            contentId = contentId.substring(1);
                        }
                        if (contentId.endsWith(">")) {
                            contentId = contentId.substring(0, contentId.length() - 1);
                        }
                        ap.setBase64Content((InputStream)new ByteArrayInputStream(base64Content.getBytes()), contentType);
                        message.addAttachmentPart(ap);
                        addAttachment = true;
                    }
                    catch (Exception e) {
                        throw new MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") found element (" + qname + ") with base64 value (textContent). Error occurs during mtom optimize packaging (decodeBase64/createAttach): " + e.getMessage(), e);
                    }
                    elementBase64Binary.setTextContent(null);
                    Element xomReference = documentSOAPPart.createElementNS("http://www.w3.org/2004/08/xop/include", "xop:Include");
                    xomReference.setAttribute("href", "cid:" + contentId);
                    elementBase64Binary.appendChild(xomReference);
                    MtomXomReference reference = new MtomXomReference();
                    reference.setNodeName(qname);
                    reference.setXomReference(xomReference);
                    reference.setNode(elementBase64Binary);
                    reference.setContentId(contentId);
                    list.add(reference);
                }
            }
            if (addAttachment) {
                message.addContentTypeParameter("type", "application/xop+xml");
                if (MessageType.SOAP_11.equals(message.getMessageType())) {
                    message.addContentTypeParameter("start-info", "text/xml");
                } else if (MessageType.SOAP_12.equals(message.getMessageType())) {
                    message.addContentTypeParameter("start-info", "application/soap+xml");
                }
            }
            return list;
        }
        catch (MessageException e) {
            throw e;
        }
        catch (MessageNotSupportedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static List<MtomXomReference> verify(OpenSPCoop2Message msgParam, List<MtomXomPackageInfo> packageInfos, boolean body) throws MessageException, MessageNotSupportedException {
        if (!MessageType.SOAP_11.equals(msgParam.getMessageType()) && !MessageType.SOAP_12.equals(msgParam.getMessageType())) {
            throw MessageNotSupportedException.newMessageNotSupportedException(msgParam.getMessageType());
        }
        OpenSPCoop2SoapMessage message = msgParam.castAsSoap();
        try {
            ArrayList<MtomXomReference> list = new ArrayList<MtomXomReference>();
            Object element = null;
            element = body ? message.getSOAPBody() : message.getSOAPPart().getEnvelope();
            if (element == null) {
                return list;
            }
            XPathExpressionEngine xpathEngine = new XPathExpressionEngine(msgParam.getFactory());
            DynamicNamespaceContext dnc = MessageDynamicNamespaceContextFactory.getInstance(msgParam.getFactory()).getNamespaceContext((Node)element);
            if (packageInfos == null || packageInfos.size() <= 0) {
                return list;
            }
            for (MtomXomPackageInfo mtomXomPackageInfo : packageInfos) {
                String xpathExpressionName = mtomXomPackageInfo.getName();
                String xpathExpression = mtomXomPackageInfo.getXpathExpression();
                Object oNode = null;
                try {
                    oNode = xpathEngine.getMatchPattern((Element)element, dnc, xpathExpression, XPathReturnType.NODESET);
                }
                catch (XPathNotFoundException xPathNotFoundException) {
                    // empty catch block
                }
                if (oNode == null) {
                    if (!mtomXomPackageInfo.isRequired()) continue;
                    throw new MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") not found reference");
                }
                if (!(oNode instanceof NodeList)) {
                    throw new MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") return wrong type (expected: " + NodeList.class.getName() + "): " + oNode.getClass().getName());
                }
                NodeList nodeList = (NodeList)oNode;
                if (nodeList.getLength() <= 0) {
                    if (!mtomXomPackageInfo.isRequired()) continue;
                    throw new MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") not found reference (node list is empty)");
                }
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    List<Node> nodeListBase64;
                    NamedNodeMap attr;
                    Node elementBase64Binary = nodeList.item(i);
                    QName qname = new QName(elementBase64Binary.getNamespaceURI(), elementBase64Binary.getLocalName());
                    if (elementBase64Binary.hasAttributes() && (attr = elementBase64Binary.getAttributes()) != null) {
                        for (int j = 0; j < attr.getLength(); ++j) {
                            Node n = attr.item(j);
                            String localName = n.getNodeName();
                            if (localName.contains(":")) {
                                localName = localName.split(":")[1];
                            }
                            if ("http://www.w3.org/2000/xmlns/".equals(n.getNamespaceURI()) && "xmlns".equals(localName) || "http://www.w3.org/2005/05/xmlmime".equals(n.getNamespaceURI()) && "contentType".equals(localName)) continue;
                            throw new MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") found element (" + qname + ") with attribute ({" + n.getNamespaceURI() + "}" + localName + "), mtom optimize packaging structure invalid");
                        }
                    }
                    if ((nodeListBase64 = SoapUtils.getNotEmptyChildNodes(msgParam.getFactory(), elementBase64Binary, false)) == null || nodeListBase64.size() <= 0) {
                        throw new MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") found element (" + qname + ") without childs, mtom optimize packaging require xop:Include element");
                    }
                    if (nodeListBase64.size() > 1) {
                        throw new MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") found element (" + qname + ") with more than one child, mtom optimize packaging structure invalid");
                    }
                    Node xomReference = nodeListBase64.get(0);
                    if (xomReference.getAttributes() == null || xomReference.getAttributes().getLength() <= 0) {
                        throw new MessageException("Found XOM Reference without attributes ('href' attribute required)");
                    }
                    Node xomHref = xomReference.getAttributes().getNamedItem("href");
                    if (xomHref == null) {
                        throw new MessageException("Found XOM Reference without attribute 'href'");
                    }
                    String contentId = xomHref.getNodeValue();
                    if (contentId == null) {
                        throw new MessageException("Found XOM Reference with attribute 'href' without value?");
                    }
                    if (contentId.startsWith("cid:")) {
                        contentId = contentId.substring("cid:".length());
                    }
                    MimeHeaders mhs = new MimeHeaders();
                    mhs.addHeader("Content-ID", contentId);
                    Iterator<?> itAttachments = message.getAttachments(mhs);
                    if (itAttachments == null || !itAttachments.hasNext()) {
                        throw new MessageException("Found XOM Reference with attribute [href]=[" + contentId + "] but the message hasn't attachments");
                    }
                    AttachmentPart ap = null;
                    while (itAttachments.hasNext()) {
                        if (ap != null) {
                            throw new MessageException("Found XOM Reference with attribute [href]=[" + contentId + "] but exists more than one attachment with same id");
                        }
                        ap = (AttachmentPart)itAttachments.next();
                    }
                    if (ap == null) {
                        throw new MessageException("Found XOM Reference with attribute [href]=[" + contentId + "] but not exists attachment with same id");
                    }
                    String contentType = mtomXomPackageInfo.getContentType();
                    if (contentType == null) {
                        contentType = "application/octet-stream";
                    }
                    if (ap.getContentType() == null) {
                        throw new MessageException("Found XOM Reference with attribute [href]=[" + contentId + "]. The attachment hasn't content-type");
                    }
                    String apCT = ap.getContentType();
                    String base = ContentTypeUtilities.readBaseTypeFromContentType((String)apCT);
                    if (!contentType.equals(base)) {
                        throw new MessageException("Found XOM Reference with attribute [href]=[" + contentId + "]. The attachment has wrong content-type (expected:" + contentType + "): " + ap.getContentType());
                    }
                    MtomXomReference reference = new MtomXomReference();
                    reference.setNodeName(qname);
                    reference.setXomReference(xomReference);
                    reference.setNode(elementBase64Binary);
                    reference.setContentId(contentId);
                    list.add(reference);
                }
            }
            return list;
        }
        catch (MessageException e) {
            throw e;
        }
        catch (MessageNotSupportedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static void restoreAfterFastUnpackaging(OpenSPCoop2Message msgParam, List<MtomXomReference> references, boolean body) throws MessageException, MessageNotSupportedException {
        if (!MessageType.SOAP_11.equals(msgParam.getMessageType()) && !MessageType.SOAP_12.equals(msgParam.getMessageType())) {
            throw MessageNotSupportedException.newMessageNotSupportedException(msgParam.getMessageType());
        }
        OpenSPCoop2SoapMessage message = msgParam.castAsSoap();
        try {
            Object element = null;
            element = body ? message.getSOAPBody() : message.getSOAPPart().getEnvelope();
            if (element == null) {
                return;
            }
            if (references == null || references.size() <= 0) {
                return;
            }
            for (MtomXomReference mtomXomReference : references) {
                if (mtomXomReference.getNode() == null) {
                    throw new MessageException("XomReference [" + mtomXomReference.getNodeName() + "] with undefined node");
                }
                if (mtomXomReference.getXomReference() == null) {
                    throw new MessageException("XomReference [" + mtomXomReference.getNodeName() + "] with undefined xomRerefence");
                }
                mtomXomReference.getNode().setTextContent(null);
                mtomXomReference.getNode().appendChild(mtomXomReference.getXomReference());
            }
        }
        catch (MessageException e) {
            throw e;
        }
        catch (MessageNotSupportedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static Element getIfExistsXomReference(OpenSPCoop2MessageFactory messageFactory, Element element) {
        try {
            Node n = SoapUtils.getFirstNotEmptyChildNode(messageFactory, element, false);
            if ("Include".equals(n.getLocalName()) && "http://www.w3.org/2004/08/xop/include".equals(n.getNamespaceURI())) {
                return (Element)n;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCidXomReference(Element element) throws MessageException {
        if (element.getAttributes() == null || element.getAttributes().getLength() <= 0) {
            throw new MessageException("Found XOM Reference without attributes ('href' attribute required)");
        }
        Node xomHref = element.getAttributes().getNamedItem("href");
        if (xomHref == null) {
            throw new MessageException("Found XOM Reference without attribute 'href'");
        }
        String contentId = xomHref.getNodeValue();
        if (contentId == null) {
            throw new MessageException("Found XOM Reference with attribute 'href' without value?");
        }
        if (contentId.startsWith("cid:")) {
            contentId = contentId.substring("cid:".length());
        }
        return contentId;
    }

    public static AttachmentPart getAttachmentPart(OpenSPCoop2Message msgParam, String cidReference) throws MessageException, MessageNotSupportedException {
        if (!MessageType.SOAP_11.equals(msgParam.getMessageType()) && !MessageType.SOAP_12.equals(msgParam.getMessageType())) {
            throw MessageNotSupportedException.newMessageNotSupportedException(msgParam.getMessageType());
        }
        OpenSPCoop2SoapMessage message = msgParam.castAsSoap();
        MimeHeaders mhs = new MimeHeaders();
        mhs.addHeader("Content-ID", cidReference);
        Iterator<?> itAttachments = message.getAttachments(mhs);
        if (itAttachments == null || !itAttachments.hasNext()) {
            throw new MessageException("Found XOM Reference with attribute [href]=[" + cidReference + "] but the message hasn't attachments");
        }
        AttachmentPart ap = null;
        while (itAttachments.hasNext()) {
            if (ap != null) {
                throw new MessageException("Found XOM Reference with attribute [href]=[" + cidReference + "] but exists more than one attachment with same id");
            }
            ap = (AttachmentPart)itAttachments.next();
        }
        if (ap == null) {
            throw new MessageException("Found XOM Reference with attribute [href]=[" + cidReference + "] but not exists attachment with same id");
        }
        return ap;
    }
}

