/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap.reader.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeader;
import org.openspcoop2.message.AbstractBaseOpenSPCoop2MessageDynamicContent;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.AbstractOpenSPCoop2Message_saaj_impl;
import org.openspcoop2.message.soap.AbstractOpenSPCoop2Message_soap_impl;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.message.soap.reader.test.ReaderTest;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.instrument.InstrumentationUtils;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.xml.XMLDiff;
import org.openspcoop2.utils.xml.XMLDiffImplType;
import org.openspcoop2.utils.xml.XMLDiffOptions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OptimizedHeaderTest {
    private static File fTmp = null;
    private static List<Exception> excTooBig = new ArrayList<Exception>();
    private static int MAX_EXC = 0;
    private static long HEAP_MEMORY_SIZE = -1L;
    private static boolean print_message = false;
    private static int maxIterations = 100;
    private static String ID_SOAP_ENVELOPE_MULTIPART = "<56D2051AED8F9598BB61721D8C95BA6F>";
    private static boolean testHeap = false;
    private static long dimensioneOggetto = -1L;
    private static Runtime runtime = null;
    private static long precedenteCalcolo = -1L;
    private static long skip = 0L;
    private static List<String> error = new ArrayList<String>();
    private static boolean printAllIterations = false;

    public static void main(String[] args) throws Exception {
        OptimizedHeaderTest.test(args);
    }

    public static void test() throws Exception {
        OptimizedHeaderTest.test(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(String[] args) throws Exception {
        Integer testDimensioneKb = null;
        if (args != null && args.length > 0) {
            testHeap = Boolean.valueOf(args[0]);
            if (testHeap) {
                runtime = Runtime.getRuntime();
            }
            if (args.length > 1) {
                maxIterations = Integer.valueOf(args[1]);
            }
            if (args.length > 2) {
                testDimensioneKb = Integer.valueOf(args[2]);
            }
            HEAP_MEMORY_SIZE = args.length > 3 ? Long.valueOf(args[3]) * 1024L * 1024L : 0x6400000L;
        } else {
            HEAP_MEMORY_SIZE = 0x6400000L;
        }
        int buffer_dimensione_default = 10;
        String contentTypeSoap11 = "text/xml; charset=UTF-8";
        String contentTypeSoap12 = "application/soap+xml; charset=UTF-8";
        String _prefixContentTypeWithAttachments = "multipart/related;   boundary=\"----=_Part_0_6330713.1171639717331\";   type=\"";
        String contentTypeSoap11WithAttachments = _prefixContentTypeWithAttachments + "text/xml\"";
        String contentTypeSoap12WithAttachments = _prefixContentTypeWithAttachments + "application/soap+xml\"";
        try {
            fTmp = File.createTempFile("testsuiteOptimizedHeader", ".bin");
            if (testDimensioneKb == null || testDimensioneKb < 0) {
                System.out.println("\n\n*** TEST SOAP 11 da 5K (buffer 1k) ***");
                OptimizedHeaderTest.test("request5K_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, 1, true);
                System.out.println("\n\n*** TEST SOAP 12 da 5K (buffer 1k) ***");
                OptimizedHeaderTest.test("request5K_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, 1, true);
                System.out.println("\n\n*** TEST SOAP 11 da 5K (unica riga) (buffer 1k) ***");
                OptimizedHeaderTest.test("request5K_unicaRiga_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, 1, true);
                System.out.println("\n\n*** TEST SOAP 12 da 5K (unica riga) (buffer 1k) ***");
                OptimizedHeaderTest.test("request5K_unicaRiga_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, 1, true);
                System.out.println("\n\n*** TEST SOAP 11 con Header 5K (buffer 1k) ***");
                OptimizedHeaderTest.test("requestHeader5K_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, 1, false);
                System.out.println("\n\n*** TEST SOAP 12 con Header 5K (buffer 1k) ***");
                OptimizedHeaderTest.test("requestHeader5K_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, 1, false);
                System.out.println("\n\n*** TEST SOAP 11 con Header 5K (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestHeader5K_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 con Header 5K (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestHeader5K_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 con Header 5K (unica riga) (buffer 1k) ***");
                OptimizedHeaderTest.test("requestHeader5K_unicaRiga_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, 1, false);
                System.out.println("\n\n*** TEST SOAP 12 con Header 5K (unica riga) (buffer 1k) ***");
                OptimizedHeaderTest.test("requestHeader5K_unicaRiga_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, 1, false);
                System.out.println("\n\n*** TEST SOAP 11 con Header 5K (unica riga) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestHeader5K_unicaRiga_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 con Header 5K (unica riga) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestHeader5K_unicaRiga_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 con Header 5K e Body 5K (buffer 1k) ***");
                OptimizedHeaderTest.test("requestHeader5KBody5K_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, 1, false);
                System.out.println("\n\n*** TEST SOAP 12 con Header 5K e Body 5K (buffer 1k) ***");
                OptimizedHeaderTest.test("requestHeader5KBody5K_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, 1, false);
                System.out.println("\n\n*** TEST SOAP 11 con Header 5K e Body 5K (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestHeader5KBody5K_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 con Header 5K e Body 5K (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestHeader5KBody5K_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 con Header 5K e Body 5K (unica riga) (buffer 1k) ***");
                OptimizedHeaderTest.test("requestHeader5KBody5K_unicaRiga_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, 1, false);
                System.out.println("\n\n*** TEST SOAP 12 con Header 5K e Body 5K (unica riga) (buffer 1k) ***");
                OptimizedHeaderTest.test("requestHeader5KBody5K_unicaRiga_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, 1, false);
                System.out.println("\n\n*** TEST SOAP 11 con Header 5K e Body 5K (unica riga) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestHeader5KBody5K_unicaRiga_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 con Header 5K e Body 5K (unica riga) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestHeader5KBody5K_unicaRiga_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 con prefisso SOAP vuoto (buffer 1k) ***");
                OptimizedHeaderTest.test("requestSoapPrefixEmpty_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, 1, true);
                System.out.println("\n\n*** TEST SOAP 12 con prefisso SOAP vuoto (buffer 1k) ***");
                OptimizedHeaderTest.test("requestSoapPrefixEmpty_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, 1, true);
                System.out.println("\n\n*** TEST SOAP 11 con prefisso SOAP vuoto e Header (buffer 1k) ***");
                OptimizedHeaderTest.test("requestSoapPrefixEmptyWithHeader_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, 1, true);
                System.out.println("\n\n*** TEST SOAP 12 con prefisso SOAP vuoto e Header (buffer 1k) ***");
                OptimizedHeaderTest.test("requestSoapPrefixEmptyWithHeader_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, 1, true);
                System.out.println("\n\n*** TEST SOAP 11 con prefissi SOAP vari con Header (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestMixedPrefix_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 con prefissi SOAP vari con Header (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestMixedPrefix_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 tutto su una riga con soap body vuoto (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestSuUnaRigaSoapBodyVuoto_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 tutto su una riga con soap body vuoto (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestSuUnaRigaSoapBodyVuoto_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 soap body vuoto (caso1) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestEmpty1_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 soap body vuoto (caso1) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestEmpty1_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 soap body vuoto (caso2) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestEmpty2_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 soap body vuoto (caso2) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestEmpty2_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 soap body vuoto (caso3) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestEmpty3_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 soap body vuoto (caso3) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestEmpty3_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 con request short senza header (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestShort_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 con request short senza header (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestShort_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 con request short con header vuoto (caso1) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestShortHeaderEmpty1_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 con request short con header vuoto (caso1) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestShortHeaderEmpty1_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 con request short con header vuoto (caso2) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestShortHeaderEmpty2_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 con request short con header vuoto (caso2) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestShortHeaderEmpty2_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 con request short con header vuoto (caso3) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestShortHeaderEmpty3_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 con request short con header vuoto (caso3) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestShortHeaderEmpty3_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 soapFault (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("soapFault_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 soapFault (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("soapFault_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 soapFault con soap prefix empty (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("soapFaultSoapPrefixEmpty_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 soapFault con soap prefix empty (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("soapFaultSoapPrefixEmpty_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 soapFault con stack trace (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("soapFaultLong_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 soapFault con stack trace (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("soapFaultLong_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 struttura soapFault simile (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestSimileSoapFault_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 struttura soapFault simile (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestSimileSoapFault_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 struttura soapFault simile (empty prefix) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestSimileSoapFault2_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 struttura soapFault simile (empty prefix) (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestSimileSoapFault2_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 CDATA (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestAllCDATAHeaderBodyEmpty_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 CDATA (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestAllCDATAHeaderBodyEmpty_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 con prefissi SOAP vari con Header e CDATA (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestMixedPrefixAndCDATA_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 con prefissi SOAP vari con Header e CDATA (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestMixedPrefixAndCDATA_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 XmlEntity (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestHeaderBodyXmlEntity_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 XmlEntity (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestHeaderBodyXmlEntity_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 XmlEntity OpenOnly (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestHeaderBodyXmlEntityOpenOnly_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 12 XmlEntity OpenOnly (buffer " + buffer_dimensione_default + "k) ***");
                OptimizedHeaderTest.test("requestHeaderBodyXmlEntityOpenOnly_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                System.out.println("\n\n*** TEST SOAP 11 XmlEntity CloseOnly (buffer " + buffer_dimensione_default + "k) ***");
                try {
                    OptimizedHeaderTest.test("requestHeaderBodyXmlEntityCloseOnly_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                    throw new Exception("Atteso errore");
                }
                catch (Throwable e) {
                    if (!e.getMessage().contains("Element type \"redro\" must be followed by either attribute specifications, \">\" or \"/>\".")) {
                        throw e;
                    }
                    System.out.println("Rilevato errore atteso: " + e.getMessage());
                    System.out.println("\n\n*** TEST SOAP 12 XmlEntity CloseOnly (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestHeaderBodyXmlEntityCloseOnly_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 11 con attachments (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestSOAPMultipartRelatedMIME_soap11.bin", contentTypeSoap11WithAttachments, MessageType.SOAP_11, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 12 con attachments (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestSOAPMultipartRelatedMIME_soap12.bin", contentTypeSoap12WithAttachments, MessageType.SOAP_12, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 11 con attachments (pdf) (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestSOAPMultipartRelatedMIMEpdf_soap11.bin", contentTypeSoap11WithAttachments, MessageType.SOAP_11, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 12 con attachments (pdf) (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestSOAPMultipartRelatedMIMEpdf_soap12.bin", contentTypeSoap12WithAttachments, MessageType.SOAP_12, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 11 con attachments (bodyEmpty) (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestSOAPMultipartRelatedMIMEbodyEmpty_soap11.bin", contentTypeSoap11WithAttachments, MessageType.SOAP_11, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 12 con attachments (bodyEmpty) (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestSOAPMultipartRelatedMIMEbodyEmpty_soap12.bin", contentTypeSoap12WithAttachments, MessageType.SOAP_12, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 11 '\\n' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestACapo_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 12 '\\n' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestACapo_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 11 '\\t' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestTab_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 12 '\\t' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestTab_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 11 rootElement '\\n' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestRootElementACapo_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 12 rootElement '\\n' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestRootElementACapo_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 11 rootElement '\\t' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestRootElementTab_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 12 rootElement '\\t' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestRootElementTab_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 11 header '\\n' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestHeaderACapo_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 12 header '\\n' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestHeaderACapo_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 11 header '\\t' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestHeaderTab_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 12 header '\\t' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestHeaderTab_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 11 fault '\\n' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestSoapFaultACapo_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 12 fault '\\n' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestSoapFaultACapo_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 11 fault '\\t' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestSoapFaultTab_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 12 fault '\\t' (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestSoapFaultTab_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 11 elemento > senza < (buffer " + buffer_dimensione_default + "k) ***");
                    try {
                        OptimizedHeaderTest.test("requestMalformed_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                        throw new Exception("Atteso errore");
                    }
                    catch (Throwable e2) {
                        if (!e2.getMessage().contains("Invalid content; found premature '>' character")) {
                            throw e2;
                        }
                        System.out.println("Rilevato errore atteso: " + e2.getMessage());
                        System.out.println("\n\n*** TEST SOAP 12 elemento > senza < (buffer " + buffer_dimensione_default + "k) ***");
                        try {
                            OptimizedHeaderTest.test("requestMalformed_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                            throw new Exception("Atteso errore");
                        }
                        catch (Throwable e3) {
                            if (!e3.getMessage().contains("Invalid content; found premature '>' character")) {
                                throw e3;
                            }
                            System.out.println("Rilevato errore atteso: " + e3.getMessage());
                            System.out.println("\n\n*** TEST SOAP 11 con attachments (carattere > prima di <) (buffer " + buffer_dimensione_default + "k) ***");
                            OptimizedHeaderTest.test("contentIdMalformedSOAPMultipartRelatedMIME_soap11.bin", contentTypeSoap11WithAttachments, MessageType.SOAP_11, buffer_dimensione_default, true);
                            System.out.println("\n\n*** TEST SOAP 12 con attachments (carattere > prima di <) (buffer " + buffer_dimensione_default + "k) ***");
                            OptimizedHeaderTest.test("contentIdMalformedSOAPMultipartRelatedMIME_soap12.bin", contentTypeSoap12WithAttachments, MessageType.SOAP_12, buffer_dimensione_default, true);
                            System.out.println("\n\n*** TEST SOAP 11 elemento body non corretto (buffer " + buffer_dimensione_default + "k) ***");
                            try {
                                OptimizedHeaderTest.test("requestBodyMalformed_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                                throw new Exception("Atteso errore");
                            }
                            catch (Throwable e4) {
                                if (!e4.getMessage().contains("Element type \"CONTENUTO_ERRATO\" must be followed by either attribute specifications, \">\" or \"/>\".")) {
                                    throw e4;
                                }
                                System.out.println("Rilevato errore atteso: " + e4.getMessage());
                                System.out.println("\n\n*** TEST SOAP 12 elemento body non corretto (buffer " + buffer_dimensione_default + "k) ***");
                                try {
                                    OptimizedHeaderTest.test("requestBodyMalformed_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                                    throw new Exception("Atteso errore");
                                }
                                catch (Throwable e5) {
                                    if (!e5.getMessage().contains("Element type \"CONTENUTO_ERRATO\" must be followed by either attribute specifications, \">\" or \"/>\".")) {
                                        throw e5;
                                    }
                                    System.out.println("Rilevato errore atteso: " + e5.getMessage());
                                    System.out.println("\n\n*** TEST SOAP 11 elemento body corretto (test2: chiusura senza apertura ammessa in xml) (buffer " + buffer_dimensione_default + "k) ***");
                                    OptimizedHeaderTest.test("requestBodyMalformed2_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                                    System.out.println("\n\n*** TEST SOAP 12 elemento body non corretto (test2: chiusura senza apertura ammessa in xml) (buffer " + buffer_dimensione_default + "k) ***");
                                    OptimizedHeaderTest.test("requestBodyMalformed2_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                                    System.out.println("\n\n*** TEST SOAP 11 elemento body non corretto (test3: /chiusura senza apertura ammessa in xml) (buffer " + buffer_dimensione_default + "k) ***");
                                    OptimizedHeaderTest.test("requestBodyMalformed3_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                                    System.out.println("\n\n*** TEST SOAP 12 elemento body non corretto (test3: /chiusura senza apertura ammessa in xml) (buffer " + buffer_dimensione_default + "k) ***");
                                    OptimizedHeaderTest.test("requestBodyMalformed3_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                                    System.out.println("\n\n*** TEST SOAP 11 elemento header non corretto (buffer " + buffer_dimensione_default + "k) ***");
                                    try {
                                        OptimizedHeaderTest.test("requestHeaderMalformed_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                                        throw new Exception("Atteso errore");
                                    }
                                    catch (Throwable e6) {
                                        if (!e6.getMessage().contains("Element type \"CONTENUTO_ERRATO\" must be followed by either attribute specifications, \">\" or \"/>\".")) {
                                            throw e6;
                                        }
                                        System.out.println("Rilevato errore atteso: " + e6.getMessage());
                                        System.out.println("\n\n*** TEST SOAP 12 elemento header non corretto (buffer " + buffer_dimensione_default + "k) ***");
                                        try {
                                            OptimizedHeaderTest.test("requestHeaderMalformed_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                                            throw new Exception("Atteso errore");
                                        }
                                        catch (Throwable e7) {
                                            if (!e7.getMessage().contains("Element type \"CONTENUTO_ERRATO\" must be followed by either attribute specifications, \">\" or \"/>\".")) {
                                                throw e7;
                                            }
                                            System.out.println("Rilevato errore atteso: " + e7.getMessage());
                                            System.out.println("\n\n*** TEST SPECIAL CASE SOAP 11 con BodyChildName (buffer 1k) ***");
                                            OptimizedHeaderTest.test("requestFirstChildNameBody_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, 1, true);
                                            System.out.println("\n\n*** TEST SPECIAL CASE SOAP 12 con BodyChildName (buffer 1k) ***");
                                            OptimizedHeaderTest.test("requestFirstChildNameBody_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, 1, true);
                                            System.out.println("\n\n*** TEST SPECIAL CASE SOAP 11 con BodyChildNameExact (buffer 1k) ***");
                                            OptimizedHeaderTest.test("requestFirstChildNameExactBody_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, 1, true);
                                            System.out.println("\n\n*** TEST SPECIAL CASE SOAP 12 con BodyChildNameExact (buffer 1k) ***");
                                            OptimizedHeaderTest.test("requestFirstChildNameExactBody_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, 1, true);
                                            System.out.println("\n\n*** TEST SPECIAL CASE SOAP 11 con HeaderChildName (buffer 1k) ***");
                                            OptimizedHeaderTest.test("requestFirstChildNameHeader_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, 1, true);
                                            System.out.println("\n\n*** TEST SPECIAL CASE SOAP 12 con HeaderChildName (buffer 1k) ***");
                                            OptimizedHeaderTest.test("requestFirstChildNameHeader_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, 1, true);
                                            System.out.println("\n\n*** TEST SPECIAL CASE SOAP 11 con HeaderChildNameExact (buffer 1k) ***");
                                            OptimizedHeaderTest.test("requestFirstChildNameExactHeader_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, 1, true);
                                            System.out.println("\n\n*** TEST SPECIAL CASE SOAP 12 con HeaderChildNameExact (buffer 1k) ***");
                                            OptimizedHeaderTest.test("requestFirstChildNameExactHeader_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, 1, true);
                                            System.out.println("\n\n*** TEST SPECIAL CASE SOAP 11 con XmlDeclaration a capo (buffer 1k) ***");
                                            OptimizedHeaderTest.test("requestXmlDeclarationACapo_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, 1, true);
                                            System.out.println("\n\n*** TEST SPECIAL CASE SOAP 12 con XmlDeclaration a capo (buffer 1k) ***");
                                            OptimizedHeaderTest.test("requestXmlDeclarationACapo_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, 1, true);
                                            System.out.println("\n\n*** TEST DichiarazioneCommentata SOAP12 , e messaggio SOAP 11 (buffer 1k) ***");
                                            OptimizedHeaderTest.test("requestSoap12Commentata_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, 1, true);
                                            System.out.println("\n\n*** TEST DichiarazioneCommentata SOAP11 , e messaggio SOAP 12 (buffer 1k) ***");
                                            OptimizedHeaderTest.test("requestSoap11Commentata_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, 1, true);
                                            System.out.println("\n\n*** TEST DichiarazioneCommentata SOAP12 (ACapo) , e messaggio SOAP 11 (buffer 1k) ***");
                                            OptimizedHeaderTest.test("requestSoap12CommentataACapo_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, 1, true);
                                            System.out.println("\n\n*** TEST DichiarazioneCommentata SOAP11 (ACapo) , e messaggio SOAP 12 (buffer 1k) ***");
                                            OptimizedHeaderTest.test("requestSoap11CommentataACapo_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, 1, true);
                                            System.out.println("\n\n*** TEST SOAP11 con vari commenti (buffer " + buffer_dimensione_default + "k) ***");
                                            OptimizedHeaderTest.test("requestHeaderBodyVariCommenti_soap11.xml", contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                                            System.out.println("\n\n*** TEST SOAP12 con vari commenti (buffer " + buffer_dimensione_default + "k) ***");
                                            OptimizedHeaderTest.test("requestHeaderBodyVariCommenti_soap12.xml", contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                                            System.out.println("\n\nTestsuite completata con successo");
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (testDimensioneKb == null || testDimensioneKb > 0) {
                System.out.println("\n\nTestsuite per dimensioni maggiori ...");
                ArrayList<Integer> dimensioni = new ArrayList<Integer>();
                if (testDimensioneKb != null && testDimensioneKb > 0) {
                    dimensioni.add(testDimensioneKb);
                } else {
                    dimensioni.add(50);
                    dimensioni.add(500);
                }
                for (Integer dimensione : dimensioni) {
                    System.out.println("\n\n*** TEST SOAP 11 da " + dimensione + "K (buffer 1k) ***");
                    OptimizedHeaderTest.test("request5K_soap11.xml", dimensione, contentTypeSoap11, MessageType.SOAP_11, 1, true);
                    System.out.println("\n\n*** TEST SOAP 12 da " + dimensione + "K (buffer 1k) ***");
                    OptimizedHeaderTest.test("request5K_soap12.xml", dimensione, contentTypeSoap12, MessageType.SOAP_12, 1, true);
                    if (dimensione > 2000) continue;
                    System.out.println("\n\n*** TEST SOAP 11 da " + dimensione + "K (unica riga) (buffer 1k) ***");
                    OptimizedHeaderTest.test("request5K_unicaRiga_soap11.xml", dimensione, contentTypeSoap11, MessageType.SOAP_11, 1, true);
                    System.out.println("\n\n*** TEST SOAP 12 da " + dimensione + "K (unica riga) (buffer 1k) ***");
                    OptimizedHeaderTest.test("request5K_unicaRiga_soap12.xml", dimensione, contentTypeSoap12, MessageType.SOAP_12, 1, true);
                    System.out.println("\n\n*** TEST SOAP 11 con Header 5K da " + dimensione + "K (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestHeader5K_soap11.xml", dimensione, contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 12 con Header 5K da " + dimensione + "K (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestHeader5K_soap12.xml", dimensione, contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 11 con Header 5K (unica riga) da " + dimensione + "K (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestHeader5K_unicaRiga_soap11.xml", dimensione, contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 12 con Header 5K (unica riga) da " + dimensione + "K (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestHeader5K_unicaRiga_soap12.xml", dimensione, contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 11 con Header 5K da " + dimensione + "K (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestHeader5KBody5K_soap11.xml", dimensione, contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 12 con Header 5K da " + dimensione + "K (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestHeader5KBody5K_soap12.xml", dimensione, contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 11 con Header 5K da " + dimensione + "K (unica riga) (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestHeader5KBody5K_unicaRiga_soap11.xml", dimensione, contentTypeSoap11, MessageType.SOAP_11, buffer_dimensione_default, true);
                    System.out.println("\n\n*** TEST SOAP 12 con Header 5K da " + dimensione + "K (buffer " + buffer_dimensione_default + "k) ***");
                    OptimizedHeaderTest.test("requestHeader5KBody5K_unicaRiga_soap12.xml", dimensione, contentTypeSoap12, MessageType.SOAP_12, buffer_dimensione_default, true);
                }
                System.out.println("\n\nTestsuite per dimensioni maggiori completata con successo");
            }
        }
        finally {
            if (fTmp != null && fTmp.exists()) {
                fTmp.delete();
            }
        }
    }

    private static InputStream getInputStream(String fileName, int kbBody, byte[] resource) throws Exception {
        if (fTmp.exists()) {
            fTmp.delete();
        }
        FileSystemUtilities.writeFile((File)fTmp, (byte[])resource);
        return new FileInputStream(fTmp);
    }

    private static void test(String fileName, String contentType, MessageType messageType, int bufferThresholdKb, boolean attesoComeOttimizzabile) throws Exception {
        OptimizedHeaderTest.test(fileName, -1, contentType, messageType, bufferThresholdKb, attesoComeOttimizzabile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test(String fileName, int kbBody, String contentType, MessageType messageType, int bufferThresholdKb, boolean attesoComeOttimizzabile) throws Exception {
        String check;
        String newString;
        String newHeader;
        long dimensione;
        StringBuilder sbDebug;
        ByteArrayOutputStream bout;
        SOAPElement soapElement;
        OpenSPCoop2SoapMessage soapMsg;
        OpenSPCoop2Message msg;
        OpenSPCoop2MessageParseResult parser;
        InputStream is;
        OpenSPCoop2MessageSoapStreamReader streamReader;
        InputStream isMessage;
        long rapporto_left_interval = 0L;
        long rapporto_min_saaj = 28L;
        long rapporto_max_saaj = 36L;
        long rapporto_min_dom = 5L;
        long rapporto_max_dom = 15L;
        long rapporto_min = 1L;
        long rapporto_stream_reader = 1L;
        long rapporto_min_after_header = 1L;
        long rapporto_stream_reader_after_header = 1L;
        long rapporto_write_to = 1L;
        long incremento_minimo_memoria = 1L;
        long tolleranza_bytes = 2048L;
        byte[] resource = Utilities.getAsByteArray((InputStream)ReaderTest.class.getResourceAsStream("/org/openspcoop2/message/soap/reader/test/" + fileName));
        OpenSPCoop2MessageFactory factory = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
        if (kbBody > 0) {
            System.out.println("Build new message ...");
            long bytes = (long)kbBody * 1024L;
            while ((long)resource.length < bytes) {
                MessageXMLUtils xmlUtils = MessageXMLUtils.getInstance(factory);
                Element envelope = xmlUtils.newElement(resource);
                NodeList l = envelope.getElementsByTagNameNS(envelope.getNamespaceURI(), "Body");
                Node body = l.item(0);
                Node node = MessageXMLUtils.getInstance(factory).getFirstNotEmptyChildNode(body);
                List children = xmlUtils.getNotEmptyChildNodes(node, false);
                for (int j = 0; j < children.size(); ++j) {
                    Node d = ((Node)children.get(j)).cloneNode(true);
                    node.appendChild(d);
                }
                resource = xmlUtils.toByteArray(envelope);
            }
            System.out.println("Builded: " + Utilities.convertBytesToFormatString((long)resource.length, (boolean)true, (String)" "));
        }
        String resourceAsString = new String(resource);
        long initial = OptimizedHeaderTest.print(0, "RisorsaRaw", resource, null, null, null);
        String defaultDomPrefix = MessageType.SOAP_11.equals(messageType) ? "SOAP-ENV" : "env";
        XMLDiffOptions xmlDiffOptions = new XMLDiffOptions();
        xmlDiffOptions.setIgnoreComments(true);
        xmlDiffOptions.setIgnoreDiffBetweenTextAndCDATA(true);
        xmlDiffOptions.setIgnoreWhitespace(true);
        xmlDiffOptions.setNormalize(false);
        XMLDiff xmlDiffEngine = new XMLDiff();
        xmlDiffEngine.initialize(XMLDiffImplType.XML_UNIT, xmlDiffOptions);
        TransportRequestContext req = new TransportRequestContext();
        HashMap parametriTrasporto = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        if (fileName.startsWith("requestSOAPMultipartRelatedMIMEpdf")) {
            String ctMultipartRefreshed = null;
            String ct = MessageType.SOAP_11.equals(messageType) ? "text/xml" : "application/soap+xml";
            ctMultipartRefreshed = ContentTypeUtilities.buildMultipartRelatedContentType((byte[])resource, (String)ct, (String)ID_SOAP_ENVELOPE_MULTIPART);
            list.add(ctMultipartRefreshed);
        } else {
            list.add(contentType);
        }
        parametriTrasporto.put("Content-Type", list);
        req.setHeaders(parametriTrasporto);
        Element envelope = null;
        if (!contentType.startsWith("multipart/related") && !fileName.startsWith("requestMalformed_soap")) {
            envelope = MessageXMLUtils.getInstance(factory).newElement(resource);
        }
        if (fileName.contains("Header5K") && !fileName.contains("requestHeader5KBody5K")) {
            rapporto_stream_reader = 2L;
        } else if (fileName.contains("requestHeader5KBody5K")) {
            rapporto_max_saaj = 39L;
        } else if (fileName.startsWith("requestMixedPrefixAndCDATA")) {
            rapporto_max_dom *= 3L;
            rapporto_min = 2L;
            rapporto_min_after_header = 3L;
            rapporto_min_saaj = 15L;
        } else if (fileName.startsWith("requestSoapPrefixEmpty") || fileName.startsWith("requestMixedPrefix")) {
            rapporto_max_dom *= 4L;
            rapporto_min = 3L;
            rapporto_stream_reader = 2L;
            rapporto_min_after_header = 7L;
            rapporto_min_saaj = 28L;
            rapporto_max_saaj = 46L;
        } else if (fileName.startsWith("requestEmpty") || fileName.startsWith("requestShort")) {
            rapporto_max_dom *= 35L;
            rapporto_stream_reader = 15L;
            rapporto_stream_reader_after_header = 45L;
            rapporto_write_to = 2L;
            rapporto_max_saaj = 70L;
            incremento_minimo_memoria = 10L;
        } else if (fileName.startsWith("soapFault_soap") || fileName.startsWith("soapFaultSoapPrefixEmpty_") || fileName.startsWith("requestSimileSoapFault")) {
            rapporto_max_dom *= 6L;
            incremento_minimo_memoria = 10L;
            rapporto_stream_reader = 3L;
            rapporto_stream_reader_after_header = 10L;
            rapporto_min_saaj = 20L;
        } else if (fileName.startsWith("soapFaultLong")) {
            rapporto_max_dom *= 6L;
            rapporto_min_saaj = 2L;
            tolleranza_bytes = 3072L;
        } else if (fileName.startsWith("requestAllCDATAHeaderBodyEmpty")) {
            rapporto_max_dom *= 6L;
            rapporto_min_saaj = 2L;
            rapporto_stream_reader_after_header = 3L;
            tolleranza_bytes = 3072L;
        } else if (fileName.startsWith("requestHeaderBodyXmlEntity")) {
            rapporto_max_dom *= 6L;
            rapporto_stream_reader_after_header = 3L;
            rapporto_min_saaj = 3L;
            tolleranza_bytes = 3072L;
        } else if (fileName.startsWith("requestSOAPMultipartRelatedMIME") || fileName.startsWith("contentIdMalformedSOAPMultipartRelatedMIME")) {
            rapporto_stream_reader = 2L;
            rapporto_stream_reader_after_header = 10L;
            rapporto_min_saaj = 18L;
        } else if (fileName.startsWith("requestACapo_")) {
            rapporto_max_dom *= 6L;
            rapporto_stream_reader = 3L;
            rapporto_stream_reader_after_header = 20L;
            rapporto_min_saaj = 20L;
            rapporto_max_saaj = 50L;
        } else if (fileName.contains("FirstChild")) {
            rapporto_max_dom *= 30L;
            rapporto_min = 10L;
            rapporto_min_after_header = 30L;
            rapporto_min_saaj = 20L;
            rapporto_max_saaj = 55L;
            tolleranza_bytes = 3072L;
        } else if (fileName.contains("requestXmlDeclarationACapo_")) {
            rapporto_max_dom *= 30L;
            rapporto_min = 10L;
            rapporto_min_after_header = 25L;
            rapporto_min_saaj = 20L;
            rapporto_max_saaj = 45L;
            tolleranza_bytes = 3072L;
        } else if (fileName.contains("requestSoap") && fileName.contains("Commentata")) {
            rapporto_max_dom *= 20L;
            rapporto_min = 10L;
            rapporto_min_after_header = 25L;
            rapporto_min_saaj = 20L;
            rapporto_max_saaj = 45L;
            tolleranza_bytes = 3072L;
        } else if (fileName.contains("requestHeaderBodyVariCommenti")) {
            rapporto_max_dom *= 4L;
            rapporto_stream_reader = 10L;
            rapporto_stream_reader_after_header = 25L;
            rapporto_min_saaj = 15L;
        } else if (fileName.startsWith("requestTab")) {
            rapporto_max_dom *= 6L;
            rapporto_stream_reader = 3L;
            rapporto_stream_reader_after_header = 15L;
            rapporto_min_saaj = 25L;
            rapporto_max_saaj = 45L;
        } else if (fileName.startsWith("requestRootElementACapo") || fileName.startsWith("requestRootElementTab") || fileName.startsWith("requestHeaderACapo") || fileName.startsWith("requestHeaderTab")) {
            rapporto_max_dom *= 8L;
            rapporto_stream_reader = 3L;
            rapporto_stream_reader_after_header = 15L;
            rapporto_min_saaj = 25L;
            rapporto_max_saaj = 45L;
        } else if (fileName.startsWith("requestSoapFaultACapo") || fileName.startsWith("requestSoapFaultTab")) {
            rapporto_max_dom *= 8L;
            rapporto_stream_reader = 3L;
            rapporto_stream_reader_after_header = 15L;
            rapporto_min_saaj = 20L;
            rapporto_max_saaj = 45L;
            tolleranza_bytes = 3072L;
        } else if (fileName.startsWith("requestBodyMalformed")) {
            rapporto_max_dom *= 20L;
            rapporto_stream_reader = 10L;
            rapporto_stream_reader_after_header = 30L;
            rapporto_min_saaj = 20L;
            rapporto_max_saaj = 50L;
            tolleranza_bytes = 3072L;
        } else if (fileName.startsWith("requestSuUnaRigaSoapBodyVuoto")) {
            rapporto_stream_reader = 2L;
        }
        if (kbBody > 50) {
            rapporto_min_dom = 3L;
        }
        if (envelope != null) {
            OptimizedHeaderTest.print(0, "DOM", envelope, initial, rapporto_min_dom, rapporto_max_dom);
        }
        ArrayList<OpenSPCoop2Message> contenitor = new ArrayList<OpenSPCoop2Message>();
        boolean wsa = "requestSoapPrefixEmptyWithHeader_soap11.xml".equals(fileName) || "requestSoapPrefixEmptyWithHeader_soap12.xml".equals(fileName);
        boolean mixed = "requestMixedPrefix_soap11.xml".equals(fileName) || "requestMixedPrefix_soap12.xml".equals(fileName);
        boolean shortHeader = fileName.startsWith("requestShortHeaderEmpty");
        boolean cdata = fileName.startsWith("requestAllCDATA");
        System.out.println("== TRASPARENTE ==");
        contenitor.clear();
        long rapporto = 1L;
        long iterazioniPossibili = HEAP_MEMORY_SIZE / initial / rapporto;
        if (!testHeap) {
            iterazioniPossibili = 1L;
        } else if (iterazioniPossibili > (long)maxIterations) {
            iterazioniPossibili = maxIterations;
        }
        int i = 0;
        while ((long)i < iterazioniPossibili) {
            OptimizedHeaderTest.printMemory(i, iterazioniPossibili, tolleranza_bytes);
            isMessage = OptimizedHeaderTest.getInputStream(fileName, kbBody, resource);
            try {
                streamReader = new OpenSPCoop2MessageSoapStreamReader(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), contentType, isMessage, bufferThresholdKb);
                is = null;
                try {
                    streamReader.read();
                    streamReader.checkException();
                }
                finally {
                    is = streamReader.getBufferedInputStream();
                }
                OptimizedHeaderTest.print(i, "StreamReader", streamReader, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min : rapporto_stream_reader);
                parser = factory.createMessage(messageType, req, is, null, streamReader);
                msg = parser.getMessage_throwParseException();
                OptimizedHeaderTest.print(i, "OpenSPCoop2Message-init", msg, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min : rapporto_stream_reader);
                if (!streamReader.isSoapHeaderOptimizable() && attesoComeOttimizzabile) {
                    throw new Exception("Atteso come ottimizzabile");
                }
                ByteArrayOutputStream bout2 = new ByteArrayOutputStream();
                StringBuilder sbDebug2 = new StringBuilder();
                ((AbstractBaseOpenSPCoop2MessageDynamicContent)msg).writeTo(bout2, true, false, null, sbDebug2);
                if (!"SERIALIZE-STREAM".equals(sbDebug2.toString())) {
                    throw new Exception("Attesa modalita di serializzazione 'SERIALIZE-STREAM'; riscontrata: " + sbDebug2.toString());
                }
                bout2.flush();
                bout2.close();
                if (i == 0 && print_message) {
                    System.out.println("WRITE: " + bout2.toString());
                }
                long dimensione2 = OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-write", msg, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min : rapporto_stream_reader);
                if (i == 0) {
                    OptimizedHeaderTest.saveDimensioneOggetto(dimensione2);
                }
                contenitor.add(msg);
                OptimizedHeaderTest.verificaConsistenza(contentType, factory, bout2, messageType, fileName);
                if (!resourceAsString.equals(bout2.toString())) {
                    throw new Exception("Contenuto serializzato differente: \nATTESO:\n[" + resourceAsString + "]\n GENERATO:\n[" + bout2.toString() + "]");
                }
                OptimizedHeaderTest.print(i, "finalResourceRaw", bout2.toByteArray(), initial, rapporto_left_interval, rapporto_write_to);
            }
            finally {
                if (isMessage != null) {
                    isMessage.close();
                }
            }
            ++i;
        }
        OptimizedHeaderTest.checkMemoryError();
        System.out.println("== HEADER ==");
        contenitor.clear();
        rapporto = 2L;
        iterazioniPossibili = HEAP_MEMORY_SIZE / initial / rapporto;
        if (!testHeap) {
            iterazioniPossibili = 1L;
        } else if (iterazioniPossibili > (long)maxIterations) {
            iterazioniPossibili = maxIterations;
        }
        i = 0;
        while ((long)i < iterazioniPossibili) {
            OptimizedHeaderTest.printMemory(i, iterazioniPossibili, tolleranza_bytes);
            isMessage = OptimizedHeaderTest.getInputStream(fileName, kbBody, resource);
            try {
                streamReader = new OpenSPCoop2MessageSoapStreamReader(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), contentType, isMessage, bufferThresholdKb);
                is = null;
                try {
                    streamReader.read();
                    streamReader.checkException();
                }
                finally {
                    is = streamReader.getBufferedInputStream();
                }
                OptimizedHeaderTest.print(i, "StreamReader", streamReader, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min : rapporto_stream_reader);
                parser = factory.createMessage(messageType, req, is, null, streamReader);
                msg = parser.getMessage_throwParseException();
                OptimizedHeaderTest.print(i, "OpenSPCoop2Message-init", msg, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min : rapporto_stream_reader);
                boolean isOptimizable = streamReader.isSoapHeaderOptimizable();
                if (!isOptimizable && attesoComeOttimizzabile) {
                    throw new Exception("Atteso come ottimizzabile");
                }
                soapMsg = msg.castAsSoap();
                SOAPHeader hdr = soapMsg.getSOAPHeader();
                if (hdr == null) {
                    hdr = soapMsg.getSOAPPart().getEnvelope().addHeader();
                }
                soapElement = hdr.addChildElement("PROVA", "test", "http://prova");
                if (isOptimizable) {
                    if (fileName.contains("Header5K") || fileName.startsWith("requestSuUnaRigaSoapBodyVuoto")) {
                        OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-header", msg, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min * 2L : rapporto_max_saaj);
                    } else if (fileName.startsWith("requestSoapPrefixEmptyWithHeader") || fileName.startsWith("requestMixedPrefix")) {
                        OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-header", msg, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min * 4L : rapporto_min * 4L);
                    } else {
                        OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-header", msg, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min_after_header : rapporto_stream_reader_after_header);
                    }
                } else {
                    OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-header", msg, initial, rapporto_min_saaj, rapporto_max_saaj);
                }
                bout = new ByteArrayOutputStream();
                sbDebug = new StringBuilder();
                ((AbstractBaseOpenSPCoop2MessageDynamicContent)msg).writeTo(bout, true, false, null, sbDebug);
                if (isOptimizable) {
                    if (!"SERIALIZE-STREAM-WITH-HEADER".equals(sbDebug.toString())) {
                        throw new Exception("Attesa modalita di serializzazione 'SERIALIZE-STREAM-WITH-HEADER'; riscontrata: " + sbDebug.toString());
                    }
                } else if (!"SERIALIZE-CONTENT".equals(sbDebug.toString())) {
                    throw new Exception("Attesa modalita di serializzazione 'SERIALIZE-CONTENT'; riscontrata: " + sbDebug.toString());
                }
                bout.flush();
                bout.close();
                if (i == 0 && print_message) {
                    System.out.println("WRITE AFTER HEADER: " + bout.toString());
                }
                dimensione = -1L;
                dimensione = isOptimizable ? OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-header-write", msg, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min : rapporto_stream_reader) : OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-header-write", msg, initial, rapporto_min_saaj, rapporto_max_saaj);
                if (i == 0) {
                    if (incremento_minimo_memoria > 1L) {
                        dimensione *= incremento_minimo_memoria;
                    }
                    OptimizedHeaderTest.saveDimensioneOggetto(dimensione);
                }
                contenitor.add(msg);
                OptimizedHeaderTest.verificaConsistenza(contentType, factory, bout, messageType, fileName);
                newHeader = OpenSPCoop2MessageFactory.getAsString(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (Node)soapElement, true);
                newString = null;
                if (isOptimizable) {
                    if (fileName.startsWith("requestHeaderBodyXmlEntityOpenOnly")) {
                        newString = resourceAsString.replace("</soapenv:Header>", newHeader + "</soapenv:Header>");
                        newString = newString.replace("<soapenv:Header>", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\">");
                        newString = newString.replaceFirst("<xsd:skcotSyub>", "<xsd:skcotSyub xmlns:xsd=\"http://services.samples/xsd\">");
                        int indexOf = newString.indexOf("<soapenv:Body>");
                        ArrayList<String> listSrc = new ArrayList<String>();
                        listSrc.add("&lt;redro>&lt;lobmys>IBM&lt;/lobmys>&lt;DIreyub>asankha&lt;/DIreyub>&lt;ecirp>140.34&lt;/ecirp>&lt;emulov>2000&lt;/emulov>&lt;/redro>");
                        listSrc.add("&lt;redro>&lt;lobmys>MSFT&lt;/lobmys>&lt;DIreyub>ruwan&lt;/DIreyub>&lt;ecirp>23.56&lt;/ecirp>&lt;emulov>8030&lt;/emulov>&lt;/redro>");
                        listSrc.add("&lt;redro>&lt;lobmys>SUN&lt;/lobmys>&lt;DIreyub>indika&lt;/DIreyub>&lt;ecirp>14.56&lt;/ecirp>&lt;emulov>500&lt;/emulov>&lt;/redro>");
                        listSrc.add("&lt;redro>&lt;lobmys>GOOG&lt;/lobmys>&lt;DIreyub>chathura&lt;/DIreyub>&lt;ecirp>60.24&lt;/ecirp>&lt;emulov>40000&lt;/emulov>&lt;/redro>");
                        ArrayList<String> listDest = new ArrayList<String>();
                        listDest.add("&lt;redro&gt;&lt;lobmys&gt;IBM&lt;/lobmys&gt;&lt;DIreyub&gt;asankha&lt;/DIreyub&gt;&lt;ecirp&gt;140.34&lt;/ecirp&gt;&lt;emulov&gt;2000&lt;/emulov&gt;&lt;/redro&gt;");
                        listDest.add("&lt;redro&gt;&lt;lobmys&gt;MSFT&lt;/lobmys&gt;&lt;DIreyub&gt;ruwan&lt;/DIreyub&gt;&lt;ecirp&gt;23.56&lt;/ecirp&gt;&lt;emulov&gt;8030&lt;/emulov&gt;&lt;/redro&gt;");
                        listDest.add("&lt;redro&gt;&lt;lobmys&gt;SUN&lt;/lobmys&gt;&lt;DIreyub&gt;indika&lt;/DIreyub&gt;&lt;ecirp&gt;14.56&lt;/ecirp&gt;&lt;emulov&gt;500&lt;/emulov&gt;&lt;/redro&gt;");
                        listDest.add("&lt;redro&gt;&lt;lobmys&gt;GOOG&lt;/lobmys&gt;&lt;DIreyub&gt;chathura&lt;/DIreyub&gt;&lt;ecirp&gt;60.24&lt;/ecirp&gt;&lt;emulov&gt;40000&lt;/emulov&gt;&lt;/redro&gt;");
                        for (int j = 0; j < listSrc.size(); ++j) {
                            String src = (String)listSrc.get(j);
                            String dest = (String)listDest.get(j);
                            int ind = newString.indexOf(src);
                            indexOf = newString.indexOf("<soapenv:Body>");
                            while (ind > 0 && ind < indexOf) {
                                newString = newString.replaceFirst(src, dest);
                                ind = newString.indexOf(src);
                                indexOf = newString.indexOf("<soapenv:Body>");
                            }
                        }
                    } else if (fileName.startsWith("requestHeaderACapo")) {
                        newString = resourceAsString.replace("</soapenv:Header\n>", newHeader + "</soapenv:Header>");
                        newString = newString.replace("<soapenv:Header\nxmlns:xsd=\"http://services.samples/xsd\"\nxmlns:xsd2=\"http://services.samples/xsd\"\nxmlns=\"AltroperTest\"   \n   >", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\" xmlns=\"AltroperTest\" xmlns:xsd=\"http://services.samples/xsd\" xmlns:xsd2=\"http://services.samples/xsd\">");
                    } else if (fileName.startsWith("requestHeaderTab_")) {
                        newString = resourceAsString.replace("</soapenv:Header\t>", newHeader + "</soapenv:Header>");
                        newString = newString.replace("<soapenv:Header\t\txmlns:xsd=\"http://services.samples/xsd\"\t\txmlns:xsd2=\"http://services.samples/xsd\"\t\n\txmlns=\"AltroperTest\"\t\n>", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\" xmlns=\"AltroperTest\" xmlns:xsd=\"http://services.samples/xsd\" xmlns:xsd2=\"http://services.samples/xsd\">");
                        newString = newString.replaceFirst("<xsd:skcotSyub\t>", "<xsd:skcotSyub>");
                        newString = newString.replaceFirst("<redro\t>", "<redro>");
                    } else if (fileName.startsWith("requestFirstChildNameHeader") || fileName.startsWith("requestFirstChildNameExactHeader")) {
                        newString = resourceAsString.replace("</soap:Header>", newHeader + "</soap:Header>");
                        newString = newString.replace("<soap:Header>", "<soap:Header xmlns:soap=\"" + streamReader.getNamespace() + "\">");
                    } else if (fileName.contains("Header") || fileName.startsWith("requestSuUnaRigaSoapBodyVuoto")) {
                        newString = resourceAsString.replace("<soapenv:Header>", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\">");
                        if (shortHeader) {
                            newString = newString.replace("<soapenv:Header/>", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\"></soapenv:Header>");
                        }
                        if (!(wsa || shortHeader || cdata)) {
                            newString = newString.replaceFirst("<xsd:skcotSyub>", "<xsd:skcotSyub xmlns:xsd=\"http://services.samples/xsd\">");
                        }
                        newString = newString.replace("</soapenv:Header>", newHeader + "</soapenv:Header>");
                        newString = newString.replace("</Header>", newHeader + "</Header>");
                        if (wsa) {
                            newString = newString.replace("<Header xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">", "<Header xmlns=\"" + streamReader.getNamespace() + "\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                        }
                    } else if (mixed) {
                        newString = resourceAsString.replace("</hdr:Header>", newHeader + "</hdr:Header>");
                        newString = newString.replace("</Header>", newHeader + "</Header>");
                        newString = newString.replace("<hdr:Header>", "<hdr:Header xmlns:hdr=\"" + streamReader.getNamespace() + "\">");
                        newString = newString.replace("<Header>", "<Header xmlns=\"" + streamReader.getNamespace() + "\">");
                        newString = newString.replace("<wsa:MessageID>", "<wsa:MessageID xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                        newString = newString.replace("<wsa:ReplyTo>", "<wsa:ReplyTo xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                        newString = newString.replace("<wsa:To>", "<wsa:To xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                        newString = newString.replace("<wsa:Action>", "<wsa:Action xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                    } else if (fileName.startsWith("requestEmpty1")) {
                        newString = resourceAsString.replace("<soapenv:Body/>", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\">" + newHeader + "</soapenv:Header><soapenv:Body/>");
                    } else if (fileName.startsWith("requestEmpty2")) {
                        newString = resourceAsString.replace("<Body>", "<Header xmlns=\"" + streamReader.getNamespace() + "\">" + newHeader + "</Header><Body>");
                    } else if (fileName.startsWith("soapFault_soap")) {
                        newString = resourceAsString.replace("<" + defaultDomPrefix + ":Body>", "<" + defaultDomPrefix + ":Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\">" + newHeader + "</" + defaultDomPrefix + ":Header><" + defaultDomPrefix + ":Body>");
                        newString = newString.replace("xmlns:soapenv", "xmlns:" + defaultDomPrefix);
                    } else if (fileName.startsWith("soapFaultLong_soap11")) {
                        newString = resourceAsString.replace("<env:Header />\n    <env:Body>", "<env:Header xmlns:env=\"" + streamReader.getNamespace() + "\">" + newHeader + "</env:Header><env:Body>");
                    } else if (fileName.startsWith("soapFaultLong_soap12")) {
                        newString = resourceAsString.replace("<env:Body>", "<env:Header xmlns:env=\"" + streamReader.getNamespace() + "\">" + newHeader + "</env:Header><env:Body>");
                    } else if (fileName.startsWith("requestSimileSoapFault")) {
                        newString = resourceAsString.replace("<" + defaultDomPrefix + ":Body>", "<" + defaultDomPrefix + ":Header xmlns:" + defaultDomPrefix + "=\"" + streamReader.getNamespace() + "\">" + newHeader + "</" + defaultDomPrefix + ":Header><" + defaultDomPrefix + ":Body>");
                    } else if (fileName.startsWith("requestMixedPrefixAndCDATA")) {
                        if (fileName.contains("soap11")) {
                            newString = resourceAsString.replace("</hdr:Header>", newHeader + "</hdr:Header>");
                            newString = newString.replace("<hdr:Header>", "<hdr:Header xmlns:hdr=\"" + streamReader.getNamespace() + "\">");
                        } else {
                            newString = resourceAsString.replace("</Header>", newHeader + "</Header>");
                            newString = newString.replace("<Header>", "<Header xmlns=\"" + streamReader.getNamespace() + "\">");
                        }
                        newString = newString.replace("<wsa:MessageID>", "<wsa:MessageID xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                        newString = newString.replace("<wsa:ReplyTo>", "<wsa:ReplyTo xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                        newString = newString.replace("<wsa:To>", "<wsa:To xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                        newString = newString.replace("<wsa:Action>", "<wsa:Action xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                    } else if (fileName.startsWith("requestSOAPMultipartRelatedMIME") || fileName.startsWith("contentIdMalformedSOAPMultipartRelatedMIME")) {
                        newString = resourceAsString.replace("</soapenv:Header>", newHeader + "</soapenv:Header>");
                        newString = newString.replace("<soapenv:Header ", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\" ");
                        newString = newString.replace("soapenv:mustUnderstand=\"0\" >", "soapenv:mustUnderstand=\"0\">");
                    } else if (fileName.startsWith("requestACapo")) {
                        newString = resourceAsString.replace("</soapenv:Header\n>", newHeader + "</soapenv:Header>");
                        newString = newString.replace("</soapenv:Header\n\n>", newHeader + "</soapenv:Header>");
                        newString = newString.replace("<soapenv:Header\nxmlns:xsd=\"http://services.samples/xsd\"\nxmlns:xsd2=\"http://services.samples/xsd\"\nxmlns=\"AltroperTest\"   \n   >", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\" xmlns=\"AltroperTest\" xmlns:xsd=\"http://services.samples/xsd\" xmlns:xsd2=\"http://services.samples/xsd\">");
                        newString = newString.replace("<xsd:skcotSyub\n>", "<xsd:skcotSyub>");
                        newString = newString.replace("<xsd:skcotSyub\n   >", "<xsd:skcotSyub>");
                        if (fileName.contains("11")) {
                            newString = newString.replaceFirst("<redro\n>", "<redro>");
                        }
                        newString = newString.replaceFirst("</xsd:skcotSyub\n>", "</xsd:skcotSyub>");
                        if (fileName.contains("12")) {
                            newString = newString.replaceFirst("</xsd:skcotSyub\n\n>", "</xsd:skcotSyub>");
                        }
                    } else if (fileName.startsWith("requestTab")) {
                        newString = resourceAsString.replace("</soapenv:Header\t>", newHeader + "</soapenv:Header>");
                        newString = newString.replace("<soapenv:Header\t\txmlns:xsd=\"http://services.samples/xsd\"\t\txmlns:xsd2=\"http://services.samples/xsd\"\t\n\txmlns=\"AltroperTest\"\t\n>", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\" xmlns=\"AltroperTest\" xmlns:xsd=\"http://services.samples/xsd\" xmlns:xsd2=\"http://services.samples/xsd\">");
                        newString = newString.replaceFirst("<xsd:skcotSyub\t>", "<xsd:skcotSyub>");
                        newString = newString.replaceFirst("<redro\t>", "<redro>");
                    } else if (fileName.startsWith("requestFirstChildNameBody") || fileName.startsWith("requestFirstChildNameExactBody") || fileName.startsWith("requestSoap12Commentata") || fileName.startsWith("requestSoap11Commentata")) {
                        newString = resourceAsString.replace("<soap:Body>", "<soap:Header xmlns:soap=\"" + streamReader.getNamespace() + "\">" + newHeader + "</soap:Header><soap:Body>");
                    } else if (fileName.startsWith("requestXmlDeclarationACapo")) {
                        newString = resourceAsString.replace("</soap:Header>", newHeader + "</soap:Header>");
                        newString = newString.replace("<soap:Header>", "<soap:Header xmlns:soap=\"" + streamReader.getNamespace() + "\">");
                    } else {
                        newString = resourceAsString.replace("<soapenv:Body>", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\">" + newHeader + "</soapenv:Header><soapenv:Body>");
                        newString = newString.replace("<Body>", "<Header xmlns=\"" + streamReader.getNamespace() + "\">" + newHeader + "</Header><Body>");
                    }
                } else {
                    if (fileName.contains("Header")) {
                        newString = resourceAsString.replace("</soapenv:Header>", newHeader + "</soapenv:Header>");
                    } else {
                        newString = resourceAsString.replace("<soapenv:Body>", "<soapenv:Header>" + newHeader + "</soapenv:Header><soapenv:Body>");
                        newString = newString.replace("<Body>", "<Header>" + newHeader + "</Header><Body>");
                    }
                    newString = newString.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n   ", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    newString = newString.replace("</soapenv:Envelope>\n", "</soapenv:Envelope>");
                }
                check = null;
                if (newString != null) {
                    newString = OptimizedHeaderTest.normalizeReturnLine(newString);
                    check = OptimizedHeaderTest.normalizeReturnLine(bout.toString());
                }
                if (newString != null && !newString.equals(check)) {
                    throw new Exception("Contenuto serializzato differente: \nATTESO:\n[" + newString + "]\n GENERATO:\n[" + check + "]");
                }
                OptimizedHeaderTest.print(i, "finalResourceRaw", bout.toByteArray(), initial, rapporto_left_interval, rapporto_write_to);
            }
            finally {
                if (isMessage != null) {
                    isMessage.close();
                }
            }
            ++i;
        }
        OptimizedHeaderTest.checkMemoryError();
        System.out.println("== BODY ==");
        contenitor.clear();
        rapporto = rapporto_max_saaj;
        iterazioniPossibili = HEAP_MEMORY_SIZE / initial / rapporto;
        if (!testHeap) {
            iterazioniPossibili = 1L;
        } else if (iterazioniPossibili > (long)maxIterations) {
            iterazioniPossibili = maxIterations;
        }
        contenitor.clear();
        i = 0;
        while ((long)i < iterazioniPossibili) {
            OptimizedHeaderTest.printMemory(i, iterazioniPossibili, tolleranza_bytes);
            isMessage = OptimizedHeaderTest.getInputStream(fileName, kbBody, resource);
            try {
                streamReader = new OpenSPCoop2MessageSoapStreamReader(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), contentType, isMessage, bufferThresholdKb);
                is = null;
                try {
                    streamReader.read();
                    streamReader.checkException();
                }
                finally {
                    is = streamReader.getBufferedInputStream();
                }
                OptimizedHeaderTest.print(i, "StreamReader", streamReader, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min : rapporto_stream_reader);
                parser = factory.createMessage(messageType, req, is, null, streamReader);
                msg = parser.getMessage_throwParseException();
                OptimizedHeaderTest.print(i, "OpenSPCoop2Message-init", msg, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min : rapporto_stream_reader);
                boolean isOptimizable = streamReader.isSoapHeaderOptimizable();
                if (!isOptimizable && attesoComeOttimizzabile) {
                    throw new Exception("Atteso come ottimizzabile");
                }
                soapMsg = msg.castAsSoap();
                SOAPHeader hdr = soapMsg.getSOAPHeader();
                if (hdr == null) {
                    hdr = soapMsg.getSOAPPart().getEnvelope().addHeader();
                }
                soapElement = hdr.addChildElement("PROVA", "test", "http://prova");
                if (isOptimizable) {
                    if (fileName.contains("Header5K") || fileName.startsWith("requestSuUnaRigaSoapBodyVuoto")) {
                        OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-header", msg, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min * 2L : rapporto_max_saaj);
                    } else if (fileName.startsWith("requestSoapPrefixEmptyWithHeader") || fileName.startsWith("requestMixedPrefix")) {
                        OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-header", msg, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min * 4L : rapporto_min * 4L);
                    } else {
                        OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-header", msg, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min_after_header : rapporto_stream_reader_after_header);
                    }
                } else {
                    OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-header", msg, initial, rapporto_min_saaj, rapporto_max_saaj);
                }
                soapMsg.getSOAPBody();
                if (fileName.contains("Header5K") || fileName.startsWith("requestSuUnaRigaSoapBodyVuoto")) {
                    OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-body", msg, initial, rapporto_min_saaj, rapporto_max_saaj * 2L);
                } else {
                    OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-body", msg, initial, rapporto_min_saaj, rapporto_max_saaj);
                }
                bout = new ByteArrayOutputStream();
                sbDebug = new StringBuilder();
                ((AbstractBaseOpenSPCoop2MessageDynamicContent)msg).writeTo(bout, true, false, null, sbDebug);
                if (!"SERIALIZE-CONTENT".equals(sbDebug.toString())) {
                    throw new Exception("Attesa modalita di serializzazione 'SERIALIZE-CONTENT'; riscontrata: " + sbDebug.toString());
                }
                bout.flush();
                bout.close();
                if (i == 0 && print_message) {
                    System.out.println("WRITE AFTER BODY: " + bout.toString());
                }
                dimensione = -1L;
                dimensione = fileName.contains("Header5K") || fileName.startsWith("requestSuUnaRigaSoapBodyVuoto") ? OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-body-write", msg, initial, rapporto_min_saaj, rapporto_max_saaj * 2L) : OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-body-write", msg, initial, rapporto_min_saaj, rapporto_max_saaj);
                if (i == 0) {
                    if (incremento_minimo_memoria > 1L) {
                        dimensione *= incremento_minimo_memoria;
                    }
                    OptimizedHeaderTest.saveDimensioneOggetto(dimensione);
                }
                contenitor.add(msg);
                OptimizedHeaderTest.verificaConsistenza(contentType, factory, bout, messageType, fileName);
                newHeader = OpenSPCoop2MessageFactory.getAsString(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (Node)soapElement, true);
                newString = null;
                if (fileName.startsWith("requestHeaderBodyXmlEntityOpenOnly")) {
                    newString = resourceAsString.replace("</soapenv:Header>", newHeader + "</soapenv:Header>");
                    ArrayList<String> listSrc = new ArrayList<String>();
                    listSrc.add("&lt;redro>&lt;lobmys>IBM&lt;/lobmys>&lt;DIreyub>asankha&lt;/DIreyub>&lt;ecirp>140.34&lt;/ecirp>&lt;emulov>2000&lt;/emulov>&lt;/redro>");
                    listSrc.add("&lt;redro>&lt;lobmys>MSFT&lt;/lobmys>&lt;DIreyub>ruwan&lt;/DIreyub>&lt;ecirp>23.56&lt;/ecirp>&lt;emulov>8030&lt;/emulov>&lt;/redro>");
                    listSrc.add("&lt;redro>&lt;lobmys>SUN&lt;/lobmys>&lt;DIreyub>indika&lt;/DIreyub>&lt;ecirp>14.56&lt;/ecirp>&lt;emulov>500&lt;/emulov>&lt;/redro>");
                    listSrc.add("&lt;redro>&lt;lobmys>GOOG&lt;/lobmys>&lt;DIreyub>chathura&lt;/DIreyub>&lt;ecirp>60.24&lt;/ecirp>&lt;emulov>40000&lt;/emulov>&lt;/redro>");
                    ArrayList<String> listDest = new ArrayList<String>();
                    listDest.add("&lt;redro&gt;&lt;lobmys&gt;IBM&lt;/lobmys&gt;&lt;DIreyub&gt;asankha&lt;/DIreyub&gt;&lt;ecirp&gt;140.34&lt;/ecirp&gt;&lt;emulov&gt;2000&lt;/emulov&gt;&lt;/redro&gt;");
                    listDest.add("&lt;redro&gt;&lt;lobmys&gt;MSFT&lt;/lobmys&gt;&lt;DIreyub&gt;ruwan&lt;/DIreyub&gt;&lt;ecirp&gt;23.56&lt;/ecirp&gt;&lt;emulov&gt;8030&lt;/emulov&gt;&lt;/redro&gt;");
                    listDest.add("&lt;redro&gt;&lt;lobmys&gt;SUN&lt;/lobmys&gt;&lt;DIreyub&gt;indika&lt;/DIreyub&gt;&lt;ecirp&gt;14.56&lt;/ecirp&gt;&lt;emulov&gt;500&lt;/emulov&gt;&lt;/redro&gt;");
                    listDest.add("&lt;redro&gt;&lt;lobmys&gt;GOOG&lt;/lobmys&gt;&lt;DIreyub&gt;chathura&lt;/DIreyub&gt;&lt;ecirp&gt;60.24&lt;/ecirp&gt;&lt;emulov&gt;40000&lt;/emulov&gt;&lt;/redro&gt;");
                    for (int j = 0; j < listSrc.size(); ++j) {
                        String src = (String)listSrc.get(j);
                        String dest = (String)listDest.get(j);
                        int ind = newString.indexOf(src);
                        while (ind > 0) {
                            newString = newString.replaceFirst(src, dest);
                            ind = newString.indexOf(src);
                        }
                    }
                } else if (fileName.startsWith("requestHeaderACapo")) {
                    newString = resourceAsString.replace("</soapenv:Header\n>", newHeader + "</soapenv:Header>");
                    newString = newString.replace("<soapenv:Header\nxmlns:xsd=\"http://services.samples/xsd\"\nxmlns:xsd2=\"http://services.samples/xsd\"\nxmlns=\"AltroperTest\"   \n   >", "<soapenv:Header xmlns=\"AltroperTest\" xmlns:xsd=\"http://services.samples/xsd\" xmlns:xsd2=\"http://services.samples/xsd\">");
                    newString = newString.replace("<xsd:skcotSyub\nxmlns:xsd=\"http://services.samples/xsd\"\nxmlns:xsd2=\"http://services.samples/xsd\"\nxmlns=\"AltroperTest\"\n>", "<xsd:skcotSyub xmlns:xsd=\"http://services.samples/xsd\" xmlns=\"AltroperTest\" xmlns:xsd2=\"http://services.samples/xsd\">");
                } else if (fileName.startsWith("requestHeaderTab_")) {
                    newString = resourceAsString.replace("</soapenv:Header\t>", newHeader + "</soapenv:Header>");
                    newString = newString.replace("<soapenv:Header\t\txmlns:xsd=\"http://services.samples/xsd\"\t\txmlns:xsd2=\"http://services.samples/xsd\"\t\n\txmlns=\"AltroperTest\"\t\n>", "<soapenv:Header xmlns=\"AltroperTest\" xmlns:xsd=\"http://services.samples/xsd\" xmlns:xsd2=\"http://services.samples/xsd\">");
                    newString = newString.replaceFirst("<xsd:skcotSyub\t>", "<xsd:skcotSyub>");
                    newString = newString.replaceFirst("<redro\t>", "<redro>");
                    newString = newString.replace("<xsd:skcotSyub\t\txmlns:xsd=\"http://services.samples/xsd\"\t\txmlns:xsd2=\"http://services.samples/xsd\"\t\n\txmlns=\"AltroperTest\"\t\n>", "<xsd:skcotSyub xmlns:xsd=\"http://services.samples/xsd\" xmlns=\"AltroperTest\" xmlns:xsd2=\"http://services.samples/xsd\">");
                } else if (fileName.startsWith("requestFirstChildNameHeader") || fileName.startsWith("requestFirstChildNameExactHeader")) {
                    newString = resourceAsString.replace("</soap:Header>", newHeader + "</soap:Header>");
                    newString = newString.replace("</soap:Envelope>\n", "</soap:Envelope>");
                } else if (fileName.contains("Header") || fileName.startsWith("requestSuUnaRigaSoapBodyVuoto")) {
                    newString = resourceAsString.replace("</soapenv:Header>", newHeader + "</soapenv:Header>");
                    if (shortHeader) {
                        newString = newString.replace("<soapenv:Header/>", "<soapenv:Header>" + newHeader + "</soapenv:Header>");
                    }
                    newString = newString.replace("<Header ", "<" + defaultDomPrefix + ":Header ");
                    newString = newString.replace("</Header>", newHeader + "</" + defaultDomPrefix + ":Header>");
                    if (fileName.startsWith("requestHeaderBodyVariCommenti")) {
                        newString = newString.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<!-- Commento Iniziale -->\n\n<!--", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- Commento Iniziale --><!--");
                        newString = newString.replace("-->\n\n\n   <soapenv:Envelope", "--><soapenv:Envelope");
                    }
                } else if (mixed) {
                    newString = resourceAsString.replace("</hdr:Header>", newHeader + "</hdr:Header>");
                    newString = newString.replace("</Header>", newHeader + "</" + defaultDomPrefix + ":Header>");
                    newString = newString.replace("<Header>", "<" + defaultDomPrefix + ":Header>");
                    newString = newString.replace("<Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" \n   xmlns=\"http://schemas.xmlsoap.org/soap/envelope/\" \n   xmlns:hdr=\"http://schemas.xmlsoap.org/soap/envelope/\"\n   xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" \n   xmlns:xsd=\"http://services.samples/xsd\">", "<" + defaultDomPrefix + ":Envelope xmlns:" + defaultDomPrefix + "=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:hdr=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" xmlns:xsd=\"http://services.samples/xsd\">");
                    newString = newString.replace("<env:Envelope xmlns:soapenv=\"http://www.w3.org/2003/05/soap-envelope\" \n   xmlns=\"http://www.w3.org/2003/05/soap-envelope\" \n   xmlns:env=\"http://www.w3.org/2003/05/soap-envelope\"\n   xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" \n   xmlns:xsd=\"http://services.samples/xsd\">", "<" + defaultDomPrefix + ":Envelope xmlns:" + defaultDomPrefix + "=\"http://www.w3.org/2003/05/soap-envelope\" xmlns=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:soapenv=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" xmlns:xsd=\"http://services.samples/xsd\">");
                    newString = newString.replace("</Envelope>", "</" + defaultDomPrefix + ":Envelope>");
                } else if (fileName.startsWith("requestEmpty1")) {
                    newString = resourceAsString.replace("<soapenv:Body/>", "<soapenv:Header>" + newHeader + "</soapenv:Header><soapenv:Body/>");
                } else if (fileName.startsWith("requestEmpty2")) {
                    newString = resourceAsString.replace("<Body></Body>", "<" + defaultDomPrefix + ":Header>" + newHeader + "</" + defaultDomPrefix + ":Header><" + defaultDomPrefix + ":Body/>");
                } else if (fileName.startsWith("requestEmpty3")) {
                    newString = resourceAsString.replace("<Body>", "<" + defaultDomPrefix + ":Header>" + newHeader + "</" + defaultDomPrefix + ":Header><" + defaultDomPrefix + ":Body>");
                } else if (fileName.startsWith("soapFault_soap")) {
                    newString = resourceAsString.replace("<" + defaultDomPrefix + ":Body>", "<" + defaultDomPrefix + ":Header>" + newHeader + "</" + defaultDomPrefix + ":Header><" + defaultDomPrefix + ":Body>");
                    newString = newString.replace("xmlns:soapenv", "xmlns:" + defaultDomPrefix);
                } else if (fileName.startsWith("soapFaultSoapPrefixEmpty")) {
                    newString = resourceAsString.replace("<Body>", "<" + defaultDomPrefix + ":Header>" + newHeader + "</" + defaultDomPrefix + ":Header><" + defaultDomPrefix + ":Body>");
                    newString = newString.replace("<Fault>", "<" + defaultDomPrefix + ":Fault>");
                    newString = newString.replace("</Fault>", "</" + defaultDomPrefix + ":Fault>");
                    if (fileName.contains("soap12")) {
                        newString = newString.replace("<Detail>", "<" + defaultDomPrefix + ":Detail>");
                        newString = newString.replace("</Detail>", "</" + defaultDomPrefix + ":Detail>");
                    }
                } else if (fileName.startsWith("soapFaultLong_soap11")) {
                    newString = resourceAsString.replace("<env:Header />", "<env:Header>" + newHeader + "</env:Header>");
                } else if (fileName.startsWith("soapFaultLong_soap12")) {
                    newString = resourceAsString.replace("<env:Body>", "<env:Header>" + newHeader + "</env:Header><env:Body>");
                } else if (fileName.startsWith("requestSimileSoapFault")) {
                    newString = resourceAsString.replace("<" + defaultDomPrefix + ":Body>", "<" + defaultDomPrefix + ":Header>" + newHeader + "</" + defaultDomPrefix + ":Header><" + defaultDomPrefix + ":Body>");
                } else if (fileName.startsWith("requestMixedPrefixAndCDATA")) {
                    if (fileName.contains("soap11")) {
                        newString = resourceAsString.replace("</hdr:Header>", newHeader + "</hdr:Header>");
                        newString = newString.replace("<Envelope xmlns:soapenv=\"" + streamReader.getNamespace() + "\" \n   xmlns=\"" + streamReader.getNamespace() + "\" \n   xmlns:hdr=\"" + streamReader.getNamespace() + "\"\n   xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" \n   xmlns:xsd=\"http://services.samples/xsd\">", "<" + defaultDomPrefix + ":Envelope xmlns:" + defaultDomPrefix + "=\"" + streamReader.getNamespace() + "\" xmlns=\"" + streamReader.getNamespace() + "\" xmlns:hdr=\"" + streamReader.getNamespace() + "\" xmlns:soapenv=\"" + streamReader.getNamespace() + "\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" xmlns:xsd=\"http://services.samples/xsd\">");
                    } else {
                        newString = resourceAsString.replace("</Header>", newHeader + "</env:Header>");
                        newString = newString.replace("<Header>", "<env:Header>");
                        newString = newString.replace("<env:Envelope xmlns:soapenv=\"" + streamReader.getNamespace() + "\" \n   xmlns=\"" + streamReader.getNamespace() + "\" \n   xmlns:env=\"" + streamReader.getNamespace() + "\"\n   xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" \n   xmlns:xsd=\"http://services.samples/xsd\">", "<" + defaultDomPrefix + ":Envelope xmlns:" + defaultDomPrefix + "=\"" + streamReader.getNamespace() + "\" xmlns=\"" + streamReader.getNamespace() + "\" xmlns:soapenv=\"" + streamReader.getNamespace() + "\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" xmlns:xsd=\"http://services.samples/xsd\">");
                    }
                } else if (fileName.startsWith("requestSOAPMultipartRelatedMIME") || fileName.startsWith("contentIdMalformedSOAPMultipartRelatedMIME")) {
                    newString = resourceAsString.replace("</soapenv:Header>", newHeader + "</soapenv:Header>");
                    newString = newString.replace("soapenv:mustUnderstand=\"0\" >", "soapenv:mustUnderstand=\"0\">");
                    String mime = ContentTypeUtilities.readMultipartBoundaryFromContentType((String)soapMsg.getContentType());
                    newString = newString.replace("------=_Part_0_6330713.1171639717331--", "--" + mime + "--");
                    newString = newString.replace("------=_Part_0_6330713.1171639717331", "--" + mime);
                    newString = newString.replaceFirst("charset=UTF-8", "charset=utf-8");
                    if (!fileName.startsWith("requestSOAPMultipartRelatedMIMEbodyEmpty")) {
                        newString = newString.replaceFirst("&quot;mario&quot;", "\"mario\"");
                        newString = newString.replaceFirst("&quot;rossi&quot;", "\"rossi\"");
                        newString = newString.replaceFirst("<attachInZIP1 href=\"cid:D559E7E9E29638A15AD37B90FCAEAD53\" xmlns=\"\"/><attachInZIP2 href=\"cid:FF5ED4B1298A2E36CF986C32638C5257\" xmlns=\"\"/>", "<attachInZIP1 xmlns=\"\" href=\"cid:D559E7E9E29638A15AD37B90FCAEAD53\"/><attachInZIP2 xmlns=\"\" href=\"cid:FF5ED4B1298A2E36CF986C32638C5257\"/>");
                    }
                    newString = newString.substring(2);
                    newString = newString.substring(0, newString.length() - 2);
                } else if (fileName.startsWith("requestACapo")) {
                    newString = resourceAsString.replace("</soapenv:Header\n>", newHeader + "</soapenv:Header>");
                    newString = newString.replace("</soapenv:Header\n\n>", newHeader + "</soapenv:Header>");
                    newString = newString.replace("<soapenv:Header\nxmlns:xsd=\"http://services.samples/xsd\"\nxmlns:xsd2=\"http://services.samples/xsd\"\nxmlns=\"AltroperTest\"   \n   >", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\" xmlns=\"AltroperTest\" xmlns:xsd=\"http://services.samples/xsd\" xmlns:xsd2=\"http://services.samples/xsd\">");
                    newString = newString.replace("<xsd:skcotSyub\n>", "<xsd:skcotSyub>");
                    newString = newString.replace("<xsd:skcotSyub\n   >", "<xsd:skcotSyub>");
                    newString = newString.replace("<redro\n>", "<redro>");
                    newString = newString.replace("</xsd:skcotSyub\n>", "</xsd:skcotSyub>");
                    newString = newString.replace("?>\n\n   <soapenv:Envelope\n" + (fileName.contains("11") ? "\n" : "") + "xmlns:soapenv=\"" + streamReader.getNamespace() + "\"\n\n>", "?><soapenv:Envelope xmlns:soapenv=\"" + streamReader.getNamespace() + "\">");
                    newString = newString.replace("<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\"", "<soapenv:Header");
                    newString = newString.replace("<soapenv:Body\n>", "<soapenv:Body>");
                    newString = newString.replace("<soapenv:Body\n\n>", "<soapenv:Body>");
                    newString = newString.replace("<xsd:skcotSyub\n" + (fileName.contains("12") ? "\n" : "") + "xmlns:xsd=\"http://services.samples/xsd\"\nxmlns:xsd2=\"http://services.samples/xsd\"\nxmlns=\"AltroperTest\"\n>", "<xsd:skcotSyub xmlns:xsd=\"http://services.samples/xsd\" xmlns=\"AltroperTest\" xmlns:xsd2=\"http://services.samples/xsd\">");
                    newString = newString.replace("</soapenv:Body\n\n>", "</soapenv:Body>");
                    newString = newString.replace("</lobmys\n>", "</lobmys>");
                    newString = newString.replace("</redro\n>", "</redro>");
                    newString = newString.replace("</soapenv:Envelope\n\n>", "</soapenv:Envelope>");
                    newString = newString.replace("</soapenv:Envelope\n>", "</soapenv:Envelope>");
                    newString = newString.replace("</xsd:skcotSyub\n\n>", "</xsd:skcotSyub>");
                } else if (fileName.startsWith("requestTab")) {
                    newString = resourceAsString.replace("</soapenv:Header\t>", newHeader + "</soapenv:Header>");
                    newString = newString.replace("<soapenv:Header\t\txmlns:xsd=\"http://services.samples/xsd\"\t\txmlns:xsd2=\"http://services.samples/xsd\"\t\n\txmlns=\"AltroperTest\"\t\n>", "<soapenv:Header xmlns=\"AltroperTest\" xmlns:xsd=\"http://services.samples/xsd\" xmlns:xsd2=\"http://services.samples/xsd\">");
                    newString = newString.replaceFirst("<xsd:skcotSyub\t>", "<xsd:skcotSyub>");
                    newString = newString.replaceFirst("<redro\t>", "<redro>");
                    newString = newString.replace("<?xml\t version=\"1.0\"\t encoding=\"UTF-8\"\t?>\n\n   <soapenv:Envelope\txmlns:soapenv=\"" + streamReader.getNamespace() + "\"\t\t>", "<?xml\t version=\"1.0\"\t encoding=\"UTF-8\"\t?><soapenv:Envelope xmlns:soapenv=\"" + streamReader.getNamespace() + "\">");
                    newString = newString.replace("<soapenv:Body\t>", "<soapenv:Body>");
                    newString = newString.replace("</xsd:skcotSyub\t\t>", "</xsd:skcotSyub>");
                    newString = newString.replace("</soapenv:Body\t\t>", "</soapenv:Body>");
                    newString = newString.replace("</soapenv:Envelope\t\t>", "</soapenv:Envelope>");
                    newString = newString.replace("<redro\t\t>", "<redro>");
                    newString = newString.replace("<xsd:skcotSyub\t\txmlns:xsd=\"http://services.samples/xsd\"\t\txmlns:xsd2=\"http://services.samples/xsd\"\t\n\txmlns=\"AltroperTest\"\t\n>", "<xsd:skcotSyub xmlns:xsd=\"http://services.samples/xsd\" xmlns=\"AltroperTest\" xmlns:xsd2=\"http://services.samples/xsd\">");
                } else if (fileName.startsWith("requestRootElementACapo")) {
                    newString = resourceAsString.replace("<soapenv:Body>", "<soapenv:Header>" + newHeader + "</soapenv:Header><soapenv:Body>");
                    newString = newString.replace("<xsd:skcotSyub\nxmlns:xsd=\"http://services.samples/xsd\"\nxmlns:xsd2=\"http://services.samples/xsd\"\nxmlns=\"AltroperTest\"\n>", "<xsd:skcotSyub xmlns:xsd=\"http://services.samples/xsd\" xmlns=\"AltroperTest\" xmlns:xsd2=\"http://services.samples/xsd\">");
                    newString = newString.replace("</xsd:skcotSyub\n>", "</xsd:skcotSyub>");
                } else if (fileName.startsWith("requestRootElementTab")) {
                    newString = resourceAsString.replace("<soapenv:Body>", "<soapenv:Header>" + newHeader + "</soapenv:Header><soapenv:Body>");
                    newString = newString.replace("<xsd:skcotSyub\t\txmlns:xsd=\"http://services.samples/xsd\"\t\txmlns:xsd2=\"http://services.samples/xsd\"\t\n\txmlns=\"AltroperTest\"\t\n>", "<xsd:skcotSyub xmlns:xsd=\"http://services.samples/xsd\" xmlns=\"AltroperTest\" xmlns:xsd2=\"http://services.samples/xsd\">");
                    newString = newString.replace("</xsd:skcotSyub\t>", "</xsd:skcotSyub>");
                } else if (fileName.startsWith("requestSoapFaultACapo_soap11")) {
                    newString = resourceAsString.replace("<soapenv:Body>", "<soapenv:Header>" + newHeader + "</soapenv:Header><soapenv:Body>");
                    newString = newString.replace("<soapenv:Fault\nxmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\nxmlns:problem=\"urn:ietf:rfc:7807\"\n>", "<soapenv:Fault xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:problem=\"urn:ietf:rfc:7807\">");
                    newString = newString.replace("</soapenv:Fault\n>", "</soapenv:Fault>");
                } else if (fileName.startsWith("requestSoapFaultACapo_soap12")) {
                    newString = resourceAsString.replace("<soapenv:Body>", "<soapenv:Header>" + newHeader + "</soapenv:Header><soapenv:Body>");
                    newString = newString.replace("<env:Fault\nxmlns:env=\"http://www.w3.org/2003/05/soap-envelope\"\nxmlns:problem=\"urn:ietf:rfc:7807\"\n\n    >", "<env:Fault xmlns:env=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:problem=\"urn:ietf:rfc:7807\">");
                    newString = newString.replace("</env:Fault\n\n>", "</env:Fault>");
                } else if (fileName.startsWith("requestSoapFaultTab_soap11")) {
                    newString = resourceAsString.replace("<soapenv:Body>", "<soapenv:Header>" + newHeader + "</soapenv:Header><soapenv:Body>");
                    newString = newString.replace("<soapenv:Fault\txmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\txmlns:problem=\"urn:ietf:rfc:7807\"\t>", "<soapenv:Fault xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:problem=\"urn:ietf:rfc:7807\">");
                    newString = newString.replace("</soapenv:Fault\t\t>", "</soapenv:Fault>");
                } else if (fileName.startsWith("requestSoapFaultTab_soap12")) {
                    newString = resourceAsString.replace("<soapenv:Body>", "<soapenv:Header>" + newHeader + "</soapenv:Header><soapenv:Body>");
                    newString = newString.replace("<env:Fault\t\txmlns:env=\"http://www.w3.org/2003/05/soap-envelope\"\txmlns:problem=\"urn:ietf:rfc:7807\"\t\t>", "<env:Fault xmlns:env=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:problem=\"urn:ietf:rfc:7807\">");
                    newString = newString.replace("</env:Fault\t\t>", "</env:Fault>");
                } else if (fileName.startsWith("requestFirstChildNameBody") || fileName.startsWith("requestFirstChildNameExactBody") || fileName.startsWith("requestSoap12Commentata") || fileName.startsWith("requestSoap11Commentata")) {
                    newString = resourceAsString.replace("<soap:Body>", "<soap:Header>" + newHeader + "</soap:Header><soap:Body>");
                    newString = newString.replace("</soap:Envelope>\n", "</soap:Envelope>");
                    if (fileName.startsWith("requestSoap12Commentata")) {
                        newString = newString.replace("\n  <!--<soap:Envelope", "<!--<soap:Envelope");
                        newString = newString.replace("-->     \n\n<soap:Envelope", "--><soap:Envelope");
                    }
                    if (fileName.startsWith("requestSoap11Commentata")) {
                        newString = newString.replace("\n  <!--<soap:Envelope", "<!--<soap:Envelope");
                        newString = newString.replace("-->\n\n<soap:Envelope", "--><soap:Envelope");
                    }
                    if (fileName.startsWith("requestSoap12CommentataACapo")) {
                        newString = newString.replace("\n<!--", "<!--");
                        newString = newString.replace("-->      \n\n", "-->");
                    }
                    if (fileName.startsWith("requestSoap11CommentataACapo")) {
                        newString = newString.replace("\n  <!--", "<!--");
                        newString = newString.replace("-->      \n\n", "-->");
                        newString = newString.replace("</ns2:skcotSyub>y>", "</ns2:skcotSyub>y&gt;");
                    }
                } else if (fileName.startsWith("requestXmlDeclarationACapo")) {
                    newString = resourceAsString.replace("</soap:Header>", newHeader + "</soap:Header>");
                    newString = newString.replace("</soap:Envelope>\n", "</soap:Envelope>");
                    newString = newString.replace("?>\n\n<soap:Envelope", "?><soap:Envelope");
                } else if (fileName.startsWith("requestBodyMalformed2")) {
                    newString = resourceAsString.replace("<soapenv:Body>", "<soapenv:Header>" + newHeader + "</soapenv:Header><soapenv:Body>");
                    newString = newString.replace("CONTENUTO_ERRATO>", "CONTENUTO_ERRATO&gt;");
                } else if (fileName.startsWith("requestBodyMalformed3")) {
                    newString = resourceAsString.replace("<soapenv:Body>", "<soapenv:Header>" + newHeader + "</soapenv:Header><soapenv:Body>");
                    newString = newString.replace("CONTENUTO_ERRATO/>", "CONTENUTO_ERRATO/&gt;");
                } else {
                    newString = resourceAsString.replace("<soapenv:Body>", "<soapenv:Header>" + newHeader + "</soapenv:Header><soapenv:Body>");
                    newString = newString.replace("<Body>", "<" + defaultDomPrefix + ":Header>" + newHeader + "</" + defaultDomPrefix + ":Header><" + defaultDomPrefix + ":Body>");
                }
                if (!mixed) {
                    newString = newString.replace("<Envelope xmlns=\"" + streamReader.getNamespace() + "\"", "<" + defaultDomPrefix + ":Envelope xmlns:" + defaultDomPrefix + "=\"" + streamReader.getNamespace() + "\" xmlns=\"" + streamReader.getNamespace() + "\"");
                    newString = newString.replace("</Envelope>", "</" + defaultDomPrefix + ":Envelope>");
                    newString = newString.replace("<Body>", "<" + defaultDomPrefix + ":Body>");
                    newString = newString.replace("</Body>", "</" + defaultDomPrefix + ":Body>");
                }
                newString = newString.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n   ", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                newString = newString.replace("</soapenv:Envelope>\n", "</soapenv:Envelope>");
                newString = newString.replace("</" + defaultDomPrefix + ":Envelope>\n", "</" + defaultDomPrefix + ":Envelope>");
                check = null;
                if (newString != null) {
                    newString = OptimizedHeaderTest.normalizeReturnLine(newString);
                    check = OptimizedHeaderTest.normalizeReturnLine(bout.toString());
                }
                if (newString != null && !newString.equals(check)) {
                    if (fileName.startsWith("requestSOAPMultipartRelatedMIMEpdf")) {
                        if (i == 0) {
                            System.out.println("Verifica disabilitata; richiesta binaria con PDF");
                        }
                    } else {
                        throw new Exception("Contenuto serializzato differente: \nATTESO:\n[" + newString + "]\n GENERATO:\n[" + check + "]");
                    }
                }
                OptimizedHeaderTest.print(i, "finalResourceRaw", bout.toByteArray(), initial, rapporto_left_interval, rapporto_write_to);
            }
            finally {
                if (isMessage != null) {
                    isMessage.close();
                }
            }
            ++i;
        }
        OptimizedHeaderTest.checkMemoryError();
        System.out.println("== TRASPARENTE, ACCESSO CONTENUTO READ ONLY ==");
        contenitor.clear();
        rapporto = rapporto_max_saaj;
        iterazioniPossibili = HEAP_MEMORY_SIZE / initial / rapporto;
        if (!testHeap) {
            iterazioniPossibili = 1L;
        } else if (iterazioniPossibili > (long)maxIterations) {
            iterazioniPossibili = maxIterations;
        }
        i = 0;
        while ((long)i < iterazioniPossibili) {
            OptimizedHeaderTest.printMemory(i, iterazioniPossibili, tolleranza_bytes);
            isMessage = OptimizedHeaderTest.getInputStream(fileName, kbBody, resource);
            try {
                long dimensione3;
                ByteArrayOutputStream bout3;
                block356: {
                    streamReader = new OpenSPCoop2MessageSoapStreamReader(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), contentType, isMessage, bufferThresholdKb);
                    is = null;
                    try {
                        streamReader.read();
                        streamReader.checkException();
                    }
                    finally {
                        is = streamReader.getBufferedInputStream();
                    }
                    OptimizedHeaderTest.print(i, "StreamReader", streamReader, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min : rapporto_stream_reader);
                    parser = factory.createMessage(messageType, req, is, null, streamReader);
                    msg = parser.getMessage_throwParseException();
                    OptimizedHeaderTest.print(i, "OpenSPCoop2Message-init", msg, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min : rapporto_stream_reader);
                    boolean isOptimizable = streamReader.isSoapHeaderOptimizable();
                    if (!isOptimizable && attesoComeOttimizzabile) {
                        throw new Exception("Atteso come ottimizzabile");
                    }
                    soapMsg = msg.castAsSoap();
                    AbstractOpenSPCoop2Message_soap_impl soap = null;
                    if (soapMsg instanceof AbstractOpenSPCoop2Message_soap_impl) {
                        soap = (AbstractOpenSPCoop2Message_soap_impl)soapMsg;
                        ((AbstractOpenSPCoop2Message_saaj_impl)soap.getContent(true, "idTransazione-xxx")).getSOAPMessage();
                    }
                    bout3 = new ByteArrayOutputStream();
                    StringBuilder sbDebug3 = new StringBuilder();
                    ((AbstractBaseOpenSPCoop2MessageDynamicContent)msg).writeTo(bout3, true, false, null, sbDebug3);
                    if (!"SERIALIZE-BUFFER".equals(sbDebug3.toString())) {
                        throw new Exception("Attesa modalita di serializzazione 'SERIALIZE-BUFFER'; riscontrata: " + sbDebug3.toString());
                    }
                    bout3.flush();
                    bout3.close();
                    if (i == 0 && print_message) {
                        System.out.println("WRITE: " + bout3.toString());
                    }
                    dimensione3 = -1L;
                    try {
                        dimensione3 = OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-write", msg, initial, rapporto_min_saaj, rapporto_max_saaj);
                    }
                    catch (Exception e) {
                        excTooBig.add(e);
                        System.out.println("Saved in list");
                        if (soap.getSoapReader().getHeader_OpenSPCoop2Message() != null) {
                            OptimizedHeaderTest.print(i, "Verifica interna soap header nel reader", soap.getSoapReader().getHeader_OpenSPCoop2Message(), initial, 0L, 300L);
                        }
                        OptimizedHeaderTest.print(i, "Verifica interna soap reader", soap.getSoapReader(), initial, 0L, 300L);
                        if (excTooBig.size() <= MAX_EXC) break block356;
                        throw e;
                    }
                }
                if (i == 0) {
                    if (incremento_minimo_memoria > 1L) {
                        dimensione3 *= incremento_minimo_memoria;
                    }
                    OptimizedHeaderTest.saveDimensioneOggetto(dimensione3);
                }
                contenitor.add(msg);
                OptimizedHeaderTest.verificaConsistenza(contentType, factory, bout3, messageType, fileName);
                if (!resourceAsString.equals(bout3.toString())) {
                    throw new Exception("Contenuto serializzato differente: \nATTESO:\n[" + resourceAsString + "]\n GENERATO:\n[" + bout3.toString() + "]");
                }
                OptimizedHeaderTest.print(i, "finalResourceRaw", bout3.toByteArray(), initial, rapporto_left_interval, rapporto_write_to);
            }
            finally {
                if (isMessage != null) {
                    isMessage.close();
                }
            }
            ++i;
        }
        OptimizedHeaderTest.checkMemoryError();
        System.out.println("== HEADER e ACCESSO CONTENUTO READ ONLY ==");
        contenitor.clear();
        rapporto = rapporto_max_saaj;
        iterazioniPossibili = HEAP_MEMORY_SIZE / initial / rapporto;
        if (!testHeap) {
            iterazioniPossibili = 1L;
        } else if (iterazioniPossibili > (long)maxIterations) {
            iterazioniPossibili = maxIterations;
        }
        i = 0;
        while ((long)i < iterazioniPossibili) {
            OptimizedHeaderTest.printMemory(i, iterazioniPossibili, tolleranza_bytes);
            isMessage = OptimizedHeaderTest.getInputStream(fileName, kbBody, resource);
            try {
                long dimensione4;
                ByteArrayOutputStream bout4;
                SOAPElement soapElement2;
                boolean isOptimizable;
                block360: {
                    AbstractOpenSPCoop2Message_soap_impl soap;
                    block359: {
                        streamReader = new OpenSPCoop2MessageSoapStreamReader(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), contentType, isMessage, bufferThresholdKb);
                        is = null;
                        try {
                            streamReader.read();
                            streamReader.checkException();
                        }
                        finally {
                            is = streamReader.getBufferedInputStream();
                        }
                        OptimizedHeaderTest.print(i, "StreamReader", streamReader, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min : rapporto_stream_reader);
                        parser = factory.createMessage(messageType, req, is, null, streamReader);
                        msg = parser.getMessage_throwParseException();
                        OptimizedHeaderTest.print(i, "OpenSPCoop2Message-init", msg, initial, rapporto_left_interval, bufferThresholdKb == 1 ? rapporto_min : rapporto_stream_reader);
                        isOptimizable = streamReader.isSoapHeaderOptimizable();
                        if (!isOptimizable && attesoComeOttimizzabile) {
                            throw new Exception("Atteso come ottimizzabile");
                        }
                        OpenSPCoop2SoapMessage _soapMsg = msg.castAsSoap();
                        soap = null;
                        if (!(_soapMsg instanceof AbstractOpenSPCoop2Message_soap_impl)) {
                            throw new Exception("Atteso messaggio con tipo '" + AbstractOpenSPCoop2Message_soap_impl.class.getName() + "'");
                        }
                        soap = (AbstractOpenSPCoop2Message_soap_impl)_soapMsg;
                        ((AbstractOpenSPCoop2Message_saaj_impl)soap.getContent(true, "idTransazione-xxx")).getSOAPMessage();
                        SOAPHeader hdr = soap.getSOAPHeader();
                        if (hdr == null) {
                            hdr = soap.getSOAPPart().getEnvelope().addHeader();
                        }
                        soapElement2 = hdr.addChildElement("PROVA", "test", "http://prova");
                        try {
                            if (fileName.contains("Header5K") || fileName.startsWith("requestSuUnaRigaSoapBodyVuoto")) {
                                OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-header", msg, initial, rapporto_min_saaj, rapporto_max_saaj * 2L);
                            } else {
                                OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-header", msg, initial, rapporto_min_saaj, rapporto_max_saaj);
                            }
                        }
                        catch (Exception e) {
                            excTooBig.add(e);
                            System.out.println("Saved in list");
                            if (soap.getSoapReader().getHeader_OpenSPCoop2Message() != null) {
                                OptimizedHeaderTest.print(i, "Verifica interna soap header nel reader", soap.getSoapReader().getHeader_OpenSPCoop2Message(), initial, 0L, 300L);
                            }
                            OptimizedHeaderTest.print(i, "Verifica interna soap reader", soap.getSoapReader(), initial, 0L, 300L);
                            if (excTooBig.size() <= MAX_EXC) break block359;
                            throw e;
                        }
                    }
                    bout4 = new ByteArrayOutputStream();
                    StringBuilder sbDebug4 = new StringBuilder();
                    ((AbstractBaseOpenSPCoop2MessageDynamicContent)msg).writeTo(bout4, true, false, null, sbDebug4);
                    if (isOptimizable) {
                        if (!"SERIALIZE-BUFFER-WITH-HEADER".equals(sbDebug4.toString())) {
                            throw new Exception("Attesa modalita di serializzazione 'SERIALIZE-BUFFER-WITH-HEADER'; riscontrata: " + sbDebug4.toString());
                        }
                    } else if (!"SERIALIZE-CONTENT".equals(sbDebug4.toString())) {
                        throw new Exception("Attesa modalita di serializzazione 'SERIALIZE-CONTENT'; riscontrata: " + sbDebug4.toString());
                    }
                    bout4.flush();
                    bout4.close();
                    if (i == 0 && print_message) {
                        System.out.println("WRITE AFTER HEADER: " + bout4.toString());
                    }
                    dimensione4 = -1L;
                    try {
                        dimensione4 = OptimizedHeaderTest.print(i, "OpenSPCoop2Message-after-header-write", msg, initial, rapporto_min_saaj, rapporto_max_saaj);
                    }
                    catch (Exception e) {
                        excTooBig.add(e);
                        System.out.println("Saved in list");
                        if (soap.getSoapReader().getHeader_OpenSPCoop2Message() != null) {
                            OptimizedHeaderTest.print(i, "Verifica interna soap header nel reader", soap.getSoapReader().getHeader_OpenSPCoop2Message(), initial, 0L, 300L);
                        }
                        OptimizedHeaderTest.print(i, "Verifica interna soap reader", soap.getSoapReader(), initial, 0L, 300L);
                        if (excTooBig.size() <= MAX_EXC) break block360;
                        throw e;
                    }
                }
                if (i == 0) {
                    if (incremento_minimo_memoria > 1L) {
                        dimensione4 *= incremento_minimo_memoria;
                    }
                    OptimizedHeaderTest.saveDimensioneOggetto(dimensione4);
                }
                contenitor.add(msg);
                OptimizedHeaderTest.verificaConsistenza(contentType, factory, bout4, messageType, fileName);
                String newHeader2 = OpenSPCoop2MessageFactory.getAsString(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (Node)soapElement2, true);
                String newString2 = null;
                if (fileName.startsWith("requestHeaderBodyXmlEntityOpenOnly")) {
                    newString2 = resourceAsString.replace("</soapenv:Header>", newHeader2 + "</soapenv:Header>");
                    newString2 = newString2.replace("<soapenv:Header>", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\">");
                    newString2 = newString2.replaceFirst("<xsd:skcotSyub>", "<xsd:skcotSyub xmlns:xsd=\"http://services.samples/xsd\">");
                    int indexOf = newString2.indexOf("<soapenv:Body>");
                    ArrayList<String> listSrc = new ArrayList<String>();
                    listSrc.add("&lt;redro>&lt;lobmys>IBM&lt;/lobmys>&lt;DIreyub>asankha&lt;/DIreyub>&lt;ecirp>140.34&lt;/ecirp>&lt;emulov>2000&lt;/emulov>&lt;/redro>");
                    listSrc.add("&lt;redro>&lt;lobmys>MSFT&lt;/lobmys>&lt;DIreyub>ruwan&lt;/DIreyub>&lt;ecirp>23.56&lt;/ecirp>&lt;emulov>8030&lt;/emulov>&lt;/redro>");
                    listSrc.add("&lt;redro>&lt;lobmys>SUN&lt;/lobmys>&lt;DIreyub>indika&lt;/DIreyub>&lt;ecirp>14.56&lt;/ecirp>&lt;emulov>500&lt;/emulov>&lt;/redro>");
                    listSrc.add("&lt;redro>&lt;lobmys>GOOG&lt;/lobmys>&lt;DIreyub>chathura&lt;/DIreyub>&lt;ecirp>60.24&lt;/ecirp>&lt;emulov>40000&lt;/emulov>&lt;/redro>");
                    ArrayList<String> listDest = new ArrayList<String>();
                    listDest.add("&lt;redro&gt;&lt;lobmys&gt;IBM&lt;/lobmys&gt;&lt;DIreyub&gt;asankha&lt;/DIreyub&gt;&lt;ecirp&gt;140.34&lt;/ecirp&gt;&lt;emulov&gt;2000&lt;/emulov&gt;&lt;/redro&gt;");
                    listDest.add("&lt;redro&gt;&lt;lobmys&gt;MSFT&lt;/lobmys&gt;&lt;DIreyub&gt;ruwan&lt;/DIreyub&gt;&lt;ecirp&gt;23.56&lt;/ecirp&gt;&lt;emulov&gt;8030&lt;/emulov&gt;&lt;/redro&gt;");
                    listDest.add("&lt;redro&gt;&lt;lobmys&gt;SUN&lt;/lobmys&gt;&lt;DIreyub&gt;indika&lt;/DIreyub&gt;&lt;ecirp&gt;14.56&lt;/ecirp&gt;&lt;emulov&gt;500&lt;/emulov&gt;&lt;/redro&gt;");
                    listDest.add("&lt;redro&gt;&lt;lobmys&gt;GOOG&lt;/lobmys&gt;&lt;DIreyub&gt;chathura&lt;/DIreyub&gt;&lt;ecirp&gt;60.24&lt;/ecirp&gt;&lt;emulov&gt;40000&lt;/emulov&gt;&lt;/redro&gt;");
                    for (int j = 0; j < listSrc.size(); ++j) {
                        String src = (String)listSrc.get(j);
                        String dest = (String)listDest.get(j);
                        int ind = newString2.indexOf(src);
                        indexOf = newString2.indexOf("<soapenv:Body>");
                        while (ind > 0 && ind < indexOf) {
                            newString2 = newString2.replaceFirst(src, dest);
                            ind = newString2.indexOf(src);
                            indexOf = newString2.indexOf("<soapenv:Body>");
                        }
                    }
                } else if (fileName.startsWith("requestHeaderACapo")) {
                    newString2 = resourceAsString.replace("</soapenv:Header\n>", newHeader2 + "</soapenv:Header>");
                    newString2 = newString2.replace("<soapenv:Header\nxmlns:xsd=\"http://services.samples/xsd\"\nxmlns:xsd2=\"http://services.samples/xsd\"\nxmlns=\"AltroperTest\"   \n   >", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\" xmlns=\"AltroperTest\" xmlns:xsd=\"http://services.samples/xsd\" xmlns:xsd2=\"http://services.samples/xsd\">");
                } else if (fileName.startsWith("requestHeaderTab_")) {
                    newString2 = resourceAsString.replace("</soapenv:Header\t>", newHeader2 + "</soapenv:Header>");
                    newString2 = newString2.replace("<soapenv:Header\t\txmlns:xsd=\"http://services.samples/xsd\"\t\txmlns:xsd2=\"http://services.samples/xsd\"\t\n\txmlns=\"AltroperTest\"\t\n>", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\" xmlns=\"AltroperTest\" xmlns:xsd=\"http://services.samples/xsd\" xmlns:xsd2=\"http://services.samples/xsd\">");
                    newString2 = newString2.replaceFirst("<xsd:skcotSyub\t>", "<xsd:skcotSyub>");
                    newString2 = newString2.replaceFirst("<redro\t>", "<redro>");
                } else if (fileName.startsWith("requestFirstChildNameHeader") || fileName.startsWith("requestFirstChildNameExactHeader")) {
                    newString2 = resourceAsString.replace("</soap:Header>", newHeader2 + "</soap:Header>");
                    newString2 = newString2.replace("<soap:Header>", "<soap:Header xmlns:soap=\"" + streamReader.getNamespace() + "\">");
                } else if (fileName.contains("Header") || fileName.startsWith("requestSuUnaRigaSoapBodyVuoto")) {
                    if (isOptimizable) {
                        newString2 = resourceAsString.replace("<soapenv:Header>", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\">");
                        if (shortHeader) {
                            newString2 = newString2.replace("<soapenv:Header/>", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\"></soapenv:Header>");
                        }
                        if (!(wsa || shortHeader || cdata)) {
                            newString2 = newString2.replaceFirst("<xsd:skcotSyub>", "<xsd:skcotSyub xmlns:xsd=\"http://services.samples/xsd\">");
                        }
                        newString2 = newString2.replace("</soapenv:Header>", newHeader2 + "</soapenv:Header>");
                        newString2 = newString2.replace("</Header>", newHeader2 + "</Header>");
                        newString2 = newString2.replace("</hdr:Header>", newHeader2 + "</hdr:Header>");
                        if (wsa) {
                            newString2 = newString2.replace("<Header xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">", "<Header xmlns=\"" + streamReader.getNamespace() + "\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                        }
                    } else {
                        newString2 = resourceAsString.replace("</soapenv:Header>", newHeader2 + "</soapenv:Header>");
                    }
                } else if (mixed) {
                    newString2 = resourceAsString.replace("<hdr:Header>", "<hdr:Header xmlns:hdr=\"" + streamReader.getNamespace() + "\">");
                    newString2 = newString2.replace("</Header>", newHeader2 + "</Header>");
                    newString2 = newString2.replace("<hdr:Header>", "<hdr:Header xmlns:hdr=\"" + streamReader.getNamespace() + "\">");
                    newString2 = newString2.replace("<Header>", "<Header xmlns=\"" + streamReader.getNamespace() + "\">");
                    newString2 = newString2.replace("</hdr:Header>", newHeader2 + "</hdr:Header>");
                    newString2 = newString2.replace("<wsa:MessageID>", "<wsa:MessageID xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                    newString2 = newString2.replace("<wsa:ReplyTo>", "<wsa:ReplyTo xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                    newString2 = newString2.replace("<wsa:To>", "<wsa:To xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                    newString2 = newString2.replace("<wsa:Action>", "<wsa:Action xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                } else if (fileName.startsWith("requestEmpty1")) {
                    newString2 = resourceAsString.replace("<soapenv:Body/>", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\">" + newHeader2 + "</soapenv:Header><soapenv:Body/>");
                } else if (fileName.startsWith("requestEmpty2")) {
                    newString2 = resourceAsString.replace("<Body>", "<Header xmlns=\"" + streamReader.getNamespace() + "\">" + newHeader2 + "</Header><Body>");
                } else if (fileName.startsWith("soapFault_soap")) {
                    newString2 = resourceAsString.replace("<" + defaultDomPrefix + ":Body>", "<" + defaultDomPrefix + ":Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\">" + newHeader2 + "</" + defaultDomPrefix + ":Header><" + defaultDomPrefix + ":Body>");
                    newString2 = newString2.replace("xmlns:soapenv", "xmlns:" + defaultDomPrefix);
                } else if (fileName.startsWith("soapFaultLong_soap11")) {
                    newString2 = resourceAsString.replace("<env:Header />\n    <env:Body>", "<env:Header xmlns:env=\"" + streamReader.getNamespace() + "\">" + newHeader2 + "</env:Header><env:Body>");
                } else if (fileName.startsWith("soapFaultLong_soap12")) {
                    newString2 = resourceAsString.replace("<env:Body>", "<env:Header xmlns:env=\"" + streamReader.getNamespace() + "\">" + newHeader2 + "</env:Header><env:Body>");
                } else if (fileName.startsWith("requestSimileSoapFault")) {
                    newString2 = resourceAsString.replace("<" + defaultDomPrefix + ":Body>", "<" + defaultDomPrefix + ":Header xmlns:" + defaultDomPrefix + "=\"" + streamReader.getNamespace() + "\">" + newHeader2 + "</" + defaultDomPrefix + ":Header><" + defaultDomPrefix + ":Body>");
                } else if (fileName.startsWith("requestMixedPrefixAndCDATA")) {
                    if (fileName.contains("soap11")) {
                        newString2 = resourceAsString.replace("</hdr:Header>", newHeader2 + "</hdr:Header>");
                        newString2 = newString2.replace("<hdr:Header>", "<hdr:Header xmlns:hdr=\"" + streamReader.getNamespace() + "\">");
                    } else {
                        newString2 = resourceAsString.replace("</Header>", newHeader2 + "</Header>");
                        newString2 = newString2.replace("<Header>", "<Header xmlns=\"" + streamReader.getNamespace() + "\">");
                    }
                    newString2 = newString2.replace("<wsa:MessageID>", "<wsa:MessageID xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                    newString2 = newString2.replace("<wsa:ReplyTo>", "<wsa:ReplyTo xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                    newString2 = newString2.replace("<wsa:To>", "<wsa:To xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                    newString2 = newString2.replace("<wsa:Action>", "<wsa:Action xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">");
                } else if (fileName.startsWith("requestSOAPMultipartRelatedMIME") || fileName.startsWith("contentIdMalformedSOAPMultipartRelatedMIME")) {
                    newString2 = resourceAsString.replace("</soapenv:Header>", newHeader2 + "</soapenv:Header>");
                    newString2 = newString2.replace("<soapenv:Header ", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\" ");
                    newString2 = newString2.replace("soapenv:mustUnderstand=\"0\" >", "soapenv:mustUnderstand=\"0\">");
                } else if (fileName.startsWith("requestACapo")) {
                    newString2 = resourceAsString.replace("</soapenv:Header\n>", newHeader2 + "</soapenv:Header>");
                    newString2 = newString2.replace("</soapenv:Header\n\n>", newHeader2 + "</soapenv:Header>");
                    newString2 = newString2.replace("<soapenv:Header\nxmlns:xsd=\"http://services.samples/xsd\"\nxmlns:xsd2=\"http://services.samples/xsd\"\nxmlns=\"AltroperTest\"   \n   >", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\" xmlns=\"AltroperTest\" xmlns:xsd=\"http://services.samples/xsd\" xmlns:xsd2=\"http://services.samples/xsd\">");
                    newString2 = newString2.replace("<xsd:skcotSyub\n>", "<xsd:skcotSyub>");
                    newString2 = newString2.replace("<xsd:skcotSyub\n   >", "<xsd:skcotSyub>");
                    if (fileName.contains("11")) {
                        newString2 = newString2.replaceFirst("<redro\n>", "<redro>");
                    }
                    newString2 = newString2.replaceFirst("</xsd:skcotSyub\n>", "</xsd:skcotSyub>");
                    if (fileName.contains("12")) {
                        newString2 = newString2.replaceFirst("</xsd:skcotSyub\n\n>", "</xsd:skcotSyub>");
                    }
                } else if (fileName.startsWith("requestTab")) {
                    newString2 = resourceAsString.replace("</soapenv:Header\t>", newHeader2 + "</soapenv:Header>");
                    newString2 = newString2.replace("<soapenv:Header\t\txmlns:xsd=\"http://services.samples/xsd\"\t\txmlns:xsd2=\"http://services.samples/xsd\"\t\n\txmlns=\"AltroperTest\"\t\n>", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\" xmlns=\"AltroperTest\" xmlns:xsd=\"http://services.samples/xsd\" xmlns:xsd2=\"http://services.samples/xsd\">");
                    newString2 = newString2.replaceFirst("<xsd:skcotSyub\t>", "<xsd:skcotSyub>");
                    newString2 = newString2.replaceFirst("<redro\t>", "<redro>");
                } else if (fileName.startsWith("requestFirstChildNameBody") || fileName.startsWith("requestFirstChildNameExactBody") || fileName.startsWith("requestSoap12Commentata") || fileName.startsWith("requestSoap11Commentata")) {
                    newString2 = resourceAsString.replace("<soap:Body>", "<soap:Header xmlns:soap=\"" + streamReader.getNamespace() + "\">" + newHeader2 + "</soap:Header><soap:Body>");
                } else if (fileName.startsWith("requestXmlDeclarationACapo")) {
                    newString2 = resourceAsString.replace("</soap:Header>", newHeader2 + "</soap:Header>");
                    newString2 = newString2.replace("<soap:Header>", "<soap:Header xmlns:soap=\"" + streamReader.getNamespace() + "\">");
                } else {
                    newString2 = resourceAsString.replace("<soapenv:Body>", "<soapenv:Header xmlns:soapenv=\"" + streamReader.getNamespace() + "\">" + newHeader2 + "</soapenv:Header><soapenv:Body>");
                    newString2 = newString2.replace("<Body>", "<Header xmlns=\"" + streamReader.getNamespace() + "\">" + newHeader2 + "</Header><Body>");
                }
                if (!isOptimizable) {
                    newString2 = newString2.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n   ", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    newString2 = newString2.replace("</soapenv:Envelope>\n", "</soapenv:Envelope>");
                }
                String check2 = null;
                if (newString2 != null) {
                    newString2 = OptimizedHeaderTest.normalizeReturnLine(newString2);
                    check2 = OptimizedHeaderTest.normalizeReturnLine(bout4.toString());
                }
                if (newString2 != null && !newString2.equals(check2)) {
                    throw new Exception("Contenuto serializzato differente: \nATTESO:\n[" + newString2 + "]\n GENERATO:\n[" + check2 + "]");
                }
                OptimizedHeaderTest.print(i, "finalResourceRaw", bout4.toByteArray(), initial, rapporto_left_interval, rapporto_write_to);
            }
            finally {
                if (isMessage != null) {
                    isMessage.close();
                }
            }
            ++i;
        }
        OptimizedHeaderTest.checkMemoryError();
        contenitor.clear();
    }

    private static long print(int iterazione, String name, Object resource, Long initial, Long rapportoAttesoMin, Long rapportoAttesoMax) throws Exception {
        if (testHeap && iterazione == 0) {
            long l = InstrumentationUtils.deepUsage((Object)resource);
            Object rapporto = "";
            long rapportoOttenuto = -1L;
            if (initial != null) {
                rapportoOttenuto = l / initial;
                rapporto = " (1:" + rapportoOttenuto + ")";
            }
            System.out.println("Dimensione " + name + (String)rapporto + ": " + Utilities.convertBytesToFormatString((long)l, (boolean)true, (String)" "));
            if (initial != null) {
                if (rapportoAttesoMax != null && rapportoAttesoMax == 0L) {
                    rapportoAttesoMin = 0L;
                }
                if (rapportoOttenuto < rapportoAttesoMin || rapportoOttenuto > rapportoAttesoMax) {
                    HashMap map = new HashMap();
                    InstrumentationUtils.deepUsage((Object)resource, map, (int)6);
                    InstrumentationUtils.printToSystemOut(map, (boolean)false);
                    throw new Exception("Atteso un rapporto 1:[" + rapportoAttesoMin + "-" + rapportoAttesoMax + "] mentre \u00e8 stato riscontrato un rapporto 1:" + rapportoOttenuto);
                }
            }
            return l;
        }
        return -1L;
    }

    private static void saveDimensioneOggetto(long dimensione) {
        if (testHeap) {
            dimensioneOggetto = dimensione;
            skip = 0L;
            error.clear();
        }
    }

    private static void printMemory(int iterazione, long interazioniPossibili, long tolleranza_bytes) throws Exception {
        if (testHeap) {
            long diff;
            System.gc();
            long memoryBefore = runtime.totalMemory() - runtime.freeMemory();
            Object increment = "";
            if (precedenteCalcolo > 0L && skip > 3L && precedenteCalcolo > 0L) {
                diff = memoryBefore - precedenteCalcolo;
                long abs = Math.abs(diff);
                increment = " " + (diff < 0L ? "gcclean:-" : "increment:+") + Utilities.convertBytesToFormatString((long)abs, (boolean)true, (String)" ");
            }
            if (printAllIterations || iterazione % 10 == 0) {
                System.out.println("memory-after " + iterazione + "/" + interazioniPossibili + ": " + Utilities.convertBytesToFormatString((long)memoryBefore, (boolean)true, (String)" ") + (String)increment);
            }
            if (dimensioneOggetto > 0L) {
                if (precedenteCalcolo > 0L && ++skip > 3L) {
                    diff = memoryBefore - precedenteCalcolo;
                    if (diff < 0L) {
                        precedenteCalcolo = -1L;
                    } else {
                        long actual;
                        if (diff > dimensioneOggetto && (actual = diff - dimensioneOggetto) > tolleranza_bytes) {
                            error.add(diff + "b");
                        }
                        precedenteCalcolo = memoryBefore;
                    }
                } else {
                    precedenteCalcolo = memoryBefore;
                }
            }
        }
    }

    private static void checkMemoryError() throws Exception {
        if (error.size() > 5) {
            throw new Exception("Atteso un incremento di memoria di " + dimensioneOggetto + "b, riscontrato: " + error.toString());
        }
    }

    private static void verificaConsistenza(String contentType, OpenSPCoop2MessageFactory factory, ByteArrayOutputStream bout, MessageType messageType, String fileName) throws Exception {
        if (!contentType.startsWith("multipart/related")) {
            Element check = MessageXMLUtils.getInstance(factory).newElement(bout.toByteArray());
            check.toString();
            TransportRequestContext req = new TransportRequestContext();
            HashMap parametriTrasporto = new HashMap();
            ArrayList<String> list = new ArrayList<String>();
            list.add(contentType);
            parametriTrasporto.put("Content-Type", list);
            req.setHeaders(parametriTrasporto);
            OpenSPCoop2MessageParseResult parser = factory.createMessage(messageType, req, (InputStream)new ByteArrayInputStream(bout.toByteArray()), null);
            OpenSPCoop2Message msg = parser.getMessage_throwParseException();
            msg.castAsSoap().getSOAPHeader();
            msg.castAsSoap().getSOAPBody();
            msg.castAsSoap().getSOAPPart();
        } else {
            byte[] b = bout.toByteArray();
            String ctMultipartRefreshed = null;
            String ct = MessageType.SOAP_11.equals(messageType) ? "text/xml" : "application/soap+xml";
            ctMultipartRefreshed = fileName.startsWith("requestSOAPMultipartRelatedMIMEpdf") ? ContentTypeUtilities.buildMultipartRelatedContentType((byte[])b, (String)ct, (String)ID_SOAP_ENVELOPE_MULTIPART) : ContentTypeUtilities.buildMultipartRelatedContentType((byte[])b, (String)ct);
            TransportRequestContext req = new TransportRequestContext();
            HashMap parametriTrasporto = new HashMap();
            ArrayList<String> list = new ArrayList<String>();
            list.add(ctMultipartRefreshed);
            parametriTrasporto.put("Content-Type", list);
            req.setHeaders(parametriTrasporto);
            OpenSPCoop2MessageParseResult parser = factory.createMessage(messageType, req, (InputStream)new ByteArrayInputStream(b), null);
            OpenSPCoop2Message msg = parser.getMessage_throwParseException();
            msg.castAsSoap().getSOAPHeader();
            msg.castAsSoap().getSOAPBody();
            msg.castAsSoap().getSOAPPart();
            if (msg.castAsSoap().countAttachments() <= 0) {
                throw new Exception("Attesi attachments");
            }
        }
    }

    private static String normalizeReturnLine(String newString) {
        return newString.replaceAll("\r\n", "\n");
    }
}

