/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.utils;

import java.util.HashMap;
import java.util.List;
import org.openspcoop2.message.ForcedResponseMessage;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.utils.WWWAuthenticateErrorCode;
import org.openspcoop2.utils.transport.TransportUtils;

public class WWWAuthenticateGenerator {
    private WWWAuthenticateGenerator() {
    }

    public static OpenSPCoop2Message buildErrorMessage(WWWAuthenticateErrorCode errorCode, String realm, boolean genericError, String error, String ... scope) {
        return WWWAuthenticateGenerator.buildErrorMessage("Bearer ", errorCode, realm, genericError, error, scope);
    }

    public static OpenSPCoop2Message buildErrorMessage(String headerName, WWWAuthenticateErrorCode errorCode, String realm, boolean genericError, String error, String ... scope) {
        OpenSPCoop2Message errorMessage = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createEmptyMessage(MessageType.BINARY, MessageRole.FAULT);
        ForcedResponseMessage forcedResponseMessage = new ForcedResponseMessage();
        forcedResponseMessage.setContent(null);
        forcedResponseMessage.setContentType(null);
        forcedResponseMessage.setResponseCode("" + WWWAuthenticateGenerator.getReturnCode(errorCode));
        forcedResponseMessage.setHeadersValues(new HashMap<String, List<String>>());
        String headerValue = WWWAuthenticateGenerator.buildHeaderValue(headerName, errorCode, realm, genericError, error, scope);
        TransportUtils.addHeader(forcedResponseMessage.getHeadersValues(), (String)"WWW-Authenticate", (String)headerValue);
        errorMessage.forceResponse(forcedResponseMessage);
        return errorMessage;
    }

    public static int getReturnCode(WWWAuthenticateErrorCode errorCode) {
        switch (errorCode) {
            case invalid_request: {
                return 400;
            }
            case invalid_token: 
            case invalid_dpop_proof: {
                return 401;
            }
            case insufficient_scope: {
                return 403;
            }
        }
        return 500;
    }

    public static String buildHeaderValue(WWWAuthenticateErrorCode errorCode, String realm, boolean genericError, String error, String ... scope) {
        return WWWAuthenticateGenerator.buildHeaderValue("Bearer ", errorCode, realm, genericError, error, scope);
    }

    public static String buildHeaderValue(String headerName, WWWAuthenticateErrorCode errorCode, String realm, boolean genericError, String error, String ... scope) {
        StringBuilder bf = new StringBuilder(headerName);
        bf.append("realm=\"");
        bf.append(realm);
        bf.append("\", error=\"");
        bf.append(errorCode.name());
        bf.append("\", error_description=\"");
        if (!genericError) {
            bf.append(error);
        }
        WWWAuthenticateGenerator.setErrorDescription(errorCode, genericError, bf);
        bf.append("\"");
        if (scope != null && scope.length > 0) {
            bf.append(", scope=\"");
            for (int i = 0; i < scope.length; ++i) {
                if (i > 0) {
                    bf.append(",");
                }
                bf.append(scope[i]);
            }
            bf.append("\"");
        }
        return bf.toString();
    }

    private static void setErrorDescription(WWWAuthenticateErrorCode errorCode, boolean genericError, StringBuilder bf) {
        switch (errorCode) {
            case invalid_request: {
                if (!genericError) break;
                bf.append("The request is missing a required token parameter");
                break;
            }
            case invalid_token: {
                if (!genericError) break;
                bf.append("Token invalid");
                break;
            }
            case insufficient_scope: {
                if (!genericError) break;
                bf.append("The request requires higher privileges than provided by the access token");
                break;
            }
            case invalid_dpop_proof: {
                if (!genericError) break;
                bf.append("DPoP proof invalid");
            }
        }
    }

    public static String buildBasicHeaderValue(String realm) {
        StringBuilder bf = new StringBuilder("Basic ");
        bf.append("realm=\"");
        bf.append(realm);
        bf.append("\"");
        return bf.toString();
    }

    public static String buildCustomHeaderValue(String auth, String realm, WWWAuthenticateErrorCode errorCode, String errorDescription) {
        return WWWAuthenticateGenerator.buildCustomHeaderValue(auth, realm, errorCode != null ? errorCode.name() : null, errorDescription);
    }

    public static String buildCustomHeaderValue(String auth, String realm, String errorCode, String errorDescription) {
        StringBuilder bf = new StringBuilder(auth);
        bf.append(" realm=\"");
        bf.append(realm);
        bf.append("\"");
        if (errorCode != null) {
            bf.append(", error=\"");
            bf.append(errorCode);
            bf.append("\"");
        }
        if (errorDescription != null) {
            bf.append(", error_description=\"");
            bf.append(errorDescription);
            bf.append("\"");
        }
        return bf.toString();
    }
}

