/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.PDNDResolver;
import org.openspcoop2.pdd.core.keystore.KeystoreException;
import org.openspcoop2.pdd.core.keystore.RemoteStoreConfigPropertiesUtils;
import org.openspcoop2.protocol.basic.BasicStaticInstanceConfig;
import org.openspcoop2.protocol.modipa.config.ModIAuditConfig;
import org.openspcoop2.protocol.modipa.config.ModIInstanceProperties;
import org.openspcoop2.protocol.modipa.config.ModISignalHubConfig;
import org.openspcoop2.protocol.modipa.utils.ModISecurityConfig;
import org.openspcoop2.protocol.sdk.ModIPDNDClientConfig;
import org.openspcoop2.protocol.sdk.ModIPDNDOrganizationConfig;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.certificate.remote.RemoteKeyType;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.digest.DigestEncoding;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;

public class ModIProperties {
    private Logger log = null;
    private static ModIProperties modipaProperties = null;
    private static final String PREFIX_PROPRIETA = "Propriet\u00e0 '";
    private static final String SUFFIX_NON_TROVATA = " non trovata";
    private ModIInstanceProperties reader;
    private static final String INVALID_VALUE = "Invalid value";
    private Boolean generateIDasUUID = null;
    private String sicurezzaMessaggioCertificatiTrustStoreTipo = null;
    private Boolean sicurezzaMessaggioCertificatiTrustStoreTipoReaded = null;
    private String sicurezzaMessaggioCertificatiTrustStorePath = null;
    private String sicurezzaMessaggioCertificatiTrustStorePassword = null;
    private Boolean sicurezzaMessaggioCertificatiTrustStoreCrlsReaded = null;
    private String sicurezzaMessaggioCertificatiTrustStoreCrls = null;
    private Boolean sicurezzaMessaggioCertificatiTrustStoreOcspPolicyReaded = null;
    private String sicurezzaMessaggioCertificatiTrustStoreOcspPolicy = null;
    private String sicurezzaMessaggioSslTrustStoreTipo = null;
    private Boolean sicurezzaMessaggioSslTrustStoreTipoReaded = null;
    private String sicurezzaMessaggioSslTrustStorePath = null;
    private String sicurezzaMessaggioSslTrustStorePassword = null;
    private Boolean sicurezzaMessaggioSslTrustStoreCrlsReaded = null;
    private String sicurezzaMessaggioSslTrustStoreCrls = null;
    private Boolean sicurezzaMessaggioSslTrustStoreOcspPolicyReaded = null;
    private String sicurezzaMessaggioSslTrustStoreOcspPolicy = null;
    private static final String REMOTE_STORE_PREFIX_PROPERTY = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.remoteStore.";
    private Map<String, Integer> apiPDNDVersion = new HashMap<String, Integer>();
    private List<RemoteStoreConfig> remoteStoreConfig = null;
    private Map<String, RemoteKeyType> remoteStoreKeyTypeMap = null;
    private static final String URL_CHAR_DELIMITER = "/";
    private List<String> validazioneTokenOAuthClaimsRequired = null;
    private Map<String, List<String>> validazioneTokenOAuthClaimsRequiredSoggetto = new HashMap<String, List<String>>();
    private List<String> validazioneTokenPDNDClaimsRequired = null;
    private Map<String, List<String>> validazioneTokenPDNDClaimsRequiredSoggetto = new HashMap<String, List<String>>();
    private static final String PREFIX_PROPERTY_MODIPA_PDND = "org.openspcoop2.protocol.modipa.pdnd.";
    private Boolean isValidazioneTokenPDNDProducerIdCheck = null;
    private Map<String, Boolean> isValidazioneTokenPDNDProducerIdCheckSoggetto = new HashMap<String, Boolean>();
    private Boolean isPdndProducerIdCheckUnique = null;
    private Boolean isValidazioneTokenPDNDEServiceIdCheck = null;
    private Map<String, Boolean> isValidazioneTokenPDNDEServiceIdCheckSoggetto = new HashMap<String, Boolean>();
    private Boolean isPdndEServiceIdCheckUnique = null;
    private Boolean isValidazioneTokenPDNDDescriptorIdCheck = null;
    private Map<String, Boolean> isValidazioneTokenPDNDDescriptorIdCheckSoggetto = new HashMap<String, Boolean>();
    private Boolean isPdndDescriptorIdCheckUnique = null;
    private static final String PREFIX_API_PDND = "org.openspcoop2.protocol.modipa.pdnd.api";
    private String getApiPDNDBaseUrlVersionPattern = null;
    private static final String PREFIX_API_PDND_V = "org.openspcoop2.protocol.modipa.pdnd.api.v";
    private Map<String, String> getApiPDNDClientKeysPath = new HashMap<String, String>();
    private Map<String, String> getApiPDNDClientKeysJsonPath = new HashMap<String, String>();
    private Map<String, String> getApiPDNDServerKeysPath = new HashMap<String, String>();
    private Map<String, String> getApiPDNDServerKeysJsonPath = new HashMap<String, String>();
    private Map<String, Boolean> isApiPDNDServerKeysFaultClientCheck = new HashMap<String, Boolean>();
    private Map<String, String> getApiPDNDEventKeysPath = new HashMap<String, String>();
    private Map<String, String> getApiPDNDEventKeysParameterLastEventId = new HashMap<String, String>();
    private Map<String, String> getApiPDNDEventKeysParameterLastEventIdFirstValue = new HashMap<String, String>();
    private Map<String, String> getApiPDNDEventKeysParameterLimit = new HashMap<String, String>();
    private Map<String, String> getApiPDNDClientsVersionPatttern = new HashMap<String, String>();
    private Map<String, String> getApiPDNDClientsPath = new HashMap<String, String>();
    private Map<String, String> getApiPDNDClientsIdJsonPath = new HashMap<String, String>();
    private Map<String, String> getApiPDNDClientsOrganizationJsonPath = new HashMap<String, String>();
    private Map<String, String> getApiPDNDClientsNameJsonPath = new HashMap<String, String>();
    private Map<String, String> getApiPDNDClientsDescriptionJsonPath = new HashMap<String, String>();
    private Map<String, String> getApiPDNDOrganizationsVersionPatttern = new HashMap<String, String>();
    private Map<String, String> getApiPDNDOrganizationsPath = new HashMap<String, String>();
    private Map<String, String> getApiPDNDOrganizationsIdJsonPath = new HashMap<String, String>();
    private Map<String, String> getApiPDNDOrganizationsNameJsonPath = new HashMap<String, String>();
    private Map<String, String> getApiPDNDOrganizationsExternalOriginJsonPath = new HashMap<String, String>();
    private Map<String, String> getApiPDNDOrganizationsExternalIdJsonPath = new HashMap<String, String>();
    private Map<String, String> getApiPDNDOrganizationsCategoryJsonPath = new HashMap<String, String>();
    private Map<String, String> getApiPDNDOrganizationsSubunitJsonPath = new HashMap<String, String>();
    private String sicurezzaMessaggioCertificatiKeyStoreTipo = null;
    private Boolean sicurezzaMessaggioCertificatiKeyStoreTipoReaded = null;
    private String sicurezzaMessaggioCertificatiKeyStorePath = null;
    private String sicurezzaMessaggioCertificatiKeyStorePassword = null;
    private String sicurezzaMessaggioCertificatiKeyAlias = null;
    private String sicurezzaMessaggioCertificatiKeyPassword = null;
    private Boolean sicurezzaMessaggioCertificatiKeyClientIdRead = null;
    private String sicurezzaMessaggioCertificatiKeyClientId = null;
    private Boolean sicurezzaMessaggioCertificatiKeyKidRead = null;
    private String sicurezzaMessaggioCertificatiKeyKid = null;
    private Boolean isSicurezzaMessaggioCorniceSicurezzaEnabled = null;
    private String sicurezzaMessaggioCorniceSicurezzaRestCodiceEnte = null;
    private String sicurezzaMessaggioCorniceSicurezzaRestUser = null;
    private String sicurezzaMessaggioCorniceSicurezzaRestIpuser = null;
    private String sicurezzaMessaggioCorniceSicurezzaSoapCodiceEnte = null;
    private Boolean sicurezzaMessaggioCorniceSicurezzaSoapCodiceEnteReaded = null;
    private String sicurezzaMessaggioCorniceSicurezzaSoapUser = null;
    private String sicurezzaMessaggioCorniceSicurezzaSoapIpuser = null;
    private List<String> sicurezzaMessaggioCorniceSicurezzaDynamicCodiceEnte = null;
    private List<String> sicurezzaMessaggioCorniceSicurezzaDynamicUser = null;
    private List<String> sicurezzaMessaggioCorniceSicurezzaDynamicIpuser = null;
    private List<ModIAuditConfig> auditConfig = null;
    private String getSecurityTokenHeaderAudit = null;
    private Boolean isSecurityTokenAuditX509AddKid = null;
    private Boolean isSecurityTokenAuditApiSoapX509RiferimentoX5c = null;
    private Boolean isSecurityTokenAuditApiSoapX509RiferimentoX5cSingleCertificate = null;
    private Boolean isSecurityTokenAuditApiSoapX509RiferimentoX5u = null;
    private Boolean isSecurityTokenAuditApiSoapX509RiferimentoX5t = null;
    private Boolean getSecurityTokenAuditProcessArrayModeReaded = null;
    private Boolean getSecurityTokenAuditProcessArrayModeEnabled = null;
    private Boolean isSecurityTokenAuditAddPurposeId = null;
    private Boolean isSecurityTokenAuditExpectedPurposeId = null;
    private Boolean isSecurityTokenAuditCompareAuthorizationPurposeId = null;
    private Integer getSecurityTokenAuditDnonceSize = null;
    private String getSecurityTokenAuditDigestAlgorithm = null;
    private Boolean isTokenAuthCacheable = null;
    private Boolean isTokenAuditCacheable = null;
    private Integer isGestioneTokenCacheableRefreshTokenBeforeExpirePercent = null;
    private Boolean isGestioneTokenCacheableRefreshTokenBeforeExpirePercentRead = null;
    private String isGestioneTokenCacheableRefreshTokenBeforeExpirePercentPName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.cache.refreshTokenBeforeExpire.percent";
    private Integer sGestioneTokenCacheableRefreshTokenBeforeExpireSeconds = null;
    private Boolean sGestioneTokenCacheableRefreshTokenBeforeExpireSecondsRead = null;
    private String sGestioneTokenCacheableRefreshTokenBeforeExpireSecondsPName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.cache.refreshTokenBeforeExpire.seconds";
    private Boolean isGenerazioneTracce = null;
    private Boolean isGenerazioneTracceRegistraToken = null;
    private Boolean isGenerazioneTracceRegistraCustomClaims = null;
    private List<String> getGenerazioneTracceRegistraCustomClaimsBlackList = null;
    private Boolean isModIVersioneBozza = null;
    private String getRestSecurityTokenHeader = null;
    private Boolean isSecurityTokenX509AddKid = null;
    private Boolean isSecurityTokenIntegrity01AddPurposeId = null;
    private Boolean isSecurityTokenIntegrity02AddPurposeId = null;
    private Boolean getRestSecurityTokenClaimsIssuerEnabledReaded = null;
    private Boolean getRestSecurityTokenClaimsIssuerEnabled = null;
    private Boolean getRestSecurityTokenClaimsIssuerHeaderValueReaded = null;
    private String getRestSecurityTokenClaimsIssuerHeaderValue = null;
    private Boolean getRestSecurityTokenClaimsSubjectEnabledReaded = null;
    private Boolean getRestSecurityTokenClaimsSubjectEnabled = null;
    private Boolean getRestSecurityTokenClaimsSubjectHeaderValueReaded = null;
    private String getRestSecurityTokenClaimsSubjectHeaderValue = null;
    private String getRestSecurityTokenClaimsClientIdHeader = null;
    private String getRestSecurityTokenClaimSignedHeaders = null;
    private String getRestSecurityTokenClaimRequestDigest = null;
    private String[] getRestSecurityTokenSignedHeaders = null;
    private Boolean getRestSecurityTokenClaimsIatTimeCheckFutureToleranceMillisecondsReaded = null;
    private Long getRestSecurityTokenClaimsIatTimeCheckFutureToleranceMilliseconds = null;
    private Boolean getRestSecurityTokenClaimsIatTimeCheckMillisecondsReaded = null;
    private Long getRestSecurityTokenClaimsIatTimeCheckMilliseconds = null;
    private Boolean isRestSecurityTokenClaimsExpTimeCheck = null;
    private Boolean getRestSecurityTokenClaimsExpTimeCheckToleranceMillisecondsReaded = null;
    private Long getRestSecurityTokenClaimsExpTimeCheckToleranceMilliseconds = null;
    private Boolean getRestSecurityTokenClaimsNbfTimeCheckToleranceMillisecondsReaded = null;
    private Long getRestSecurityTokenClaimsNbfTimeCheckToleranceMilliseconds = null;
    private DigestEncoding getRestSecurityTokenDigestDefaultEncoding = null;
    private Boolean isRestSecurityTokenDigestEncodingChoice = null;
    private List<DigestEncoding> getRestSecurityTokenDigestEncodingAccepted = null;
    private Boolean getRestSecurityTokenRequestDigestCleanReaded = null;
    private Boolean getRestSecurityTokenRequestDigestClean = null;
    private Boolean getRestSecurityTokenResponseDigestCleanReaded = null;
    private Boolean getRestSecurityTokenResponseDigestClean = null;
    private Boolean getRestSecurityTokenResponseDigestHEADuseServerHeaderReaded = null;
    private Boolean getRestSecurityTokenResponseDigestHEADuseServerHeader = null;
    private Boolean getRestSecurityTokenFaultProcessEnabledReaded = null;
    private Boolean getRestSecurityTokenFaultProcessEnabled = null;
    private Boolean getRestSecurityTokenAudienceProcessArrayModeReaded = null;
    private Boolean getRestSecurityTokenAudienceProcessArrayModeEnabled = null;
    private Boolean getRestResponseSecurityTokenAudienceDefaultReaded = null;
    private String getRestResponseSecurityTokenAudienceDefault = null;
    private String getRestCorrelationIdHeader = null;
    private String getRestReplyToHeader = null;
    private String getRestLocationHeader = null;
    private Boolean getRestProfiliInterazioneCheckCompatibilityReaded = null;
    private Boolean getRestProfiliInterazioneCheckCompatibility = null;
    private Integer[] getRestBloccanteHttpStatus = null;
    private List<HttpRequestMethod> getRestBloccanteHttpMethod = null;
    private Boolean getRestSecurityTokenPushReplyToUpdateOrCreate = null;
    private Boolean getRestSecurityTokenPushReplyToUpdate = null;
    private Boolean getRestSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists = null;
    private Integer[] getRestSecurityTokenPushRequestHttpStatus = null;
    private List<HttpRequestMethod> getRestNonBloccantePushRequestHttpMethod = null;
    private Integer[] getRestSecurityTokenPushResponseHttpStatus = null;
    private List<HttpRequestMethod> getRestNonBloccantePushResponseHttpMethod = null;
    private List<HttpRequestMethod> getRestNonBloccantePushHttpMethod = null;
    private Integer[] getRestSecurityTokenPullRequestHttpStatus = null;
    private List<HttpRequestMethod> getRestNonBloccantePullRequestHttpMethod = null;
    private Integer[] getRestSecurityTokenPullRequestStateNotReadyHttpStatus = null;
    private Integer[] getRestSecurityTokenPullRequestStateOkHttpStatus = null;
    private List<HttpRequestMethod> getRestNonBloccantePullRequestStateHttpMethod = null;
    private Integer[] getRestSecurityTokenPullResponseHttpStatus = null;
    private List<HttpRequestMethod> getRestNonBloccantePullResponseHttpMethod = null;
    private List<HttpRequestMethod> getRestNonBloccantePullHttpMethod = null;
    private Boolean getSoapSecurityTokenMustUnderstandReaded = null;
    private Boolean getSoapSecurityTokenMustUnderstand = null;
    private Boolean getSoapSecurityTokenActorReaded = null;
    private String getSoapSecurityTokenActor = null;
    private Boolean getSoapSecurityTokenTimestampCreatedTimeCheckMillisecondsReaded = null;
    private Long getSoapSecurityTokenTimestampCreatedTimeCheckMilliseconds = null;
    private Boolean getSoapSecurityTokenTimestampCreatedTimeCheckFutureToleranceMillisecondsReaded = null;
    private Long getSoapSecurityTokenTimestampCreatedTimeCheckFutureToleranceMilliseconds = null;
    private Boolean getSoapSecurityTokenFaultProcessEnabledReaded = null;
    private Boolean getSoapSecurityTokenFaultProcessEnabled = null;
    private Boolean isSoapSecurityTokenTimestampExpiresTimeCheck = null;
    private Boolean getSoapSecurityTokenTimestampExpiresTimeCheckToleranceMillisecondsReaded = null;
    private Long getSoapSecurityTokenTimestampExpiresTimeCheckToleranceMilliseconds = null;
    private Boolean getSoapWSAddressingMustUnderstandReaded = null;
    private Boolean getSoapWSAddressingMustUnderstand = null;
    private Boolean getSoapWSAddressingActorReaded = null;
    private String getSoapWSAddressingActor = null;
    private Boolean getSoapWSAddressingSchemaValidationReaded = null;
    private Boolean getSoapWSAddressingSchemaValidation = null;
    private String getSoapCorrelationIdName = null;
    private String getSoapCorrelationIdNamespace = null;
    private String getSoapCorrelationIdPrefix = null;
    private Boolean getSoapCorrelationIdMustUnderstandReaded = null;
    private Boolean getSoapCorrelationIdMustUnderstand = null;
    private Boolean getSoapCorrelationIdActorReaded = null;
    private String getSoapCorrelationIdActor = null;
    private String getSoapReplyToName = null;
    private String getSoapReplyToNamespace = null;
    private String getSoapReplyToPrefix = null;
    private Boolean getSoapReplyToMustUnderstandReaded = null;
    private Boolean getSoapReplyToMustUnderstand = null;
    private Boolean getSoapReplyToActorReaded = null;
    private String getSoapReplyToActor = null;
    private String getSoapRequestDigestName = null;
    private String getSoapRequestDigestNamespace = null;
    private String getSoapRequestDigestPrefix = null;
    private Boolean getSoapRequestDigestMustUnderstandReaded = null;
    private Boolean getSoapRequestDigestMustUnderstand = null;
    private Boolean getSoapRequestDigestActorReaded = null;
    private String getSoapRequestDigestActor = null;
    private Boolean getSoapSecurityTokenWsaToReaded = null;
    private String getSoapSecurityTokenWsaTo = null;
    private Boolean getSoapSecurityTokenWsaToSoapAction = null;
    private Boolean getSoapSecurityTokenWsaToOperation = null;
    private Boolean getSoapSecurityTokenWsaToNone = null;
    private Boolean getSoapResponseSecurityTokenAudienceDefaultReaded = null;
    private String getSoapResponseSecurityTokenAudienceDefault = null;
    private Boolean getSoapSecurityTokenPushReplyToUpdateOrCreate = null;
    private Boolean getSoapSecurityTokenPushReplyToUpdate = null;
    private Boolean getSoapSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists = null;
    private Boolean getSoapSecurityTokenPullCorrelationIdUseTransactionIdIfNotExists = null;
    private Boolean isReadByPathBufferEnabled = null;
    private Boolean isValidazioneBufferEnabled = null;
    private Boolean isRiferimentoIDRichiestaPortaDelegataRequired = null;
    private Boolean isRiferimentoIDRichiestaPortaDelegataRequiredRead = null;
    private Boolean isRiferimentoIDRichiestaPortaApplicativaRequired = null;
    private Boolean isRiferimentoIDRichiestaPortaApplicativaRequiredRead = null;
    private Boolean isTokenOAuthUseJtiIntegrityAsMessageId = null;
    private Boolean isTokenOAuthUseJtiIntegrityAsMessageIdRead = null;
    private Boolean isPortaApplicativaBustaErrorePersonalizzaElementiFault = null;
    private Boolean isPortaApplicativaBustaErrorePersonalizzaElementiFaultRead = null;
    private Boolean isPortaApplicativaBustaErroreAggiungiErroreApplicativo = null;
    private Boolean isPortaApplicativaBustaErroreAggiungiErroreApplicativoRead = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolValidazione = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolProcessamento = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationServerError = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationClientError = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = null;
    private BooleanNullable isAggiungiDetailErroreApplicativoSoapFaultApplicativo = null;
    private Boolean isAggiungiDetailErroreApplicativoSoapFaultApplicativoRead = null;
    private BooleanNullable isAggiungiDetailErroreApplicativoSoapFaultPdD = null;
    private Boolean isAggiungiDetailErroreApplicativoSoapFaultPdDRead = null;
    private Boolean useConfigStaticInstance = null;
    private Boolean useErroreApplicativoStaticInstance = null;
    private Boolean useEsitoStaticInstance = null;
    private BasicStaticInstanceConfig staticInstanceConfig = null;
    private Boolean signalHubEnabled = null;
    private Boolean signalHubPseudonymizationChoiceEnabled = null;
    private List<String> signalHubAlgorithms = null;
    private String signalHubDefaultAlgorithm = null;
    private List<Integer> signalHubSeedSize = null;
    private Integer signalHubDefaultSeedSize = null;
    private Boolean signalHubSeedLifetimeUnlimited = null;
    private Integer signalHubDefaultSeedLifetimeDaysDefault = null;
    private String signalHubSoapNamespace = null;
    private String signalHubApiName = null;
    private Integer signalHubApiVersion = null;
    private ModISignalHubConfig signalHubConfig = null;
    private String signalHubHashCompose = null;
    private Integer signalHubDigestHistroy = null;
    private Boolean tracingPDNDEnabled = null;

    private ModIProperties(String confDir, Logger log) throws ProtocolException {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger((String)"ModIProperties");
        if (confDir != null) {
            // empty if block
        }
        Properties propertiesReader = new Properties();
        try (InputStream properties = ModIProperties.class.getResourceAsStream("/modipa.properties");){
            if (properties == null) {
                throw new ProtocolException("File '/modipa.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.logError("Riscontrato errore durante la lettura del file 'modipa.properties': " + e.getMessage());
            throw new ProtocolException("ModIProperties initialize error: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.reader = new ModIInstanceProperties(propertiesReader, this.log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static synchronized void initialize(String confDir, Logger log) throws ProtocolException {
        if (modipaProperties == null) {
            modipaProperties = new ModIProperties(confDir, log);
        }
    }

    public static ModIProperties getInstance() throws ProtocolException {
        if (modipaProperties == null) {
            Class<ModIProperties> clazz = ModIProperties.class;
            synchronized (ModIProperties.class) {
                throw new ProtocolException("ModIProperties not initialized (use init method in factory)");
            }
        }
        return modipaProperties;
    }

    private void logDebug(String msg) {
        this.log.debug(msg);
    }

    private void logWarn(String msg) {
        this.log.warn(msg);
    }

    private void logError(String msg, Exception e) {
        this.log.error(msg, (Throwable)e);
    }

    private void logError(String msg) {
        this.log.error(msg);
    }

    private String getPrefixProprieta(String propertyName) {
        return PREFIX_PROPRIETA + propertyName + "'";
    }

    private String getPrefixValoreIndicatoProprieta(String value, String name) {
        return "Valore '" + value + "' indicato nella propriet\u00e0 '" + name + "'";
    }

    private String getSuffixSuperioreMassimoConsentitoControlloDisabilitato(long maxLongValue) {
        return " superiore al massimo consentito '" + maxLongValue + "'; il controllo viene disabilitato";
    }

    private String getMessaggioVerificaDisabilitata(String name) {
        return "Verifica gestita tramite la propriet\u00e0 '" + name + "' disabilitata.";
    }

    private String getMessaggioErroreProprietaNonImpostata(String propertyName, Boolean defaultValue) {
        return this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue.toString());
    }

    private String getMessaggioErroreProprietaNonImpostata(String propertyName, Integer defaultValue) {
        return this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue.toString());
    }

    private String getMessaggioErroreProprietaNonImpostata(String propertyName, String defaultValue) {
        return this.getPrefixProprieta(propertyName) + " non impostata, viene utilizzato il default=" + defaultValue;
    }

    private String getMessaggioErroreProprietaNonImpostata(String pName, Exception e) {
        return this.getPrefixProprieta(pName) + " non impostata, errore:" + e.getMessage();
    }

    private String getMessaggioErroreProprietaNonCorretta(String pName, Exception e) {
        return this.getPrefixProprieta(pName) + " non corretta, errore:" + e.getMessage();
    }

    private String getSuffixErrore(Exception e) {
        return ", errore:" + e.getMessage();
    }

    private ProtocolException newProtocolExceptionPropertyNonDefinita() {
        return new ProtocolException("non definita");
    }

    public void validaConfigurazione(Loader loader) throws ProtocolException {
        try {
            int[] apiPdndVersion;
            List<RemoteStoreConfig> rsc;
            String sslTrustStoreType;
            if (loader != null) {
                // empty if block
            }
            this.generateIDasUUID();
            String trustStoreType = this.getSicurezzaMessaggioCertificatiTrustStoreTipo();
            if (trustStoreType != null) {
                if (!HSMUtils.isKeystoreHSM((String)trustStoreType)) {
                    this.getSicurezzaMessaggioCertificatiTrustStorePath();
                    this.getSicurezzaMessaggioCertificatiTrustStorePassword();
                }
                this.getSicurezzaMessaggioCertificatiTrustStoreCrls();
                this.getSicurezzaMessaggioCertificatiTrustStoreOcspPolicy();
            }
            if ((sslTrustStoreType = this.getSicurezzaMessaggioSslTrustStoreTipo()) != null) {
                if (!HSMUtils.isKeystoreHSM((String)sslTrustStoreType)) {
                    this.getSicurezzaMessaggioSslTrustStorePath();
                    this.getSicurezzaMessaggioSslTrustStorePassword();
                }
                this.getSicurezzaMessaggioSslTrustStoreCrls();
                this.getSicurezzaMessaggioSslTrustStoreOcspPolicy();
            }
            if ((rsc = this.getRemoteStoreConfig()) != null && !rsc.isEmpty()) {
                for (RemoteStoreConfig remoteStoreConfig : rsc) {
                    this.readAPIPDNDVersionKeys(remoteStoreConfig.getStoreName());
                    this.readAPIPDNDVersionEvents(remoteStoreConfig.getStoreName());
                    this.readAPIPDNDVersionClients(remoteStoreConfig.getStoreName());
                    this.readAPIPDNDVersionOrganizations(remoteStoreConfig.getStoreName());
                }
            }
            this.getValidazioneTokenOAuthClaimsRequired();
            this.getValidazioneTokenPDNDClaimsRequired();
            this.isValidazioneTokenPDNDProducerIdCheck();
            this.isPdndProducerIdCheckUnique();
            this.isValidazioneTokenPDNDEServiceIdCheck();
            this.isPdndEServiceIdCheckUnique();
            this.isValidazioneTokenPDNDDescriptorIdCheck();
            this.isPdndDescriptorIdCheckUnique();
            this.getApiPDNDBaseUrlVersionPattern();
            for (int v : apiPdndVersion = new int[]{1, 2}) {
                this.getApiPDNDClientsVersionPatttern(v);
                this.getApiPDNDOrganizationsVersionPatttern(v);
                this.getApiPDNDClientKeysPath(v);
                this.getApiPDNDClientKeysJsonPath(v);
                this.getApiPDNDServerKeysPath(v);
                this.getApiPDNDServerKeysJsonPath(v);
                this.isApiPDNDServerKeysFaultClientCheck(v);
                this.getApiPDNDEventKeysPath(v);
                this.getApiPDNDEventKeysParameterLastEventId(v);
                this.getApiPDNDEventKeysParameterLastEventIdFirstValue(v);
                this.getApiPDNDEventKeysParameterLimit(v);
                this.getApiPDNDClientsPath(v);
                this.getApiPDNDClientsIdJsonPath(v);
                this.getApiPDNDClientsOrganizationJsonPath(v);
                this.getApiPDNDClientsNameJsonPath(v);
                this.getApiPDNDClientsDescriptionJsonPath(v);
                this.getApiPDNDOrganizationsPath(v);
                this.getApiPDNDOrganizationsIdJsonPath(v);
                this.getApiPDNDOrganizationsNameJsonPath(v);
                this.getApiPDNDOrganizationsExternalOriginJsonPath(v);
                this.getApiPDNDOrganizationsExternalIdJsonPath(v);
                this.getApiPDNDOrganizationsCategoryJsonPath(v);
                this.getApiPDNDOrganizationsSubunitJsonPath(v);
            }
            String string = this.getSicurezzaMessaggioCertificatiKeyStoreTipo();
            if (string != null) {
                if (!HSMUtils.isKeystoreHSM((String)string)) {
                    this.getSicurezzaMessaggioCertificatiKeyStorePath();
                    this.getSicurezzaMessaggioCertificatiKeyStorePassword();
                }
                this.getSicurezzaMessaggioCertificatiKeyAlias();
                if (!HSMUtils.isKeystoreHSM((String)string) || HSMUtils.isHsmConfigurableKeyPassword()) {
                    this.getSicurezzaMessaggioCertificatiKeyPassword();
                }
                this.getSicurezzaMessaggioCertificatiKeyClientId();
                this.getSicurezzaMessaggioCertificatiKeyKid();
            }
            if (this.isSicurezzaMessaggioCorniceSicurezzaEnabled() != null && this.isSicurezzaMessaggioCorniceSicurezzaEnabled().booleanValue()) {
                this.getSicurezzaMessaggioCorniceSicurezzaRestCodiceEnte();
                this.getSicurezzaMessaggioCorniceSicurezzaRestUser();
                this.getSicurezzaMessaggioCorniceSicurezzaRestIpuser();
                this.getSicurezzaMessaggioCorniceSicurezzaSoapCodiceEnte();
                this.getSicurezzaMessaggioCorniceSicurezzaSoapUser();
                this.getSicurezzaMessaggioCorniceSicurezzaSoapIpuser();
                this.getSicurezzaMessaggioCorniceSicurezzaDynamicCodiceEnte();
                this.getSicurezzaMessaggioCorniceSicurezzaDynamicUser();
                this.getSicurezzaMessaggioCorniceSicurezzaDynamicIpuser();
            }
            this.getAuditConfig();
            this.getSecurityTokenHeaderModIAudit();
            this.isSecurityTokenAuditX509AddKid();
            this.isSecurityTokenAuditApiSoapX509RiferimentoX5c();
            this.isSecurityTokenAuditApiSoapX509RiferimentoX5cSingleCertificate();
            this.isSecurityTokenAuditApiSoapX509RiferimentoX5u();
            this.isSecurityTokenAuditApiSoapX509RiferimentoX5t();
            this.isSecurityTokenAuditProcessArrayModeEnabled();
            this.isSecurityTokenAuditAddPurposeId();
            this.isSecurityTokenAuditExpectedPurposeId();
            this.isSecurityTokenAuditCompareAuthorizationPurposeId();
            this.getSecurityTokenAuditDnonceSize();
            this.getSecurityTokenAuditDigestAlgorithm();
            this.isTokenAuthCacheable();
            this.isTokenAuditCacheable();
            this.getGestioneRetrieveTokenRefreshTokenBeforeExpirePercent();
            this.getGestioneRetrieveTokenRefreshTokenBeforeExpireSeconds();
            this.isGenerazioneTracce();
            this.isGenerazioneTracceRegistraToken();
            this.isGenerazioneTracceRegistraCustomClaims();
            this.getGenerazioneTracceRegistraCustomClaimsBlackList();
            this.isModIVersioneBozza();
            this.getRestSecurityTokenHeaderModI();
            this.isSecurityTokenX509AddKid();
            this.isSecurityTokenIntegrity01AddPurposeId();
            this.isSecurityTokenIntegrity02AddPurposeId();
            if (this.isRestSecurityTokenClaimsIssuerEnabled()) {
                this.getRestSecurityTokenClaimsIssuerHeaderValue();
            }
            if (this.isRestSecurityTokenClaimsSubjectEnabled()) {
                this.getRestSecurityTokenClaimsSubjectHeaderValue();
            }
            this.getRestSecurityTokenClaimsClientIdHeader();
            this.getRestSecurityTokenClaimSignedHeaders();
            this.getRestSecurityTokenClaimRequestDigest();
            this.getRestSecurityTokenSignedHeaders();
            this.getRestSecurityTokenClaimsIatTimeCheckMilliseconds();
            this.getRestSecurityTokenClaimsIatTimeCheckFutureToleranceMilliseconds();
            this.isRestSecurityTokenClaimsExpTimeCheck();
            this.getRestSecurityTokenClaimsExpTimeCheckToleranceMilliseconds();
            this.getRestSecurityTokenClaimsNbfTimeCheckToleranceMilliseconds();
            this.getRestSecurityTokenDigestDefaultEncoding();
            this.isRestSecurityTokenDigestEncodingChoice();
            this.getRestSecurityTokenDigestEncodingAccepted();
            this.isRestSecurityTokenRequestDigestClean();
            this.isRestSecurityTokenResponseDigestClean();
            this.isRestSecurityTokenResponseDigestHEADuseServerHeader();
            this.isRestSecurityTokenFaultProcessEnabled();
            this.isRestSecurityTokenAudienceProcessArrayModeEnabled();
            this.getRestResponseSecurityTokenAudienceDefault(null);
            this.getRestCorrelationIdHeader();
            this.getRestReplyToHeader();
            this.getRestLocationHeader();
            this.isRestProfiliInterazioneCheckCompatibility();
            this.getRestBloccanteHttpStatus();
            this.getRestBloccanteHttpMethod();
            this.isRestSecurityTokenPushReplyToUpdateOrCreateInFruizione();
            this.isRestSecurityTokenPushReplyToUpdateInErogazione();
            this.isRestSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists();
            this.getRestNonBloccantePushRequestHttpStatus();
            this.getRestNonBloccantePushRequestHttpMethod();
            this.getRestNonBloccantePushResponseHttpStatus();
            this.getRestNonBloccantePushResponseHttpMethod();
            this.getRestNonBloccantePullRequestHttpStatus();
            this.getRestNonBloccantePullRequestHttpMethod();
            this.getRestNonBloccantePullRequestStateNotReadyHttpStatus();
            this.getRestNonBloccantePullRequestStateOkHttpStatus();
            this.getRestNonBloccantePullRequestStateHttpMethod();
            this.getRestNonBloccantePullResponseHttpStatus();
            this.getRestNonBloccantePullResponseHttpMethod();
            this.isSoapSecurityTokenMustUnderstand();
            this.getSoapSecurityTokenActor();
            this.getSoapSecurityTokenTimestampCreatedTimeCheckMilliseconds();
            this.getSoapSecurityTokenTimestampCreatedTimeCheckFutureToleranceMilliseconds();
            this.isSoapSecurityTokenTimestampExpiresTimeCheck();
            this.getSoapSecurityTokenTimestampExpiresTimeCheckToleranceMilliseconds();
            this.isSoapSecurityTokenFaultProcessEnabled();
            this.isSoapWSAddressingMustUnderstand();
            this.getSoapWSAddressingActor();
            this.getSoapCorrelationIdName();
            this.getSoapCorrelationIdNamespace();
            this.getSoapCorrelationIdPrefix();
            this.useSoapBodyCorrelationIdNamespace();
            this.isSoapCorrelationIdMustUnderstand();
            this.getSoapCorrelationIdActor();
            this.getSoapReplyToName();
            this.getSoapReplyToNamespace();
            this.getSoapReplyToPrefix();
            this.useSoapBodyReplyToNamespace();
            this.isSoapReplyToMustUnderstand();
            this.getSoapReplyToActor();
            this.getSoapRequestDigestName();
            this.getSoapRequestDigestNamespace();
            this.getSoapRequestDigestPrefix();
            this.useSoapBodyRequestDigestNamespace();
            this.isSoapRequestDigestMustUnderstand();
            this.getSoapRequestDigestActor();
            this.getSoapResponseSecurityTokenAudienceDefault(null);
            this.isSoapSecurityTokenWsaToSoapAction();
            this.isSoapSecurityTokenWsaToOperation();
            this.isSoapSecurityTokenWsaToDisabled();
            this.isSoapSecurityTokenPushReplyToUpdateOrCreateInFruizione();
            this.isSoapSecurityTokenPushReplyToUpdateInErogazione();
            this.isSoapSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists();
            this.isReadByPathBufferEnabled();
            this.isValidazioneBufferEnabled();
            this.isRiferimentoIDRichiestaPortaDelegataRequired();
            this.isRiferimentoIDRichiestaPortaApplicativaRequired();
            this.isTokenOAuthUseJtiIntegrityAsMessageId();
            this.isAggiungiDetailErroreApplicativoSoapFaultApplicativo();
            this.isAggiungiDetailErroreApplicativoSoapFaultPdD();
            this.isGenerazioneDetailsSOAPFaultProtocolValidazione();
            this.isGenerazioneDetailsSOAPFaultProtocolProcessamento();
            this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace();
            this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche();
            this.isGenerazioneDetailsSOAPFaultIntegrationServerError();
            this.isGenerazioneDetailsSOAPFaultIntegrationClientError();
            this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace();
            this.isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche();
            this.isPortaApplicativaBustaErrorePersonalizzaElementiFault();
            this.isPortaApplicativaBustaErroreAggiungiErroreApplicativo();
            this.useConfigStaticInstance();
            this.useErroreApplicativoStaticInstance();
            this.useEsitoStaticInstance();
            this.getStaticInstanceConfig();
            if (this.isSignalHubEnabled()) {
                this.isSignalHubPseudonymizationChoiceEnabled();
                this.getSignalHubAlgorithms();
                this.getSignalHubDefaultAlgorithm();
                this.getSignalHubSeedSize();
                this.getSignalHubDefaultSeedSize();
                this.isSignalHubSeedLifetimeUnlimited();
                this.getSignalHubDeSeedSeedLifetimeDaysDefault();
                this.getSignalHubSoapNamespace();
                this.getSignalHubApiName();
                this.getSignalHubApiVersion();
                this.getSignalHubConfig();
                this.getSignalHubSeedSize();
                this.getSignalHubDigestHistroy();
            }
            this.getStaticInstanceConfig();
            this.isTracingPDNDEnabled();
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la validazione della proprieta' del protocollo modipa, " + e.getMessage();
            this.logError(msg, e);
            throw new ProtocolException(msg, (Throwable)e);
        }
    }

    public Boolean generateIDasUUID() {
        if (this.generateIDasUUID == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.modipa.id.uuid";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.generateIDasUUID = Boolean.parseBoolean(value);
                } else {
                    this.logWarn(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.generateIDasUUID = defaultValue;
                }
            }
            catch (Exception e) {
                this.logWarn(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.generateIDasUUID = defaultValue;
            }
        }
        return this.generateIDasUUID;
    }

    public KeystoreParams getSicurezzaMessaggioCertificatiTrustStore() throws ProtocolException {
        KeystoreParams params = null;
        String trustStoreType = this.getSicurezzaMessaggioCertificatiTrustStoreTipo();
        if (trustStoreType != null) {
            params = new KeystoreParams();
            params.setType(trustStoreType);
            params.setPath(this.getSicurezzaMessaggioCertificatiTrustStorePath());
            params.setPassword(this.getSicurezzaMessaggioCertificatiTrustStorePassword());
            params.setCrls(this.getSicurezzaMessaggioCertificatiTrustStoreCrls());
            params.setOcspPolicy(this.getSicurezzaMessaggioCertificatiTrustStoreOcspPolicy());
        }
        return params;
    }

    public String getSicurezzaMessaggioCertificatiTrustStoreTipo() {
        if (this.sicurezzaMessaggioCertificatiTrustStoreTipoReaded == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.trustStore.tipo");
                if (value != null) {
                    this.sicurezzaMessaggioCertificatiTrustStoreTipo = value = value.trim();
                }
                this.sicurezzaMessaggioCertificatiTrustStoreTipoReaded = true;
            }
            catch (Exception e) {
                this.logError("Propriet\u00e0 'org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.trustStore.tipo' non impostata, errore:" + e.getMessage());
                this.sicurezzaMessaggioCertificatiTrustStoreTipoReaded = true;
            }
        }
        return this.sicurezzaMessaggioCertificatiTrustStoreTipo;
    }

    public String getSicurezzaMessaggioCertificatiTrustStorePath() throws ProtocolException {
        if (this.sicurezzaMessaggioCertificatiTrustStorePath == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.trustStore.path");
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.sicurezzaMessaggioCertificatiTrustStorePath = value = value.trim();
            }
            catch (Exception e) {
                this.logError("Propriet\u00e0 'org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.trustStore.path' non impostata, errore:" + e.getMessage());
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCertificatiTrustStorePath;
    }

    public String getSicurezzaMessaggioCertificatiTrustStorePassword() throws ProtocolException {
        if (this.sicurezzaMessaggioCertificatiTrustStorePassword == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.trustStore.password");
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.sicurezzaMessaggioCertificatiTrustStorePassword = value = value.trim();
            }
            catch (Exception e) {
                this.logError("Propriet\u00e0 'org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.trustStore.password' non impostata, errore:" + e.getMessage());
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCertificatiTrustStorePassword;
    }

    public String getSicurezzaMessaggioCertificatiTrustStoreCrls() throws ProtocolException {
        if (this.sicurezzaMessaggioCertificatiTrustStoreCrlsReaded == null) {
            String pName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.trustStore.crls";
            try {
                String value = this.reader.getValueConvertEnvProperties(pName);
                if (value != null) {
                    this.sicurezzaMessaggioCertificatiTrustStoreCrls = value = value.trim();
                }
                this.sicurezzaMessaggioCertificatiTrustStoreCrlsReaded = true;
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCertificatiTrustStoreCrls;
    }

    public String getSicurezzaMessaggioCertificatiTrustStoreOcspPolicy() throws ProtocolException {
        if (this.sicurezzaMessaggioCertificatiTrustStoreOcspPolicyReaded == null) {
            String pName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.trustStore.ocspPolicy";
            try {
                String value = this.reader.getValueConvertEnvProperties(pName);
                if (value != null) {
                    this.sicurezzaMessaggioCertificatiTrustStoreOcspPolicy = value = value.trim();
                }
                this.sicurezzaMessaggioCertificatiTrustStoreOcspPolicyReaded = true;
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCertificatiTrustStoreOcspPolicy;
    }

    public KeystoreParams getSicurezzaMessaggioSslTrustStore() throws ProtocolException {
        KeystoreParams params = null;
        String sslTrustStoreType = this.getSicurezzaMessaggioSslTrustStoreTipo();
        if (sslTrustStoreType != null) {
            params = new KeystoreParams();
            params.setType(sslTrustStoreType);
            params.setPath(this.getSicurezzaMessaggioSslTrustStorePath());
            params.setPassword(this.getSicurezzaMessaggioSslTrustStorePassword());
            params.setCrls(this.getSicurezzaMessaggioSslTrustStoreCrls());
            params.setOcspPolicy(this.getSicurezzaMessaggioSslTrustStoreOcspPolicy());
        }
        return params;
    }

    public String getSicurezzaMessaggioSslTrustStoreTipo() {
        if (this.sicurezzaMessaggioSslTrustStoreTipoReaded == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.sicurezzaMessaggio.ssl.trustStore.tipo");
                if (value != null) {
                    this.sicurezzaMessaggioSslTrustStoreTipo = value = value.trim();
                }
                this.sicurezzaMessaggioSslTrustStoreTipoReaded = true;
            }
            catch (Exception e) {
                this.logError("Propriet\u00e0 'org.openspcoop2.protocol.modipa.sicurezzaMessaggio.ssl.trustStore.tipo' non impostata, errore:" + e.getMessage());
                this.sicurezzaMessaggioSslTrustStoreTipoReaded = true;
            }
        }
        return this.sicurezzaMessaggioSslTrustStoreTipo;
    }

    public String getSicurezzaMessaggioSslTrustStorePath() throws ProtocolException {
        if (this.sicurezzaMessaggioSslTrustStorePath == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.sicurezzaMessaggio.ssl.trustStore.path");
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.sicurezzaMessaggioSslTrustStorePath = value = value.trim();
            }
            catch (Exception e) {
                this.logError("Propriet\u00e0 'org.openspcoop2.protocol.modipa.sicurezzaMessaggio.ssl.trustStore.path' non impostata, errore:" + e.getMessage());
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioSslTrustStorePath;
    }

    public String getSicurezzaMessaggioSslTrustStorePassword() throws ProtocolException {
        if (this.sicurezzaMessaggioSslTrustStorePassword == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.sicurezzaMessaggio.ssl.trustStore.password");
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.sicurezzaMessaggioSslTrustStorePassword = value = value.trim();
            }
            catch (Exception e) {
                this.logError("Propriet\u00e0 'org.openspcoop2.protocol.modipa.sicurezzaMessaggio.ssl.trustStore.password' non impostata, errore:" + e.getMessage());
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioSslTrustStorePassword;
    }

    public String getSicurezzaMessaggioSslTrustStoreCrls() throws ProtocolException {
        if (this.sicurezzaMessaggioSslTrustStoreCrlsReaded == null) {
            String pName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.ssl.trustStore.crls";
            try {
                String value = this.reader.getValueConvertEnvProperties(pName);
                if (value != null) {
                    this.sicurezzaMessaggioSslTrustStoreCrls = value = value.trim();
                }
                this.sicurezzaMessaggioSslTrustStoreCrlsReaded = true;
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioSslTrustStoreCrls;
    }

    public String getSicurezzaMessaggioSslTrustStoreOcspPolicy() throws ProtocolException {
        if (this.sicurezzaMessaggioSslTrustStoreOcspPolicyReaded == null) {
            String pName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.ssl.trustStore.ocspPolicy";
            try {
                String value = this.reader.getValueConvertEnvProperties(pName);
                if (value != null) {
                    this.sicurezzaMessaggioSslTrustStoreOcspPolicy = value = value.trim();
                }
                this.sicurezzaMessaggioSslTrustStoreOcspPolicyReaded = true;
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioSslTrustStoreOcspPolicy;
    }

    public int readAPIPDNDVersionKeys(String remoteStore) throws ProtocolException, UtilsException {
        return this.readAPIPDNDVersionEngine(remoteStore, "api.keys.version");
    }

    public int readAPIPDNDVersionEvents(String remoteStore) throws ProtocolException, UtilsException {
        return this.readAPIPDNDVersionEngine(remoteStore, "api.events.version");
    }

    public int readAPIPDNDVersionClients(String remoteStore) throws ProtocolException, UtilsException {
        return this.readAPIPDNDVersionEngine(remoteStore, "api.clients.version");
    }

    public int readAPIPDNDVersionOrganizations(String remoteStore) throws ProtocolException, UtilsException {
        return this.readAPIPDNDVersionEngine(remoteStore, "api.organizations.version");
    }

    private int readAPIPDNDVersionEngine(String remoteStore, String pName) throws ProtocolException, UtilsException {
        String key = remoteStore + "_" + pName;
        if (!this.apiPDNDVersion.containsKey(key)) {
            String p = REMOTE_STORE_PREFIX_PROPERTY + remoteStore + "." + pName;
            String pValue = this.reader.getValueConvertEnvProperties(p);
            if (pValue != null) {
                try {
                    int i = Integer.parseInt(pValue);
                    if (i > 0) {
                        this.apiPDNDVersion.put(key, i);
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException("Property '" + p + "' non valida: " + e.getMessage(), (Throwable)e);
                }
            }
            if (!this.apiPDNDVersion.containsKey(key)) {
                this.apiPDNDVersion.put(key, -1);
            }
        }
        return this.apiPDNDVersion.get(key);
    }

    private Map<String, RemoteKeyType> getRemoteStoreKeyTypeMap() throws ProtocolException {
        if (this.remoteStoreKeyTypeMap == null) {
            this.getRemoteStoreConfig();
        }
        return this.remoteStoreKeyTypeMap;
    }

    public List<RemoteStoreConfig> getRemoteStoreConfig() throws ProtocolException {
        if (this.remoteStoreConfig == null) {
            String pName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.remoteStores";
            try {
                String value = this.reader.getValueConvertEnvProperties(pName);
                if (value != null) {
                    value = value.trim();
                    this.remoteStoreConfig = new ArrayList<RemoteStoreConfig>();
                    this.remoteStoreKeyTypeMap = new HashMap<String, RemoteKeyType>();
                    this.readRemoteStores(value);
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonCorretta(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.remoteStoreConfig;
    }

    private void readRemoteStores(String value) throws UtilsException, ProtocolException, KeystoreException {
        String[] tmp = value.split(",");
        if (tmp != null && tmp.length > 0) {
            for (String rsc : tmp) {
                rsc = rsc.trim();
                String debugPrefix = "Configurazione per remoteStore '" + rsc + "'";
                String propertyPrefix = REMOTE_STORE_PREFIX_PROPERTY + rsc + ".";
                Properties p = this.reader.readPropertiesConvertEnvProperties(propertyPrefix);
                if (p == null || p.isEmpty()) {
                    throw new ProtocolException(debugPrefix + SUFFIX_NON_TROVATA);
                }
                try {
                    RemoteStoreConfig config = RemoteStoreConfigPropertiesUtils.read((Properties)p, null);
                    this.setUrlPDND(rsc, config);
                    this.remoteStoreConfig.add(config);
                    this.readKeyType(p, debugPrefix, config);
                }
                catch (Exception e) {
                    throw new ProtocolException("[" + propertyPrefix + "] " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public String buildBaseUrlPDND(String baseUrl) throws ProtocolException {
        int apiVersion = this.extractVersionFromBaseUrl(baseUrl);
        Object pathKeys = this.getApiPDNDClientKeysPath(apiVersion);
        if (!((String)pathKeys).startsWith(URL_CHAR_DELIMITER)) {
            pathKeys = URL_CHAR_DELIMITER + (String)pathKeys;
        }
        if (baseUrl.endsWith((String)pathKeys)) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - ((String)pathKeys).length());
        } else if (baseUrl.endsWith((String)(pathKeys = ((String)pathKeys).endsWith(URL_CHAR_DELIMITER) ? ((String)pathKeys).substring(0, ((String)pathKeys).length() - 1) : (String)pathKeys + URL_CHAR_DELIMITER))) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - ((String)pathKeys).length());
        }
        return baseUrl;
    }

    public int extractVersionFromBaseUrl(String baseUrl) {
        String pattern = null;
        try {
            pattern = this.getApiPDNDBaseUrlVersionPattern();
            String s = RegularExpressionEngine.getStringMatchPattern((String)baseUrl, (String)pattern);
            int i = Integer.parseInt(s);
            if (i > 0) {
                return i;
            }
        }
        catch (Exception e) {
            this.log.error("extractVersionFromBaseUrl(" + baseUrl + ") with pattern '" + pattern + "' failed: " + e.getMessage(), (Throwable)e);
        }
        return 1;
    }

    private void setUrlPDND(String rsc, RemoteStoreConfig config) throws ProtocolException, UtilsException {
        String baseUrlOrig = config.getBaseUrl();
        HashMap baseUrlMultitenantOrig = new HashMap();
        if (config.getMultiTenantBaseUrl() != null && !config.getMultiTenantBaseUrl().isEmpty()) {
            baseUrlMultitenantOrig.putAll(config.getMultiTenantBaseUrl());
        }
        int versionInBaseUrl = this.extractVersionFromBaseUrl(baseUrlOrig);
        this.forceBaseUrlPDNDEndsWithKeys(rsc, config, baseUrlOrig, versionInBaseUrl);
        String baseUrlWithoutKeys = this.buildBaseUrlPDND(baseUrlOrig);
        HashMap<String, String> baseUrlMultitenantWithoutKeys = new HashMap<String, String>();
        if (!baseUrlMultitenantOrig.isEmpty()) {
            for (Map.Entry entry : baseUrlMultitenantOrig.entrySet()) {
                baseUrlMultitenantWithoutKeys.put((String)entry.getKey(), this.buildBaseUrlPDND((String)entry.getValue()));
            }
        }
        this.buildUrlCheckEventi(rsc, config, versionInBaseUrl, baseUrlWithoutKeys, baseUrlMultitenantWithoutKeys);
        this.buildUrlCheckClients(rsc, config, versionInBaseUrl, baseUrlWithoutKeys, baseUrlMultitenantWithoutKeys);
        this.buildUrlCheckOrganizations(rsc, config, versionInBaseUrl, baseUrlWithoutKeys, baseUrlMultitenantWithoutKeys);
    }

    private void forceBaseUrlPDNDEndsWithKeys(String rsc, RemoteStoreConfig config, String baseUrl, int versionInBaseUrl) throws ProtocolException, UtilsException {
        if (this.isForceBaseUrlPDNDEndsWithKeys(rsc)) {
            config.setBaseUrl(this.normalizeBaseUrlApiPDNDKeys(baseUrl, versionInBaseUrl));
            if (config.getMultiTenantBaseUrl() != null && !config.getMultiTenantBaseUrl().isEmpty()) {
                HashMap<String, String> multiTenantBaseUrlNormalized = config.getMultiTenantBaseUrl();
                if (multiTenantBaseUrlNormalized == null) {
                    multiTenantBaseUrlNormalized = new HashMap<String, String>();
                }
                for (Map.Entry entry : config.getMultiTenantBaseUrl().entrySet()) {
                    String baseUrlTenant = (String)entry.getValue();
                    multiTenantBaseUrlNormalized.put((String)entry.getKey(), this.normalizeBaseUrlApiPDNDKeys(baseUrlTenant, versionInBaseUrl));
                }
                config.setMultiTenantBaseUrl(multiTenantBaseUrlNormalized);
            }
        }
        int apiPdndVersionOverride = this.readAPIPDNDVersionKeys(rsc);
        this.upgradeBaseUrlApiPDNDKeys(config, versionInBaseUrl, apiPdndVersionOverride);
    }

    private String normalizeBaseUrlApiPDNDKeys(String baseUrl, int versionInBaseUrl) throws ProtocolException {
        Object suffix = null;
        try {
            suffix = this.getApiPDNDClientKeysPath(versionInBaseUrl);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        String pathWithoutSlash = null;
        if (!((String)suffix).startsWith(URL_CHAR_DELIMITER)) {
            pathWithoutSlash = suffix;
            suffix = URL_CHAR_DELIMITER + (String)suffix;
        } else {
            pathWithoutSlash = ((String)suffix).substring(1);
        }
        if (!((String)baseUrl).endsWith((String)suffix)) {
            if (!((String)baseUrl).endsWith(URL_CHAR_DELIMITER)) {
                baseUrl = (String)baseUrl + URL_CHAR_DELIMITER;
            }
            baseUrl = (String)baseUrl + pathWithoutSlash;
        }
        return baseUrl;
    }

    private void upgradeBaseUrlApiPDNDKeys(RemoteStoreConfig config, int versionInBaseUrl, int apiPdndVersionOverride) throws ProtocolException {
        int apiVersion = apiPdndVersionOverride > 0 && apiPdndVersionOverride != versionInBaseUrl ? apiPdndVersionOverride : versionInBaseUrl;
        boolean faultCheck = this.isApiPDNDServerKeysFaultClientCheck(apiVersion);
        if (apiPdndVersionOverride > 0 && apiPdndVersionOverride != versionInBaseUrl) {
            config.setBaseUrl(this.upgradeBaseUrlApiPDNDKeys(config.getBaseUrl(), versionInBaseUrl, apiPdndVersionOverride));
        }
        if (faultCheck) {
            config.setBaseUrlFaultCheck(this.upgradeBaseUrlApiPDNDKeysFaultCheck(config.getBaseUrl(), apiVersion));
        }
        config.setResponseJsonPath(this.getApiPDNDClientKeysJsonPath(apiVersion));
        config.setResponseJsonPathFaultCheck(this.getApiPDNDServerKeysJsonPath(apiVersion));
        this.upgradeBaseUrlApiPDNDKeysMultitenant(config, versionInBaseUrl, apiPdndVersionOverride, faultCheck, apiVersion);
    }

    private void upgradeBaseUrlApiPDNDKeysMultitenant(RemoteStoreConfig config, int versionInBaseUrl, int apiPdndVersionOverride, boolean faultCheck, int apiVersion) throws ProtocolException {
        if (config.getMultiTenantBaseUrl() != null && !config.getMultiTenantBaseUrl().isEmpty()) {
            HashMap<String, String> multiTenantBaseUrlUpgraded = config.getMultiTenantBaseUrl();
            if (multiTenantBaseUrlUpgraded == null) {
                multiTenantBaseUrlUpgraded = new HashMap<String, String>();
            }
            HashMap<String, String> multiTenantBaseUrlFaultCheckUpgraded = new HashMap<String, String>();
            for (Map.Entry entry : config.getMultiTenantBaseUrl().entrySet()) {
                String baseUrlTenant = (String)entry.getValue();
                if (apiPdndVersionOverride > 0 && apiPdndVersionOverride != versionInBaseUrl) {
                    multiTenantBaseUrlUpgraded.put((String)entry.getKey(), this.upgradeBaseUrlApiPDNDKeys(baseUrlTenant, versionInBaseUrl, apiPdndVersionOverride));
                }
                if (!faultCheck) continue;
                multiTenantBaseUrlFaultCheckUpgraded.put((String)entry.getKey(), this.upgradeBaseUrlApiPDNDKeysFaultCheck(config.getBaseUrl(), apiVersion));
            }
            config.setMultiTenantBaseUrl(multiTenantBaseUrlUpgraded);
            config.setMultiTenantBaseUrlFaultCheck(multiTenantBaseUrlFaultCheckUpgraded);
        }
    }

    private String upgradeBaseUrlApiPDNDKeys(String orig, int versionInBaseUrl, int apiPdndVersionOverride) throws ProtocolException {
        String suffixInBaseUrl = this.buildSuffixClientKeysPathByVersionl(versionInBaseUrl);
        String newSuffixInBaseUrl = this.buildSuffixClientKeysPathByVersionl(apiPdndVersionOverride);
        return orig.replace(suffixInBaseUrl, newSuffixInBaseUrl);
    }

    private String buildSuffixClientKeysPathByVersionl(int version) throws ProtocolException {
        Object suffixUrl = null;
        try {
            suffixUrl = this.getApiPDNDClientKeysPath(version);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        if (!((String)suffixUrl).startsWith(URL_CHAR_DELIMITER)) {
            suffixUrl = URL_CHAR_DELIMITER + (String)suffixUrl;
        }
        return "/v" + version + (String)suffixUrl;
    }

    private boolean isForceBaseUrlPDNDEndsWithKeys(String rsc) {
        String propertyPrefix = REMOTE_STORE_PREFIX_PROPERTY + rsc + ".baseUrl.forceEndsWithKeys";
        try {
            boolean force = true;
            String value = this.reader.getValueConvertEnvProperties(propertyPrefix);
            if (value != null && "false".equalsIgnoreCase(value = value.trim())) {
                force = false;
            }
            return force;
        }
        catch (Exception e) {
            this.logWarn(PREFIX_PROPRIETA + propertyPrefix + "' non impostata; viene forzato il suffisso /keys");
            return true;
        }
    }

    private String upgradeBaseUrlApiPDNDKeysFaultCheck(String original, int version) throws ProtocolException {
        Object suffixClientUrl = null;
        try {
            suffixClientUrl = this.getApiPDNDClientKeysPath(version);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        if (!((String)suffixClientUrl).startsWith(URL_CHAR_DELIMITER)) {
            suffixClientUrl = URL_CHAR_DELIMITER + (String)suffixClientUrl;
        }
        Object suffixServerUrl = null;
        try {
            suffixServerUrl = this.getApiPDNDServerKeysPath(version);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        if (!((String)suffixServerUrl).startsWith(URL_CHAR_DELIMITER)) {
            suffixServerUrl = URL_CHAR_DELIMITER + (String)suffixServerUrl;
        }
        if (original.endsWith((String)suffixClientUrl)) {
            return original.substring(0, original.length() - ((String)suffixClientUrl).length()) + (String)suffixServerUrl;
        }
        return original;
    }

    private String concatenateUrl(String baseUrlWithoutKeys, String path) {
        if (baseUrlWithoutKeys.endsWith(URL_CHAR_DELIMITER)) {
            if (path.startsWith(URL_CHAR_DELIMITER)) {
                return baseUrlWithoutKeys + path.substring(1);
            }
            return baseUrlWithoutKeys + path;
        }
        if (path.startsWith(URL_CHAR_DELIMITER)) {
            return baseUrlWithoutKeys + path;
        }
        return baseUrlWithoutKeys + URL_CHAR_DELIMITER + path;
    }

    private void buildUrlCheckEventi(String rsc, RemoteStoreConfig remoteStore, int versionInBaseUrl, String baseUrlWithoutKeys, Map<String, String> baseUrlMultitenantWithoutKeys) throws ProtocolException, UtilsException {
        int apiPdndVersionOverride = this.readAPIPDNDVersionEvents(rsc);
        int apiVersion = apiPdndVersionOverride > 0 && apiPdndVersionOverride != versionInBaseUrl ? apiPdndVersionOverride : versionInBaseUrl;
        Object pathEventKeys = this.getApiPDNDEventKeysPath(apiVersion);
        if (!((String)pathEventKeys).startsWith(URL_CHAR_DELIMITER)) {
            pathEventKeys = URL_CHAR_DELIMITER + (String)pathEventKeys;
        }
        String urlEventi = this.concatenateUrl(baseUrlWithoutKeys, (String)pathEventKeys);
        if (apiPdndVersionOverride > 0 && apiPdndVersionOverride != versionInBaseUrl) {
            urlEventi = this.upgradeBaseUrlApiPDND(urlEventi, versionInBaseUrl, apiPdndVersionOverride, (String)pathEventKeys);
        }
        remoteStore.getMetadati().put("api-pdnd-eventsKeys-path", urlEventi);
        remoteStore.getMetadati().put("api-pdnd-eventsKeys-parameterLastEventId", this.getApiPDNDEventKeysParameterLastEventId(apiVersion));
        remoteStore.getMetadati().put("api-pdnd-eventsKeys-parameterLastEventIdFirstValue", this.getApiPDNDEventKeysParameterLastEventIdFirstValue(apiVersion));
        remoteStore.getMetadati().put("api-pdnd-eventsKeys-parameterLimit", this.getApiPDNDEventKeysParameterLimit(apiVersion));
        this.buildUrlCheckEventiMultitenant(remoteStore, versionInBaseUrl, baseUrlMultitenantWithoutKeys, apiPdndVersionOverride, apiVersion, (String)pathEventKeys);
    }

    private void buildUrlCheckEventiMultitenant(RemoteStoreConfig remoteStore, int versionInBaseUrl, Map<String, String> baseUrlMultitenantWithoutKeys, int apiPdndVersionOverride, int apiVersion, String pathEventKeys) throws ProtocolException {
        if (baseUrlMultitenantWithoutKeys != null && !baseUrlMultitenantWithoutKeys.isEmpty()) {
            HashMap<String, HashMap<String, String>> multiTenantUpgraded = remoteStore.getMultiTenantMetadati();
            if (multiTenantUpgraded == null) {
                multiTenantUpgraded = new HashMap<String, HashMap<String, String>>();
            }
            for (Map.Entry<String, String> entry : baseUrlMultitenantWithoutKeys.entrySet()) {
                String baseUrlTenant = entry.getValue();
                String urlEventiTenant = this.concatenateUrl(baseUrlTenant, pathEventKeys);
                HashMap<String, String> multiTenantValues = (HashMap<String, String>)multiTenantUpgraded.get(entry.getKey());
                if (multiTenantValues == null) {
                    multiTenantValues = new HashMap<String, String>();
                }
                if (apiPdndVersionOverride > 0 && apiPdndVersionOverride != versionInBaseUrl) {
                    urlEventiTenant = this.upgradeBaseUrlApiPDND(urlEventiTenant, versionInBaseUrl, apiPdndVersionOverride, pathEventKeys);
                }
                multiTenantValues.put("api-pdnd-eventsKeys-path", urlEventiTenant);
                multiTenantValues.put("api-pdnd-eventsKeys-parameterLastEventId", this.getApiPDNDEventKeysParameterLastEventId(apiVersion));
                multiTenantValues.put("api-pdnd-eventsKeys-parameterLastEventIdFirstValue", this.getApiPDNDEventKeysParameterLastEventIdFirstValue(apiVersion));
                multiTenantValues.put("api-pdnd-eventsKeys-parameterLimit", this.getApiPDNDEventKeysParameterLimit(apiVersion));
                multiTenantUpgraded.put(entry.getKey(), multiTenantValues);
            }
            remoteStore.setMultiTenantMetadati(multiTenantUpgraded);
        }
    }

    private void buildUrlCheckClients(String rsc, RemoteStoreConfig remoteStore, int versionInBaseUrl, String baseUrlWithoutKeys, Map<String, String> baseUrlMultitenantWithoutKeys) throws ProtocolException, UtilsException {
        int apiPdndVersionOverride = this.readAPIPDNDVersionClients(rsc);
        int apiVersion = apiPdndVersionOverride > 0 && apiPdndVersionOverride != versionInBaseUrl ? apiPdndVersionOverride : versionInBaseUrl;
        Object pathClients = this.getApiPDNDClientsPath(apiVersion);
        if (!((String)pathClients).startsWith(URL_CHAR_DELIMITER)) {
            pathClients = URL_CHAR_DELIMITER + (String)pathClients;
        }
        String urlClients = this.concatenateUrl(baseUrlWithoutKeys, (String)pathClients);
        if (apiPdndVersionOverride > 0 && apiPdndVersionOverride != versionInBaseUrl) {
            urlClients = this.upgradeBaseUrlApiPDND(urlClients, versionInBaseUrl, apiPdndVersionOverride, (String)pathClients);
        }
        remoteStore.getMetadati().put("api-pdnd-clients-path", urlClients);
        remoteStore.getMetadati().put("api-pdnd-clients-organizationJsonPath", this.getApiPDNDClientsOrganizationJsonPath(apiVersion));
        this.buildUrlCheckClientsMultitenant(remoteStore, versionInBaseUrl, baseUrlMultitenantWithoutKeys, apiPdndVersionOverride, apiVersion, (String)pathClients);
    }

    private void buildUrlCheckClientsMultitenant(RemoteStoreConfig remoteStore, int versionInBaseUrl, Map<String, String> baseUrlMultitenantWithoutKeys, int apiPdndVersionOverride, int apiVersion, String pathClients) throws ProtocolException {
        if (baseUrlMultitenantWithoutKeys != null && !baseUrlMultitenantWithoutKeys.isEmpty()) {
            HashMap<String, HashMap<String, String>> multiTenantUpgraded = remoteStore.getMultiTenantMetadati();
            if (multiTenantUpgraded == null) {
                multiTenantUpgraded = new HashMap<String, HashMap<String, String>>();
            }
            for (Map.Entry<String, String> entry : baseUrlMultitenantWithoutKeys.entrySet()) {
                String baseUrlTenant = entry.getValue();
                String urlClientTenant = this.concatenateUrl(baseUrlTenant, pathClients);
                HashMap<String, String> multiTenantValues = (HashMap<String, String>)multiTenantUpgraded.get(entry.getKey());
                if (multiTenantValues == null) {
                    multiTenantValues = new HashMap<String, String>();
                }
                if (apiPdndVersionOverride > 0 && apiPdndVersionOverride != versionInBaseUrl) {
                    urlClientTenant = this.upgradeBaseUrlApiPDND(urlClientTenant, versionInBaseUrl, apiPdndVersionOverride, pathClients);
                }
                multiTenantValues.put("api-pdnd-clients-path", urlClientTenant);
                multiTenantValues.put("api-pdnd-clients-organizationJsonPath", this.getApiPDNDClientsOrganizationJsonPath(apiVersion));
                multiTenantUpgraded.put(entry.getKey(), multiTenantValues);
            }
            remoteStore.setMultiTenantMetadati(multiTenantUpgraded);
        }
    }

    private void buildUrlCheckOrganizations(String rsc, RemoteStoreConfig remoteStore, int versionInBaseUrl, String baseUrlWithoutKeys, Map<String, String> baseUrlMultitenantWithoutKeys) throws ProtocolException, UtilsException {
        int apiPdndVersionOverride = this.readAPIPDNDVersionOrganizations(rsc);
        int apiVersion = apiPdndVersionOverride > 0 && apiPdndVersionOverride != versionInBaseUrl ? apiPdndVersionOverride : versionInBaseUrl;
        Object pathOrganizations = this.getApiPDNDOrganizationsPath(apiVersion);
        if (!((String)pathOrganizations).startsWith(URL_CHAR_DELIMITER)) {
            pathOrganizations = URL_CHAR_DELIMITER + (String)pathOrganizations;
        }
        String urlOrganizations = this.concatenateUrl(baseUrlWithoutKeys, (String)pathOrganizations);
        if (apiPdndVersionOverride > 0 && apiPdndVersionOverride != versionInBaseUrl) {
            urlOrganizations = this.upgradeBaseUrlApiPDND(urlOrganizations, versionInBaseUrl, apiPdndVersionOverride, (String)pathOrganizations);
        }
        remoteStore.getMetadati().put("api-pdnd-organizations-path", urlOrganizations);
        this.buildUrlCheckOrganizationsMultitenant(remoteStore, versionInBaseUrl, baseUrlMultitenantWithoutKeys, apiPdndVersionOverride, (String)pathOrganizations);
    }

    private void buildUrlCheckOrganizationsMultitenant(RemoteStoreConfig remoteStore, int versionInBaseUrl, Map<String, String> baseUrlMultitenantWithoutKeys, int apiPdndVersionOverride, String pathOrganizations) {
        if (baseUrlMultitenantWithoutKeys != null && !baseUrlMultitenantWithoutKeys.isEmpty()) {
            HashMap<String, HashMap<String, String>> multiTenantUpgraded = remoteStore.getMultiTenantMetadati();
            if (multiTenantUpgraded == null) {
                multiTenantUpgraded = new HashMap<String, HashMap<String, String>>();
            }
            for (Map.Entry<String, String> entry : baseUrlMultitenantWithoutKeys.entrySet()) {
                String baseUrlTenant = entry.getValue();
                String urlOrganizationsTenant = this.concatenateUrl(baseUrlTenant, pathOrganizations);
                HashMap<String, String> multiTenantValues = (HashMap<String, String>)multiTenantUpgraded.get(entry.getKey());
                if (multiTenantValues == null) {
                    multiTenantValues = new HashMap<String, String>();
                }
                if (apiPdndVersionOverride > 0 && apiPdndVersionOverride != versionInBaseUrl) {
                    urlOrganizationsTenant = this.upgradeBaseUrlApiPDND(urlOrganizationsTenant, versionInBaseUrl, apiPdndVersionOverride, pathOrganizations);
                }
                multiTenantValues.put("api-pdnd-organizations-path", urlOrganizationsTenant);
                multiTenantUpgraded.put(entry.getKey(), multiTenantValues);
            }
            remoteStore.setMultiTenantMetadati(multiTenantUpgraded);
        }
    }

    private String upgradeBaseUrlApiPDND(String orig, int versionInBaseUrl, int apiPdndVersionOverride, String path) {
        String suffixOrig = "/v" + versionInBaseUrl + path;
        String suffixNew = "/v" + apiPdndVersionOverride + path;
        return orig.replace(suffixOrig, suffixNew);
    }

    private void readKeyType(Properties p, String debugPrefix, RemoteStoreConfig config) throws ProtocolException {
        String keyType = p.getProperty("keyType");
        if (keyType != null) {
            keyType = keyType.trim();
        }
        if (keyType == null || StringUtils.isEmpty((String)keyType)) {
            throw new ProtocolException(debugPrefix + " non completa; key type non indicato");
        }
        try {
            RemoteKeyType rkt = RemoteKeyType.toEnumFromName((String)keyType);
            if (rkt == null) {
                throw new ProtocolException("Non valido");
            }
            this.remoteStoreKeyTypeMap.put(config.getStoreName(), rkt);
        }
        catch (Exception e) {
            throw new ProtocolException(debugPrefix + " non completa; key type indicato '" + keyType + "' non valido", (Throwable)e);
        }
    }

    public boolean isRemoteStore(String name) throws ProtocolException {
        return PDNDResolver.isRemoteStore((String)name, this.getRemoteStoreConfig());
    }

    public RemoteStoreConfig getRemoteStoreConfig(String name, IDSoggetto idDominio) throws ProtocolException {
        return PDNDResolver.getRemoteStoreConfig((String)name, (IDSoggetto)idDominio, this.getRemoteStoreConfig());
    }

    public RemoteStoreConfig getRemoteStoreConfigByTokenPolicy(String name, IDSoggetto idDominio) throws ProtocolException {
        return PDNDResolver.getRemoteStoreConfigByTokenPolicy((String)name, (IDSoggetto)idDominio, this.getRemoteStoreConfig());
    }

    public RemoteKeyType getRemoteKeyType(String name) throws ProtocolException {
        return this.getRemoteStoreKeyTypeMap().get(name);
    }

    private List<String> getValidazioneTokenOAuthClaimsRequired() throws ProtocolException {
        if (this.validazioneTokenOAuthClaimsRequired == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.token.oauth.claims.required";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                this.validazioneTokenOAuthClaimsRequired = value != null && StringUtils.isNotEmpty((String)value) ? ModISecurityConfig.convertToList(value) : new ArrayList<String>();
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.validazioneTokenOAuthClaimsRequired;
    }

    public List<String> getValidazioneTokenOAuthClaimsRequired(String soggetto) throws ProtocolException {
        if (!this.validazioneTokenOAuthClaimsRequiredSoggetto.containsKey(soggetto)) {
            String propertyName = "org.openspcoop2.protocol.modipa." + soggetto + ".token.oauth.claims.required";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null && StringUtils.isNotEmpty((String)value)) {
                    this.validazioneTokenOAuthClaimsRequiredSoggetto.put(soggetto, ModISecurityConfig.convertToList(value));
                } else {
                    this.validazioneTokenOAuthClaimsRequiredSoggetto.put(soggetto, this.getValidazioneTokenOAuthClaimsRequired());
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.validazioneTokenOAuthClaimsRequiredSoggetto.get(soggetto);
    }

    private List<String> getValidazioneTokenPDNDClaimsRequired() throws ProtocolException {
        if (this.validazioneTokenPDNDClaimsRequired == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.token.pdnd.claims.required";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null && StringUtils.isNotEmpty((String)value)) {
                    this.validazioneTokenPDNDClaimsRequired = ModISecurityConfig.convertToList(value);
                } else {
                    this.validazioneTokenOAuthClaimsRequired = new ArrayList<String>();
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.validazioneTokenPDNDClaimsRequired;
    }

    public List<String> getValidazioneTokenPDNDClaimsRequired(String soggetto) throws ProtocolException {
        if (!this.validazioneTokenPDNDClaimsRequiredSoggetto.containsKey(soggetto)) {
            String propertyName = "org.openspcoop2.protocol.modipa." + soggetto + ".token.pdnd.claims.required";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null && StringUtils.isNotEmpty((String)value)) {
                    this.validazioneTokenPDNDClaimsRequiredSoggetto.put(soggetto, ModISecurityConfig.convertToList(value));
                } else {
                    this.validazioneTokenPDNDClaimsRequiredSoggetto.put(soggetto, this.getValidazioneTokenPDNDClaimsRequired());
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.validazioneTokenPDNDClaimsRequiredSoggetto.get(soggetto);
    }

    private boolean isValidazioneTokenPDNDProducerIdCheck() throws ProtocolException {
        if (this.isValidazioneTokenPDNDProducerIdCheck == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.pdnd.producerId.check";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                this.isValidazioneTokenPDNDProducerIdCheck = value != null && StringUtils.isNotEmpty((String)value) ? Boolean.valueOf(Boolean.parseBoolean(value)) : Boolean.valueOf(true);
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.isValidazioneTokenPDNDProducerIdCheck;
    }

    public boolean isValidazioneTokenPDNDProducerIdCheck(String soggetto) throws ProtocolException {
        if (!this.isValidazioneTokenPDNDProducerIdCheckSoggetto.containsKey(soggetto)) {
            String propertyName = PREFIX_PROPERTY_MODIPA_PDND + soggetto + ".producerId.check";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null && StringUtils.isNotEmpty((String)value)) {
                    this.isValidazioneTokenPDNDProducerIdCheckSoggetto.put(soggetto, Boolean.parseBoolean(value));
                } else {
                    this.isValidazioneTokenPDNDProducerIdCheckSoggetto.put(soggetto, this.isValidazioneTokenPDNDProducerIdCheck());
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.isValidazioneTokenPDNDProducerIdCheckSoggetto.get(soggetto);
    }

    public boolean isPdndProducerIdCheckUnique() {
        if (this.isPdndProducerIdCheckUnique == null) {
            Boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.pdnd.producerId.console.checkUnique";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isPdndProducerIdCheckUnique = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isPdndProducerIdCheckUnique = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isPdndProducerIdCheckUnique = defaultValue;
            }
        }
        return this.isPdndProducerIdCheckUnique;
    }

    private boolean isValidazioneTokenPDNDEServiceIdCheck() throws ProtocolException {
        if (this.isValidazioneTokenPDNDEServiceIdCheck == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.pdnd.eServiceId.check";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                this.isValidazioneTokenPDNDEServiceIdCheck = value != null && StringUtils.isNotEmpty((String)value) ? Boolean.valueOf(Boolean.parseBoolean(value)) : Boolean.valueOf(true);
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.isValidazioneTokenPDNDEServiceIdCheck;
    }

    public boolean isValidazioneTokenPDNDEServiceIdCheck(String soggetto) throws ProtocolException {
        if (!this.isValidazioneTokenPDNDEServiceIdCheckSoggetto.containsKey(soggetto)) {
            String propertyName = PREFIX_PROPERTY_MODIPA_PDND + soggetto + ".eServiceId.check";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null && StringUtils.isNotEmpty((String)value)) {
                    this.isValidazioneTokenPDNDEServiceIdCheckSoggetto.put(soggetto, Boolean.parseBoolean(value));
                } else {
                    this.isValidazioneTokenPDNDEServiceIdCheckSoggetto.put(soggetto, this.isValidazioneTokenPDNDEServiceIdCheck());
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.isValidazioneTokenPDNDEServiceIdCheckSoggetto.get(soggetto);
    }

    public boolean isPdndEServiceIdCheckUnique() {
        if (this.isPdndEServiceIdCheckUnique == null) {
            Boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.pdnd.eServiceId.console.checkUnique";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isPdndEServiceIdCheckUnique = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isPdndEServiceIdCheckUnique = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isPdndEServiceIdCheckUnique = defaultValue;
            }
        }
        return this.isPdndEServiceIdCheckUnique;
    }

    private boolean isValidazioneTokenPDNDDescriptorIdCheck() throws ProtocolException {
        if (this.isValidazioneTokenPDNDDescriptorIdCheck == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.pdnd.descriptorId.check";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                this.isValidazioneTokenPDNDDescriptorIdCheck = value != null && StringUtils.isNotEmpty((String)value) ? Boolean.valueOf(Boolean.parseBoolean(value)) : Boolean.valueOf(true);
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.isValidazioneTokenPDNDDescriptorIdCheck;
    }

    public boolean isValidazioneTokenPDNDDescriptorIdCheck(String soggetto) throws ProtocolException {
        if (!this.isValidazioneTokenPDNDDescriptorIdCheckSoggetto.containsKey(soggetto)) {
            String propertyName = PREFIX_PROPERTY_MODIPA_PDND + soggetto + ".eServiceId.check";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null && StringUtils.isNotEmpty((String)value)) {
                    this.isValidazioneTokenPDNDDescriptorIdCheckSoggetto.put(soggetto, Boolean.parseBoolean(value));
                } else {
                    this.isValidazioneTokenPDNDDescriptorIdCheckSoggetto.put(soggetto, this.isValidazioneTokenPDNDDescriptorIdCheck());
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.isValidazioneTokenPDNDDescriptorIdCheckSoggetto.get(soggetto);
    }

    public boolean isPdndDescriptorIdCheckUnique() {
        if (this.isPdndDescriptorIdCheckUnique == null) {
            Boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.pdnd.descriptorId.console.checkUnique";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isPdndDescriptorIdCheckUnique = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isPdndDescriptorIdCheckUnique = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isPdndDescriptorIdCheckUnique = defaultValue;
            }
        }
        return this.isPdndDescriptorIdCheckUnique;
    }

    public String getApiPDNDBaseUrlVersionPattern() throws ProtocolException {
        if (this.getApiPDNDBaseUrlVersionPattern == null) {
            String pName = "org.openspcoop2.protocol.modipa.pdnd.api.baseUrl.version.pattern";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException("Non configurata");
                }
                this.getApiPDNDBaseUrlVersionPattern = name = name.trim();
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDBaseUrlVersionPattern;
    }

    public String getApiPDNDClientKeysPath(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDClientKeysPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".keys.client.path";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDClientKeysPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDClientKeysPath.get(key);
    }

    public String getApiPDNDClientKeysJsonPath(int version) throws ProtocolException {
        String s;
        String key = "" + version;
        if (!this.getApiPDNDClientKeysJsonPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".keys.client.jsonPath";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    name = "";
                }
                name = name.trim();
                this.getApiPDNDClientKeysJsonPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return (s = this.getApiPDNDClientKeysJsonPath.get(key)) != null && "".equals(s) ? null : s;
    }

    public String getApiPDNDServerKeysPath(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDServerKeysPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".keys.server.path";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDServerKeysPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDServerKeysPath.get(key);
    }

    public String getApiPDNDServerKeysJsonPath(int version) throws ProtocolException {
        String s;
        String key = "" + version;
        if (!this.getApiPDNDServerKeysJsonPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".keys.server.jsonPath";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    name = "";
                }
                name = name.trim();
                this.getApiPDNDServerKeysJsonPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return (s = this.getApiPDNDServerKeysJsonPath.get(key)) != null && "".equals(s) ? null : s;
    }

    public boolean isApiPDNDServerKeysFaultClientCheck(int version) throws ProtocolException {
        Boolean s;
        String key = "" + version;
        if (!this.isApiPDNDServerKeysFaultClientCheck.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".keys.server.faultClientCheck";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    name = "false";
                }
                name = name.trim();
                this.isApiPDNDServerKeysFaultClientCheck.put(key, "true".equalsIgnoreCase(name));
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return (s = this.isApiPDNDServerKeysFaultClientCheck.get(key)) != null && s != false;
    }

    public String getApiPDNDEventKeysPath(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDEventKeysPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".events.keys.path";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDEventKeysPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDEventKeysPath.get(key);
    }

    public String getApiPDNDEventKeysParameterLastEventId(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDEventKeysParameterLastEventId.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".events.keys.parameter.lastEventId";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDEventKeysParameterLastEventId.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDEventKeysParameterLastEventId.get(key);
    }

    public String getApiPDNDEventKeysParameterLastEventIdFirstValue(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDEventKeysParameterLastEventIdFirstValue.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".events.keys.parameter.lastEventId.firstValue";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    name = "";
                }
                name = name.trim();
                this.getApiPDNDEventKeysParameterLastEventIdFirstValue.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDEventKeysParameterLastEventIdFirstValue.get(key);
    }

    public String getApiPDNDEventKeysParameterLimit(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDEventKeysParameterLimit.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".events.keys.parameter.limit";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDEventKeysParameterLimit.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDEventKeysParameterLimit.get(key);
    }

    public String getApiPDNDClientsVersionPatttern(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDClientsVersionPatttern.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".clients.versionIdentifier.jsonPath";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDClientsVersionPatttern.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDClientsVersionPatttern.get(key);
    }

    public String getApiPDNDClientsPath(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDClientsPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".clients.path";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDClientsPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDClientsPath.get(key);
    }

    public String getApiPDNDClientsIdJsonPath(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDClientsIdJsonPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".clients.id.jsonPath";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDClientsIdJsonPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDClientsIdJsonPath.get(key);
    }

    public String getApiPDNDClientsOrganizationJsonPath(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDClientsOrganizationJsonPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".clients.organization.jsonPath";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDClientsOrganizationJsonPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDClientsOrganizationJsonPath.get(key);
    }

    public String getApiPDNDClientsNameJsonPath(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDClientsNameJsonPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".clients.name.jsonPath";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    name = "";
                }
                name = name.trim();
                this.getApiPDNDClientsNameJsonPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDClientsNameJsonPath.get(key);
    }

    public String getApiPDNDClientsDescriptionJsonPath(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDClientsDescriptionJsonPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".clients.description.jsonPath";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    name = "";
                }
                name = name.trim();
                this.getApiPDNDClientsDescriptionJsonPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDClientsDescriptionJsonPath.get(key);
    }

    public ModIPDNDClientConfig getAPIPDNDClientConfig() throws ProtocolException {
        ModIPDNDClientConfig instance = new ModIPDNDClientConfig(this.log);
        this.fillAPIPDNDClientConfig(instance);
        return instance;
    }

    public ModIPDNDClientConfig getAPIPDNDClientConfig(Logger log) throws ProtocolException {
        ModIPDNDClientConfig instance = new ModIPDNDClientConfig(log);
        this.fillAPIPDNDClientConfig(instance);
        return instance;
    }

    public ModIPDNDClientConfig getAPIPDNDClientConfig(String details) throws ProtocolException {
        ModIPDNDClientConfig instance = new ModIPDNDClientConfig(details, this.log);
        this.fillAPIPDNDClientConfig(instance);
        return instance;
    }

    public ModIPDNDClientConfig getAPIPDNDClientConfig(String details, Logger log) throws ProtocolException {
        ModIPDNDClientConfig instance = new ModIPDNDClientConfig(details, log);
        this.fillAPIPDNDClientConfig(instance);
        return instance;
    }

    private ModIPDNDClientConfig fillAPIPDNDClientConfig(ModIPDNDClientConfig c) throws ProtocolException {
        c.setVersion1JsonPathMatch(this.getApiPDNDClientsVersionPatttern(1));
        c.setVersion2JsonPathMatch(this.getApiPDNDClientsVersionPatttern(2));
        c.setIdJsonPath(this.getApiPDNDClientsIdJsonPath);
        c.setOrganizationJsonPath(this.getApiPDNDClientsOrganizationJsonPath);
        c.setNameJsonPath(this.getApiPDNDClientsNameJsonPath);
        c.setDescriptionJsonPath(this.getApiPDNDClientsDescriptionJsonPath);
        return c;
    }

    public String getApiPDNDOrganizationsVersionPatttern(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDOrganizationsVersionPatttern.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".organizations.versionIdentifier.jsonPath";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDOrganizationsVersionPatttern.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDOrganizationsVersionPatttern.get(key);
    }

    public String getApiPDNDOrganizationsPath(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDOrganizationsPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".organizations.path";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDOrganizationsPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDOrganizationsPath.get(key);
    }

    public String getApiPDNDOrganizationsIdJsonPath(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDOrganizationsIdJsonPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".organizations.id.jsonPath";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDOrganizationsIdJsonPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDOrganizationsIdJsonPath.get(key);
    }

    public String getApiPDNDOrganizationsNameJsonPath(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDOrganizationsNameJsonPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".organizations.name.jsonPath";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDOrganizationsNameJsonPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDOrganizationsNameJsonPath.get(key);
    }

    public String getApiPDNDOrganizationsExternalOriginJsonPath(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDOrganizationsExternalOriginJsonPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".organizations.external.origin.jsonPath";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDOrganizationsExternalOriginJsonPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDOrganizationsExternalOriginJsonPath.get(key);
    }

    public String getApiPDNDOrganizationsExternalIdJsonPath(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDOrganizationsExternalIdJsonPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".organizations.external.id.jsonPath";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDOrganizationsExternalIdJsonPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDOrganizationsExternalIdJsonPath.get(key);
    }

    public String getApiPDNDOrganizationsCategoryJsonPath(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDOrganizationsCategoryJsonPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".organizations.category.jsonPath";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    throw new ProtocolException(PREFIX_PROPRIETA + pName + "' non trovata");
                }
                name = name.trim();
                this.getApiPDNDOrganizationsCategoryJsonPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDOrganizationsCategoryJsonPath.get(key);
    }

    public String getApiPDNDOrganizationsSubunitJsonPath(int version) throws ProtocolException {
        String key = "" + version;
        if (!this.getApiPDNDOrganizationsSubunitJsonPath.containsKey(key)) {
            String pName = PREFIX_API_PDND_V + version + ".organizations.subUnit.jsonPath";
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties(pName);
                if (name == null) {
                    name = "";
                }
                name = name.trim();
                this.getApiPDNDOrganizationsSubunitJsonPath.put(key, name);
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getApiPDNDOrganizationsSubunitJsonPath.get(key);
    }

    public ModIPDNDOrganizationConfig getAPIPDNDOrganizationConfig() throws ProtocolException {
        ModIPDNDOrganizationConfig instance = new ModIPDNDOrganizationConfig(this.log);
        this.fillAPIPDNDOrganizationConfig(instance);
        return instance;
    }

    public ModIPDNDOrganizationConfig getAPIPDNDOrganizationConfig(Logger log) throws ProtocolException {
        ModIPDNDOrganizationConfig instance = new ModIPDNDOrganizationConfig(log);
        this.fillAPIPDNDOrganizationConfig(instance);
        return instance;
    }

    public ModIPDNDOrganizationConfig getAPIPDNDOrganizationConfig(String details) throws ProtocolException {
        ModIPDNDOrganizationConfig instance = new ModIPDNDOrganizationConfig(details, this.log);
        this.fillAPIPDNDOrganizationConfig(instance);
        return instance;
    }

    public ModIPDNDOrganizationConfig getAPIPDNDOrganizationConfig(String details, Logger log) throws ProtocolException {
        ModIPDNDOrganizationConfig instance = new ModIPDNDOrganizationConfig(details, log);
        this.fillAPIPDNDOrganizationConfig(instance);
        return instance;
    }

    private ModIPDNDOrganizationConfig fillAPIPDNDOrganizationConfig(ModIPDNDOrganizationConfig c) throws ProtocolException {
        c.setVersion1JsonPathMatch(this.getApiPDNDOrganizationsVersionPatttern(1));
        c.setVersion2JsonPathMatch(this.getApiPDNDOrganizationsVersionPatttern(2));
        c.setIdJsonPath(this.getApiPDNDOrganizationsIdJsonPath);
        c.setNameJsonPath(this.getApiPDNDOrganizationsNameJsonPath);
        c.setExternalOriginJsonPath(this.getApiPDNDOrganizationsExternalOriginJsonPath);
        c.setExternalIdJsonPath(this.getApiPDNDOrganizationsExternalIdJsonPath);
        c.setCategoryJsonPath(this.getApiPDNDOrganizationsCategoryJsonPath);
        c.setSubUnitJsonPath(this.getApiPDNDOrganizationsSubunitJsonPath);
        return c;
    }

    public KeystoreParams getSicurezzaMessaggioCertificatiKeyStore() throws ProtocolException {
        KeystoreParams params = null;
        String keystoreType = this.getSicurezzaMessaggioCertificatiKeyStoreTipo();
        if (keystoreType != null) {
            params = new KeystoreParams();
            params.setType(keystoreType);
            params.setPath(this.getSicurezzaMessaggioCertificatiKeyStorePath());
            params.setPassword(this.getSicurezzaMessaggioCertificatiKeyStorePassword());
            params.setKeyAlias(this.getSicurezzaMessaggioCertificatiKeyAlias());
            params.setKeyPassword(this.getSicurezzaMessaggioCertificatiKeyPassword());
        }
        return params;
    }

    public String getSicurezzaMessaggioCertificatiKeyStoreTipo() {
        if (this.sicurezzaMessaggioCertificatiKeyStoreTipoReaded == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.keyStore.tipo");
                if (value != null) {
                    this.sicurezzaMessaggioCertificatiKeyStoreTipo = value = value.trim();
                }
                this.sicurezzaMessaggioCertificatiKeyStoreTipoReaded = true;
            }
            catch (Exception e) {
                this.logError("Propriet\u00e0 'org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.keyStore.tipo' non impostata, errore:" + e.getMessage());
                this.sicurezzaMessaggioCertificatiKeyStoreTipoReaded = true;
            }
        }
        return this.sicurezzaMessaggioCertificatiKeyStoreTipo;
    }

    public String getSicurezzaMessaggioCertificatiKeyStorePath() throws ProtocolException {
        if (this.sicurezzaMessaggioCertificatiKeyStorePath == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.keyStore.path");
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.sicurezzaMessaggioCertificatiKeyStorePath = value = value.trim();
            }
            catch (Exception e) {
                this.logError("Propriet\u00e0 'org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.keyStore.path' non impostata, errore:" + e.getMessage());
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCertificatiKeyStorePath;
    }

    public String getSicurezzaMessaggioCertificatiKeyStorePassword() throws ProtocolException {
        if (this.sicurezzaMessaggioCertificatiKeyStorePassword == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.keyStore.password");
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.sicurezzaMessaggioCertificatiKeyStorePassword = value = value.trim();
            }
            catch (Exception e) {
                this.logError("Propriet\u00e0 'org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.keyStore.password' non impostata, errore:" + e.getMessage());
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCertificatiKeyStorePassword;
    }

    public String getSicurezzaMessaggioCertificatiKeyAlias() throws ProtocolException {
        if (this.sicurezzaMessaggioCertificatiKeyAlias == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.key.alias");
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.sicurezzaMessaggioCertificatiKeyAlias = value = value.trim();
            }
            catch (Exception e) {
                this.logError("Propriet\u00e0 'org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.key.alias' non impostata, errore:" + e.getMessage());
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCertificatiKeyAlias;
    }

    public String getSicurezzaMessaggioCertificatiKeyPassword() throws ProtocolException {
        if (this.sicurezzaMessaggioCertificatiKeyPassword == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.key.password");
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.sicurezzaMessaggioCertificatiKeyPassword = value = value.trim();
            }
            catch (Exception e) {
                this.logError("Propriet\u00e0 'org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.key.password' non impostata, errore:" + e.getMessage());
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCertificatiKeyPassword;
    }

    public String getSicurezzaMessaggioCertificatiKeyClientId() throws ProtocolException {
        if (this.sicurezzaMessaggioCertificatiKeyClientIdRead == null) {
            String pName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.key.clientId";
            try {
                String value = this.reader.getValueConvertEnvProperties(pName);
                if (value != null && StringUtils.isNotEmpty((String)(value = value.trim()))) {
                    this.sicurezzaMessaggioCertificatiKeyClientId = value;
                }
                this.sicurezzaMessaggioCertificatiKeyClientIdRead = true;
            }
            catch (Exception e) {
                this.logError(this.getPrefixProprieta(pName) + "non impostata, errore:" + e.getMessage());
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCertificatiKeyClientId;
    }

    public String getSicurezzaMessaggioCertificatiKeyKid() throws ProtocolException {
        if (this.sicurezzaMessaggioCertificatiKeyKidRead == null) {
            String pName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.certificati.key.kid";
            try {
                String value = this.reader.getValueConvertEnvProperties(pName);
                if (value != null && StringUtils.isNotEmpty((String)(value = value.trim()))) {
                    this.sicurezzaMessaggioCertificatiKeyKid = value;
                }
                this.sicurezzaMessaggioCertificatiKeyKidRead = true;
            }
            catch (Exception e) {
                this.logError(this.getPrefixProprieta(pName) + "non impostata, errore:" + e.getMessage());
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCertificatiKeyKid;
    }

    public Boolean isSicurezzaMessaggioCorniceSicurezzaEnabled() {
        if (this.isSicurezzaMessaggioCorniceSicurezzaEnabled == null) {
            Boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.corniceSicurezza";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isSicurezzaMessaggioCorniceSicurezzaEnabled = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isSicurezzaMessaggioCorniceSicurezzaEnabled = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isSicurezzaMessaggioCorniceSicurezzaEnabled = defaultValue;
            }
        }
        return this.isSicurezzaMessaggioCorniceSicurezzaEnabled;
    }

    public String getSicurezzaMessaggioCorniceSicurezzaRestCodiceEnte() throws ProtocolException {
        if (this.sicurezzaMessaggioCorniceSicurezzaRestCodiceEnte == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.corniceSicurezza.rest.codice_ente";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.sicurezzaMessaggioCorniceSicurezzaRestCodiceEnte = value = value.trim();
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCorniceSicurezzaRestCodiceEnte;
    }

    public String getSicurezzaMessaggioCorniceSicurezzaRestUser() throws ProtocolException {
        if (this.sicurezzaMessaggioCorniceSicurezzaRestUser == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.corniceSicurezza.rest.user";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.sicurezzaMessaggioCorniceSicurezzaRestUser = value = value.trim();
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCorniceSicurezzaRestUser;
    }

    public String getSicurezzaMessaggioCorniceSicurezzaRestIpuser() throws ProtocolException {
        if (this.sicurezzaMessaggioCorniceSicurezzaRestIpuser == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.corniceSicurezza.rest.ipuser";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.sicurezzaMessaggioCorniceSicurezzaRestIpuser = value = value.trim();
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCorniceSicurezzaRestIpuser;
    }

    public String getSicurezzaMessaggioCorniceSicurezzaSoapCodiceEnte() throws ProtocolException {
        if (this.sicurezzaMessaggioCorniceSicurezzaSoapCodiceEnteReaded == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.corniceSicurezza.soap.codice_ente";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    this.sicurezzaMessaggioCorniceSicurezzaSoapCodiceEnte = value = value.trim();
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            this.sicurezzaMessaggioCorniceSicurezzaSoapCodiceEnteReaded = true;
        }
        return this.sicurezzaMessaggioCorniceSicurezzaSoapCodiceEnte;
    }

    public String getSicurezzaMessaggioCorniceSicurezzaSoapUser() throws ProtocolException {
        if (this.sicurezzaMessaggioCorniceSicurezzaSoapUser == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.corniceSicurezza.soap.user";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.sicurezzaMessaggioCorniceSicurezzaSoapUser = value = value.trim();
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCorniceSicurezzaSoapUser;
    }

    public String getSicurezzaMessaggioCorniceSicurezzaSoapIpuser() throws ProtocolException {
        if (this.sicurezzaMessaggioCorniceSicurezzaSoapIpuser == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.corniceSicurezza.soap.ipuser";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.sicurezzaMessaggioCorniceSicurezzaSoapIpuser = value = value.trim();
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCorniceSicurezzaSoapIpuser;
    }

    public List<String> getSicurezzaMessaggioCorniceSicurezzaDynamicCodiceEnte() throws ProtocolException {
        if (this.sicurezzaMessaggioCorniceSicurezzaDynamicCodiceEnte == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.corniceSicurezza.codice_ente";
            try {
                String value = this.reader.getValue(propertyName);
                this.sicurezzaMessaggioCorniceSicurezzaDynamicCodiceEnte = ModISecurityConfig.convertToList(value);
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCorniceSicurezzaDynamicCodiceEnte;
    }

    public List<String> getSicurezzaMessaggioCorniceSicurezzaDynamicUser() throws ProtocolException {
        if (this.sicurezzaMessaggioCorniceSicurezzaDynamicUser == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.corniceSicurezza.user";
            try {
                String value = this.reader.getValue(propertyName);
                this.sicurezzaMessaggioCorniceSicurezzaDynamicUser = ModISecurityConfig.convertToList(value);
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCorniceSicurezzaDynamicUser;
    }

    public List<String> getSicurezzaMessaggioCorniceSicurezzaDynamicIpuser() throws ProtocolException {
        if (this.sicurezzaMessaggioCorniceSicurezzaDynamicIpuser == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.corniceSicurezza.ipuser";
            try {
                String value = this.reader.getValue(propertyName);
                this.sicurezzaMessaggioCorniceSicurezzaDynamicIpuser = ModISecurityConfig.convertToList(value);
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.sicurezzaMessaggioCorniceSicurezzaDynamicIpuser;
    }

    public List<ModIAuditConfig> getAuditConfig() throws ProtocolException {
        if (this.auditConfig == null) {
            String pName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.audit.pattern";
            try {
                String value = this.reader.getValueConvertEnvProperties(pName);
                if (value != null) {
                    value = value.trim();
                    this.auditConfig = new ArrayList<ModIAuditConfig>();
                    this.readAuditConf(value);
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonCorretta(pName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.auditConfig;
    }

    private void readAuditConf(String value) throws UtilsException, ProtocolException {
        String[] tmp = value.split(",");
        if (tmp != null && tmp.length > 0) {
            for (String auditConf : tmp) {
                auditConf = auditConf.trim();
                String debugPrefix = "Pattern audit '" + auditConf + "'";
                String propertyPrefix = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.audit.pattern." + auditConf;
                Properties p = this.reader.readProperties(propertyPrefix + ".");
                if (p == null || p.isEmpty()) {
                    throw new ProtocolException(debugPrefix + SUFFIX_NON_TROVATA);
                }
                ModIAuditConfig config = new ModIAuditConfig(propertyPrefix, propertyPrefix, p);
                this.auditConfig.add(config);
            }
        }
    }

    public String getSecurityTokenHeaderModIAudit() throws ProtocolException {
        if (this.getSecurityTokenHeaderAudit == null) {
            String name = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.audit.securityToken.header";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getSecurityTokenHeaderAudit = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getSecurityTokenHeaderAudit;
    }

    public boolean isSecurityTokenAuditX509AddKid() {
        if (this.isSecurityTokenAuditX509AddKid == null) {
            boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.audit.x509.kid";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isSecurityTokenAuditX509AddKid = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isSecurityTokenAuditX509AddKid = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isSecurityTokenAuditX509AddKid = defaultValue;
            }
        }
        return this.isSecurityTokenAuditX509AddKid;
    }

    public boolean isSecurityTokenAuditApiSoapX509RiferimentoX5c() {
        if (this.isSecurityTokenAuditApiSoapX509RiferimentoX5c == null) {
            boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.audit.soap.x509.x5c";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isSecurityTokenAuditApiSoapX509RiferimentoX5c = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isSecurityTokenAuditApiSoapX509RiferimentoX5c = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isSecurityTokenAuditApiSoapX509RiferimentoX5c = defaultValue;
            }
        }
        return this.isSecurityTokenAuditApiSoapX509RiferimentoX5c;
    }

    public boolean isSecurityTokenAuditApiSoapX509RiferimentoX5cSingleCertificate() {
        if (this.isSecurityTokenAuditApiSoapX509RiferimentoX5cSingleCertificate == null) {
            boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.audit.soap.x509.x5c.singleCertificate";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isSecurityTokenAuditApiSoapX509RiferimentoX5cSingleCertificate = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isSecurityTokenAuditApiSoapX509RiferimentoX5cSingleCertificate = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isSecurityTokenAuditApiSoapX509RiferimentoX5cSingleCertificate = defaultValue;
            }
        }
        return this.isSecurityTokenAuditApiSoapX509RiferimentoX5cSingleCertificate;
    }

    public boolean isSecurityTokenAuditApiSoapX509RiferimentoX5u() {
        if (this.isSecurityTokenAuditApiSoapX509RiferimentoX5u == null) {
            boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.audit.soap.x509.x5u";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isSecurityTokenAuditApiSoapX509RiferimentoX5u = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isSecurityTokenAuditApiSoapX509RiferimentoX5u = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isSecurityTokenAuditApiSoapX509RiferimentoX5u = defaultValue;
            }
        }
        return this.isSecurityTokenAuditApiSoapX509RiferimentoX5u;
    }

    public boolean isSecurityTokenAuditApiSoapX509RiferimentoX5t() {
        if (this.isSecurityTokenAuditApiSoapX509RiferimentoX5t == null) {
            boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.audit.soap.x509.x5t";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isSecurityTokenAuditApiSoapX509RiferimentoX5t = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isSecurityTokenAuditApiSoapX509RiferimentoX5t = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isSecurityTokenAuditApiSoapX509RiferimentoX5t = defaultValue;
            }
        }
        return this.isSecurityTokenAuditApiSoapX509RiferimentoX5t;
    }

    public boolean isSecurityTokenAuditProcessArrayModeEnabled() throws ProtocolException {
        if (this.getSecurityTokenAuditProcessArrayModeReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.audit.audience.processArrayMode";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getSecurityTokenAuditProcessArrayModeEnabled = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getSecurityTokenAuditProcessArrayModeReaded = true;
        }
        return this.getSecurityTokenAuditProcessArrayModeEnabled;
    }

    public boolean isSecurityTokenAuditAddPurposeId() {
        if (this.isSecurityTokenAuditAddPurposeId == null) {
            boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.audit.addPurposeId";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isSecurityTokenAuditAddPurposeId = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isSecurityTokenAuditAddPurposeId = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isSecurityTokenAuditAddPurposeId = defaultValue;
            }
        }
        return this.isSecurityTokenAuditAddPurposeId;
    }

    public boolean isSecurityTokenAuditExpectedPurposeId() {
        if (this.isSecurityTokenAuditExpectedPurposeId == null) {
            boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.audit.expectedPurposeId";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isSecurityTokenAuditExpectedPurposeId = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isSecurityTokenAuditExpectedPurposeId = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isSecurityTokenAuditExpectedPurposeId = defaultValue;
            }
        }
        return this.isSecurityTokenAuditExpectedPurposeId;
    }

    public boolean isSecurityTokenAuditCompareAuthorizationPurposeId() {
        if (this.isSecurityTokenAuditCompareAuthorizationPurposeId == null) {
            boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.audit.compareAuthorizationPurposeId";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isSecurityTokenAuditCompareAuthorizationPurposeId = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isSecurityTokenAuditCompareAuthorizationPurposeId = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isSecurityTokenAuditCompareAuthorizationPurposeId = defaultValue;
            }
        }
        return this.isSecurityTokenAuditCompareAuthorizationPurposeId;
    }

    public int getSecurityTokenAuditDnonceSize() {
        if (this.getSecurityTokenAuditDnonceSize == null) {
            int defaultValue = 13;
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.audit.dnonce.size";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.getSecurityTokenAuditDnonceSize = Integer.valueOf(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.getSecurityTokenAuditDnonceSize = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.getSecurityTokenAuditDnonceSize = defaultValue;
            }
        }
        return this.getSecurityTokenAuditDnonceSize;
    }

    public String getSecurityTokenAuditDigestAlgorithm() {
        if (this.getSecurityTokenAuditDigestAlgorithm == null) {
            String defaultValue = "SHA256";
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.audit.digest.algo";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    this.getSecurityTokenAuditDigestAlgorithm = value = value.trim();
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.getSecurityTokenAuditDigestAlgorithm = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.getSecurityTokenAuditDigestAlgorithm = defaultValue;
            }
        }
        return this.getSecurityTokenAuditDigestAlgorithm;
    }

    public Boolean isTokenAuthCacheable() {
        if (this.isTokenAuthCacheable == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.auth.cacheable";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isTokenAuthCacheable = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isTokenAuthCacheable = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isTokenAuthCacheable = defaultValue;
            }
        }
        return this.isTokenAuthCacheable;
    }

    public Boolean isTokenAuditCacheable() {
        if (this.isTokenAuditCacheable == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.modipa.sicurezzaMessaggio.audit.cacheable";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isTokenAuditCacheable = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isTokenAuditCacheable = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isTokenAuditCacheable = defaultValue;
            }
        }
        return this.isTokenAuditCacheable;
    }

    public Integer getGestioneRetrieveTokenRefreshTokenBeforeExpirePercent() {
        if (this.isGestioneTokenCacheableRefreshTokenBeforeExpirePercentRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties(this.isGestioneTokenCacheableRefreshTokenBeforeExpirePercentPName);
                if (value != null) {
                    value = value.trim();
                    this.isGestioneTokenCacheableRefreshTokenBeforeExpirePercent = Integer.parseInt(value);
                }
                this.isGestioneTokenCacheableRefreshTokenBeforeExpirePercentRead = true;
            }
            catch (Exception e) {
                this.logError("Proprieta' di openspcoop '" + this.isGestioneTokenCacheableRefreshTokenBeforeExpirePercentPName + "' non impostata, errore:" + e.getMessage(), e);
                this.isGestioneTokenCacheableRefreshTokenBeforeExpirePercent = null;
            }
        }
        return this.isGestioneTokenCacheableRefreshTokenBeforeExpirePercent;
    }

    public Integer getGestioneRetrieveTokenRefreshTokenBeforeExpireSeconds() {
        if (this.sGestioneTokenCacheableRefreshTokenBeforeExpireSecondsRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties(this.sGestioneTokenCacheableRefreshTokenBeforeExpireSecondsPName);
                if (value != null) {
                    value = value.trim();
                    this.sGestioneTokenCacheableRefreshTokenBeforeExpireSeconds = Integer.parseInt(value);
                }
                this.sGestioneTokenCacheableRefreshTokenBeforeExpireSecondsRead = true;
            }
            catch (Exception e) {
                this.logError("Proprieta' di openspcoop '" + this.sGestioneTokenCacheableRefreshTokenBeforeExpireSecondsPName + "' non impostata, errore:" + e.getMessage(), e);
                this.sGestioneTokenCacheableRefreshTokenBeforeExpireSeconds = null;
            }
        }
        return this.sGestioneTokenCacheableRefreshTokenBeforeExpireSeconds;
    }

    public Boolean isGenerazioneTracce() {
        if (this.isGenerazioneTracce == null) {
            Boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.generazioneTracce.enabled";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneTracce = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isGenerazioneTracce = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isGenerazioneTracce = defaultValue;
            }
        }
        return this.isGenerazioneTracce;
    }

    public Boolean isGenerazioneTracceRegistraToken() {
        if (this.isGenerazioneTracceRegistraToken == null) {
            Boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.generazioneTracce.registrazioneToken.enabled";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneTracceRegistraToken = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isGenerazioneTracceRegistraToken = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isGenerazioneTracceRegistraToken = defaultValue;
            }
        }
        return this.isGenerazioneTracceRegistraToken;
    }

    public boolean isGenerazioneTracceRegistraCustomClaims() {
        if (this.isGenerazioneTracceRegistraCustomClaims == null) {
            Boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.generazioneTracce.registrazioneCustomClaims.enabled";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneTracceRegistraCustomClaims = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isGenerazioneTracceRegistraCustomClaims = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isGenerazioneTracceRegistraCustomClaims = defaultValue;
            }
        }
        return this.isGenerazioneTracceRegistraCustomClaims;
    }

    public List<String> getGenerazioneTracceRegistraCustomClaimsBlackList() throws ProtocolException {
        if (this.getGenerazioneTracceRegistraCustomClaimsBlackList == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.generazioneTracce.registrazioneCustomClaims.blackList";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null && StringUtils.isNotEmpty((String)value)) {
                    this.getGenerazioneTracceRegistraCustomClaimsBlackList = ModISecurityConfig.convertToList(value);
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.getGenerazioneTracceRegistraCustomClaimsBlackList;
    }

    public Boolean isModIVersioneBozza() {
        if (this.isModIVersioneBozza == null) {
            Boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.usaVersioneBozza";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isModIVersioneBozza = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isModIVersioneBozza = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isModIVersioneBozza = defaultValue;
            }
        }
        return this.isModIVersioneBozza;
    }

    public String getRestSecurityTokenHeaderModI() throws ProtocolException {
        if (this.getRestSecurityTokenHeader == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.header";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getRestSecurityTokenHeader = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestSecurityTokenHeader;
    }

    public boolean isSecurityTokenX509AddKid() {
        if (this.isSecurityTokenX509AddKid == null) {
            boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.rest.securityToken.x509.kid";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isSecurityTokenX509AddKid = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isSecurityTokenX509AddKid = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isSecurityTokenX509AddKid = defaultValue;
            }
        }
        return this.isSecurityTokenX509AddKid;
    }

    public boolean isSecurityTokenIntegrity01AddPurposeId() {
        if (this.isSecurityTokenIntegrity01AddPurposeId == null) {
            boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.rest.securityToken.integrity_01.addPurposeId";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isSecurityTokenIntegrity01AddPurposeId = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isSecurityTokenIntegrity01AddPurposeId = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isSecurityTokenIntegrity01AddPurposeId = defaultValue;
            }
        }
        return this.isSecurityTokenIntegrity01AddPurposeId;
    }

    public boolean isSecurityTokenIntegrity02AddPurposeId() {
        if (this.isSecurityTokenIntegrity02AddPurposeId == null) {
            boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.rest.securityToken.integrity_02.addPurposeId";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.isSecurityTokenIntegrity02AddPurposeId = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.isSecurityTokenIntegrity02AddPurposeId = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.isSecurityTokenIntegrity02AddPurposeId = defaultValue;
            }
        }
        return this.isSecurityTokenIntegrity02AddPurposeId;
    }

    public boolean isRestSecurityTokenClaimsIssuerEnabled() throws ProtocolException {
        if (this.getRestSecurityTokenClaimsIssuerEnabledReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.claims.iss.enabled";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getRestSecurityTokenClaimsIssuerEnabled = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getRestSecurityTokenClaimsIssuerEnabledReaded = true;
        }
        return this.getRestSecurityTokenClaimsIssuerEnabled;
    }

    public String getRestSecurityTokenClaimsIssuerHeaderValue() throws ProtocolException {
        if (this.getRestSecurityTokenClaimsIssuerHeaderValueReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.claims.iss";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    this.getRestSecurityTokenClaimsIssuerHeaderValue = value = value.trim();
                }
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getRestSecurityTokenClaimsIssuerHeaderValueReaded = true;
        }
        return this.getRestSecurityTokenClaimsIssuerHeaderValue;
    }

    public boolean isRestSecurityTokenClaimsSubjectEnabled() throws ProtocolException {
        if (this.getRestSecurityTokenClaimsSubjectEnabledReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.claims.sub.enabled";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getRestSecurityTokenClaimsSubjectEnabled = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getRestSecurityTokenClaimsSubjectEnabledReaded = true;
        }
        return this.getRestSecurityTokenClaimsSubjectEnabled;
    }

    public String getRestSecurityTokenClaimsSubjectHeaderValue() throws ProtocolException {
        if (this.getRestSecurityTokenClaimsSubjectHeaderValueReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.claims.sub";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    this.getRestSecurityTokenClaimsSubjectHeaderValue = value = value.trim();
                }
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getRestSecurityTokenClaimsSubjectHeaderValueReaded = true;
        }
        return this.getRestSecurityTokenClaimsSubjectHeaderValue;
    }

    public String getRestSecurityTokenClaimsClientIdHeader() throws ProtocolException {
        if (this.getRestSecurityTokenClaimsClientIdHeader == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.claims.client_id";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getRestSecurityTokenClaimsClientIdHeader = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestSecurityTokenClaimsClientIdHeader;
    }

    public String getRestSecurityTokenClaimSignedHeaders() throws ProtocolException {
        if (this.getRestSecurityTokenClaimSignedHeaders == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.claims.signedHeaders";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getRestSecurityTokenClaimSignedHeaders = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestSecurityTokenClaimSignedHeaders;
    }

    public String getRestSecurityTokenClaimRequestDigest() throws ProtocolException {
        if (this.getRestSecurityTokenClaimRequestDigest == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.claims.requestDigest";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getRestSecurityTokenClaimRequestDigest = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestSecurityTokenClaimRequestDigest;
    }

    public String[] getRestSecurityTokenSignedHeaders() throws ProtocolException {
        block5: {
            if (this.getRestSecurityTokenSignedHeaders == null) {
                String name = "org.openspcoop2.protocol.modipa.rest.securityToken.signedHeaders";
                try {
                    String value = this.reader.getValueConvertEnvProperties(name);
                    if (value != null) {
                        value = value.trim();
                        String[] tmp = value.split(",");
                        this.getRestSecurityTokenSignedHeaders = new String[tmp.length];
                        for (int i = 0; i < tmp.length; ++i) {
                            this.getRestSecurityTokenSignedHeaders[i] = tmp[i].trim();
                        }
                        break block5;
                    }
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                catch (Exception e) {
                    String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                    this.logError(msgErrore);
                    throw new ProtocolException(msgErrore, (Throwable)e);
                }
            }
        }
        return this.getRestSecurityTokenSignedHeaders;
    }

    public String getRestSecurityTokenSignedHeadersAsString() {
        StringBuilder bf = new StringBuilder();
        for (String hdr : this.getRestSecurityTokenSignedHeaders) {
            if (bf.length() > 0) {
                bf.append(",");
            }
            bf.append(hdr);
        }
        return bf.toString();
    }

    public Long getRestSecurityTokenClaimsIatTimeCheckFutureToleranceMilliseconds() throws ProtocolException {
        if (this.getRestSecurityTokenClaimsIatTimeCheckFutureToleranceMillisecondsReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.claims.iat.future.toleranceMilliseconds";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    long tmp = Long.parseLong(value = value.trim());
                    if (tmp > 0L) {
                        long maxLongValue = Long.MAX_VALUE;
                        if (tmp > maxLongValue) {
                            this.logWarn(this.getPrefixValoreIndicatoProprieta(value, name) + this.getSuffixSuperioreMassimoConsentitoControlloDisabilitato(maxLongValue));
                        } else {
                            this.getRestSecurityTokenClaimsIatTimeCheckFutureToleranceMilliseconds = tmp;
                        }
                    } else {
                        this.logWarn(this.getMessaggioVerificaDisabilitata(name));
                    }
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(name, e), e);
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            this.getRestSecurityTokenClaimsIatTimeCheckFutureToleranceMillisecondsReaded = true;
        }
        return this.getRestSecurityTokenClaimsIatTimeCheckFutureToleranceMilliseconds;
    }

    public Long getRestSecurityTokenClaimsIatTimeCheckMilliseconds() throws ProtocolException {
        if (this.getRestSecurityTokenClaimsIatTimeCheckMillisecondsReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.claims.iat.minutes";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    long tmp = Long.parseLong(value = value.trim());
                    if (tmp > 0L) {
                        long maxLongValue = 153722867280912L;
                        if (tmp > maxLongValue) {
                            this.logWarn(this.getPrefixValoreIndicatoProprieta(value, name) + this.getSuffixSuperioreMassimoConsentitoControlloDisabilitato(maxLongValue));
                        } else {
                            this.getRestSecurityTokenClaimsIatTimeCheckMilliseconds = tmp * 60L * 1000L;
                        }
                    } else {
                        this.logWarn(this.getMessaggioVerificaDisabilitata(name));
                    }
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(name, e), e);
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            this.getRestSecurityTokenClaimsIatTimeCheckMillisecondsReaded = true;
        }
        return this.getRestSecurityTokenClaimsIatTimeCheckMilliseconds;
    }

    public boolean isRestSecurityTokenClaimsExpTimeCheck() throws ProtocolException {
        if (this.isRestSecurityTokenClaimsExpTimeCheck == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.claims.exp.checkEnabled";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.isRestSecurityTokenClaimsExpTimeCheck = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.isRestSecurityTokenClaimsExpTimeCheck;
    }

    public Long getRestSecurityTokenClaimsExpTimeCheckToleranceMilliseconds() throws ProtocolException {
        if (this.getRestSecurityTokenClaimsExpTimeCheckToleranceMillisecondsReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.claims.exp.toleranceMilliseconds";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    long tmp = Long.parseLong(value = value.trim());
                    if (tmp > 0L) {
                        long maxLongValue = Long.MAX_VALUE;
                        if (tmp > maxLongValue) {
                            this.logWarn(this.getPrefixValoreIndicatoProprieta(value, name) + this.getSuffixSuperioreMassimoConsentitoControlloDisabilitato(maxLongValue));
                        } else {
                            this.getRestSecurityTokenClaimsExpTimeCheckToleranceMilliseconds = tmp;
                        }
                    } else {
                        this.logWarn(this.getMessaggioVerificaDisabilitata(name));
                    }
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(name, e), e);
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            this.getRestSecurityTokenClaimsExpTimeCheckToleranceMillisecondsReaded = true;
        }
        return this.getRestSecurityTokenClaimsExpTimeCheckToleranceMilliseconds;
    }

    public Long getRestSecurityTokenClaimsNbfTimeCheckToleranceMilliseconds() throws ProtocolException {
        if (this.getRestSecurityTokenClaimsNbfTimeCheckToleranceMillisecondsReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.claims.nbf.toleranceMilliseconds";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    long tmp = Long.parseLong(value = value.trim());
                    if (tmp > 0L) {
                        long maxLongValue = Long.MAX_VALUE;
                        if (tmp > maxLongValue) {
                            this.logWarn(this.getPrefixValoreIndicatoProprieta(value, name) + this.getSuffixSuperioreMassimoConsentitoControlloDisabilitato(maxLongValue));
                        } else {
                            this.getRestSecurityTokenClaimsNbfTimeCheckToleranceMilliseconds = tmp;
                        }
                    } else {
                        this.logWarn(this.getMessaggioVerificaDisabilitata(name));
                    }
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(name, e), e);
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            this.getRestSecurityTokenClaimsNbfTimeCheckToleranceMillisecondsReaded = true;
        }
        return this.getRestSecurityTokenClaimsNbfTimeCheckToleranceMilliseconds;
    }

    public DigestEncoding getRestSecurityTokenDigestDefaultEncoding() throws ProtocolException {
        block5: {
            if (this.getRestSecurityTokenDigestDefaultEncoding == null) {
                String name = "org.openspcoop2.protocol.modipa.rest.securityToken.digest.encoding";
                try {
                    String value = this.reader.getValueConvertEnvProperties(name);
                    if (value != null) {
                        value = value.trim();
                        this.getRestSecurityTokenDigestDefaultEncoding = DigestEncoding.valueOf((String)value.toUpperCase());
                        if (this.getRestSecurityTokenDigestDefaultEncoding == null) {
                            throw new ProtocolException(INVALID_VALUE);
                        }
                        break block5;
                    }
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                catch (Exception e) {
                    String msgErrore = this.getPrefixProprieta(name) + " non impostata, errore (valori ammessi: " + DigestEncoding.BASE64.name().toLowerCase() + "," + DigestEncoding.HEX.name().toLowerCase() + "):" + e.getMessage();
                    this.logError(msgErrore);
                    throw new ProtocolException(msgErrore, (Throwable)e);
                }
            }
        }
        return this.getRestSecurityTokenDigestDefaultEncoding;
    }

    public boolean isRestSecurityTokenDigestEncodingChoice() throws ProtocolException {
        if (this.isRestSecurityTokenDigestEncodingChoice == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.digest.encoding.choice";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.isRestSecurityTokenDigestEncodingChoice = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.isRestSecurityTokenDigestEncodingChoice;
    }

    public List<DigestEncoding> getRestSecurityTokenDigestEncodingAccepted() throws ProtocolException {
        block7: {
            if (this.getRestSecurityTokenDigestEncodingAccepted == null) {
                String name = "org.openspcoop2.protocol.modipa.rest.securityToken.digest.encoding.accepted";
                try {
                    String value = this.reader.getValueConvertEnvProperties(name);
                    if (value != null) {
                        value = value.trim();
                        this.getRestSecurityTokenDigestEncodingAccepted = new ArrayList<DigestEncoding>();
                        if (value.contains(",")) {
                            this.readRestSecurityTokenDigestEncodingAcceptedSplitValue(value);
                        } else {
                            DigestEncoding tmp = DigestEncoding.valueOf((String)value.toUpperCase());
                            if (tmp == null) {
                                throw new ProtocolException(INVALID_VALUE);
                            }
                            this.getRestSecurityTokenDigestEncodingAccepted.add(tmp);
                        }
                        break block7;
                    }
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                catch (Exception e) {
                    String msgErrore = this.getPrefixProprieta(name) + " non impostata, errore (valori ammessi: " + DigestEncoding.BASE64.name().toLowerCase() + "," + DigestEncoding.HEX.name().toLowerCase() + "):" + e.getMessage();
                    this.logError(msgErrore);
                    throw new ProtocolException(msgErrore, (Throwable)e);
                }
            }
        }
        return this.getRestSecurityTokenDigestEncodingAccepted;
    }

    private void readRestSecurityTokenDigestEncodingAcceptedSplitValue(String value) throws ProtocolException {
        String[] split = value.split(",");
        if (split == null || split.length <= 0) {
            throw new ProtocolException("Empty value");
        }
        for (String s : split) {
            if (s == null) {
                throw new ProtocolException("Null value");
            }
            DigestEncoding tmp = DigestEncoding.valueOf((String)(s = s.trim()).toUpperCase());
            if (tmp == null) {
                throw new ProtocolException(INVALID_VALUE);
            }
            this.getRestSecurityTokenDigestEncodingAccepted.add(tmp);
        }
    }

    public boolean isRestSecurityTokenRequestDigestClean() throws ProtocolException {
        if (this.getRestSecurityTokenRequestDigestCleanReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.request.digest.clean";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getRestSecurityTokenRequestDigestClean = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getRestSecurityTokenRequestDigestCleanReaded = true;
        }
        return this.getRestSecurityTokenRequestDigestClean;
    }

    public boolean isRestSecurityTokenResponseDigestClean() throws ProtocolException {
        if (this.getRestSecurityTokenResponseDigestCleanReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.response.digest.clean";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getRestSecurityTokenResponseDigestClean = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getRestSecurityTokenResponseDigestCleanReaded = true;
        }
        return this.getRestSecurityTokenResponseDigestClean;
    }

    public boolean isRestSecurityTokenResponseDigestHEADuseServerHeader() throws ProtocolException {
        if (this.getRestSecurityTokenResponseDigestHEADuseServerHeaderReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.response.digest.HEAD.useServerHeader";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getRestSecurityTokenResponseDigestHEADuseServerHeader = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getRestSecurityTokenResponseDigestHEADuseServerHeaderReaded = true;
        }
        return this.getRestSecurityTokenResponseDigestHEADuseServerHeader;
    }

    public boolean isRestSecurityTokenFaultProcessEnabled() throws ProtocolException {
        if (this.getRestSecurityTokenFaultProcessEnabledReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.fault.securityToken";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getRestSecurityTokenFaultProcessEnabled = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getRestSecurityTokenFaultProcessEnabledReaded = true;
        }
        return this.getRestSecurityTokenFaultProcessEnabled;
    }

    public boolean isRestSecurityTokenAudienceProcessArrayModeEnabled() throws ProtocolException {
        if (this.getRestSecurityTokenAudienceProcessArrayModeReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.securityToken.audience.processArrayMode";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getRestSecurityTokenAudienceProcessArrayModeEnabled = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getRestSecurityTokenAudienceProcessArrayModeReaded = true;
        }
        return this.getRestSecurityTokenAudienceProcessArrayModeEnabled;
    }

    public String getRestResponseSecurityTokenAudienceDefault(String soggettoMittente) throws ProtocolException {
        if (this.getRestResponseSecurityTokenAudienceDefaultReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.response.securityToken.audience.default";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    this.getRestResponseSecurityTokenAudienceDefault = value = value.trim();
                }
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getRestResponseSecurityTokenAudienceDefaultReaded = true;
        }
        if ("#SoggettoMittente#".equalsIgnoreCase(this.getRestResponseSecurityTokenAudienceDefault) && soggettoMittente != null && !StringUtils.isEmpty((String)soggettoMittente)) {
            return soggettoMittente;
        }
        return this.getRestResponseSecurityTokenAudienceDefault;
    }

    public List<String> getUsedRestSecurityClaims(boolean request, boolean integrita) throws ProtocolException {
        String v;
        ArrayList<String> l = new ArrayList<String>();
        l.add("iat");
        l.add("nbf");
        l.add("exp");
        l.add("jti");
        if (request) {
            l.add("aud");
            v = this.getRestSecurityTokenClaimsClientIdHeader();
            if (v != null && StringUtils.isNotEmpty((String)v)) {
                l.add(v);
            }
        }
        if (!request && (v = this.getRestSecurityTokenClaimRequestDigest()) != null && StringUtils.isNotEmpty((String)v)) {
            l.add(v);
        }
        if (integrita && (v = this.getRestSecurityTokenClaimSignedHeaders()) != null && StringUtils.isNotEmpty((String)v)) {
            l.add(v);
        }
        return l;
    }

    public String getRestCorrelationIdHeader() throws ProtocolException {
        if (this.getRestCorrelationIdHeader == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.correlationId.header";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getRestCorrelationIdHeader = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestCorrelationIdHeader;
    }

    public String getRestReplyToHeader() throws ProtocolException {
        if (this.getRestReplyToHeader == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.replyTo.header";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getRestReplyToHeader = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestReplyToHeader;
    }

    public String getRestLocationHeader() throws ProtocolException {
        if (this.getRestLocationHeader == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.location.header";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getRestLocationHeader = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestLocationHeader;
    }

    public boolean isRestProfiliInterazioneCheckCompatibility() throws ProtocolException {
        if (this.getRestProfiliInterazioneCheckCompatibilityReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.profiliInterazione.checkCompatibility";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getRestProfiliInterazioneCheckCompatibility = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getRestProfiliInterazioneCheckCompatibilityReaded = true;
        }
        return this.getRestProfiliInterazioneCheckCompatibility;
    }

    public Integer[] getRestBloccanteHttpStatus() throws ProtocolException {
        block7: {
            if (this.getRestBloccanteHttpStatus == null) {
                String name = "org.openspcoop2.protocol.modipa.rest.bloccante.httpStatus";
                try {
                    String value = this.reader.getValueConvertEnvProperties(name);
                    if (value != null) {
                        if ("2xx".equalsIgnoreCase(value = value.trim())) {
                            this.getRestBloccanteHttpStatus = new Integer[1];
                            this.getRestBloccanteHttpStatus[0] = -2;
                        } else {
                            String[] tmp = value.split(",");
                            this.getRestBloccanteHttpStatus = new Integer[tmp.length];
                            for (int i = 0; i < tmp.length; ++i) {
                                this.getRestBloccanteHttpStatus[i] = Integer.valueOf(tmp[i].trim());
                            }
                        }
                        break block7;
                    }
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                catch (Exception e) {
                    String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                    this.logError(msgErrore);
                    throw new ProtocolException(msgErrore, (Throwable)e);
                }
            }
        }
        return this.getRestBloccanteHttpStatus;
    }

    public List<HttpRequestMethod> getRestBloccanteHttpMethod() throws ProtocolException {
        if (this.getRestBloccanteHttpMethod == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.bloccante.httpMethod";
            try {
                this.getRestBloccanteHttpMethod = new ArrayList<HttpRequestMethod>();
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    value = value.trim();
                    String[] tmp = value.split(",");
                    for (int i = 0; i < tmp.length; ++i) {
                        this.getRestBloccanteHttpMethod.add(HttpRequestMethod.valueOf((String)tmp[i].trim().toUpperCase()));
                    }
                }
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonCorretta(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestBloccanteHttpMethod;
    }

    public boolean isRestSecurityTokenPushReplyToUpdateOrCreateInFruizione() throws ProtocolException {
        if (this.getRestSecurityTokenPushReplyToUpdateOrCreate == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.push.replyTo.header.updateOrCreate";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getRestSecurityTokenPushReplyToUpdateOrCreate = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestSecurityTokenPushReplyToUpdateOrCreate;
    }

    public boolean isRestSecurityTokenPushReplyToUpdateInErogazione() throws ProtocolException {
        if (this.getRestSecurityTokenPushReplyToUpdate == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.push.replyTo.header.update";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getRestSecurityTokenPushReplyToUpdate = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestSecurityTokenPushReplyToUpdate;
    }

    public boolean isRestSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists() throws ProtocolException {
        if (this.getRestSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.push.request.correlationId.header.useTransactionIdIfNotExists";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getRestSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists;
    }

    public Integer[] getRestNonBloccantePushRequestHttpStatus() throws ProtocolException {
        block5: {
            if (this.getRestSecurityTokenPushRequestHttpStatus == null) {
                String name = "org.openspcoop2.protocol.modipa.rest.push.request.httpStatus";
                try {
                    String value = this.reader.getValueConvertEnvProperties(name);
                    if (value != null) {
                        value = value.trim();
                        String[] tmp = value.split(",");
                        this.getRestSecurityTokenPushRequestHttpStatus = new Integer[tmp.length];
                        for (int i = 0; i < tmp.length; ++i) {
                            this.getRestSecurityTokenPushRequestHttpStatus[i] = Integer.valueOf(tmp[i].trim());
                        }
                        break block5;
                    }
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                catch (Exception e) {
                    String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                    this.logError(msgErrore);
                    throw new ProtocolException(msgErrore, (Throwable)e);
                }
            }
        }
        return this.getRestSecurityTokenPushRequestHttpStatus;
    }

    public List<HttpRequestMethod> getRestNonBloccantePushRequestHttpMethod() throws ProtocolException {
        if (this.getRestNonBloccantePushRequestHttpMethod == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.push.request.httpMethod";
            try {
                this.getRestNonBloccantePushRequestHttpMethod = new ArrayList<HttpRequestMethod>();
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    value = value.trim();
                    String[] tmp = value.split(",");
                    for (int i = 0; i < tmp.length; ++i) {
                        this.getRestNonBloccantePushRequestHttpMethod.add(HttpRequestMethod.valueOf((String)tmp[i].trim().toUpperCase()));
                    }
                }
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonCorretta(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestNonBloccantePushRequestHttpMethod;
    }

    public Integer[] getRestNonBloccantePushResponseHttpStatus() throws ProtocolException {
        block5: {
            if (this.getRestSecurityTokenPushResponseHttpStatus == null) {
                String name = "org.openspcoop2.protocol.modipa.rest.push.response.httpStatus";
                try {
                    String value = this.reader.getValueConvertEnvProperties(name);
                    if (value != null) {
                        value = value.trim();
                        String[] tmp = value.split(",");
                        this.getRestSecurityTokenPushResponseHttpStatus = new Integer[tmp.length];
                        for (int i = 0; i < tmp.length; ++i) {
                            this.getRestSecurityTokenPushResponseHttpStatus[i] = Integer.valueOf(tmp[i].trim());
                        }
                        break block5;
                    }
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                catch (Exception e) {
                    String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                    this.logError(msgErrore);
                    throw new ProtocolException(msgErrore, (Throwable)e);
                }
            }
        }
        return this.getRestSecurityTokenPushResponseHttpStatus;
    }

    public List<HttpRequestMethod> getRestNonBloccantePushResponseHttpMethod() throws ProtocolException {
        if (this.getRestNonBloccantePushResponseHttpMethod == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.push.response.httpMethod";
            try {
                this.getRestNonBloccantePushResponseHttpMethod = new ArrayList<HttpRequestMethod>();
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    value = value.trim();
                    String[] tmp = value.split(",");
                    for (int i = 0; i < tmp.length; ++i) {
                        this.getRestNonBloccantePushResponseHttpMethod.add(HttpRequestMethod.valueOf((String)tmp[i].trim().toUpperCase()));
                    }
                }
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonCorretta(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestNonBloccantePushResponseHttpMethod;
    }

    public List<HttpRequestMethod> getRestNonBloccantePushHttpMethod() throws ProtocolException {
        List<HttpRequestMethod> res;
        if (this.getRestNonBloccantePushHttpMethod != null) {
            return this.getRestNonBloccantePushHttpMethod;
        }
        this.getRestNonBloccantePushHttpMethod = new ArrayList<HttpRequestMethod>();
        List<HttpRequestMethod> req = this.getRestNonBloccantePushRequestHttpMethod();
        if (req != null && !req.isEmpty()) {
            this.getRestNonBloccantePushHttpMethod.addAll(req);
        }
        if ((res = this.getRestNonBloccantePushResponseHttpMethod()) != null && !res.isEmpty()) {
            for (HttpRequestMethod httpRequestMethod : res) {
                if (this.getRestNonBloccantePushHttpMethod.contains(httpRequestMethod)) continue;
                this.getRestNonBloccantePushHttpMethod.add(httpRequestMethod);
            }
        }
        return this.getRestNonBloccantePushHttpMethod;
    }

    public Integer[] getRestNonBloccantePullRequestHttpStatus() throws ProtocolException {
        block5: {
            if (this.getRestSecurityTokenPullRequestHttpStatus == null) {
                String name = "org.openspcoop2.protocol.modipa.rest.pull.request.httpStatus";
                try {
                    String value = this.reader.getValueConvertEnvProperties(name);
                    if (value != null) {
                        value = value.trim();
                        String[] tmp = value.split(",");
                        this.getRestSecurityTokenPullRequestHttpStatus = new Integer[tmp.length];
                        for (int i = 0; i < tmp.length; ++i) {
                            this.getRestSecurityTokenPullRequestHttpStatus[i] = Integer.valueOf(tmp[i].trim());
                        }
                        break block5;
                    }
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                catch (Exception e) {
                    String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                    this.logError(msgErrore);
                    throw new ProtocolException(msgErrore, (Throwable)e);
                }
            }
        }
        return this.getRestSecurityTokenPullRequestHttpStatus;
    }

    public List<HttpRequestMethod> getRestNonBloccantePullRequestHttpMethod() throws ProtocolException {
        if (this.getRestNonBloccantePullRequestHttpMethod == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.pull.request.httpMethod";
            try {
                this.getRestNonBloccantePullRequestHttpMethod = new ArrayList<HttpRequestMethod>();
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    value = value.trim();
                    String[] tmp = value.split(",");
                    for (int i = 0; i < tmp.length; ++i) {
                        this.getRestNonBloccantePullRequestHttpMethod.add(HttpRequestMethod.valueOf((String)tmp[i].trim().toUpperCase()));
                    }
                }
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonCorretta(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestNonBloccantePullRequestHttpMethod;
    }

    public Integer[] getRestNonBloccantePullRequestStateNotReadyHttpStatus() throws ProtocolException {
        block5: {
            if (this.getRestSecurityTokenPullRequestStateNotReadyHttpStatus == null) {
                String name = "org.openspcoop2.protocol.modipa.rest.pull.requestState.notReady.httpStatus";
                try {
                    String value = this.reader.getValueConvertEnvProperties(name);
                    if (value != null) {
                        value = value.trim();
                        String[] tmp = value.split(",");
                        this.getRestSecurityTokenPullRequestStateNotReadyHttpStatus = new Integer[tmp.length];
                        for (int i = 0; i < tmp.length; ++i) {
                            this.getRestSecurityTokenPullRequestStateNotReadyHttpStatus[i] = Integer.valueOf(tmp[i].trim());
                        }
                        break block5;
                    }
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                catch (Exception e) {
                    String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                    this.logError(msgErrore);
                    throw new ProtocolException(msgErrore, (Throwable)e);
                }
            }
        }
        return this.getRestSecurityTokenPullRequestStateNotReadyHttpStatus;
    }

    public Integer[] getRestNonBloccantePullRequestStateOkHttpStatus() throws ProtocolException {
        block5: {
            if (this.getRestSecurityTokenPullRequestStateOkHttpStatus == null) {
                String name = "org.openspcoop2.protocol.modipa.rest.pull.requestState.ok.httpStatus";
                try {
                    String value = this.reader.getValueConvertEnvProperties(name);
                    if (value != null) {
                        value = value.trim();
                        String[] tmp = value.split(",");
                        this.getRestSecurityTokenPullRequestStateOkHttpStatus = new Integer[tmp.length];
                        for (int i = 0; i < tmp.length; ++i) {
                            this.getRestSecurityTokenPullRequestStateOkHttpStatus[i] = Integer.valueOf(tmp[i].trim());
                        }
                        break block5;
                    }
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                catch (Exception e) {
                    String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                    this.logError(msgErrore);
                    throw new ProtocolException(msgErrore, (Throwable)e);
                }
            }
        }
        return this.getRestSecurityTokenPullRequestStateOkHttpStatus;
    }

    public List<HttpRequestMethod> getRestNonBloccantePullRequestStateHttpMethod() throws ProtocolException {
        if (this.getRestNonBloccantePullRequestStateHttpMethod == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.pull.requestState.httpMethod";
            try {
                this.getRestNonBloccantePullRequestStateHttpMethod = new ArrayList<HttpRequestMethod>();
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    value = value.trim();
                    String[] tmp = value.split(",");
                    for (int i = 0; i < tmp.length; ++i) {
                        this.getRestNonBloccantePullRequestStateHttpMethod.add(HttpRequestMethod.valueOf((String)tmp[i].trim().toUpperCase()));
                    }
                }
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonCorretta(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestNonBloccantePullRequestStateHttpMethod;
    }

    public Integer[] getRestNonBloccantePullResponseHttpStatus() throws ProtocolException {
        block5: {
            if (this.getRestSecurityTokenPullResponseHttpStatus == null) {
                String name = "org.openspcoop2.protocol.modipa.rest.pull.response.httpStatus";
                try {
                    String value = this.reader.getValueConvertEnvProperties(name);
                    if (value != null) {
                        value = value.trim();
                        String[] tmp = value.split(",");
                        this.getRestSecurityTokenPullResponseHttpStatus = new Integer[tmp.length];
                        for (int i = 0; i < tmp.length; ++i) {
                            this.getRestSecurityTokenPullResponseHttpStatus[i] = Integer.valueOf(tmp[i].trim());
                        }
                        break block5;
                    }
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                catch (Exception e) {
                    String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                    this.logError(msgErrore);
                    throw new ProtocolException(msgErrore, (Throwable)e);
                }
            }
        }
        return this.getRestSecurityTokenPullResponseHttpStatus;
    }

    public List<HttpRequestMethod> getRestNonBloccantePullResponseHttpMethod() throws ProtocolException {
        if (this.getRestNonBloccantePullResponseHttpMethod == null) {
            String name = "org.openspcoop2.protocol.modipa.rest.pull.response.httpMethod";
            try {
                this.getRestNonBloccantePullResponseHttpMethod = new ArrayList<HttpRequestMethod>();
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    value = value.trim();
                    String[] tmp = value.split(",");
                    for (int i = 0; i < tmp.length; ++i) {
                        this.getRestNonBloccantePullResponseHttpMethod.add(HttpRequestMethod.valueOf((String)tmp[i].trim().toUpperCase()));
                    }
                }
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonCorretta(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getRestNonBloccantePullResponseHttpMethod;
    }

    public List<HttpRequestMethod> getRestNonBloccantePullHttpMethod() throws ProtocolException {
        if (this.getRestNonBloccantePullHttpMethod != null) {
            return this.getRestNonBloccantePullHttpMethod;
        }
        this.getRestNonBloccantePullHttpMethod = new ArrayList<HttpRequestMethod>();
        this.readRestNonBloccantePullHttpMethodRequest();
        this.readRestNonBloccantePullHttpMethodResponse();
        return this.getRestNonBloccantePullHttpMethod;
    }

    private void readRestNonBloccantePullHttpMethodRequest() throws ProtocolException {
        List<HttpRequestMethod> reqState;
        List<HttpRequestMethod> req = this.getRestNonBloccantePullRequestHttpMethod();
        if (req != null && !req.isEmpty()) {
            this.getRestNonBloccantePullHttpMethod.addAll(req);
        }
        if ((reqState = this.getRestNonBloccantePullRequestStateHttpMethod()) != null && !reqState.isEmpty()) {
            for (HttpRequestMethod httpRequestMethod : reqState) {
                if (this.getRestNonBloccantePullHttpMethod.contains(httpRequestMethod)) continue;
                this.getRestNonBloccantePullHttpMethod.add(httpRequestMethod);
            }
        }
    }

    private void readRestNonBloccantePullHttpMethodResponse() throws ProtocolException {
        List<HttpRequestMethod> res = this.getRestNonBloccantePullResponseHttpMethod();
        if (res != null && !res.isEmpty()) {
            for (HttpRequestMethod httpRequestMethod : res) {
                if (this.getRestNonBloccantePullHttpMethod.contains(httpRequestMethod)) continue;
                this.getRestNonBloccantePullHttpMethod.add(httpRequestMethod);
            }
        }
    }

    public boolean isSoapSecurityTokenMustUnderstand() throws ProtocolException {
        if (this.getSoapSecurityTokenMustUnderstandReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.securityToken.mustUnderstand";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getSoapSecurityTokenMustUnderstand = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getSoapSecurityTokenMustUnderstandReaded = true;
        }
        return this.getSoapSecurityTokenMustUnderstand;
    }

    public String getSoapSecurityTokenActor() throws ProtocolException {
        if (this.getSoapSecurityTokenActorReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.securityToken.actor";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null && !"".equals(value = value.trim())) {
                    this.getSoapSecurityTokenActor = value;
                }
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getSoapSecurityTokenActorReaded = true;
        }
        return this.getSoapSecurityTokenActor;
    }

    public Long getSoapSecurityTokenTimestampCreatedTimeCheckMilliseconds() throws ProtocolException {
        if (this.getSoapSecurityTokenTimestampCreatedTimeCheckMillisecondsReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.securityToken.timestamp.created.minutes";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    long tmp = Long.parseLong(value = value.trim());
                    if (tmp > 0L) {
                        long maxLongValue = 153722867280912L;
                        if (tmp > maxLongValue) {
                            this.logWarn(this.getPrefixValoreIndicatoProprieta(value, name) + this.getSuffixSuperioreMassimoConsentitoControlloDisabilitato(maxLongValue));
                        } else {
                            this.getSoapSecurityTokenTimestampCreatedTimeCheckMilliseconds = tmp * 60L * 1000L;
                        }
                    } else {
                        this.logWarn(this.getMessaggioVerificaDisabilitata(name));
                    }
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(name, e), e);
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            this.getSoapSecurityTokenTimestampCreatedTimeCheckMillisecondsReaded = true;
        }
        return this.getSoapSecurityTokenTimestampCreatedTimeCheckMilliseconds;
    }

    public Long getSoapSecurityTokenTimestampCreatedTimeCheckFutureToleranceMilliseconds() throws ProtocolException {
        if (this.getSoapSecurityTokenTimestampCreatedTimeCheckFutureToleranceMillisecondsReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.securityToken.timestamp.created.future.toleranceMilliseconds";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    long tmp = Long.parseLong(value = value.trim());
                    if (tmp > 0L) {
                        long maxLongValue = Long.MAX_VALUE;
                        if (tmp > maxLongValue) {
                            this.logWarn(this.getPrefixValoreIndicatoProprieta(value, name) + this.getSuffixSuperioreMassimoConsentitoControlloDisabilitato(maxLongValue));
                        } else {
                            this.getSoapSecurityTokenTimestampCreatedTimeCheckFutureToleranceMilliseconds = tmp;
                        }
                    } else {
                        this.logWarn(this.getMessaggioVerificaDisabilitata(name));
                    }
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(name, e), e);
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            this.getSoapSecurityTokenTimestampCreatedTimeCheckFutureToleranceMillisecondsReaded = true;
        }
        return this.getSoapSecurityTokenTimestampCreatedTimeCheckFutureToleranceMilliseconds;
    }

    public boolean isSoapSecurityTokenFaultProcessEnabled() throws ProtocolException {
        if (this.getSoapSecurityTokenFaultProcessEnabledReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.fault.securityToken";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getSoapSecurityTokenFaultProcessEnabled = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getSoapSecurityTokenFaultProcessEnabledReaded = true;
        }
        return this.getSoapSecurityTokenFaultProcessEnabled;
    }

    public boolean isSoapSecurityTokenTimestampExpiresTimeCheck() throws ProtocolException {
        if (this.isSoapSecurityTokenTimestampExpiresTimeCheck == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.securityToken.timestamp.expires.checkEnabled";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.isSoapSecurityTokenTimestampExpiresTimeCheck = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.isSoapSecurityTokenTimestampExpiresTimeCheck;
    }

    public Long getSoapSecurityTokenTimestampExpiresTimeCheckToleranceMilliseconds() throws ProtocolException {
        if (this.getSoapSecurityTokenTimestampExpiresTimeCheckToleranceMillisecondsReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.securityToken.timestamp.expires.toleranceMilliseconds";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    long tmp = Long.parseLong(value = value.trim());
                    if (tmp > 0L) {
                        long maxLongValue = Long.MAX_VALUE;
                        if (tmp > maxLongValue) {
                            this.logWarn(this.getPrefixValoreIndicatoProprieta(value, name) + this.getSuffixSuperioreMassimoConsentitoControlloDisabilitato(maxLongValue));
                        } else {
                            this.getSoapSecurityTokenTimestampExpiresTimeCheckToleranceMilliseconds = tmp;
                        }
                    } else {
                        this.logWarn(this.getMessaggioVerificaDisabilitata(name));
                    }
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(name, e), e);
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            this.getSoapSecurityTokenTimestampExpiresTimeCheckToleranceMillisecondsReaded = true;
        }
        return this.getSoapSecurityTokenTimestampExpiresTimeCheckToleranceMilliseconds;
    }

    public boolean isSoapWSAddressingMustUnderstand() throws ProtocolException {
        if (this.getSoapWSAddressingMustUnderstandReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.wsaddressing.mustUnderstand";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getSoapWSAddressingMustUnderstand = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getSoapWSAddressingMustUnderstandReaded = true;
        }
        return this.getSoapWSAddressingMustUnderstand;
    }

    public String getSoapWSAddressingActor() throws ProtocolException {
        if (this.getSoapWSAddressingActorReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.wsaddressing.actor";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null && !"".equals(value = value.trim())) {
                    this.getSoapWSAddressingActor = value;
                }
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getSoapWSAddressingActorReaded = true;
        }
        return this.getSoapWSAddressingActor;
    }

    public boolean isSoapWSAddressingSchemaValidation() throws ProtocolException {
        if (this.getSoapWSAddressingSchemaValidationReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.wsaddressing.schemaValidation";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getSoapWSAddressingSchemaValidation = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getSoapWSAddressingSchemaValidationReaded = true;
        }
        return this.getSoapWSAddressingSchemaValidation;
    }

    public String getSoapCorrelationIdName() throws ProtocolException {
        if (this.getSoapCorrelationIdName == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.correlationId.name";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getSoapCorrelationIdName = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getSoapCorrelationIdName;
    }

    public String getSoapCorrelationIdNamespace() throws ProtocolException {
        if (this.getSoapCorrelationIdNamespace == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.correlationId.namespace";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getSoapCorrelationIdNamespace = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getSoapCorrelationIdNamespace;
    }

    public boolean useSoapBodyCorrelationIdNamespace() throws ProtocolException {
        return "useBodyNamespace".equals(this.getSoapCorrelationIdNamespace());
    }

    public String getSoapCorrelationIdPrefix() throws ProtocolException {
        if (this.getSoapCorrelationIdPrefix == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.correlationId.prefix";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getSoapCorrelationIdPrefix = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getSoapCorrelationIdPrefix;
    }

    public boolean isSoapCorrelationIdMustUnderstand() throws ProtocolException {
        if (this.getSoapCorrelationIdMustUnderstandReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.correlationId.mustUnderstand";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getSoapCorrelationIdMustUnderstand = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getSoapCorrelationIdMustUnderstandReaded = true;
        }
        return this.getSoapCorrelationIdMustUnderstand;
    }

    public String getSoapCorrelationIdActor() throws ProtocolException {
        if (this.getSoapCorrelationIdActorReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.correlationId.actor";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null && !"".equals(value = value.trim())) {
                    this.getSoapCorrelationIdActor = value;
                }
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getSoapCorrelationIdActorReaded = true;
        }
        return this.getSoapCorrelationIdActor;
    }

    public String getSoapReplyToName() throws ProtocolException {
        if (this.getSoapReplyToName == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.replyTo.name";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getSoapReplyToName = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getSoapReplyToName;
    }

    public String getSoapReplyToNamespace() throws ProtocolException {
        if (this.getSoapReplyToNamespace == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.replyTo.namespace";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getSoapReplyToNamespace = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getSoapReplyToNamespace;
    }

    public boolean useSoapBodyReplyToNamespace() throws ProtocolException {
        return "useBodyNamespace".equals(this.getSoapReplyToNamespace());
    }

    public String getSoapReplyToPrefix() throws ProtocolException {
        if (this.getSoapReplyToPrefix == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.replyTo.prefix";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getSoapReplyToPrefix = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getSoapReplyToPrefix;
    }

    public boolean isSoapReplyToMustUnderstand() throws ProtocolException {
        if (this.getSoapReplyToMustUnderstandReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.replyTo.mustUnderstand";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getSoapReplyToMustUnderstand = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getSoapReplyToMustUnderstandReaded = true;
        }
        return this.getSoapReplyToMustUnderstand;
    }

    public String getSoapReplyToActor() throws ProtocolException {
        if (this.getSoapReplyToActorReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.replyTo.actor";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null && !"".equals(value = value.trim())) {
                    this.getSoapReplyToActor = value;
                }
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getSoapReplyToActorReaded = true;
        }
        return this.getSoapReplyToActor;
    }

    public String getSoapRequestDigestName() throws ProtocolException {
        if (this.getSoapRequestDigestName == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.requestDigest.name";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getSoapRequestDigestName = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getSoapRequestDigestName;
    }

    public String getSoapRequestDigestNamespace() throws ProtocolException {
        if (this.getSoapRequestDigestNamespace == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.requestDigest.namespace";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getSoapRequestDigestNamespace = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getSoapRequestDigestNamespace;
    }

    public boolean useSoapBodyRequestDigestNamespace() throws ProtocolException {
        return "useBodyNamespace".equals(this.getSoapRequestDigestNamespace());
    }

    public String getSoapRequestDigestPrefix() throws ProtocolException {
        if (this.getSoapRequestDigestPrefix == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.requestDigest.prefix";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getSoapRequestDigestPrefix = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getSoapRequestDigestPrefix;
    }

    public boolean isSoapRequestDigestMustUnderstand() throws ProtocolException {
        if (this.getSoapRequestDigestMustUnderstandReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.requestDigest.mustUnderstand";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getSoapRequestDigestMustUnderstand = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getSoapRequestDigestMustUnderstandReaded = true;
        }
        return this.getSoapRequestDigestMustUnderstand;
    }

    public String getSoapRequestDigestActor() throws ProtocolException {
        if (this.getSoapRequestDigestActorReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.requestDigest.actor";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null && !"".equals(value = value.trim())) {
                    this.getSoapRequestDigestActor = value;
                }
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getSoapRequestDigestActorReaded = true;
        }
        return this.getSoapRequestDigestActor;
    }

    private String getSoapSecurityTokenWsaTo() throws ProtocolException {
        if (this.getSoapSecurityTokenWsaToReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.securityToken.wsaTo";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.getSoapSecurityTokenWsaTo = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getSoapSecurityTokenWsaToReaded = true;
        }
        return this.getSoapSecurityTokenWsaTo;
    }

    public boolean isSoapSecurityTokenWsaToSoapAction() throws ProtocolException {
        if (this.getSoapSecurityTokenWsaToSoapAction == null) {
            this.getSoapSecurityTokenWsaToSoapAction = "soapAction".equalsIgnoreCase(this.getSoapSecurityTokenWsaTo());
        }
        return this.getSoapSecurityTokenWsaToSoapAction;
    }

    public boolean isSoapSecurityTokenWsaToOperation() throws ProtocolException {
        if (this.getSoapSecurityTokenWsaToOperation == null) {
            this.getSoapSecurityTokenWsaToOperation = "operation".equalsIgnoreCase(this.getSoapSecurityTokenWsaTo());
        }
        return this.getSoapSecurityTokenWsaToOperation;
    }

    public boolean isSoapSecurityTokenWsaToDisabled() throws ProtocolException {
        if (this.getSoapSecurityTokenWsaToNone == null) {
            this.getSoapSecurityTokenWsaToNone = "none".equalsIgnoreCase(this.getSoapSecurityTokenWsaTo());
        }
        return this.getSoapSecurityTokenWsaToNone;
    }

    public String getSoapResponseSecurityTokenAudienceDefault(String soggettoMittente) throws ProtocolException {
        if (this.getSoapResponseSecurityTokenAudienceDefaultReaded == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.response.securityToken.audience.default";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value != null) {
                    this.getSoapResponseSecurityTokenAudienceDefault = value = value.trim();
                }
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            this.getSoapResponseSecurityTokenAudienceDefaultReaded = true;
        }
        if ("#SoggettoMittente#".equalsIgnoreCase(this.getSoapResponseSecurityTokenAudienceDefault) && soggettoMittente != null && !StringUtils.isEmpty((String)soggettoMittente)) {
            return soggettoMittente;
        }
        return this.getSoapResponseSecurityTokenAudienceDefault;
    }

    public boolean isSoapSecurityTokenPushReplyToUpdateOrCreateInFruizione() throws ProtocolException {
        if (this.getSoapSecurityTokenPushReplyToUpdateOrCreate == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.push.replyTo.header.updateOrCreate";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getSoapSecurityTokenPushReplyToUpdateOrCreate = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getSoapSecurityTokenPushReplyToUpdateOrCreate;
    }

    public boolean isSoapSecurityTokenPushReplyToUpdateInErogazione() throws ProtocolException {
        if (this.getSoapSecurityTokenPushReplyToUpdate == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.push.replyTo.header.update";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getSoapSecurityTokenPushReplyToUpdate = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getSoapSecurityTokenPushReplyToUpdate;
    }

    public boolean isSoapSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists() throws ProtocolException {
        if (this.getSoapSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.push.request.correlationId.header.useTransactionIdIfNotExists";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getSoapSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getSoapSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists;
    }

    public boolean isSoapSecurityTokenPullCorrelationIdUseTransactionIdIfNotExists() throws ProtocolException {
        if (this.getSoapSecurityTokenPullCorrelationIdUseTransactionIdIfNotExists == null) {
            String name = "org.openspcoop2.protocol.modipa.soap.pull.request.correlationId.header.useTransactionIdIfNotExists";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                value = value.trim();
                this.getSoapSecurityTokenPullCorrelationIdUseTransactionIdIfNotExists = Boolean.valueOf(value);
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.getSoapSecurityTokenPullCorrelationIdUseTransactionIdIfNotExists;
    }

    public Boolean isReadByPathBufferEnabled() {
        if (this.isReadByPathBufferEnabled == null) {
            String pName = "org.openspcoop2.protocol.modipa.readByPath.buffer";
            try {
                String value = this.reader.getValueConvertEnvProperties(pName);
                if (value != null) {
                    value = value.trim();
                    this.isReadByPathBufferEnabled = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, true));
                    this.isReadByPathBufferEnabled = true;
                }
            }
            catch (Exception e) {
                this.logWarn(this.getMessaggioErroreProprietaNonImpostata(pName, true) + this.getSuffixErrore(e));
                this.isReadByPathBufferEnabled = true;
            }
        }
        return this.isReadByPathBufferEnabled;
    }

    public Boolean isValidazioneBufferEnabled() {
        if (this.isValidazioneBufferEnabled == null) {
            String pName = "org.openspcoop2.protocol.modipa.validazione.buffer";
            try {
                String value = this.reader.getValueConvertEnvProperties(pName);
                if (value != null) {
                    value = value.trim();
                    this.isValidazioneBufferEnabled = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, true));
                    this.isValidazioneBufferEnabled = true;
                }
            }
            catch (Exception e) {
                this.logWarn(this.getMessaggioErroreProprietaNonImpostata(pName, true) + this.getSuffixErrore(e));
                this.isValidazioneBufferEnabled = true;
            }
        }
        return this.isValidazioneBufferEnabled;
    }

    public Boolean isRiferimentoIDRichiestaPortaDelegataRequired() {
        if (this.isRiferimentoIDRichiestaPortaDelegataRequiredRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.pd.riferimentoIdRichiesta.required");
                if (value != null) {
                    value = value.trim();
                    this.isRiferimentoIDRichiestaPortaDelegataRequired = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata("org.openspcoop2.protocol.modipa.pd.riferimentoIdRichiesta.required", true));
                    this.isRiferimentoIDRichiestaPortaDelegataRequired = true;
                }
                this.isRiferimentoIDRichiestaPortaDelegataRequiredRead = true;
            }
            catch (Exception e) {
                this.logWarn("Propriet\u00e0 'org.openspcoop2.protocol.modipa.pd.riferimentoIdRichiesta.required' non impostata, viene utilizzato il default 'true', errore:" + e.getMessage());
                this.isRiferimentoIDRichiestaPortaDelegataRequired = true;
                this.isRiferimentoIDRichiestaPortaDelegataRequiredRead = true;
            }
        }
        return this.isRiferimentoIDRichiestaPortaDelegataRequired;
    }

    public Boolean isRiferimentoIDRichiestaPortaApplicativaRequired() {
        if (this.isRiferimentoIDRichiestaPortaApplicativaRequiredRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.pa.riferimentoIdRichiesta.required");
                if (value != null) {
                    value = value.trim();
                    this.isRiferimentoIDRichiestaPortaApplicativaRequired = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata("org.openspcoop2.protocol.modipa.pa.riferimentoIdRichiesta.required", true));
                    this.isRiferimentoIDRichiestaPortaApplicativaRequired = true;
                }
                this.isRiferimentoIDRichiestaPortaApplicativaRequiredRead = true;
            }
            catch (Exception e) {
                this.logWarn("Propriet\u00e0 'org.openspcoop2.protocol.modipa.pa.riferimentoIdRichiesta.required' non impostata, viene utilizzato il default 'true', errore:" + e.getMessage());
                this.isRiferimentoIDRichiestaPortaApplicativaRequired = true;
                this.isRiferimentoIDRichiestaPortaApplicativaRequiredRead = true;
            }
        }
        return this.isRiferimentoIDRichiestaPortaApplicativaRequired;
    }

    public Boolean isTokenOAuthUseJtiIntegrityAsMessageId() {
        if (this.isTokenOAuthUseJtiIntegrityAsMessageIdRead == null) {
            String pName = "org.openspcoop2.protocol.modipa.tokenOAuthIntegrity.useJtiIntegrityAsMessageId";
            try {
                String value = this.reader.getValueConvertEnvProperties(pName);
                if (value != null) {
                    value = value.trim();
                    this.isTokenOAuthUseJtiIntegrityAsMessageId = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(pName, true));
                    this.isTokenOAuthUseJtiIntegrityAsMessageId = true;
                }
                this.isTokenOAuthUseJtiIntegrityAsMessageIdRead = true;
            }
            catch (Exception e) {
                this.logWarn(PREFIX_PROPRIETA + pName + "' non impostata, viene utilizzato il default 'true', errore:" + e.getMessage());
                this.isTokenOAuthUseJtiIntegrityAsMessageId = true;
                this.isTokenOAuthUseJtiIntegrityAsMessageIdRead = true;
            }
        }
        return this.isTokenOAuthUseJtiIntegrityAsMessageId;
    }

    public Boolean isPortaApplicativaBustaErrorePersonalizzaElementiFault() {
        if (this.isPortaApplicativaBustaErrorePersonalizzaElementiFaultRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.pa.bustaErrore.personalizzaElementiFault");
                if (value != null) {
                    value = value.trim();
                    this.isPortaApplicativaBustaErrorePersonalizzaElementiFault = Boolean.parseBoolean(value);
                } else {
                    this.logDebug("Propriet\u00e0 'org.openspcoop2.protocol.modipa.pa.bustaErrore.personalizzaElementiFault' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails)");
                    this.isPortaApplicativaBustaErrorePersonalizzaElementiFault = null;
                }
                this.isPortaApplicativaBustaErrorePersonalizzaElementiFaultRead = true;
            }
            catch (Exception e) {
                this.logWarn("Propriet\u00e0 'org.openspcoop2.protocol.modipa.pa.bustaErrore.personalizzaElementiFault' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails), errore:" + e.getMessage());
                this.isPortaApplicativaBustaErrorePersonalizzaElementiFault = null;
                this.isPortaApplicativaBustaErrorePersonalizzaElementiFaultRead = true;
            }
        }
        return this.isPortaApplicativaBustaErrorePersonalizzaElementiFault;
    }

    public Boolean isPortaApplicativaBustaErroreAggiungiErroreApplicativo() {
        if (this.isPortaApplicativaBustaErroreAggiungiErroreApplicativoRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.pa.bustaErrore.aggiungiErroreApplicativo");
                if (value != null) {
                    value = value.trim();
                    this.isPortaApplicativaBustaErroreAggiungiErroreApplicativo = Boolean.parseBoolean(value);
                } else {
                    this.logDebug("Propriet\u00e0 'org.openspcoop2.protocol.modipa.pa.bustaErrore.aggiungiErroreApplicativo' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails)");
                    this.isPortaApplicativaBustaErroreAggiungiErroreApplicativo = null;
                }
                this.isPortaApplicativaBustaErroreAggiungiErroreApplicativoRead = true;
            }
            catch (Exception e) {
                this.logWarn("Propriet\u00e0 'org.openspcoop2.protocol.modipa.pa.bustaErrore.aggiungiErroreApplicativo' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails), errore:" + e.getMessage());
                this.isPortaApplicativaBustaErroreAggiungiErroreApplicativo = null;
                this.isPortaApplicativaBustaErroreAggiungiErroreApplicativoRead = true;
            }
        }
        return this.isPortaApplicativaBustaErroreAggiungiErroreApplicativo;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolValidazione() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolValidazione == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.protocol.eccezioneIntestazione");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolValidazione = Boolean.parseBoolean(value);
                } else {
                    this.logWarn(this.getMessaggioErroreProprietaNonImpostata("org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.protocol.eccezioneIntestazione", false));
                    this.isGenerazioneDetailsSOAPFaultProtocolValidazione = false;
                }
            }
            catch (Exception e) {
                this.logWarn("Propriet\u00e0 'org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.protocol.eccezioneIntestazione' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolValidazione = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolValidazione;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolProcessamento() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolProcessamento == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.protocol.eccezioneProcessamento");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolProcessamento = Boolean.parseBoolean(value);
                } else {
                    this.logWarn(this.getMessaggioErroreProprietaNonImpostata("org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.protocol.eccezioneProcessamento", true));
                    this.isGenerazioneDetailsSOAPFaultProtocolProcessamento = true;
                }
            }
            catch (Exception e) {
                this.logWarn("Propriet\u00e0 'org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.protocol.eccezioneProcessamento' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolProcessamento = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolProcessamento;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolWithStackTrace() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.protocol.stackTrace");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = Boolean.parseBoolean(value);
                } else {
                    this.logWarn(this.getMessaggioErroreProprietaNonImpostata("org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.protocol.stackTrace", false));
                    this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = false;
                }
            }
            catch (Exception e) {
                this.logWarn("Propriet\u00e0 'org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.protocol.stackTrace' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.protocol.informazioniGeneriche");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = Boolean.parseBoolean(value);
                } else {
                    this.logWarn(this.getMessaggioErroreProprietaNonImpostata("org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.protocol.informazioniGeneriche", true));
                    this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = true;
                }
            }
            catch (Exception e) {
                this.logWarn("Propriet\u00e0 'org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.protocol.informazioniGeneriche' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationServerError() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationServerError == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.integration.serverError");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationServerError = Boolean.parseBoolean(value);
                } else {
                    this.logWarn(this.getMessaggioErroreProprietaNonImpostata("org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.integration.serverError", true));
                    this.isGenerazioneDetailsSOAPFaultIntegrationServerError = true;
                }
            }
            catch (Exception e) {
                this.logWarn("Propriet\u00e0 'org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.integration.serverError' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationServerError = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationServerError;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationClientError() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationClientError == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.integration.clientError");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationClientError = Boolean.parseBoolean(value);
                } else {
                    this.logWarn(this.getMessaggioErroreProprietaNonImpostata("org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.integration.clientError", false));
                    this.isGenerazioneDetailsSOAPFaultIntegrationClientError = false;
                }
            }
            catch (Exception e) {
                this.logWarn("Propriet\u00e0 'org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.integration.clientError' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationClientError = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationClientError;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.integration.stackTrace");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = Boolean.parseBoolean(value);
                } else {
                    this.logWarn(this.getMessaggioErroreProprietaNonImpostata("org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.integration.stackTrace", false));
                    this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = false;
                }
            }
            catch (Exception e) {
                this.logWarn("Propriet\u00e0 'org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.integration.stackTrace' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace;
    }

    public Boolean isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.integration.informazioniGeneriche");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = Boolean.parseBoolean(value);
                } else {
                    this.logDebug("Propriet\u00e0 'org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.integration.informazioniGeneriche' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultAsGenericCode)");
                    this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
                }
                this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = true;
            }
            catch (Exception e) {
                this.logWarn("Propriet\u00e0 'org.openspcoop2.protocol.modipa.generazioneDetailsSoapFault.integration.informazioniGeneriche' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultAsGenericCode), errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
                this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche;
    }

    public BooleanNullable isAggiungiDetailErroreApplicativoSoapFaultApplicativo() {
        if (this.isAggiungiDetailErroreApplicativoSoapFaultApplicativoRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.erroreApplicativo.faultApplicativo.enrichDetails");
                if (value != null) {
                    Boolean b = Boolean.parseBoolean(value = value.trim());
                    this.isAggiungiDetailErroreApplicativoSoapFaultApplicativo = b != false ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
                } else {
                    this.logDebug("Propriet\u00e0 'org.openspcoop2.protocol.modipa.erroreApplicativo.faultApplicativo.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails)");
                    this.isAggiungiDetailErroreApplicativoSoapFaultApplicativo = BooleanNullable.NULL();
                }
                this.isAggiungiDetailErroreApplicativoSoapFaultApplicativoRead = true;
            }
            catch (Exception e) {
                this.logWarn("Propriet\u00e0 'org.openspcoop2.protocol.modipa.erroreApplicativo.faultApplicativo.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails), errore:" + e.getMessage());
                this.isAggiungiDetailErroreApplicativoSoapFaultApplicativo = BooleanNullable.NULL();
                this.isAggiungiDetailErroreApplicativoSoapFaultApplicativoRead = true;
            }
        }
        return this.isAggiungiDetailErroreApplicativoSoapFaultApplicativo;
    }

    public BooleanNullable isAggiungiDetailErroreApplicativoSoapFaultPdD() {
        if (this.isAggiungiDetailErroreApplicativoSoapFaultPdDRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.modipa.erroreApplicativo.faultPdD.enrichDetails");
                if (value != null) {
                    Boolean b = Boolean.parseBoolean(value = value.trim());
                    this.isAggiungiDetailErroreApplicativoSoapFaultPdD = b != false ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
                } else {
                    this.logDebug("Propriet\u00e0 'org.openspcoop2.protocol.modipa.erroreApplicativo.faultPdD.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultPdD.enrichDetails)");
                    this.isAggiungiDetailErroreApplicativoSoapFaultPdD = BooleanNullable.NULL();
                }
                this.isAggiungiDetailErroreApplicativoSoapFaultPdDRead = true;
            }
            catch (Exception e) {
                this.logWarn("Propriet\u00e0 'org.openspcoop2.protocol.modipa.erroreApplicativo.faultPdD.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultPdD.enrichDetails), errore:" + e.getMessage());
                this.isAggiungiDetailErroreApplicativoSoapFaultPdD = BooleanNullable.NULL();
                this.isAggiungiDetailErroreApplicativoSoapFaultPdDRead = true;
            }
        }
        return this.isAggiungiDetailErroreApplicativoSoapFaultPdD;
    }

    private Boolean useConfigStaticInstance() {
        if (this.useConfigStaticInstance == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.modipa.factory.config.staticInstance";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.useConfigStaticInstance = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.useConfigStaticInstance = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.useConfigStaticInstance = defaultValue;
            }
        }
        return this.useConfigStaticInstance;
    }

    private Boolean useErroreApplicativoStaticInstance() {
        if (this.useErroreApplicativoStaticInstance == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.modipa.factory.erroreApplicativo.staticInstance";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.useErroreApplicativoStaticInstance = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.useErroreApplicativoStaticInstance = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.useErroreApplicativoStaticInstance = defaultValue;
            }
        }
        return this.useErroreApplicativoStaticInstance;
    }

    private Boolean useEsitoStaticInstance() {
        if (this.useEsitoStaticInstance == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.modipa.factory.esito.staticInstance";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.useEsitoStaticInstance = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.useEsitoStaticInstance = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.useEsitoStaticInstance = defaultValue;
            }
        }
        return this.useEsitoStaticInstance;
    }

    public BasicStaticInstanceConfig getStaticInstanceConfig() {
        if (this.staticInstanceConfig == null) {
            this.staticInstanceConfig = new BasicStaticInstanceConfig();
            if (this.useConfigStaticInstance() != null) {
                this.staticInstanceConfig.setStaticConfig(this.useConfigStaticInstance().booleanValue());
            }
            if (this.useErroreApplicativoStaticInstance() != null) {
                this.staticInstanceConfig.setStaticErrorBuilder(this.useErroreApplicativoStaticInstance().booleanValue());
            }
            if (this.useEsitoStaticInstance() != null) {
                this.staticInstanceConfig.setStaticEsitoBuilder(this.useEsitoStaticInstance().booleanValue());
            }
        }
        return this.staticInstanceConfig;
    }

    public boolean isSignalHubEnabled() {
        if (this.signalHubEnabled == null) {
            Boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.signalHub.enabled";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.signalHubEnabled = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.signalHubEnabled = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.signalHubEnabled = defaultValue;
            }
        }
        return this.signalHubEnabled;
    }

    public boolean isSignalHubPseudonymizationChoiceEnabled() {
        if (this.signalHubPseudonymizationChoiceEnabled == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.modipa.signalHub.pseudonymization.choice.enabled";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.signalHubPseudonymizationChoiceEnabled = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.signalHubPseudonymizationChoiceEnabled = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.signalHubPseudonymizationChoiceEnabled = defaultValue;
            }
        }
        return this.signalHubPseudonymizationChoiceEnabled;
    }

    public List<String> getSignalHubAlgorithms() throws ProtocolException {
        if (this.signalHubAlgorithms == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.signalHub.algorithms";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                this.signalHubAlgorithms = ModISecurityConfig.convertToList(value);
                if (this.signalHubAlgorithms == null || this.signalHubAlgorithms.isEmpty()) {
                    throw new ProtocolException("SignalHub algorithms undefined");
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.signalHubAlgorithms;
    }

    public String getSignalHubDefaultAlgorithm() throws ProtocolException {
        if (this.signalHubDefaultAlgorithm == null) {
            String name = "org.openspcoop2.protocol.modipa.signalHub.algorithms.default";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.signalHubDefaultAlgorithm = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.signalHubDefaultAlgorithm;
    }

    public List<Integer> getSignalHubSeedSize() throws ProtocolException {
        if (this.signalHubSeedSize == null) {
            String propertyName = "org.openspcoop2.protocol.modipa.signalHub.seed.size";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                this.signalHubSeedSize = ModISecurityConfig.convertToList(value).stream().map(Integer::parseInt).collect(Collectors.toList());
                if (this.signalHubSeedSize == null || this.signalHubSeedSize.isEmpty()) {
                    throw new ProtocolException("SignalHub algorithms undefined");
                }
                for (Integer s : this.signalHubSeedSize) {
                    ModIProperties.validateSignalHubInteger("Signal Hub - Seed size", s);
                }
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonImpostata(propertyName, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.signalHubSeedSize;
    }

    private static void validateSignalHubInteger(String objectTitle, Integer i) throws ProtocolException {
        try {
            if (i <= 0) {
                throw new ProtocolException("must be a positive integer greater than 0");
            }
        }
        catch (Exception e) {
            throw new ProtocolException(objectTitle + " '" + i + "' invalid; must be a positive integer greater than 0");
        }
    }

    public Integer getSignalHubDefaultSeedSize() throws ProtocolException {
        if (this.signalHubDefaultSeedSize == null) {
            String name = "org.openspcoop2.protocol.modipa.signalHub.seed.size.default";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                Integer valueInt = Integer.parseInt(value.trim());
                ModIProperties.validateSignalHubInteger("Signal Hub - Default seed size", valueInt);
                this.signalHubDefaultSeedSize = valueInt;
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.signalHubDefaultSeedSize;
    }

    public boolean isSignalHubSeedLifetimeUnlimited() {
        if (this.signalHubSeedLifetimeUnlimited == null) {
            Boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.signalHub.seed.lifetime.unlimited";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.signalHubSeedLifetimeUnlimited = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.signalHubSeedLifetimeUnlimited = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.signalHubSeedLifetimeUnlimited = defaultValue;
            }
        }
        return this.signalHubSeedLifetimeUnlimited;
    }

    public Integer getSignalHubDeSeedSeedLifetimeDaysDefault() throws ProtocolException {
        if (this.signalHubDefaultSeedLifetimeDaysDefault == null) {
            String name = "org.openspcoop2.protocol.modipa.signalHub.seed.lifetime.days.default";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                Integer valueInt = Integer.parseInt(value.trim());
                ModIProperties.validateSignalHubInteger("Signal Hub - Default lifetime days", valueInt);
                this.signalHubDefaultSeedLifetimeDaysDefault = valueInt;
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.signalHubDefaultSeedLifetimeDaysDefault;
    }

    public String getSignalHubSoapNamespace() throws ProtocolException {
        if (this.signalHubSoapNamespace == null) {
            String name = "org.openspcoop2.protocol.modipa.signalHub.soap.namespace";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.signalHubSoapNamespace = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.signalHubSoapNamespace;
    }

    public String getSignalHubApiName() throws ProtocolException {
        if (this.signalHubApiName == null) {
            String name = "org.openspcoop2.protocol.modipa.signalHub.api.name";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                this.signalHubApiName = value = value.trim();
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.signalHubApiName;
    }

    public int getSignalHubApiVersion() throws ProtocolException {
        if (this.signalHubApiVersion == null) {
            String name = "org.openspcoop2.protocol.modipa.signalHub.api.version";
            try {
                String value = this.reader.getValueConvertEnvProperties(name);
                if (value == null) {
                    throw this.newProtocolExceptionPropertyNonDefinita();
                }
                Integer valueInt = Integer.parseInt(value.trim());
                ModIProperties.validateSignalHubInteger("Signal Hub - API Version", valueInt);
                this.signalHubApiVersion = valueInt;
            }
            catch (Exception e) {
                String msgErrore = this.getMessaggioErroreProprietaNonImpostata(name, e);
                this.logError(msgErrore);
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
        }
        return this.signalHubApiVersion;
    }

    public ModISignalHubConfig getSignalHubConfig() throws ProtocolException {
        if (this.signalHubConfig == null) {
            String propertyPrefix = "org.openspcoop2.protocol.modipa.signalHub";
            try {
                String debugPrefix = "Param signal hub '" + propertyPrefix + "'";
                Properties p = this.reader.readProperties(propertyPrefix + ".");
                if (p == null || p.isEmpty()) {
                    throw new ProtocolException(debugPrefix + SUFFIX_NON_TROVATA);
                }
                this.signalHubConfig = new ModISignalHubConfig(propertyPrefix, p);
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonCorretta(propertyPrefix, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.signalHubConfig;
    }

    public String getSignalHubHashCompose() throws ProtocolException {
        if (this.signalHubHashCompose == null) {
            String name = "org.openspcoop2.protocol.modipa.signalHub.hash.composition";
            try {
                String value = this.reader.getValue(name);
                if (value == null || value.isBlank()) {
                    throw new ProtocolException(name + SUFFIX_NON_TROVATA);
                }
                this.signalHubHashCompose = value;
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonCorretta(name, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.signalHubHashCompose;
    }

    public int getSignalHubDigestHistroy() throws ProtocolException {
        if (this.signalHubDigestHistroy == null) {
            String name = "org.openspcoop2.protocol.modipa.signalHub.seed.history";
            try {
                Integer value;
                String rawValue = this.reader.getValue(name);
                if (rawValue == null || rawValue.isBlank()) {
                    throw new ProtocolException(name + SUFFIX_NON_TROVATA);
                }
                this.signalHubDigestHistroy = value = Integer.valueOf(rawValue);
            }
            catch (Exception e) {
                this.logError(this.getMessaggioErroreProprietaNonCorretta(name, e));
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return this.signalHubDigestHistroy;
    }

    public boolean isTracingPDNDEnabled() {
        if (this.tracingPDNDEnabled == null) {
            Boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.modipa.tracingPDND.enabled";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.tracingPDNDEnabled = Boolean.parseBoolean(value);
                } else {
                    this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue));
                    this.tracingPDNDEnabled = defaultValue;
                }
            }
            catch (Exception e) {
                this.logDebug(this.getMessaggioErroreProprietaNonImpostata(propertyName, defaultValue) + this.getSuffixErrore(e));
                this.tracingPDNDEnabled = defaultValue;
            }
        }
        return this.tracingPDNDEnabled;
    }
}

