/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.properties;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.ConfigurazioneMultitenant;
import org.openspcoop2.core.config.constants.PortaApplicativaSoggettiFruitori;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.protocol.modipa.constants.ModIConsoleCostanti;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemType;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemValueType;
import org.openspcoop2.protocol.sdk.properties.AbstractConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BaseConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BinaryConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BinaryProperty;
import org.openspcoop2.protocol.sdk.properties.BooleanConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BooleanProperty;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesFactory;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.properties.StringConsoleItem;
import org.openspcoop2.protocol.sdk.properties.StringProperty;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.KeystoreUtils;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.certificate.ocsp.OCSPProvider;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;

public class ModIDynamicConfigurationKeystoreUtilities {
    private ModIDynamicConfigurationKeystoreUtilities() {
    }

    static void addKeystoreConfig(ConsoleConfiguration configuration, boolean checkRidefinisci, boolean addHiddenSubjectIssuer, boolean requiredValue) throws ProtocolException {
        if (checkRidefinisci) {
            BaseConsoleItem subTitleItem = ProtocolPropertiesFactory.newSubTitleItem((String)"modipaAPIImplKeyStoreSubTitleId", (String)"KeyStore");
            subTitleItem.setType(ConsoleItemType.HIDDEN);
            configuration.addConsoleItem(subTitleItem);
        }
        StringConsoleItem modeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaKeystoreMode", (String)"Modalit\u00e0");
        modeItem.setDefaultValue((Object)"path");
        modeItem.setReloadOnChange(true, true);
        configuration.addConsoleItem((BaseConsoleItem)modeItem);
        StringConsoleItem typeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaKeystoreType", (String)"Tipo");
        typeItem.setDefaultValue((Object)ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_DEFAULT_VALUE);
        typeItem.setReloadOnChange(true, true);
        configuration.addConsoleItem((BaseConsoleItem)typeItem);
        AbstractConsoleItem archiveItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BINARY, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaKeystoreArchive", (String)"Archivio");
        ((BinaryConsoleItem)archiveItem).setShowContent(false);
        ((BinaryConsoleItem)archiveItem).setReadOnly(false);
        ((BinaryConsoleItem)archiveItem).setRequired(true);
        ((BinaryConsoleItem)archiveItem).setNoteUpdate("<b>Attenzione:</b> Se i parametri di accesso al nuovo archivio differiscono rispetto a quello precedentemente caricato, <BR/> devono essere aggiornati, ritornando alla pagina precente, prima di procedere con il caricamento del nuovo archivio.");
        ((BinaryConsoleItem)archiveItem).setLock(true);
        configuration.addConsoleItem((BaseConsoleItem)archiveItem);
        AbstractConsoleItem pathItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaKeystorePath", (String)"Path");
        configuration.addConsoleItem((BaseConsoleItem)pathItem);
        AbstractConsoleItem pathPublicKeyItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaKeystorePathPublicKey", (String)"Chiave Pubblica");
        configuration.addConsoleItem((BaseConsoleItem)pathPublicKeyItem);
        StringConsoleItem pathKeyAlgorithmItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaKeystoreKeyPairAlgo", (String)"");
        pathKeyAlgorithmItem.setDefaultValue((Object)"RSA");
        configuration.addConsoleItem((BaseConsoleItem)pathKeyAlgorithmItem);
        AbstractConsoleItem keystorePasswordItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.LOCK_HIDDEN, (String)"modipaKeystorePassword", (String)"Password");
        keystorePasswordItem.setRequired(requiredValue);
        configuration.addConsoleItem((BaseConsoleItem)keystorePasswordItem);
        AbstractConsoleItem keyAliasItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaKeyAlias", (String)"Alias Chiave Privata");
        keyAliasItem.setRequired(requiredValue);
        configuration.addConsoleItem((BaseConsoleItem)keyAliasItem);
        AbstractConsoleItem keyPasswordItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.LOCK_HIDDEN, (String)"modipaKeyPassword", (String)"Password Chiave Privata");
        keyPasswordItem.setRequired(requiredValue);
        configuration.addConsoleItem((BaseConsoleItem)keyPasswordItem);
        AbstractConsoleItem keystoreByokPolicyItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaKeystoreByokPolicy", (String)"BYOK Policy");
        keystoreByokPolicyItem.setRequired(false);
        configuration.addConsoleItem((BaseConsoleItem)keystoreByokPolicyItem);
        AbstractConsoleItem certificateItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BINARY, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaKeystoreCertificate", (String)"Certificato");
        ((BinaryConsoleItem)certificateItem).setShowContent(false);
        ((BinaryConsoleItem)certificateItem).setReadOnly(false);
        ((BinaryConsoleItem)certificateItem).setRequired(false);
        configuration.addConsoleItem((BaseConsoleItem)certificateItem);
        if (addHiddenSubjectIssuer) {
            AbstractConsoleItem cnSubjectItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaKeyCNSubject", (String)"modipaKeyCNSubject");
            configuration.addConsoleItem((BaseConsoleItem)cnSubjectItem);
            AbstractConsoleItem cnIssuerItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaKeyCNIssuer", (String)"modipaKeyCNIssuer");
            configuration.addConsoleItem((BaseConsoleItem)cnIssuerItem);
        }
    }

    static boolean updateKeystoreConfig(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, boolean checkRidefinisci, boolean hideSceltaArchivioFilePath, boolean addHiddenSubjectIssuer, boolean requiredValue, ConfigurazioneMultitenant configurazioneMultitenant, boolean rest) throws ProtocolException {
        return ModIDynamicConfigurationKeystoreUtilities.updateKeystoreConfig(consoleConfiguration, properties, checkRidefinisci, false, hideSceltaArchivioFilePath, addHiddenSubjectIssuer, requiredValue, configurazioneMultitenant, rest);
    }

    static boolean updateKeystoreConfig(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, boolean checkRidefinisci, boolean checkRidefinisciOauth, boolean hideSceltaArchivioFilePath, boolean addHiddenSubjectIssuer, boolean requiredValue, ConfigurazioneMultitenant configurazioneMultitenant, boolean rest) throws ProtocolException {
        AbstractConsoleItem keyPasswordItem;
        AbstractConsoleItem keyAliasItem;
        AbstractConsoleItem keystoreByokItem;
        AbstractConsoleItem keystorePasswordItem;
        BinaryProperty archiveItemValue;
        StringProperty pathItemItemValue;
        AbstractConsoleItem modeItem;
        boolean ridefinisci = true;
        if (checkRidefinisci) {
            if (checkRidefinisciOauth) {
                BooleanProperty booleanItemValue = (BooleanProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreCertMode");
                ridefinisci = booleanItemValue != null && booleanItemValue.getValue() != null && ((Boolean)booleanItemValue.getValue()).booleanValue();
            } else {
                StringProperty selectModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreCertMode");
                ridefinisci = selectModeItemValue == null ? false : "ridefinisci".equals(selectModeItemValue.getValue());
                BaseConsoleItem subTitleItem = ProtocolPropertiesUtils.getBaseConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaAPIImplKeyStoreSubTitleId");
                if (subTitleItem != null) {
                    if (ridefinisci) {
                        subTitleItem.setType(ConsoleItemType.SUBTITLE);
                    } else {
                        subTitleItem.setType(ConsoleItemType.HIDDEN);
                    }
                }
            }
        }
        if ((modeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeystoreMode")) != null) {
            if (ridefinisci && !hideSceltaArchivioFilePath) {
                modeItem.setType(ConsoleItemType.SELECT);
            } else {
                modeItem.setType(ConsoleItemType.HIDDEN);
            }
            ((StringConsoleItem)modeItem).addLabelValue("Archivio", (Object)"archive");
            ((StringConsoleItem)modeItem).addLabelValue("File System", (Object)"path");
            if (HSMUtils.existsTipologieKeystoreHSM((boolean)false, (boolean)false)) {
                ((StringConsoleItem)modeItem).addLabelValue("HSM", (Object)"hsm");
            }
        }
        StringProperty selectModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreMode");
        AbstractConsoleItem archiveItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeystoreArchive");
        AbstractConsoleItem pathItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeystorePath");
        AbstractConsoleItem certificateItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeystoreCertificate");
        boolean permitCertificate = false;
        boolean hsm = false;
        boolean archive = false;
        String modalita = "path";
        if (selectModeItemValue != null && selectModeItemValue.getValue() != null && !"".equals(selectModeItemValue.getValue())) {
            modalita = (String)selectModeItemValue.getValue();
        }
        if (ridefinisci) {
            if (selectModeItemValue != null && (selectModeItemValue.getValue() == null || "".equals(selectModeItemValue.getValue()))) {
                selectModeItemValue.setValue((Object)modalita);
            }
            if ("hsm".equals(modalita)) {
                StringProperty keystoreByokPolicyMODIItemValue;
                StringProperty keystorePasswordMODIItemValue;
                permitCertificate = true;
                hsm = true;
                archiveItem.setType(ConsoleItemType.HIDDEN);
                archiveItem.setRequired(false);
                BinaryProperty archiveItemValue2 = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreArchive");
                if (archiveItemValue2 != null) {
                    archiveItemValue2.setValue(null);
                    archiveItemValue2.setFileName(null);
                    archiveItemValue2.setClearContent(true);
                }
                pathItem.setType(ConsoleItemType.HIDDEN);
                pathItem.setRequired(false);
                StringProperty pathItemItemValue2 = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystorePath");
                if (pathItemItemValue2 != null) {
                    pathItemItemValue2.setValue(null);
                }
                if (configurazioneMultitenant != null && StatoFunzionalita.ABILITATO.equals((Object)configurazioneMultitenant.getStato()) && !PortaApplicativaSoggettiFruitori.SOGGETTI_ESTERNI.equals((Object)configurazioneMultitenant.getErogazioneSceltaSoggettiFruitori())) {
                    modeItem.setNote("<b>!!Attenzione!!</b> La modalit\u00e0 selezionata non consente un'identificazione dell'applicativo su API erogate da altri soggetti di dominio interno.<br/>Per consentire l'identificazione caricare il certificato associato alla chiave privata.");
                } else {
                    modeItem.setNote(null);
                }
                StringProperty keyPasswordMODIItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyPassword");
                if (keyPasswordMODIItemValue != null) {
                    keyPasswordMODIItemValue.setValue(null);
                }
                if ((keystorePasswordMODIItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystorePassword")) != null) {
                    keystorePasswordMODIItemValue.setValue(null);
                }
                if ((keystoreByokPolicyMODIItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreByokPolicy")) != null) {
                    keystoreByokPolicyMODIItemValue.setValue(null);
                }
            } else if ("archive".equals(modalita)) {
                archive = true;
                archiveItem.setType(ConsoleItemType.FILE);
                archiveItem.setRequired(requiredValue);
                if (addHiddenSubjectIssuer) {
                    ((BinaryConsoleItem)archiveItem).setReadOnly(true);
                }
                pathItem.setType(ConsoleItemType.HIDDEN);
                pathItem.setRequired(false);
                pathItemItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystorePath");
                if (pathItemItemValue != null) {
                    pathItemItemValue.setValue(null);
                }
                modeItem.setNote(null);
            } else {
                permitCertificate = true;
                StringProperty typeItemItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreType");
                if (typeItemItemValue != null && typeItemItemValue.getValue() != null && (ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_JWK.equals(typeItemItemValue.getValue()) || ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_KEY_PAIR.equals(typeItemItemValue.getValue()))) {
                    permitCertificate = false;
                }
                archiveItem.setType(ConsoleItemType.HIDDEN);
                archiveItem.setRequired(false);
                archiveItemValue = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreArchive");
                if (archiveItemValue != null) {
                    archiveItemValue.setValue(null);
                    archiveItemValue.setFileName(null);
                    archiveItemValue.setClearContent(true);
                }
                pathItem.setType(ConsoleItemType.TEXT_AREA);
                ((StringConsoleItem)pathItem).setRows(Integer.valueOf(3));
                pathItem.setRequired(requiredValue);
                if (configurazioneMultitenant != null && StatoFunzionalita.ABILITATO.equals((Object)configurazioneMultitenant.getStato()) && !PortaApplicativaSoggettiFruitori.SOGGETTI_ESTERNI.equals((Object)configurazioneMultitenant.getErogazioneSceltaSoggettiFruitori())) {
                    modeItem.setNote("<b>!!Attenzione!!</b> La modalit\u00e0 selezionata non consente un'identificazione dell'applicativo su API erogate da altri soggetti di dominio interno.<br/>Per consentire l'identificazione caricare il certificato associato alla chiave privata.");
                } else {
                    modeItem.setNote(null);
                }
            }
            if (certificateItem != null) {
                BinaryProperty certificateItemValue;
                if (addHiddenSubjectIssuer && permitCertificate) {
                    certificateItem.setType(ConsoleItemType.FILE);
                    certificateItem.setRequired(false);
                    ((BinaryConsoleItem)archiveItem).setReadOnly(true);
                    certificateItemValue = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreCertificate");
                    if (certificateItemValue != null && certificateItemValue.getValue() != null && ((byte[])certificateItemValue.getValue()).length > 0) {
                        modeItem.setNote(null);
                    }
                } else {
                    certificateItem.setType(ConsoleItemType.HIDDEN);
                    certificateItem.setRequired(false);
                    certificateItemValue = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreCertificate");
                    if (certificateItemValue != null) {
                        certificateItemValue.setValue(null);
                        certificateItemValue.setFileName(null);
                        certificateItemValue.setClearContent(true);
                    }
                }
            }
            if (addHiddenSubjectIssuer) {
                try {
                    CertificateInfo cert = ModIDynamicConfigurationKeystoreUtilities.readKeystoreConfig(properties, permitCertificate);
                    if (cert != null && cert.getSubject() != null) {
                        StringProperty subjectItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyCNSubject");
                        subjectItemValue.setValue((Object)cert.getSubject().toString());
                        StringProperty issuerItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyCNIssuer");
                        if (cert.getIssuer() != null) {
                            issuerItemValue.setValue((Object)cert.getIssuer().toString());
                        } else if (issuerItemValue != null) {
                            issuerItemValue.setValue(null);
                        }
                    }
                }
                catch (Exception cert) {}
            }
        } else {
            Object certificateItemValue;
            if (pathItem != null) {
                pathItem.setType(ConsoleItemType.HIDDEN);
                pathItem.setRequired(false);
            }
            if ((pathItemItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystorePath")) != null) {
                pathItemItemValue.setValue(null);
            }
            if (archiveItem != null) {
                archiveItem.setType(ConsoleItemType.HIDDEN);
                archiveItem.setRequired(false);
            }
            if ((archiveItemValue = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreArchive")) != null) {
                archiveItemValue.setValue(null);
                archiveItemValue.setFileName(null);
                archiveItemValue.setClearContent(true);
            }
            if (certificateItem != null) {
                certificateItem.setType(ConsoleItemType.HIDDEN);
                certificateItem.setRequired(false);
            }
            if ((certificateItemValue = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreCertificate")) != null) {
                certificateItemValue.setValue(null);
                certificateItemValue.setFileName(null);
                certificateItemValue.setClearContent(true);
            }
        }
        AbstractConsoleItem typeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeystoreType");
        ArrayList lHsmTypes = null;
        if (typeItem != null) {
            if (hsm) {
                lHsmTypes = new ArrayList();
                HSMUtils.fillTipologieKeystore((boolean)false, (boolean)false, lHsmTypes);
                if (lHsmTypes != null && !lHsmTypes.isEmpty()) {
                    for (String hsmType : lHsmTypes) {
                        ((StringConsoleItem)typeItem).addLabelValue(hsmType, (Object)hsmType);
                    }
                }
            } else {
                ((StringConsoleItem)typeItem).addLabelValue(ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_LABEL_JKS, (Object)ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS);
                ((StringConsoleItem)typeItem).addLabelValue(ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_LABEL_PKCS12, (Object)ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12);
                if ("path".equals(modalita) && rest) {
                    ((StringConsoleItem)typeItem).addLabelValue(ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_LABEL_JWK, (Object)ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_JWK);
                    ((StringConsoleItem)typeItem).addLabelValue(ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_LABEL_KEY_PAIR, (Object)ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_KEY_PAIR);
                }
            }
            if (ridefinisci) {
                typeItem.setType(ConsoleItemType.SELECT);
            } else {
                typeItem.setType(ConsoleItemType.HIDDEN);
            }
        }
        StringProperty typeItemItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreType");
        String keystoreType = null;
        boolean keystoreKeyPair = false;
        boolean keystoreJWK = false;
        boolean keystoreJks = false;
        boolean keystorePkcs12 = false;
        if (typeItemItemValue != null && typeItemItemValue.getValue() != null) {
            keystoreType = (String)typeItemItemValue.getValue();
            if (hsm && (lHsmTypes == null || !lHsmTypes.contains(keystoreType))) {
                keystoreType = null;
                typeItemItemValue.setValue(null);
            }
            keystoreKeyPair = ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_KEY_PAIR.equals(keystoreType);
            keystoreJWK = ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_JWK.equals(keystoreType);
            if ("archive".equals(modalita) && (keystoreKeyPair || keystoreJWK)) {
                keystoreKeyPair = false;
                keystoreJWK = false;
                keystoreType = ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_DEFAULT_VALUE;
                typeItemItemValue.setValue((Object)keystoreType);
            }
            if (keystoreType == null || "".equals(keystoreType)) {
                keystoreJks = ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS.equals(ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_DEFAULT_VALUE);
                keystorePkcs12 = ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12.equals(ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_DEFAULT_VALUE);
            } else {
                keystoreJks = ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS.equals(keystoreType);
                keystorePkcs12 = ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12.equals(keystoreType);
            }
        }
        AbstractConsoleItem pathPublicKeyItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeystorePathPublicKey");
        boolean pathPublicKeyRestoreDefaultValue = true;
        if (pathPublicKeyItem != null && ridefinisci && "path".equals(modalita) && keystoreKeyPair) {
            pathPublicKeyItem.setType(ConsoleItemType.TEXT_AREA);
            ((StringConsoleItem)pathPublicKeyItem).setRows(Integer.valueOf(3));
            pathPublicKeyItem.setRequired(true);
            pathPublicKeyRestoreDefaultValue = false;
            if (pathItem != null) {
                pathItem.setLabel("Chiave Privata");
            }
        }
        if (pathPublicKeyRestoreDefaultValue) {
            StringProperty pathPublicKeyItemItemValue;
            if (pathPublicKeyItem != null) {
                pathPublicKeyItem.setType(ConsoleItemType.HIDDEN);
                pathPublicKeyItem.setRequired(false);
            }
            if ((pathPublicKeyItemItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystorePathPublicKey")) != null) {
                pathPublicKeyItemItemValue.setValue(null);
            }
            if (pathItem != null) {
                pathItem.setLabel("Path");
            }
        }
        if ((keystorePasswordItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeystorePassword")) != null) {
            if (ridefinisci && !hsm && !keystoreKeyPair && !keystoreJWK) {
                keystorePasswordItem.setType(ConsoleItemType.LOCK);
                if (keystoreJks && !DBUtils.isKeystoreJksPasswordRequired() || keystorePkcs12 && !DBUtils.isKeystorePkcs12PasswordRequired()) {
                    keystorePasswordItem.setRequired(false);
                }
            } else {
                keystorePasswordItem.setType(ConsoleItemType.LOCK_HIDDEN);
                StringProperty keystorePasswordItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystorePassword");
                if (keystorePasswordItemValue != null) {
                    keystorePasswordItemValue.setValue(null);
                }
            }
        }
        if ((keystoreByokItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeystoreByokPolicy")) != null) {
            BYOKProvider byokProvider = null;
            try {
                byokProvider = BYOKProvider.getUnwrapInstance();
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            if (ridefinisci && !hsm && !archive && byokProvider.isByokEnabled()) {
                List ocspTypes = byokProvider.getValues();
                List ocspLabels = byokProvider.getLabels();
                for (int i = 0; i < ocspTypes.size(); ++i) {
                    String type = (String)ocspTypes.get(i);
                    String label = (String)ocspLabels.get(i);
                    ((StringConsoleItem)keystoreByokItem).addLabelValue(label, (Object)type);
                }
                keystoreByokItem.setType(ConsoleItemType.SELECT);
            } else {
                keystoreByokItem.setType(ConsoleItemType.HIDDEN);
                StringProperty keystoreByokPolicyItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreByokPolicy");
                if (keystoreByokPolicyItemValue != null) {
                    keystoreByokPolicyItemValue.setValue(null);
                }
            }
        }
        if ((keyAliasItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeyAlias")) != null) {
            if (ridefinisci && !keystoreKeyPair) {
                keyAliasItem.setType(ConsoleItemType.TEXT_EDIT);
            } else {
                keyAliasItem.setType(ConsoleItemType.HIDDEN);
                StringProperty keyAliasItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyAlias");
                if (keyAliasItemValue != null) {
                    keyAliasItemValue.setValue(null);
                }
            }
        }
        if ((keyPasswordItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeyPassword")) != null) {
            if (ridefinisci && (!hsm || HSMUtils.isHsmConfigurableKeyPassword()) && !keystoreJWK) {
                keyPasswordItem.setType(ConsoleItemType.LOCK);
                if (keystoreKeyPair || keystoreJks && !DBUtils.isKeystoreJksKeyPasswordRequired() || keystorePkcs12 && !DBUtils.isKeystorePkcs12KeyPasswordRequired()) {
                    keyPasswordItem.setRequired(false);
                }
            } else {
                keyPasswordItem.setType(ConsoleItemType.LOCK_HIDDEN);
                StringProperty keyPasswordItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyPassword");
                if (keyPasswordItemValue != null) {
                    keyPasswordItemValue.setValue(null);
                }
                keyPasswordItem.setRequired(requiredValue);
            }
        }
        StringProperty keyPairAlgorithmItemItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreKeyPairAlgo");
        if (keystoreKeyPair && keyPairAlgorithmItemItemValue != null && (keyPairAlgorithmItemItemValue.getValue() == null || StringUtils.isEmpty((String)((String)keyPairAlgorithmItemItemValue.getValue())))) {
            keyPairAlgorithmItemItemValue.setValue((Object)"RSA");
        }
        return ridefinisci;
    }

    public static CertificateInfo readKeystoreConfig(ProtocolProperties properties, boolean onlyCert) throws Exception {
        Certificate cert = null;
        StringProperty selectModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreMode");
        String modalita = "path";
        if (selectModeItemValue != null && selectModeItemValue.getValue() != null && !"".equals(selectModeItemValue.getValue())) {
            modalita = (String)selectModeItemValue.getValue();
        }
        if (onlyCert) {
            BinaryProperty certificateItemValue;
            if (!"archive".equals(modalita) && (certificateItemValue = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreCertificate")) != null && certificateItemValue.getValue() != null) {
                byte[] certificate = (byte[])certificateItemValue.getValue();
                cert = ArchiveLoader.load((byte[])certificate);
            }
        } else {
            StringProperty keystoreTypeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreType");
            StringProperty keystorePasswordItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystorePassword");
            StringProperty keystoreByokPolicyItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreByokPolicy");
            StringProperty keyAliasItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyAlias");
            StringProperty keyPasswordItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyPassword");
            if (keystoreTypeItemValue != null && keystorePasswordItemValue != null && keyAliasItemValue != null && keyPasswordItemValue != null) {
                String type = (String)keystoreTypeItemValue.getValue();
                ArchiveType archiveType = null;
                archiveType = ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS.equals(type) ? ArchiveType.JKS : ArchiveType.PKCS12;
                byte[] archive = null;
                if ("archive".equals(modalita)) {
                    BinaryProperty archiveItemValue = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreArchive");
                    if (archiveItemValue != null && archiveItemValue.getValue() != null) {
                        archive = (byte[])archiveItemValue.getValue();
                        cert = ArchiveLoader.load((ArchiveType)archiveType, (byte[])archive, (String)((String)keyAliasItemValue.getValue()), (String)((String)keystorePasswordItemValue.getValue()));
                    }
                } else if (keystoreByokPolicyItemValue != null) {
                    // empty if block
                }
                if (archive != null) {
                    KeyStore ks = KeystoreUtils.readKeystore(archive, (String)archiveType.name(), (String)((String)keystorePasswordItemValue.getValue()));
                    ks.getKey((String)keyAliasItemValue.getValue(), keyPasswordItemValue.getValue() != null ? ((String)keyPasswordItemValue.getValue()).toCharArray() : "".toCharArray());
                }
            }
        }
        if (cert != null) {
            return cert.getCertificate();
        }
        return null;
    }

    static void addDPoPKeystoreConfig(ConsoleConfiguration configuration, boolean requiredValue) throws ProtocolException {
        BaseConsoleItem subTitleItem = ProtocolPropertiesFactory.newSubTitleItem((String)"modipaDPoPSubtitleId", (String)"DPoP");
        subTitleItem.setType(ConsoleItemType.HIDDEN);
        configuration.addConsoleItem(subTitleItem);
        BooleanConsoleItem statoItem = (BooleanConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BOOLEAN, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaDPoPStato", (String)"Abilitato");
        statoItem.setDefaultValue((Object)false);
        statoItem.setReloadOnChange(true, true);
        configuration.addConsoleItem((BaseConsoleItem)statoItem);
        StringConsoleItem modeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaDPoPKeystoreMode", (String)"Modalit\u00e0");
        modeItem.setDefaultValue((Object)"path");
        modeItem.setReloadOnChange(true, true);
        configuration.addConsoleItem((BaseConsoleItem)modeItem);
        ModIDynamicConfigurationKeystoreUtilities.addDPoPKeystoreFields(configuration, requiredValue);
    }

    static void addDPoPKeystoreConfigFruizione(ConsoleConfiguration configuration, boolean requiredValue) throws ProtocolException {
        StringConsoleItem modeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaDPoPKeystoreMode", (String)"Modalit\u00e0");
        modeItem.setDefaultValue((Object)"path");
        modeItem.setReloadOnChange(true, true);
        configuration.addConsoleItem((BaseConsoleItem)modeItem);
        ModIDynamicConfigurationKeystoreUtilities.addDPoPKeystoreFields(configuration, requiredValue);
    }

    private static void addDPoPKeystoreFields(ConsoleConfiguration configuration, boolean requiredValue) throws ProtocolException {
        StringConsoleItem typeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaDPoPKeystoreType", (String)"Tipo");
        typeItem.setDefaultValue((Object)ModIConsoleCostanti.MODIPA_DPOP_KEYSTORE_TYPE_DEFAULT_VALUE);
        typeItem.setReloadOnChange(true, true);
        configuration.addConsoleItem((BaseConsoleItem)typeItem);
        AbstractConsoleItem archiveItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BINARY, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaDPoPKeystoreArchive", (String)"Archivio");
        ((BinaryConsoleItem)archiveItem).setShowContent(false);
        ((BinaryConsoleItem)archiveItem).setReadOnly(false);
        ((BinaryConsoleItem)archiveItem).setRequired(true);
        ((BinaryConsoleItem)archiveItem).setNoteUpdate("<b>Attenzione:</b> Se i parametri di accesso al nuovo archivio differiscono rispetto a quello precedentemente caricato, <BR/> devono essere aggiornati, ritornando alla pagina precente, prima di procedere con il caricamento del nuovo archivio.");
        ((BinaryConsoleItem)archiveItem).setLock(true);
        configuration.addConsoleItem((BaseConsoleItem)archiveItem);
        AbstractConsoleItem pathItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaDPoPKeystorePath", (String)"Path");
        configuration.addConsoleItem((BaseConsoleItem)pathItem);
        AbstractConsoleItem pathPublicKeyItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaDPoPKeystorePathPublicKey", (String)"Chiave Pubblica");
        configuration.addConsoleItem((BaseConsoleItem)pathPublicKeyItem);
        StringConsoleItem pathKeyAlgorithmItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaDPoPKeystoreKeyPairAlgo", (String)"");
        pathKeyAlgorithmItem.setDefaultValue((Object)"RSA");
        configuration.addConsoleItem((BaseConsoleItem)pathKeyAlgorithmItem);
        AbstractConsoleItem keystorePasswordItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.LOCK_HIDDEN, (String)"modipaDPoPKeystorePassword", (String)"Password");
        keystorePasswordItem.setRequired(requiredValue);
        configuration.addConsoleItem((BaseConsoleItem)keystorePasswordItem);
        AbstractConsoleItem keyAliasItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaDPoPKeyAlias", (String)"Alias Chiave Privata");
        keyAliasItem.setRequired(requiredValue);
        configuration.addConsoleItem((BaseConsoleItem)keyAliasItem);
        AbstractConsoleItem keyPasswordItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.LOCK_HIDDEN, (String)"modipaDPoPKeyPassword", (String)"Password Chiave Privata");
        keyPasswordItem.setRequired(requiredValue);
        configuration.addConsoleItem((BaseConsoleItem)keyPasswordItem);
        AbstractConsoleItem keystoreByokPolicyItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaDPoPKeystoreByokPolicy", (String)"BYOK Policy");
        keystoreByokPolicyItem.setRequired(false);
        configuration.addConsoleItem((BaseConsoleItem)keystoreByokPolicyItem);
    }

    static void updateDPoPKeystoreConfig(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, boolean dpopAbilitato, boolean requiredValue, boolean rest) throws ProtocolException {
        AbstractConsoleItem keyPasswordItem;
        AbstractConsoleItem keyAliasItem;
        AbstractConsoleItem keystoreByokItem;
        AbstractConsoleItem keystorePasswordItem;
        StringProperty pathItemItemValue;
        AbstractConsoleItem modeItem;
        AbstractConsoleItem statoItem;
        BaseConsoleItem subTitleItem = ProtocolPropertiesUtils.getBaseConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaDPoPSubtitleId");
        if (subTitleItem != null) {
            subTitleItem.setType(ConsoleItemType.SUBTITLE);
        }
        if ((statoItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaDPoPStato")) != null) {
            statoItem.setType(ConsoleItemType.CHECKBOX);
        }
        if ((modeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaDPoPKeystoreMode")) != null) {
            if (dpopAbilitato) {
                modeItem.setType(ConsoleItemType.SELECT);
            } else {
                modeItem.setType(ConsoleItemType.HIDDEN);
            }
            ((StringConsoleItem)modeItem).addLabelValue("Archivio", (Object)"archive");
            ((StringConsoleItem)modeItem).addLabelValue("File System", (Object)"path");
            if (HSMUtils.existsTipologieKeystoreHSM((boolean)false, (boolean)false)) {
                ((StringConsoleItem)modeItem).addLabelValue("HSM", (Object)"hsm");
            }
        }
        StringProperty selectModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystoreMode");
        AbstractConsoleItem archiveItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaDPoPKeystoreArchive");
        AbstractConsoleItem pathItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaDPoPKeystorePath");
        boolean hsm = false;
        boolean archive = false;
        String modalita = "path";
        if (selectModeItemValue != null && selectModeItemValue.getValue() != null && !"".equals(selectModeItemValue.getValue())) {
            modalita = (String)selectModeItemValue.getValue();
        }
        if (dpopAbilitato) {
            BinaryProperty archiveItemValue;
            if (selectModeItemValue != null && (selectModeItemValue.getValue() == null || "".equals(selectModeItemValue.getValue()))) {
                selectModeItemValue.setValue((Object)modalita);
            }
            if ("hsm".equals(modalita)) {
                StringProperty keystoreByokPolicyItemValue;
                StringProperty keystorePasswordItemValue;
                Object keyPasswordItemValue;
                hsm = true;
                archiveItem.setType(ConsoleItemType.HIDDEN);
                archiveItem.setRequired(false);
                archiveItemValue = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystoreArchive");
                if (archiveItemValue != null) {
                    archiveItemValue.setValue(null);
                    archiveItemValue.setFileName(null);
                    archiveItemValue.setClearContent(true);
                }
                pathItem.setType(ConsoleItemType.HIDDEN);
                pathItem.setRequired(false);
                StringProperty pathItemItemValue2 = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystorePath");
                if (pathItemItemValue2 != null) {
                    pathItemItemValue2.setValue(null);
                }
                if ((keyPasswordItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeyPassword")) != null) {
                    keyPasswordItemValue.setValue(null);
                }
                if ((keystorePasswordItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystorePassword")) != null) {
                    keystorePasswordItemValue.setValue(null);
                }
                if ((keystoreByokPolicyItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystoreByokPolicy")) != null) {
                    keystoreByokPolicyItemValue.setValue(null);
                }
            } else if ("archive".equals(modalita)) {
                archive = true;
                archiveItem.setType(ConsoleItemType.FILE);
                archiveItem.setRequired(requiredValue);
                pathItem.setType(ConsoleItemType.HIDDEN);
                pathItem.setRequired(false);
                pathItemItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystorePath");
                if (pathItemItemValue != null) {
                    pathItemItemValue.setValue(null);
                }
            } else {
                archiveItem.setType(ConsoleItemType.HIDDEN);
                archiveItem.setRequired(false);
                archiveItemValue = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystoreArchive");
                if (archiveItemValue != null) {
                    archiveItemValue.setValue(null);
                    archiveItemValue.setFileName(null);
                    archiveItemValue.setClearContent(true);
                }
                pathItem.setType(ConsoleItemType.TEXT_AREA);
                ((StringConsoleItem)pathItem).setRows(Integer.valueOf(3));
                pathItem.setRequired(requiredValue);
            }
        } else {
            BinaryProperty archiveItemValue;
            if (pathItem != null) {
                pathItem.setType(ConsoleItemType.HIDDEN);
                pathItem.setRequired(false);
            }
            if ((pathItemItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystorePath")) != null) {
                pathItemItemValue.setValue(null);
            }
            if (archiveItem != null) {
                archiveItem.setType(ConsoleItemType.HIDDEN);
                archiveItem.setRequired(false);
            }
            if ((archiveItemValue = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystoreArchive")) != null) {
                archiveItemValue.setValue(null);
                archiveItemValue.setFileName(null);
                archiveItemValue.setClearContent(true);
            }
        }
        AbstractConsoleItem typeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaDPoPKeystoreType");
        ArrayList lHsmTypes = null;
        if (typeItem != null) {
            if (hsm) {
                lHsmTypes = new ArrayList();
                HSMUtils.fillTipologieKeystore((boolean)false, (boolean)false, lHsmTypes);
                if (lHsmTypes != null && !lHsmTypes.isEmpty()) {
                    for (String hsmType : lHsmTypes) {
                        ((StringConsoleItem)typeItem).addLabelValue(hsmType, (Object)hsmType);
                    }
                }
            } else {
                ((StringConsoleItem)typeItem).addLabelValue(ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_LABEL_JKS, (Object)ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS);
                ((StringConsoleItem)typeItem).addLabelValue(ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_LABEL_PKCS12, (Object)ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12);
                if ("path".equals(modalita) && rest) {
                    ((StringConsoleItem)typeItem).addLabelValue(ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_LABEL_JWK, (Object)ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_JWK);
                    ((StringConsoleItem)typeItem).addLabelValue(ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_LABEL_KEY_PAIR, (Object)ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_KEY_PAIR);
                }
            }
            if (dpopAbilitato) {
                typeItem.setType(ConsoleItemType.SELECT);
            } else {
                typeItem.setType(ConsoleItemType.HIDDEN);
            }
        }
        StringProperty typeItemItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystoreType");
        String keystoreType = null;
        boolean keystoreKeyPair = false;
        boolean keystoreJWK = false;
        boolean keystoreJks = false;
        boolean keystorePkcs12 = false;
        if (typeItemItemValue != null && typeItemItemValue.getValue() != null) {
            keystoreType = (String)typeItemItemValue.getValue();
            if (hsm && (lHsmTypes == null || !lHsmTypes.contains(keystoreType))) {
                keystoreType = null;
                typeItemItemValue.setValue(null);
            }
            keystoreKeyPair = ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_KEY_PAIR.equals(keystoreType);
            keystoreJWK = ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_JWK.equals(keystoreType);
            if ("archive".equals(modalita) && (keystoreKeyPair || keystoreJWK)) {
                keystoreKeyPair = false;
                keystoreJWK = false;
                keystoreType = ModIConsoleCostanti.MODIPA_DPOP_KEYSTORE_TYPE_DEFAULT_VALUE;
                typeItemItemValue.setValue((Object)keystoreType);
            }
            if (keystoreType == null || "".equals(keystoreType)) {
                keystoreJks = ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS.equals(ModIConsoleCostanti.MODIPA_DPOP_KEYSTORE_TYPE_DEFAULT_VALUE);
                keystorePkcs12 = ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12.equals(ModIConsoleCostanti.MODIPA_DPOP_KEYSTORE_TYPE_DEFAULT_VALUE);
            } else {
                keystoreJks = ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS.equals(keystoreType);
                keystorePkcs12 = ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12.equals(keystoreType);
            }
        }
        AbstractConsoleItem pathPublicKeyItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaDPoPKeystorePathPublicKey");
        boolean pathPublicKeyRestoreDefaultValue = true;
        if (pathPublicKeyItem != null && dpopAbilitato && "path".equals(modalita) && keystoreKeyPair) {
            pathPublicKeyItem.setType(ConsoleItemType.TEXT_AREA);
            ((StringConsoleItem)pathPublicKeyItem).setRows(Integer.valueOf(3));
            pathPublicKeyItem.setRequired(true);
            pathPublicKeyRestoreDefaultValue = false;
            if (pathItem != null) {
                pathItem.setLabel("Chiave Privata");
            }
        }
        if (pathPublicKeyRestoreDefaultValue) {
            StringProperty pathPublicKeyItemItemValue;
            if (pathPublicKeyItem != null) {
                pathPublicKeyItem.setType(ConsoleItemType.HIDDEN);
                pathPublicKeyItem.setRequired(false);
            }
            if ((pathPublicKeyItemItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystorePathPublicKey")) != null) {
                pathPublicKeyItemItemValue.setValue(null);
            }
            if (pathItem != null) {
                pathItem.setLabel("Path");
            }
        }
        if ((keystorePasswordItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaDPoPKeystorePassword")) != null) {
            if (dpopAbilitato && !hsm && !keystoreKeyPair && !keystoreJWK) {
                keystorePasswordItem.setType(ConsoleItemType.LOCK);
                if (keystoreJks && !DBUtils.isKeystoreJksPasswordRequired() || keystorePkcs12 && !DBUtils.isKeystorePkcs12PasswordRequired()) {
                    keystorePasswordItem.setRequired(false);
                }
            } else {
                keystorePasswordItem.setType(ConsoleItemType.LOCK_HIDDEN);
                StringProperty keystorePasswordItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystorePassword");
                if (keystorePasswordItemValue != null) {
                    keystorePasswordItemValue.setValue(null);
                }
            }
        }
        if ((keystoreByokItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaDPoPKeystoreByokPolicy")) != null) {
            BYOKProvider byokProvider = null;
            try {
                byokProvider = BYOKProvider.getUnwrapInstance();
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            if (dpopAbilitato && !hsm && !archive && byokProvider.isByokEnabled()) {
                List ocspTypes = byokProvider.getValues();
                List ocspLabels = byokProvider.getLabels();
                for (int i = 0; i < ocspTypes.size(); ++i) {
                    String type = (String)ocspTypes.get(i);
                    String label = (String)ocspLabels.get(i);
                    ((StringConsoleItem)keystoreByokItem).addLabelValue(label, (Object)type);
                }
                keystoreByokItem.setType(ConsoleItemType.SELECT);
            } else {
                keystoreByokItem.setType(ConsoleItemType.HIDDEN);
                StringProperty keystoreByokPolicyItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystoreByokPolicy");
                if (keystoreByokPolicyItemValue != null) {
                    keystoreByokPolicyItemValue.setValue(null);
                }
            }
        }
        if ((keyAliasItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaDPoPKeyAlias")) != null) {
            if (dpopAbilitato && !keystoreKeyPair) {
                keyAliasItem.setType(ConsoleItemType.TEXT_EDIT);
            } else {
                keyAliasItem.setType(ConsoleItemType.HIDDEN);
                StringProperty keyAliasItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeyAlias");
                if (keyAliasItemValue != null) {
                    keyAliasItemValue.setValue(null);
                }
            }
        }
        if ((keyPasswordItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaDPoPKeyPassword")) != null) {
            if (dpopAbilitato && (!hsm || HSMUtils.isHsmConfigurableKeyPassword()) && !keystoreJWK) {
                keyPasswordItem.setType(ConsoleItemType.LOCK);
                if (keystoreKeyPair || keystoreJks && !DBUtils.isKeystoreJksKeyPasswordRequired() || keystorePkcs12 && !DBUtils.isKeystorePkcs12KeyPasswordRequired()) {
                    keyPasswordItem.setRequired(false);
                }
            } else {
                keyPasswordItem.setType(ConsoleItemType.LOCK_HIDDEN);
                StringProperty keyPasswordItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeyPassword");
                if (keyPasswordItemValue != null) {
                    keyPasswordItemValue.setValue(null);
                }
                keyPasswordItem.setRequired(requiredValue);
            }
        }
        StringProperty keyPairAlgorithmItemItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystoreKeyPairAlgo");
        if (keystoreKeyPair && keyPairAlgorithmItemItemValue != null && (keyPairAlgorithmItemItemValue.getValue() == null || StringUtils.isEmpty((String)((String)keyPairAlgorithmItemItemValue.getValue())))) {
            keyPairAlgorithmItemItemValue.setValue((Object)"RSA");
        }
    }

    static void hideDPoPKeystoreConfig(ConsoleConfiguration configuration, ProtocolProperties properties) throws ProtocolException {
        StringProperty keystoreByokPolicyItemValue;
        AbstractConsoleItem keystoreByokItem;
        StringProperty keyPasswordItemValue;
        AbstractConsoleItem keyPasswordItem;
        StringProperty keyAliasItemValue;
        AbstractConsoleItem keyAliasItem;
        StringProperty keystorePasswordItemValue;
        AbstractConsoleItem keystorePasswordItem;
        StringProperty pathPublicKeyItemValue;
        AbstractConsoleItem pathPublicKeyItem;
        StringProperty pathItemValue;
        AbstractConsoleItem pathItem;
        BinaryProperty archiveItemValue;
        AbstractConsoleItem archiveItem;
        StringProperty typeItemValue;
        AbstractConsoleItem typeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)configuration.getConsoleItem(), (String)"modipaDPoPKeystoreType");
        if (typeItem != null) {
            typeItem.setType(ConsoleItemType.HIDDEN);
        }
        if ((typeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystoreType")) != null) {
            typeItemValue.setValue(null);
        }
        if ((archiveItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)configuration.getConsoleItem(), (String)"modipaDPoPKeystoreArchive")) != null) {
            archiveItem.setType(ConsoleItemType.HIDDEN);
            archiveItem.setRequired(false);
        }
        if ((archiveItemValue = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystoreArchive")) != null) {
            archiveItemValue.setValue(null);
            archiveItemValue.setFileName(null);
            archiveItemValue.setClearContent(true);
        }
        if ((pathItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)configuration.getConsoleItem(), (String)"modipaDPoPKeystorePath")) != null) {
            pathItem.setType(ConsoleItemType.HIDDEN);
            pathItem.setRequired(false);
        }
        if ((pathItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystorePath")) != null) {
            pathItemValue.setValue(null);
        }
        if ((pathPublicKeyItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)configuration.getConsoleItem(), (String)"modipaDPoPKeystorePathPublicKey")) != null) {
            pathPublicKeyItem.setType(ConsoleItemType.HIDDEN);
            pathPublicKeyItem.setRequired(false);
        }
        if ((pathPublicKeyItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystorePathPublicKey")) != null) {
            pathPublicKeyItemValue.setValue(null);
        }
        if ((keystorePasswordItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)configuration.getConsoleItem(), (String)"modipaDPoPKeystorePassword")) != null) {
            keystorePasswordItem.setType(ConsoleItemType.LOCK_HIDDEN);
        }
        if ((keystorePasswordItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystorePassword")) != null) {
            keystorePasswordItemValue.setValue(null);
        }
        if ((keyAliasItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)configuration.getConsoleItem(), (String)"modipaDPoPKeyAlias")) != null) {
            keyAliasItem.setType(ConsoleItemType.HIDDEN);
        }
        if ((keyAliasItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeyAlias")) != null) {
            keyAliasItemValue.setValue(null);
        }
        if ((keyPasswordItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)configuration.getConsoleItem(), (String)"modipaDPoPKeyPassword")) != null) {
            keyPasswordItem.setType(ConsoleItemType.LOCK_HIDDEN);
        }
        if ((keyPasswordItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeyPassword")) != null) {
            keyPasswordItemValue.setValue(null);
        }
        if ((keystoreByokItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)configuration.getConsoleItem(), (String)"modipaDPoPKeystoreByokPolicy")) != null) {
            keystoreByokItem.setType(ConsoleItemType.HIDDEN);
        }
        if ((keystoreByokPolicyItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaDPoPKeystoreByokPolicy")) != null) {
            keystoreByokPolicyItemValue.setValue(null);
        }
    }

    static void addTrustStoreSSLConfigChoice(ConsoleConfiguration configuration, boolean x5u) throws ProtocolException {
        ModIDynamicConfigurationKeystoreUtilities.addTrustStoreConfigChoice(configuration, true, false, false, false, false, false, x5u);
    }

    static void addTrustStoreCertificatiConfigChoice(ConsoleConfiguration configuration, boolean x5u) throws ProtocolException {
        ModIDynamicConfigurationKeystoreUtilities.addTrustStoreConfigChoice(configuration, false, true, false, false, false, false, x5u);
    }

    static void addTrustStoreKeystoreErogazioneConfigChoice(ConsoleConfiguration configuration) throws ProtocolException {
        ModIDynamicConfigurationKeystoreUtilities.addTrustStoreConfigChoice(configuration, false, false, true, false, false, false, false);
    }

    static void addTrustStoreKeystoreFruizioneConfigChoice(ConsoleConfiguration configuration, boolean tokenNonLocale) throws ProtocolException {
        ModIDynamicConfigurationKeystoreUtilities.addTrustStoreConfigChoice(configuration, false, false, false, true, tokenNonLocale, false, false);
    }

    static void addTrustStoreKeystoreFruizioneOAuthConfigChoice(ConsoleConfiguration configuration) throws ProtocolException {
        ModIDynamicConfigurationKeystoreUtilities.addTrustStoreConfigChoice(configuration, false, false, false, false, false, true, false);
    }

    private static void addTrustStoreConfigChoice(ConsoleConfiguration configuration, boolean ssl, boolean truststore, boolean keystoreErogazione, boolean keystoreFruizione, boolean tokenNonLocale, boolean keystoreFruizioneOauthNoSicurezzaMessaggio, boolean x5u) throws ProtocolException {
        if (keystoreErogazione) {
            // empty if block
        }
        if (keystoreFruizione) {
            StringConsoleItem modeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaKeystoreFruizioneMode", (String)"KeyStore");
            modeItem.addLabelValue("Definito nell'applicativo", (Object)"applicativo");
            modeItem.addLabelValue("Definito nella fruizione", (Object)"fruizione");
            if (tokenNonLocale) {
                modeItem.addLabelValue("Definito nella token policy", (Object)"token");
            }
            modeItem.setDefaultValue((Object)"applicativo");
            modeItem.setReloadOnChange(true, true);
            configuration.addConsoleItem((BaseConsoleItem)modeItem);
        }
        if (keystoreFruizioneOauthNoSicurezzaMessaggio) {
            // empty if block
        }
        String id = null;
        id = ssl ? "modipaSslTruststoreMode" : (truststore ? "modipaTruststoreMode" : "modipaKeystoreCertMode");
        String label = null;
        label = ssl ? "TrustStore SSL" : (truststore ? "TrustStore Certificati" : (keystoreFruizione ? "" : "KeyStore"));
        StringConsoleItem modeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)id, (String)label);
        if (keystoreFruizioneOauthNoSicurezzaMessaggio) {
            modeItem.addLabelValue("-", (Object)"-");
        }
        modeItem.addLabelValue("Default", (Object)"default");
        modeItem.addLabelValue("Ridefinito", (Object)"ridefinisci");
        if (keystoreFruizioneOauthNoSicurezzaMessaggio) {
            modeItem.setDefaultValue((Object)"-");
        } else {
            modeItem.setDefaultValue((Object)"default");
        }
        modeItem.setReloadOnChange(true, true);
        if (ssl && !x5u || keystoreFruizione) {
            modeItem.setType(ConsoleItemType.HIDDEN);
        }
        configuration.addConsoleItem((BaseConsoleItem)modeItem);
    }

    public static void addKeStoreConfigOAuthChoice(ConsoleConfiguration configuration) throws ProtocolException {
        String id = "modipaKeystoreCertMode";
        String label = "KeyStore";
        BooleanConsoleItem booleanConsoleItem = (BooleanConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BOOLEAN, (ConsoleItemType)ConsoleItemType.CHECKBOX, (String)id, (String)label);
        booleanConsoleItem.setDefaultValue((Object)false);
        booleanConsoleItem.setReloadOnChange(true, true);
        configuration.addConsoleItem((BaseConsoleItem)booleanConsoleItem);
    }

    static void addTrustStoreConfigSubSection(ConsoleConfiguration configuration, boolean ssl, boolean x5u) throws ProtocolException {
        BaseConsoleItem subTitleItem;
        if (x5u) {
            // empty if block
        }
        if ((subTitleItem = ProtocolPropertiesFactory.newSubTitleItem((String)(ssl ? "modipaAPIImplTrustStoreSslSubTitleId" : "modipaAPIImplTrustStoreCertsSubTitleId"), (String)(ssl ? "TrustStore SSL" : "TrustStore Certificati"))) != null) {
            subTitleItem.setType(ConsoleItemType.HIDDEN);
            configuration.addConsoleItem(subTitleItem);
        }
        StringConsoleItem typeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)(ssl ? "modipaSslTruststoreType" : "modipaTruststoreType"), (String)(ssl ? "Tipo" : "Tipo"));
        typeItem.setDefaultValue((Object)(ssl ? ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SSL_TRUSTSTORE_TYPE_VALUE_JKS : ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JKS));
        configuration.addConsoleItem((BaseConsoleItem)typeItem);
        AbstractConsoleItem pathItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)(ssl ? "modipaSslTruststorePath" : "modipaTruststorePath"), (String)(ssl ? "Path" : "Path"));
        configuration.addConsoleItem((BaseConsoleItem)pathItem);
        StringConsoleItem passwordItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.LOCK_HIDDEN, (String)(ssl ? "modipaSslTruststorePassword" : "modipaTruststorePassword"), (String)(ssl ? "Password" : "Password"));
        configuration.addConsoleItem((BaseConsoleItem)passwordItem);
        StringConsoleItem ocspPolicyItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)(ssl ? "modipaSslTruststoreOCSP" : "modipaTruststoreOCSP"), (String)(ssl ? "OCSP Policy" : "OCSP Policy"));
        ocspPolicyItem.setRequired(false);
        configuration.addConsoleItem((BaseConsoleItem)ocspPolicyItem);
        StringConsoleItem crlsItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)(ssl ? "modipaSslTruststoreCRLs" : "modipaTruststoreCRLs"), (String)(ssl ? "CRL File(s)" : "CRL File(s)"));
        crlsItem.setRequired(false);
        crlsItem.setRows(Integer.valueOf(2));
        crlsItem.setNote(ssl ? "Elencare pi\u00f9 file separandoli con la ','" : "Elencare pi\u00f9 file separandoli con la ','");
        configuration.addConsoleItem((BaseConsoleItem)crlsItem);
    }

    static void updateTrustConfig(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, boolean ssl, boolean x5u, boolean requiredValue, boolean addTrustStoreTypesChiaviPubbliche, List<RemoteStoreConfig> remoteStoreConfig) throws ProtocolException {
        StringProperty ocspItemValue;
        if (ssl) {
            StringConsoleItem modeItem = (StringConsoleItem)ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSslTruststoreMode");
            if (x5u) {
                modeItem.setType(ConsoleItemType.SELECT);
                modeItem.addLabelValue("Default", (Object)"default");
                modeItem.addLabelValue("Ridefinito", (Object)"ridefinisci");
            } else {
                modeItem.setType(ConsoleItemType.HIDDEN);
            }
        }
        StringProperty selectModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)(ssl ? "modipaSslTruststoreMode" : "modipaTruststoreMode"));
        boolean ridefinisci = selectModeItemValue != null && "ridefinisci".equals(selectModeItemValue.getValue());
        BaseConsoleItem subTitleItem = ProtocolPropertiesUtils.getBaseConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)(ssl ? "modipaAPIImplTrustStoreSslSubTitleId" : "modipaAPIImplTrustStoreCertsSubTitleId"));
        if (subTitleItem != null) {
            subTitleItem.setType(ridefinisci ? ConsoleItemType.SUBTITLE : ConsoleItemType.HIDDEN);
        }
        boolean hsm = false;
        boolean remoteStore = false;
        boolean jwk = false;
        boolean jks = false;
        AbstractConsoleItem typeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)(ssl ? "modipaSslTruststoreType" : "modipaTruststoreType"));
        typeItem.setType(ridefinisci ? ConsoleItemType.SELECT : ConsoleItemType.HIDDEN);
        if (ridefinisci) {
            boolean reloadOnChange = false;
            if (ssl) {
                ((StringConsoleItem)typeItem).addLabelValue(ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SSL_TRUSTSTORE_TYPE_LABEL_JKS, (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SSL_TRUSTSTORE_TYPE_VALUE_JKS);
            } else {
                ((StringConsoleItem)typeItem).addLabelValue(ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_LABEL_JKS, (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JKS);
                if (addTrustStoreTypesChiaviPubbliche) {
                    ((StringConsoleItem)typeItem).addLabelValue(ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_LABEL_JWK, (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JWK);
                    reloadOnChange = true;
                }
                if (remoteStoreConfig != null && !remoteStoreConfig.isEmpty()) {
                    for (RemoteStoreConfig remoteStoreConfig2 : remoteStoreConfig) {
                        ((StringConsoleItem)typeItem).addLabelValue(remoteStoreConfig2.getStoreLabel(), (Object)remoteStoreConfig2.getStoreName());
                        reloadOnChange = true;
                    }
                }
            }
            if (HSMUtils.existsTipologieKeystoreHSM((boolean)true, (boolean)false)) {
                ArrayList l = new ArrayList();
                HSMUtils.fillTipologieKeystore((boolean)true, (boolean)false, l);
                if (l != null && !l.isEmpty()) {
                    typeItem.setReloadOnChange(true, true);
                    for (String hsmType : l) {
                        ((StringConsoleItem)typeItem).addLabelValue(hsmType, (Object)hsmType);
                    }
                }
            } else {
                typeItem.setReloadOnChange(reloadOnChange, true);
            }
            StringProperty typeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)(ssl ? "modipaSslTruststoreType" : "modipaTruststoreType"));
            if (typeItemValue != null && typeItemValue.getValue() != null && !(hsm = HSMUtils.isKeystoreHSM((String)((String)typeItemValue.getValue())))) {
                jwk = ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JWK.equals(typeItemValue.getValue());
                jks = ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JKS.equals(typeItemValue.getValue());
                if (!jwk && remoteStoreConfig != null && !remoteStoreConfig.isEmpty()) {
                    for (RemoteStoreConfig rsc : remoteStoreConfig) {
                        if (!((String)typeItemValue.getValue()).equals(rsc.getStoreName())) continue;
                        remoteStore = true;
                    }
                }
            }
        }
        String pathId = ssl ? "modipaSslTruststorePath" : "modipaTruststorePath";
        boolean path = ridefinisci && !hsm && !remoteStore;
        AbstractConsoleItem abstractConsoleItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)pathId);
        abstractConsoleItem.setType(path ? ConsoleItemType.TEXT_AREA : ConsoleItemType.HIDDEN);
        ((StringConsoleItem)abstractConsoleItem).setRows(Integer.valueOf(3));
        if (path) {
            abstractConsoleItem.setRequired(requiredValue);
        } else {
            abstractConsoleItem.setRequired(false);
        }
        StringProperty pathItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)pathId);
        if (pathItemValue != null && !path) {
            pathItemValue.setValue(null);
        }
        String passwordId = ssl ? "modipaSslTruststorePassword" : "modipaTruststorePassword";
        boolean password = ridefinisci && !hsm && !jwk && !remoteStore;
        AbstractConsoleItem passwordItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)passwordId);
        passwordItem.setType(password ? ConsoleItemType.LOCK : ConsoleItemType.LOCK_HIDDEN);
        if (password) {
            if (jks && !DBUtils.isTruststoreJksPasswordRequired()) {
                passwordItem.setRequired(false);
            } else {
                passwordItem.setRequired(requiredValue);
            }
        } else {
            passwordItem.setRequired(false);
        }
        StringProperty passwordItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)passwordId);
        if (passwordItemValue != null && !password) {
            passwordItemValue.setValue(null);
        }
        String ocspId = ssl ? "modipaSslTruststoreOCSP" : "modipaTruststoreOCSP";
        AbstractConsoleItem ocspItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)ocspId);
        OCSPProvider ocspProvider = new OCSPProvider();
        boolean ocsp = ridefinisci && !jwk && !remoteStore && ocspProvider.isOcspEnabled();
        ocspItem.setType(ocsp ? ConsoleItemType.SELECT : ConsoleItemType.HIDDEN);
        if (ocsp) {
            List ocspTypes = ocspProvider.getValues();
            List ocspLabels = ocspProvider.getLabels();
            for (int i = 0; i < ocspTypes.size(); ++i) {
                String type = (String)ocspTypes.get(i);
                String label = (String)ocspLabels.get(i);
                ((StringConsoleItem)ocspItem).addLabelValue(label, (Object)type);
            }
        }
        if ((ocspItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)ocspId)) != null && !ocsp) {
            ocspItemValue.setValue(null);
        }
        String crlId = ssl ? "modipaSslTruststoreCRLs" : "modipaTruststoreCRLs";
        AbstractConsoleItem crlsItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)crlId);
        boolean crl = ridefinisci && !jwk && !remoteStore;
        crlsItem.setType(crl ? ConsoleItemType.TEXT_AREA : ConsoleItemType.HIDDEN);
        StringProperty crlsItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)crlId);
        if (crlsItemValue != null && !crl) {
            crlsItemValue.setValue(null);
        }
    }
}

