/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.beans;

import java.util.Date;
import org.openspcoop2.generic_project.beans.CustomField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class UnixTimestampIntervalField
extends CustomField {
    private static int counter = 0;
    private String alias = null;

    public UnixTimestampIntervalField(String fieldName, ISQLFieldConverter fieldConverter, boolean appendTablePrefix, IField maxInterval, IField minInterval) throws ExpressionException, SQLQueryObjectException {
        super(fieldName, Long.class, UnixTimestampIntervalField.buildFunction(fieldConverter, appendTablePrefix, maxInterval, minInterval), fieldName, "", "");
    }

    private static String buildFunction(ISQLFieldConverter fieldConverter, boolean appendTablePrefix, IField maxInterval, IField minInterval) throws ExpressionException, SQLQueryObjectException {
        String maxClassName;
        if (maxInterval == null) {
            throw new ExpressionException("MaxInterval is null");
        }
        if (minInterval == null) {
            throw new ExpressionException("MinInterval is null");
        }
        String dateClassName = Date.class.getName();
        if (!dateClassName.equals(maxClassName = maxInterval.getFieldType().getName())) {
            throw new ExpressionException("MaxInterval with wrong type, expected:" + Date.class.getName() + " found:" + maxInterval.getFieldType());
        }
        String minClassName = minInterval.getFieldType().getName();
        if (!dateClassName.equals(minClassName)) {
            throw new ExpressionException("MinInterval with wrong type, expected:" + Date.class.getName() + " found:" + minInterval.getFieldType());
        }
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((TipiDatabase)fieldConverter.getDatabaseType());
        return sqlQueryObject.getDiffUnixTimestamp(fieldConverter.toColumn(maxInterval, appendTablePrefix), fieldConverter.toColumn(minInterval, appendTablePrefix));
    }

    private static synchronized int getNextCounter() {
        if (++counter > 1000) {
            counter = 0;
        }
        return counter;
    }

    public boolean existsAlias() {
        return this.alias != null;
    }

    public String getAlias() {
        return this.alias;
    }

    public synchronized void buildAlias() {
        if (this.alias == null) {
            this.alias = "TS" + UnixTimestampIntervalField.getNextCounter();
        }
    }
}

