/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.dao.jdbc.utils;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.openspcoop2.generic_project.beans.IEnumeration;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCAdapterException;
import org.openspcoop2.utils.jdbc.JDBCParameterUtilities;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class GenericJDBCParameterUtilities
extends JDBCParameterUtilities {
    public GenericJDBCParameterUtilities(TipiDatabase tipoDatabaseOpenSPCoop2) throws SQLQueryObjectException, JDBCAdapterException {
        super(tipoDatabaseOpenSPCoop2);
    }

    public void setParameters(PreparedStatement pstmt, JDBCObject ... params) throws SQLException, JDBCAdapterException, UtilsException {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                this.setParameter(pstmt, i + 1, params[i]);
            }
        }
    }

    public void setParameter(PreparedStatement pstmt, int index, JDBCObject param) throws SQLException, JDBCAdapterException, UtilsException {
        Object value = param.getObject();
        Class<?> type = param.getTypeObject();
        if (value != null && value instanceof IEnumeration) {
            IEnumeration enumObject = (IEnumeration)value;
            Object valueEnum = enumObject.getValue();
            Class<?> cValueEnum = null;
            if (valueEnum != null) {
                cValueEnum = valueEnum.getClass();
            }
            JDBCObject jdbcObject = new JDBCObject(valueEnum, cValueEnum);
            this.setParameter(pstmt, index, jdbcObject);
        } else {
            super.setParameter(pstmt, index, value, type);
        }
    }
}

