/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.formatter;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.formatter.ITypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.TimestampTypeFormatter;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.date.DateUtils;

public class CalendarTypeFormatter
implements ITypeFormatter<Calendar> {
    private SimpleDateFormat dateformat = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    public String toString(Calendar o) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        return this.dateformat.format(o.getTime());
    }

    @Override
    public String toSQLString(Calendar o) throws ExpressionException {
        return this.toSQLString(o, TipiDatabase.DEFAULT);
    }

    @Override
    public String toSQLString(Calendar o, TipiDatabase databaseType) throws ExpressionException {
        return TimestampTypeFormatter.toSQLString(o, o.getTime(), databaseType, this);
    }

    @Override
    public Calendar toObject(String o, Class<?> c) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.dateformat.parse(o));
            return calendar;
        }
        catch (Exception e) {
            throw new ExpressionException("Conversion failure: " + e.getMessage(), e);
        }
    }

    @Override
    public Class<Calendar> getTypeSupported() {
        return Calendar.class;
    }
}

