/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.formatter;

import java.lang.reflect.Method;
import org.openspcoop2.generic_project.beans.IEnumeration;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.formatter.ITypeFormatter;
import org.openspcoop2.utils.TipiDatabase;

public class EnumTypeFormatter
implements ITypeFormatter<IEnumeration> {
    @Override
    public String toString(IEnumeration o) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        return o.toString();
    }

    @Override
    public String toSQLString(IEnumeration o) throws ExpressionException {
        return this.toSQLString(o, TipiDatabase.DEFAULT);
    }

    @Override
    public String toSQLString(IEnumeration o, TipiDatabase databaseType) throws ExpressionException {
        return "'" + o.toString() + "'";
    }

    @Override
    public IEnumeration toObject(String o, Class<?> c) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        try {
            Method m = c.getMethod("toEnumConstantFromString", String.class);
            IEnumeration tmp = (IEnumeration)m.invoke(null, o);
            if (tmp != null) {
                return tmp;
            }
            throw new Exception("Enum value is not correct: " + o);
        }
        catch (Exception e) {
            throw new ExpressionException("Conversion failure: " + e.getMessage(), e);
        }
    }

    @Override
    public Class<IEnumeration> getTypeSupported() {
        return IEnumeration.class;
    }
}

