/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.serializer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.openspcoop2.generic_project.exception.DeserializerException;

public abstract class AbstractDeserializerBase {
    public <T> T xmlToObj(String fileName, Class<T> c) throws DeserializerException {
        return this.xmlToObj(new File(fileName), c);
    }

    public <T> T xmlToObj(File file, Class<T> c) throws DeserializerException {
        T t;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            t = this.xmlToObj(fin, c);
        }
        catch (Exception e) {
            throw new DeserializerException(e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
        return t;
    }

    public <T> T xmlToObj(byte[] bytes, Class<T> c) throws DeserializerException {
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        return this.xmlToObj(bin, c);
    }

    public <T> T xmlToObj(InputStream is, Class<T> c) throws DeserializerException {
        try {
            return this._xmlToObj(is, c);
        }
        catch (Exception e) {
            throw new DeserializerException(e);
        }
    }

    protected abstract <T> T _xmlToObj(InputStream var1, Class<T> var2) throws Exception;

    public <T> T xmlToObjByByteArray(byte[] xml, Class<T> c) throws DeserializerException {
        T t;
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(xml);
            t = this._xmlToObj(bin, c);
        }
        catch (Exception e) {
            throw new DeserializerException(e);
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {}
        }
        return t;
    }

    public <T> T xmlToObjByString(String xml, Class<T> c) throws DeserializerException {
        try {
            return this.xmlToObjByByteArray(xml.getBytes(), c);
        }
        catch (Exception e) {
            throw new DeserializerException(e);
        }
    }
}

