/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.ByteArrayCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListIntegerCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AddressCodec;
import com.hazelcast.cluster.Address;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public final class ExperimentalAuthenticationCodec {
    public static final int REQUEST_MESSAGE_TYPE = 16580864;
    public static final int RESPONSE_MESSAGE_TYPE = 16580865;
    private static final int REQUEST_UUID_FIELD_OFFSET = 16;
    private static final int REQUEST_SERIALIZATION_VERSION_FIELD_OFFSET = 33;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 34;
    private static final int RESPONSE_STATUS_FIELD_OFFSET = 13;
    private static final int RESPONSE_MEMBER_UUID_FIELD_OFFSET = 14;
    private static final int RESPONSE_SERIALIZATION_VERSION_FIELD_OFFSET = 31;
    private static final int RESPONSE_PARTITION_COUNT_FIELD_OFFSET = 32;
    private static final int RESPONSE_CLUSTER_ID_FIELD_OFFSET = 36;
    private static final int RESPONSE_FAILOVER_SUPPORTED_FIELD_OFFSET = 53;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 54;

    private ExperimentalAuthenticationCodec() {
    }

    public static ClientMessage encodeRequest(String clusterName, @Nullable String username, @Nullable String password, @Nullable UUID uuid, String clientType, byte serializationVersion, String clientHazelcastVersion, String clientName, Collection<String> labels) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Experimental.Authentication");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[34], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16580864);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, uuid);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 33, serializationVersion);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, clusterName);
        CodecUtil.encodeNullable(clientMessage, username, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, password, StringCodec::encode);
        StringCodec.encode(clientMessage, clientType);
        StringCodec.encode(clientMessage, clientHazelcastVersion);
        StringCodec.encode(clientMessage, clientName);
        ListMultiFrameCodec.encode(clientMessage, labels, StringCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        request.serializationVersion = FixedSizeTypesCodec.decodeByte(initialFrame.content, 33);
        request.clusterName = StringCodec.decode(iterator);
        request.username = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.password = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.clientType = StringCodec.decode(iterator);
        request.clientHazelcastVersion = StringCodec.decode(iterator);
        request.clientName = StringCodec.decode(iterator);
        request.labels = ListMultiFrameCodec.decode(iterator, StringCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse(byte status, @Nullable Address address, @Nullable UUID memberUuid, byte serializationVersion, String serverHazelcastVersion, int partitionCount, UUID clusterId, boolean failoverSupported, @Nullable Collection<Integer> tpcPorts, @Nullable byte[] tpcToken) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[54], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16580865);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 13, status);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 14, memberUuid);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 31, serializationVersion);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 32, partitionCount);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 36, clusterId);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 53, failoverSupported);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, address, AddressCodec::encode);
        StringCodec.encode(clientMessage, serverHazelcastVersion);
        CodecUtil.encodeNullable(clientMessage, tpcPorts, ListIntegerCodec::encode);
        CodecUtil.encodeNullable(clientMessage, tpcToken, ByteArrayCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.status = FixedSizeTypesCodec.decodeByte(initialFrame.content, 13);
        response.memberUuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 14);
        response.serializationVersion = FixedSizeTypesCodec.decodeByte(initialFrame.content, 31);
        response.partitionCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 32);
        response.clusterId = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 36);
        response.failoverSupported = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 53);
        response.address = CodecUtil.decodeNullable(iterator, AddressCodec::decode);
        response.serverHazelcastVersion = StringCodec.decode(iterator);
        response.tpcPorts = CodecUtil.decodeNullable(iterator, ListIntegerCodec::decode);
        response.tpcToken = CodecUtil.decodeNullable(iterator, ByteArrayCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public byte status;
        @Nullable
        public Address address;
        @Nullable
        public UUID memberUuid;
        public byte serializationVersion;
        public String serverHazelcastVersion;
        public int partitionCount;
        public UUID clusterId;
        public boolean failoverSupported;
        @Nullable
        public List<Integer> tpcPorts;
        @Nullable
        public byte[] tpcToken;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String clusterName;
        @Nullable
        public String username;
        @Nullable
        public String password;
        @Nullable
        public UUID uuid;
        public String clientType;
        public byte serializationVersion;
        public String clientHazelcastVersion;
        public String clientName;
        public List<String> labels;
    }
}

