/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.cluster.impl.ClusterStateChange;
import com.hazelcast.internal.cluster.impl.operations.CommitClusterStateOp;
import com.hazelcast.internal.cluster.impl.operations.LockClusterStateOp;
import com.hazelcast.internal.cluster.impl.operations.RollbackClusterStateOp;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.transaction.impl.TargetAwareTransactionLogRecord;
import java.io.IOException;
import java.util.UUID;

public class ClusterStateTransactionLogRecord
implements TargetAwareTransactionLogRecord,
Versioned {
    ClusterStateChange stateChange;
    Address initiator;
    Address target;
    UUID txnId;
    long leaseTime;
    int memberListVersion;
    long partitionStateStamp;
    boolean isTransient;

    public ClusterStateTransactionLogRecord() {
    }

    public ClusterStateTransactionLogRecord(ClusterStateChange stateChange, Address initiator, Address target, UUID txnId, long leaseTime, int memberListVersion, long partitionStateStamp, boolean isTransient) {
        this.memberListVersion = memberListVersion;
        Preconditions.checkNotNull(stateChange);
        Preconditions.checkNotNull(initiator);
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(txnId);
        Preconditions.checkPositive("leaseTime", leaseTime);
        this.stateChange = stateChange;
        this.initiator = initiator;
        this.target = target;
        this.txnId = txnId;
        this.leaseTime = leaseTime;
        this.partitionStateStamp = partitionStateStamp;
        this.isTransient = isTransient;
    }

    @Override
    public Object getKey() {
        return null;
    }

    @Override
    public Operation newPrepareOperation() {
        return new LockClusterStateOp(this.stateChange, this.initiator, this.txnId, this.leaseTime, this.memberListVersion, this.partitionStateStamp);
    }

    @Override
    public Operation newCommitOperation() {
        return new CommitClusterStateOp(this.stateChange, this.initiator, this.txnId, this.isTransient);
    }

    @Override
    public Operation newRollbackOperation() {
        return new RollbackClusterStateOp(this.initiator, this.txnId);
    }

    @Override
    public Address getTarget() {
        return this.target;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.stateChange);
        out.writeObject(this.initiator);
        out.writeObject(this.target);
        UUIDSerializationUtil.writeUUID(out, this.txnId);
        out.writeLong(this.leaseTime);
        if (out.getVersion().isGreaterOrEqual(Versions.V4_1)) {
            out.writeLong(this.partitionStateStamp);
        } else {
            out.writeInt((int)this.partitionStateStamp);
        }
        out.writeBoolean(this.isTransient);
        out.writeInt(this.memberListVersion);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.stateChange = (ClusterStateChange)in.readObject();
        this.initiator = (Address)in.readObject();
        this.target = (Address)in.readObject();
        this.txnId = UUIDSerializationUtil.readUUID(in);
        this.leaseTime = in.readLong();
        this.partitionStateStamp = in.getVersion().isGreaterOrEqual(Versions.V4_1) ? in.readLong() : (long)in.readInt();
        this.isTransient = in.readBoolean();
        this.memberListVersion = in.readInt();
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getClassId() {
        return 24;
    }
}

