/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.iobuffer;

import com.hazelcast.internal.tpcengine.iobuffer.IOBuffer;
import com.hazelcast.internal.tpcengine.iobuffer.IOBufferAllocator;
import com.hazelcast.shaded.org.jctools.queues.MessagePassingQueue;
import com.hazelcast.shaded.org.jctools.queues.MpmcArrayQueue;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;

public class ConcurrentIOBufferAllocator
implements IOBufferAllocator {
    private static final AtomicLong NEW_ALLOCATIONS = new AtomicLong();
    private static final AtomicLong POOLED_ALLOCATIONS = new AtomicLong();
    private static final AtomicLong ALLOCATE_CALLS = new AtomicLong();
    private static final AtomicLong RELEASE_CALLS = new AtomicLong();
    private static final ThreadLocal<Pool> POOL = new ThreadLocal();
    private final MpmcArrayQueue<IOBuffer> queue = new MpmcArrayQueue(4096);
    private final boolean direct;
    private final int minSize;

    public ConcurrentIOBufferAllocator(int minSize, boolean direct) {
        this.minSize = minSize;
        this.direct = direct;
    }

    @Override
    public IOBuffer allocate(int minSize) {
        IOBuffer buf = this.allocate();
        buf.ensureRemaining(minSize);
        return buf;
    }

    @Override
    public IOBuffer allocate() {
        Pool pool = POOL.get();
        if (pool == null) {
            pool = new Pool();
            POOL.set(pool);
        }
        pool.allocateCnt++;
        if (pool.index == -1) {
            IOBuffer buf;
            int k;
            int count = 0;
            for (k = 0; k < pool.bufs.length && (buf = this.queue.poll()) != null; ++k) {
                ++count;
                pool.index++;
                ((Pool)pool).bufs[((Pool)pool).index] = buf;
            }
            for (k = count; k < pool.bufs.length; ++k) {
                ByteBuffer buffer = this.direct ? ByteBuffer.allocateDirect(this.minSize) : ByteBuffer.allocate(this.minSize);
                IOBuffer buf2 = new IOBuffer(buffer);
                buf2.concurrent = true;
                buf2.allocator = this;
                pool.newAllocateCnt++;
                pool.index++;
                ((Pool)pool).bufs[k] = buf2;
            }
        }
        IOBuffer buf = pool.bufs[pool.index];
        ((Pool)pool).bufs[((Pool)pool).index] = null;
        pool.index--;
        do {
            int c;
            if ((c = buf.refCount.get()) == 0) continue;
            throw new RuntimeException("Ref count should be 0, but was: " + buf.refCount());
        } while (!buf.refCount.compareAndSet(0, 1));
        return buf;
    }

    @Override
    public void free(IOBuffer buf) {
        if (buf.refCount.get() != 0) {
            throw new RuntimeException("refCount should be 0, but was:" + buf.refCount.get());
        }
        buf.clear();
        buf.next = null;
        Pool pool = POOL.get();
        if (pool == null) {
            this.queue.offer(buf);
        } else if (pool.index == pool.bufs.length - 1) {
            this.queue.offer(buf);
        } else {
            pool.index++;
            ((Pool)pool).bufs[((Pool)pool).index] = buf;
        }
    }

    static class Pool {
        private long newAllocateCnt;
        private long allocateCnt;
        private IOBuffer[] bufs = new IOBuffer[128];
        private int index = -1;
        private final MessagePassingQueue.Consumer<IOBuffer> consumer = buf -> {
            ++this.index;
            this.bufs[this.index] = buf;
        };

        Pool() {
        }
    }
}

