/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.impl.operation.ClearBackupOperation;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.steps.ClearOpSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;

public class ClearOperation
extends MapOperation
implements BackupAwareOperation,
PartitionAwareOperation,
MutatingOperation {
    private boolean shouldBackup;
    private int numberOfClearedEntries;

    public ClearOperation() {
        this(null);
    }

    public ClearOperation(String name) {
        super(name);
        this.createRecordStoreOnDemand = false;
    }

    @Override
    protected void runInternal() {
        if (this.recordStore == null) {
            return;
        }
        this.numberOfClearedEntries = this.recordStore.clear(false);
        this.shouldBackup = true;
    }

    @Override
    public Step getStartingStep() {
        return ClearOpSteps.CLEAR_MEMORY;
    }

    @Override
    public void applyState(State state) {
        if (this.recordStore == null) {
            return;
        }
        super.applyState(state);
        this.numberOfClearedEntries = (Integer)state.getResult();
        this.shouldBackup = true;
    }

    @Override
    public void afterRunInternal() {
        this.invalidateAllKeysInNearCaches();
        this.hintMapEvent();
        super.afterRunInternal();
    }

    private void hintMapEvent() {
        this.mapEventPublisher.hintMapEvent(this.getCallerAddress(), this.name, EntryEventType.CLEAR_ALL, this.numberOfClearedEntries, this.getPartitionId());
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapServiceContext.getMapContainer(this.name).getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapServiceContext.getMapContainer(this.name).getAsyncBackupCount();
    }

    @Override
    public Object getResponse() {
        return this.numberOfClearedEntries;
    }

    @Override
    public Operation getBackupOperation() {
        return new ClearBackupOperation(this.name).setServiceName("hz:impl:mapService");
    }

    @Override
    public int getClassId() {
        return 27;
    }
}

