/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.users.dao;

import java.io.Serializable;
import org.openspcoop2.web.lib.users.dao.Permessi;

public class PermessiUtente
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean servizi;
    private boolean diagnostica;
    private boolean reportistica;
    private boolean sistema;
    private boolean codeMessaggi;
    private boolean auditing;
    private boolean utenti;
    private boolean accordiCooperazione;

    public String toString() {
        StringBuilder bf = new StringBuilder();
        if (this.servizi) {
            bf.append(Permessi.SERVIZI.toString());
        }
        if (this.diagnostica) {
            bf.append(Permessi.DIAGNOSTICA.toString());
        }
        if (this.reportistica) {
            bf.append(Permessi.REPORTISTICA.toString());
        }
        if (this.sistema) {
            bf.append(Permessi.SISTEMA.toString());
        }
        if (this.codeMessaggi) {
            bf.append(Permessi.CODE_MESSAGGI.toString());
        }
        if (this.auditing) {
            bf.append(Permessi.AUDITING.toString());
        }
        if (this.utenti) {
            bf.append(Permessi.UTENTI.toString());
        }
        if (this.accordiCooperazione) {
            bf.append(Permessi.ACCORDI_COOPERAZIONE.toString());
        }
        return bf.toString();
    }

    public String toString(String separatore) {
        PermessiUtente p = new PermessiUtente();
        p.setAuditing(true);
        p.setCodeMessaggi(true);
        p.setDiagnostica(true);
        p.setReportistica(true);
        p.setServizi(true);
        p.setSistema(true);
        p.setUtenti(true);
        p.setAccordiCooperazione(true);
        return this.toString(separatore, p);
    }

    public String toString(String separatore, PermessiUtente maschera) {
        StringBuilder bf = new StringBuilder();
        if (maschera.servizi && this.servizi) {
            if (bf.length() > 0) {
                bf.append(separatore);
            }
            bf.append(Permessi.SERVIZI.toString());
        }
        if (maschera.diagnostica && this.diagnostica) {
            if (bf.length() > 0) {
                bf.append(separatore);
            }
            bf.append(Permessi.DIAGNOSTICA.toString());
        }
        if (maschera.reportistica && this.reportistica) {
            if (bf.length() > 0) {
                bf.append(separatore);
            }
            bf.append(Permessi.REPORTISTICA.toString());
        }
        if (maschera.sistema && this.sistema) {
            if (bf.length() > 0) {
                bf.append(separatore);
            }
            bf.append(Permessi.SISTEMA.toString());
        }
        if (maschera.codeMessaggi && this.codeMessaggi) {
            if (bf.length() > 0) {
                bf.append(separatore);
            }
            bf.append(Permessi.CODE_MESSAGGI.toString());
        }
        if (maschera.auditing && this.auditing) {
            if (bf.length() > 0) {
                bf.append(separatore);
            }
            bf.append(Permessi.AUDITING.toString());
        }
        if (maschera.utenti && this.utenti) {
            if (bf.length() > 0) {
                bf.append(separatore);
            }
            bf.append(Permessi.UTENTI.toString());
        }
        if (maschera.accordiCooperazione && this.accordiCooperazione) {
            if (bf.length() > 0) {
                bf.append(separatore);
            }
            bf.append(Permessi.ACCORDI_COOPERAZIONE.toString());
        }
        return bf.toString();
    }

    public static PermessiUtente toPermessiUtente(String value) {
        PermessiUtente permUtenti = new PermessiUtente();
        if (value.contains(Permessi.SERVIZI.toString())) {
            permUtenti.setServizi(true);
        }
        if (value.contains(Permessi.DIAGNOSTICA.toString())) {
            permUtenti.setDiagnostica(true);
        }
        if (value.contains(Permessi.REPORTISTICA.toString())) {
            permUtenti.setReportistica(true);
        }
        if (value.contains(Permessi.SISTEMA.toString())) {
            permUtenti.setSistema(true);
        }
        if (value.contains(Permessi.CODE_MESSAGGI.toString())) {
            permUtenti.setCodeMessaggi(true);
        }
        if (value.contains(Permessi.AUDITING.toString())) {
            permUtenti.setAuditing(true);
        }
        if (value.contains(Permessi.UTENTI.toString())) {
            permUtenti.setUtenti(true);
        }
        if (value.contains(Permessi.ACCORDI_COOPERAZIONE.toString())) {
            permUtenti.setAccordiCooperazione(true);
        }
        return permUtenti;
    }

    public boolean isAccordiCooperazione() {
        return this.accordiCooperazione;
    }

    public void setAccordiCooperazione(boolean accordiCooperazione) {
        this.accordiCooperazione = accordiCooperazione;
    }

    public boolean isServizi() {
        return this.servizi;
    }

    public void setServizi(boolean servizi) {
        this.servizi = servizi;
    }

    public boolean isDiagnostica() {
        return this.diagnostica;
    }

    public void setDiagnostica(boolean diagnostica) {
        this.diagnostica = diagnostica;
    }

    public boolean isReportistica() {
        return this.reportistica;
    }

    public void setReportistica(boolean reportistica) {
        this.reportistica = reportistica;
    }

    public boolean isSistema() {
        return this.sistema;
    }

    public void setSistema(boolean sistema) {
        this.sistema = sistema;
    }

    public boolean isCodeMessaggi() {
        return this.codeMessaggi;
    }

    public void setCodeMessaggi(boolean codeMessaggi) {
        this.codeMessaggi = codeMessaggi;
    }

    public boolean isAuditing() {
        return this.auditing;
    }

    public void setAuditing(boolean auditing) {
        this.auditing = auditing;
    }

    public boolean isUtenti() {
        return this.utenti;
    }

    public void setUtenti(boolean utenti) {
        this.utenti = utenti;
    }

    public boolean or(PermessiUtente permessi) {
        boolean ok = false;
        if (this.isAuditing() && permessi.isAuditing()) {
            ok = true;
        }
        if (this.isCodeMessaggi() && permessi.isCodeMessaggi()) {
            ok = true;
        }
        if (this.isDiagnostica() && permessi.isDiagnostica()) {
            ok = true;
        }
        if (this.isReportistica() && permessi.isReportistica()) {
            ok = true;
        }
        if (this.isServizi() && permessi.isServizi()) {
            ok = true;
        }
        if (this.isSistema() && permessi.isSistema()) {
            ok = true;
        }
        if (this.isUtenti() && permessi.isUtenti()) {
            ok = true;
        }
        if (this.isAccordiCooperazione() && permessi.isAccordiCooperazione()) {
            ok = true;
        }
        return ok;
    }

    public boolean and(PermessiUtente permessi) {
        if (this.isAuditing() && permessi.isAuditing()) {
            return false;
        }
        if (this.isCodeMessaggi() && permessi.isCodeMessaggi()) {
            return false;
        }
        if (this.isDiagnostica() && permessi.isDiagnostica()) {
            return false;
        }
        if (this.isReportistica() && permessi.isReportistica()) {
            return false;
        }
        if (this.isServizi() && permessi.isServizi()) {
            return false;
        }
        if (this.isSistema() && permessi.isSistema()) {
            return false;
        }
        if (this.isUtenti() && permessi.isUtenti()) {
            return false;
        }
        return !this.isAccordiCooperazione() || !permessi.isAccordiCooperazione();
    }
}

