/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.base;

import net.sf.dynamicreports.design.base.DRDesignGroup;
import net.sf.dynamicreports.design.constant.ResetType;
import net.sf.dynamicreports.design.definition.DRIDesignVariable;
import net.sf.dynamicreports.design.definition.expression.DRIDesignExpression;
import net.sf.dynamicreports.report.ReportUtils;
import net.sf.dynamicreports.report.constant.Calculation;

public class DRDesignVariable
implements DRIDesignVariable {
    private static final long serialVersionUID = 10000L;
    private String name;
    private DRIDesignExpression valueExpression;
    private DRIDesignExpression initialValueExpression;
    private Calculation calculation;
    private ResetType resetType;
    private DRDesignGroup resetGroup;

    public DRDesignVariable() {
        this.name = ReportUtils.generateUniqueName("variable");
    }

    public DRDesignVariable(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DRIDesignExpression getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(DRIDesignExpression valueExpression) {
        this.valueExpression = valueExpression;
    }

    @Override
    public DRIDesignExpression getInitialValueExpression() {
        return this.initialValueExpression;
    }

    public void setInitialValueExpression(DRIDesignExpression initialValueExpression) {
        this.initialValueExpression = initialValueExpression;
    }

    @Override
    public Calculation getCalculation() {
        return this.calculation;
    }

    public void setCalculation(Calculation calculation) {
        this.calculation = calculation;
    }

    @Override
    public ResetType getResetType() {
        return this.resetType;
    }

    public void setResetType(ResetType resetType) {
        this.resetType = resetType;
    }

    @Override
    public DRDesignGroup getResetGroup() {
        return this.resetGroup;
    }

    public void setResetGroup(DRDesignGroup resetGroup) {
        this.resetGroup = resetGroup;
    }

    @Override
    public Class<?> getValueClass() {
        return ReportUtils.getVariableValueClass(this.calculation, this.valueExpression.getValueClass());
    }
}

