/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.base.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.design.base.style.DRDesignBaseStyle;
import net.sf.dynamicreports.design.base.style.DRDesignConditionalStyle;
import net.sf.dynamicreports.design.definition.style.DRIDesignStyle;
import net.sf.dynamicreports.report.ReportUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class DRDesignStyle
extends DRDesignBaseStyle
implements DRIDesignStyle {
    private static final long serialVersionUID = 10000L;
    private String name;
    private DRDesignStyle parentStyle;
    private List<DRDesignConditionalStyle> conditionalStyles;

    public DRDesignStyle() {
        this(ReportUtils.generateUniqueName("style"));
    }

    public DRDesignStyle(String name) {
        this.name = (String)Validate.notBlank((CharSequence)name);
        this.conditionalStyles = new ArrayList<DRDesignConditionalStyle>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DRDesignStyle getParentStyle() {
        return this.parentStyle;
    }

    public void setParentStyle(DRDesignStyle parentStyle) {
        this.parentStyle = parentStyle;
    }

    public List<DRDesignConditionalStyle> getConditionalStyles() {
        return this.conditionalStyles;
    }

    public void setConditionalStyles(List<DRDesignConditionalStyle> conditionalStyles) {
        this.conditionalStyles = conditionalStyles;
    }

    public void addConditionalStyle(DRDesignConditionalStyle conditionalStyle) {
        this.conditionalStyles.add(conditionalStyle);
    }

    @Override
    public boolean equals(Object obj) {
        EqualsBuilder equalsBuilder = new EqualsBuilder().appendSuper(super.equals(obj));
        if (equalsBuilder.isEquals()) {
            DRDesignStyle o = (DRDesignStyle)obj;
            if (!(this.parentStyle != null ? this.parentStyle.getName().equals(o.getParentStyle().getName()) : o.getParentStyle() == null)) {
                return false;
            }
            equalsBuilder.append((Object)this.name, (Object)o.name).append(this.conditionalStyles, o.conditionalStyles);
        }
        return equalsBuilder.isEquals();
    }
}

