/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.chartcustomizer;

import java.awt.Paint;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import org.apache.commons.lang3.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.SubCategoryAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class GroupedStackedBarRendererCustomizer
implements DRIChartCustomizer,
Serializable {
    public static final String GROUP_SERIES_KEY = "-{group-series}-";
    private static final long serialVersionUID = 10000L;
    private KeyToGroupMap map;
    private Map<String, Paint> seriesColors;

    @Override
    public void customize(JFreeChart chart, ReportParameters reportParameters) {
        this.seriesColors = new LinkedHashMap<String, Paint>();
        this.map = null;
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        CategoryDataset dataset = chart.getCategoryPlot().getDataset();
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            String rowKey = (String)((Object)dataset.getRowKey(i));
            String group = StringUtils.substringBefore((String)rowKey, (String)GROUP_SERIES_KEY);
            String series = StringUtils.substringAfter((String)rowKey, (String)GROUP_SERIES_KEY);
            if (this.map == null) {
                this.map = new KeyToGroupMap((Comparable)((Object)group));
            }
            this.map.mapKeyToGroup((Comparable)((Object)rowKey), (Comparable)((Object)group));
            groups.add(group);
            if (this.seriesColors.containsKey(series)) continue;
            Paint paint = chart.getCategoryPlot().getDrawingSupplier().getNextPaint();
            this.seriesColors.put(series, paint);
        }
        DefaultCategoryDataset newDataset = new DefaultCategoryDataset();
        for (Object column : dataset.getColumnKeys()) {
            for (String group : groups) {
                for (String series : this.seriesColors.keySet()) {
                    try {
                        Number value = dataset.getValue((Comparable)((Object)(group + GROUP_SERIES_KEY + series)), (Comparable)column);
                        newDataset.addValue(value, (Comparable)((Object)(group + GROUP_SERIES_KEY + series)), (Comparable)column);
                    }
                    catch (UnknownKeyException e) {
                        newDataset.addValue(0.0, (Comparable)((Object)(group + GROUP_SERIES_KEY + series)), (Comparable)column);
                    }
                }
            }
        }
        dataset = newDataset;
        GroupedStackedBarRenderer renderer = new GroupedStackedBarRenderer();
        renderer.setSeriesToGroupMap(this.map);
        StackedBarRenderer categoryRenderer = (StackedBarRenderer)chart.getCategoryPlot().getRenderer();
        renderer.setBaseItemLabelsVisible(categoryRenderer.getBaseItemLabelsVisible());
        renderer.setBaseItemLabelFont(categoryRenderer.getBaseItemLabelFont());
        renderer.setBaseItemLabelPaint(categoryRenderer.getBaseItemLabelPaint());
        renderer.setBaseItemLabelGenerator(categoryRenderer.getBaseItemLabelGenerator());
        renderer.setShadowVisible(categoryRenderer.getShadowsVisible());
        renderer.setItemMargin(0.1);
        renderer.setDrawBarOutline(false);
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            String rowKey = (String)((Object)dataset.getRowKey(i));
            String score = StringUtils.substringAfter((String)rowKey, (String)GROUP_SERIES_KEY);
            renderer.setSeriesPaint(i, this.seriesColors.get(score));
        }
        CategoryAxis domainAxis = chart.getCategoryPlot().getDomainAxis();
        SubCategoryAxis newDomainAxis = new SubCategoryAxis(domainAxis.getLabel());
        newDomainAxis.setLabelFont(domainAxis.getLabelFont());
        newDomainAxis.setTickLabelFont(domainAxis.getTickLabelFont());
        newDomainAxis.setLabelPaint(domainAxis.getLabelPaint());
        newDomainAxis.setTickLabelPaint(domainAxis.getTickLabelPaint());
        newDomainAxis.setAxisLinePaint(domainAxis.getAxisLinePaint());
        newDomainAxis.setTickMarkPaint(domainAxis.getTickMarkPaint());
        newDomainAxis.setTickLabelsVisible(domainAxis.isTickLabelsVisible());
        newDomainAxis.setTickMarksVisible(domainAxis.isTickMarksVisible());
        newDomainAxis.setCategoryMargin(0.05);
        for (String group : groups) {
            newDomainAxis.addSubCategory((Comparable)((Object)group));
        }
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setDomainAxis((CategoryAxis)newDomainAxis);
        plot.setRenderer((CategoryItemRenderer)renderer);
        LegendItemCollection legendItems = new LegendItemCollection();
        for (String item : this.seriesColors.keySet()) {
            legendItems.add(new LegendItem(item, this.seriesColors.get(item)));
        }
        plot.setFixedLegendItems(legendItems);
        chart.getCategoryPlot().setDataset(dataset);
    }
}

