/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.chartcustomizer;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;

public class PieChartLabelFormatCustomizer
implements DRIChartCustomizer,
Serializable {
    private static final long serialVersionUID = 10000L;
    private String labelFormat;
    private String valuePattern;
    private String percentValuePattern;

    public PieChartLabelFormatCustomizer(String labelFormat, String valuePattern, String percentValuePattern) {
        this.labelFormat = labelFormat;
        this.valuePattern = valuePattern;
        this.percentValuePattern = percentValuePattern;
    }

    @Override
    public void customize(JFreeChart chart, ReportParameters reportParameters) {
        PiePlot plot = (PiePlot)chart.getPlot();
        if (this.labelFormat == null) {
            plot.setLabelGenerator(null);
        } else {
            plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(this.labelFormat, (NumberFormat)new DecimalFormat(this.valuePattern), (NumberFormat)new DecimalFormat(this.percentValuePattern + "%")));
        }
    }
}

