/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.base.column;

import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.report.ReportUtils;
import net.sf.dynamicreports.report.constant.ComponentDimensionType;
import net.sf.dynamicreports.report.constant.TextAdjust;
import net.sf.dynamicreports.report.definition.column.DRIColumn;
import net.sf.dynamicreports.report.definition.component.DRIComponent;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.expression.DRIPropertyExpression;
import net.sf.dynamicreports.report.definition.style.DRIReportStyle;
import org.apache.commons.lang3.Validate;

public class DRColumn<T extends DRIComponent>
implements DRIColumn<T> {
    private static final long serialVersionUID = 10000L;
    private final String name;
    private T component;
    private DRIExpression<?> titleExpression;
    private DRIReportStyle titleStyle;
    private Integer titleHeight;
    private ComponentDimensionType titleHeightType;
    private Integer titleRows;
    private Boolean titleStretchWithOverflow;
    private TextAdjust titleTextAdjust;
    private List<DRIPropertyExpression> titlePropertyExpressions;

    protected DRColumn() {
        this.name = ReportUtils.generateUniqueName("column");
        this.titlePropertyExpressions = new ArrayList<DRIPropertyExpression>();
    }

    public DRColumn(T component) {
        Validate.notNull(component, (String)"component must not be null", (Object[])new Object[0]);
        this.name = ReportUtils.generateUniqueName("column");
        this.component = component;
        this.titlePropertyExpressions = new ArrayList<DRIPropertyExpression>();
    }

    @Override
    public T getComponent() {
        return this.component;
    }

    @Override
    public DRIExpression<?> getTitleExpression() {
        return this.titleExpression;
    }

    public void setTitleExpression(DRIExpression<?> titleExpression) {
        this.titleExpression = titleExpression;
    }

    @Override
    public DRIReportStyle getTitleStyle() {
        return this.titleStyle;
    }

    public void setTitleStyle(DRIReportStyle titleStyle) {
        this.titleStyle = titleStyle;
    }

    @Override
    public Integer getTitleHeight() {
        return this.titleHeight;
    }

    public void setTitleHeight(Integer titleHeight) {
        if (titleHeight != null) {
            Validate.isTrue((titleHeight >= 0 ? 1 : 0) != 0, (String)"titleHeight must be >= 0", (Object[])new Object[0]);
        }
        this.titleHeight = titleHeight;
    }

    @Override
    public ComponentDimensionType getTitleHeightType() {
        return this.titleHeightType;
    }

    public void setTitleHeightType(ComponentDimensionType titleHeightType) {
        this.titleHeightType = titleHeightType;
    }

    @Override
    public Integer getTitleRows() {
        return this.titleRows;
    }

    public void setTitleRows(Integer titleRows) {
        if (titleRows != null) {
            Validate.isTrue((titleRows >= 0 ? 1 : 0) != 0, (String)"titleRows must be >= 0", (Object[])new Object[0]);
        }
        this.titleRows = titleRows;
    }

    @Override
    public Boolean getTitleStretchWithOverflow() {
        return this.titleStretchWithOverflow;
    }

    @Deprecated
    public void setTitleStretchWithOverflow(Boolean titleStretchWithOverflow) {
        this.titleStretchWithOverflow = titleStretchWithOverflow;
    }

    @Override
    public TextAdjust getTitleTextAdjust() {
        return this.titleTextAdjust;
    }

    public void setTitleTextAdjust(TextAdjust titleTextAdjust) {
        this.titleTextAdjust = titleTextAdjust;
    }

    @Override
    public List<DRIPropertyExpression> getTitlePropertyExpressions() {
        return this.titlePropertyExpressions;
    }

    public void setTitlePropertyExpressions(List<DRIPropertyExpression> titlePropertyExpressions) {
        this.titlePropertyExpressions = titlePropertyExpressions;
    }

    public void addTitlePropertyExpression(DRIPropertyExpression propertyExpression) {
        Validate.notNull((Object)propertyExpression, (String)"propertyExpression must not be null", (Object[])new Object[0]);
        this.titlePropertyExpressions.add(propertyExpression);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

