/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.base.component;

import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.report.base.component.DRComponent;
import net.sf.dynamicreports.report.base.component.DRDimensionComponent;
import net.sf.dynamicreports.report.base.component.DRListCell;
import net.sf.dynamicreports.report.constant.HorizontalCellComponentAlignment;
import net.sf.dynamicreports.report.constant.ListType;
import net.sf.dynamicreports.report.constant.VerticalCellComponentAlignment;
import net.sf.dynamicreports.report.definition.component.DRIList;
import org.apache.commons.lang3.Validate;

public class DRList
extends DRDimensionComponent
implements DRIList {
    private static final long serialVersionUID = 10000L;
    private List<DRListCell> listCells;
    private ListType type;
    private Integer gap;
    private DRComponent backgroundComponent;

    public DRList() {
        this(ListType.HORIZONTAL);
    }

    public DRList(ListType type) {
        this.setType(type);
    }

    @Override
    protected void init() {
        super.init();
        this.listCells = new ArrayList<DRListCell>();
    }

    public List<DRListCell> getListCells() {
        return this.listCells;
    }

    public void addComponent(DRComponent component) {
        this.listCells.add(new DRListCell(component));
    }

    public void addCell(DRListCell cell) {
        Validate.notNull((Object)cell, (String)"cell must not be null", (Object[])new Object[0]);
        this.listCells.add(cell);
    }

    public void addComponent(HorizontalCellComponentAlignment horizontalAlignment, VerticalCellComponentAlignment verticalAlignment, DRComponent component) {
        this.listCells.add(new DRListCell(horizontalAlignment, verticalAlignment, component));
    }

    @Override
    public ListType getType() {
        return this.type;
    }

    public void setType(ListType type) {
        Validate.notNull((Object)((Object)type), (String)"type must not be null", (Object[])new Object[0]);
        this.type = type;
    }

    @Override
    public Integer getGap() {
        return this.gap;
    }

    public void setGap(Integer gap) {
        if (gap != null) {
            Validate.isTrue((gap >= 0 ? 1 : 0) != 0, (String)"gap must be >= 0", (Object[])new Object[0]);
        }
        this.gap = gap;
    }

    @Override
    public DRComponent getBackgroundComponent() {
        return this.backgroundComponent;
    }

    public void setBackgroundComponent(DRComponent backgroundComponent) {
        this.backgroundComponent = backgroundComponent;
    }
}

