/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder;

import java.sql.Connection;
import net.sf.dynamicreports.report.base.DRDataset;
import net.sf.dynamicreports.report.base.DRField;
import net.sf.dynamicreports.report.base.DRQuery;
import net.sf.dynamicreports.report.base.DRSort;
import net.sf.dynamicreports.report.builder.AbstractBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.QueryBuilder;
import net.sf.dynamicreports.report.builder.SortBuilder;
import net.sf.dynamicreports.report.builder.VariableBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.jasperreports.engine.JRDataSource;
import org.apache.commons.lang3.Validate;

public class DatasetBuilder
extends AbstractBuilder<DatasetBuilder, DRDataset> {
    private static final long serialVersionUID = 10000L;

    protected DatasetBuilder() {
        super(new DRDataset());
    }

    public DatasetBuilder fields(FieldBuilder<?> ... fields) {
        return this.addField(fields);
    }

    public DatasetBuilder addField(String name, Class<?> valueClass) {
        return this.addField(DynamicReports.field(name, valueClass));
    }

    public <U> DatasetBuilder addField(String name, DRIDataType<? super U, U> dataType) {
        return this.addField(DynamicReports.field(name, dataType));
    }

    public DatasetBuilder addField(FieldBuilder<?> ... fields) {
        Validate.notNull(fields, (String)"fields must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])fields, (String)"fields must not contains null field", (Object[])new Object[0]);
        for (FieldBuilder<?> field : fields) {
            ((DRDataset)this.getObject()).addField((DRField)field.build());
        }
        return this;
    }

    public DatasetBuilder variables(VariableBuilder<?> ... variables) {
        return this.addVariable(variables);
    }

    public DatasetBuilder addVariable(VariableBuilder<?> ... variables) {
        Validate.notNull(variables, (String)"variables must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])variables, (String)"variables must not contains null variable", (Object[])new Object[0]);
        for (VariableBuilder<?> variable : variables) {
            ((DRDataset)this.getObject()).addVariable(variable.getVariable());
        }
        return this;
    }

    public DatasetBuilder sortBy(TextColumnBuilder<?> ... sortColumns) {
        Validate.notNull(sortColumns, (String)"sortColumns must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])sortColumns, (String)"sortColumns must not contains null sortColumn", (Object[])new Object[0]);
        for (TextColumnBuilder<?> sortColumn : sortColumns) {
            this.sortBy(DynamicReports.asc(sortColumn));
        }
        return this;
    }

    public DatasetBuilder sortBy(SortBuilder ... sorts) {
        return this.addSort(sorts);
    }

    public DatasetBuilder addSort(SortBuilder ... sorts) {
        Validate.notNull((Object)sorts, (String)"sorts must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])sorts, (String)"sorts must not contains null sort", (Object[])new Object[0]);
        for (SortBuilder sort : sorts) {
            ((DRDataset)this.getObject()).addSort((DRSort)sort.build());
        }
        return this;
    }

    public DatasetBuilder setQuery(String text, String language) {
        Validate.notNull((Object)text, (String)"text must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)language, (String)"language must not be null", (Object[])new Object[0]);
        return this.setQuery(DynamicReports.query(text, language));
    }

    public DatasetBuilder setQuery(String sql) {
        Validate.notNull((Object)sql, (String)"sql must not be null", (Object[])new Object[0]);
        return this.setQuery(DynamicReports.query(sql, "sql"));
    }

    public DatasetBuilder setQuery(QueryBuilder query) {
        Validate.notNull((Object)query, (String)"query must not be null", (Object[])new Object[0]);
        ((DRDataset)this.getObject()).setQuery((DRQuery)query.build());
        return this;
    }

    public DatasetBuilder setConnection(Connection connection) {
        ((DRDataset)this.getObject()).setConnectionExpression(Expressions.value(connection));
        return this;
    }

    public DatasetBuilder setConnection(DRIExpression<Connection> connectionExpression) {
        ((DRDataset)this.getObject()).setConnectionExpression(connectionExpression);
        return this;
    }

    public DatasetBuilder setDataSource(JRDataSource dataSource) {
        ((DRDataset)this.getObject()).setDataSourceExpression(Expressions.dataSource(dataSource));
        return this;
    }

    public DatasetBuilder setDataSource(DRIExpression<JRDataSource> dataSourceExpression) {
        ((DRDataset)this.getObject()).setDataSourceExpression(dataSourceExpression);
        return this;
    }

    public DatasetBuilder setFilterExpression(DRIExpression<Boolean> filterExpression) {
        ((DRDataset)this.getObject()).setFilterExpression(filterExpression);
        return this;
    }

    public DatasetBuilder setDataSource(String sql, Connection connection) {
        Validate.notNull((Object)sql, (String)"sql must not be null", (Object[])new Object[0]);
        return this.setDataSource(DynamicReports.query(sql, "sql"), connection);
    }

    public DatasetBuilder setDataSource(QueryBuilder query, Connection connection) {
        Validate.notNull((Object)query, (String)"query must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)connection, (String)"connection must not be null", (Object[])new Object[0]);
        this.setQuery(query);
        this.setConnection(connection);
        return this;
    }
}

