/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.chart;

import java.awt.Color;
import net.sf.dynamicreports.report.base.chart.plot.DRAxisFormat;
import net.sf.dynamicreports.report.base.style.DRFont;
import net.sf.dynamicreports.report.builder.AbstractBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public class AxisFormatBuilder
extends AbstractBuilder<AxisFormatBuilder, DRAxisFormat> {
    private static final long serialVersionUID = 10000L;

    protected AxisFormatBuilder() {
        super(new DRAxisFormat());
    }

    public AxisFormatBuilder setLabel(String label) {
        ((DRAxisFormat)this.getObject()).setLabelExpression(Expressions.text(label));
        return this;
    }

    public AxisFormatBuilder setLabel(DRIExpression<String> labelExpression) {
        ((DRAxisFormat)this.getObject()).setLabelExpression(labelExpression);
        return this;
    }

    public AxisFormatBuilder setLabelFont(FontBuilder labelFont) {
        Validate.notNull((Object)labelFont, (String)"labelFont must not be null", (Object[])new Object[0]);
        ((DRAxisFormat)this.getObject()).setLabelFont((DRFont)labelFont.build());
        return this;
    }

    public AxisFormatBuilder setLabelColor(Color labelColor) {
        ((DRAxisFormat)this.getObject()).setLabelColor(labelColor);
        return this;
    }

    public AxisFormatBuilder setTickLabelFont(FontBuilder tickLabelFont) {
        Validate.notNull((Object)tickLabelFont, (String)"tickLabelFont must not be null", (Object[])new Object[0]);
        ((DRAxisFormat)this.getObject()).setTickLabelFont((DRFont)tickLabelFont.build());
        return this;
    }

    public AxisFormatBuilder setTickLabelColor(Color tickLabelColor) {
        ((DRAxisFormat)this.getObject()).setTickLabelColor(tickLabelColor);
        return this;
    }

    public AxisFormatBuilder setTickLabelMask(String tickLabelMask) {
        ((DRAxisFormat)this.getObject()).setTickLabelMask(tickLabelMask);
        return this;
    }

    public AxisFormatBuilder setVerticalTickLabels(Boolean verticalTickLabels) {
        ((DRAxisFormat)this.getObject()).setVerticalTickLabels(verticalTickLabels);
        return this;
    }

    public AxisFormatBuilder setTickLabelRotation(Double tickLabelRotation) {
        ((DRAxisFormat)this.getObject()).setTickLabelRotation(tickLabelRotation);
        return this;
    }

    public AxisFormatBuilder setLineColor(Color lineColor) {
        ((DRAxisFormat)this.getObject()).setLineColor(lineColor);
        return this;
    }

    public AxisFormatBuilder setRangeMinValueExpression(Number rangeMinValue) {
        ((DRAxisFormat)this.getObject()).setRangeMinValueExpression(Expressions.number(rangeMinValue));
        return this;
    }

    public AxisFormatBuilder setRangeMinValueExpression(DRIExpression<? extends Number> rangeMinValueExpression) {
        ((DRAxisFormat)this.getObject()).setRangeMinValueExpression(rangeMinValueExpression);
        return this;
    }

    public AxisFormatBuilder setRangeMaxValueExpression(Number rangeMaxValue) {
        ((DRAxisFormat)this.getObject()).setRangeMaxValueExpression(Expressions.number(rangeMaxValue));
        return this;
    }

    public AxisFormatBuilder setRangeMaxValueExpression(DRIExpression<? extends Number> rangeMaxValueExpression) {
        ((DRAxisFormat)this.getObject()).setRangeMaxValueExpression(rangeMaxValueExpression);
        return this;
    }

    public DRAxisFormat getAxisFormat() {
        return (DRAxisFormat)this.build();
    }
}

