/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.component;

import net.sf.dynamicreports.report.base.component.DRComponent;
import net.sf.dynamicreports.report.base.component.DRList;
import net.sf.dynamicreports.report.base.component.DRListCell;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.Components;
import net.sf.dynamicreports.report.builder.component.DimensionComponentBuilder;
import net.sf.dynamicreports.report.builder.component.FillerBuilder;
import net.sf.dynamicreports.report.builder.component.HorizontalListCellBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.constant.HorizontalCellComponentAlignment;
import net.sf.dynamicreports.report.constant.ListType;
import net.sf.dynamicreports.report.constant.StretchType;
import net.sf.dynamicreports.report.constant.VerticalCellComponentAlignment;
import org.apache.commons.lang3.Validate;

public class HorizontalListBuilder
extends DimensionComponentBuilder<HorizontalListBuilder, DRList> {
    private static final long serialVersionUID = 10000L;
    private DRList row;

    protected HorizontalListBuilder() {
        super(new DRList(ListType.VERTICAL));
        this.init();
    }

    protected void init() {
        this.newRow();
    }

    public HorizontalListBuilder add(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        for (ComponentBuilder<?, ?> component : components) {
            this.row.addComponent((DRComponent)component.getComponent());
        }
        return this;
    }

    public HorizontalListBuilder add(int gap, ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        for (ComponentBuilder<?, ?> component : components) {
            this.add(Components.hListCell(Components.filler().setWidth(gap)).widthFixed());
            this.add(component);
        }
        return this;
    }

    public HorizontalListBuilder add(HorizontalListCellBuilder ... cells) {
        Validate.notNull((Object)cells, (String)"cells must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])cells, (String)"cells must not contains null cell", (Object[])new Object[0]);
        for (HorizontalListCellBuilder cell : cells) {
            this.row.addCell((DRListCell)cell.build());
        }
        return this;
    }

    public HorizontalListBuilder add(int gap, HorizontalListCellBuilder ... cells) {
        Validate.notNull((Object)cells, (String)"cells must not be null", (Object[])new Object[0]);
        for (HorizontalListCellBuilder cell : cells) {
            this.add(Components.hListCell(Components.filler().setWidth(gap)).widthFixed(), cell);
        }
        return this;
    }

    public HorizontalListBuilder newRow() {
        return this.newRow(0);
    }

    public HorizontalListBuilder newRow(Integer verticalGap) {
        return this.newRow(verticalGap, ListType.HORIZONTAL);
    }

    public HorizontalListBuilder newFlowRow() {
        return this.newFlowRow(0);
    }

    public HorizontalListBuilder newFlowRow(Integer verticalGap) {
        return this.newRow(verticalGap, ListType.HORIZONTAL_FLOW);
    }

    private HorizontalListBuilder newRow(Integer verticalGap, ListType listType) {
        if (verticalGap != null) {
            Validate.isTrue((verticalGap >= 0 ? 1 : 0) != 0, (String)"verticalGap must be >= 0", (Object[])new Object[0]);
        }
        if (verticalGap != null && verticalGap > 0) {
            ((DRList)this.getObject()).addComponent(HorizontalCellComponentAlignment.CENTER, VerticalCellComponentAlignment.TOP, (DRComponent)((FillerBuilder)Components.filler().setHeight(verticalGap)).build());
        }
        this.row = new DRList(listType);
        ((DRList)this.getObject()).addComponent(this.row);
        return this;
    }

    public HorizontalListBuilder setGap(Integer gap) {
        this.row.setGap(gap);
        return this;
    }

    @Override
    public HorizontalListBuilder setStyle(ReportStyleBuilder style) {
        if (style != null) {
            this.row.setStyle(style.build());
        } else {
            this.row.setStyle(null);
        }
        return this;
    }

    public HorizontalListBuilder setBaseStretchType(StretchType stretchType) {
        this.row.setStretchType(stretchType);
        return this;
    }

    public HorizontalListBuilder setBaseGap(Integer gap) {
        ((DRList)this.getObject()).setGap(gap);
        return this;
    }

    public HorizontalListBuilder setBaseStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRList)this.getObject()).setStyle(style.build());
        } else {
            ((DRList)this.getObject()).setStyle(null);
        }
        return this;
    }

    public HorizontalListBuilder setBaseBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRList)this.getObject()).setBackgroundComponent((DRComponent)backgroundComponent.build());
        return this;
    }

    public HorizontalListBuilder setBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        this.row.setBackgroundComponent((DRComponent)backgroundComponent.build());
        return this;
    }

    public DRList getList() {
        return (DRList)this.build();
    }
}

