/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.component;

import java.awt.Image;
import java.io.InputStream;
import java.net.URL;
import net.sf.dynamicreports.report.base.component.DRImage;
import net.sf.dynamicreports.report.builder.component.HyperLinkComponentBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.constant.HorizontalImageAlignment;
import net.sf.dynamicreports.report.constant.ImageScale;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;

public class ImageBuilder
extends HyperLinkComponentBuilder<ImageBuilder, DRImage> {
    private static final long serialVersionUID = 10000L;

    protected ImageBuilder() {
        super(new DRImage());
    }

    public ImageBuilder setImage(DRIExpression<?> imageExpression) {
        ((DRImage)this.getObject()).setImageExpression(imageExpression);
        return this;
    }

    public ImageBuilder setImage(String imagePath) {
        ((DRImage)this.getObject()).setImageExpression(Expressions.text(imagePath));
        ((DRImage)this.getObject()).setUsingCache(true);
        return this;
    }

    public ImageBuilder setImage(Image image) {
        ((DRImage)this.getObject()).setImageExpression(Expressions.image(image));
        ((DRImage)this.getObject()).setUsingCache(true);
        return this;
    }

    public ImageBuilder setImage(InputStream imageInputStream) {
        ((DRImage)this.getObject()).setImageExpression(Expressions.inputStream(imageInputStream));
        ((DRImage)this.getObject()).setUsingCache(true);
        return this;
    }

    public ImageBuilder setImage(URL imageUrl) {
        ((DRImage)this.getObject()).setImageExpression(Expressions.url(imageUrl));
        ((DRImage)this.getObject()).setUsingCache(true);
        return this;
    }

    public ImageBuilder setImageScale(ImageScale imageScale) {
        ((DRImage)this.getObject()).setImageScale(imageScale);
        return this;
    }

    public ImageBuilder setUsingCache(Boolean usingCache) {
        ((DRImage)this.getObject()).setUsingCache(usingCache);
        return this;
    }

    public ImageBuilder setLazy(Boolean lazy) {
        ((DRImage)this.getObject()).setLazy(lazy);
        return this;
    }

    @Deprecated
    public ImageBuilder setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment != null) {
            ((DRImage)this.getObject()).setHorizontalImageAlignment(HorizontalImageAlignment.valueOf(horizontalAlignment.name()));
        } else {
            ((DRImage)this.getObject()).setHorizontalImageAlignment(null);
        }
        return this;
    }

    public ImageBuilder setHorizontalImageAlignment(HorizontalImageAlignment horizontalImageAlignment) {
        ((DRImage)this.getObject()).setHorizontalImageAlignment(horizontalImageAlignment);
        return this;
    }
}

