/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.style;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.jasper.base.JasperTemplateStyleLoader;
import net.sf.dynamicreports.report.base.style.DRStyle;
import net.sf.dynamicreports.report.builder.AbstractBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.exception.DRException;
import org.apache.commons.lang3.Validate;

public class TemplateStylesBuilder
extends AbstractBuilder<TemplateStylesBuilder, List<StyleBuilder>> {
    private static final long serialVersionUID = 10000L;

    protected TemplateStylesBuilder() {
        super(new ArrayList());
    }

    public TemplateStylesBuilder loadStyles(InputStream inputStream) {
        return this.addStyles(JasperTemplateStyleLoader.loadStyles(inputStream));
    }

    public TemplateStylesBuilder loadStyles(File file) {
        return this.addStyles(JasperTemplateStyleLoader.loadStyles(file));
    }

    public TemplateStylesBuilder loadStyles(String fileName) throws DRException {
        return this.addStyles(JasperTemplateStyleLoader.loadStyles(fileName));
    }

    public TemplateStylesBuilder loadStyles(URL url) {
        return this.addStyles(JasperTemplateStyleLoader.loadStyles(url));
    }

    private TemplateStylesBuilder addStyles(DRStyle[] styles) {
        for (DRStyle style : styles) {
            ((List)this.getObject()).add(new StyleBuilder(style));
        }
        return this;
    }

    public TemplateStylesBuilder styles(StyleBuilder ... styles) {
        return this.addStyle(styles);
    }

    public TemplateStylesBuilder addStyle(StyleBuilder ... styles) {
        Validate.notNull((Object)styles, (String)"styles must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])styles, (String)"styles must not contains null style", (Object[])new Object[0]);
        for (StyleBuilder templateStyle : styles) {
            ((List)this.getObject()).add(templateStyle);
        }
        return this;
    }

    public StyleBuilder getStyle(String name) {
        Validate.notNull((Object)name, (String)"name must not be null", (Object[])new Object[0]);
        for (StyleBuilder style : this.getStyles()) {
            if (!name.equals(((DRStyle)style.getStyle()).getName())) continue;
            return style;
        }
        return null;
    }

    public List<StyleBuilder> getStyles() {
        return (List)this.build();
    }
}

