/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.subtotal;

import net.sf.dynamicreports.report.base.DRSubtotal;
import net.sf.dynamicreports.report.base.column.DRColumn;
import net.sf.dynamicreports.report.base.component.DRComponent;
import net.sf.dynamicreports.report.base.component.DRDimensionComponent;
import net.sf.dynamicreports.report.base.component.DRHyperLinkComponent;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.builder.AbstractBuilder;
import net.sf.dynamicreports.report.builder.HyperLinkBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.constant.ComponentDimensionType;
import net.sf.dynamicreports.report.constant.Position;
import net.sf.dynamicreports.report.constant.SubtotalPosition;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.expression.DRIValueFormatter;
import org.apache.commons.lang3.Validate;

public abstract class BaseSubtotalBuilder<T extends BaseSubtotalBuilder<T, U>, U>
extends AbstractBuilder<T, DRSubtotal<U>> {
    private static final long serialVersionUID = 10000L;
    private DRIExpression<U> valueExpression;

    protected BaseSubtotalBuilder(ColumnBuilder<?, ?> showInColumn) {
        super(new DRSubtotal((DRColumn)showInColumn.build()));
    }

    protected void setValueExpression(DRIExpression<U> valueExpression) {
        this.valueExpression = valueExpression;
    }

    public T setShowInColumn(ColumnBuilder<?, ?> showInColumn) {
        Validate.notNull(showInColumn, (String)"showInColumn must not be null", (Object[])new Object[0]);
        ((DRSubtotal)this.getObject()).setShowInColumn((DRColumn)showInColumn.build());
        return (T)this;
    }

    public T setLabel(DRIExpression<?> labelExpression) {
        ((DRSubtotal)this.getObject()).setLabelExpression(labelExpression);
        return (T)this;
    }

    public T setLabel(String label) {
        ((DRSubtotal)this.getObject()).setLabelExpression(Expressions.text(label));
        return (T)this;
    }

    public T setLabelStyle(ReportStyleBuilder labelStyle) {
        if (labelStyle != null) {
            ((DRSubtotal)this.getObject()).setLabelStyle(labelStyle.getStyle());
        } else {
            ((DRSubtotal)this.getObject()).setLabelStyle(null);
        }
        return (T)this;
    }

    public T setLabelPosition(Position labelPosition) {
        ((DRSubtotal)this.getObject()).setLabelPosition(labelPosition);
        return (T)this;
    }

    public T setLabelWidth(Integer width) {
        ((DRSubtotal)this.getObject()).setLabelWidth(width);
        return (T)this;
    }

    public T setLabelFixedWidth(Integer width) {
        ((DRSubtotal)this.getObject()).setLabelWidth(width);
        ((DRSubtotal)this.getObject()).setLabelWidthType(ComponentDimensionType.FIXED);
        return (T)this;
    }

    public T setLabelMinWidth(Integer width) {
        ((DRSubtotal)this.getObject()).setLabelWidth(width);
        ((DRSubtotal)this.getObject()).setLabelWidthType(ComponentDimensionType.EXPAND);
        return (T)this;
    }

    public T setPattern(String pattern) {
        ((DRTextField)((DRSubtotal)this.getObject()).getValueField()).setPattern(pattern);
        return (T)this;
    }

    public T setPattern(DRIExpression<String> patternExpression) {
        ((DRTextField)((DRSubtotal)this.getObject()).getValueField()).setPatternExpression(patternExpression);
        return (T)this;
    }

    public T setValueFormatter(DRIValueFormatter<?, ? super U> valueFormatter) {
        ((DRTextField)((DRSubtotal)this.getObject()).getValueField()).setValueFormatter(valueFormatter);
        return (T)this;
    }

    public T setDataType(DRIDataType dataType) {
        ((DRTextField)((DRSubtotal)this.getObject()).getValueField()).setDataType(dataType);
        return (T)this;
    }

    public T setAnchorName(String anchorName) {
        ((DRHyperLinkComponent)((Object)((DRSubtotal)this.getObject()).getValueField())).setAnchorNameExpression(Expressions.text(anchorName));
        return (T)this;
    }

    public T setAnchorName(DRIExpression<String> anchorNameExpression) {
        ((DRHyperLinkComponent)((Object)((DRSubtotal)this.getObject()).getValueField())).setAnchorNameExpression(anchorNameExpression);
        return (T)this;
    }

    public T setBookmarkLevel(Integer bookmarkLevel) {
        ((DRHyperLinkComponent)((Object)((DRSubtotal)this.getObject()).getValueField())).setBookmarkLevel(bookmarkLevel);
        return (T)this;
    }

    public T setHyperLink(HyperLinkBuilder hyperLink) {
        if (hyperLink != null) {
            ((DRHyperLinkComponent)((Object)((DRSubtotal)this.getObject()).getValueField())).setHyperLink(hyperLink.getHyperLink());
        } else {
            ((DRHyperLinkComponent)((Object)((DRSubtotal)this.getObject()).getValueField())).setHyperLink(null);
        }
        return (T)this;
    }

    public T setRows(Integer rows) {
        ((DRTextField)((DRSubtotal)this.getObject()).getValueField()).setRows(rows);
        return (T)this;
    }

    public T setFixedRows(Integer rows) {
        ((DRTextField)((DRSubtotal)this.getObject()).getValueField()).setRows(rows);
        ((DRDimensionComponent)((Object)((DRSubtotal)this.getObject()).getValueField())).setHeightType(ComponentDimensionType.FIXED);
        return (T)this;
    }

    public T setMinRows(Integer rows) {
        ((DRTextField)((DRSubtotal)this.getObject()).getValueField()).setRows(rows);
        ((DRDimensionComponent)((Object)((DRSubtotal)this.getObject()).getValueField())).setHeightType(ComponentDimensionType.EXPAND);
        return (T)this;
    }

    public T setHeight(Integer height) {
        ((DRDimensionComponent)((Object)((DRSubtotal)this.getObject()).getValueField())).setHeight(height);
        return (T)this;
    }

    public T setFixedHeight(Integer height) {
        ((DRDimensionComponent)((Object)((DRSubtotal)this.getObject()).getValueField())).setHeight(height);
        ((DRDimensionComponent)((Object)((DRSubtotal)this.getObject()).getValueField())).setHeightType(ComponentDimensionType.FIXED);
        return (T)this;
    }

    public T setMinHeight(Integer height) {
        ((DRDimensionComponent)((Object)((DRSubtotal)this.getObject()).getValueField())).setHeight(height);
        ((DRDimensionComponent)((Object)((DRSubtotal)this.getObject()).getValueField())).setHeightType(ComponentDimensionType.EXPAND);
        return (T)this;
    }

    public T setStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRComponent)((Object)((DRSubtotal)this.getObject()).getValueField())).setStyle(style.getStyle());
        } else {
            ((DRComponent)((Object)((DRSubtotal)this.getObject()).getValueField())).setStyle(null);
        }
        return (T)this;
    }

    public T setPrintWhenExpression(DRIExpression<Boolean> printWhenExpression) {
        ((DRComponent)((Object)((DRSubtotal)this.getObject()).getValueField())).setPrintWhenExpression(printWhenExpression);
        return (T)this;
    }

    public T setGroup(GroupBuilder<?> group) {
        if (group != null) {
            ((DRSubtotal)this.getObject()).setGroup(group.getGroup());
        } else {
            ((DRSubtotal)this.getObject()).setGroup(null);
        }
        return (T)this;
    }

    public T setPosition(SubtotalPosition position) {
        ((DRSubtotal)this.getObject()).setPosition(position);
        return (T)this;
    }

    @Override
    protected void configure() {
        super.configure();
        ((DRTextField)((DRSubtotal)this.getObject()).getValueField()).setValueExpression(this.valueExpression);
    }

    public DRSubtotal<U> getSubtotal() {
        return (DRSubtotal)this.build();
    }
}

