/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.tableofcontents;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.dynamicreports.jasper.base.tableofcontents.JasperTocHeading;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.HyperLinkBuilder;
import net.sf.dynamicreports.report.builder.ReportBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.HorizontalListBuilder;
import net.sf.dynamicreports.report.builder.component.TextFieldBuilder;
import net.sf.dynamicreports.report.builder.component.VerticalListBuilder;
import net.sf.dynamicreports.report.builder.expression.SystemMessageExpression;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.constant.HorizontalTextAlignment;
import net.sf.dynamicreports.report.constant.HyperLinkType;
import net.sf.dynamicreports.report.constant.TableOfContentsPosition;
import net.sf.dynamicreports.report.constant.TextAdjust;
import net.sf.dynamicreports.report.definition.DRITableOfContentsCustomizer;
import net.sf.dynamicreports.report.definition.ReportParameters;

public class TableOfContentsCustomizer
implements DRITableOfContentsCustomizer {
    private static final long serialVersionUID = 10000L;
    protected static String dots;
    protected ReportBuilder<?> report;
    protected List<JasperTocHeading> headingList;
    protected int headings;
    protected int levels;
    protected FieldBuilder<Integer> levelField;
    protected FieldBuilder<String> textField;
    protected FieldBuilder<String> referenceField;
    protected FieldBuilder<Integer> pageIndexField;
    protected HyperLinkBuilder referenceHyperLink;
    protected int pageIndexDigits;
    protected ReportStyleBuilder titleStyle;
    protected ReportStyleBuilder headingStyle;
    protected Map<Integer, ReportStyleBuilder> headingStyles = new HashMap<Integer, ReportStyleBuilder>();
    protected Integer textFixedWidth;
    protected Integer dotsFixedWidth;
    protected Integer pageIndexFixedWidth;
    protected TableOfContentsPosition position;

    protected void init() {
        this.levelField = DynamicReports.field("level", DynamicReports.type.integerType());
        this.textField = DynamicReports.field("text", DynamicReports.type.stringType());
        this.referenceField = DynamicReports.field("reference", DynamicReports.type.stringType());
        this.pageIndexField = DynamicReports.field("pageIndex", DynamicReports.type.integerType());
        this.referenceHyperLink = DynamicReports.hyperLink();
        this.referenceHyperLink.setAnchor(new ReferenceExpression());
        this.referenceHyperLink.setType(HyperLinkType.LOCAL_ANCHOR);
        this.pageIndexDigits = String.valueOf(this.headings).length();
        if (this.titleStyle == null) {
            this.titleStyle = (ReportStyleBuilder)((StyleBuilder)((StyleBuilder)DynamicReports.stl.style().bold()).setFontSize(16)).setHorizontalTextAlignment(HorizontalTextAlignment.CENTER);
        }
    }

    @Override
    public void setReport(ReportBuilder<?> report) {
        this.report = report;
    }

    @Override
    public void setHeadingList(List<JasperTocHeading> headingList) {
        this.headingList = headingList;
    }

    @Override
    public void setHeadings(int headings) {
        this.headings = headings;
    }

    @Override
    public void setLevels(int levels) {
        this.levels = levels;
    }

    @Override
    public void customize() {
        this.init();
        ((ReportBuilder)((ReportBuilder)this.report.title(new ComponentBuilder[]{this.title(), DynamicReports.cmp.filler().setFixedHeight(20)})).fields(this.levelField, this.textField, this.referenceField, this.pageIndexField)).detail(this.detailComponent());
    }

    protected ComponentBuilder<?, ?> title() {
        return DynamicReports.cmp.text(new SystemMessageExpression("table_of_contents")).setStyle(this.titleStyle);
    }

    protected ComponentBuilder<?, ?> detailComponent() {
        VerticalListBuilder detailComponent = DynamicReports.cmp.verticalList();
        for (int i = 0; i < this.levels; ++i) {
            ComponentBuilder<?, ?> headingComponent = this.headingComponent(i);
            headingComponent.setPrintWhenExpression(new PrintHeadingExpression(i));
            headingComponent.removeLineWhenBlank();
            detailComponent.add(headingComponent);
        }
        return detailComponent;
    }

    protected ComponentBuilder<?, ?> headingComponent(int level) {
        HorizontalListBuilder headingComponent = DynamicReports.cmp.horizontalList();
        if (level > 0) {
            headingComponent.add(new ComponentBuilder[]{DynamicReports.cmp.filler().setFixedWidth(level * 10)});
        }
        TextFieldBuilder textComponent = (TextFieldBuilder)DynamicReports.cmp.text(this.textField).setHyperLink(this.referenceHyperLink);
        if (this.textFixedWidth != null) {
            textComponent.setFixedWidth(this.textFixedWidth);
        }
        headingComponent.add(textComponent);
        if (level > 0) {
            headingComponent.add(new ComponentBuilder[]{DynamicReports.cmp.filler().setFixedWidth(level * 10)});
        }
        TextFieldBuilder dotsComponent = (TextFieldBuilder)DynamicReports.cmp.text(dots.toString()).setTextAdjust(TextAdjust.CUT_TEXT).setHyperLink(this.referenceHyperLink);
        if (this.dotsFixedWidth != null) {
            dotsComponent.setFixedWidth(this.dotsFixedWidth);
        }
        headingComponent.add(dotsComponent);
        TextFieldBuilder pageIndexComponent = (TextFieldBuilder)DynamicReports.cmp.text(this.pageIndexField).setHyperLink(this.referenceHyperLink);
        if (this.pageIndexFixedWidth != null) {
            pageIndexComponent.setFixedWidth(this.pageIndexFixedWidth);
        } else {
            pageIndexComponent.setFixedColumns(this.pageIndexDigits);
        }
        headingComponent.add(pageIndexComponent);
        ReportStyleBuilder headingStyle = this.headingStyles.get(level);
        if (headingStyle == null) {
            headingStyle = this.headingStyle;
        }
        if (headingStyle != null) {
            textComponent.setStyle(headingStyle);
            dotsComponent.setStyle(headingStyle);
            pageIndexComponent.setStyle(headingStyle);
        }
        return headingComponent;
    }

    public void setTitleStyle(ReportStyleBuilder titleStyle) {
        this.titleStyle = titleStyle;
    }

    public void setHeadingStyle(ReportStyleBuilder headingStyle) {
        this.headingStyle = headingStyle;
    }

    public void setHeadingStyle(int level, ReportStyleBuilder headingStyle) {
        this.headingStyles.put(level, headingStyle);
    }

    public void setTextFixedWidth(Integer textFixedWidth) {
        this.textFixedWidth = textFixedWidth;
    }

    public void setDotsFixedWidth(Integer dotsFixedWidth) {
        this.dotsFixedWidth = dotsFixedWidth;
    }

    public void setPageIndexFixedWidth(Integer pageIndexFixedWidth) {
        this.pageIndexFixedWidth = pageIndexFixedWidth;
    }

    @Override
    public TableOfContentsPosition getPosition() {
        return this.position;
    }

    public void setPosition(TableOfContentsPosition position) {
        this.position = position;
    }

    static {
        StringBuilder dots = new StringBuilder(200);
        for (int i = 0; i < dots.capacity(); ++i) {
            dots.append(".");
        }
        TableOfContentsCustomizer.dots = dots.toString();
    }

    protected class PrintHeadingExpression
    extends AbstractSimpleExpression<Boolean> {
        private static final long serialVersionUID = 10000L;
        private final int level;

        public PrintHeadingExpression(int level) {
            this.level = level;
        }

        @Override
        public Boolean evaluate(ReportParameters reportParameters) {
            return reportParameters.getValue(TableOfContentsCustomizer.this.levelField) == this.level;
        }
    }

    protected class ReferenceExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 10000L;

        protected ReferenceExpression() {
        }

        @Override
        public String evaluate(ReportParameters reportParameters) {
            return reportParameters.getValue(TableOfContentsCustomizer.this.referenceField);
        }
    }
}

