/*
 * Decompiled with CFR 0.152.
 */
package org.jminix.console.application;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jminix.console.resource.AttributeResource;
import org.jminix.console.resource.AttributesResource;
import org.jminix.console.resource.DomainResource;
import org.jminix.console.resource.DomainsResource;
import org.jminix.console.resource.MBeanResource;
import org.jminix.console.resource.MBeansResource;
import org.jminix.console.resource.OperationResource;
import org.jminix.console.resource.OperationsResource;
import org.jminix.console.resource.ServerResource;
import org.jminix.console.resource.ServersResource;
import org.jminix.server.DefaultLocalServerConnectionProvider;
import org.jminix.server.ServerConnectionProvider;
import org.jminix.type.AttributeFilter;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.representation.OutputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Directory;
import org.restlet.routing.Router;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiniConsoleApplication
extends Application {
    private ServerConnectionProvider serverConnectionProvider;
    private AttributeFilter attributeFilter;

    public MiniConsoleApplication() {
        MiniConsoleApplication.configureLog(null);
        this.initConnectionServiceProvider();
    }

    private void initConnectionServiceProvider() {
        String serverConnectionProviderName = System.getProperty("serverConnectionProvider");
        if (serverConnectionProviderName == null) {
            this.serverConnectionProvider = new DefaultLocalServerConnectionProvider();
        } else {
            this.initServerConnectionProvider(serverConnectionProviderName);
            if (this.serverConnectionProvider == null) {
                this.serverConnectionProvider = new DefaultLocalServerConnectionProvider();
            }
        }
    }

    private void initServerConnectionProvider(String serverConnectionProviderName) {
        try {
            Class<?> forName = Class.forName(serverConnectionProviderName);
            this.serverConnectionProvider = (ServerConnectionProvider)forName.newInstance();
            this.initStringProperties(forName);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void initStringProperties(Class<? extends ServerConnectionProvider> forName) throws IllegalAccessException {
        String argsAsCommaSepString = System.getProperty("serverConnectionProviderArgs");
        if (argsAsCommaSepString != null) {
            String[] args;
            for (String kvPair : args = argsAsCommaSepString.split(",")) {
                String[] kvArray = kvPair.split("=");
                if (kvArray.length == 2) {
                    try {
                        Method m = forName.getMethod("set" + kvArray[0], String.class);
                        m.invoke((Object)this.serverConnectionProvider, kvArray[1]);
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                System.err.println("arg " + kvArray[0] + " was not processable");
            }
        }
    }

    public Restlet createInboundRoot() {
        MiniConsoleApplication.configureLog(this.getContext());
        this.getConnectorService().getClientProtocols().add(Protocol.CLAP);
        this.getContext().getAttributes().put("serverProvider", this.serverConnectionProvider);
        if (this.attributeFilter != null) {
            this.getContext().getAttributes().put("attributeFilter", this.attributeFilter);
        }
        Directory jsDirectory = new Directory(this.getContext(), "clap://class/jminix/js");
        Router router = new Router(this.getContext());
        router.setDefaultMatchingMode(1);
        router.setRoutingMode(1);
        router.attach("/js", (Restlet)jsDirectory);
        router.attach("/servers/", ServersResource.class);
        router.attach("/servers/{server}", ServerResource.class);
        router.attach("/servers/{server}/domains", DomainsResource.class);
        router.attach("/servers/{server}/domains/{domain}", DomainResource.class);
        router.attach("/servers/{server}/domains/{domain}/mbeans", MBeansResource.class);
        router.attach("/servers/{server}/domains/{domain}/mbeans/{mbean}", MBeanResource.class);
        router.attach("/servers/{server}/domains/{domain}/mbeans/{mbean}/attributes", AttributesResource.class);
        router.attach("/servers/{server}/domains/{domain}/mbeans/{mbean}/attributes/{attribute}", AttributeResource.class);
        router.attach("/servers/{server}/domains/{domain}/mbeans/{mbean}/attributes/{attribute}/{item}", AttributeResource.class);
        router.attach("/servers/{server}/domains/{domain}/mbeans/{mbean}/operations", OperationsResource.class);
        router.attach("/servers/{server}/domains/{domain}/mbeans/{mbean}/operations/{operation}", OperationResource.class);
        router.attach("/", new Restlet(){

            public void handle(Request request, Response response) {
                response.setEntity((Representation)new OutputRepresentation(MediaType.TEXT_HTML){

                    public void write(OutputStream outputStream) throws IOException {
                        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResource("jminix/console/index.html").openStream();
                        while (in.available() > 0) {
                            int bytesRead;
                            byte[] buffer = new byte[8192];
                            while ((bytesRead = in.read(buffer)) != -1) {
                                outputStream.write(buffer, 0, bytesRead);
                                outputStream.flush();
                            }
                        }
                    }
                });
            }
        });
        return router;
    }

    public void setServerConnectionProvider(ServerConnectionProvider serverConnectionProvider) {
        this.serverConnectionProvider = serverConnectionProvider;
    }

    public void setAttributeFilter(AttributeFilter filter) {
        this.attributeFilter = filter;
    }

    protected static void configureLog(Context context) {
        if (!"true".equals(System.getProperty("common.jmx.show.restlet.log"))) {
            Logger.getLogger("org.restlet").setLevel(Level.SEVERE);
            if (context != null) {
                context.getLogger().setLevel(Level.SEVERE);
            }
        }
    }
}

