/*
 * Decompiled with CFR 0.152.
 */
package org.jminix.console.resource;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class ValueParser {
    private static String stringArraySeparator = ";";

    public static void setStringArraySeparator(String separator) {
        Validate.notNull((Object)separator);
        stringArraySeparator = separator;
    }

    public static boolean isNullOrEmpty(String value) {
        return null == value || "".equals(value);
    }

    public Object parse(String value, String type) {
        String[] result = null;
        if (type.equals("java.lang.String")) {
            return value;
        }
        if (type.equals("java.lang.Byte") || type.equals("byte")) {
            if (ValueParser.isNullOrEmpty(value)) {
                return "byte".equals(type) ? Byte.valueOf((byte)0) : null;
            }
            result = new Byte(value);
        } else if (type.equals("java.lang.Short") || type.equals("short")) {
            if (ValueParser.isNullOrEmpty(value)) {
                return "short".equals(type) ? Short.valueOf((short)0) : null;
            }
            result = new Short(value);
        } else if (type.equals("java.lang.Integer") || type.equals("int")) {
            if (ValueParser.isNullOrEmpty(value)) {
                return "int".equals(type) ? Integer.valueOf(0) : null;
            }
            result = new Integer(value);
        } else if (type.equals("java.lang.Long") || type.equals("long")) {
            if (ValueParser.isNullOrEmpty(value)) {
                return "long".equals(type) ? Long.valueOf(0L) : null;
            }
            result = new Long(value);
        } else if (type.equals("java.lang.Double") || type.equals("double")) {
            if (ValueParser.isNullOrEmpty(value)) {
                return "double".equals(type) ? Double.valueOf(0.0) : null;
            }
            result = new Double(value);
        } else if (type.equals("java.lang.Float") || type.equals("float")) {
            if (ValueParser.isNullOrEmpty(value)) {
                return "float".equals(type) ? Float.valueOf(0.0f) : null;
            }
            result = new Float(value);
        } else if (type.equals("java.lang.Boolean") || type.equals("boolean")) {
            if (ValueParser.isNullOrEmpty(value)) {
                return "boolean".equals(type) ? Boolean.valueOf(false) : null;
            }
            result = new Boolean(value);
        } else if (type.equals("[Ljava.lang.String;")) {
            result = StringUtils.splitPreserveAllTokens((String)value, (String)stringArraySeparator);
        }
        if (result == null) {
            throw new RuntimeException("Type " + type + " is not supported");
        }
        return result;
    }
}

