/*
 * Decompiled with CFR 0.152.
 */
package org.jminix.server;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import org.jminix.server.AbstractMapServerConnectionProvider;
import org.jminix.server.ServerConnectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableServerConnectionProvider
extends AbstractMapServerConnectionProvider {
    private Map<String, ServerConnectionProvider> providerMap = new HashMap<String, ServerConnectionProvider>();
    private List<String> providerKeys = new ArrayList<String>();
    private String keyFormat = "{0}-{1}";

    @Override
    public List<String> getConnectionKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (String providerKey : this.providerKeys) {
            for (String connectionKey : this.providerMap.get(providerKey).getConnectionKeys()) {
                result.add(MessageFormat.format(this.keyFormat, providerKey, connectionKey));
            }
        }
        return result;
    }

    public List<String> getProviderKeys() {
        return this.providerKeys;
    }

    @Override
    public MBeanServerConnection getConnection(String name) {
        Object[] keys;
        try {
            keys = new MessageFormat(this.keyFormat).parse(name);
        }
        catch (ParseException e) {
            return null;
        }
        ServerConnectionProvider provider = this.providerMap.get(keys[0].toString());
        if (provider == null) {
            throw new RuntimeException("No connection named '" + name + "'");
        }
        return provider.getConnection(keys[1].toString());
    }

    public void setKeyFormat(String format) {
        this.keyFormat = format;
    }

    public synchronized void setServerConnectionProviders(Map<String, ServerConnectionProvider> providers) {
        this.providerMap = providers;
        this.providerKeys = new ArrayList<String>(providers.keySet());
        Collections.sort(this.providerKeys);
    }

    public synchronized void addServerConnectionProvider(String key, ServerConnectionProvider provider) {
        this.providerMap.put(key, provider);
        this.providerKeys.add(key);
        Collections.sort(this.providerKeys);
    }

    public synchronized void removeServerConnectionProvider(String key) {
        this.providerMap.remove(key);
        this.providerKeys.remove(key);
    }
}

