/*
 * Decompiled with CFR 0.152.
 */
package org.jminix.server.cluster;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.util.binary.BasicBinaryEncryptor;
import org.jasypt.util.binary.BinaryEncryptor;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.util.Util;
import org.jminix.server.ConfigurableServerConnectionProvider;
import org.jminix.server.ServerConnectionProvider;

public abstract class ClusterManager
extends ReceiverAdapter {
    private ConfigurableServerConnectionProvider provider;
    protected String clusterName;
    private Channel channel;
    private boolean ipv6 = false;
    private BinaryEncryptor encryptor;
    protected String urlPattern;
    protected String host;
    protected int port;
    protected String nodeName;
    private Map<Address, Node> nodes = Collections.synchronizedMap(new HashMap());
    private static final Log log = LogFactory.getLog(ClusterManager.class);

    public void start() {
        try {
            if (this.provider == null) {
                throw new IllegalStateException("Property 'provider' must be set");
            }
            if (this.clusterName == null) {
                throw new IllegalStateException("Property 'clusterName' must be set");
            }
            if (!this.ipv6) {
                System.setProperty("java.net.preferIPv4Stack", "true");
            }
            if (this.channel == null) {
                this.channel = new JChannel();
            }
            this.channel.setReceiver((Receiver)this);
            log.debug((Object)("Connecting to cluster " + this.clusterName));
            this.channel.connect(this.clusterName);
        }
        catch (ChannelException e) {
            throw new RuntimeException(e);
        }
    }

    protected Node thisNode() {
        Node node = new Node();
        if (this.host == null) {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.nodeName == null) {
            this.nodeName = this.host;
            node.name = "node." + this.nodeName;
        } else {
            node.name = "node." + this.nodeName + "." + this.host;
        }
        node.url = this.formatUrl();
        return node;
    }

    protected String formatUrl() {
        return MessageFormat.format(this.urlPattern, this.host, this.port, this.nodeName);
    }

    public String getLocalUrl() {
        return this.thisNode().url;
    }

    public void close() {
        this.channel.close();
    }

    public void viewAccepted(View view) {
        this.nodes.keySet().retainAll(view.getMembers());
        try {
            this.channel.send(new Message(null, null, this.encrypt(this.thisNode())));
        }
        catch (ChannelException e) {
            throw new RuntimeException(e);
        }
    }

    public void receive(Message message) {
        Object o = this.decrypt(message.getBuffer());
        if (o instanceof Node) {
            log.debug((Object)("Received node " + o));
            this.nodes.put(message.getSrc(), (Node)o);
            this.updateProvider();
        }
    }

    private byte[] encrypt(Node node) {
        byte[] message;
        try {
            message = Util.objectToByteBuffer((Object)node);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        if (this.encryptor != null) {
            message = this.encryptor.encrypt(message);
        }
        return message;
    }

    private Object decrypt(byte[] buffer) {
        if (this.encryptor != null) {
            try {
                buffer = this.encryptor.decrypt(buffer);
            }
            catch (EncryptionOperationNotPossibleException e) {
                log.debug((Object)"Could not decrypt:", (Throwable)e);
                return null;
            }
        }
        try {
            return Util.objectFromByteBuffer((byte[])buffer);
        }
        catch (Exception e) {
            log.debug((Object)"Could not deserialize:", (Throwable)e);
            return null;
        }
    }

    private synchronized void updateProvider() {
        log.debug((Object)"Updating providers");
        List<String> currentKeys = this.provider.getProviderKeys();
        HashMap<String, Node> actualNodes = new HashMap<String, Node>();
        for (Node node : this.nodes.values()) {
            actualNodes.put(node.name, node);
        }
        log.debug((Object)("Current providers: " + currentKeys));
        log.debug((Object)("Actual providers: " + actualNodes.keySet()));
        HashSet newKeys = new HashSet(actualNodes.keySet());
        newKeys.removeAll(currentKeys);
        HashSet<String> removedKeys = new HashSet<String>(currentKeys);
        removedKeys.removeAll(actualNodes.keySet());
        log.debug((Object)("New providers: " + newKeys));
        log.debug((Object)("Removed providers: " + removedKeys));
        for (String key : removedKeys) {
            this.provider.removeServerConnectionProvider(key);
        }
        for (String key : newKeys) {
            Node node = (Node)actualNodes.get(key);
            if (node == null) continue;
            log.debug((Object)("Creating provider to " + node));
            this.provider.addServerConnectionProvider(key, this.createNodeProvider(node));
        }
    }

    protected abstract ServerConnectionProvider createNodeProvider(Node var1);

    public void setProvider(ConfigurableServerConnectionProvider provider) {
        this.provider = provider;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setSecret(String secret) {
        this.encryptor = new BasicBinaryEncryptor();
        ((BasicBinaryEncryptor)this.encryptor).setPassword(secret);
    }

    public void setIpv6(boolean ipv6) {
        this.ipv6 = ipv6;
    }

    protected static class Node
    implements Serializable {
        String name;
        String url;

        protected Node() {
        }

        public String toString() {
            return this.name + " (" + this.url + ")";
        }
    }
}

