/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.bean;

import java.util.ArrayList;
import org.openspcoop2.core.statistiche.StatistichePdndTracing;
import org.openspcoop2.core.statistiche.constants.PossibiliStatiRichieste;
import org.openspcoop2.core.transazioni.utils.DumpUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.beans.BlackListElement;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.web.monitor.core.core.Utils;
import org.openspcoop2.web.monitor.core.utils.BeanUtils;
import org.openspcoop2.web.monitor.core.utils.MessageManager;

public class StatistichePdndTracingBean
extends StatistichePdndTracing {
    private static final long serialVersionUID = 1L;
    private String soggettoReadable;

    public StatistichePdndTracingBean() {
    }

    public StatistichePdndTracingBean(StatistichePdndTracing statistichePdndTracing) {
        ArrayList<BlackListElement> metodiEsclusi = new ArrayList<BlackListElement>(0);
        metodiEsclusi.add(new BlackListElement("setSoggettoReadable", new Class[]{String.class}));
        BeanUtils.copy((Object)((Object)this), (Object)statistichePdndTracing, metodiEsclusi);
    }

    public String getStatoReadable() {
        if (this.getStato() == null) {
            return "--";
        }
        if (this.getStato().equals((Object)PossibiliStatiRichieste.FAILED)) {
            return MessageManager.getInstance().getMessage("statistichePdndTracing.stato.FAILED.label");
        }
        return MessageManager.getInstance().getMessage("statistichePdndTracing.stato.PUBLISHED.label");
    }

    public String getStatoPdndReadable() {
        if (this.getStatoPdnd() == null) {
            return "--";
        }
        switch (this.getStatoPdnd()) {
            case ERROR: {
                return MessageManager.getInstance().getMessage("statistichePdndTracing.statoPdnd.ERROR.label");
            }
            case OK: {
                return MessageManager.getInstance().getMessage("statistichePdndTracing.statoPdnd.OK.label");
            }
            case PENDING: {
                return MessageManager.getInstance().getMessage("statistichePdndTracing.statoPdnd.PENDING.label");
            }
            case WAITING: {
                return MessageManager.getInstance().getMessage("statistichePdndTracing.statoPdnd.WAITING.label");
            }
        }
        return this.getStatoPdnd().toString();
    }

    public boolean isShowStatoPdnd() {
        return this.stato != null && this.stato.equals(PossibiliStatiRichieste.PUBLISHED.getValue());
    }

    public void setSoggettoReadable(String soggettoReadable) {
        this.soggettoReadable = soggettoReadable;
    }

    public String getSoggettoReadable() {
        if (this.soggettoReadable != null) {
            return this.soggettoReadable;
        }
        if (this.getPddCodice() == null) {
            return "--";
        }
        return this.getPddCodice();
    }

    public String getTentativiPubblicazioneReadable() {
        if (this.getTentativiPubblicazione() == null) {
            return "--";
        }
        return this.getTentativiPubblicazione().toString();
    }

    public String getMethodReadable() {
        if (this.getMethod() == null) {
            return "--";
        }
        switch (this.getMethod()) {
            case RECOVER: {
                return MessageManager.getInstance().getMessage("statistichePdndTracing.method.RECOVER.label");
            }
            case REPLACE: {
                return MessageManager.getInstance().getMessage("statistichePdndTracing.method.REPLACE.label");
            }
            case SUBMIT: {
                return MessageManager.getInstance().getMessage("statistichePdndTracing.method.SUBMIT.label");
            }
        }
        return this.getMethod().toString();
    }

    public String getErrorDetailsPrettyFailedMessage() {
        String errorDetails = this.getErrorDetails();
        if (errorDetails != null) {
            StringBuilder contenutoDocumentoStringBuilder = new StringBuilder();
            String errore = Utils.getTestoVisualizzabile((byte[])errorDetails.getBytes(), (StringBuilder)contenutoDocumentoStringBuilder, (boolean)true, (int)DumpUtils.getThreshold_readInMemory());
            if (errore != null) {
                return errore;
            }
        }
        return "";
    }

    public String getErrorDetailsPretty() {
        String toRet = null;
        String errorDetails = this.getErrorDetails();
        if (errorDetails != null) {
            StringBuilder contenutoDocumentoStringBuilder = new StringBuilder();
            String errore = Utils.getTestoVisualizzabile((byte[])errorDetails.getBytes(), (StringBuilder)contenutoDocumentoStringBuilder, (boolean)true, (int)DumpUtils.getThreshold_readInMemory());
            if (errore != null) {
                return "";
            }
            JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
            try {
                toRet = jsonUtils.toString(jsonUtils.getAsNode(errorDetails.getBytes()));
            }
            catch (UtilsException utilsException) {
                // empty catch block
            }
        }
        if (toRet == null || "".equals(toRet)) {
            toRet = errorDetails != null ? errorDetails : "";
        }
        return toRet;
    }

    public String getBrushErrorDetails() {
        String toRet = null;
        String errorDetails = this.getErrorDetails();
        if (errorDetails != null) {
            toRet = "json";
        }
        return toRet != null ? toRet : "xml";
    }

    public String getStatoTooltip() {
        if (this.stato == null) {
            return MessageManager.getInstance().getMessage("statistichePdndTracing.statoPdnd.WAITING.label");
        }
        if (this.stato.equals((Object)PossibiliStatiRichieste.FAILED)) {
            return MessageManager.getInstance().getMessage("statistichePdndTracing.stato.FAILED.label");
        }
        switch (this.statoPdnd) {
            case ERROR: {
                return MessageManager.getInstance().getMessage("statistichePdndTracing.statoPdnd.ERROR.label");
            }
            case OK: {
                return MessageManager.getInstance().getMessage("statistichePdndTracing.statoPdnd.OK.label");
            }
            case PENDING: {
                return MessageManager.getInstance().getMessage("statistichePdndTracing.statoPdnd.PENDING.label");
            }
        }
        return MessageManager.getInstance().getMessage("statistichePdndTracing.statoPdnd.WAITING.label");
    }

    public String getColoreIconaStato() {
        if (this.stato == null) {
            return "icona-tracingcsv-grey";
        }
        if (this.stato.equals((Object)PossibiliStatiRichieste.FAILED)) {
            return "icona-tracingcsv-error";
        }
        switch (this.statoPdnd) {
            case ERROR: {
                return "icona-tracingcsv-error";
            }
            case OK: {
                return "icona-tracingcsv-ok";
            }
            case PENDING: {
                return "icona-tracingcsv-warning";
            }
        }
        return "icona-tracingcsv-grey";
    }

    public boolean getFailed() {
        return PossibiliStatiRichieste.FAILED.equals((Object)this.stato);
    }
}

