/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.dao;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.commons.search.AccordoServizioParteComune;
import org.openspcoop2.core.commons.search.AccordoServizioParteComuneGruppo;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteComuneGruppo;
import org.openspcoop2.core.commons.search.PortaApplicativa;
import org.openspcoop2.core.commons.search.PortaDelegata;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.constants.TipoPdD;
import org.openspcoop2.core.commons.search.dao.IDBPortaApplicativaServiceSearch;
import org.openspcoop2.core.commons.search.dao.IDBPortaDelegataServiceSearch;
import org.openspcoop2.core.commons.search.dao.IPortaApplicativaServiceSearch;
import org.openspcoop2.core.commons.search.dao.IPortaDelegataServiceSearch;
import org.openspcoop2.core.commons.search.model.PortaApplicativaModel;
import org.openspcoop2.core.commons.search.model.PortaDelegataModel;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazione;
import org.openspcoop2.core.config.constants.RuoloContesto;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.IdPolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.dao.IAttivazionePolicyServiceSearch;
import org.openspcoop2.core.controllo_traffico.dao.IConfigurazionePolicyServiceSearch;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.id.IdentificativiErogazione;
import org.openspcoop2.core.id.IdentificativiFruizione;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.plugins.utils.ProjectInfo;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.dao.IServiceSearchWithId;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.config.UrlInvocazioneAPI;
import org.openspcoop2.pdd.core.autorizzazione.canali.CanaliUtils;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.protocol.utils.PorteNamingUtils;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.dao.DynamicUtilsService;
import org.openspcoop2.web.monitor.core.dao.DynamicUtilsServiceEngine;
import org.openspcoop2.web.monitor.core.dao.IDynamicUtilsService;
import org.openspcoop2.web.monitor.core.exception.UserInvalidException;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.DynamicPdDBeanUtils;
import org.openspcoop2.web.monitor.core.utils.ParseUtility;
import org.openspcoop2.web.monitor.statistiche.bean.ConfigurazioneGenerale;
import org.openspcoop2.web.monitor.statistiche.bean.ConfigurazioneGeneralePK;
import org.openspcoop2.web.monitor.statistiche.bean.ConfigurazioniGeneraliSearchForm;
import org.openspcoop2.web.monitor.statistiche.bean.DettaglioPA;
import org.openspcoop2.web.monitor.statistiche.bean.DettaglioPD;
import org.openspcoop2.web.monitor.statistiche.bean.DettaglioRateLimiting;
import org.openspcoop2.web.monitor.statistiche.dao.IConfigurazioniGeneraliService;
import org.openspcoop2.web.monitor.statistiche.utils.ConfigurazioniUtils;
import org.slf4j.Logger;

public class ConfigurazioniGeneraliService
implements IConfigurazioniGeneraliService {
    private ConfigurazioniGeneraliSearchForm search = null;
    private static Logger log = LoggerManager.getPddMonitorSqlLogger();
    private transient IDynamicUtilsService dynamicService = null;
    private transient org.openspcoop2.core.commons.search.dao.IServiceManager utilsServiceManager;
    private transient IServiceManager pluginsBaseServiceManager;
    private transient org.openspcoop2.core.controllo_traffico.dao.IServiceManager controlloTrafficoServiceManager;
    private IPortaDelegataServiceSearch portaDelegataDAO = null;
    private IPortaApplicativaServiceSearch portaApplicativaDAO = null;
    private IAttivazionePolicyServiceSearch attivazionePolicyDAO = null;
    private IConfigurazionePolicyServiceSearch configurazionePolicyDAO = null;
    private transient DriverConfigurazioneDB driverConfigDB = null;
    private transient DriverRegistroServiziDB driverRegistroDB = null;
    private ConfigurazioneUrlInvocazione configurazioneUrlInvocazione;
    protected DynamicPdDBeanUtils dynamicUtils = null;

    public ConfigurazioniGeneraliService() {
        try {
            this.dynamicService = new DynamicUtilsService();
            this.utilsServiceManager = (org.openspcoop2.core.commons.search.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), log);
            this.pluginsBaseServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), log);
            this.controlloTrafficoServiceManager = (org.openspcoop2.core.controllo_traffico.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.controllo_traffico.utils.ProjectInfo.getInstance(), log);
            this._init(null, null);
        }
        catch (Exception e) {
            log.error("Errore durante la creazione del Service: " + e.getMessage(), (Throwable)e);
        }
    }

    public ConfigurazioniGeneraliService(Connection con, boolean autoCommit) {
        this(con, autoCommit, null, log);
    }

    public ConfigurazioniGeneraliService(Connection con, boolean autoCommit, Logger log) {
        this(con, autoCommit, null, log);
    }

    public ConfigurazioniGeneraliService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties) {
        this(con, autoCommit, serviceManagerProperties, log);
    }

    public ConfigurazioniGeneraliService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties, Logger log) {
        try {
            this.dynamicService = new DynamicUtilsService(con, autoCommit, serviceManagerProperties, log);
            this.utilsServiceManager = (org.openspcoop2.core.commons.search.dao.IServiceManager)DAOFactory.getInstance((Logger)ConfigurazioniGeneraliService.log).getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, log);
            this.pluginsBaseServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)ConfigurazioniGeneraliService.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, log);
            this.controlloTrafficoServiceManager = (org.openspcoop2.core.controllo_traffico.dao.IServiceManager)DAOFactory.getInstance((Logger)ConfigurazioniGeneraliService.log).getServiceManager((IProjectInfo)org.openspcoop2.core.controllo_traffico.utils.ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, ConfigurazioniGeneraliService.log);
            this._init(con, serviceManagerProperties);
        }
        catch (Exception e) {
            ConfigurazioniGeneraliService.log.error("Errore durante la creazione del Service: " + e.getMessage(), (Throwable)e);
        }
    }

    private void _init(Connection con, ServiceManagerProperties serviceManagerProperties) {
        try {
            this.portaApplicativaDAO = this.utilsServiceManager.getPortaApplicativaServiceSearch();
            this.portaDelegataDAO = this.utilsServiceManager.getPortaDelegataServiceSearch();
            this.attivazionePolicyDAO = this.controlloTrafficoServiceManager.getAttivazionePolicyServiceSearch();
            this.configurazionePolicyDAO = this.controlloTrafficoServiceManager.getConfigurazionePolicyServiceSearch();
            String tipoDatabase = null;
            tipoDatabase = serviceManagerProperties != null ? serviceManagerProperties.getDatabaseType() : DAOFactoryProperties.getInstance((Logger)log).getTipoDatabase((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            if (con != null) {
                this.driverConfigDB = new DriverConfigurazioneDB(con, log, tipoDatabase);
                this.driverRegistroDB = new DriverRegistroServiziDB(con, log, tipoDatabase);
            } else {
                String datasourceJNDIName = DAOFactoryProperties.getInstance((Logger)log).getDatasourceJNDIName((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
                Properties datasourceJNDIContext = DAOFactoryProperties.getInstance((Logger)log).getDatasourceJNDIContext((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
                this.driverConfigDB = new DriverConfigurazioneDB(datasourceJNDIName, datasourceJNDIContext, log, tipoDatabase);
                this.driverRegistroDB = new DriverRegistroServiziDB(datasourceJNDIName, datasourceJNDIContext, log, tipoDatabase);
            }
            Configurazione config = this.driverConfigDB.getConfigurazioneGenerale();
            if (config != null && config.getUrlInvocazione() != null) {
                this.configurazioneUrlInvocazione = config.getUrlInvocazione();
            }
            this.dynamicUtils = new DynamicPdDBeanUtils(this.utilsServiceManager, this.pluginsBaseServiceManager, this.driverRegistroDB, this.driverConfigDB, log);
        }
        catch (Exception e) {
            log.error("Errore durante la creazione del Service: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<ConfigurazioneGenerale> findAll() {
        log.debug("Metodo FindAll");
        try {
            String tipoProtocollo = this.search.getProtocollo();
            String tipoSoggetto = this.search.getTipoSoggettoLocale();
            String nomeSoggetto = this.search.getSoggettoLocale();
            String input = null;
            String gruppo = this.search.getGruppo();
            boolean apiImplSelected = StringUtils.isNotBlank((String)this.search.getNomeServizio());
            IDAccordo idAccordo = null;
            IDAccordoFactory idAccordoFactory = null;
            String api = this.search.getApi();
            if (!apiImplSelected && api != null && !"".equals(api)) {
                idAccordoFactory = IDAccordoFactory.getInstance();
                idAccordo = idAccordoFactory.getIDAccordoFromUri(api);
            }
            List<IDServizio> listIDServizio = this.getListServizi(apiImplSelected, gruppo, idAccordo, tipoProtocollo, tipoSoggetto, nomeSoggetto, input);
            if (PddRuolo.DELEGATA.equals((Object)this.search.getTipologiaTransazioni())) {
                IExpression expr = this.createPDExpression((IServiceSearchWithId<?, ?>)this.portaDelegataDAO, this.search, false);
                IPaginatedExpression pagExpr = this.portaDelegataDAO.toPaginatedExpression(expr);
                this.setListServiziPD(apiImplSelected, listIDServizio, (IExpression)pagExpr);
                List findAll = this.portaDelegataDAO.findAll(pagExpr);
                if (findAll != null && findAll.size() > 0) {
                    ArrayList<ConfigurazioneGenerale> lst = new ArrayList<ConfigurazioneGenerale>();
                    for (PortaDelegata portaDelegata : findAll) {
                        lst.add(this.fromPD(portaDelegata));
                    }
                    return lst;
                }
            } else {
                IExpression expr = this.createPAExpression((IServiceSearchWithId<?, ?>)this.portaApplicativaDAO, this.search, false);
                IPaginatedExpression pagExpr = this.portaApplicativaDAO.toPaginatedExpression(expr);
                this.setListServiziPA(apiImplSelected, listIDServizio, (IExpression)pagExpr);
                List findAll = this.portaApplicativaDAO.findAll(pagExpr);
                if (findAll != null && findAll.size() > 0) {
                    ArrayList<ConfigurazioneGenerale> lst = new ArrayList<ConfigurazioneGenerale>();
                    for (PortaApplicativa portaApplicativa : findAll) {
                        lst.add(this.fromPA(portaApplicativa));
                    }
                    return lst;
                }
            }
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (UserInvalidException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<ConfigurazioneGenerale>();
    }

    public ConfigurazioneGenerale getApplicativi() {
        ConfigurazioneGenerale configurazione = new ConfigurazioneGenerale();
        configurazione.setLabel("Applicativi");
        log.debug("Calcolo numero Applicativi");
        int count = 0;
        String tipoProtocollo = this.search.getProtocollo();
        try {
            if (this.getSearch().getTipoNomeSoggettoLocale() != null && !StringUtils.isEmpty((String)this.getSearch().getTipoNomeSoggettoLocale()) && !"--".equals(this.getSearch().getTipoNomeSoggettoLocale())) {
                Soggetto soggetto = new Soggetto();
                soggetto.setTipoSoggetto(this.getSearch().getTipoSoggettoLocale());
                soggetto.setNomeSoggetto(this.getSearch().getSoggettoLocale());
                count = this.dynamicService.countElencoServiziApplicativi(tipoProtocollo, soggetto, true, true);
            } else {
                count = this.dynamicService.countElencoServiziApplicativi(tipoProtocollo, null, true, true);
            }
            log.debug("Trovati " + count + " Applicativi");
        }
        catch (Exception e) {
            log.error("Errore durante il calcolo del numero degli applicativi: " + e.getMessage(), (Throwable)e);
        }
        log.debug("Trovate " + count + " Applicativi");
        configurazione.setValue("" + count);
        return configurazione;
    }

    public ConfigurazioneGenerale getPdd() {
        ConfigurazioneGenerale configurazione = new ConfigurazioneGenerale();
        configurazione.setLabel("Porte di Dominio");
        log.debug("Calcolo numero Porte di Dominio");
        int count = 0;
        try {
            count = this.dynamicService.countPdD(this.search.getProtocollo());
        }
        catch (Exception e) {
            log.error("Errore durante il calcolo del numero delle pdd: " + e.getMessage(), (Throwable)e);
        }
        log.debug("Trovate " + count + " Porte di Dominio");
        configurazione.setValue("" + count);
        return configurazione;
    }

    public ConfigurazioneGenerale getSoggettiOperativi() throws Exception {
        ConfigurazioneGenerale configurazione = new ConfigurazioneGenerale();
        configurazione.setLabel("Soggetti 'Operativi'");
        log.debug("Calcolo numero Soggetti 'Operativi'");
        int count = 0;
        try {
            count = this.dynamicService.countElencoSoggettiFromTipoTipoPdD(this.search.getProtocollo(), TipoPdD.OPERATIVO);
        }
        catch (Exception e) {
            log.error("Errore durante il calcolo del numero dei soggetti operativi: " + e.getMessage(), (Throwable)e);
        }
        log.debug("Trovati " + count + " Soggetti 'Operativi'");
        configurazione.setValue("" + count);
        return configurazione;
    }

    public ConfigurazioneGenerale getSoggettiEsterni() throws Exception {
        ConfigurazioneGenerale configurazione = new ConfigurazioneGenerale();
        configurazione.setLabel("Soggetti 'Esterni'");
        log.debug("Calcolo numero Soggetti 'Esterni'");
        int count = 0;
        try {
            count = this.dynamicService.countElencoSoggettiFromTipoTipoPdD(this.search.getProtocollo(), TipoPdD.ESTERNO);
            count += this.dynamicService.countElencoSoggettiFromTipoTipoPdD(this.search.getProtocollo(), null);
        }
        catch (Exception e) {
            log.error("Errore durante il calcolo del numero dei soggetti esterni: " + e.getMessage(), (Throwable)e);
        }
        log.debug("Trovati " + count + " Soggetti 'Esterni'");
        configurazione.setValue("" + count);
        return configurazione;
    }

    public ConfigurazioneGenerale getAccordiServizioParteComune() throws Exception {
        Object value;
        ConfigurazioneGenerale configurazione;
        block14: {
            configurazione = new ConfigurazioneGenerale();
            configurazione.setLabel("API");
            int count = 0;
            value = null;
            boolean isErogatore = false;
            String tipoProtocollo = this.search.getProtocollo();
            String gruppo = this.search.getGruppo();
            try {
                IDAccordo idAccordo = null;
                String api = this.search.getApi();
                if (api != null && !"".equals(api)) {
                    idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(api);
                }
                if (idAccordo != null) {
                    value = "1";
                    break block14;
                }
                if (StringUtils.isNotBlank((String)this.getSearch().getNomeServizio())) {
                    String servizioString = this.getSearch().getNomeServizio();
                    IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)servizioString);
                    AccordoServizioParteComune aspc = this.dynamicService.getAccordoServizio(tipoProtocollo, idServizio.getSoggettoErogatore(), idServizio.getTipo(), idServizio.getNome(), idServizio.getVersione());
                    if (aspc != null) {
                        String nomeAspc = aspc.getNome();
                        Integer versioneAspc = aspc.getVersione();
                        String nomeReferenteAspc = aspc.getIdReferente() != null ? aspc.getIdReferente().getNome() : null;
                        String tipoReferenteAspc = aspc.getIdReferente() != null ? aspc.getIdReferente().getTipo() : null;
                        idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromValues(nomeAspc, tipoReferenteAspc, nomeReferenteAspc, versioneAspc);
                        value = tipoProtocollo != null ? NamingUtils.getLabelAccordoServizioParteComune((String)tipoProtocollo, (IDAccordo)idAccordo) : NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idAccordo);
                    } else {
                        value = "--";
                    }
                    break block14;
                }
                log.debug("Calcolo numero API");
                if (!(this.getSearch().getTipoNomeSoggettoLocale() == null || StringUtils.isEmpty((String)this.getSearch().getTipoNomeSoggettoLocale()) || "--".equals(this.getSearch().getTipoNomeSoggettoLocale()) || "qualsiasi".equals(this.getSearch().getTipoNomeSoggettoLocale()))) {
                    String tipoSoggetto = this.getSearch().getTipoSoggettoLocale();
                    String nomeSoggetto = this.getSearch().getSoggettoLocale();
                    boolean supportoReferente = false;
                    try {
                        supportoReferente = ProtocolFactoryManager.getInstance().getProtocolFactoryByOrganizationType(tipoSoggetto).createProtocolConfiguration().isSupportoSoggettoReferenteAccordiParteComune();
                    }
                    catch (Throwable e) {
                        log.error("Analisi se il protocollo supporta il soggetto referente: " + e.getMessage());
                    }
                    count = supportoReferente ? this.dynamicService.countAccordiServizio(tipoProtocollo, tipoSoggetto, nomeSoggetto, Boolean.valueOf(true), Boolean.valueOf(isErogatore), gruppo) : this.dynamicService.countAccordiServizio(tipoProtocollo, null, null, Boolean.valueOf(false), Boolean.valueOf(isErogatore), gruppo);
                } else {
                    String protocollo = Utility.getLoggedUtenteModalita();
                    boolean supportoReferente = false;
                    try {
                        if (!(protocollo == null || StringUtils.isEmpty((String)protocollo) || "--".equals(protocollo) || "qualsiasi".equals(protocollo))) {
                            supportoReferente = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportoSoggettoReferenteAccordiParteComune();
                        }
                    }
                    catch (Throwable e) {
                        log.error("Analisi se il protocollo supporta il soggetto referente: " + e.getMessage());
                    }
                    count = this.dynamicService.countAccordiServizio(tipoProtocollo, null, null, Boolean.valueOf(supportoReferente), Boolean.valueOf(isErogatore), gruppo);
                }
                log.debug("Trovati " + count + " API");
                value = "" + count;
            }
            catch (Exception e) {
                log.error("Errore durante il calcolo del numero degli accordi di servizio parte comune: " + e.getMessage(), (Throwable)e);
            }
        }
        configurazione.setValue((String)value);
        return configurazione;
    }

    public ConfigurazioneGenerale getAzioni() {
        ConfigurazioneGenerale configurazione = new ConfigurazioneGenerale();
        configurazione.setLabel("Azioni");
        String tipoProtocollo = this.search.getProtocollo();
        String nomeServizio = null;
        String tipoServizio = null;
        String nomeErogatore = null;
        String tipoErogatore = null;
        Integer versioneServizio = null;
        log.debug("Calcolo numero Azioni");
        int count = 0;
        try {
            if (StringUtils.isNotBlank((String)this.getSearch().getNomeServizio())) {
                String servizioString = this.getSearch().getNomeServizio();
                IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)servizioString);
                nomeServizio = idServizio.getNome();
                tipoServizio = idServizio.getTipo();
                nomeErogatore = idServizio.getSoggettoErogatore().getNome();
                tipoErogatore = idServizio.getSoggettoErogatore().getTipo();
                versioneServizio = idServizio.getVersione();
                count = this.dynamicService.countAzioniFromServizio(tipoProtocollo, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, null);
            }
        }
        catch (Exception e) {
            log.error("Errore durante il calcolo del numero delle azioni: " + e.getMessage(), (Throwable)e);
        }
        log.debug("Trovate " + count + " Azioni");
        configurazione.setValue("" + count);
        return configurazione;
    }

    public ConfigurazioneGenerale getErogazioniServizio() throws Exception {
        ConfigurazioneGenerale configurazione = new ConfigurazioneGenerale();
        configurazione.setLabel("Erogazioni");
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        String tipoProtocollo = this.search.getProtocollo();
        String nomeServizio = null;
        String tipoServizio = null;
        String nomeErogatore = null;
        String tipoErogatore = null;
        Integer versioneServizio = null;
        log.debug("Calcolo numero Erogazioni");
        int count = 0;
        try {
            if (StringUtils.isNotBlank((String)this.getSearch().getNomeServizio())) {
                String servizioString = this.getSearch().getNomeServizio();
                IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)servizioString);
                nomeServizio = idServizio.getNome();
                tipoServizio = idServizio.getTipo();
                nomeErogatore = idServizio.getSoggettoErogatore().getNome();
                tipoErogatore = idServizio.getSoggettoErogatore().getTipo();
                versioneServizio = idServizio.getVersione();
            } else if (this.getSearch().getTipoNomeSoggettoLocale() != null && !StringUtils.isEmpty((String)this.getSearch().getTipoNomeSoggettoLocale()) && !"--".equals(this.getSearch().getTipoNomeSoggettoLocale())) {
                tipoSoggetto = this.getSearch().getTipoSoggettoLocale();
                nomeSoggetto = this.getSearch().getSoggettoLocale();
            }
            String gruppo = this.search.getGruppo();
            IDAccordo idAccordo = null;
            String api = this.search.getApi();
            if (api != null && !"".equals(api)) {
                idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(api);
            }
            if (gruppo != null && !"".equals(gruppo) || idAccordo != null) {
                boolean distinct = false;
                List l = this.dynamicUtils.getListaSelectItemsElencoConfigurazioneServiziErogazione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, tipoErogatore, nomeErogatore, tipoServizio, nomeServizio, versioneServizio, null, null, false, this.search.getPermessiUtenteOperatore(), distinct);
                count = l != null ? l.size() : 0;
            } else {
                count = this.dynamicService.countConfigurazioneServiziErogazione(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, null, null, Boolean.valueOf(false), this.search.getPermessiUtenteOperatore());
            }
        }
        catch (Exception e) {
            log.error("Errore durante il calcolo del numero degli accordi servizio parte specifica: " + e.getMessage(), (Throwable)e);
        }
        log.debug("Trovati " + count + " Erogazioni");
        configurazione.setValue("" + count);
        return configurazione;
    }

    public ConfigurazioneGenerale getFruizioniServizio() throws Exception {
        ConfigurazioneGenerale configurazione = new ConfigurazioneGenerale();
        configurazione.setLabel("Fruizioni");
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        String tipoProtocollo = this.search.getProtocollo();
        String nomeServizio = null;
        String tipoServizio = null;
        String nomeErogatore = null;
        String tipoErogatore = null;
        Integer versioneServizio = null;
        log.debug("Calcolo numero Fruizioni");
        int count = 0;
        try {
            if (StringUtils.isNotBlank((String)this.getSearch().getNomeServizio())) {
                String servizioString = this.getSearch().getNomeServizio();
                IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)servizioString);
                nomeServizio = idServizio.getNome();
                tipoServizio = idServizio.getTipo();
                nomeErogatore = idServizio.getSoggettoErogatore().getNome();
                tipoErogatore = idServizio.getSoggettoErogatore().getTipo();
                versioneServizio = idServizio.getVersione();
            } else if (this.getSearch().getTipoNomeSoggettoLocale() != null && !StringUtils.isEmpty((String)this.getSearch().getTipoNomeSoggettoLocale()) && !"--".equals(this.getSearch().getTipoNomeSoggettoLocale())) {
                tipoSoggetto = this.getSearch().getTipoSoggettoLocale();
                nomeSoggetto = this.getSearch().getSoggettoLocale();
            }
            String gruppo = this.search.getGruppo();
            IDAccordo idAccordo = null;
            String api = this.search.getApi();
            if (api != null && !"".equals(api)) {
                idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(api);
            }
            if (gruppo != null && !"".equals(gruppo) || idAccordo != null) {
                boolean distinct = false;
                List l = this.dynamicUtils.getListaSelectItemsElencoConfigurazioneServiziFruizione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, tipoErogatore, nomeErogatore, tipoServizio, nomeServizio, versioneServizio, null, null, false, this.search.getPermessiUtenteOperatore(), distinct);
                count = l != null ? l.size() : 0;
            } else {
                count = this.dynamicService.countConfigurazioneServiziFruizione(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, null, null, Boolean.valueOf(false), this.search.getPermessiUtenteOperatore());
            }
        }
        catch (Exception e) {
            log.error("Errore durante il calcolo del numero delle fruizioni servizio: " + e.getMessage(), (Throwable)e);
        }
        log.debug("Trovate " + count + " Fruizioni");
        configurazione.setValue("" + count);
        return configurazione;
    }

    public List<ConfigurazioneGenerale> findAll(int start, int limit) {
        log.debug("Metodo FindAll: start[" + start + "], limit: [" + limit + "]");
        try {
            String tipoProtocollo = this.search.getProtocollo();
            String tipoSoggetto = this.search.getTipoSoggettoLocale();
            String nomeSoggetto = this.search.getSoggettoLocale();
            String input = null;
            String gruppo = this.search.getGruppo();
            boolean apiImplSelected = StringUtils.isNotBlank((String)this.search.getNomeServizio());
            IDAccordo idAccordo = null;
            IDAccordoFactory idAccordoFactory = null;
            String api = this.search.getApi();
            if (!apiImplSelected && api != null && !"".equals(api)) {
                idAccordoFactory = IDAccordoFactory.getInstance();
                idAccordo = idAccordoFactory.getIDAccordoFromUri(api);
            }
            List<IDServizio> listIDServizio = this.getListServizi(apiImplSelected, gruppo, idAccordo, tipoProtocollo, tipoSoggetto, nomeSoggetto, input);
            if (PddRuolo.DELEGATA.equals((Object)this.search.getTipologiaTransazioni())) {
                IExpression expr = this.createPDExpression((IServiceSearchWithId<?, ?>)this.portaDelegataDAO, this.search, false);
                IPaginatedExpression pagExpr = this.portaDelegataDAO.toPaginatedExpression(expr);
                pagExpr.offset(start).limit(limit);
                this.setListServiziPD(apiImplSelected, listIDServizio, (IExpression)pagExpr);
                List findAll = this.portaDelegataDAO.findAll(pagExpr);
                if (findAll != null && findAll.size() > 0) {
                    ArrayList<ConfigurazioneGenerale> lst = new ArrayList<ConfigurazioneGenerale>();
                    for (PortaDelegata portaDelegata : findAll) {
                        lst.add(this.fromPD(portaDelegata));
                    }
                    return lst;
                }
            } else {
                IExpression expr = this.createPAExpression((IServiceSearchWithId<?, ?>)this.portaApplicativaDAO, this.search, false);
                IPaginatedExpression pagExpr = this.portaApplicativaDAO.toPaginatedExpression(expr);
                pagExpr.offset(start).limit(limit);
                this.setListServiziPA(apiImplSelected, listIDServizio, (IExpression)pagExpr);
                List findAll = this.portaApplicativaDAO.findAll(pagExpr);
                if (findAll != null && findAll.size() > 0) {
                    ArrayList<ConfigurazioneGenerale> lst = new ArrayList<ConfigurazioneGenerale>();
                    for (PortaApplicativa portaApplicativa : findAll) {
                        lst.add(this.fromPA(portaApplicativa));
                    }
                    return lst;
                }
            }
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (UserInvalidException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<ConfigurazioneGenerale>();
    }

    @Override
    public List<ConfigurazioneGenerale> findAllDettagli(int start, int limit) {
        log.debug("Metodo findAllDettagli: start[" + start + "], limit: [" + limit + "]");
        try {
            String tipoProtocollo = this.search.getProtocollo();
            String tipoSoggetto = this.search.getTipoSoggettoLocale();
            String nomeSoggetto = this.search.getSoggettoLocale();
            String input = null;
            String gruppo = this.search.getGruppo();
            boolean apiImplSelected = StringUtils.isNotBlank((String)this.search.getNomeServizio());
            IDAccordo idAccordo = null;
            IDAccordoFactory idAccordoFactory = null;
            String api = this.search.getApi();
            if (!apiImplSelected && api != null && !"".equals(api)) {
                idAccordoFactory = IDAccordoFactory.getInstance();
                idAccordo = idAccordoFactory.getIDAccordoFromUri(api);
            }
            List<IDServizio> listIDServizio = this.getListServizi(apiImplSelected, gruppo, idAccordo, tipoProtocollo, tipoSoggetto, nomeSoggetto, input);
            if (PddRuolo.DELEGATA.equals((Object)this.search.getTipologiaTransazioni())) {
                IExpression expr = this.createPDExpression((IServiceSearchWithId<?, ?>)this.portaDelegataDAO, this.search, false);
                IPaginatedExpression pagExpr = this.portaDelegataDAO.toPaginatedExpression(expr);
                pagExpr.offset(start).limit(limit);
                pagExpr.addOrder(PortaDelegata.model().NOME);
                this.setListServiziPD(apiImplSelected, listIDServizio, (IExpression)pagExpr);
                List findAll = this.portaDelegataDAO.findAll(pagExpr);
                if (findAll != null && findAll.size() > 0) {
                    ArrayList<ConfigurazioneGenerale> lst = new ArrayList<ConfigurazioneGenerale>();
                    for (PortaDelegata portaDelegata : findAll) {
                        ConfigurazioneGenerale dettaglioPD = this.fillDettaglioPD(portaDelegata, false);
                        lst.add(dettaglioPD);
                        List<ConfigurazioneGenerale> findConfigurazioniFiglie = this.findConfigurazioniFiglie(portaDelegata.getNome(), dettaglioPD.getRuolo());
                        if (findConfigurazioniFiglie == null || findConfigurazioniFiglie.size() <= 0) continue;
                        lst.addAll(findConfigurazioniFiglie);
                    }
                    return lst;
                }
            } else {
                IExpression expr = this.createPAExpression((IServiceSearchWithId<?, ?>)this.portaApplicativaDAO, this.search, false);
                IPaginatedExpression pagExpr = this.portaApplicativaDAO.toPaginatedExpression(expr);
                pagExpr.offset(start).limit(limit);
                pagExpr.addOrder(PortaApplicativa.model().NOME);
                this.setListServiziPA(apiImplSelected, listIDServizio, (IExpression)pagExpr);
                List findAll = this.portaApplicativaDAO.findAll(pagExpr);
                if (findAll != null && findAll.size() > 0) {
                    ArrayList<ConfigurazioneGenerale> lst = new ArrayList<ConfigurazioneGenerale>();
                    for (PortaApplicativa portaApplicativa : findAll) {
                        ConfigurazioneGenerale dettaglioPA = this.fillDettaglioPA(portaApplicativa, false);
                        lst.add(dettaglioPA);
                        List<ConfigurazioneGenerale> findConfigurazioniFiglie = this.findConfigurazioniFiglie(portaApplicativa.getNome(), dettaglioPA.getRuolo());
                        if (findConfigurazioniFiglie == null || findConfigurazioniFiglie.size() <= 0) continue;
                        lst.addAll(findConfigurazioniFiglie);
                    }
                    return lst;
                }
            }
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (DriverConfigurazioneException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (DriverConfigurazioneNotFound e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (DriverRegistroServiziException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (DriverRegistroServiziNotFound e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ProtocolException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (UserInvalidException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<ConfigurazioneGenerale>();
    }

    @Override
    public List<ConfigurazioneGenerale> findConfigurazioniFiglie(String nome, PddRuolo ruolo) throws ServiceException {
        log.debug("Metodo findConfigurazioniFiglie: nome[" + nome + "], ruolo: [" + ruolo + "]");
        try {
            if (PddRuolo.DELEGATA.equals((Object)ruolo)) {
                IExpression expr = this.portaDelegataDAO.newExpression();
                expr.equals(PortaDelegata.model().NOME_PORTA_DELEGANTE_AZIONE, (Object)nome);
                expr.sortOrder(SortOrder.ASC);
                expr.addOrder(PortaDelegata.model().ID_SOGGETTO.TIPO);
                expr.addOrder(PortaDelegata.model().ID_SOGGETTO.NOME);
                expr.addOrder(PortaDelegata.model().TIPO_SERVIZIO);
                expr.addOrder(PortaDelegata.model().NOME_SERVIZIO);
                expr.addOrder(PortaDelegata.model().VERSIONE_SERVIZIO);
                expr.addOrder(PortaDelegata.model().NOME_AZIONE);
                IPaginatedExpression pagExpr = this.portaDelegataDAO.toPaginatedExpression(expr);
                List findAll = this.portaDelegataDAO.findAll(pagExpr);
                if (findAll != null && findAll.size() > 0) {
                    ArrayList<ConfigurazioneGenerale> lst = new ArrayList<ConfigurazioneGenerale>();
                    for (PortaDelegata portaDelegata : findAll) {
                        ConfigurazioneGenerale dettaglioPD = this.fillDettaglioPD(portaDelegata, true);
                        lst.add(dettaglioPD);
                    }
                    return lst;
                }
            } else {
                IExpression expr = this.portaApplicativaDAO.newExpression();
                expr.equals(PortaApplicativa.model().NOME_PORTA_DELEGANTE_AZIONE, (Object)nome);
                expr.sortOrder(SortOrder.ASC);
                expr.addOrder(PortaApplicativa.model().ID_SOGGETTO.TIPO);
                expr.addOrder(PortaApplicativa.model().ID_SOGGETTO.NOME);
                expr.addOrder(PortaApplicativa.model().TIPO_SERVIZIO);
                expr.addOrder(PortaApplicativa.model().NOME_SERVIZIO);
                expr.addOrder(PortaApplicativa.model().VERSIONE_SERVIZIO);
                expr.addOrder(PortaApplicativa.model().NOME_AZIONE);
                IPaginatedExpression pagExpr = this.portaApplicativaDAO.toPaginatedExpression(expr);
                List findAll = this.portaApplicativaDAO.findAll(pagExpr);
                if (findAll != null && findAll.size() > 0) {
                    ArrayList<ConfigurazioneGenerale> lst = new ArrayList<ConfigurazioneGenerale>();
                    for (PortaApplicativa portaApplicativa : findAll) {
                        ConfigurazioneGenerale dettaglioPA = this.fillDettaglioPA(portaApplicativa, true);
                        lst.add(dettaglioPA);
                    }
                    return lst;
                }
            }
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (DriverConfigurazioneException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (DriverConfigurazioneNotFound e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (DriverRegistroServiziException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (DriverRegistroServiziNotFound e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ProtocolException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<ConfigurazioneGenerale>();
    }

    public int totalCount() {
        log.debug("Metodo TotalCount");
        NonNegativeNumber nnn = null;
        try {
            String tipoProtocollo = this.search.getProtocollo();
            String tipoSoggetto = this.search.getTipoSoggettoLocale();
            String nomeSoggetto = this.search.getSoggettoLocale();
            String input = null;
            String gruppo = this.search.getGruppo();
            boolean apiImplSelected = StringUtils.isNotBlank((String)this.search.getNomeServizio());
            IDAccordo idAccordo = null;
            IDAccordoFactory idAccordoFactory = null;
            String api = this.search.getApi();
            if (!apiImplSelected && api != null && !"".equals(api)) {
                idAccordoFactory = IDAccordoFactory.getInstance();
                idAccordo = idAccordoFactory.getIDAccordoFromUri(api);
            }
            List<IDServizio> listIDServizio = this.getListServizi(apiImplSelected, gruppo, idAccordo, tipoProtocollo, tipoSoggetto, nomeSoggetto, input);
            if (PddRuolo.DELEGATA.equals((Object)this.search.getTipologiaTransazioni())) {
                IExpression expr = this.createPDExpression((IServiceSearchWithId<?, ?>)this.portaDelegataDAO, this.search, true);
                this.setListServiziPD(apiImplSelected, listIDServizio, expr);
                nnn = this.portaDelegataDAO.count(expr);
            } else {
                IExpression expr = this.createPAExpression((IServiceSearchWithId<?, ?>)this.portaApplicativaDAO, this.search, true);
                this.setListServiziPA(apiImplSelected, listIDServizio, expr);
                nnn = this.portaApplicativaDAO.count(expr);
            }
            if (nnn != null) {
                return (int)nnn.longValue();
            }
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (UserInvalidException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    public void store(ConfigurazioneGenerale obj) throws Exception {
    }

    public void deleteById(ConfigurazioneGeneralePK key) {
    }

    public void delete(ConfigurazioneGenerale obj) throws Exception {
    }

    public void deleteAll() throws Exception {
    }

    public ConfigurazioneGenerale findById(ConfigurazioneGeneralePK key) {
        log.debug("Metodo FindById: [" + key + "]");
        ConfigurazioneGenerale configurazione = null;
        try {
            if (PddRuolo.DELEGATA.equals((Object)key.getRuolo())) {
                IDBPortaDelegataServiceSearch search = (IDBPortaDelegataServiceSearch)this.portaDelegataDAO;
                PortaDelegata portaDelegata = (PortaDelegata)search.get(key.getId().longValue());
                configurazione = this.fillDettaglioPD(portaDelegata, false);
            } else {
                IDBPortaApplicativaServiceSearch search = (IDBPortaApplicativaServiceSearch)this.portaApplicativaDAO;
                PortaApplicativa portaApplicativa = (PortaApplicativa)search.get(key.getId().longValue());
                configurazione = this.fillDettaglioPA(portaApplicativa, false);
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (DriverConfigurazioneException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (DriverConfigurazioneNotFound e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ProtocolException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (DriverRegistroServiziException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (DriverRegistroServiziNotFound e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return configurazione;
    }

    private ConfigurazioneGenerale fillDettaglioPD(PortaDelegata portaDelegata, boolean configurazioniFiglie) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException, DriverConfigurazioneException, DriverConfigurazioneNotFound, DriverRegistroServiziException, DriverRegistroServiziNotFound, ExpressionNotImplementedException, ExpressionException, ProtocolException {
        DettaglioPD dettaglioPD = new DettaglioPD();
        dettaglioPD.setPortaDelegata(portaDelegata);
        ConfigurazioneGenerale configurazione = this.fromPD(portaDelegata);
        IDPortaDelegata idPD = new IDPortaDelegata();
        idPD.setNome(dettaglioPD.getPortaDelegata().getNome());
        IdentificativiFruizione identificativiFruizione = new IdentificativiFruizione();
        identificativiFruizione.setSoggettoFruitore(new IDSoggetto(dettaglioPD.getPortaDelegata().getIdSoggetto().getTipo(), dettaglioPD.getPortaDelegata().getIdSoggetto().getNome()));
        IDServizio idServizio = new IDServizio();
        idServizio.setSoggettoErogatore(new IDSoggetto(dettaglioPD.getPortaDelegata().getTipoSoggettoErogatore(), dettaglioPD.getPortaDelegata().getNomeSoggettoErogatore()));
        idServizio.setTipo(dettaglioPD.getPortaDelegata().getTipoServizio());
        idServizio.setNome(dettaglioPD.getPortaDelegata().getNomeServizio());
        idServizio.setAzione(dettaglioPD.getPortaDelegata().getNomeAzione());
        idServizio.setVersione(dettaglioPD.getPortaDelegata().getVersioneServizio());
        identificativiFruizione.setIdServizio(idServizio);
        idPD.setIdentificativiFruizione(identificativiFruizione);
        dettaglioPD.setPortaDelegataOp2(this.driverConfigDB.getPortaDelegata(idPD));
        List azioniGruppo = null;
        Connection con = null;
        try {
            con = this.driverConfigDB.getConnection("fillDettaglioPD_getMappingFruizione");
            dettaglioPD.setMappingFruizionePortaDelegataOp2(DBMappingUtils.getMappingFruizione((IDServizio)idServizio, (IDSoggetto)identificativiFruizione.getSoggettoFruitore(), (IDPortaDelegata)idPD, (Connection)con, (String)this.driverConfigDB.getTipoDB()));
            if (dettaglioPD.getMappingFruizionePortaDelegataOp2().isDefault()) {
                dettaglioPD.setIdPortaDelegataDefaultOp2(idPD);
            } else {
                dettaglioPD.setIdPortaDelegataDefaultOp2(DBMappingUtils.getIDPortaDelegataAssociataDefault((IDServizio)idServizio, (IDSoggetto)identificativiFruizione.getSoggettoFruitore(), (Connection)con, (String)this.driverConfigDB.getTipoDB()));
                dettaglioPD.setPortaDelegataDefaultOp2(this.driverConfigDB.getPortaDelegata(dettaglioPD.getIdPortaDelegataDefaultOp2()));
                if (dettaglioPD.getPortaDelegataOp2().getAzione() != null) {
                    azioniGruppo = dettaglioPD.getPortaDelegataOp2().getAzione().getAzioneDelegataList();
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.driverConfigDB.releaseConnection(con);
        }
        dettaglioPD.setConnettore(ConfigurazioniUtils.getConnettore(dettaglioPD.getPortaDelegata().getIdSoggetto().getTipo(), dettaglioPD.getPortaDelegata().getIdSoggetto().getNome(), dettaglioPD.getPortaDelegata().getTipoSoggettoErogatore(), dettaglioPD.getPortaDelegata().getNomeSoggettoErogatore(), dettaglioPD.getPortaDelegata().getTipoServizio(), dettaglioPD.getPortaDelegata().getNomeServizio(), dettaglioPD.getPortaDelegata().getVersioneServizio(), azioniGruppo, this.driverRegistroDB));
        dettaglioPD.setPropertyConnettore(ConfigurazioniUtils.printConnettore(dettaglioPD.getConnettore(), "Modalit\u00e0 Inoltro", null));
        ConfigurazioniUtils.fillAzioniPD(dettaglioPD, this.utilsServiceManager);
        AccordoServizioParteComune aspc = (AccordoServizioParteComune)this.utilsServiceManager.getAccordoServizioParteComuneServiceSearch().get((Object)dettaglioPD.getIdAccordoServizioParteComune());
        ArrayList<String> tags = null;
        if (aspc != null) {
            IPaginatedExpression gruppiExpr = this.utilsServiceManager.getAccordoServizioParteComuneGruppoServiceSearch().newPaginatedExpression();
            gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)aspc.getNome());
            gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)aspc.getVersione());
            gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)aspc.getIdReferente().getNome());
            gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)aspc.getIdReferente().getTipo());
            List lGruppi = this.utilsServiceManager.getAccordoServizioParteComuneGruppoServiceSearch().findAllIds(gruppiExpr);
            tags = new ArrayList<String>();
            if (lGruppi != null && !lGruppi.isEmpty()) {
                for (IdAccordoServizioParteComuneGruppo gruppoCheck : lGruppi) {
                    tags.add(gruppoCheck.getIdGruppo().getNome());
                }
            }
        }
        String canaleApi = null;
        if (aspc != null) {
            canaleApi = aspc.getCanale();
        }
        String canale = CanaliUtils.getCanale((CanaliConfigurazione)this.driverConfigDB.getCanaliConfigurazione(false), (String)canaleApi, (String)dettaglioPD.getPortaDelegata().getCanale());
        dettaglioPD.setPropertyGenerali(ConfigurazioniUtils.getPropertiesGeneraliPD(dettaglioPD));
        dettaglioPD.setPropertyAutenticazione(ConfigurazioniUtils.getPropertiesAutenticazionePD(dettaglioPD));
        dettaglioPD.setPropertyAutorizzazione(ConfigurazioniUtils.getPropertiesAutorizzazionePD(dettaglioPD, idPD, this.driverConfigDB, this.driverRegistroDB));
        try {
            dettaglioPD.setRateLimiting(this.getDettaglioRateLimiting(idPD.getNome(), RuoloPolicy.DELEGATA));
        }
        catch (Exception e) {
            log.error("Read RateLimiting PD[" + idPD.getNome() + "] failed: " + e.getMessage(), (Throwable)e);
        }
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByOrganizationType(idPD.getIdentificativiFruizione().getSoggettoFruitore().getTipo());
        String nomePorta = idPD.getNome();
        if (dettaglioPD.getMappingFruizionePortaDelegataOp2() != null && !dettaglioPD.getMappingFruizionePortaDelegataOp2().isDefault() && dettaglioPD.getIdPortaDelegataDefaultOp2() != null) {
            nomePorta = dettaglioPD.getIdPortaDelegataDefaultOp2().getNome();
        }
        UrlInvocazioneAPI urlInvocazioneAPI = UrlInvocazioneAPI.getConfigurazioneUrlInvocazione((ConfigurazioneUrlInvocazione)this.configurazioneUrlInvocazione, (IProtocolFactory)protocolFactory, (RuoloContesto)RuoloContesto.PORTA_DELEGATA, (ServiceBinding)ConfigurazioniUtils.getServiceBindingFromValues(dettaglioPD.getPortaDelegata().getTipoSoggettoErogatore(), dettaglioPD.getPortaDelegata().getNomeSoggettoErogatore(), dettaglioPD.getPortaDelegata().getTipoServizio(), dettaglioPD.getPortaDelegata().getNomeServizio(), dettaglioPD.getPortaDelegata().getVersioneServizio(), this.utilsServiceManager), (String)nomePorta, (IDSoggetto)idPD.getIdentificativiFruizione().getSoggettoFruitore(), tags, (String)canale);
        String urlInvocazione = urlInvocazioneAPI.getUrl();
        dettaglioPD.setUrlInvocazione(urlInvocazione);
        dettaglioPD.setPropertyIntegrazione(ConfigurazioniUtils.getPropertiesIntegrazionePD(dettaglioPD));
        if ("modipa".equals(protocolFactory.getProtocol())) {
            dettaglioPD.setConfigurazioneProfilo(this.readConfigurazioneProfiloFruizione(idServizio, urlInvocazione, identificativiFruizione.getSoggettoFruitore()));
        }
        boolean datiPortaPrincipale = false;
        if (!configurazioniFiglie && dettaglioPD.getMappingFruizionePortaDelegataOp2() != null && dettaglioPD.getMappingFruizionePortaDelegataOp2().isDefault()) {
            datiPortaPrincipale = true;
        }
        configurazione.setPd(dettaglioPD, datiPortaPrincipale);
        return configurazione;
    }

    private String readConfigurazioneProfiloFruizione(IDServizio idServizio, String urlInvocazione, IDSoggetto idFruitore) {
        try {
            IDAccordo idAccordo;
            org.openspcoop2.core.registry.AccordoServizioParteComune aspc;
            Map map;
            Connettore connettore;
            AccordoServizioParteSpecifica asps = this.driverRegistroDB.getAccordoServizioParteSpecifica(idServizio, false);
            Fruitore fruitore = null;
            for (Fruitore check : asps.getFruitoreList()) {
                if (!check.getTipo().equals(idFruitore.getTipo()) || !check.getNome().equals(idFruitore.getNome())) continue;
                fruitore = check;
                break;
            }
            String urlConnettoreFruitoreModI = null;
            Connettore connettore2 = connettore = fruitore != null ? fruitore.getConnettore() : null;
            if (connettore != null && connettore.sizePropertyList() > 0) {
                for (Property p : connettore.getPropertyList()) {
                    if (!"location".equals(p.getNome())) continue;
                    urlConnettoreFruitoreModI = p.getValore();
                }
            }
            if ((map = ModIUtils.configToMap((org.openspcoop2.core.registry.AccordoServizioParteComune)(aspc = this.driverRegistroDB.getAccordoServizioParteComune(idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune()), false, false)), (AccordoServizioParteSpecifica)asps, (String)urlInvocazione, (Fruitore)fruitore, urlConnettoreFruitoreModI)) != null && !map.isEmpty()) {
                ArrayList keys = new ArrayList();
                keys.addAll(map.keySet());
                Collections.sort(keys);
                StringBuilder sb = new StringBuilder();
                for (String key : keys) {
                    if (ModIUtils.isBooleanIndicator((String)key)) continue;
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(key);
                    sb.append(":");
                    String v = (String)map.get(key);
                    if (v == null || !StringUtils.isNotEmpty((String)v)) continue;
                    if (v.contains("\n")) {
                        v = v.replaceAll("\n", " ");
                    }
                    sb.append(v);
                }
                if (sb.length() > 0) {
                    return sb.toString();
                }
            }
        }
        catch (Exception e) {
            log.error("Read ProfiloInteroperabilit\u00e0 ModI configuration idServizio[" + idServizio + "] idFruitore[" + idFruitore + "] failed: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private ConfigurazioneGenerale fillDettaglioPA(PortaApplicativa portaApplicativa, boolean configurazioniFiglie) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException, ExpressionNotImplementedException, ExpressionException, DriverConfigurazioneException, DriverConfigurazioneNotFound, ProtocolException, DriverRegistroServiziException, DriverRegistroServiziNotFound {
        DettaglioPA dettaglioPA = new DettaglioPA();
        dettaglioPA.setPortaApplicativa(portaApplicativa);
        ConfigurazioneGenerale configurazione = this.fromPA(portaApplicativa);
        ConfigurazioniUtils.fillAzioniPA(dettaglioPA, this.utilsServiceManager);
        IDPortaApplicativa idPA = new IDPortaApplicativa();
        idPA.setNome(dettaglioPA.getPortaApplicativa().getNome());
        IdentificativiErogazione identificativiErogazione = new IdentificativiErogazione();
        IDServizio idServizio = new IDServizio();
        idServizio.setSoggettoErogatore(new IDSoggetto(dettaglioPA.getPortaApplicativa().getIdSoggetto().getTipo(), dettaglioPA.getPortaApplicativa().getIdSoggetto().getNome()));
        idServizio.setTipo(dettaglioPA.getPortaApplicativa().getTipoServizio());
        idServizio.setNome(dettaglioPA.getPortaApplicativa().getNomeServizio());
        idServizio.setAzione(dettaglioPA.getPortaApplicativa().getNomeAzione());
        idServizio.setVersione(dettaglioPA.getPortaApplicativa().getVersioneServizio());
        identificativiErogazione.setIdServizio(idServizio);
        idPA.setIdentificativiErogazione(identificativiErogazione);
        dettaglioPA.setPortaApplicativaOp2(this.driverConfigDB.getPortaApplicativa(idPA));
        Connection con = null;
        try {
            con = this.driverConfigDB.getConnection("fillDettaglioPA_getMappingErogazione");
            dettaglioPA.setMappingErogazionePortaApplicativaOp2(DBMappingUtils.getMappingErogazione((IDServizio)idServizio, (IDPortaApplicativa)idPA, (Connection)con, (String)this.driverConfigDB.getTipoDB()));
            if (dettaglioPA.getMappingErogazionePortaApplicativaOp2().isDefault()) {
                dettaglioPA.setIdPortaApplicativaDefaultOp2(idPA);
            } else {
                dettaglioPA.setIdPortaApplicativaDefaultOp2(DBMappingUtils.getIDPortaApplicativaAssociataDefault((IDServizio)idServizio, (Connection)con, (String)this.driverConfigDB.getTipoDB()));
                dettaglioPA.setPortaApplicativaDefaultOp2(this.driverConfigDB.getPortaApplicativa(dettaglioPA.getIdPortaApplicativaDefaultOp2()));
            }
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.driverConfigDB.releaseConnection(con);
        }
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByOrganizationType(idPA.getIdentificativiErogazione().getIdServizio().getSoggettoErogatore().getTipo());
        AccordoServizioParteComune aspc = (AccordoServizioParteComune)this.utilsServiceManager.getAccordoServizioParteComuneServiceSearch().get((Object)dettaglioPA.getIdAccordoServizioParteComune());
        ArrayList<String> tags = null;
        if (aspc != null) {
            IPaginatedExpression gruppiExpr = this.utilsServiceManager.getAccordoServizioParteComuneGruppoServiceSearch().newPaginatedExpression();
            gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)aspc.getNome());
            gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)aspc.getVersione());
            gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)aspc.getIdReferente().getNome());
            gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)aspc.getIdReferente().getTipo());
            List lGruppi = this.utilsServiceManager.getAccordoServizioParteComuneGruppoServiceSearch().findAllIds(gruppiExpr);
            tags = new ArrayList<String>();
            if (lGruppi != null && !lGruppi.isEmpty()) {
                for (IdAccordoServizioParteComuneGruppo gruppoCheck : lGruppi) {
                    tags.add(gruppoCheck.getIdGruppo().getNome());
                }
            }
        }
        String canaleApi = null;
        if (aspc != null) {
            canaleApi = aspc.getCanale();
        }
        String canale = CanaliUtils.getCanale((CanaliConfigurazione)this.driverConfigDB.getCanaliConfigurazione(false), (String)canaleApi, (String)dettaglioPA.getPortaApplicativa().getCanale());
        try {
            dettaglioPA.setRateLimiting(this.getDettaglioRateLimiting(idPA.getNome(), RuoloPolicy.APPLICATIVA));
        }
        catch (Exception e) {
            log.error("Read RateLimiting PA[" + idPA.getNome() + "] failed: " + e.getMessage(), (Throwable)e);
        }
        String nomePorta = idPA.getNome();
        if (dettaglioPA.getMappingErogazionePortaApplicativaOp2() != null && !dettaglioPA.getMappingErogazionePortaApplicativaOp2().isDefault() && dettaglioPA.getIdPortaApplicativaDefaultOp2() != null) {
            nomePorta = dettaglioPA.getIdPortaApplicativaDefaultOp2().getNome();
        }
        UrlInvocazioneAPI urlInvocazioneAPI = UrlInvocazioneAPI.getConfigurazioneUrlInvocazione((ConfigurazioneUrlInvocazione)this.configurazioneUrlInvocazione, (IProtocolFactory)protocolFactory, (RuoloContesto)RuoloContesto.PORTA_APPLICATIVA, (ServiceBinding)ConfigurazioniUtils.getServiceBindingFromValues(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getTipo(), idServizio.getNome(), idServizio.getVersione(), this.utilsServiceManager), (String)nomePorta, (IDSoggetto)idServizio.getSoggettoErogatore(), tags, (String)canale);
        String urlInvocazione = urlInvocazioneAPI.getUrl();
        dettaglioPA.setUrlInvocazione(urlInvocazione);
        if ("trasparente".equals(protocolFactory.getProtocol())) {
            dettaglioPA.setTrasparente(true);
            dettaglioPA.setPropertyIntegrazione(ConfigurazioniUtils.getPropertiesIntegrazionePA(dettaglioPA));
        }
        dettaglioPA.setPropertyGenerali(ConfigurazioniUtils.getPropertiesGeneraliPA(dettaglioPA));
        boolean supportatoAutenticazione = protocolFactory.createProtocolConfiguration().isSupportoAutenticazioneSoggetti();
        dettaglioPA.setSupportatoAutenticazione(supportatoAutenticazione);
        dettaglioPA.setPropertyAutenticazione(ConfigurazioniUtils.getPropertiesAutenticazionePA(dettaglioPA));
        dettaglioPA.setPropertyAutorizzazione(ConfigurazioniUtils.getPropertiesAutorizzazionePA(dettaglioPA, this.utilsServiceManager, this.driverRegistroDB));
        dettaglioPA.setListaSA(ConfigurazioniUtils.getPropertiesServiziApplicativiPA(dettaglioPA, this.driverConfigDB, idPA));
        if ("modipa".equals(protocolFactory.getProtocol())) {
            dettaglioPA.setModi(true);
            dettaglioPA.setConfigurazioneProfilo(this.readConfigurazioneProfiloErogazione(idServizio, urlInvocazione));
            if (dettaglioPA.getConfigurazioneProfilo() != null && dettaglioPA.getConfigurazioneProfilo().length() > 1) {
                dettaglioPA.setModiSicurezzaMessaggio(true);
            }
        }
        boolean datiPortaPrincipale = false;
        if (!configurazioniFiglie && dettaglioPA.getMappingErogazionePortaApplicativaOp2() != null && dettaglioPA.getMappingErogazionePortaApplicativaOp2().isDefault()) {
            datiPortaPrincipale = true;
        }
        configurazione.setPa(dettaglioPA, datiPortaPrincipale);
        return configurazione;
    }

    private String readConfigurazioneProfiloErogazione(IDServizio idServizio, String urlInvocazione) {
        try {
            AccordoServizioParteSpecifica asps = this.driverRegistroDB.getAccordoServizioParteSpecifica(idServizio, false);
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
            org.openspcoop2.core.registry.AccordoServizioParteComune aspc = this.driverRegistroDB.getAccordoServizioParteComune(idAccordo, false, false);
            Map map = ModIUtils.configToMap((org.openspcoop2.core.registry.AccordoServizioParteComune)aspc, (AccordoServizioParteSpecifica)asps, (String)urlInvocazione, null, null);
            if (map != null && !map.isEmpty()) {
                ArrayList keys = new ArrayList();
                keys.addAll(map.keySet());
                Collections.sort(keys);
                StringBuilder sb = new StringBuilder();
                for (String key : keys) {
                    if (ModIUtils.isBooleanIndicator((String)key)) continue;
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(key);
                    sb.append(":");
                    String v = (String)map.get(key);
                    if (v == null || !StringUtils.isNotEmpty((String)v)) continue;
                    if (v.contains("\n")) {
                        v = v.replaceAll("\n", " ");
                    }
                    sb.append(v);
                }
                if (sb.length() > 0) {
                    return sb.toString();
                }
            }
        }
        catch (Exception e) {
            log.error("Read ProfiloInteroperabilit\u00e0 ModI configuration idServizio[" + idServizio + "] failed: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public ConfigurazioniGeneraliSearchForm getSearch() {
        return this.search;
    }

    public void setSearch(ConfigurazioniGeneraliSearchForm search) {
        this.search = search;
    }

    @Override
    public List<ConfigurazioneGenerale> findAllInformazioniGenerali() throws ServiceException {
        ArrayList<ConfigurazioneGenerale> lista = new ArrayList<ConfigurazioneGenerale>();
        try {
            log.debug("--------------- findAllInformazioniGenerali ------------");
            log.debug("--------------- Filtro Impostato ------------");
            log.debug("Protocollo: [" + this.search.getProtocollo() + "]");
            log.debug("Soggetto : [" + this.search.getSoggettoLocale() + "]");
            log.debug("Servizio: [" + this.search.getNomeServizio() + "]");
            log.debug("------------ Fine Filtro Impostato ----------");
            if (!Utility.isMultitenantAbilitato()) {
                lista.add(this.getSoggettiEsterni());
            } else {
                lista.add(this.getSoggettiOperativi());
                lista.add(this.getSoggettiEsterni());
            }
            lista.add(this.getApplicativi());
        }
        catch (Exception e) {
            log.error("Errore durante la ricerca delle Configurazioni: " + e.getMessage(), (Throwable)e);
        }
        return lista;
    }

    @Override
    public List<ConfigurazioneGenerale> findAllInformazioniServizi() throws ServiceException {
        ArrayList<ConfigurazioneGenerale> lista = new ArrayList<ConfigurazioneGenerale>();
        try {
            log.debug("--------------- findAllInformazioniServizi ------------");
            log.debug("--------------- Filtro Impostato ------------");
            log.debug("Protocollo: [" + this.search.getProtocollo() + "]");
            log.debug("Soggetto : [" + this.search.getSoggettoLocale() + "]");
            log.debug("Servizio: [" + this.search.getNomeServizio() + "]");
            log.debug("------------ Fine Filtro Impostato ----------");
            lista.add(this.getAccordiServizioParteComune());
            if (StringUtils.isNotBlank((String)this.getSearch().getNomeServizio())) {
                lista.add(this.getAzioni());
            }
            lista.add(this.getErogazioniServizio());
            lista.add(this.getFruizioniServizio());
        }
        catch (Exception e) {
            log.error("Errore durante la ricerca delle Configurazioni: " + e.getMessage(), (Throwable)e);
        }
        return lista;
    }

    private IExpression createPDExpression(IServiceSearchWithId<?, ?> dao, ConfigurazioniGeneraliSearchForm searchForm, boolean count) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException, CoreException, UserInvalidException {
        IExpression expr = dao.newExpression();
        if (searchForm == null) {
            return expr;
        }
        expr.and();
        expr.isNotNull(PortaDelegata.model().TIPO_SOGGETTO_EROGATORE);
        expr.isNotNull(PortaDelegata.model().NOME_SOGGETTO_EROGATORE);
        expr.isNotNull(PortaDelegata.model().TIPO_SERVIZIO);
        expr.isNotNull(PortaDelegata.model().NOME_SERVIZIO);
        expr.isNotNull(PortaDelegata.model().VERSIONE_SERVIZIO);
        if (searchForm.getPermessiUtenteOperatore() != null) {
            IExpression permessi = searchForm.getPermessiUtenteOperatore().toExpressionConfigurazioneServizi(dao, PortaDelegata.model().ID_SOGGETTO.TIPO, PortaDelegata.model().ID_SOGGETTO.NOME, PortaDelegata.model().TIPO_SOGGETTO_EROGATORE, PortaDelegata.model().NOME_SOGGETTO_EROGATORE, PortaDelegata.model().TIPO_SERVIZIO, PortaDelegata.model().NOME_SERVIZIO, PortaDelegata.model().VERSIONE_SERVIZIO, false);
            expr.and(new IExpression[]{permessi});
        }
        String protocollo = null;
        if (searchForm.isSetFiltroProtocollo()) {
            protocollo = searchForm.getProtocollo();
            this.impostaTipiCompatibiliConProtocollo(dao, PortaDelegata.model(), expr, protocollo);
        }
        if (searchForm.getTipoNomeSoggettoLocale() != null && !StringUtils.isEmpty((String)searchForm.getTipoNomeSoggettoLocale()) && !"--".equals(searchForm.getTipoNomeSoggettoLocale())) {
            String tipoSoggettoDestinatario = searchForm.getTipoSoggettoLocale();
            String nomeSoggettoDestinatario = searchForm.getSoggettoLocale();
            if (tipoSoggettoDestinatario != null && !"qualsiasi".equals(tipoSoggettoDestinatario)) {
                expr.equals(PortaDelegata.model().ID_SOGGETTO.TIPO, (Object)tipoSoggettoDestinatario);
            }
            if (nomeSoggettoDestinatario != null && !"qualsiasi".equals(nomeSoggettoDestinatario)) {
                expr.equals(PortaDelegata.model().ID_SOGGETTO.NOME, (Object)nomeSoggettoDestinatario);
            }
        }
        if (StringUtils.isNotBlank((String)searchForm.getNomeServizio())) {
            String servizioString = searchForm.getNomeServizio();
            IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)servizioString);
            expr.equals(PortaDelegata.model().TIPO_SOGGETTO_EROGATORE, (Object)idServizio.getSoggettoErogatore().getTipo());
            expr.equals(PortaDelegata.model().NOME_SOGGETTO_EROGATORE, (Object)idServizio.getSoggettoErogatore().getNome());
            expr.equals(PortaDelegata.model().TIPO_SERVIZIO, (Object)idServizio.getTipo());
            expr.equals(PortaDelegata.model().NOME_SERVIZIO, (Object)idServizio.getNome());
            expr.equals(PortaDelegata.model().VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
        }
        expr.notEquals(PortaDelegata.model().MODE_AZIONE, (Object)"delegatedBy");
        if (!count) {
            expr.sortOrder(SortOrder.ASC);
            expr.addOrder(PortaDelegata.model().ID_SOGGETTO.TIPO);
            expr.addOrder(PortaDelegata.model().ID_SOGGETTO.NOME);
            expr.addOrder(PortaDelegata.model().TIPO_SOGGETTO_EROGATORE);
            expr.addOrder(PortaDelegata.model().NOME_SOGGETTO_EROGATORE);
            expr.addOrder(PortaDelegata.model().TIPO_SERVIZIO);
            expr.addOrder(PortaDelegata.model().NOME_SERVIZIO);
            expr.addOrder(PortaDelegata.model().VERSIONE_SERVIZIO);
            expr.addOrder(PortaDelegata.model().NOME_AZIONE);
        }
        return expr;
    }

    private IExpression createPAExpression(IServiceSearchWithId<?, ?> dao, ConfigurazioniGeneraliSearchForm searchForm, boolean count) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException, CoreException, UserInvalidException {
        IExpression expr = dao.newExpression();
        if (searchForm == null) {
            return expr;
        }
        expr.isNotNull(PortaApplicativa.model().TIPO_SERVIZIO);
        expr.isNotNull(PortaApplicativa.model().NOME_SERVIZIO);
        expr.isNotNull(PortaApplicativa.model().VERSIONE_SERVIZIO);
        if (searchForm.getPermessiUtenteOperatore() != null) {
            IExpression permessi = searchForm.getPermessiUtenteOperatore().toExpressionConfigurazioneServizi(dao, PortaApplicativa.model().ID_SOGGETTO.TIPO, PortaApplicativa.model().ID_SOGGETTO.NOME, PortaApplicativa.model().ID_SOGGETTO.TIPO, PortaApplicativa.model().ID_SOGGETTO.NOME, PortaApplicativa.model().TIPO_SERVIZIO, PortaApplicativa.model().NOME_SERVIZIO, PortaApplicativa.model().VERSIONE_SERVIZIO, false);
            expr.and(new IExpression[]{permessi});
        }
        String protocollo = null;
        if (searchForm.isSetFiltroProtocollo()) {
            protocollo = searchForm.getProtocollo();
            this.impostaTipiCompatibiliConProtocollo(dao, PortaApplicativa.model(), expr, protocollo);
        }
        boolean setSoggettoProprietario = false;
        if (searchForm.getTipoNomeSoggettoLocale() != null && !StringUtils.isEmpty((String)searchForm.getTipoNomeSoggettoLocale()) && !"--".equals(searchForm.getTipoNomeSoggettoLocale())) {
            String tipoSoggettoDestinatario = searchForm.getTipoSoggettoLocale();
            String nomeSoggettoDestinatario = searchForm.getSoggettoLocale();
            if (tipoSoggettoDestinatario != null && !"qualsiasi".equals(tipoSoggettoDestinatario)) {
                expr.equals(PortaApplicativa.model().ID_SOGGETTO.TIPO, (Object)tipoSoggettoDestinatario);
            }
            if (nomeSoggettoDestinatario != null && !"qualsiasi".equals(nomeSoggettoDestinatario)) {
                expr.equals(PortaApplicativa.model().ID_SOGGETTO.NOME, (Object)nomeSoggettoDestinatario);
            }
            setSoggettoProprietario = true;
        }
        if (StringUtils.isNotBlank((String)searchForm.getNomeServizio())) {
            String servizioString = searchForm.getNomeServizio();
            IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)servizioString);
            expr.equals(PortaApplicativa.model().TIPO_SERVIZIO, (Object)idServizio.getTipo());
            expr.equals(PortaApplicativa.model().NOME_SERVIZIO, (Object)idServizio.getNome());
            expr.equals(PortaApplicativa.model().VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
            if (!setSoggettoProprietario) {
                expr.equals(PortaApplicativa.model().ID_SOGGETTO.TIPO, (Object)idServizio.getSoggettoErogatore().getTipo());
                expr.equals(PortaApplicativa.model().ID_SOGGETTO.NOME, (Object)idServizio.getSoggettoErogatore().getNome());
            }
        }
        expr.notEquals(PortaApplicativa.model().MODE_AZIONE, (Object)"delegatedBy");
        if (!count) {
            expr.sortOrder(SortOrder.ASC);
            expr.addOrder(PortaApplicativa.model().ID_SOGGETTO.TIPO);
            expr.addOrder(PortaApplicativa.model().ID_SOGGETTO.NOME);
            expr.addOrder(PortaApplicativa.model().TIPO_SERVIZIO);
            expr.addOrder(PortaApplicativa.model().NOME_SERVIZIO);
            expr.addOrder(PortaApplicativa.model().VERSIONE_SERVIZIO);
            expr.addOrder(PortaApplicativa.model().NOME_AZIONE);
        }
        return expr;
    }

    private ConfigurazioneGenerale fromPD(PortaDelegata portaDelegata) {
        ConfigurazioneGenerale configurazioneGenerale = new ConfigurazioneGenerale(portaDelegata.getId(), PddRuolo.DELEGATA);
        configurazioneGenerale.setStato(portaDelegata.getStato());
        try {
            String tipoProtocollo = this.search.getProtocollo();
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tipoProtocollo);
            PorteNamingUtils n = new PorteNamingUtils(protocolFactory);
            configurazioneGenerale.setLabel(n.normalizePD(portaDelegata.getNome()));
            configurazioneGenerale.setProtocollo(tipoProtocollo);
            if (portaDelegata.getNomeAzione() == null) {
                configurazioneGenerale.setAzione("default");
            } else {
                configurazioneGenerale.setAzione(portaDelegata.getNomeAzione());
            }
            configurazioneGenerale.setErogatore(NamingUtils.getLabelSoggetto((String)tipoProtocollo, (String)portaDelegata.getTipoSoggettoErogatore(), (String)portaDelegata.getNomeSoggettoErogatore()));
            configurazioneGenerale.setFruitore(NamingUtils.getLabelSoggetto((String)tipoProtocollo, (String)portaDelegata.getIdSoggetto().getTipo(), (String)portaDelegata.getIdSoggetto().getNome()));
            String labelServizio = NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((String)tipoProtocollo, (String)portaDelegata.getTipoServizio(), (String)portaDelegata.getNomeServizio(), (Integer)portaDelegata.getVersioneServizio());
            configurazioneGenerale.setServizio(labelServizio);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return configurazioneGenerale;
    }

    private ConfigurazioneGenerale fromPA(PortaApplicativa portaApplicativa) {
        ConfigurazioneGenerale configurazioneGenerale = new ConfigurazioneGenerale(portaApplicativa.getId(), PddRuolo.APPLICATIVA);
        configurazioneGenerale.setStato(portaApplicativa.getStato());
        try {
            String tipoProtocollo = this.search.getProtocollo();
            configurazioneGenerale.setProtocollo(tipoProtocollo);
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tipoProtocollo);
            PorteNamingUtils n = new PorteNamingUtils(protocolFactory);
            configurazioneGenerale.setLabel(n.normalizePA(portaApplicativa.getNome()));
            configurazioneGenerale.setErogatore(NamingUtils.getLabelSoggetto((String)tipoProtocollo, (String)portaApplicativa.getIdSoggetto().getTipo(), (String)portaApplicativa.getIdSoggetto().getNome()));
            String labelServizio = NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((String)tipoProtocollo, (String)portaApplicativa.getTipoServizio(), (String)portaApplicativa.getNomeServizio(), (Integer)portaApplicativa.getVersioneServizio());
            configurazioneGenerale.setServizio(labelServizio);
            if (portaApplicativa.getNomeAzione() == null) {
                configurazioneGenerale.setAzione("default");
            } else {
                configurazioneGenerale.setAzione(portaApplicativa.getNomeAzione());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return configurazioneGenerale;
    }

    private void impostaTipiCompatibiliConProtocollo(IServiceSearchWithId<?, ?> dao, PortaDelegataModel model, IExpression expr, String protocollo) throws ExpressionNotImplementedException, ExpressionException {
        IExpression expressionTipoServiziCompatibili = null;
        try {
            if (protocollo != null) {
                expressionTipoServiziCompatibili = DynamicUtilsServiceEngine.getExpressionTipiServiziCompatibiliConProtocollo(dao, (IField)model.TIPO_SERVIZIO, (String)protocollo);
            }
        }
        catch (Exception e) {
            log.error("Si e' verificato un errore durante il calcolo dei tipi servizio compatibili con il protocollo scelto: " + e.getMessage(), (Throwable)e);
        }
        if (expressionTipoServiziCompatibili != null) {
            expr.and(new IExpression[]{expressionTipoServiziCompatibili});
        }
        IExpression expressionTipoSoggettiMittenteCompatibili = null;
        try {
            if (protocollo != null) {
                expressionTipoSoggettiMittenteCompatibili = DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(dao, (IField)model.ID_SOGGETTO.TIPO, (String)protocollo);
            }
        }
        catch (Exception e) {
            log.error("Si e' verificato un errore durante il calcolo dei tipi soggetto mittente compatibili con il protocollo scelto: " + e.getMessage(), (Throwable)e);
        }
        if (expressionTipoSoggettiMittenteCompatibili != null) {
            expr.and(new IExpression[]{expressionTipoSoggettiMittenteCompatibili});
        }
        IExpression expressionTipoSoggettiDestinatarioCompatibili = null;
        try {
            if (protocollo != null) {
                expressionTipoSoggettiDestinatarioCompatibili = DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(dao, (IField)model.TIPO_SOGGETTO_EROGATORE, (String)protocollo);
            }
        }
        catch (Exception e) {
            log.error("Si e' verificato un errore durante il calcolo dei tipi soggetto destinatario compatibili con il protocollo scelto: " + e.getMessage(), (Throwable)e);
        }
        if (expressionTipoSoggettiDestinatarioCompatibili != null) {
            expr.and(new IExpression[]{expressionTipoSoggettiDestinatarioCompatibili});
        }
    }

    private void impostaTipiCompatibiliConProtocollo(IServiceSearchWithId<?, ?> dao, PortaApplicativaModel model, IExpression expr, String protocollo) throws ExpressionNotImplementedException, ExpressionException {
        IExpression expressionTipoServiziCompatibili = null;
        try {
            if (protocollo != null) {
                expressionTipoServiziCompatibili = DynamicUtilsServiceEngine.getExpressionTipiServiziCompatibiliConProtocollo(dao, (IField)model.TIPO_SERVIZIO, (String)protocollo);
            }
        }
        catch (Exception e) {
            log.error("Si e' verificato un errore durante il calcolo dei tipi servizio compatibili con il protocollo scelto: " + e.getMessage(), (Throwable)e);
        }
        if (expressionTipoServiziCompatibili != null) {
            expr.and(new IExpression[]{expressionTipoServiziCompatibili});
        }
        IExpression expressionTipoSoggettiDestinatarioCompatibili = null;
        try {
            if (protocollo != null) {
                expressionTipoSoggettiDestinatarioCompatibili = DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(dao, (IField)model.ID_SOGGETTO.TIPO, (String)protocollo);
            }
        }
        catch (Exception e) {
            log.error("Si e' verificato un errore durante il calcolo dei tipi soggetto destinatario compatibili con il protocollo scelto: " + e.getMessage(), (Throwable)e);
        }
        if (expressionTipoSoggettiDestinatarioCompatibili != null) {
            expr.and(new IExpression[]{expressionTipoSoggettiDestinatarioCompatibili});
        }
    }

    private DettaglioRateLimiting getDettaglioRateLimiting(String nomePorta, RuoloPolicy ruoloPorta) throws Exception {
        IPaginatedExpression expr = this.attivazionePolicyDAO.newPaginatedExpression();
        expr.equals(AttivazionePolicy.model().FILTRO.RUOLO_PORTA, (Object)ruoloPorta);
        expr.equals(AttivazionePolicy.model().FILTRO.NOME_PORTA, (Object)nomePorta);
        int offset = 0;
        int limit = 1000;
        expr.offset(offset).limit(limit);
        expr.sortOrder(SortOrder.ASC);
        expr.addOrder(AttivazionePolicy.model().ID_POLICY);
        expr.addOrder(AttivazionePolicy.model().ALIAS);
        List l = this.attivazionePolicyDAO.findAll(expr);
        if (l != null && !l.isEmpty()) {
            DettaglioRateLimiting d = new DettaglioRateLimiting();
            for (AttivazionePolicy attivazionePolicy : l) {
                IdPolicy idPolicy = new IdPolicy();
                idPolicy.setNome(attivazionePolicy.getIdPolicy());
                ConfigurazionePolicy cp = (ConfigurazionePolicy)this.configurazionePolicyDAO.get((Object)idPolicy);
                d.addDetail(attivazionePolicy, cp);
            }
            return d;
        }
        return null;
    }

    private List<IDServizio> getListServizi(boolean apiImplSelected, String gruppo, IDAccordo idAccordo, String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String input) throws Exception {
        ArrayList<IDServizio> listIDServizio = null;
        if (!apiImplSelected && (gruppo != null && !"".equals(gruppo) || idAccordo != null)) {
            listIDServizio = new ArrayList<IDServizio>();
            List list = null;
            boolean distinct = true;
            list = PddRuolo.DELEGATA.equals((Object)this.search.getTipologiaTransazioni()) ? this.dynamicUtils.getListaSelectItemsElencoConfigurazioneServiziFruizione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, null, null, input, false, this.search.getPermessiUtenteOperatore(), distinct) : this.dynamicUtils.getListaSelectItemsElencoConfigurazioneServiziErogazione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, input, true, this.search.getPermessiUtenteOperatore(), distinct);
            if (list != null && list.size() > 0) {
                for (SelectItem selectItem : list) {
                    String servizioString = (String)selectItem.getValue();
                    IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)servizioString);
                    listIDServizio.add(idServizio);
                }
            } else {
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues("-", "-", "-", "-", -1);
                listIDServizio.add(idServizio);
            }
        }
        return listIDServizio;
    }

    private void setListServiziPD(boolean apiImplSelected, List<IDServizio> listIDServizio, IExpression pagExpr) throws Exception {
        if (!apiImplSelected && listIDServizio != null && !listIDServizio.isEmpty()) {
            ArrayList<IExpression> exprOrList = new ArrayList<IExpression>();
            for (IDServizio idServizio : listIDServizio) {
                IExpression exprIdServizio = this.portaDelegataDAO.newExpression();
                exprIdServizio.equals(PortaDelegata.model().TIPO_SOGGETTO_EROGATORE, (Object)idServizio.getSoggettoErogatore().getTipo());
                exprIdServizio.equals(PortaDelegata.model().NOME_SOGGETTO_EROGATORE, (Object)idServizio.getSoggettoErogatore().getNome());
                exprIdServizio.equals(PortaDelegata.model().TIPO_SERVIZIO, (Object)idServizio.getTipo());
                exprIdServizio.equals(PortaDelegata.model().NOME_SERVIZIO, (Object)idServizio.getNome());
                exprIdServizio.equals(PortaDelegata.model().VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
                exprOrList.add(exprIdServizio);
            }
            pagExpr.or(exprOrList.toArray(new IExpression[1]));
        }
    }

    private void setListServiziPA(boolean apiImplSelected, List<IDServizio> listIDServizio, IExpression pagExpr) throws Exception {
        if (!apiImplSelected && listIDServizio != null && !listIDServizio.isEmpty()) {
            ArrayList<IExpression> exprOrList = new ArrayList<IExpression>();
            for (IDServizio idServizio : listIDServizio) {
                IExpression exprIdServizio = this.portaApplicativaDAO.newExpression();
                exprIdServizio.equals(PortaApplicativa.model().TIPO_SERVIZIO, (Object)idServizio.getTipo());
                exprIdServizio.equals(PortaApplicativa.model().NOME_SERVIZIO, (Object)idServizio.getNome());
                exprIdServizio.equals(PortaApplicativa.model().VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
                boolean setSoggettoProprietario = false;
                if (this.search.getTipoNomeSoggettoLocale() != null && !StringUtils.isEmpty((String)this.search.getTipoNomeSoggettoLocale()) && !"--".equals(this.search.getTipoNomeSoggettoLocale())) {
                    setSoggettoProprietario = true;
                }
                if (!setSoggettoProprietario) {
                    exprIdServizio.equals(PortaApplicativa.model().ID_SOGGETTO.TIPO, (Object)idServizio.getSoggettoErogatore().getTipo());
                    exprIdServizio.equals(PortaApplicativa.model().ID_SOGGETTO.NOME, (Object)idServizio.getSoggettoErogatore().getNome());
                }
                exprOrList.add(exprIdServizio);
            }
            pagExpr.or(exprOrList.toArray(new IExpression[1]));
        }
    }
}

