/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.dao;

import java.sql.Connection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.statistiche.StatisticaGiornaliera;
import org.openspcoop2.core.statistiche.StatisticaMensile;
import org.openspcoop2.core.statistiche.StatisticaOraria;
import org.openspcoop2.core.statistiche.StatisticaSettimanale;
import org.openspcoop2.core.statistiche.constants.TipoBanda;
import org.openspcoop2.core.statistiche.constants.TipoLatenza;
import org.openspcoop2.core.statistiche.constants.TipoVisualizzazione;
import org.openspcoop2.core.statistiche.dao.IStatisticaGiornalieraServiceSearch;
import org.openspcoop2.core.statistiche.dao.IStatisticaMensileServiceSearch;
import org.openspcoop2.core.statistiche.dao.IStatisticaOrariaServiceSearch;
import org.openspcoop2.core.statistiche.dao.IStatisticaSettimanaleServiceSearch;
import org.openspcoop2.core.statistiche.model.StatisticaContenutiModel;
import org.openspcoop2.core.statistiche.model.StatisticaModel;
import org.openspcoop2.core.statistiche.utils.ProjectInfo;
import org.openspcoop2.core.statistiche.utils.StatisticheUtils;
import org.openspcoop2.core.transazioni.CredenzialeMittente;
import org.openspcoop2.core.transazioni.dao.ICredenzialeMittenteService;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.core.transazioni.utils.credenziali.AbstractCredenzialeList;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeClientAddress;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchApi;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchClientAddress;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchGruppo;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchToken;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchTokenClient;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchTrasporto;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeTokenClient;
import org.openspcoop2.generic_project.beans.ConstantField;
import org.openspcoop2.generic_project.beans.Function;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.Union;
import org.openspcoop2.generic_project.beans.UnionExpression;
import org.openspcoop2.generic_project.dao.IDBServiceUtilities;
import org.openspcoop2.generic_project.dao.IExpressionConstructor;
import org.openspcoop2.generic_project.dao.IServiceSearchWithoutId;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.Index;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.monitor.engine.condition.FilterImpl;
import org.openspcoop2.monitor.engine.constants.Costanti;
import org.openspcoop2.monitor.engine.statistic.StatisticheMensili;
import org.openspcoop2.monitor.engine.statistic.StatisticheSettimanali;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.pdd.config.DynamicClusterManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.PDNDTokenInfo;
import org.openspcoop2.protocol.sdk.PDNDTokenInfoDetails;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.web.monitor.core.bean.BaseSearchForm;
import org.openspcoop2.web.monitor.core.constants.CaseSensitiveMatch;
import org.openspcoop2.web.monitor.core.constants.TipoMatch;
import org.openspcoop2.web.monitor.core.constants.TipologiaRicerca;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.PermessiUtenteOperatore;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.dao.CredenzialiMittenteUtils;
import org.openspcoop2.web.monitor.core.dao.DynamicUtilsServiceEngine;
import org.openspcoop2.web.monitor.core.dao.MBeanUtilsService;
import org.openspcoop2.web.monitor.core.datamodel.Res;
import org.openspcoop2.web.monitor.core.datamodel.ResBase;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione3D;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione3DCustom;
import org.openspcoop2.web.monitor.core.datamodel.ResLive;
import org.openspcoop2.web.monitor.core.exception.UserInvalidException;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.thread.ThreadExecutorManager;
import org.openspcoop2.web.monitor.core.utils.ParseUtility;
import org.openspcoop2.web.monitor.statistiche.bean.DimensioneCustom;
import org.openspcoop2.web.monitor.statistiche.bean.NumeroDimensioni;
import org.openspcoop2.web.monitor.statistiche.bean.StatistichePersonalizzateSearchForm;
import org.openspcoop2.web.monitor.statistiche.bean.StatsSearchForm;
import org.openspcoop2.web.monitor.statistiche.dao.IStatisticheGiornaliere;
import org.openspcoop2.web.monitor.statistiche.utils.ExportUtils;
import org.openspcoop2.web.monitor.statistiche.utils.StatsUtils;
import org.slf4j.Logger;

public class StatisticheGiornaliereService
implements IStatisticheGiornaliere {
    private static Logger log = LoggerManager.getPddMonitorSqlLogger();
    private boolean timeoutEvent = false;
    private Integer timeoutRicerche = null;
    private static final String FALSA_UNION_DEFAULT_VALUE = "gbyfake";
    private static final Integer FALSA_UNION_DEFAULT_VALUE_INT = -99999;
    private static final Integer FALSA_UNION_DEFAULT_VALUE_VERSIONE = 1;
    private static Date FALSA_UNION_DEFAULT_VALUE_TIMESTAMP = null;
    private static final String ALIAS_FIELD_DATA_3D = "data3d";
    private static final String ALIAS_FIELD_DATA_3D_CUSTOM = "c3d_";
    private StatsSearchForm andamentoTemporaleSearch;
    private StatsSearchForm distribErroriSearch;
    private StatsSearchForm distribSoggettoSearch;
    private StatsSearchForm distribServizioSearch;
    private StatsSearchForm distribAzioneSearch;
    private StatsSearchForm distribSaSearch;
    private StatistichePersonalizzateSearchForm statistichePersonalizzateSearch;
    private org.openspcoop2.core.commons.search.dao.IServiceManager utilsServiceManager;
    private IServiceManager pluginsServiceManager;
    private org.openspcoop2.core.statistiche.dao.IServiceManager transazioniStatisticheServiceManager;
    private DriverRegistroServiziDB driverRegistroServiziDB;
    private DriverConfigurazioneDB driverConfigurazioneDB;
    private IStatisticaGiornalieraServiceSearch statGiornaliereSearchDAO;
    private IStatisticaMensileServiceSearch statMensileSearchDAO;
    private IStatisticaOrariaServiceSearch statOrariaSearchDAO;
    private IStatisticaSettimanaleServiceSearch statSettimanaleSearchDAO;
    private org.openspcoop2.core.transazioni.dao.IServiceManager transazioniServiceManager;
    private ICredenzialeMittenteService credenzialiMittenteDAO;
    private PddMonitorProperties govwayMonitorProperties;
    private boolean useStatisticheGiornaliereCalcoloDistribuzioneSettimanale;
    private boolean useStatisticheGiornaliereCalcoloDistribuzioneMensile;
    private boolean isMediaPesataCalcoloDistribuzioneSettimanaleMensileUtilizzandoStatisticheGiornaliere;
    private boolean clusterDinamico = false;
    private int clusterDinamicoRefresh;
    private IServiceSearchWithoutId<?> dao = null;
    private boolean isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato = false;
    private static final String MESSAGE_3D_CUSTOM_INFORMAZIONE_NON_INDICATA = "Informazione personalizzata non indicata";

    private static void logError(String msg, Throwable e) {
        if (log != null) {
            log.error(msg, e);
        }
    }

    private static void logDebug(String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    private static void logDebug(String msg, Throwable e) {
        if (log != null) {
            log.debug(msg, e);
        }
    }

    public StatisticheGiornaliereService() {
        try {
            this.utilsServiceManager = (org.openspcoop2.core.commons.search.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), log);
            this.pluginsServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance(), log);
            this.transazioniStatisticheServiceManager = (org.openspcoop2.core.statistiche.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), log);
            this.statGiornaliereSearchDAO = this.transazioniStatisticheServiceManager.getStatisticaGiornalieraServiceSearch();
            this.statMensileSearchDAO = this.transazioniStatisticheServiceManager.getStatisticaMensileServiceSearch();
            this.statOrariaSearchDAO = this.transazioniStatisticheServiceManager.getStatisticaOrariaServiceSearch();
            this.statSettimanaleSearchDAO = this.transazioniStatisticheServiceManager.getStatisticaSettimanaleServiceSearch();
            this.transazioniServiceManager = (org.openspcoop2.core.transazioni.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.transazioni.utils.ProjectInfo.getInstance(), log);
            this.credenzialiMittenteDAO = this.transazioniServiceManager.getCredenzialeMittenteService();
            this.govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            this.useStatisticheGiornaliereCalcoloDistribuzioneSettimanale = this.govwayMonitorProperties.isUseStatisticheGiornaliereCalcoloDistribuzioneSettimanale();
            this.useStatisticheGiornaliereCalcoloDistribuzioneMensile = this.govwayMonitorProperties.isUseStatisticheGiornaliereCalcoloDistribuzioneMensile();
            this.isMediaPesataCalcoloDistribuzioneSettimanaleMensileUtilizzandoStatisticheGiornaliere = this.govwayMonitorProperties.isMediaPesataCalcoloDistribuzioneSettimanaleMensileUtilizzandoStatisticheGiornaliere();
            String datasourceJNDIName = DAOFactoryProperties.getInstance((Logger)log).getDatasourceJNDIName((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            Properties datasourceJNDIContext = DAOFactoryProperties.getInstance((Logger)log).getDatasourceJNDIContext((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            String tipoDatabase = DAOFactoryProperties.getInstance((Logger)log).getTipoDatabase((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            this.driverRegistroServiziDB = new DriverRegistroServiziDB(datasourceJNDIName, datasourceJNDIContext, log, tipoDatabase);
            this.driverConfigurazioneDB = new DriverConfigurazioneDB(datasourceJNDIName, datasourceJNDIContext, log, tipoDatabase);
            this.clusterDinamico = this.govwayMonitorProperties.isClusterDinamico();
            if (this.clusterDinamico) {
                this.clusterDinamicoRefresh = this.govwayMonitorProperties.getClusterDinamicoRefresh();
            }
            this.timeoutRicerche = this.govwayMonitorProperties.getIntervalloTimeoutRicercaStatistiche();
            this.isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato = this.govwayMonitorProperties.isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato();
            ExportUtils.setDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato(this.isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
    }

    public StatisticheGiornaliereService(Connection con, boolean autoCommit) {
        this(con, autoCommit, null, log);
    }

    public StatisticheGiornaliereService(Connection con, boolean autoCommit, Logger log) {
        this(con, autoCommit, null, log);
    }

    public StatisticheGiornaliereService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties) {
        this(con, autoCommit, serviceManagerProperties, log);
    }

    public StatisticheGiornaliereService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties, Logger log) {
        try {
            this.utilsServiceManager = (org.openspcoop2.core.commons.search.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, log);
            this.pluginsServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, log);
            this.transazioniStatisticheServiceManager = (org.openspcoop2.core.statistiche.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, log);
            this.statGiornaliereSearchDAO = this.transazioniStatisticheServiceManager.getStatisticaGiornalieraServiceSearch();
            this.statMensileSearchDAO = this.transazioniStatisticheServiceManager.getStatisticaMensileServiceSearch();
            this.statOrariaSearchDAO = this.transazioniStatisticheServiceManager.getStatisticaOrariaServiceSearch();
            this.statSettimanaleSearchDAO = this.transazioniStatisticheServiceManager.getStatisticaSettimanaleServiceSearch();
            this.transazioniServiceManager = (org.openspcoop2.core.transazioni.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.transazioni.utils.ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, log);
            this.credenzialiMittenteDAO = this.transazioniServiceManager.getCredenzialeMittenteService();
            this.govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)StatisticheGiornaliereService.log);
            this.useStatisticheGiornaliereCalcoloDistribuzioneSettimanale = this.govwayMonitorProperties.isUseStatisticheGiornaliereCalcoloDistribuzioneSettimanale();
            this.useStatisticheGiornaliereCalcoloDistribuzioneMensile = this.govwayMonitorProperties.isUseStatisticheGiornaliereCalcoloDistribuzioneMensile();
            this.isMediaPesataCalcoloDistribuzioneSettimanaleMensileUtilizzandoStatisticheGiornaliere = this.govwayMonitorProperties.isMediaPesataCalcoloDistribuzioneSettimanaleMensileUtilizzandoStatisticheGiornaliere();
            String tipoDatabase = serviceManagerProperties != null && serviceManagerProperties.getDatabaseType() != null ? serviceManagerProperties.getDatabaseType() : DAOFactoryProperties.getInstance((Logger)log).getTipoDatabase((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            this.driverRegistroServiziDB = new DriverRegistroServiziDB(con, log, tipoDatabase);
            this.driverConfigurazioneDB = new DriverConfigurazioneDB(con, log, tipoDatabase);
            this.clusterDinamico = this.govwayMonitorProperties.isClusterDinamico();
            if (this.clusterDinamico) {
                this.clusterDinamicoRefresh = this.govwayMonitorProperties.getClusterDinamicoRefresh();
            }
            this.timeoutRicerche = this.govwayMonitorProperties.getIntervalloTimeoutRicercaStatistiche();
            this.isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato = this.govwayMonitorProperties.isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato();
            ExportUtils.setDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato(this.isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
    }

    public StatisticheGiornaliereService(Connection conConfig, Connection conStatistiche, Connection conTransazioni, boolean autoCommit) {
        this(conConfig, conStatistiche, conTransazioni, autoCommit, null, log);
    }

    public StatisticheGiornaliereService(Connection conConfig, Connection conStatistiche, Connection conTransazioni, boolean autoCommit, Logger log) {
        this(conConfig, conStatistiche, conTransazioni, autoCommit, null, log);
    }

    public StatisticheGiornaliereService(Connection conConfig, Connection conStatistiche, Connection conTransazioni, boolean autoCommit, ServiceManagerProperties serviceManagerProperties) {
        this(conConfig, conStatistiche, conTransazioni, autoCommit, serviceManagerProperties, log);
    }

    public StatisticheGiornaliereService(Connection conConfig, Connection conStatistiche, Connection conTransazioni, boolean autoCommit, ServiceManagerProperties serviceManagerProperties, Logger log) {
        try {
            this.utilsServiceManager = (org.openspcoop2.core.commons.search.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), conConfig, autoCommit, serviceManagerProperties, log);
            this.pluginsServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance(), conConfig, autoCommit, serviceManagerProperties, log);
            this.transazioniStatisticheServiceManager = (org.openspcoop2.core.statistiche.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), conStatistiche, autoCommit, serviceManagerProperties, log);
            this.statGiornaliereSearchDAO = this.transazioniStatisticheServiceManager.getStatisticaGiornalieraServiceSearch();
            this.statMensileSearchDAO = this.transazioniStatisticheServiceManager.getStatisticaMensileServiceSearch();
            this.statOrariaSearchDAO = this.transazioniStatisticheServiceManager.getStatisticaOrariaServiceSearch();
            this.statSettimanaleSearchDAO = this.transazioniStatisticheServiceManager.getStatisticaSettimanaleServiceSearch();
            this.transazioniServiceManager = (org.openspcoop2.core.transazioni.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.transazioni.utils.ProjectInfo.getInstance(), conTransazioni, autoCommit, serviceManagerProperties, log);
            this.credenzialiMittenteDAO = this.transazioniServiceManager.getCredenzialeMittenteService();
            this.govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)StatisticheGiornaliereService.log);
            this.useStatisticheGiornaliereCalcoloDistribuzioneSettimanale = this.govwayMonitorProperties.isUseStatisticheGiornaliereCalcoloDistribuzioneSettimanale();
            this.useStatisticheGiornaliereCalcoloDistribuzioneMensile = this.govwayMonitorProperties.isUseStatisticheGiornaliereCalcoloDistribuzioneMensile();
            this.isMediaPesataCalcoloDistribuzioneSettimanaleMensileUtilizzandoStatisticheGiornaliere = this.govwayMonitorProperties.isMediaPesataCalcoloDistribuzioneSettimanaleMensileUtilizzandoStatisticheGiornaliere();
            String tipoDatabase = serviceManagerProperties != null && serviceManagerProperties.getDatabaseType() != null ? serviceManagerProperties.getDatabaseType() : DAOFactoryProperties.getInstance((Logger)log).getTipoDatabase((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            this.driverRegistroServiziDB = new DriverRegistroServiziDB(conConfig, log, tipoDatabase);
            this.driverConfigurazioneDB = new DriverConfigurazioneDB(conConfig, log, tipoDatabase);
            this.clusterDinamico = this.govwayMonitorProperties.isClusterDinamico();
            if (this.clusterDinamico) {
                this.clusterDinamicoRefresh = this.govwayMonitorProperties.getClusterDinamicoRefresh();
            }
            this.timeoutRicerche = this.govwayMonitorProperties.getIntervalloTimeoutRicercaStatistiche();
            this.isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato = this.govwayMonitorProperties.isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato();
            ExportUtils.setDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato(this.isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
    }

    public org.openspcoop2.core.commons.search.dao.IServiceManager getUtilsServiceManager() {
        return this.utilsServiceManager;
    }

    public IServiceManager getPluginsServiceManager() {
        return this.pluginsServiceManager;
    }

    public DriverRegistroServiziDB getDriverRegistroServiziDB() {
        return this.driverRegistroServiziDB;
    }

    public DriverConfigurazioneDB getDriverConfigurazioneDB() {
        return this.driverConfigurazioneDB;
    }

    public void setAndamentoTemporaleSearch(StatsSearchForm andamentoTemporaleSearch) {
        this.andamentoTemporaleSearch = andamentoTemporaleSearch;
    }

    public void setDistribErroriSearch(StatsSearchForm distribErroriSearch) {
        this.distribErroriSearch = distribErroriSearch;
    }

    public void setDistribSoggettoSearch(StatsSearchForm distribSoggettoSearch) {
        this.distribSoggettoSearch = distribSoggettoSearch;
    }

    public void setDistribServizioSearch(StatsSearchForm distribServizioSearch) {
        this.distribServizioSearch = distribServizioSearch;
    }

    public void setDistribAzioneSearch(StatsSearchForm distribAzioneSearch) {
        this.distribAzioneSearch = distribAzioneSearch;
    }

    public void setDistribSaSearch(StatsSearchForm distribSaSearch) {
        this.distribSaSearch = distribSaSearch;
    }

    public void setStatistichePersonalizzateSearch(StatistichePersonalizzateSearchForm statistichePersonalizzateSearch) {
        this.statistichePersonalizzateSearch = statistichePersonalizzateSearch;
    }

    public StatsSearchForm getDistribErroriSearch() {
        return this.distribErroriSearch;
    }

    public StatsSearchForm getDistribSoggettoSearch() {
        return this.distribSoggettoSearch;
    }

    public StatsSearchForm getDistribServizioSearch() {
        return this.distribServizioSearch;
    }

    public StatsSearchForm getDistribAzioneSearch() {
        return this.distribAzioneSearch;
    }

    public StatsSearchForm getDistribSaSearch() {
        return this.distribSaSearch;
    }

    public List<ResBase> findAll(int start, int limit) {
        return null;
    }

    public int totalCount() {
        return 0;
    }

    public void delete(StatisticaGiornaliera obj) throws Exception {
    }

    public void deleteById(Integer key) {
    }

    public List<ResBase> findAll() {
        return null;
    }

    public StatisticaGiornaliera findById(Long key) {
        return null;
    }

    public void store(StatisticaGiornaliera obj) throws Exception {
    }

    public void delete(ResBase obj) throws Exception {
    }

    public ResBase findById(Integer key) {
        return null;
    }

    public void store(ResBase obj) throws Exception {
    }

    public void deleteAll() throws Exception {
    }

    private List<Index> convertForceIndexList(IModel<?> model, List<String> l) {
        if (l != null && l.size() > 0) {
            ArrayList<Index> li = new ArrayList<Index>();
            for (String index : l) {
                li.add(new Index(model, index));
            }
            return li;
        }
        return null;
    }

    public StatisticType checkStatisticType(StatsSearchForm form) {
        boolean distribuzione3d;
        boolean onlyForCount = true;
        boolean bl = distribuzione3d = form.getNumeroDimensioni() != null && (NumeroDimensioni.DIMENSIONI_3.equals(form.getNumeroDimensioni()) || NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(form.getNumeroDimensioni()));
        if (distribuzione3d) {
            onlyForCount = false;
        }
        return StatsUtils.checkStatisticType(form, onlyForCount);
    }

    @Override
    public int countAllAndamentoTemporale() throws ServiceException {
        try {
            return (int)this.countAndamentoTemporale().longValue();
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            return 0;
        }
    }

    @Override
    public List<Res> findAllAndamentoTemporale(int start, int limit) throws ServiceException {
        List<Res> res = this.executeAndamentoTemporaleSearch(false, true, start, limit);
        return res;
    }

    @Override
    public List<Res> findAllAndamentoTemporale() throws ServiceException {
        List<Res> res = this.executeAndamentoTemporaleSearch(false, false, -1, -1);
        return res;
    }

    private NonNegativeNumber countAndamentoTemporale() throws ServiceException {
        try {
            StatisticType tipologiaSearch = this.andamentoTemporaleSearch.getModalitaTemporale();
            StatisticaModel model = null;
            IStatisticaOrariaServiceSearch dao = null;
            boolean forceUseDistribGiornaliera = false;
            StatisticType tipologia = tipologiaSearch;
            StatisticheSettimanali statisticheSettimanaliUtils = null;
            StatisticheMensili statisticheMensiliUtils = null;
            switch (tipologiaSearch) {
                case ORARIA: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    dao = this.statOrariaSearchDAO;
                    break;
                }
                case GIORNALIERA: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    dao = this.statGiornaliereSearchDAO;
                    break;
                }
                case SETTIMANALE: {
                    forceUseDistribGiornaliera = this.useStatisticheGiornaliereCalcoloDistribuzioneSettimanale;
                    if (forceUseDistribGiornaliera) {
                        model = StatisticaGiornaliera.model().STATISTICA_BASE;
                        dao = this.statGiornaliereSearchDAO;
                        tipologia = StatisticType.GIORNALIERA;
                        statisticheSettimanaliUtils = StatisticheSettimanali.getInstanceForUtils();
                        break;
                    }
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    dao = this.statSettimanaleSearchDAO;
                    break;
                }
                case MENSILE: {
                    forceUseDistribGiornaliera = this.useStatisticheGiornaliereCalcoloDistribuzioneMensile;
                    if (forceUseDistribGiornaliera) {
                        model = StatisticaGiornaliera.model().STATISTICA_BASE;
                        dao = this.statGiornaliereSearchDAO;
                        tipologia = StatisticType.GIORNALIERA;
                        statisticheMensiliUtils = StatisticheMensili.getInstanceForUtils();
                        break;
                    }
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    dao = this.statMensileSearchDAO;
                }
            }
            if (dao == null) {
                throw new ServiceException("DAO unknown");
            }
            if (model == null) {
                throw new ServiceException("Model unknown");
            }
            List<Index> forceIndexes = null;
            try {
                forceIndexes = this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexAndamentoTemporaleCount(tipologia, this.govwayMonitorProperties.getExternalForceIndexRepository()));
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
            IExpression gByExpr = dao.newExpression();
            gByExpr = this.createGenericAndamentoTemporaleExpression(gByExpr, (IServiceSearchWithoutId<?>)dao, model, true);
            TipoVisualizzazione tipoVisualizzazione = this.andamentoTemporaleSearch.getTipoVisualizzazione();
            switch (tipoVisualizzazione) {
                case DIMENSIONE_TRANSAZIONI: 
                case NUMERO_TRANSAZIONI: {
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    List<TipoLatenza> tipiLatenza = this.andamentoTemporaleSearch.getTipiLatenzaImpostati();
                    Iterator<TipoLatenza> iterator = tipiLatenza.iterator();
                    block20: while (iterator.hasNext()) {
                        TipoLatenza tipoLatenza = iterator.next();
                        switch (tipoLatenza) {
                            case LATENZA_PORTA: {
                                gByExpr.isNotNull(model.LATENZA_PORTA);
                                continue block20;
                            }
                            case LATENZA_SERVIZIO: {
                                gByExpr.isNotNull(model.LATENZA_SERVIZIO);
                                continue block20;
                            }
                        }
                        gByExpr.isNotNull(model.LATENZA_TOTALE);
                    }
                    break;
                }
            }
            if (forceIndexes != null && !forceIndexes.isEmpty()) {
                for (Index index : forceIndexes) {
                    gByExpr.addForceIndex(index);
                }
            }
            if (forceUseDistribGiornaliera) {
                List list = null;
                try {
                    FunctionField fCount = new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "somma");
                    list = dao.groupBy(gByExpr, new FunctionField[]{fCount});
                }
                catch (NotFoundException e) {
                    StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente: " + e.getMessage(), e);
                    return new NonNegativeNumber(0L);
                }
                if (list == null || list.isEmpty()) {
                    return new NonNegativeNumber(0L);
                }
                ArrayList<Date> dateFound = new ArrayList<Date>();
                for (Map row : list) {
                    Date data = (Date)row.get(GenericJDBCUtilities.getAlias((Object)model.DATA));
                    Date truncDate = null;
                    truncDate = statisticheSettimanaliUtils != null ? statisticheSettimanaliUtils.truncDate(data, false) : statisticheMensiliUtils.truncDate(data, false);
                    boolean found = false;
                    for (Date date : dateFound) {
                        if (!truncDate.equals(date)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    dateFound.add(truncDate);
                }
                NonNegativeNumber nnn = new NonNegativeNumber((long)dateFound.size());
                return nnn;
            }
            NonNegativeNumber nnn = dao.count(gByExpr);
            return nnn;
        }
        catch (ExpressionException | ExpressionNotImplementedException | NotImplementedException | ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            return new NonNegativeNumber(0L);
        }
    }

    private List<Res> executeAndamentoTemporaleSearch(boolean isCount, boolean isPaginated, int offset, int limit) {
        try {
            List list;
            TipoVisualizzazione tipoVisualizzazione;
            ArrayList<FunctionField> listaFunzioni;
            boolean isBanda_esterna;
            boolean isBanda_interna;
            boolean isBanda_complessiva;
            boolean isBanda;
            boolean isLatenza_porta;
            boolean isLatenza_servizio;
            boolean isLatenza_totale;
            boolean isLatenza;
            List<Index> forceIndexes;
            boolean calcolaSommeMediaPesata;
            StatisticheMensili statisticheMensiliUtils;
            StatisticheSettimanali statisticheSettimanaliUtils;
            boolean forceUseDistribGiornaliera;
            StatisticaModel model;
            block262: {
                StatisticType tipologiaSearch = this.andamentoTemporaleSearch.getModalitaTemporale();
                model = null;
                forceUseDistribGiornaliera = false;
                StatisticType tipologia = tipologiaSearch;
                statisticheSettimanaliUtils = null;
                statisticheMensiliUtils = null;
                calcolaSommeMediaPesata = false;
                switch (tipologiaSearch) {
                    case ORARIA: {
                        model = StatisticaOraria.model().STATISTICA_BASE;
                        this.dao = this.statOrariaSearchDAO;
                        break;
                    }
                    case GIORNALIERA: {
                        model = StatisticaGiornaliera.model().STATISTICA_BASE;
                        this.dao = this.statGiornaliereSearchDAO;
                        break;
                    }
                    case SETTIMANALE: {
                        forceUseDistribGiornaliera = this.useStatisticheGiornaliereCalcoloDistribuzioneSettimanale;
                        if (forceUseDistribGiornaliera) {
                            model = StatisticaGiornaliera.model().STATISTICA_BASE;
                            this.dao = this.statGiornaliereSearchDAO;
                            tipologia = StatisticType.GIORNALIERA;
                            statisticheSettimanaliUtils = StatisticheSettimanali.getInstanceForUtils();
                            calcolaSommeMediaPesata = this.isMediaPesataCalcoloDistribuzioneSettimanaleMensileUtilizzandoStatisticheGiornaliere;
                            break;
                        }
                        model = StatisticaSettimanale.model().STATISTICA_BASE;
                        this.dao = this.statSettimanaleSearchDAO;
                        break;
                    }
                    case MENSILE: {
                        forceUseDistribGiornaliera = this.useStatisticheGiornaliereCalcoloDistribuzioneMensile;
                        if (forceUseDistribGiornaliera) {
                            model = StatisticaGiornaliera.model().STATISTICA_BASE;
                            this.dao = this.statGiornaliereSearchDAO;
                            tipologia = StatisticType.GIORNALIERA;
                            statisticheMensiliUtils = StatisticheMensili.getInstanceForUtils();
                            calcolaSommeMediaPesata = this.isMediaPesataCalcoloDistribuzioneSettimanaleMensileUtilizzandoStatisticheGiornaliere;
                            break;
                        }
                        model = StatisticaMensile.model().STATISTICA_BASE;
                        this.dao = this.statMensileSearchDAO;
                    }
                }
                if (model == null) {
                    throw new Exception("Model sconosciuta");
                }
                if (this.dao == null) {
                    throw new ServiceException("DAO unknown");
                }
                ISQLFieldConverter fieldConverter = ((IDBServiceUtilities)this.dao).getFieldConverter();
                forceIndexes = null;
                try {
                    forceIndexes = this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexAndamentoTemporaleGroupBy(tipologia, this.govwayMonitorProperties.getExternalForceIndexRepository()));
                }
                catch (Exception e) {
                    throw new ServiceException(e.getMessage(), (Throwable)e);
                }
                IExpression gByExpr = this.dao.newExpression();
                this.createGenericAndamentoTemporaleExpression(gByExpr, this.dao, model, isCount);
                isLatenza = false;
                isLatenza_totale = false;
                isLatenza_servizio = false;
                isLatenza_porta = false;
                isBanda = false;
                isBanda_complessiva = false;
                isBanda_interna = false;
                isBanda_esterna = false;
                listaFunzioni = new ArrayList<FunctionField>();
                tipoVisualizzazione = this.andamentoTemporaleSearch.getTipoVisualizzazione();
                block18 : switch (tipoVisualizzazione) {
                    case DIMENSIONE_TRANSAZIONI: {
                        isBanda = true;
                        if (this.andamentoTemporaleSearch.isAndamentoTemporalePerEsiti()) {
                            TipoBanda tipoBanda = this.andamentoTemporaleSearch.getTipoBanda();
                            switch (tipoBanda) {
                                case COMPLESSIVA: {
                                    listaFunzioni.add(new FunctionField(model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA, Function.SUM, "somma_banda_complessiva"));
                                    isBanda_complessiva = true;
                                    break block18;
                                }
                                case INTERNA: {
                                    listaFunzioni.add(new FunctionField(model.DIMENSIONI_BYTES_BANDA_INTERNA, Function.SUM, "somma_banda_interna"));
                                    isBanda_interna = true;
                                    break block18;
                                }
                            }
                            listaFunzioni.add(new FunctionField(model.DIMENSIONI_BYTES_BANDA_ESTERNA, Function.SUM, "somma_banda_esterna"));
                            isBanda_esterna = true;
                            break;
                        }
                        List<TipoBanda> tipiBanda = this.andamentoTemporaleSearch.getTipiBandaImpostati();
                        block73: for (TipoBanda tipoBanda : tipiBanda) {
                            switch (tipoBanda) {
                                case COMPLESSIVA: {
                                    listaFunzioni.add(new FunctionField(model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA, Function.SUM, "somma_banda_complessiva"));
                                    isBanda_complessiva = true;
                                    continue block73;
                                }
                                case INTERNA: {
                                    listaFunzioni.add(new FunctionField(model.DIMENSIONI_BYTES_BANDA_INTERNA, Function.SUM, "somma_banda_interna"));
                                    isBanda_interna = true;
                                    continue block73;
                                }
                            }
                            listaFunzioni.add(new FunctionField(model.DIMENSIONI_BYTES_BANDA_ESTERNA, Function.SUM, "somma_banda_esterna"));
                            isBanda_esterna = true;
                        }
                        break;
                    }
                    case NUMERO_TRANSAZIONI: {
                        listaFunzioni.add(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "somma"));
                        break;
                    }
                    case TEMPO_MEDIO_RISPOSTA: {
                        isLatenza = true;
                        if (this.andamentoTemporaleSearch.isAndamentoTemporalePerEsiti()) {
                            TipoLatenza tipoLatenza = this.andamentoTemporaleSearch.getTipoLatenza();
                            switch (tipoLatenza) {
                                case LATENZA_PORTA: {
                                    gByExpr.isNotNull(model.LATENZA_PORTA);
                                    listaFunzioni.add(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_PORTA, (IField)model.NUMERO_TRANSAZIONI, (String)"somma_latenza_porta"));
                                    isLatenza_porta = true;
                                    if (!calcolaSommeMediaPesata) break block18;
                                    listaFunzioni.add(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "somma_media_pesata"));
                                    break;
                                }
                                case LATENZA_SERVIZIO: {
                                    gByExpr.isNotNull(model.LATENZA_SERVIZIO);
                                    listaFunzioni.add(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_SERVIZIO, (IField)model.NUMERO_TRANSAZIONI, (String)"somma_latenza_servizio"));
                                    isLatenza_servizio = true;
                                    if (!calcolaSommeMediaPesata) break block18;
                                    listaFunzioni.add(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "somma_media_pesata"));
                                    break;
                                }
                                default: {
                                    gByExpr.isNotNull(model.LATENZA_TOTALE);
                                    listaFunzioni.add(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_TOTALE, (IField)model.NUMERO_TRANSAZIONI, (String)"somma_latenza_totale"));
                                    isLatenza_totale = true;
                                    if (!calcolaSommeMediaPesata) break block18;
                                    listaFunzioni.add(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "somma_media_pesata"));
                                    break;
                                }
                            }
                            break;
                        }
                        List<TipoLatenza> tipiLatenza = this.andamentoTemporaleSearch.getTipiLatenzaImpostati();
                        block74: for (TipoLatenza tipoLatenza : tipiLatenza) {
                            switch (tipoLatenza) {
                                case LATENZA_PORTA: {
                                    gByExpr.isNotNull(model.LATENZA_PORTA);
                                    listaFunzioni.add(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_PORTA, (IField)model.NUMERO_TRANSAZIONI, (String)"somma_latenza_porta"));
                                    isLatenza_porta = true;
                                    continue block74;
                                }
                                case LATENZA_SERVIZIO: {
                                    gByExpr.isNotNull(model.LATENZA_SERVIZIO);
                                    listaFunzioni.add(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_SERVIZIO, (IField)model.NUMERO_TRANSAZIONI, (String)"somma_latenza_servizio"));
                                    isLatenza_servizio = true;
                                    continue block74;
                                }
                            }
                            gByExpr.isNotNull(model.LATENZA_TOTALE);
                            listaFunzioni.add(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_TOTALE, (IField)model.NUMERO_TRANSAZIONI, (String)"somma_latenza_totale"));
                            isLatenza_totale = true;
                        }
                        if (!calcolaSommeMediaPesata) break;
                        listaFunzioni.add(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "somma_media_pesata"));
                    }
                }
                list = null;
                this.timeoutEvent = false;
                if (forceIndexes != null && !forceIndexes.isEmpty()) {
                    for (Index index : forceIndexes) {
                        gByExpr.addForceIndex(index);
                    }
                }
                if (!isPaginated) {
                    if (this.timeoutRicerche == null) {
                        try {
                            list = this.dao.groupBy(gByExpr, listaFunzioni.toArray(new FunctionField[listaFunzioni.size()]));
                        }
                        catch (NotFoundException e) {
                            StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente: " + e.getMessage(), e);
                            list = new ArrayList();
                        }
                    } else {
                        try {
                            list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.dao.groupBy(gByExpr, listaFunzioni.toArray(new FunctionField[listaFunzioni.size()]))).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            StatisticheGiornaliereService.logError(e.getMessage(), e);
                            Thread.currentThread().interrupt();
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() instanceof NotFoundException) {
                                StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente: " + e.getMessage(), e);
                                list = new ArrayList();
                                break block262;
                            }
                            if (e.getCause() instanceof ServiceException) {
                                throw (ServiceException)e.getCause();
                            }
                            if (e.getCause() instanceof NotImplementedException) {
                                throw (NotImplementedException)e.getCause();
                            }
                            StatisticheGiornaliereService.logError(e.getMessage(), e);
                        }
                        catch (TimeoutException e) {
                            this.timeoutEvent = true;
                            list = new ArrayList();
                            StatisticheGiornaliereService.logError(e.getMessage(), e);
                        }
                    }
                } else {
                    IPaginatedExpression pagExpr = this.dao.toPaginatedExpression(gByExpr);
                    if (!forceUseDistribGiornaliera) {
                        pagExpr.offset(offset).limit(limit);
                    }
                    if (this.timeoutRicerche == null) {
                        try {
                            list = this.dao.groupBy(pagExpr, listaFunzioni.toArray(new FunctionField[listaFunzioni.size()]));
                        }
                        catch (NotFoundException e) {
                            StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente: " + e.getMessage(), e);
                            list = new ArrayList();
                        }
                    } else {
                        try {
                            list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.dao.groupBy(pagExpr, listaFunzioni.toArray(new FunctionField[listaFunzioni.size()]))).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            StatisticheGiornaliereService.logError(e.getMessage(), e);
                            Thread.currentThread().interrupt();
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() instanceof NotFoundException) {
                                StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente: " + e.getMessage(), e);
                                list = new ArrayList();
                            } else {
                                if (e.getCause() instanceof ServiceException) {
                                    throw (ServiceException)e.getCause();
                                }
                                if (e.getCause() instanceof NotImplementedException) {
                                    throw (NotImplementedException)e.getCause();
                                }
                                StatisticheGiornaliereService.logError(e.getMessage(), e);
                            }
                        }
                        catch (TimeoutException e) {
                            this.timeoutEvent = true;
                            list = new ArrayList();
                            StatisticheGiornaliereService.logError(e.getMessage(), e);
                        }
                    }
                }
            }
            ArrayList<Res> res = new ArrayList<Res>();
            if (list != null) {
                for (Map row : list) {
                    Res r = new Res();
                    Date data = (Date)row.get(GenericJDBCUtilities.getAlias((Object)model.DATA));
                    r.setId(data != null ? Long.valueOf(data.getTime()) : null);
                    r.setRisultato(data);
                    ArrayList<Number> rSommaMediaPesata = new ArrayList<Number>();
                    if (isLatenza) {
                        Number obLT = StatsUtils.converToNumber(row.get("somma_latenza_totale"));
                        Number obLS = StatsUtils.converToNumber(row.get("somma_latenza_servizio"));
                        Number obLP = StatsUtils.converToNumber(row.get("somma_latenza_porta"));
                        Number obSommaMediaPesata = null;
                        if (calcolaSommeMediaPesata) {
                            obSommaMediaPesata = StatsUtils.converToNumber(row.get("somma_media_pesata"));
                        }
                        if (obLT != null) {
                            r.inserisciSomma(obLT);
                            if (calcolaSommeMediaPesata) {
                                rSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                            }
                        } else if (isLatenza_totale) {
                            r.inserisciSomma((Number)0);
                            if (calcolaSommeMediaPesata) {
                                rSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                            }
                        }
                        if (obLS != null) {
                            r.inserisciSomma(obLS);
                            if (calcolaSommeMediaPesata) {
                                rSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                            }
                        } else if (isLatenza_servizio) {
                            r.inserisciSomma((Number)0);
                            if (calcolaSommeMediaPesata) {
                                rSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                            }
                        }
                        if (obLP != null) {
                            r.inserisciSomma(obLP);
                            if (calcolaSommeMediaPesata) {
                                rSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                            }
                        } else if (isLatenza_porta) {
                            r.inserisciSomma((Number)0);
                            if (calcolaSommeMediaPesata) {
                                rSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                            }
                        }
                    } else if (isBanda) {
                        Number obComplessiva = StatsUtils.converToNumber(row.get("somma_banda_complessiva"));
                        Number obInterna = StatsUtils.converToNumber(row.get("somma_banda_interna"));
                        Number obEsterna = StatsUtils.converToNumber(row.get("somma_banda_esterna"));
                        if (obComplessiva != null) {
                            r.inserisciSomma(obComplessiva);
                        } else if (isBanda_complessiva) {
                            r.inserisciSomma((Number)0);
                        }
                        if (obInterna != null) {
                            r.inserisciSomma(obInterna);
                        } else if (isBanda_interna) {
                            r.inserisciSomma((Number)0);
                        }
                        if (obEsterna != null) {
                            r.inserisciSomma(obEsterna);
                        } else if (isBanda_esterna) {
                            r.inserisciSomma((Number)0);
                        }
                    } else {
                        Number somma = StatsUtils.converToNumber(row.get("somma"));
                        if (somma != null) {
                            r.setSomma(somma);
                        } else {
                            r.setSomma((Number)0);
                        }
                    }
                    if (this.andamentoTemporaleSearch.isAndamentoTemporalePerEsiti()) {
                        IExpression expOk = this.dao.newExpression();
                        IExpression expKo = this.dao.newExpression();
                        IExpression expFault = this.dao.newExpression();
                        this.createGenericAndamentoTemporaleExpression(expOk, this.dao, model, isCount, data, false);
                        this.createGenericAndamentoTemporaleExpression(expKo, this.dao, model, isCount, data, false);
                        this.createGenericAndamentoTemporaleExpression(expFault, this.dao, model, isCount, data, false);
                        block39 : switch (tipoVisualizzazione) {
                            case TEMPO_MEDIO_RISPOSTA: {
                                TipoLatenza tipoLatenza = this.andamentoTemporaleSearch.getTipoLatenza();
                                switch (tipoLatenza) {
                                    case LATENZA_PORTA: {
                                        expOk.isNotNull(model.LATENZA_PORTA);
                                        expKo.isNotNull(model.LATENZA_PORTA);
                                        expFault.isNotNull(model.LATENZA_PORTA);
                                        break block39;
                                    }
                                    case LATENZA_SERVIZIO: {
                                        expOk.isNotNull(model.LATENZA_SERVIZIO);
                                        expKo.isNotNull(model.LATENZA_SERVIZIO);
                                        expFault.isNotNull(model.LATENZA_SERVIZIO);
                                        break block39;
                                    }
                                }
                                expOk.isNotNull(model.LATENZA_TOTALE);
                                expKo.isNotNull(model.LATENZA_TOTALE);
                                expFault.isNotNull(model.LATENZA_TOTALE);
                                break;
                            }
                        }
                        if (forceIndexes != null && !forceIndexes.isEmpty()) {
                            for (Index index : forceIndexes) {
                                expOk.addForceIndex(index);
                                expKo.addForceIndex(index);
                                expFault.addForceIndex(index);
                            }
                        }
                        EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)this.andamentoTemporaleSearch.getProtocollo());
                        List esitiOk = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
                        List esitiKo = esitiProperties.getEsitiCodeKo_senzaFaultApplicativo();
                        List esitiFault = esitiProperties.getEsitiCodeFaultApplicativo();
                        expOk.and().in(model.ESITO, (Collection)esitiOk);
                        expKo.and().in(model.ESITO, (Collection)esitiKo);
                        expFault.and().in(model.ESITO, (Collection)esitiFault);
                        List listOk = null;
                        Res rEsito = new Res();
                        rEsito.setId(Long.valueOf(data.getTime()));
                        rEsito.setRisultato(data);
                        ArrayList<Number> rEsitoSommaMediaPesata = new ArrayList<Number>();
                        this.timeoutEvent = false;
                        if (this.timeoutRicerche == null) {
                            try {
                                listOk = this.dao.groupBy(expOk, listaFunzioni.toArray(new FunctionField[listaFunzioni.size()]));
                            }
                            catch (NotFoundException e) {
                                StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente con esiti Ok: " + esitiOk);
                                rEsito.inserisciSomma((Number)0);
                            }
                        } else {
                            try {
                                listOk = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.dao.groupBy(expOk, listaFunzioni.toArray(new FunctionField[listaFunzioni.size()]))).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                            }
                            catch (InterruptedException e) {
                                StatisticheGiornaliereService.logError(e.getMessage(), e);
                                Thread.currentThread().interrupt();
                            }
                            catch (ExecutionException e) {
                                if (e.getCause() instanceof NotFoundException) {
                                    StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente con esiti Ok: " + esitiOk);
                                    rEsito.inserisciSomma((Number)0);
                                } else {
                                    if (e.getCause() instanceof ServiceException) {
                                        throw (ServiceException)e.getCause();
                                    }
                                    if (e.getCause() instanceof NotImplementedException) {
                                        throw (NotImplementedException)e.getCause();
                                    }
                                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                                }
                            }
                            catch (TimeoutException e) {
                                this.timeoutEvent = true;
                                rEsito.inserisciSomma((Number)0);
                                StatisticheGiornaliereService.logError(e.getMessage(), e);
                            }
                        }
                        if (listOk != null && listOk.size() > 0) {
                            if (listOk.size() > 1) {
                                throw new Exception("Expected only one result, found: " + listOk.size());
                            }
                            Map rowOk = (Map)listOk.get(0);
                            if (isLatenza) {
                                Number obLT = StatsUtils.converToNumber(rowOk.get("somma_latenza_totale"));
                                Number obLS = StatsUtils.converToNumber(rowOk.get("somma_latenza_servizio"));
                                Number obLP = StatsUtils.converToNumber(rowOk.get("somma_latenza_porta"));
                                Number obSommaMediaPesata = null;
                                if (calcolaSommeMediaPesata) {
                                    obSommaMediaPesata = StatsUtils.converToNumber(row.get("somma_media_pesata"));
                                }
                                if (obLT != null) {
                                    rEsito.inserisciSomma(obLT);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                } else if (isLatenza_totale) {
                                    rEsito.inserisciSomma((Number)0);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                }
                                if (obLS != null) {
                                    rEsito.inserisciSomma(obLS);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                } else if (isLatenza_servizio) {
                                    rEsito.inserisciSomma((Number)0);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                }
                                if (obLP != null) {
                                    rEsito.inserisciSomma(obLP);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                } else if (isLatenza_porta) {
                                    rEsito.inserisciSomma((Number)0);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                }
                            } else if (isBanda) {
                                Number obComplessiva = StatsUtils.converToNumber(rowOk.get("somma_banda_complessiva"));
                                Number obInterna = StatsUtils.converToNumber(rowOk.get("somma_banda_interna"));
                                Number obEsterna = StatsUtils.converToNumber(rowOk.get("somma_banda_esterna"));
                                if (obComplessiva != null) {
                                    rEsito.inserisciSomma(obComplessiva);
                                } else if (isBanda_complessiva) {
                                    rEsito.inserisciSomma((Number)0);
                                }
                                if (obInterna != null) {
                                    rEsito.inserisciSomma(obInterna);
                                } else if (isBanda_interna) {
                                    rEsito.inserisciSomma((Number)0);
                                }
                                if (obEsterna != null) {
                                    rEsito.inserisciSomma(obEsterna);
                                } else if (isBanda_esterna) {
                                    rEsito.inserisciSomma((Number)0);
                                }
                            } else {
                                Number somma = StatsUtils.converToNumber(rowOk.get("somma"));
                                if (somma != null) {
                                    rEsito.inserisciSomma(somma);
                                } else {
                                    rEsito.inserisciSomma((Number)0);
                                }
                            }
                        } else if (isLatenza && calcolaSommeMediaPesata) {
                            rEsitoSommaMediaPesata.add(0);
                        }
                        List listFaultApplicativo = null;
                        this.timeoutEvent = false;
                        if (this.timeoutRicerche == null) {
                            try {
                                listFaultApplicativo = this.dao.groupBy(expFault, listaFunzioni.toArray(new FunctionField[listaFunzioni.size()]));
                            }
                            catch (NotFoundException e) {
                                StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente con esiti Fault: " + esitiFault);
                                rEsito.inserisciSomma((Number)0);
                            }
                        } else {
                            try {
                                listFaultApplicativo = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.dao.groupBy(expFault, listaFunzioni.toArray(new FunctionField[listaFunzioni.size()]))).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                            }
                            catch (InterruptedException e) {
                                StatisticheGiornaliereService.logError(e.getMessage(), e);
                                Thread.currentThread().interrupt();
                            }
                            catch (ExecutionException e) {
                                if (e.getCause() instanceof NotFoundException) {
                                    StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente con esiti Fault: " + esitiFault);
                                    rEsito.inserisciSomma((Number)0);
                                } else {
                                    if (e.getCause() instanceof ServiceException) {
                                        throw (ServiceException)e.getCause();
                                    }
                                    if (e.getCause() instanceof NotImplementedException) {
                                        throw (NotImplementedException)e.getCause();
                                    }
                                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                                }
                            }
                            catch (TimeoutException e) {
                                this.timeoutEvent = true;
                                rEsito.inserisciSomma((Number)0);
                                StatisticheGiornaliereService.logError(e.getMessage(), e);
                            }
                        }
                        if (listFaultApplicativo != null && listFaultApplicativo.size() > 0) {
                            if (listFaultApplicativo.size() > 1) {
                                throw new Exception("Expected only one result, found: " + listFaultApplicativo.size());
                            }
                            Map rowFault = (Map)listFaultApplicativo.get(0);
                            if (isLatenza) {
                                Number obLT = StatsUtils.converToNumber(rowFault.get("somma_latenza_totale"));
                                Number obLS = StatsUtils.converToNumber(rowFault.get("somma_latenza_servizio"));
                                Number obLP = StatsUtils.converToNumber(rowFault.get("somma_latenza_porta"));
                                Number obSommaMediaPesata = null;
                                if (calcolaSommeMediaPesata) {
                                    obSommaMediaPesata = StatsUtils.converToNumber(row.get("somma_media_pesata"));
                                }
                                if (obLT != null) {
                                    rEsito.inserisciSomma(obLT);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                } else if (isLatenza_totale) {
                                    rEsito.inserisciSomma((Number)0);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                }
                                if (obLS != null) {
                                    rEsito.inserisciSomma(obLS);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                } else if (isLatenza_servizio) {
                                    rEsito.inserisciSomma((Number)0);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                }
                                if (obLP != null) {
                                    rEsito.inserisciSomma(obLP);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                } else if (isLatenza_porta) {
                                    rEsito.inserisciSomma((Number)0);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                }
                            } else if (isBanda) {
                                Number obComplessiva = StatsUtils.converToNumber(rowFault.get("somma_banda_complessiva"));
                                Number obInterna = StatsUtils.converToNumber(rowFault.get("somma_banda_interna"));
                                Number obEsterna = StatsUtils.converToNumber(rowFault.get("somma_banda_esterna"));
                                if (obComplessiva != null) {
                                    rEsito.inserisciSomma(obComplessiva);
                                } else if (isBanda_complessiva) {
                                    rEsito.inserisciSomma((Number)0);
                                }
                                if (obInterna != null) {
                                    rEsito.inserisciSomma(obInterna);
                                } else if (isBanda_interna) {
                                    rEsito.inserisciSomma((Number)0);
                                }
                                if (obEsterna != null) {
                                    rEsito.inserisciSomma(obEsterna);
                                } else if (isBanda_esterna) {
                                    rEsito.inserisciSomma((Number)0);
                                }
                            } else {
                                Number somma = StatsUtils.converToNumber(rowFault.get("somma"));
                                if (somma != null) {
                                    rEsito.inserisciSomma(somma);
                                } else {
                                    rEsito.inserisciSomma((Number)0);
                                }
                            }
                        } else if (isLatenza && calcolaSommeMediaPesata) {
                            rEsitoSommaMediaPesata.add(0);
                        }
                        List listKo = null;
                        this.timeoutEvent = false;
                        if (this.timeoutRicerche == null) {
                            try {
                                listKo = this.dao.groupBy(expKo, listaFunzioni.toArray(new FunctionField[listaFunzioni.size()]));
                            }
                            catch (NotFoundException e) {
                                StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente con esiti Ko: " + esitiKo);
                                rEsito.inserisciSomma((Number)0);
                            }
                        } else {
                            try {
                                listKo = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.dao.groupBy(expKo, listaFunzioni.toArray(new FunctionField[listaFunzioni.size()]))).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                            }
                            catch (InterruptedException e) {
                                StatisticheGiornaliereService.logError(e.getMessage(), e);
                                Thread.currentThread().interrupt();
                            }
                            catch (ExecutionException e) {
                                if (e.getCause() instanceof NotFoundException) {
                                    StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente con esiti Ko: " + esitiKo);
                                    rEsito.inserisciSomma((Number)0);
                                } else {
                                    if (e.getCause() instanceof ServiceException) {
                                        throw (ServiceException)e.getCause();
                                    }
                                    if (e.getCause() instanceof NotImplementedException) {
                                        throw (NotImplementedException)e.getCause();
                                    }
                                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                                }
                            }
                            catch (TimeoutException e) {
                                this.timeoutEvent = true;
                                rEsito.inserisciSomma((Number)0);
                                StatisticheGiornaliereService.logError(e.getMessage(), e);
                            }
                        }
                        if (listKo != null && listKo.size() > 0) {
                            if (listKo.size() > 1) {
                                throw new Exception("Expected only one result, found: " + listKo.size());
                            }
                            Map rowKo = (Map)listKo.get(0);
                            if (isLatenza) {
                                Number obLT = StatsUtils.converToNumber(rowKo.get("somma_latenza_totale"));
                                Number obLS = StatsUtils.converToNumber(rowKo.get("somma_latenza_servizio"));
                                Number obLP = StatsUtils.converToNumber(rowKo.get("somma_latenza_porta"));
                                Number obSommaMediaPesata = null;
                                if (calcolaSommeMediaPesata) {
                                    obSommaMediaPesata = StatsUtils.converToNumber(row.get("somma_media_pesata"));
                                }
                                if (obLT != null) {
                                    rEsito.inserisciSomma(obLT);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                } else if (isLatenza_totale) {
                                    rEsito.inserisciSomma((Number)0);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                }
                                if (obLS != null) {
                                    rEsito.inserisciSomma(obLS);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                } else if (isLatenza_servizio) {
                                    rEsito.inserisciSomma((Number)0);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                }
                                if (obLP != null) {
                                    rEsito.inserisciSomma(obLP);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                } else if (isLatenza_porta) {
                                    rEsito.inserisciSomma((Number)0);
                                    if (calcolaSommeMediaPesata) {
                                        rEsitoSommaMediaPesata.add(obSommaMediaPesata != null ? (Number)obSommaMediaPesata : (Number)0);
                                    }
                                }
                            } else if (isBanda) {
                                Number obComplessiva = StatsUtils.converToNumber(rowKo.get("somma_banda_complessiva"));
                                Number obInterna = StatsUtils.converToNumber(rowKo.get("somma_banda_interna"));
                                Number obEsterna = StatsUtils.converToNumber(rowKo.get("somma_banda_esterna"));
                                if (obComplessiva != null) {
                                    rEsito.inserisciSomma(obComplessiva);
                                } else if (isBanda_complessiva) {
                                    rEsito.inserisciSomma((Number)0);
                                }
                                if (obInterna != null) {
                                    rEsito.inserisciSomma(obInterna);
                                } else if (isBanda_interna) {
                                    rEsito.inserisciSomma((Number)0);
                                }
                                if (obEsterna != null) {
                                    rEsito.inserisciSomma(obEsterna);
                                } else if (isBanda_esterna) {
                                    rEsito.inserisciSomma((Number)0);
                                }
                            } else {
                                Number somma = StatsUtils.converToNumber(rowKo.get("somma"));
                                if (somma != null) {
                                    rEsito.inserisciSomma(somma);
                                } else {
                                    rEsito.inserisciSomma((Number)0);
                                }
                            }
                        } else if (isLatenza && calcolaSommeMediaPesata) {
                            rEsitoSommaMediaPesata.add(0);
                        }
                        if (forceUseDistribGiornaliera) {
                            Date truncDate = null;
                            truncDate = statisticheSettimanaliUtils != null ? statisticheSettimanaliUtils.truncDate(rEsito.getRisultato(), false) : statisticheMensiliUtils.truncDate(rEsito.getRisultato(), false);
                            this.elaboraIntervalloTemporale(truncDate, res, rEsito, isLatenza, rEsitoSommaMediaPesata);
                            continue;
                        }
                        res.add(rEsito);
                        continue;
                    }
                    if (forceUseDistribGiornaliera) {
                        Date truncDate = null;
                        truncDate = statisticheSettimanaliUtils != null ? statisticheSettimanaliUtils.truncDate(r.getRisultato(), false) : statisticheMensiliUtils.truncDate(r.getRisultato(), false);
                        this.elaboraIntervalloTemporale(truncDate, res, r, isLatenza, rSommaMediaPesata);
                        continue;
                    }
                    res.add(r);
                }
            }
            if (forceUseDistribGiornaliera) {
                if (offset <= 0 && res.size() <= limit) {
                    return res;
                }
                ArrayList<Res> resPaginated = new ArrayList<Res>();
                for (int i = 0; i < res.size(); ++i) {
                    if (i < offset) continue;
                    resPaginated.add((Res)res.get(i));
                    if (resPaginated.size() == limit) break;
                }
                return resPaginated;
            }
            return res;
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (NotFoundException e) {
            StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente.");
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (Exception e) {
            if (e != null && e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        return new ArrayList<Res>();
    }

    private void elaboraIntervalloTemporale(Date truncDate, List<Res> res, Res r, boolean isLatenza, List<Number> sommaMediaPesata) throws Exception {
        boolean mediaPesata = this.isMediaPesataCalcoloDistribuzioneSettimanaleMensileUtilizzandoStatisticheGiornaliere;
        int indexFound = -1;
        for (int i = 0; i < res.size(); ++i) {
            Res resCheck = res.get(i);
            if (!resCheck.getRisultato().equals(truncDate)) continue;
            indexFound = i;
            break;
        }
        Res alreadyExistsRes = null;
        if (indexFound >= 0) {
            alreadyExistsRes = res.remove(indexFound);
        }
        if (alreadyExistsRes == null) {
            r.setId(truncDate != null ? Long.valueOf(truncDate.getTime()) : null);
            r.setRisultato(truncDate);
            r.setSommeMediaPesata(sommaMediaPesata);
            res.add(r);
        } else {
            List listaEsistente = alreadyExistsRes.getSomme();
            List sommeMediaPesataEsistente = null;
            List listaNuovo = r.getSomme();
            if (listaEsistente.size() != listaNuovo.size()) {
                throw new Exception("La dimensione dei risultati \u00e8 differente; esistente:" + listaEsistente.size() + ", nuovo:" + listaNuovo.size());
            }
            if (isLatenza && mediaPesata) {
                if (sommaMediaPesata.size() != listaNuovo.size()) {
                    throw new Exception("La dimensione dei risultati rispetto alle somme per la media pesata \u00e8 differente; sommeMediaPesata:" + sommaMediaPesata.size() + ", nuovo:" + listaNuovo.size());
                }
                sommeMediaPesataEsistente = alreadyExistsRes.getSommeMediaPesata();
            }
            Res rEsitoRicalcolato = new Res();
            rEsitoRicalcolato.setId(Long.valueOf(truncDate.getTime()));
            rEsitoRicalcolato.setRisultato(truncDate);
            ArrayList<Long> sommaMediaPesataRicalcolata = new ArrayList<Long>();
            for (int i = 0; i < listaEsistente.size(); ++i) {
                Number nEsistente = (Number)listaEsistente.get(i);
                Number nNuovo = (Number)listaNuovo.get(i);
                if (isLatenza) {
                    if (mediaPesata) {
                        Number nSommaMediaEsistente = (Number)sommeMediaPesataEsistente.get(i);
                        Number nSommaMediaNuovo = sommaMediaPesata.get(i);
                        StatisticheGiornaliereService.logDebug("Latenza gi\u00e0 registrata: " + nEsistente + " per un totale di record " + nSommaMediaEsistente);
                        StatisticheGiornaliereService.logDebug("Latenza nuova: " + nNuovo + " per un totale di record " + nSommaMediaNuovo);
                        Long totale = nSommaMediaEsistente.longValue() + nSommaMediaNuovo.longValue();
                        sommaMediaPesataRicalcolata.add(totale);
                        StatisticheGiornaliereService.logDebug("TOT: " + totale);
                        Long nMediaEsistente = nSommaMediaEsistente.longValue() * nEsistente.longValue();
                        Long nMediaNuovo = nSommaMediaNuovo.longValue() * nNuovo.longValue();
                        Long nMedia = nMediaEsistente + nMediaNuovo;
                        StatisticheGiornaliereService.logDebug("MEDIA: esi " + nMediaEsistente + " + nuovo " + nMediaNuovo + " = " + nMedia);
                        Long nMediaPesata = totale > 0L ? nMedia / totale : 0L;
                        StatisticheGiornaliereService.logDebug("MEDIA PESATA: " + nMediaPesata);
                        rEsitoRicalcolato.inserisciSomma((Number)nMediaPesata);
                        continue;
                    }
                    rEsitoRicalcolato.inserisciSomma((Number)((nEsistente.longValue() + nNuovo.longValue()) / 2L));
                    continue;
                }
                rEsitoRicalcolato.inserisciSomma((Number)(nEsistente.longValue() + nNuovo.longValue()));
            }
            if (isLatenza && mediaPesata) {
                rEsitoRicalcolato.setSommeMediaPesata(sommaMediaPesataRicalcolata);
            }
            res.add(rEsitoRicalcolato);
        }
    }

    private IExpression createGenericAndamentoTemporaleExpression(IExpression expr, IServiceSearchWithoutId<?> dao, StatisticaModel model, boolean isCount) {
        return this.createGenericAndamentoTemporaleExpression(expr, dao, model, isCount, null, true);
    }

    private IExpression createGenericAndamentoTemporaleExpression(IExpression expr, IServiceSearchWithoutId<?> dao, StatisticaModel model, boolean isCount, Date date, boolean setEsito) {
        log.debug("creo  Expression per Andamento Temporale!");
        try {
            IExpression[] orSoggetti;
            List listaSoggettiGestione = this.andamentoTemporaleSearch.getSoggettiGestione();
            if (date == null) {
                expr.between(model.DATA, (Object)this.andamentoTemporaleSearch.getDataInizio(), (Object)this.andamentoTemporaleSearch.getDataFine());
            } else {
                expr.equals(model.DATA, (Object)date);
            }
            StatisticheUtils.selezionaRecordValidi((IExpression)expr, (StatisticaModel)model);
            String protocollo = null;
            if (this.andamentoTemporaleSearch.isSetFiltroProtocollo()) {
                protocollo = this.andamentoTemporaleSearch.getProtocollo();
                this.impostaTipiCompatibiliConProtocollo(dao, model, expr, protocollo, this.andamentoTemporaleSearch.getTipologiaRicercaEnum());
            }
            if (this.andamentoTemporaleSearch.getPermessiUtenteOperatore() != null) {
                IExpression permessi = this.andamentoTemporaleSearch.getPermessiUtenteOperatore().toExpression(dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                expr.and(new IExpression[]{permessi});
            }
            if (Utility.isFiltroDominioAbilitato() && this.andamentoTemporaleSearch.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.andamentoTemporaleSearch.getSoggettoLocale()) && !"--".equals(this.andamentoTemporaleSearch.getSoggettoLocale())) {
                String tipoSoggettoLocale = this.andamentoTemporaleSearch.getTipoSoggettoLocale();
                String nomeSoggettoLocale = this.andamentoTemporaleSearch.getSoggettoLocale();
                String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                expr.and().equals(model.ID_PORTA, (Object)idPorta);
            }
            if (StringUtils.isNotBlank((String)this.andamentoTemporaleSearch.getNomeAzione())) {
                expr.and().equals(model.AZIONE, (Object)this.andamentoTemporaleSearch.getNomeAzione());
            }
            if (StringUtils.isNotBlank((String)this.andamentoTemporaleSearch.getNomeServizio())) {
                IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)this.andamentoTemporaleSearch.getNomeServizio());
                expr.and().equals(model.TIPO_DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getTipo()).equals(model.DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getNome()).equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo()).equals(model.SERVIZIO, (Object)idServizio.getNome()).equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
            }
            EsitoUtils esitoUtils = new EsitoUtils(log, this.andamentoTemporaleSearch.getProtocollo());
            if (setEsito) {
                esitoUtils.setExpression(expr, this.andamentoTemporaleSearch.getEsitoGruppo(), this.andamentoTemporaleSearch.getEsitoDettaglio(), this.andamentoTemporaleSearch.getEsitoDettaglioPersonalizzato(), this.andamentoTemporaleSearch.getEsitoContesto(), this.andamentoTemporaleSearch.isEscludiRichiesteScartate(), model.ESITO, model.ESITO_CONTESTO, dao.newExpression());
            } else {
                esitoUtils.setExpressionContesto(expr, model.ESITO_CONTESTO, this.andamentoTemporaleSearch.getEsitoContesto());
            }
            if (this.andamentoTemporaleSearch.getTipologiaRicercaEnum() == null || TipologiaRicerca.all.equals((Object)this.andamentoTemporaleSearch.getTipologiaRicercaEnum())) {
                boolean trafficoSoggetto = StringUtils.isNotBlank((String)this.andamentoTemporaleSearch.getTrafficoPerSoggetto());
                boolean soggetto = !listaSoggettiGestione.isEmpty();
                String tipoTrafficoSoggetto = null;
                String nomeTrafficoSoggetto = null;
                if (trafficoSoggetto) {
                    tipoTrafficoSoggetto = this.andamentoTemporaleSearch.getTipoTrafficoPerSoggetto();
                    nomeTrafficoSoggetto = this.andamentoTemporaleSearch.getTrafficoPerSoggetto();
                }
                IExpression e1 = dao.newExpression();
                IExpression e2 = dao.newExpression();
                if (trafficoSoggetto && soggetto) {
                    expr.and();
                    if (!listaSoggettiGestione.isEmpty()) {
                        IExpression[] orSoggetti2 = new IExpression[listaSoggettiGestione.size()];
                        IExpression[] orSoggetti22 = new IExpression[listaSoggettiGestione.size()];
                        int i = 0;
                        for (Soggetto sog : listaSoggettiGestione) {
                            IExpression se = dao.newExpression();
                            IExpression se2 = dao.newExpression();
                            se.equals(model.TIPO_MITTENTE, (Object)sog.getTipoSoggetto());
                            se.and().equals(model.MITTENTE, (Object)sog.getNomeSoggetto());
                            orSoggetti2[i] = se;
                            se2.equals(model.TIPO_DESTINATARIO, (Object)sog.getTipoSoggetto());
                            se2.and().equals(model.DESTINATARIO, (Object)sog.getNomeSoggetto());
                            orSoggetti22[i] = se2;
                            ++i;
                        }
                        e1.or(orSoggetti2);
                        e2.or(orSoggetti22);
                    }
                    e1.and().equals(model.TIPO_DESTINATARIO, (Object)tipoTrafficoSoggetto);
                    e1.and().equals(model.DESTINATARIO, (Object)nomeTrafficoSoggetto);
                    e2.and().equals(model.TIPO_MITTENTE, (Object)tipoTrafficoSoggetto);
                    e2.and().equals(model.MITTENTE, (Object)nomeTrafficoSoggetto);
                    expr.or(e1, e2);
                } else if (trafficoSoggetto && !soggetto) {
                    expr.and();
                    e1.equals(model.TIPO_DESTINATARIO, (Object)tipoTrafficoSoggetto);
                    e1.and().equals(model.DESTINATARIO, (Object)nomeTrafficoSoggetto);
                    e2.equals(model.TIPO_MITTENTE, (Object)tipoTrafficoSoggetto);
                    e2.and().equals(model.MITTENTE, (Object)nomeTrafficoSoggetto);
                    expr.or(e1, e2);
                } else if (!trafficoSoggetto && soggetto) {
                    expr.and();
                    if (!listaSoggettiGestione.isEmpty()) {
                        IExpression[] orSoggetti3 = new IExpression[listaSoggettiGestione.size()];
                        IExpression[] orSoggetti2 = new IExpression[listaSoggettiGestione.size()];
                        int i = 0;
                        for (Soggetto sog : listaSoggettiGestione) {
                            IExpression se = dao.newExpression();
                            IExpression se2 = dao.newExpression();
                            se.equals(model.TIPO_MITTENTE, (Object)sog.getTipoSoggetto());
                            se.and().equals(model.MITTENTE, (Object)sog.getNomeSoggetto());
                            orSoggetti3[i] = se;
                            se2.equals(model.TIPO_DESTINATARIO, (Object)sog.getTipoSoggetto());
                            se2.and().equals(model.DESTINATARIO, (Object)sog.getNomeSoggetto());
                            orSoggetti2[i] = se2;
                            ++i;
                        }
                        e1.or(orSoggetti3);
                        e2.or(orSoggetti2);
                    }
                    expr.or(e1, e2);
                }
            } else if (TipologiaRicerca.ingresso.equals((Object)this.andamentoTemporaleSearch.getTipologiaRicercaEnum())) {
                expr.and().equals(model.TIPO_PORTA, (Object)"applicativa");
                if (!listaSoggettiGestione.isEmpty()) {
                    expr.and();
                    orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_DESTINATARIO, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.DESTINATARIO, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    expr.or(orSoggetti);
                }
                boolean ignoreSetMittente = this.isIgnoreSetMittente(this.andamentoTemporaleSearch);
                if (StringUtils.isNotBlank((String)this.andamentoTemporaleSearch.getNomeMittente()) && !ignoreSetMittente) {
                    expr.and().equals(model.TIPO_MITTENTE, (Object)this.andamentoTemporaleSearch.getTipoMittente());
                    expr.and().equals(model.MITTENTE, (Object)this.andamentoTemporaleSearch.getNomeMittente());
                }
            } else {
                expr.and().equals(model.TIPO_PORTA, (Object)"delegata");
                if (!listaSoggettiGestione.isEmpty()) {
                    expr.and();
                    orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_MITTENTE, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.MITTENTE, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    expr.or(orSoggetti);
                }
                if (StringUtils.isNotBlank((String)this.andamentoTemporaleSearch.getNomeDestinatario())) {
                    expr.and().equals(model.TIPO_DESTINATARIO, (Object)this.andamentoTemporaleSearch.getTipoDestinatario());
                    expr.and().equals(model.DESTINATARIO, (Object)this.andamentoTemporaleSearch.getNomeDestinatario());
                }
            }
            this.impostaFiltroDatiMittente(expr, this.andamentoTemporaleSearch, model, isCount);
            this.impostaFiltroGruppo(expr, this.andamentoTemporaleSearch, model, isCount);
            this.impostaFiltroApi(expr, this.andamentoTemporaleSearch, model, isCount);
            this.impostaFiltroIdClusterOrCanale(expr, this.andamentoTemporaleSearch, model, isCount);
            if (date == null) {
                SortOrder s;
                SortOrder sortOrder = s = this.andamentoTemporaleSearch.getSortOrder() != null ? this.andamentoTemporaleSearch.getSortOrder() : SortOrder.ASC;
                if (!isCount) {
                    expr.sortOrder(s).addOrder(model.DATA);
                }
            }
            expr.addGroupBy(model.DATA);
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (CoreException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        return expr;
    }

    public ResLive getEsiti(PermessiUtenteOperatore permessiUtente, Date min, Date max, String periodo, String esitoContesto, String protocolloSelected, String protocolloDefault, TipologiaRicerca tipologiaRicerca) {
        StatisticheGiornaliereService.logDebug("Get Esiti [id porta: " + permessiUtente + "],[ Date Min: " + min + "], [Date Max: " + max + "]");
        try {
            Number somma;
            StatisticaModel model = null;
            IStatisticaGiornalieraServiceSearch dao = null;
            StatisticType tipologia = null;
            boolean forceUseDistribGiornaliera = false;
            if (periodo.equals("Ultimo anno")) {
                forceUseDistribGiornaliera = this.useStatisticheGiornaliereCalcoloDistribuzioneMensile;
                if (forceUseDistribGiornaliera) {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    dao = this.statGiornaliereSearchDAO;
                    tipologia = StatisticType.GIORNALIERA;
                } else {
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    dao = this.statMensileSearchDAO;
                    tipologia = StatisticType.MENSILE;
                }
            } else if (periodo.equals("Ultimi 30 giorni")) {
                forceUseDistribGiornaliera = this.useStatisticheGiornaliereCalcoloDistribuzioneSettimanale;
                if (forceUseDistribGiornaliera) {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    dao = this.statGiornaliereSearchDAO;
                    tipologia = StatisticType.GIORNALIERA;
                } else {
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    dao = this.statSettimanaleSearchDAO;
                    tipologia = StatisticType.SETTIMANALE;
                }
            } else if (periodo.equals("Ultimi 7 giorni")) {
                model = StatisticaGiornaliera.model().STATISTICA_BASE;
                dao = this.statGiornaliereSearchDAO;
                tipologia = StatisticType.GIORNALIERA;
            } else {
                model = StatisticaOraria.model().STATISTICA_BASE;
                dao = this.statOrariaSearchDAO;
                tipologia = StatisticType.ORARIA;
            }
            List<Index> forceIndexes = null;
            try {
                forceIndexes = this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexEsitiLiveGroupBy(tipologia, this.govwayMonitorProperties.getExternalForceIndexRepository()));
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
            String protocolloP = protocolloDefault;
            if (protocolloSelected != null) {
                protocolloP = protocolloSelected;
            }
            EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)protocolloP);
            EsitoUtils esitoUtils = new EsitoUtils(log, protocolloP);
            List esitiOk = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
            List esitiKo = esitiProperties.getEsitiCodeKo_senzaFaultApplicativo();
            List esitiFault = esitiProperties.getEsitiCodeFaultApplicativo();
            IExpression exprOk = dao.newExpression();
            exprOk.between(model.DATA, (Object)min, (Object)max);
            StatisticheUtils.selezionaRecordValidi((IExpression)exprOk, (StatisticaModel)model);
            exprOk.and().in(model.ESITO, (Collection)esitiOk);
            if (permessiUtente != null) {
                IExpression permessi = permessiUtente.toExpression((IExpressionConstructor)dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                exprOk.and(new IExpression[]{permessi});
            }
            esitoUtils.setExpressionContesto(exprOk, model.ESITO_CONTESTO, esitoContesto);
            if (tipologiaRicerca != null) {
                if (TipologiaRicerca.ingresso.equals((Object)tipologiaRicerca)) {
                    exprOk.and().equals(model.TIPO_PORTA, (Object)"applicativa");
                } else if (TipologiaRicerca.uscita.equals((Object)tipologiaRicerca)) {
                    exprOk.and().equals(model.TIPO_PORTA, (Object)"delegata");
                }
            }
            exprOk.addGroupBy(model.DATA);
            IExpression exprFault = dao.newExpression();
            exprFault.between(model.DATA, (Object)min, (Object)max);
            StatisticheUtils.selezionaRecordValidi((IExpression)exprFault, (StatisticaModel)model);
            exprFault.and().in(model.ESITO, (Collection)esitiFault);
            if (permessiUtente != null) {
                IExpression permessi = permessiUtente.toExpression((IExpressionConstructor)dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                exprFault.and(new IExpression[]{permessi});
            }
            esitoUtils.setExpressionContesto(exprFault, model.ESITO_CONTESTO, esitoContesto);
            if (tipologiaRicerca != null) {
                if (TipologiaRicerca.ingresso.equals((Object)tipologiaRicerca)) {
                    exprFault.and().equals(model.TIPO_PORTA, (Object)"applicativa");
                } else if (TipologiaRicerca.uscita.equals((Object)tipologiaRicerca)) {
                    exprFault.and().equals(model.TIPO_PORTA, (Object)"delegata");
                }
            }
            exprFault.addGroupBy(model.DATA);
            IExpression exprKo = dao.newExpression();
            exprKo.between(model.DATA, (Object)min, (Object)max);
            StatisticheUtils.selezionaRecordValidi((IExpression)exprKo, (StatisticaModel)model);
            exprKo.and().in(model.ESITO, (Collection)esitiKo);
            if (permessiUtente != null) {
                IExpression permessi = permessiUtente.toExpression((IExpressionConstructor)dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                exprKo.and(new IExpression[]{permessi});
            }
            esitoUtils.setExpressionContesto(exprKo, model.ESITO_CONTESTO, esitoContesto);
            if (tipologiaRicerca != null) {
                if (TipologiaRicerca.ingresso.equals((Object)tipologiaRicerca)) {
                    exprKo.and().equals(model.TIPO_PORTA, (Object)"applicativa");
                } else if (TipologiaRicerca.uscita.equals((Object)tipologiaRicerca)) {
                    exprKo.and().equals(model.TIPO_PORTA, (Object)"delegata");
                }
            }
            exprKo.addGroupBy(model.DATA);
            if (protocolloSelected != null) {
                this.impostaTipiCompatibiliConProtocollo((IServiceSearchWithoutId<?>)dao, model, exprOk, protocolloSelected, null);
                this.impostaTipiCompatibiliConProtocollo((IServiceSearchWithoutId<?>)dao, model, exprFault, protocolloSelected, null);
                this.impostaTipiCompatibiliConProtocollo((IServiceSearchWithoutId<?>)dao, model, exprKo, protocolloSelected, null);
            }
            if (forceIndexes != null && !forceIndexes.isEmpty()) {
                for (Index index : forceIndexes) {
                    exprOk.addForceIndex(index);
                    exprKo.addForceIndex(index);
                    exprFault.addForceIndex(index);
                }
            }
            Long numOk = 0L;
            Long numFault = 0L;
            Long numKo = 0L;
            FunctionField fSum = new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "somma");
            List list = null;
            try {
                list = dao.groupBy(exprOk, new FunctionField[]{fSum});
            }
            catch (NotFoundException e) {
                StatisticheGiornaliereService.logDebug("Non sono presenti statistiche con esito OK");
            }
            long s = 0L;
            if (list != null && list.size() > 0) {
                for (Map row : list) {
                    somma = StatsUtils.converToNumber(row.get("somma"));
                    if (somma == null) continue;
                    s += somma.longValue();
                }
            }
            numOk = s;
            list = new ArrayList();
            try {
                list = dao.groupBy(exprFault, new FunctionField[]{fSum});
            }
            catch (NotFoundException e) {
                StatisticheGiornaliereService.logDebug("Non sono presenti statistiche con esito Fault");
            }
            s = 0L;
            if (list != null && list.size() > 0) {
                for (Map row : list) {
                    somma = StatsUtils.converToNumber(row.get("somma"));
                    if (somma == null) continue;
                    s += somma.longValue();
                }
            }
            numFault = s;
            list = new ArrayList();
            try {
                list = dao.groupBy(exprKo, new FunctionField[]{fSum});
            }
            catch (NotFoundException e) {
                StatisticheGiornaliereService.logDebug("Non sono presenti statistiche con esito KO");
            }
            s = 0L;
            if (list != null && list.size() > 0) {
                for (Map row : list) {
                    somma = StatsUtils.converToNumber(row.get("somma"));
                    if (somma == null) continue;
                    s += somma.longValue();
                }
            }
            numKo = s;
            return new ResLive(Long.valueOf(numOk), Long.valueOf(numFault), Long.valueOf(numKo), new Date());
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        return new ResLive(Long.valueOf("0"), Long.valueOf("0"), Long.valueOf("0"));
    }

    @Override
    public int countAllDistribuzioneErrori() throws ServiceException {
        try {
            NonNegativeNumber nnn;
            StatisticType tipologia = this.checkStatisticType(this.distribErroriSearch);
            StatisticaModel model = null;
            IStatisticaGiornalieraServiceSearch dao = null;
            switch (tipologia) {
                case GIORNALIERA: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    dao = this.statGiornaliereSearchDAO;
                    break;
                }
                case MENSILE: {
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    dao = this.statMensileSearchDAO;
                    break;
                }
                case ORARIA: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    dao = this.statOrariaSearchDAO;
                    break;
                }
                case SETTIMANALE: {
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    dao = this.statSettimanaleSearchDAO;
                }
            }
            if (dao == null) {
                throw new ServiceException("DAO unknown");
            }
            if (model == null) {
                throw new ServiceException("Model unknown");
            }
            List<Index> forceIndexes = null;
            try {
                forceIndexes = this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexDistribuzioneErroriCount(this.govwayMonitorProperties.getExternalForceIndexRepository()));
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
            IExpression gByExpr = this.createDistribuzioneErroriExpression((IServiceSearchWithoutId<?>)dao, model, true);
            if (forceIndexes != null && !forceIndexes.isEmpty()) {
                for (Index index : forceIndexes) {
                    gByExpr.addForceIndex(index);
                }
            }
            return (nnn = dao.count(gByExpr)) != null ? (int)nnn.longValue() : 0;
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<ResDistribuzione> findAllDistribuzioneErrori() throws ServiceException {
        return this.executeDistribuzioneErrori(null, null);
    }

    @Override
    public List<ResDistribuzione> findAllDistribuzioneErrori(int start, int limit) throws ServiceException {
        return this.executeDistribuzioneErrori(start, limit);
    }

    private IExpression createDistribuzioneErroriExpression(IServiceSearchWithoutId<?> dao, StatisticaModel model, boolean isCount) throws ServiceException {
        IExpression expr = null;
        StatisticheGiornaliereService.logDebug("creo Expression per distribuzione Errori!");
        List listaSoggettiGestione = this.distribErroriSearch.getSoggettiGestione();
        try {
            IExpression[] orSoggetti;
            EsitoUtils esitoUtils = new EsitoUtils(log, this.distribErroriSearch.getProtocollo());
            expr = dao.newExpression();
            expr.between(model.DATA, (Object)this.distribErroriSearch.getDataInizio(), (Object)this.distribErroriSearch.getDataFine());
            StatisticheUtils.selezionaRecordValidi((IExpression)expr, (StatisticaModel)model);
            String protocollo = null;
            if (this.distribErroriSearch.isSetFiltroProtocollo()) {
                protocollo = this.distribErroriSearch.getProtocollo();
                this.impostaTipiCompatibiliConProtocollo(dao, model, expr, protocollo, this.distribErroriSearch.getTipologiaRicercaEnum());
            }
            if (this.distribErroriSearch.getPermessiUtenteOperatore() != null) {
                IExpression permessi = this.distribErroriSearch.getPermessiUtenteOperatore().toExpression(dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                expr.and(new IExpression[]{permessi});
            }
            if (Utility.isFiltroDominioAbilitato() && this.distribErroriSearch.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.distribErroriSearch.getSoggettoLocale()) && !"--".equals(this.distribErroriSearch.getSoggettoLocale())) {
                String tipoSoggettoLocale = this.distribErroriSearch.getTipoSoggettoLocale();
                String nomeSoggettoLocale = this.distribErroriSearch.getSoggettoLocale();
                String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                expr.and().equals(model.ID_PORTA, (Object)idPorta);
            }
            int esitoGruppo = EsitoUtils.ALL_ERROR_VALUE;
            if (this.distribErroriSearch.getEsitoGruppo() != null) {
                int esito = this.distribErroriSearch.getEsitoGruppo();
                if (EsitoUtils.ALL_VALUE != esitoGruppo && EsitoUtils.ALL_OK_VALUE != esitoGruppo) {
                    esitoGruppo = esito;
                }
            }
            esitoUtils.setExpression(expr, Integer.valueOf(esitoGruppo), this.distribErroriSearch.getEsitoDettaglio(), this.distribErroriSearch.getEsitoDettaglioPersonalizzato(), this.distribErroriSearch.getEsitoContesto(), this.distribErroriSearch.isEscludiRichiesteScartate(), model.ESITO, model.ESITO_CONTESTO, dao.newExpression());
            if (this.distribErroriSearch.getTipologiaRicercaEnum() == null || TipologiaRicerca.all.equals((Object)this.distribErroriSearch.getTipologiaRicercaEnum())) {
                boolean trafficoSoggetto = StringUtils.isNotBlank((String)this.distribErroriSearch.getTrafficoPerSoggetto());
                boolean soggetto = !listaSoggettiGestione.isEmpty();
                String tipoTrafficoSoggetto = null;
                String nomeTrafficoSoggetto = null;
                if (trafficoSoggetto) {
                    tipoTrafficoSoggetto = this.distribErroriSearch.getTipoTrafficoPerSoggetto();
                    nomeTrafficoSoggetto = this.distribErroriSearch.getTrafficoPerSoggetto();
                }
                IExpression e1 = dao.newExpression();
                IExpression e2 = dao.newExpression();
                if (trafficoSoggetto && soggetto) {
                    expr.and();
                    if (!listaSoggettiGestione.isEmpty()) {
                        IExpression[] orSoggetti2 = new IExpression[listaSoggettiGestione.size()];
                        IExpression[] orSoggetti22 = new IExpression[listaSoggettiGestione.size()];
                        int i = 0;
                        for (Soggetto sog : listaSoggettiGestione) {
                            IExpression se = dao.newExpression();
                            IExpression se2 = dao.newExpression();
                            se.equals(model.TIPO_MITTENTE, (Object)sog.getTipoSoggetto());
                            se.and().equals(model.MITTENTE, (Object)sog.getNomeSoggetto());
                            orSoggetti2[i] = se;
                            se2.equals(model.TIPO_DESTINATARIO, (Object)sog.getTipoSoggetto());
                            se2.and().equals(model.DESTINATARIO, (Object)sog.getNomeSoggetto());
                            orSoggetti22[i] = se2;
                            ++i;
                        }
                        e1.or(orSoggetti2);
                        e2.or(orSoggetti22);
                    }
                    e1.and().equals(model.TIPO_DESTINATARIO, (Object)tipoTrafficoSoggetto);
                    e1.and().equals(model.DESTINATARIO, (Object)nomeTrafficoSoggetto);
                    e2.and().equals(model.TIPO_MITTENTE, (Object)tipoTrafficoSoggetto);
                    e2.and().equals(model.MITTENTE, (Object)nomeTrafficoSoggetto);
                    expr.or(e1, e2);
                } else if (trafficoSoggetto && !soggetto) {
                    expr.and();
                    e1.equals(model.TIPO_DESTINATARIO, (Object)tipoTrafficoSoggetto);
                    e1.and().equals(model.DESTINATARIO, (Object)nomeTrafficoSoggetto);
                    e2.equals(model.TIPO_MITTENTE, (Object)tipoTrafficoSoggetto);
                    e2.and().equals(model.MITTENTE, (Object)nomeTrafficoSoggetto);
                    expr.or(e1, e2);
                } else if (!trafficoSoggetto && soggetto) {
                    expr.and();
                    if (!listaSoggettiGestione.isEmpty()) {
                        IExpression[] orSoggetti3 = new IExpression[listaSoggettiGestione.size()];
                        IExpression[] orSoggetti2 = new IExpression[listaSoggettiGestione.size()];
                        int i = 0;
                        for (Soggetto sog : listaSoggettiGestione) {
                            IExpression se = dao.newExpression();
                            IExpression se2 = dao.newExpression();
                            se.equals(model.TIPO_MITTENTE, (Object)sog.getTipoSoggetto());
                            se.and().equals(model.MITTENTE, (Object)sog.getNomeSoggetto());
                            orSoggetti3[i] = se;
                            se2.equals(model.TIPO_DESTINATARIO, (Object)sog.getTipoSoggetto());
                            se2.and().equals(model.DESTINATARIO, (Object)sog.getNomeSoggetto());
                            orSoggetti2[i] = se2;
                            ++i;
                        }
                        e1.or(orSoggetti3);
                        e2.or(orSoggetti2);
                    }
                    expr.or(e1, e2);
                }
            } else if (TipologiaRicerca.ingresso.equals((Object)this.distribErroriSearch.getTipologiaRicercaEnum())) {
                expr.and().notEquals(model.TIPO_PORTA, (Object)"delegata");
                if (!listaSoggettiGestione.isEmpty()) {
                    expr.and();
                    orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_DESTINATARIO, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.DESTINATARIO, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    expr.or(orSoggetti);
                }
                boolean ignoreSetMittente = this.isIgnoreSetMittente(this.distribErroriSearch);
                if (StringUtils.isNotBlank((String)this.distribErroriSearch.getNomeMittente()) && !ignoreSetMittente) {
                    expr.and().equals(model.TIPO_MITTENTE, (Object)this.distribErroriSearch.getTipoMittente());
                    expr.and().equals(model.MITTENTE, (Object)this.distribErroriSearch.getNomeMittente());
                }
            } else {
                expr.and().notEquals(model.TIPO_PORTA, (Object)"applicativa");
                if (!listaSoggettiGestione.isEmpty()) {
                    expr.and();
                    orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_MITTENTE, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.MITTENTE, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    expr.or(orSoggetti);
                }
                if (StringUtils.isNotBlank((String)this.distribErroriSearch.getNomeDestinatario())) {
                    expr.and().equals(model.TIPO_DESTINATARIO, (Object)this.distribErroriSearch.getTipoDestinatario());
                    expr.and().equals(model.DESTINATARIO, (Object)this.distribErroriSearch.getNomeDestinatario());
                }
            }
            if (StringUtils.isNotBlank((String)this.distribErroriSearch.getNomeAzione())) {
                expr.and().equals(model.AZIONE, (Object)this.distribSoggettoSearch.getNomeAzione());
            }
            if (StringUtils.isNotBlank((String)this.distribErroriSearch.getNomeServizio())) {
                IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)this.distribErroriSearch.getNomeServizio());
                expr.and().equals(model.TIPO_DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getTipo()).equals(model.DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getNome()).equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo()).equals(model.SERVIZIO, (Object)idServizio.getNome()).equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
            }
            this.impostaFiltroDatiMittente(expr, this.distribErroriSearch, model, isCount);
            this.impostaFiltroGruppo(expr, this.distribErroriSearch, model, isCount);
            this.impostaFiltroApi(expr, this.distribErroriSearch, model, isCount);
            this.impostaFiltroIdClusterOrCanale(expr, this.distribErroriSearch, model, isCount);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                expr.addGroupBy(model.DATA);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                this.impostaGroupByFiltro3dCustom(expr, model, this.distribErroriSearch, this.distribErroriSearch.getNumeroDimensioniCustom());
            }
            expr.addGroupBy(model.ESITO);
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (CoreException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        return expr;
    }

    private List<ResDistribuzione> executeDistribuzioneErrori(Integer start, Integer limit) throws ServiceException {
        try {
            SortOrder s;
            StatisticType tipologia = this.checkStatisticType(this.distribErroriSearch);
            StatisticaModel model = null;
            switch (tipologia) {
                case GIORNALIERA: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    this.dao = this.statGiornaliereSearchDAO;
                    break;
                }
                case MENSILE: {
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    this.dao = this.statMensileSearchDAO;
                    break;
                }
                case ORARIA: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    this.dao = this.statOrariaSearchDAO;
                    break;
                }
                case SETTIMANALE: {
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    this.dao = this.statSettimanaleSearchDAO;
                }
            }
            if (this.dao == null) {
                throw new ServiceException("DAO unknown");
            }
            if (model == null) {
                throw new ServiceException("Model unknown");
            }
            ISQLFieldConverter fieldConverter = ((IDBServiceUtilities)this.dao).getFieldConverter();
            IExpression gByExpr = this.createDistribuzioneErroriExpression(this.dao, model, false);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                s = this.distribErroriSearch.getSortOrder() != null ? this.distribErroriSearch.getSortOrder() : SortOrder.ASC;
                gByExpr.sortOrder(s).addOrder(model.DATA);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                s = this.distribErroriSearch.getSortOrder() != null ? this.distribErroriSearch.getSortOrder() : SortOrder.ASC;
                this.impostaSortOrder3dCustom(gByExpr, model, this.distribErroriSearch, this.distribErroriSearch.getNumeroDimensioniCustom(), s);
            }
            gByExpr.sortOrder(SortOrder.ASC).addOrder(model.ESITO);
            List<Index> forceIndexes = null;
            try {
                forceIndexes = this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexDistribuzioneErroriGroupBy(this.govwayMonitorProperties.getExternalForceIndexRepository()));
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
            if (forceIndexes != null && !forceIndexes.isEmpty()) {
                for (Index index : forceIndexes) {
                    gByExpr.addForceIndex(index);
                }
            }
            UnionExpression unionExpr = new UnionExpression(gByExpr);
            ArrayList<String> aliases3dCustom = new ArrayList<String>();
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                unionExpr.addSelectField(model.DATA, ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                this.impostaSelectField3dCustom(unionExpr, model, this.distribErroriSearch, this.distribErroriSearch.getNumeroDimensioniCustom(), aliases3dCustom);
            }
            String aliasFieldEsito = "esito";
            unionExpr.addSelectField(model.ESITO, aliasFieldEsito);
            IExpression fakeExpr = this.dao.newExpression();
            UnionExpression unionExprFake = new UnionExpression(fakeExpr);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                unionExprFake.addSelectField((IField)new ConstantField(ALIAS_FIELD_DATA_3D, (Object)FALSA_UNION_DEFAULT_VALUE_TIMESTAMP, model.DATA.getFieldType()), ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                this.impostaSelectField3dCustomFake(unionExprFake, model, this.distribErroriSearch, this.distribErroriSearch.getNumeroDimensioniCustom(), aliases3dCustom);
            }
            unionExprFake.addSelectField((IField)new ConstantField(aliasFieldEsito, (Object)FALSA_UNION_DEFAULT_VALUE_INT, model.ESITO.getFieldType()), aliasFieldEsito);
            Union union = new Union();
            union.setUnionAll(true);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                union.addField(ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    union.addField(a3dCustom);
                }
            }
            union.addField(aliasFieldEsito);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                union.addGroupBy(ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    union.addGroupBy(a3dCustom);
                }
            }
            union.addGroupBy(aliasFieldEsito);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                SortOrder s2 = this.distribErroriSearch.getSortOrder() != null ? this.distribErroriSearch.getSortOrder() : SortOrder.ASC;
                union.addOrderBy(ALIAS_FIELD_DATA_3D, s2);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    SortOrder s3 = this.distribErroriSearch.getSortOrder() != null ? this.distribErroriSearch.getSortOrder() : SortOrder.ASC;
                    union.addOrderBy(a3dCustom, s3);
                }
            }
            TipoVisualizzazione tipoVisualizzazione = this.distribErroriSearch.getTipoVisualizzazione();
            String sommaAliasName = "somma";
            String datoParamAliasName = "dato";
            block13 : switch (tipoVisualizzazione) {
                case DIMENSIONE_TRANSAZIONI: {
                    TipoBanda tipoBanda = this.distribErroriSearch.getTipoBanda();
                    union.addOrderBy(sommaAliasName, SortOrder.DESC);
                    union.addField(sommaAliasName, Function.SUM, datoParamAliasName);
                    switch (tipoBanda) {
                        case COMPLESSIVA: {
                            unionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA, Function.SUM, datoParamAliasName));
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_complessiva", (Object)0, model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA.getFieldType()), Function.SUM, datoParamAliasName));
                            break;
                        }
                        case INTERNA: {
                            unionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_INTERNA, Function.SUM, datoParamAliasName));
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_interna", (Object)0, model.DIMENSIONI_BYTES_BANDA_INTERNA.getFieldType()), Function.SUM, datoParamAliasName));
                            break;
                        }
                        case ESTERNA: {
                            unionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_ESTERNA, Function.SUM, datoParamAliasName));
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_esterna", (Object)0, model.DIMENSIONI_BYTES_BANDA_ESTERNA.getFieldType()), Function.SUM, datoParamAliasName));
                        }
                    }
                    break;
                }
                case NUMERO_TRANSAZIONI: {
                    union.addOrderBy(sommaAliasName, SortOrder.DESC);
                    union.addField(sommaAliasName, Function.SUM, datoParamAliasName);
                    unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("numero_transazioni", (Object)0, model.NUMERO_TRANSAZIONI.getFieldType()), Function.SUM, datoParamAliasName));
                    unionExpr.addSelectFunctionField(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, datoParamAliasName));
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    TipoLatenza tipoLatenza = this.distribErroriSearch.getTipoLatenza();
                    union.addOrderBy(sommaAliasName, SortOrder.DESC);
                    union.addField(sommaAliasName, Function.SUM, datoParamAliasName);
                    switch (tipoLatenza) {
                        case LATENZA_PORTA: {
                            fakeExpr.isNotNull(model.LATENZA_PORTA);
                            gByExpr.isNotNull(model.LATENZA_PORTA);
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_porta", (Object)0, model.LATENZA_PORTA.getFieldType()), Function.SUM, datoParamAliasName));
                            unionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_PORTA, (IField)model.NUMERO_TRANSAZIONI, (String)datoParamAliasName));
                            break block13;
                        }
                        case LATENZA_SERVIZIO: {
                            fakeExpr.isNotNull(model.LATENZA_SERVIZIO);
                            gByExpr.isNotNull(model.LATENZA_SERVIZIO);
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_servizio", (Object)0, model.LATENZA_SERVIZIO.getFieldType()), Function.SUM, datoParamAliasName));
                            unionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_SERVIZIO, (IField)model.NUMERO_TRANSAZIONI, (String)datoParamAliasName));
                            break block13;
                        }
                    }
                    fakeExpr.isNotNull(model.LATENZA_TOTALE);
                    gByExpr.isNotNull(model.LATENZA_TOTALE);
                    unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_totale", (Object)0, model.LATENZA_TOTALE.getFieldType()), Function.SUM, datoParamAliasName));
                    unionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_TOTALE, (IField)model.NUMERO_TRANSAZIONI, (String)datoParamAliasName));
                    break;
                }
            }
            ArrayList<ResDistribuzione> res = new ArrayList<ResDistribuzione>();
            if (start != null) {
                union.setOffset(start);
            }
            if (start != null) {
                union.setLimit(limit);
            }
            this.timeoutEvent = false;
            List list = null;
            if (this.timeoutRicerche == null) {
                list = this.dao.union(union, new UnionExpression[]{unionExpr, unionExprFake});
            } else {
                try {
                    list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.dao.union(union, new UnionExpression[]{unionExpr, unionExprFake})).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof NotFoundException) {
                        throw (NotFoundException)e.getCause();
                    }
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                }
            }
            if (list != null) {
                EsitiProperties esitiProperties = null;
                try {
                    esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)this.distribErroriSearch.getProtocollo());
                }
                catch (Exception t) {
                    StatisticheGiornaliereService.logError("EsitiProperties reader non disponibile: " + t.getMessage(), t);
                }
                if (esitiProperties == null) {
                    throw new ServiceException("EsitiProperties unavailable");
                }
                for (Map row : list) {
                    int esito = (Integer)row.get(aliasFieldEsito);
                    if (esito == FALSA_UNION_DEFAULT_VALUE_INT) continue;
                    ResDistribuzione3D r = null;
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                        r = new ResDistribuzione3D();
                        Date data = (Date)row.get(ALIAS_FIELD_DATA_3D);
                        r.setData(data);
                        r.setDataFormattata(StatsUtils.formatDate(tipologia, data));
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribErroriSearch.getNumeroDimensioni())) {
                        r = new ResDistribuzione3DCustom();
                        StringBuilder resFailure = new StringBuilder();
                        try {
                            BooleanNullable bSkip = BooleanNullable.NULL();
                            String customData = this.getCustomData(row, this.distribErroriSearch.getNumeroDimensioniCustom(), this.distribErroriSearch, resFailure, bSkip);
                            if (bSkip != null && bSkip.getValue() != null && bSkip.getValue().booleanValue()) continue;
                            if (customData == null) {
                                if (resFailure.length() <= 0) {
                                    resFailure.append("-?-");
                                }
                                throw new CoreException("Informazione personalizzata non presente");
                            }
                            ((ResDistribuzione3DCustom)r).setDatoCustom(customData);
                        }
                        catch (Exception t) {
                            ((ResDistribuzione3DCustom)r).setDatoCustom("Esito '" + esito + "' - " + resFailure.toString());
                            StatisticheGiornaliereService.logError("Traduzione esito(" + esito + ") '" + resFailure.toString() + "' non riuscita: " + t.getMessage(), t);
                        }
                    } else {
                        r = new ResDistribuzione();
                    }
                    try {
                        r.setRisultato(esitiProperties.getEsitoLabel(Integer.valueOf(esito)));
                    }
                    catch (Exception t) {
                        r.setRisultato("Esito '" + esito + "'");
                        StatisticheGiornaliereService.logError("Traduzione esito '" + esito + "' non riuscita: " + t.getMessage(), t);
                    }
                    try {
                        r.getParentMap().put("0", esitiProperties.getEsitoDescription(Integer.valueOf(esito)));
                    }
                    catch (Exception t) {
                        r.getParentMap().put("0", "");
                        StatisticheGiornaliereService.logError("Traduzione esito '" + esito + "' in descrizione non riuscita: " + t.getMessage(), t);
                    }
                    Number somma = StatsUtils.converToNumber(row.get(sommaAliasName));
                    if (somma != null) {
                        r.setSomma(somma);
                    } else {
                        r.setSomma((Number)0);
                    }
                    res.add((ResDistribuzione)r);
                }
            }
            return res;
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (NotFoundException e) {
            StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente.");
            return new ArrayList<ResDistribuzione>();
        }
    }

    @Override
    public int countAllDistribuzioneSoggetto() throws ServiceException {
        try {
            StatisticType tipologia = this.checkStatisticType(this.distribSoggettoSearch);
            StatisticaModel model = null;
            IStatisticaGiornalieraServiceSearch dao = null;
            switch (tipologia) {
                case GIORNALIERA: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    dao = this.statGiornaliereSearchDAO;
                    break;
                }
                case MENSILE: {
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    dao = this.statMensileSearchDAO;
                    break;
                }
                case ORARIA: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    dao = this.statOrariaSearchDAO;
                    break;
                }
                case SETTIMANALE: {
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    dao = this.statSettimanaleSearchDAO;
                }
            }
            Long countValue = this.countDistribuzioneSoggetto((IServiceSearchWithoutId<?>)dao, model);
            return countValue != null ? countValue.intValue() : 0;
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public List<ResDistribuzione> findAllDistribuzioneSoggetto() throws ServiceException {
        try {
            StatisticType tipologia = this.checkStatisticType(this.distribSoggettoSearch);
            StatisticaModel model = null;
            IStatisticaGiornalieraServiceSearch dao = null;
            switch (tipologia) {
                case GIORNALIERA: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    dao = this.statGiornaliereSearchDAO;
                    break;
                }
                case MENSILE: {
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    dao = this.statMensileSearchDAO;
                    break;
                }
                case ORARIA: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    dao = this.statOrariaSearchDAO;
                    break;
                }
                case SETTIMANALE: {
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    dao = this.statSettimanaleSearchDAO;
                }
            }
            if (dao == null) {
                throw new ServiceException("DAO is null");
            }
            if (model == null) {
                throw new ServiceException("Model is null");
            }
            return this.executeDistribuzioneSoggetto((IServiceSearchWithoutId<?>)dao, model, false, -1, -1);
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (NotFoundException e) {
            StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente.");
        }
        catch (CoreException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        return new ArrayList<ResDistribuzione>();
    }

    @Override
    public List<ResDistribuzione> findAllDistribuzioneSoggetto(int start, int limit) throws ServiceException {
        try {
            StatisticType tipologia = this.checkStatisticType(this.distribSoggettoSearch);
            StatisticaModel model = null;
            IStatisticaGiornalieraServiceSearch dao = null;
            switch (tipologia) {
                case GIORNALIERA: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    dao = this.statGiornaliereSearchDAO;
                    break;
                }
                case MENSILE: {
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    dao = this.statMensileSearchDAO;
                    break;
                }
                case ORARIA: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    dao = this.statOrariaSearchDAO;
                    break;
                }
                case SETTIMANALE: {
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    dao = this.statSettimanaleSearchDAO;
                }
            }
            if (dao == null) {
                throw new ServiceException("DAO is null");
            }
            if (model == null) {
                throw new ServiceException("Model is null");
            }
            return this.executeDistribuzioneSoggetto((IServiceSearchWithoutId<?>)dao, model, true, start, limit);
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (NotFoundException e) {
            StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente.");
        }
        catch (CoreException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        return new ArrayList<ResDistribuzione>();
    }

    private Long countDistribuzioneSoggetto(IServiceSearchWithoutId<?> dao, StatisticaModel model) throws ServiceException {
        log.debug("creo  Expression per distribuzione Soggetto!");
        List listaSoggettiGestione = this.distribSoggettoSearch.getSoggettiGestione();
        try {
            EsitoUtils esitoUtils = new EsitoUtils(log, this.distribSoggettoSearch.getProtocollo());
            List<Index> forceIndexes = null;
            try {
                forceIndexes = this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexDistribuzioneSoggettoCount(this.govwayMonitorProperties.getExternalForceIndexRepository()));
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
            if (this.distribSoggettoSearch.getTipologiaRicercaEnum() == null || TipologiaRicerca.all.equals((Object)this.distribSoggettoSearch.getTipologiaRicercaEnum())) {
                IExpression erogazione_portaApplicativa_Expr = dao.newExpression();
                erogazione_portaApplicativa_Expr.equals(model.TIPO_PORTA, (Object)"applicativa");
                erogazione_portaApplicativa_Expr.and().between(model.DATA, (Object)this.distribSoggettoSearch.getDataInizio(), (Object)this.distribSoggettoSearch.getDataFine());
                StatisticheUtils.selezionaRecordValidi((IExpression)erogazione_portaApplicativa_Expr, (StatisticaModel)model);
                String protocollo = null;
                if (this.distribSoggettoSearch.isSetFiltroProtocollo()) {
                    protocollo = this.distribSoggettoSearch.getProtocollo();
                    this.impostaTipiCompatibiliConProtocollo(dao, model, erogazione_portaApplicativa_Expr, protocollo, this.distribSoggettoSearch.getTipologiaRicercaEnum());
                }
                if (this.distribSoggettoSearch.getPermessiUtenteOperatore() != null) {
                    IExpression permessi = this.distribSoggettoSearch.getPermessiUtenteOperatore().toExpression(dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                    erogazione_portaApplicativa_Expr.and(new IExpression[]{permessi});
                }
                if (Utility.isFiltroDominioAbilitato() && this.distribSoggettoSearch.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.distribSoggettoSearch.getSoggettoLocale()) && !"--".equals(this.distribSoggettoSearch.getSoggettoLocale())) {
                    String tipoSoggettoLocale = this.distribSoggettoSearch.getTipoSoggettoLocale();
                    String nomeSoggettoLocale = this.distribSoggettoSearch.getSoggettoLocale();
                    String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                    erogazione_portaApplicativa_Expr.and().equals(model.ID_PORTA, (Object)idPorta);
                }
                if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeAzione())) {
                    erogazione_portaApplicativa_Expr.and().equals(model.AZIONE, (Object)this.distribSoggettoSearch.getNomeAzione());
                }
                if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeServizio())) {
                    IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)this.distribSoggettoSearch.getNomeServizio());
                    erogazione_portaApplicativa_Expr.and().equals(model.TIPO_DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getTipo()).equals(model.DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getNome()).equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo()).equals(model.SERVIZIO, (Object)idServizio.getNome()).equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
                }
                esitoUtils.setExpression(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch.getEsitoGruppo(), this.distribSoggettoSearch.getEsitoDettaglio(), this.distribSoggettoSearch.getEsitoDettaglioPersonalizzato(), this.distribSoggettoSearch.getEsitoContesto(), this.distribSoggettoSearch.isEscludiRichiesteScartate(), model.ESITO, model.ESITO_CONTESTO, dao.newExpression());
                if (!listaSoggettiGestione.isEmpty()) {
                    erogazione_portaApplicativa_Expr.and();
                    IExpression[] orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_DESTINATARIO, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.DESTINATARIO, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    erogazione_portaApplicativa_Expr.or(orSoggetti);
                }
                if (!this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota() && StringUtils.isNotBlank((String)this.distribSoggettoSearch.getTrafficoPerSoggetto())) {
                    erogazione_portaApplicativa_Expr.and().equals(model.TIPO_MITTENTE, (Object)this.distribSoggettoSearch.getTipoTrafficoPerSoggetto());
                    erogazione_portaApplicativa_Expr.and().equals(model.MITTENTE, (Object)this.distribSoggettoSearch.getTrafficoPerSoggetto());
                }
                IExpression fruizione_portaDelegata_Expr = dao.newExpression();
                fruizione_portaDelegata_Expr.equals(model.TIPO_PORTA, (Object)"delegata");
                fruizione_portaDelegata_Expr.and().between(model.DATA, (Object)this.distribSoggettoSearch.getDataInizio(), (Object)this.distribSoggettoSearch.getDataFine());
                StatisticheUtils.selezionaRecordValidi((IExpression)fruizione_portaDelegata_Expr, (StatisticaModel)model);
                if (StringUtils.isNotEmpty((String)this.distribSoggettoSearch.getProtocollo()) && this.distribSoggettoSearch.isShowListaProtocolli()) {
                    protocollo = this.distribSoggettoSearch.getProtocollo();
                    this.impostaTipiCompatibiliConProtocollo(dao, model, fruizione_portaDelegata_Expr, protocollo, this.distribSoggettoSearch.getTipologiaRicercaEnum());
                }
                if (this.distribSoggettoSearch.getPermessiUtenteOperatore() != null) {
                    IExpression permessi = this.distribSoggettoSearch.getPermessiUtenteOperatore().toExpression(dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                    fruizione_portaDelegata_Expr.and(new IExpression[]{permessi});
                }
                if (Utility.isFiltroDominioAbilitato() && this.distribSoggettoSearch.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.distribSoggettoSearch.getSoggettoLocale()) && !"--".equals(this.distribSoggettoSearch.getSoggettoLocale())) {
                    String tipoSoggettoLocale = this.distribSoggettoSearch.getTipoSoggettoLocale();
                    String nomeSoggettoLocale = this.distribSoggettoSearch.getSoggettoLocale();
                    String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                    fruizione_portaDelegata_Expr.and().equals(model.ID_PORTA, (Object)idPorta);
                }
                if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeAzione())) {
                    fruizione_portaDelegata_Expr.and().equals(model.AZIONE, (Object)this.distribSoggettoSearch.getNomeAzione());
                }
                if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeServizio())) {
                    IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)this.distribSoggettoSearch.getNomeServizio());
                    fruizione_portaDelegata_Expr.and().equals(model.TIPO_DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getTipo()).equals(model.DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getNome()).equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo()).equals(model.SERVIZIO, (Object)idServizio.getNome()).equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
                }
                esitoUtils.setExpression(fruizione_portaDelegata_Expr, this.distribSoggettoSearch.getEsitoGruppo(), this.distribSoggettoSearch.getEsitoDettaglio(), this.distribSoggettoSearch.getEsitoDettaglioPersonalizzato(), this.distribSoggettoSearch.getEsitoContesto(), this.distribSoggettoSearch.isEscludiRichiesteScartate(), model.ESITO, model.ESITO_CONTESTO, dao.newExpression());
                if (!listaSoggettiGestione.isEmpty()) {
                    fruizione_portaDelegata_Expr.and();
                    IExpression[] orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_MITTENTE, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.MITTENTE, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    fruizione_portaDelegata_Expr.or(orSoggetti);
                }
                if (!this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota() && StringUtils.isNotBlank((String)this.distribSoggettoSearch.getTrafficoPerSoggetto())) {
                    fruizione_portaDelegata_Expr.and().equals(model.TIPO_DESTINATARIO, (Object)this.distribSoggettoSearch.getTipoTrafficoPerSoggetto());
                    fruizione_portaDelegata_Expr.and().equals(model.DESTINATARIO, (Object)this.distribSoggettoSearch.getTrafficoPerSoggetto());
                }
                this.impostaFiltroDatiMittente(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                this.impostaFiltroDatiMittente(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
                this.impostaFiltroGruppo(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                this.impostaFiltroGruppo(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
                this.impostaFiltroApi(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                this.impostaFiltroApi(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
                this.impostaFiltroIdClusterOrCanale(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                this.impostaFiltroIdClusterOrCanale(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
                if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        erogazione_portaApplicativa_Expr.addGroupBy(model.DATA);
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        this.impostaGroupByFiltro3dCustom(erogazione_portaApplicativa_Expr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom());
                    }
                    erogazione_portaApplicativa_Expr.notEquals(model.TIPO_MITTENTE, (Object)"-");
                    erogazione_portaApplicativa_Expr.notEquals(model.MITTENTE, (Object)"-");
                    erogazione_portaApplicativa_Expr.addGroupBy(model.TIPO_MITTENTE);
                    erogazione_portaApplicativa_Expr.addGroupBy(model.MITTENTE);
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        fruizione_portaDelegata_Expr.addGroupBy(model.DATA);
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        this.impostaGroupByFiltro3dCustom(fruizione_portaDelegata_Expr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom());
                    }
                    fruizione_portaDelegata_Expr.notEquals(model.TIPO_DESTINATARIO, (Object)"-");
                    fruizione_portaDelegata_Expr.notEquals(model.DESTINATARIO, (Object)"-");
                    fruizione_portaDelegata_Expr.addGroupBy(model.TIPO_DESTINATARIO);
                    fruizione_portaDelegata_Expr.addGroupBy(model.DESTINATARIO);
                } else {
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        erogazione_portaApplicativa_Expr.addGroupBy(model.DATA);
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        this.impostaGroupByFiltro3dCustom(erogazione_portaApplicativa_Expr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom());
                    }
                    erogazione_portaApplicativa_Expr.notEquals(model.TIPO_DESTINATARIO, (Object)"-");
                    erogazione_portaApplicativa_Expr.notEquals(model.DESTINATARIO, (Object)"-");
                    erogazione_portaApplicativa_Expr.addGroupBy(model.TIPO_DESTINATARIO);
                    erogazione_portaApplicativa_Expr.addGroupBy(model.DESTINATARIO);
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        fruizione_portaDelegata_Expr.addGroupBy(model.DATA);
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        this.impostaGroupByFiltro3dCustom(fruizione_portaDelegata_Expr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom());
                    }
                    fruizione_portaDelegata_Expr.notEquals(model.TIPO_MITTENTE, (Object)"-");
                    fruizione_portaDelegata_Expr.notEquals(model.MITTENTE, (Object)"-");
                    fruizione_portaDelegata_Expr.addGroupBy(model.TIPO_MITTENTE);
                    fruizione_portaDelegata_Expr.addGroupBy(model.MITTENTE);
                }
                if (forceIndexes != null && !forceIndexes.isEmpty()) {
                    for (Index index : forceIndexes) {
                        erogazione_portaApplicativa_Expr.addForceIndex(index);
                        fruizione_portaDelegata_Expr.addForceIndex(index);
                    }
                }
                ArrayList<String> aliases3dCustom = new ArrayList<String>();
                UnionExpression erogazione_portaApplicativa_UnionExpr = new UnionExpression(erogazione_portaApplicativa_Expr);
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    erogazione_portaApplicativa_UnionExpr.addSelectField(model.DATA, ALIAS_FIELD_DATA_3D);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    this.impostaSelectField3dCustom(erogazione_portaApplicativa_UnionExpr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom(), aliases3dCustom);
                }
                if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                    erogazione_portaApplicativa_UnionExpr.addSelectField(model.TIPO_MITTENTE, "tipo_soggetto");
                    erogazione_portaApplicativa_UnionExpr.addSelectField(model.MITTENTE, "soggetto");
                } else {
                    erogazione_portaApplicativa_UnionExpr.addSelectField(model.TIPO_DESTINATARIO, "tipo_soggetto");
                    erogazione_portaApplicativa_UnionExpr.addSelectField(model.DESTINATARIO, "soggetto");
                }
                UnionExpression fruizione_portaDelegata_UnionExpr = new UnionExpression(fruizione_portaDelegata_Expr);
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    fruizione_portaDelegata_UnionExpr.addSelectField(model.DATA, ALIAS_FIELD_DATA_3D);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    this.impostaSelectField3dCustom(fruizione_portaDelegata_UnionExpr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom(), aliases3dCustom);
                }
                if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                    fruizione_portaDelegata_UnionExpr.addSelectField(model.TIPO_DESTINATARIO, "tipo_soggetto");
                    fruizione_portaDelegata_UnionExpr.addSelectField(model.DESTINATARIO, "soggetto");
                } else {
                    fruizione_portaDelegata_UnionExpr.addSelectField(model.TIPO_MITTENTE, "tipo_soggetto");
                    fruizione_portaDelegata_UnionExpr.addSelectField(model.MITTENTE, "soggetto");
                }
                Union union = new Union();
                union.setUnionAll(true);
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    union.addField(ALIAS_FIELD_DATA_3D);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    for (String a3dCustom : aliases3dCustom) {
                        union.addField(a3dCustom);
                    }
                }
                union.addField("tipo_soggetto");
                union.addField("soggetto");
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    union.addGroupBy(ALIAS_FIELD_DATA_3D);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    for (String a3dCustom : aliases3dCustom) {
                        union.addGroupBy(a3dCustom);
                    }
                }
                union.addGroupBy("tipo_soggetto");
                union.addGroupBy("soggetto");
                NonNegativeNumber nnn = dao.unionCount(union, new UnionExpression[]{erogazione_portaApplicativa_UnionExpr, fruizione_portaDelegata_UnionExpr});
                return nnn != null ? nnn.longValue() : 0L;
            }
            if (TipologiaRicerca.ingresso.equals((Object)this.distribSoggettoSearch.getTipologiaRicercaEnum())) {
                IExpression erogazione_portaApplicativa_Expr = dao.newExpression();
                erogazione_portaApplicativa_Expr.between(model.DATA, (Object)this.distribSoggettoSearch.getDataInizio(), (Object)this.distribSoggettoSearch.getDataFine());
                StatisticheUtils.selezionaRecordValidi((IExpression)erogazione_portaApplicativa_Expr, (StatisticaModel)model);
                String protocollo = null;
                if (StringUtils.isNotEmpty((String)this.distribSoggettoSearch.getProtocollo()) && this.distribSoggettoSearch.isShowListaProtocolli()) {
                    protocollo = this.distribSoggettoSearch.getProtocollo();
                    this.impostaTipiCompatibiliConProtocollo(dao, model, erogazione_portaApplicativa_Expr, protocollo, this.distribSoggettoSearch.getTipologiaRicercaEnum());
                }
                erogazione_portaApplicativa_Expr.and().equals(model.TIPO_PORTA, (Object)"applicativa");
                if (this.distribSoggettoSearch.getPermessiUtenteOperatore() != null) {
                    IExpression permessi = this.distribSoggettoSearch.getPermessiUtenteOperatore().toExpression(dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                    erogazione_portaApplicativa_Expr.and(new IExpression[]{permessi});
                }
                if (Utility.isFiltroDominioAbilitato() && this.distribSoggettoSearch.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.distribSoggettoSearch.getSoggettoLocale()) && !"--".equals(this.distribSoggettoSearch.getSoggettoLocale())) {
                    String tipoSoggettoLocale = this.distribSoggettoSearch.getTipoSoggettoLocale();
                    String nomeSoggettoLocale = this.distribSoggettoSearch.getSoggettoLocale();
                    String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                    erogazione_portaApplicativa_Expr.and().equals(model.ID_PORTA, (Object)idPorta);
                }
                if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeAzione())) {
                    erogazione_portaApplicativa_Expr.and().equals(model.AZIONE, (Object)this.distribSoggettoSearch.getNomeAzione());
                }
                if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeServizio())) {
                    IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)this.distribSoggettoSearch.getNomeServizio());
                    erogazione_portaApplicativa_Expr.and().equals(model.TIPO_DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getTipo()).equals(model.DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getNome()).equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo()).equals(model.SERVIZIO, (Object)idServizio.getNome()).equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
                }
                esitoUtils.setExpression(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch.getEsitoGruppo(), this.distribSoggettoSearch.getEsitoDettaglio(), this.distribSoggettoSearch.getEsitoDettaglioPersonalizzato(), this.distribSoggettoSearch.getEsitoContesto(), this.distribSoggettoSearch.isEscludiRichiesteScartate(), model.ESITO, model.ESITO_CONTESTO, dao.newExpression());
                if (!listaSoggettiGestione.isEmpty()) {
                    erogazione_portaApplicativa_Expr.and();
                    IExpression[] orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_DESTINATARIO, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.DESTINATARIO, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    erogazione_portaApplicativa_Expr.or(orSoggetti);
                }
                if (!this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                    boolean ignoreSetMittente = this.isIgnoreSetMittente(this.distribSoggettoSearch);
                    if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeMittente()) && !ignoreSetMittente) {
                        erogazione_portaApplicativa_Expr.and().equals(model.TIPO_MITTENTE, (Object)this.distribSoggettoSearch.getTipoMittente());
                        erogazione_portaApplicativa_Expr.and().equals(model.MITTENTE, (Object)this.distribSoggettoSearch.getNomeMittente());
                    }
                }
                this.impostaFiltroDatiMittente(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                this.impostaFiltroGruppo(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                this.impostaFiltroApi(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                this.impostaFiltroIdClusterOrCanale(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    erogazione_portaApplicativa_Expr.addGroupBy(model.DATA);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    this.impostaGroupByFiltro3dCustom(erogazione_portaApplicativa_Expr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom());
                }
                if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                    erogazione_portaApplicativa_Expr.notEquals(model.TIPO_MITTENTE, (Object)"-");
                    erogazione_portaApplicativa_Expr.notEquals(model.MITTENTE, (Object)"-");
                    erogazione_portaApplicativa_Expr.addGroupBy(model.TIPO_MITTENTE);
                    erogazione_portaApplicativa_Expr.addGroupBy(model.MITTENTE);
                } else {
                    erogazione_portaApplicativa_Expr.notEquals(model.TIPO_DESTINATARIO, (Object)"-");
                    erogazione_portaApplicativa_Expr.notEquals(model.DESTINATARIO, (Object)"-");
                    erogazione_portaApplicativa_Expr.addGroupBy(model.TIPO_DESTINATARIO);
                    erogazione_portaApplicativa_Expr.addGroupBy(model.DESTINATARIO);
                }
                if (forceIndexes != null && !forceIndexes.isEmpty()) {
                    for (Index index : forceIndexes) {
                        erogazione_portaApplicativa_Expr.addForceIndex(index);
                    }
                }
                UnionExpression erogazione_portaApplicativa_UnionExpr = new UnionExpression(erogazione_portaApplicativa_Expr);
                ArrayList<String> aliases3dCustom = new ArrayList<String>();
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    erogazione_portaApplicativa_UnionExpr.addSelectField(model.DATA, ALIAS_FIELD_DATA_3D);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    this.impostaSelectField3dCustom(erogazione_portaApplicativa_UnionExpr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom(), aliases3dCustom);
                }
                if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                    erogazione_portaApplicativa_UnionExpr.addSelectField(model.TIPO_MITTENTE, "tipo_soggetto");
                    erogazione_portaApplicativa_UnionExpr.addSelectField(model.MITTENTE, "soggetto");
                } else {
                    erogazione_portaApplicativa_UnionExpr.addSelectField(model.TIPO_DESTINATARIO, "tipo_soggetto");
                    erogazione_portaApplicativa_UnionExpr.addSelectField(model.DESTINATARIO, "soggetto");
                }
                IExpression fakeExpr = dao.newExpression();
                UnionExpression unionExprFake = new UnionExpression(fakeExpr);
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    unionExprFake.addSelectField((IField)new ConstantField(ALIAS_FIELD_DATA_3D, (Object)FALSA_UNION_DEFAULT_VALUE_TIMESTAMP, model.DATA.getFieldType()), ALIAS_FIELD_DATA_3D);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    this.impostaSelectField3dCustomFake(unionExprFake, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom(), aliases3dCustom);
                }
                if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                    unionExprFake.addSelectField((IField)new ConstantField("tipo_soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_MITTENTE.getFieldType()), "tipo_soggetto");
                    unionExprFake.addSelectField((IField)new ConstantField("soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.MITTENTE.getFieldType()), "soggetto");
                } else {
                    unionExprFake.addSelectField((IField)new ConstantField("tipo_soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_DESTINATARIO.getFieldType()), "tipo_soggetto");
                    unionExprFake.addSelectField((IField)new ConstantField("soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.DESTINATARIO.getFieldType()), "soggetto");
                }
                Union union = new Union();
                union.setUnionAll(true);
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    union.addField(ALIAS_FIELD_DATA_3D);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    for (String a3dCustom : aliases3dCustom) {
                        union.addField(a3dCustom);
                    }
                }
                union.addField("tipo_soggetto");
                union.addField("soggetto");
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    union.addGroupBy(ALIAS_FIELD_DATA_3D);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    for (String a3dCustom : aliases3dCustom) {
                        union.addGroupBy(a3dCustom);
                    }
                }
                union.addGroupBy("tipo_soggetto");
                union.addGroupBy("soggetto");
                NonNegativeNumber nnn = dao.unionCount(union, new UnionExpression[]{erogazione_portaApplicativa_UnionExpr, unionExprFake});
                return nnn != null ? nnn.longValue() - 1L : 0L;
            }
            IExpression fruizione_portaDelegata_Expr = dao.newExpression();
            fruizione_portaDelegata_Expr.between(model.DATA, (Object)this.distribSoggettoSearch.getDataInizio(), (Object)this.distribSoggettoSearch.getDataFine());
            StatisticheUtils.selezionaRecordValidi((IExpression)fruizione_portaDelegata_Expr, (StatisticaModel)model);
            String protocollo = null;
            if (StringUtils.isNotEmpty((String)this.distribSoggettoSearch.getProtocollo()) && this.distribSoggettoSearch.isShowListaProtocolli()) {
                protocollo = this.distribSoggettoSearch.getProtocollo();
                this.impostaTipiCompatibiliConProtocollo(dao, model, fruizione_portaDelegata_Expr, protocollo, this.distribSoggettoSearch.getTipologiaRicercaEnum());
            }
            fruizione_portaDelegata_Expr.and().equals(model.TIPO_PORTA, (Object)"delegata");
            if (this.distribSoggettoSearch.getPermessiUtenteOperatore() != null) {
                IExpression permessi = this.distribSoggettoSearch.getPermessiUtenteOperatore().toExpression(dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                fruizione_portaDelegata_Expr.and(new IExpression[]{permessi});
            }
            if (Utility.isFiltroDominioAbilitato() && this.distribSoggettoSearch.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.distribSoggettoSearch.getSoggettoLocale()) && !"--".equals(this.distribSoggettoSearch.getSoggettoLocale())) {
                String tipoSoggettoLocale = this.distribSoggettoSearch.getTipoSoggettoLocale();
                String nomeSoggettoLocale = this.distribSoggettoSearch.getSoggettoLocale();
                String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                fruizione_portaDelegata_Expr.and().equals(model.ID_PORTA, (Object)idPorta);
            }
            if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeAzione())) {
                fruizione_portaDelegata_Expr.and().equals(model.AZIONE, (Object)this.distribSoggettoSearch.getNomeAzione());
            }
            if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeServizio())) {
                IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)this.distribSoggettoSearch.getNomeServizio());
                fruizione_portaDelegata_Expr.and().equals(model.TIPO_DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getTipo()).equals(model.DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getNome()).equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo()).equals(model.SERVIZIO, (Object)idServizio.getNome()).equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
            }
            esitoUtils.setExpression(fruizione_portaDelegata_Expr, this.distribSoggettoSearch.getEsitoGruppo(), this.distribSoggettoSearch.getEsitoDettaglio(), this.distribSoggettoSearch.getEsitoDettaglioPersonalizzato(), this.distribSoggettoSearch.getEsitoContesto(), this.distribSoggettoSearch.isEscludiRichiesteScartate(), model.ESITO, model.ESITO_CONTESTO, dao.newExpression());
            if (!listaSoggettiGestione.isEmpty()) {
                fruizione_portaDelegata_Expr.and();
                IExpression[] orSoggetti = new IExpression[listaSoggettiGestione.size()];
                int i = 0;
                for (Soggetto soggetto : listaSoggettiGestione) {
                    IExpression se = dao.newExpression();
                    se.equals(model.TIPO_MITTENTE, (Object)soggetto.getTipoSoggetto());
                    se.and().equals(model.MITTENTE, (Object)soggetto.getNomeSoggetto());
                    orSoggetti[i] = se;
                    ++i;
                }
                fruizione_portaDelegata_Expr.or(orSoggetti);
            }
            if (!this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota() && StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeDestinatario())) {
                fruizione_portaDelegata_Expr.and().equals(model.TIPO_DESTINATARIO, (Object)this.distribSoggettoSearch.getTipoDestinatario());
                fruizione_portaDelegata_Expr.and().equals(model.DESTINATARIO, (Object)this.distribSoggettoSearch.getNomeDestinatario());
            }
            this.impostaFiltroDatiMittente(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
            this.impostaFiltroGruppo(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
            this.impostaFiltroApi(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
            this.impostaFiltroIdClusterOrCanale(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                fruizione_portaDelegata_Expr.addGroupBy(model.DATA);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                this.impostaGroupByFiltro3dCustom(fruizione_portaDelegata_Expr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom());
            }
            if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                fruizione_portaDelegata_Expr.notEquals(model.TIPO_DESTINATARIO, (Object)"-");
                fruizione_portaDelegata_Expr.notEquals(model.DESTINATARIO, (Object)"-");
                fruizione_portaDelegata_Expr.addGroupBy(model.TIPO_DESTINATARIO);
                fruizione_portaDelegata_Expr.addGroupBy(model.DESTINATARIO);
            } else {
                fruizione_portaDelegata_Expr.notEquals(model.TIPO_MITTENTE, (Object)"-");
                fruizione_portaDelegata_Expr.notEquals(model.MITTENTE, (Object)"-");
                fruizione_portaDelegata_Expr.addGroupBy(model.TIPO_MITTENTE);
                fruizione_portaDelegata_Expr.addGroupBy(model.MITTENTE);
            }
            if (forceIndexes != null && !forceIndexes.isEmpty()) {
                for (Index index : forceIndexes) {
                    fruizione_portaDelegata_Expr.addForceIndex(index);
                }
            }
            UnionExpression fruizione_portaDelegata_UnionExpr = new UnionExpression(fruizione_portaDelegata_Expr);
            ArrayList<String> aliases3dCustom = new ArrayList<String>();
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                fruizione_portaDelegata_UnionExpr.addSelectField(model.DATA, ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                this.impostaSelectField3dCustom(fruizione_portaDelegata_UnionExpr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom(), aliases3dCustom);
            }
            if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                fruizione_portaDelegata_UnionExpr.addSelectField(model.TIPO_DESTINATARIO, "tipo_soggetto");
                fruizione_portaDelegata_UnionExpr.addSelectField(model.DESTINATARIO, "soggetto");
            } else {
                fruizione_portaDelegata_UnionExpr.addSelectField(model.TIPO_MITTENTE, "tipo_soggetto");
                fruizione_portaDelegata_UnionExpr.addSelectField(model.MITTENTE, "soggetto");
            }
            IExpression fakeExpr = dao.newExpression();
            UnionExpression unionExprFake = new UnionExpression(fakeExpr);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                unionExprFake.addSelectField((IField)new ConstantField(ALIAS_FIELD_DATA_3D, (Object)FALSA_UNION_DEFAULT_VALUE_TIMESTAMP, model.DATA.getFieldType()), ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                this.impostaSelectField3dCustomFake(unionExprFake, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom(), aliases3dCustom);
            }
            if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                unionExprFake.addSelectField((IField)new ConstantField("tipo_soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_DESTINATARIO.getFieldType()), "tipo_soggetto");
                unionExprFake.addSelectField((IField)new ConstantField("soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.DESTINATARIO.getFieldType()), "soggetto");
            } else {
                unionExprFake.addSelectField((IField)new ConstantField("tipo_soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_MITTENTE.getFieldType()), "tipo_soggetto");
                unionExprFake.addSelectField((IField)new ConstantField("soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.MITTENTE.getFieldType()), "soggetto");
            }
            Union union = new Union();
            union.setUnionAll(true);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                union.addField(ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    union.addField(a3dCustom);
                }
            }
            union.addField("tipo_soggetto");
            union.addField("soggetto");
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                union.addGroupBy(ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    union.addGroupBy(a3dCustom);
                }
            }
            union.addGroupBy("tipo_soggetto");
            union.addGroupBy("soggetto");
            NonNegativeNumber nnn = dao.unionCount(union, new UnionExpression[]{fruizione_portaDelegata_UnionExpr, unionExprFake});
            return nnn != null ? nnn.longValue() - 1L : 0L;
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (CoreException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (NotFoundException e) {
            StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente.");
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        return 0L;
    }

    private List<ResDistribuzione> executeDistribuzioneSoggetto(IServiceSearchWithoutId<?> dao, StatisticaModel model, boolean isPaginated, int start, int limit) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException, CoreException, NotFoundException, ProtocolException, UserInvalidException, UtilsException {
        ArrayList<ResDistribuzione> res;
        block238: {
            List listaSoggettiGestione;
            EsitoUtils esitoUtils;
            List list;
            ISQLFieldConverter fieldConverter;
            List<Index> forceIndexes;
            StatisticType tipologia;
            block239: {
                block237: {
                    tipologia = this.checkStatisticType(this.distribSoggettoSearch);
                    forceIndexes = null;
                    try {
                        forceIndexes = this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexDistribuzioneSoggettoGroupBy(this.govwayMonitorProperties.getExternalForceIndexRepository()));
                    }
                    catch (Exception e) {
                        throw new ServiceException(e.getMessage(), (Throwable)e);
                    }
                    fieldConverter = ((IDBServiceUtilities)dao).getFieldConverter();
                    list = null;
                    res = new ArrayList<ResDistribuzione>();
                    log.debug("creo Expression per distribuzione Soggetto!");
                    esitoUtils = new EsitoUtils(log, this.distribSoggettoSearch.getProtocollo());
                    listaSoggettiGestione = this.distribSoggettoSearch.getSoggettiGestione();
                    if (this.distribSoggettoSearch.getTipologiaRicercaEnum() != null && !TipologiaRicerca.all.equals((Object)this.distribSoggettoSearch.getTipologiaRicercaEnum())) break block237;
                    IExpression erogazione_portaApplicativa_Expr = dao.newExpression();
                    erogazione_portaApplicativa_Expr.equals(model.TIPO_PORTA, (Object)"applicativa");
                    erogazione_portaApplicativa_Expr.and().between(model.DATA, (Object)this.distribSoggettoSearch.getDataInizio(), (Object)this.distribSoggettoSearch.getDataFine());
                    StatisticheUtils.selezionaRecordValidi((IExpression)erogazione_portaApplicativa_Expr, (StatisticaModel)model);
                    String protocollo = null;
                    if (this.distribSoggettoSearch.isSetFiltroProtocollo()) {
                        protocollo = this.distribSoggettoSearch.getProtocollo();
                        this.impostaTipiCompatibiliConProtocollo(dao, model, erogazione_portaApplicativa_Expr, protocollo, this.distribSoggettoSearch.getTipologiaRicercaEnum());
                    }
                    if (this.distribSoggettoSearch.getPermessiUtenteOperatore() != null) {
                        IExpression permessi = this.distribSoggettoSearch.getPermessiUtenteOperatore().toExpression(dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                        erogazione_portaApplicativa_Expr.and(new IExpression[]{permessi});
                    }
                    if (Utility.isFiltroDominioAbilitato() && this.distribSoggettoSearch.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.distribSoggettoSearch.getSoggettoLocale()) && !"--".equals(this.distribSoggettoSearch.getSoggettoLocale())) {
                        String tipoSoggettoLocale = this.distribSoggettoSearch.getTipoSoggettoLocale();
                        String nomeSoggettoLocale = this.distribSoggettoSearch.getSoggettoLocale();
                        String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                        erogazione_portaApplicativa_Expr.and().equals(model.ID_PORTA, (Object)idPorta);
                    }
                    if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeAzione())) {
                        erogazione_portaApplicativa_Expr.and().equals(model.AZIONE, (Object)this.distribSoggettoSearch.getNomeAzione());
                    }
                    if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeServizio())) {
                        IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)this.distribSoggettoSearch.getNomeServizio());
                        erogazione_portaApplicativa_Expr.and().equals(model.TIPO_DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getTipo()).equals(model.DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getNome()).equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo()).equals(model.SERVIZIO, (Object)idServizio.getNome()).equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
                    }
                    esitoUtils.setExpression(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch.getEsitoGruppo(), this.distribSoggettoSearch.getEsitoDettaglio(), this.distribSoggettoSearch.getEsitoDettaglioPersonalizzato(), this.distribSoggettoSearch.getEsitoContesto(), this.distribSoggettoSearch.isEscludiRichiesteScartate(), model.ESITO, model.ESITO_CONTESTO, dao.newExpression());
                    if (!listaSoggettiGestione.isEmpty()) {
                        erogazione_portaApplicativa_Expr.and();
                        IExpression[] orSoggetti = new IExpression[listaSoggettiGestione.size()];
                        int i = 0;
                        for (Soggetto soggetto : listaSoggettiGestione) {
                            IExpression se = dao.newExpression();
                            se.equals(model.TIPO_DESTINATARIO, (Object)soggetto.getTipoSoggetto());
                            se.and().equals(model.DESTINATARIO, (Object)soggetto.getNomeSoggetto());
                            orSoggetti[i] = se;
                            ++i;
                        }
                        erogazione_portaApplicativa_Expr.or(orSoggetti);
                    }
                    if (!this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota() && StringUtils.isNotBlank((String)this.distribSoggettoSearch.getTrafficoPerSoggetto())) {
                        erogazione_portaApplicativa_Expr.and().equals(model.TIPO_MITTENTE, (Object)this.distribSoggettoSearch.getTipoTrafficoPerSoggetto());
                        erogazione_portaApplicativa_Expr.and().equals(model.MITTENTE, (Object)this.distribSoggettoSearch.getTrafficoPerSoggetto());
                    }
                    IExpression fruizione_portaDelegata_Expr = dao.newExpression();
                    fruizione_portaDelegata_Expr.equals(model.TIPO_PORTA, (Object)"delegata");
                    fruizione_portaDelegata_Expr.and().between(model.DATA, (Object)this.distribSoggettoSearch.getDataInizio(), (Object)this.distribSoggettoSearch.getDataFine());
                    StatisticheUtils.selezionaRecordValidi((IExpression)fruizione_portaDelegata_Expr, (StatisticaModel)model);
                    if (StringUtils.isNotEmpty((String)this.distribSoggettoSearch.getProtocollo()) && this.distribSoggettoSearch.isShowListaProtocolli()) {
                        protocollo = this.distribSoggettoSearch.getProtocollo();
                        this.impostaTipiCompatibiliConProtocollo(dao, model, fruizione_portaDelegata_Expr, protocollo, this.distribSoggettoSearch.getTipologiaRicercaEnum());
                    }
                    if (this.distribSoggettoSearch.getPermessiUtenteOperatore() != null) {
                        IExpression permessi = this.distribSoggettoSearch.getPermessiUtenteOperatore().toExpression(dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                        fruizione_portaDelegata_Expr.and(new IExpression[]{permessi});
                    }
                    if (Utility.isFiltroDominioAbilitato() && this.distribSoggettoSearch.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.distribSoggettoSearch.getSoggettoLocale()) && !"--".equals(this.distribSoggettoSearch.getSoggettoLocale())) {
                        String tipoSoggettoLocale = this.distribSoggettoSearch.getTipoSoggettoLocale();
                        String nomeSoggettoLocale = this.distribSoggettoSearch.getSoggettoLocale();
                        String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                        fruizione_portaDelegata_Expr.and().equals(model.ID_PORTA, (Object)idPorta);
                    }
                    if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeAzione())) {
                        fruizione_portaDelegata_Expr.and().equals(model.AZIONE, (Object)this.distribSoggettoSearch.getNomeAzione());
                    }
                    if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeServizio())) {
                        IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)this.distribSoggettoSearch.getNomeServizio());
                        fruizione_portaDelegata_Expr.and().equals(model.TIPO_DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getTipo()).equals(model.DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getNome()).equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo()).equals(model.SERVIZIO, (Object)idServizio.getNome()).equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
                    }
                    esitoUtils.setExpression(fruizione_portaDelegata_Expr, this.distribSoggettoSearch.getEsitoGruppo(), this.distribSoggettoSearch.getEsitoDettaglio(), this.distribSoggettoSearch.getEsitoDettaglioPersonalizzato(), this.distribSoggettoSearch.getEsitoContesto(), this.distribSoggettoSearch.isEscludiRichiesteScartate(), model.ESITO, model.ESITO_CONTESTO, dao.newExpression());
                    if (!listaSoggettiGestione.isEmpty()) {
                        fruizione_portaDelegata_Expr.and();
                        IExpression[] orSoggetti = new IExpression[listaSoggettiGestione.size()];
                        int i = 0;
                        for (Soggetto soggetto : listaSoggettiGestione) {
                            IExpression se = dao.newExpression();
                            se.equals(model.TIPO_MITTENTE, (Object)soggetto.getTipoSoggetto());
                            se.and().equals(model.MITTENTE, (Object)soggetto.getNomeSoggetto());
                            orSoggetti[i] = se;
                            ++i;
                        }
                        fruizione_portaDelegata_Expr.or(orSoggetti);
                    }
                    if (!this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota() && StringUtils.isNotBlank((String)this.distribSoggettoSearch.getTrafficoPerSoggetto())) {
                        fruizione_portaDelegata_Expr.and().equals(model.TIPO_DESTINATARIO, (Object)this.distribSoggettoSearch.getTipoTrafficoPerSoggetto());
                        fruizione_portaDelegata_Expr.and().equals(model.DESTINATARIO, (Object)this.distribSoggettoSearch.getTrafficoPerSoggetto());
                    }
                    this.impostaFiltroDatiMittente(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                    this.impostaFiltroDatiMittente(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
                    this.impostaFiltroGruppo(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                    this.impostaFiltroGruppo(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
                    this.impostaFiltroApi(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                    this.impostaFiltroApi(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
                    this.impostaFiltroIdClusterOrCanale(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                    this.impostaFiltroIdClusterOrCanale(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
                    if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                        if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                            erogazione_portaApplicativa_Expr.addGroupBy(model.DATA);
                        } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                            this.impostaGroupByFiltro3dCustom(erogazione_portaApplicativa_Expr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom());
                        }
                        erogazione_portaApplicativa_Expr.notEquals(model.TIPO_MITTENTE, (Object)"-");
                        erogazione_portaApplicativa_Expr.notEquals(model.MITTENTE, (Object)"-");
                        erogazione_portaApplicativa_Expr.addGroupBy(model.TIPO_MITTENTE);
                        erogazione_portaApplicativa_Expr.addGroupBy(model.MITTENTE);
                        if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                            fruizione_portaDelegata_Expr.addGroupBy(model.DATA);
                        } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                            this.impostaGroupByFiltro3dCustom(fruizione_portaDelegata_Expr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom());
                        }
                        fruizione_portaDelegata_Expr.notEquals(model.TIPO_DESTINATARIO, (Object)"-");
                        fruizione_portaDelegata_Expr.notEquals(model.DESTINATARIO, (Object)"-");
                        fruizione_portaDelegata_Expr.addGroupBy(model.TIPO_DESTINATARIO);
                        fruizione_portaDelegata_Expr.addGroupBy(model.DESTINATARIO);
                    } else {
                        if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                            erogazione_portaApplicativa_Expr.addGroupBy(model.DATA);
                        } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                            this.impostaGroupByFiltro3dCustom(erogazione_portaApplicativa_Expr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom());
                        }
                        erogazione_portaApplicativa_Expr.notEquals(model.TIPO_DESTINATARIO, (Object)"-");
                        erogazione_portaApplicativa_Expr.notEquals(model.DESTINATARIO, (Object)"-");
                        erogazione_portaApplicativa_Expr.addGroupBy(model.TIPO_DESTINATARIO);
                        erogazione_portaApplicativa_Expr.addGroupBy(model.DESTINATARIO);
                        if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                            fruizione_portaDelegata_Expr.addGroupBy(model.DATA);
                        } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                            this.impostaGroupByFiltro3dCustom(fruizione_portaDelegata_Expr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom());
                        }
                        fruizione_portaDelegata_Expr.notEquals(model.TIPO_MITTENTE, (Object)"-");
                        fruizione_portaDelegata_Expr.notEquals(model.MITTENTE, (Object)"-");
                        fruizione_portaDelegata_Expr.addGroupBy(model.TIPO_MITTENTE);
                        fruizione_portaDelegata_Expr.addGroupBy(model.MITTENTE);
                    }
                    if (forceIndexes != null && !forceIndexes.isEmpty()) {
                        for (Index index : forceIndexes) {
                            erogazione_portaApplicativa_Expr.addForceIndex(index);
                            fruizione_portaDelegata_Expr.addForceIndex(index);
                        }
                    }
                    ArrayList<String> aliases3dCustom = new ArrayList<String>();
                    UnionExpression erogazione_portaApplicativa_UnionExpr = new UnionExpression(erogazione_portaApplicativa_Expr);
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        erogazione_portaApplicativa_UnionExpr.addSelectField(model.DATA, ALIAS_FIELD_DATA_3D);
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        this.impostaSelectField3dCustom(erogazione_portaApplicativa_UnionExpr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom(), aliases3dCustom);
                    }
                    if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                        erogazione_portaApplicativa_UnionExpr.addSelectField(model.TIPO_MITTENTE, "tipo_soggetto");
                        erogazione_portaApplicativa_UnionExpr.addSelectField(model.MITTENTE, "soggetto");
                    } else {
                        erogazione_portaApplicativa_UnionExpr.addSelectField(model.TIPO_DESTINATARIO, "tipo_soggetto");
                        erogazione_portaApplicativa_UnionExpr.addSelectField(model.DESTINATARIO, "soggetto");
                    }
                    UnionExpression fruizione_portaDelegata_UnionExpr = new UnionExpression(fruizione_portaDelegata_Expr);
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        fruizione_portaDelegata_UnionExpr.addSelectField(model.DATA, ALIAS_FIELD_DATA_3D);
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        this.impostaSelectField3dCustom(fruizione_portaDelegata_UnionExpr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom(), aliases3dCustom);
                    }
                    if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                        fruizione_portaDelegata_UnionExpr.addSelectField(model.TIPO_DESTINATARIO, "tipo_soggetto");
                        fruizione_portaDelegata_UnionExpr.addSelectField(model.DESTINATARIO, "soggetto");
                    } else {
                        fruizione_portaDelegata_UnionExpr.addSelectField(model.TIPO_MITTENTE, "tipo_soggetto");
                        fruizione_portaDelegata_UnionExpr.addSelectField(model.MITTENTE, "soggetto");
                    }
                    Union union = new Union();
                    union.setUnionAll(true);
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        union.addField(ALIAS_FIELD_DATA_3D);
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        for (String a3dCustom : aliases3dCustom) {
                            union.addField(a3dCustom);
                        }
                    }
                    union.addField("tipo_soggetto");
                    union.addField("soggetto");
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        union.addGroupBy(ALIAS_FIELD_DATA_3D);
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        for (String a3dCustom : aliases3dCustom) {
                            union.addGroupBy(a3dCustom);
                        }
                    }
                    union.addGroupBy("tipo_soggetto");
                    union.addGroupBy("soggetto");
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        SortOrder s = this.distribSoggettoSearch.getSortOrder() != null ? this.distribSoggettoSearch.getSortOrder() : SortOrder.ASC;
                        union.addOrderBy(ALIAS_FIELD_DATA_3D, s);
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        for (String a3dCustom : aliases3dCustom) {
                            SortOrder s = this.distribSoggettoSearch.getSortOrder() != null ? this.distribSoggettoSearch.getSortOrder() : SortOrder.ASC;
                            union.addOrderBy(a3dCustom, s);
                        }
                    }
                    TipoVisualizzazione tipoVisualizzazione = this.distribSoggettoSearch.getTipoVisualizzazione();
                    block7 : switch (tipoVisualizzazione) {
                        case DIMENSIONE_TRANSAZIONI: {
                            TipoBanda tipoBanda = this.distribSoggettoSearch.getTipoBanda();
                            union.addOrderBy("somma", SortOrder.DESC);
                            union.addField("somma", Function.SUM, "dato");
                            switch (tipoBanda) {
                                case COMPLESSIVA: {
                                    erogazione_portaApplicativa_UnionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA, Function.SUM, "dato"));
                                    fruizione_portaDelegata_UnionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA, Function.SUM, "dato"));
                                    break;
                                }
                                case INTERNA: {
                                    erogazione_portaApplicativa_UnionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_INTERNA, Function.SUM, "dato"));
                                    fruizione_portaDelegata_UnionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_INTERNA, Function.SUM, "dato"));
                                    break;
                                }
                                case ESTERNA: {
                                    erogazione_portaApplicativa_UnionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_ESTERNA, Function.SUM, "dato"));
                                    fruizione_portaDelegata_UnionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_ESTERNA, Function.SUM, "dato"));
                                }
                            }
                            break;
                        }
                        case NUMERO_TRANSAZIONI: {
                            union.addOrderBy("somma", SortOrder.DESC);
                            union.addField("somma", Function.SUM, "dato");
                            erogazione_portaApplicativa_UnionExpr.addSelectFunctionField(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "dato"));
                            fruizione_portaDelegata_UnionExpr.addSelectFunctionField(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "dato"));
                            break;
                        }
                        case TEMPO_MEDIO_RISPOSTA: {
                            TipoLatenza tipoLatenza = this.distribSoggettoSearch.getTipoLatenza();
                            union.addOrderBy("somma", SortOrder.DESC);
                            union.addField("somma_richieste", Function.SUM, "dato_richieste");
                            union.addCustomField("somma", StatisticheUtils.getSqlCalcolaMedia((String)"dato", (String)"dato_richieste"));
                            erogazione_portaApplicativa_UnionExpr.addSelectFunctionField(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "dato_richieste"));
                            fruizione_portaDelegata_UnionExpr.addSelectFunctionField(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "dato_richieste"));
                            switch (tipoLatenza) {
                                case LATENZA_PORTA: {
                                    erogazione_portaApplicativa_Expr.isNotNull(model.LATENZA_PORTA);
                                    fruizione_portaDelegata_Expr.isNotNull(model.LATENZA_PORTA);
                                    erogazione_portaApplicativa_UnionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_PORTA, (IField)model.NUMERO_TRANSAZIONI, (String)"dato"));
                                    fruizione_portaDelegata_UnionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_PORTA, (IField)model.NUMERO_TRANSAZIONI, (String)"dato"));
                                    break block7;
                                }
                                case LATENZA_SERVIZIO: {
                                    erogazione_portaApplicativa_Expr.isNotNull(model.LATENZA_SERVIZIO);
                                    fruizione_portaDelegata_Expr.isNotNull(model.LATENZA_SERVIZIO);
                                    erogazione_portaApplicativa_UnionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_SERVIZIO, (IField)model.NUMERO_TRANSAZIONI, (String)"dato"));
                                    fruizione_portaDelegata_UnionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_SERVIZIO, (IField)model.NUMERO_TRANSAZIONI, (String)"dato"));
                                    break block7;
                                }
                            }
                            erogazione_portaApplicativa_Expr.isNotNull(model.LATENZA_TOTALE);
                            fruizione_portaDelegata_Expr.isNotNull(model.LATENZA_TOTALE);
                            erogazione_portaApplicativa_UnionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_TOTALE, (IField)model.NUMERO_TRANSAZIONI, (String)"dato"));
                            fruizione_portaDelegata_UnionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_TOTALE, (IField)model.NUMERO_TRANSAZIONI, (String)"dato"));
                            break;
                        }
                    }
                    if (isPaginated) {
                        union.setOffset(Integer.valueOf(start));
                        union.setLimit(Integer.valueOf(limit));
                    }
                    this.timeoutEvent = false;
                    if (this.timeoutRicerche == null) {
                        list = dao.union(union, new UnionExpression[]{erogazione_portaApplicativa_UnionExpr, fruizione_portaDelegata_UnionExpr});
                    } else {
                        try {
                            list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> dao.union(union, new UnionExpression[]{erogazione_portaApplicativa_UnionExpr, fruizione_portaDelegata_UnionExpr})).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            StatisticheGiornaliereService.logError(e.getMessage(), e);
                            Thread.currentThread().interrupt();
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() instanceof NotFoundException) {
                                throw (NotFoundException)e.getCause();
                            }
                            if (e.getCause() instanceof ServiceException) {
                                throw (ServiceException)e.getCause();
                            }
                            if (e.getCause() instanceof NotImplementedException) {
                                throw (NotImplementedException)e.getCause();
                            }
                            StatisticheGiornaliereService.logError(e.getMessage(), e);
                        }
                        catch (TimeoutException e) {
                            this.timeoutEvent = true;
                            StatisticheGiornaliereService.logError(e.getMessage(), e);
                        }
                    }
                    if (list == null) break block238;
                    for (Map row : list) {
                        String risultato = (String)row.get("tipo_soggetto") + "/" + (String)row.get("soggetto");
                        ResDistribuzione3D r = null;
                        if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                            r = new ResDistribuzione3D();
                            Date data = (Date)row.get(ALIAS_FIELD_DATA_3D);
                            r.setData(data);
                            r.setDataFormattata(StatsUtils.formatDate(tipologia, data));
                        } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                            r = new ResDistribuzione3DCustom();
                            StringBuilder resFailure = new StringBuilder();
                            try {
                                BooleanNullable bSkip = BooleanNullable.NULL();
                                String customData = this.getCustomData(row, this.distribSoggettoSearch.getNumeroDimensioniCustom(), this.distribSoggettoSearch, resFailure, bSkip);
                                if (bSkip != null && bSkip.getValue() != null && bSkip.getValue().booleanValue()) continue;
                                if (customData == null) {
                                    if (resFailure.length() <= 0) {
                                        resFailure.append("-?-");
                                    }
                                    throw new CoreException("Informazione personalizzata non presente");
                                }
                                ((ResDistribuzione3DCustom)r).setDatoCustom(customData);
                            }
                            catch (Exception t) {
                                ((ResDistribuzione3DCustom)r).setDatoCustom("Soggetto '" + risultato + "' - " + resFailure.toString());
                                StatisticheGiornaliereService.logError("Traduzione Soggetto(" + risultato + ") '" + resFailure.toString() + "' non riuscita: " + t.getMessage(), t);
                            }
                        } else {
                            r = new ResDistribuzione();
                        }
                        r.setRisultato(risultato);
                        Number somma = StatsUtils.converToNumber(row.get("somma"));
                        if (somma != null) {
                            r.setSomma(somma);
                        } else {
                            r.setSomma((Number)0);
                        }
                        res.add((ResDistribuzione)r);
                    }
                    break block238;
                }
                if (!TipologiaRicerca.ingresso.equals((Object)this.distribSoggettoSearch.getTipologiaRicercaEnum())) break block239;
                IExpression erogazione_portaApplicativa_Expr = dao.newExpression();
                erogazione_portaApplicativa_Expr.between(model.DATA, (Object)this.distribSoggettoSearch.getDataInizio(), (Object)this.distribSoggettoSearch.getDataFine());
                StatisticheUtils.selezionaRecordValidi((IExpression)erogazione_portaApplicativa_Expr, (StatisticaModel)model);
                String protocollo = null;
                if (StringUtils.isNotEmpty((String)this.distribSoggettoSearch.getProtocollo()) && this.distribSoggettoSearch.isShowListaProtocolli()) {
                    protocollo = this.distribSoggettoSearch.getProtocollo();
                    this.impostaTipiCompatibiliConProtocollo(dao, model, erogazione_portaApplicativa_Expr, protocollo, this.distribSoggettoSearch.getTipologiaRicercaEnum());
                }
                erogazione_portaApplicativa_Expr.and().equals(model.TIPO_PORTA, (Object)"applicativa");
                if (this.distribSoggettoSearch.getPermessiUtenteOperatore() != null) {
                    IExpression permessi = this.distribSoggettoSearch.getPermessiUtenteOperatore().toExpression(dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                    erogazione_portaApplicativa_Expr.and(new IExpression[]{permessi});
                }
                if (Utility.isFiltroDominioAbilitato() && this.distribSoggettoSearch.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.distribSoggettoSearch.getSoggettoLocale()) && !"--".equals(this.distribSoggettoSearch.getSoggettoLocale())) {
                    String tipoSoggettoLocale = this.distribSoggettoSearch.getTipoSoggettoLocale();
                    String nomeSoggettoLocale = this.distribSoggettoSearch.getSoggettoLocale();
                    String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                    erogazione_portaApplicativa_Expr.and().equals(model.ID_PORTA, (Object)idPorta);
                }
                if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeAzione())) {
                    erogazione_portaApplicativa_Expr.and().equals(model.AZIONE, (Object)this.distribSoggettoSearch.getNomeAzione());
                }
                if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeServizio())) {
                    IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)this.distribSoggettoSearch.getNomeServizio());
                    erogazione_portaApplicativa_Expr.and().equals(model.TIPO_DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getTipo()).equals(model.DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getNome()).equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo()).equals(model.SERVIZIO, (Object)idServizio.getNome()).equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
                }
                esitoUtils.setExpression(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch.getEsitoGruppo(), this.distribSoggettoSearch.getEsitoDettaglio(), this.distribSoggettoSearch.getEsitoDettaglioPersonalizzato(), this.distribSoggettoSearch.getEsitoContesto(), this.distribSoggettoSearch.isEscludiRichiesteScartate(), model.ESITO, model.ESITO_CONTESTO, dao.newExpression());
                if (!listaSoggettiGestione.isEmpty()) {
                    erogazione_portaApplicativa_Expr.and();
                    IExpression[] orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_DESTINATARIO, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.DESTINATARIO, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    erogazione_portaApplicativa_Expr.or(orSoggetti);
                }
                if (!this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                    boolean ignoreSetMittente = this.isIgnoreSetMittente(this.distribSoggettoSearch);
                    if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeMittente()) && !ignoreSetMittente) {
                        erogazione_portaApplicativa_Expr.and().equals(model.TIPO_MITTENTE, (Object)this.distribSoggettoSearch.getTipoMittente());
                        erogazione_portaApplicativa_Expr.and().equals(model.MITTENTE, (Object)this.distribSoggettoSearch.getNomeMittente());
                    }
                }
                this.impostaFiltroDatiMittente(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                this.impostaFiltroGruppo(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                this.impostaFiltroApi(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                this.impostaFiltroIdClusterOrCanale(erogazione_portaApplicativa_Expr, this.distribSoggettoSearch, model, false);
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    erogazione_portaApplicativa_Expr.addGroupBy(model.DATA);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    this.impostaGroupByFiltro3dCustom(erogazione_portaApplicativa_Expr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom());
                }
                if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                    erogazione_portaApplicativa_Expr.notEquals(model.TIPO_MITTENTE, (Object)"-");
                    erogazione_portaApplicativa_Expr.notEquals(model.MITTENTE, (Object)"-");
                    erogazione_portaApplicativa_Expr.addGroupBy(model.TIPO_MITTENTE);
                    erogazione_portaApplicativa_Expr.addGroupBy(model.MITTENTE);
                } else {
                    erogazione_portaApplicativa_Expr.notEquals(model.TIPO_DESTINATARIO, (Object)"-");
                    erogazione_portaApplicativa_Expr.notEquals(model.DESTINATARIO, (Object)"-");
                    erogazione_portaApplicativa_Expr.addGroupBy(model.TIPO_DESTINATARIO);
                    erogazione_portaApplicativa_Expr.addGroupBy(model.DESTINATARIO);
                }
                if (forceIndexes != null && !forceIndexes.isEmpty()) {
                    for (Index index : forceIndexes) {
                        erogazione_portaApplicativa_Expr.addForceIndex(index);
                    }
                }
                UnionExpression erogazione_portaApplicativa_UnionExpr = new UnionExpression(erogazione_portaApplicativa_Expr);
                ArrayList<String> aliases3dCustom = new ArrayList<String>();
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    erogazione_portaApplicativa_UnionExpr.addSelectField(model.DATA, ALIAS_FIELD_DATA_3D);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    this.impostaSelectField3dCustom(erogazione_portaApplicativa_UnionExpr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom(), aliases3dCustom);
                }
                if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                    erogazione_portaApplicativa_UnionExpr.addSelectField(model.TIPO_MITTENTE, "tipo_soggetto");
                    erogazione_portaApplicativa_UnionExpr.addSelectField(model.MITTENTE, "soggetto");
                } else {
                    erogazione_portaApplicativa_UnionExpr.addSelectField(model.TIPO_DESTINATARIO, "tipo_soggetto");
                    erogazione_portaApplicativa_UnionExpr.addSelectField(model.DESTINATARIO, "soggetto");
                }
                IExpression fakeExpr = dao.newExpression();
                UnionExpression unionExprFake = new UnionExpression(fakeExpr);
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    unionExprFake.addSelectField((IField)new ConstantField(ALIAS_FIELD_DATA_3D, (Object)FALSA_UNION_DEFAULT_VALUE_TIMESTAMP, model.DATA.getFieldType()), ALIAS_FIELD_DATA_3D);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    this.impostaSelectField3dCustomFake(unionExprFake, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom(), aliases3dCustom);
                }
                if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                    unionExprFake.addSelectField((IField)new ConstantField("tipo_soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_MITTENTE.getFieldType()), "tipo_soggetto");
                    unionExprFake.addSelectField((IField)new ConstantField("soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.MITTENTE.getFieldType()), "soggetto");
                } else {
                    unionExprFake.addSelectField((IField)new ConstantField("tipo_soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_DESTINATARIO.getFieldType()), "tipo_soggetto");
                    unionExprFake.addSelectField((IField)new ConstantField("soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.DESTINATARIO.getFieldType()), "soggetto");
                }
                Union union = new Union();
                union.setUnionAll(true);
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    union.addField(ALIAS_FIELD_DATA_3D);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    for (String a3dCustom : aliases3dCustom) {
                        union.addField(a3dCustom);
                    }
                }
                union.addField("tipo_soggetto");
                union.addField("soggetto");
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    union.addGroupBy(ALIAS_FIELD_DATA_3D);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    for (String a3dCustom : aliases3dCustom) {
                        union.addGroupBy(a3dCustom);
                    }
                }
                union.addGroupBy("tipo_soggetto");
                union.addGroupBy("soggetto");
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    SortOrder s = this.distribSoggettoSearch.getSortOrder() != null ? this.distribSoggettoSearch.getSortOrder() : SortOrder.ASC;
                    union.addOrderBy(ALIAS_FIELD_DATA_3D, s);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                    for (String a3dCustom : aliases3dCustom) {
                        SortOrder s = this.distribSoggettoSearch.getSortOrder() != null ? this.distribSoggettoSearch.getSortOrder() : SortOrder.ASC;
                        union.addOrderBy(a3dCustom, s);
                    }
                }
                TipoVisualizzazione tipoVisualizzazione = this.distribSoggettoSearch.getTipoVisualizzazione();
                block21 : switch (tipoVisualizzazione) {
                    case DIMENSIONE_TRANSAZIONI: {
                        TipoBanda tipoBanda = this.distribSoggettoSearch.getTipoBanda();
                        union.addOrderBy("somma", SortOrder.DESC);
                        union.addField("somma", Function.SUM, "dato");
                        switch (tipoBanda) {
                            case COMPLESSIVA: {
                                erogazione_portaApplicativa_UnionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA, Function.SUM, "dato"));
                                unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_complessiva", (Object)0, model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA.getFieldType()), Function.SUM, "dato"));
                                break;
                            }
                            case INTERNA: {
                                erogazione_portaApplicativa_UnionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_INTERNA, Function.SUM, "dato"));
                                unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_interna", (Object)0, model.DIMENSIONI_BYTES_BANDA_INTERNA.getFieldType()), Function.SUM, "dato"));
                                break;
                            }
                            case ESTERNA: {
                                erogazione_portaApplicativa_UnionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_ESTERNA, Function.SUM, "dato"));
                                unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_esterna", (Object)0, model.DIMENSIONI_BYTES_BANDA_ESTERNA.getFieldType()), Function.SUM, "dato"));
                            }
                        }
                        break;
                    }
                    case NUMERO_TRANSAZIONI: {
                        union.addOrderBy("somma", SortOrder.DESC);
                        union.addField("somma", Function.SUM, "dato");
                        erogazione_portaApplicativa_UnionExpr.addSelectFunctionField(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "dato"));
                        unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("numero_transazioni", (Object)0, model.NUMERO_TRANSAZIONI.getFieldType()), Function.SUM, "dato"));
                        break;
                    }
                    case TEMPO_MEDIO_RISPOSTA: {
                        TipoLatenza tipoLatenza = this.distribSoggettoSearch.getTipoLatenza();
                        union.addOrderBy("somma", SortOrder.DESC);
                        union.addField("somma", Function.SUM, "dato");
                        switch (tipoLatenza) {
                            case LATENZA_PORTA: {
                                erogazione_portaApplicativa_Expr.isNotNull(model.LATENZA_PORTA);
                                fakeExpr.isNotNull(model.LATENZA_PORTA);
                                unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_porta", (Object)0, model.LATENZA_PORTA.getFieldType()), Function.SUM, "dato"));
                                erogazione_portaApplicativa_UnionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_PORTA, (IField)model.NUMERO_TRANSAZIONI, (String)"dato"));
                                break block21;
                            }
                            case LATENZA_SERVIZIO: {
                                erogazione_portaApplicativa_Expr.isNotNull(model.LATENZA_SERVIZIO);
                                fakeExpr.isNotNull(model.LATENZA_SERVIZIO);
                                unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_servizio", (Object)0, model.LATENZA_SERVIZIO.getFieldType()), Function.SUM, "dato"));
                                erogazione_portaApplicativa_UnionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_SERVIZIO, (IField)model.NUMERO_TRANSAZIONI, (String)"dato"));
                                break block21;
                            }
                        }
                        erogazione_portaApplicativa_Expr.isNotNull(model.LATENZA_TOTALE);
                        fakeExpr.isNotNull(model.LATENZA_TOTALE);
                        unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_totale", (Object)0, model.LATENZA_TOTALE.getFieldType()), Function.SUM, "dato"));
                        erogazione_portaApplicativa_UnionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_TOTALE, (IField)model.NUMERO_TRANSAZIONI, (String)"dato"));
                        break;
                    }
                }
                if (isPaginated) {
                    union.setOffset(Integer.valueOf(start));
                    union.setLimit(Integer.valueOf(limit));
                }
                this.timeoutEvent = false;
                if (this.timeoutRicerche == null) {
                    list = dao.union(union, new UnionExpression[]{erogazione_portaApplicativa_UnionExpr, unionExprFake});
                } else {
                    try {
                        list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> dao.union(union, new UnionExpression[]{erogazione_portaApplicativa_UnionExpr, unionExprFake})).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        StatisticheGiornaliereService.logError(e.getMessage(), e);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() instanceof NotFoundException) {
                            throw (NotFoundException)e.getCause();
                        }
                        if (e.getCause() instanceof ServiceException) {
                            throw (ServiceException)e.getCause();
                        }
                        if (e.getCause() instanceof NotImplementedException) {
                            throw (NotImplementedException)e.getCause();
                        }
                        StatisticheGiornaliereService.logError(e.getMessage(), e);
                    }
                    catch (TimeoutException e) {
                        this.timeoutEvent = true;
                        StatisticheGiornaliereService.logError(e.getMessage(), e);
                    }
                }
                if (list == null) break block238;
                for (Map row : list) {
                    String risultato = (String)row.get("tipo_soggetto") + "/" + (String)row.get("soggetto");
                    if (risultato != null && risultato.contains(FALSA_UNION_DEFAULT_VALUE)) continue;
                    ResDistribuzione3D r = null;
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        r = new ResDistribuzione3D();
                        Date data = (Date)row.get(ALIAS_FIELD_DATA_3D);
                        r.setData(data);
                        r.setDataFormattata(StatsUtils.formatDate(tipologia, data));
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        r = new ResDistribuzione3DCustom();
                        StringBuilder resFailure = new StringBuilder();
                        try {
                            BooleanNullable bSkip = BooleanNullable.NULL();
                            String customData = this.getCustomData(row, this.distribSoggettoSearch.getNumeroDimensioniCustom(), this.distribSoggettoSearch, resFailure, bSkip);
                            if (bSkip != null && bSkip.getValue() != null && bSkip.getValue().booleanValue()) continue;
                            if (customData == null) {
                                if (resFailure.length() <= 0) {
                                    resFailure.append("-?-");
                                }
                                throw new CoreException("Informazione personalizzata non presente");
                            }
                            ((ResDistribuzione3DCustom)r).setDatoCustom(customData);
                        }
                        catch (Exception t) {
                            ((ResDistribuzione3DCustom)r).setDatoCustom("Soggetto '" + risultato + "' - " + resFailure.toString());
                            StatisticheGiornaliereService.logError("Traduzione Soggetto(" + risultato + ") '" + resFailure.toString() + "' non riuscita: " + t.getMessage(), t);
                        }
                    } else {
                        r = new ResDistribuzione();
                    }
                    r.setRisultato(risultato);
                    Number somma = StatsUtils.converToNumber(row.get("somma"));
                    if (somma != null) {
                        r.setSomma(somma);
                    } else {
                        r.setSomma((Number)0);
                    }
                    res.add((ResDistribuzione)r);
                }
                break block238;
            }
            IExpression fruizione_portaDelegata_Expr = dao.newExpression();
            fruizione_portaDelegata_Expr.between(model.DATA, (Object)this.distribSoggettoSearch.getDataInizio(), (Object)this.distribSoggettoSearch.getDataFine());
            StatisticheUtils.selezionaRecordValidi((IExpression)fruizione_portaDelegata_Expr, (StatisticaModel)model);
            String protocollo = null;
            if (StringUtils.isNotEmpty((String)this.distribSoggettoSearch.getProtocollo()) && this.distribSoggettoSearch.isShowListaProtocolli()) {
                protocollo = this.distribSoggettoSearch.getProtocollo();
                this.impostaTipiCompatibiliConProtocollo(dao, model, fruizione_portaDelegata_Expr, protocollo, this.distribSoggettoSearch.getTipologiaRicercaEnum());
            }
            fruizione_portaDelegata_Expr.and().equals(model.TIPO_PORTA, (Object)"delegata");
            if (this.distribSoggettoSearch.getPermessiUtenteOperatore() != null) {
                IExpression permessi = this.distribSoggettoSearch.getPermessiUtenteOperatore().toExpression(dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                fruizione_portaDelegata_Expr.and(new IExpression[]{permessi});
            }
            if (Utility.isFiltroDominioAbilitato() && this.distribSoggettoSearch.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.distribSoggettoSearch.getSoggettoLocale()) && !"--".equals(this.distribSoggettoSearch.getSoggettoLocale())) {
                String tipoSoggettoLocale = this.distribSoggettoSearch.getTipoSoggettoLocale();
                String nomeSoggettoLocale = this.distribSoggettoSearch.getSoggettoLocale();
                String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                fruizione_portaDelegata_Expr.and().equals(model.ID_PORTA, (Object)idPorta);
            }
            if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeAzione())) {
                fruizione_portaDelegata_Expr.and().equals(model.AZIONE, (Object)this.distribSoggettoSearch.getNomeAzione());
            }
            if (StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeServizio())) {
                IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)this.distribSoggettoSearch.getNomeServizio());
                fruizione_portaDelegata_Expr.and().equals(model.TIPO_DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getTipo()).equals(model.DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getNome()).equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo()).equals(model.SERVIZIO, (Object)idServizio.getNome()).equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
            }
            esitoUtils.setExpression(fruizione_portaDelegata_Expr, this.distribSoggettoSearch.getEsitoGruppo(), this.distribSoggettoSearch.getEsitoDettaglio(), this.distribSoggettoSearch.getEsitoDettaglioPersonalizzato(), this.distribSoggettoSearch.getEsitoContesto(), this.distribSoggettoSearch.isEscludiRichiesteScartate(), model.ESITO, model.ESITO_CONTESTO, dao.newExpression());
            if (!listaSoggettiGestione.isEmpty()) {
                fruizione_portaDelegata_Expr.and();
                IExpression[] orSoggetti = new IExpression[listaSoggettiGestione.size()];
                int i = 0;
                for (Soggetto soggetto : listaSoggettiGestione) {
                    IExpression se = dao.newExpression();
                    se.equals(model.TIPO_MITTENTE, (Object)soggetto.getTipoSoggetto());
                    se.and().equals(model.MITTENTE, (Object)soggetto.getNomeSoggetto());
                    orSoggetti[i] = se;
                    ++i;
                }
                fruizione_portaDelegata_Expr.or(orSoggetti);
            }
            if (!this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota() && StringUtils.isNotBlank((String)this.distribSoggettoSearch.getNomeDestinatario())) {
                fruizione_portaDelegata_Expr.and().equals(model.TIPO_DESTINATARIO, (Object)this.distribSoggettoSearch.getTipoDestinatario());
                fruizione_portaDelegata_Expr.and().equals(model.DESTINATARIO, (Object)this.distribSoggettoSearch.getNomeDestinatario());
            }
            this.impostaFiltroDatiMittente(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
            this.impostaFiltroGruppo(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
            this.impostaFiltroApi(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
            this.impostaFiltroIdClusterOrCanale(fruizione_portaDelegata_Expr, this.distribSoggettoSearch, model, false);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                fruizione_portaDelegata_Expr.addGroupBy(model.DATA);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                this.impostaGroupByFiltro3dCustom(fruizione_portaDelegata_Expr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom());
            }
            if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                fruizione_portaDelegata_Expr.notEquals(model.TIPO_DESTINATARIO, (Object)"-");
                fruizione_portaDelegata_Expr.notEquals(model.DESTINATARIO, (Object)"-");
                fruizione_portaDelegata_Expr.addGroupBy(model.TIPO_DESTINATARIO);
                fruizione_portaDelegata_Expr.addGroupBy(model.DESTINATARIO);
            } else {
                fruizione_portaDelegata_Expr.notEquals(model.TIPO_MITTENTE, (Object)"-");
                fruizione_portaDelegata_Expr.notEquals(model.MITTENTE, (Object)"-");
                fruizione_portaDelegata_Expr.addGroupBy(model.TIPO_MITTENTE);
                fruizione_portaDelegata_Expr.addGroupBy(model.MITTENTE);
            }
            if (forceIndexes != null && !forceIndexes.isEmpty()) {
                for (Index index : forceIndexes) {
                    fruizione_portaDelegata_Expr.addForceIndex(index);
                }
            }
            UnionExpression fruizione_portaDelegata_UnionExpr = new UnionExpression(fruizione_portaDelegata_Expr);
            ArrayList<String> aliases3dCustom = new ArrayList<String>();
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                fruizione_portaDelegata_UnionExpr.addSelectField(model.DATA, ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                this.impostaSelectField3dCustom(fruizione_portaDelegata_UnionExpr, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom(), aliases3dCustom);
            }
            if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                fruizione_portaDelegata_UnionExpr.addSelectField(model.TIPO_DESTINATARIO, "tipo_soggetto");
                fruizione_portaDelegata_UnionExpr.addSelectField(model.DESTINATARIO, "soggetto");
            } else {
                fruizione_portaDelegata_UnionExpr.addSelectField(model.TIPO_MITTENTE, "tipo_soggetto");
                fruizione_portaDelegata_UnionExpr.addSelectField(model.MITTENTE, "soggetto");
            }
            IExpression fakeExpr = dao.newExpression();
            UnionExpression unionExprFake = new UnionExpression(fakeExpr);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                unionExprFake.addSelectField((IField)new ConstantField(ALIAS_FIELD_DATA_3D, (Object)FALSA_UNION_DEFAULT_VALUE_TIMESTAMP, model.DATA.getFieldType()), ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                this.impostaSelectField3dCustomFake(unionExprFake, model, this.distribSoggettoSearch, this.distribSoggettoSearch.getNumeroDimensioniCustom(), aliases3dCustom);
            }
            if (this.distribSoggettoSearch.isDistribuzionePerSoggettoRemota()) {
                unionExprFake.addSelectField((IField)new ConstantField("tipo_soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_DESTINATARIO.getFieldType()), "tipo_soggetto");
                unionExprFake.addSelectField((IField)new ConstantField("soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.DESTINATARIO.getFieldType()), "soggetto");
            } else {
                unionExprFake.addSelectField((IField)new ConstantField("tipo_soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_MITTENTE.getFieldType()), "tipo_soggetto");
                unionExprFake.addSelectField((IField)new ConstantField("soggetto", (Object)FALSA_UNION_DEFAULT_VALUE, model.MITTENTE.getFieldType()), "soggetto");
            }
            Union union = new Union();
            union.setUnionAll(true);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                union.addField(ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    union.addField(a3dCustom);
                }
            }
            union.addField("tipo_soggetto");
            union.addField("soggetto");
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                union.addGroupBy(ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    union.addGroupBy(a3dCustom);
                }
            }
            union.addGroupBy("tipo_soggetto");
            union.addGroupBy("soggetto");
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                SortOrder s = this.distribSoggettoSearch.getSortOrder() != null ? this.distribSoggettoSearch.getSortOrder() : SortOrder.ASC;
                union.addOrderBy(ALIAS_FIELD_DATA_3D, s);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    SortOrder s = this.distribSoggettoSearch.getSortOrder() != null ? this.distribSoggettoSearch.getSortOrder() : SortOrder.ASC;
                    union.addOrderBy(a3dCustom, s);
                }
            }
            TipoVisualizzazione tipoVisualizzazione = this.distribSoggettoSearch.getTipoVisualizzazione();
            block35 : switch (tipoVisualizzazione) {
                case DIMENSIONE_TRANSAZIONI: {
                    TipoBanda tipoBanda = this.distribSoggettoSearch.getTipoBanda();
                    union.addOrderBy("somma", SortOrder.DESC);
                    union.addField("somma", Function.SUM, "dato");
                    switch (tipoBanda) {
                        case COMPLESSIVA: {
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_complessiva", (Object)0, model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA.getFieldType()), Function.SUM, "dato"));
                            fruizione_portaDelegata_UnionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA, Function.SUM, "dato"));
                            break;
                        }
                        case INTERNA: {
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_interna", (Object)0, model.DIMENSIONI_BYTES_BANDA_INTERNA.getFieldType()), Function.SUM, "dato"));
                            fruizione_portaDelegata_UnionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_INTERNA, Function.SUM, "dato"));
                            break;
                        }
                        case ESTERNA: {
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_esterna", (Object)0, model.DIMENSIONI_BYTES_BANDA_ESTERNA.getFieldType()), Function.SUM, "dato"));
                            fruizione_portaDelegata_UnionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_ESTERNA, Function.SUM, "dato"));
                        }
                    }
                    break;
                }
                case NUMERO_TRANSAZIONI: {
                    union.addOrderBy("somma", SortOrder.DESC);
                    union.addField("somma", Function.SUM, "dato");
                    unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("numero_transazioni", (Object)0, model.NUMERO_TRANSAZIONI.getFieldType()), Function.SUM, "dato"));
                    fruizione_portaDelegata_UnionExpr.addSelectFunctionField(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "dato"));
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    TipoLatenza tipoLatenza = this.distribSoggettoSearch.getTipoLatenza();
                    union.addOrderBy("somma", SortOrder.DESC);
                    union.addField("somma", Function.SUM, "dato");
                    switch (tipoLatenza) {
                        case LATENZA_PORTA: {
                            fakeExpr.isNotNull(model.LATENZA_PORTA);
                            fruizione_portaDelegata_Expr.isNotNull(model.LATENZA_PORTA);
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_porta", (Object)0, model.LATENZA_PORTA.getFieldType()), Function.SUM, "dato"));
                            fruizione_portaDelegata_UnionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_PORTA, (IField)model.NUMERO_TRANSAZIONI, (String)"dato"));
                            break block35;
                        }
                        case LATENZA_SERVIZIO: {
                            fakeExpr.isNotNull(model.LATENZA_SERVIZIO);
                            fruizione_portaDelegata_Expr.isNotNull(model.LATENZA_SERVIZIO);
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_servizio", (Object)0, model.LATENZA_SERVIZIO.getFieldType()), Function.SUM, "dato"));
                            fruizione_portaDelegata_UnionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_SERVIZIO, (IField)model.NUMERO_TRANSAZIONI, (String)"dato"));
                            break block35;
                        }
                    }
                    fakeExpr.isNotNull(model.LATENZA_TOTALE);
                    fruizione_portaDelegata_Expr.isNotNull(model.LATENZA_TOTALE);
                    unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_totale", (Object)0, model.LATENZA_TOTALE.getFieldType()), Function.SUM, "dato"));
                    fruizione_portaDelegata_UnionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_TOTALE, (IField)model.NUMERO_TRANSAZIONI, (String)"dato"));
                    break;
                }
            }
            if (isPaginated) {
                union.setOffset(Integer.valueOf(start));
                union.setLimit(Integer.valueOf(limit));
            }
            this.timeoutEvent = false;
            if (this.timeoutRicerche == null) {
                list = dao.union(union, new UnionExpression[]{fruizione_portaDelegata_UnionExpr, unionExprFake});
            } else {
                try {
                    list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> dao.union(union, new UnionExpression[]{fruizione_portaDelegata_UnionExpr, unionExprFake})).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof NotFoundException) {
                        throw (NotFoundException)e.getCause();
                    }
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                }
            }
            if (list != null) {
                for (Map row : list) {
                    String risultato = (String)row.get("tipo_soggetto") + "/" + (String)row.get("soggetto");
                    if (risultato != null && risultato.contains(FALSA_UNION_DEFAULT_VALUE)) continue;
                    ResDistribuzione3D r = null;
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        r = new ResDistribuzione3D();
                        Date data = (Date)row.get(ALIAS_FIELD_DATA_3D);
                        r.setData(data);
                        r.setDataFormattata(StatsUtils.formatDate(tipologia, data));
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSoggettoSearch.getNumeroDimensioni())) {
                        r = new ResDistribuzione3DCustom();
                        StringBuilder resFailure = new StringBuilder();
                        try {
                            BooleanNullable bSkip = BooleanNullable.NULL();
                            String customData = this.getCustomData(row, this.distribSoggettoSearch.getNumeroDimensioniCustom(), this.distribSoggettoSearch, resFailure, bSkip);
                            if (bSkip != null && bSkip.getValue() != null && bSkip.getValue().booleanValue()) continue;
                            if (customData == null) {
                                if (resFailure.length() <= 0) {
                                    resFailure.append("-?-");
                                }
                                throw new CoreException("Informazione personalizzata non presente");
                            }
                            ((ResDistribuzione3DCustom)r).setDatoCustom(customData);
                        }
                        catch (Exception t) {
                            ((ResDistribuzione3DCustom)r).setDatoCustom("Soggetto '" + risultato + "' - " + resFailure.toString());
                            StatisticheGiornaliereService.logError("Traduzione Soggetto(" + risultato + ") '" + resFailure.toString() + "' non riuscita: " + t.getMessage(), t);
                        }
                    } else {
                        r = new ResDistribuzione();
                    }
                    r.setRisultato(risultato);
                    Number somma = StatsUtils.converToNumber(row.get("somma"));
                    if (somma != null) {
                        r.setSomma(somma);
                    } else {
                        r.setSomma((Number)0);
                    }
                    res.add((ResDistribuzione)r);
                }
            }
        }
        return res;
    }

    @Override
    public int countAllDistribuzioneServizio() throws ServiceException {
        try {
            NonNegativeNumber nnn;
            StatisticType tipologia = this.checkStatisticType(this.distribServizioSearch);
            StatisticaModel model = null;
            IStatisticaGiornalieraServiceSearch dao = null;
            switch (tipologia) {
                case GIORNALIERA: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    dao = this.statGiornaliereSearchDAO;
                    break;
                }
                case MENSILE: {
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    dao = this.statMensileSearchDAO;
                    break;
                }
                case ORARIA: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    dao = this.statOrariaSearchDAO;
                    break;
                }
                case SETTIMANALE: {
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    dao = this.statSettimanaleSearchDAO;
                }
            }
            if (dao == null) {
                throw new ServiceException("DAO unknown");
            }
            if (model == null) {
                throw new ServiceException("Model unknown");
            }
            List<Index> forceIndexes = null;
            try {
                forceIndexes = this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexDistribuzioneServizioCount(this.govwayMonitorProperties.getExternalForceIndexRepository()));
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
            IExpression gByExpr = this.createDistribuzioneServizioExpression((IServiceSearchWithoutId<?>)dao, model, true);
            if (forceIndexes != null && !forceIndexes.isEmpty()) {
                for (Index index : forceIndexes) {
                    gByExpr.addForceIndex(index);
                }
            }
            return (nnn = dao.count(gByExpr)) != null ? (int)nnn.longValue() : 0;
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<ResDistribuzione> findAllDistribuzioneServizio() throws ServiceException {
        return this.executeDistribuzioneServizio(null, null);
    }

    @Override
    public List<ResDistribuzione> findAllDistribuzioneServizio(int start, int limit) throws ServiceException {
        return this.executeDistribuzioneServizio(start, limit);
    }

    private List<ResDistribuzione> executeDistribuzioneServizio(Integer start, Integer limit) throws ServiceException {
        try {
            SortOrder s;
            StatisticType tipologia = this.checkStatisticType(this.distribServizioSearch);
            StatisticaModel model = null;
            switch (tipologia) {
                case GIORNALIERA: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    this.dao = this.statGiornaliereSearchDAO;
                    break;
                }
                case MENSILE: {
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    this.dao = this.statMensileSearchDAO;
                    break;
                }
                case ORARIA: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    this.dao = this.statOrariaSearchDAO;
                    break;
                }
                case SETTIMANALE: {
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    this.dao = this.statSettimanaleSearchDAO;
                }
            }
            if (this.dao == null) {
                throw new ServiceException("DAO unknown");
            }
            if (model == null) {
                throw new ServiceException("Model unknown");
            }
            ISQLFieldConverter fieldConverter = ((IDBServiceUtilities)this.dao).getFieldConverter();
            IExpression gByExpr = this.createDistribuzioneServizioExpression(this.dao, model, false);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribServizioSearch.getNumeroDimensioni())) {
                s = this.distribServizioSearch.getSortOrder() != null ? this.distribServizioSearch.getSortOrder() : SortOrder.ASC;
                gByExpr.sortOrder(s).addOrder(model.DATA);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribServizioSearch.getNumeroDimensioni())) {
                s = this.distribServizioSearch.getSortOrder() != null ? this.distribServizioSearch.getSortOrder() : SortOrder.ASC;
                this.impostaSortOrder3dCustom(gByExpr, model, this.distribServizioSearch, this.distribServizioSearch.getNumeroDimensioniCustom(), s);
            }
            if (this.distribServizioSearch.isDistribuzionePerImplementazioneApi()) {
                gByExpr.sortOrder(SortOrder.ASC).addOrder(model.TIPO_SERVIZIO);
                gByExpr.sortOrder(SortOrder.ASC).addOrder(model.SERVIZIO);
                gByExpr.sortOrder(SortOrder.ASC).addOrder(model.VERSIONE_SERVIZIO);
                gByExpr.sortOrder(SortOrder.ASC).addOrder(model.TIPO_DESTINATARIO);
                gByExpr.sortOrder(SortOrder.ASC).addOrder(model.DESTINATARIO);
            } else {
                gByExpr.sortOrder(SortOrder.ASC).addOrder(model.URI_API);
            }
            List<Index> forceIndexes = null;
            try {
                forceIndexes = this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexDistribuzioneServizioGroupBy(this.govwayMonitorProperties.getExternalForceIndexRepository()));
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
            if (forceIndexes != null && !forceIndexes.isEmpty()) {
                for (Index index : forceIndexes) {
                    gByExpr.addForceIndex(index);
                }
            }
            String aliasFieldTipoServizio = "tipo_servizio";
            String aliasFieldServizio = "servizio";
            String aliasFieldVersioneServizio = "versione_servizio";
            String aliasFieldTipoDestinatario = "tipo_destinatario";
            String aliasFieldDestinatario = "destinatario";
            String aliasUriApi = "uri_api";
            UnionExpression unionExpr = new UnionExpression(gByExpr);
            IExpression fakeExpr = this.dao.newExpression();
            UnionExpression unionExprFake = new UnionExpression(fakeExpr);
            ArrayList<String> aliases3dCustom = new ArrayList<String>();
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribServizioSearch.getNumeroDimensioni())) {
                unionExpr.addSelectField(model.DATA, ALIAS_FIELD_DATA_3D);
                unionExprFake.addSelectField((IField)new ConstantField(ALIAS_FIELD_DATA_3D, (Object)FALSA_UNION_DEFAULT_VALUE_TIMESTAMP, model.DATA.getFieldType()), ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribServizioSearch.getNumeroDimensioni())) {
                this.impostaSelectField3dCustom(unionExpr, model, this.distribServizioSearch, this.distribServizioSearch.getNumeroDimensioniCustom(), aliases3dCustom);
                this.impostaSelectField3dCustomFake(unionExprFake, model, this.distribServizioSearch, this.distribServizioSearch.getNumeroDimensioniCustom(), aliases3dCustom);
            }
            if (this.distribServizioSearch.isDistribuzionePerImplementazioneApi()) {
                unionExpr.addSelectField(model.TIPO_SERVIZIO, aliasFieldTipoServizio);
                unionExpr.addSelectField(model.SERVIZIO, aliasFieldServizio);
                unionExpr.addSelectField(model.VERSIONE_SERVIZIO, aliasFieldVersioneServizio);
                unionExpr.addSelectField(model.TIPO_DESTINATARIO, aliasFieldTipoDestinatario);
                unionExpr.addSelectField(model.DESTINATARIO, aliasFieldDestinatario);
                unionExprFake.addSelectField((IField)new ConstantField(aliasFieldTipoServizio, (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_SERVIZIO.getFieldType()), aliasFieldTipoServizio);
                unionExprFake.addSelectField((IField)new ConstantField(aliasFieldServizio, (Object)FALSA_UNION_DEFAULT_VALUE, model.SERVIZIO.getFieldType()), aliasFieldServizio);
                unionExprFake.addSelectField((IField)new ConstantField(aliasFieldVersioneServizio, (Object)FALSA_UNION_DEFAULT_VALUE_VERSIONE, model.VERSIONE_SERVIZIO.getFieldType()), aliasFieldVersioneServizio);
                unionExprFake.addSelectField((IField)new ConstantField(aliasFieldTipoDestinatario, (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_DESTINATARIO.getFieldType()), aliasFieldTipoDestinatario);
                unionExprFake.addSelectField((IField)new ConstantField(aliasFieldDestinatario, (Object)FALSA_UNION_DEFAULT_VALUE, model.DESTINATARIO.getFieldType()), aliasFieldDestinatario);
            } else {
                unionExpr.addSelectField(model.URI_API, aliasUriApi);
                unionExprFake.addSelectField((IField)new ConstantField(aliasUriApi, (Object)FALSA_UNION_DEFAULT_VALUE, model.URI_API.getFieldType()), aliasUriApi);
            }
            Union union = new Union();
            union.setUnionAll(true);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribServizioSearch.getNumeroDimensioni())) {
                union.addField(ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribServizioSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    union.addField(a3dCustom);
                }
            }
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribServizioSearch.getNumeroDimensioni())) {
                union.addGroupBy(ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribServizioSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    union.addGroupBy(a3dCustom);
                }
            }
            if (this.distribServizioSearch.isDistribuzionePerImplementazioneApi()) {
                union.addField(aliasFieldTipoServizio);
                union.addField(aliasFieldServizio);
                union.addField(aliasFieldVersioneServizio);
                union.addField(aliasFieldTipoDestinatario);
                union.addField(aliasFieldDestinatario);
                union.addGroupBy(aliasFieldTipoServizio);
                union.addGroupBy(aliasFieldServizio);
                union.addGroupBy(aliasFieldVersioneServizio);
                union.addGroupBy(aliasFieldTipoDestinatario);
                union.addGroupBy(aliasFieldDestinatario);
            } else {
                union.addField(aliasUriApi);
                union.addGroupBy(aliasUriApi);
            }
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribServizioSearch.getNumeroDimensioni())) {
                SortOrder s2 = this.distribServizioSearch.getSortOrder() != null ? this.distribServizioSearch.getSortOrder() : SortOrder.ASC;
                union.addOrderBy(ALIAS_FIELD_DATA_3D, s2);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribServizioSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    SortOrder s3 = this.distribServizioSearch.getSortOrder() != null ? this.distribServizioSearch.getSortOrder() : SortOrder.ASC;
                    union.addOrderBy(a3dCustom, s3);
                }
            }
            TipoVisualizzazione tipoVisualizzazione = this.distribServizioSearch.getTipoVisualizzazione();
            block10 : switch (tipoVisualizzazione) {
                case DIMENSIONE_TRANSAZIONI: {
                    TipoBanda tipoBanda = this.distribServizioSearch.getTipoBanda();
                    union.addOrderBy("somma", SortOrder.DESC);
                    union.addField("somma", Function.SUM, "dato");
                    switch (tipoBanda) {
                        case COMPLESSIVA: {
                            unionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA, Function.SUM, "dato"));
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_complessiva", (Object)0, model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA.getFieldType()), Function.SUM, "dato"));
                            break;
                        }
                        case INTERNA: {
                            unionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_INTERNA, Function.SUM, "dato"));
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_interna", (Object)0, model.DIMENSIONI_BYTES_BANDA_INTERNA.getFieldType()), Function.SUM, "dato"));
                            break;
                        }
                        case ESTERNA: {
                            unionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_ESTERNA, Function.SUM, "dato"));
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_esterna", (Object)0, model.DIMENSIONI_BYTES_BANDA_ESTERNA.getFieldType()), Function.SUM, "dato"));
                        }
                    }
                    break;
                }
                case NUMERO_TRANSAZIONI: {
                    union.addOrderBy("somma", SortOrder.DESC);
                    union.addField("somma", Function.SUM, "dato");
                    unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("numero_transazioni", (Object)0, model.NUMERO_TRANSAZIONI.getFieldType()), Function.SUM, "dato"));
                    unionExpr.addSelectFunctionField(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "dato"));
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    TipoLatenza tipoLatenza = this.distribServizioSearch.getTipoLatenza();
                    union.addOrderBy("somma", SortOrder.DESC);
                    union.addField("somma", Function.SUM, "dato");
                    switch (tipoLatenza) {
                        case LATENZA_PORTA: {
                            fakeExpr.isNotNull(model.LATENZA_PORTA);
                            gByExpr.isNotNull(model.LATENZA_PORTA);
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_porta", (Object)0, model.LATENZA_PORTA.getFieldType()), Function.SUM, "dato"));
                            unionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_PORTA, (IField)model.NUMERO_TRANSAZIONI, (String)"dato"));
                            break block10;
                        }
                        case LATENZA_SERVIZIO: {
                            fakeExpr.isNotNull(model.LATENZA_SERVIZIO);
                            gByExpr.isNotNull(model.LATENZA_SERVIZIO);
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_servizio", (Object)0, model.LATENZA_SERVIZIO.getFieldType()), Function.SUM, "dato"));
                            unionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_SERVIZIO, (IField)model.NUMERO_TRANSAZIONI, (String)"dato"));
                            break block10;
                        }
                    }
                    fakeExpr.isNotNull(model.LATENZA_TOTALE);
                    gByExpr.isNotNull(model.LATENZA_TOTALE);
                    unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_totale", (Object)0, model.LATENZA_TOTALE.getFieldType()), Function.SUM, "dato"));
                    unionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_TOTALE, (IField)model.NUMERO_TRANSAZIONI, (String)"dato"));
                    break;
                }
            }
            ArrayList<ResDistribuzione> res = new ArrayList<ResDistribuzione>();
            if (start != null) {
                union.setOffset(start);
            }
            if (start != null) {
                union.setLimit(limit);
            }
            this.timeoutEvent = false;
            List list = null;
            if (this.timeoutRicerche == null) {
                list = this.dao.union(union, new UnionExpression[]{unionExpr, unionExprFake});
            } else {
                try {
                    list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.dao.union(union, new UnionExpression[]{unionExpr, unionExprFake})).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof NotFoundException) {
                        throw (NotFoundException)e.getCause();
                    }
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                }
            }
            if (list != null) {
                for (Map row : list) {
                    Object risultato = null;
                    risultato = this.distribServizioSearch.isDistribuzionePerImplementazioneApi() ? (String)row.get(aliasFieldTipoServizio) + "/" + (String)row.get(aliasFieldServizio) + ":" + row.get(aliasFieldVersioneServizio) : (String)row.get(aliasUriApi);
                    if (risultato != null && ((String)risultato).contains(FALSA_UNION_DEFAULT_VALUE)) continue;
                    ResDistribuzione3D r = null;
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribServizioSearch.getNumeroDimensioni())) {
                        r = new ResDistribuzione3D();
                        Date data = (Date)row.get(ALIAS_FIELD_DATA_3D);
                        r.setData(data);
                        r.setDataFormattata(StatsUtils.formatDate(tipologia, data));
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribServizioSearch.getNumeroDimensioni())) {
                        r = new ResDistribuzione3DCustom();
                        StringBuilder resFailure = new StringBuilder();
                        try {
                            BooleanNullable bSkip = BooleanNullable.NULL();
                            String customData = this.getCustomData(row, this.distribServizioSearch.getNumeroDimensioniCustom(), this.distribServizioSearch, resFailure, bSkip);
                            if (bSkip != null && bSkip.getValue() != null && bSkip.getValue().booleanValue()) continue;
                            if (customData == null) {
                                if (resFailure.length() <= 0) {
                                    resFailure.append("-?-");
                                }
                                throw new CoreException("Informazione personalizzata non presente");
                            }
                            ((ResDistribuzione3DCustom)r).setDatoCustom(customData);
                        }
                        catch (Exception t) {
                            ((ResDistribuzione3DCustom)r).setDatoCustom("Servizio '" + (String)risultato + "' - " + resFailure.toString());
                            StatisticheGiornaliereService.logError("Traduzione Servizio(" + (String)risultato + ") '" + resFailure.toString() + "' non riuscita: " + t.getMessage(), t);
                        }
                    } else {
                        r = new ResDistribuzione();
                    }
                    if (this.distribServizioSearch.isDistribuzionePerImplementazioneApi()) {
                        r.setRisultato((String)risultato);
                        r.getParentMap().put("0", (String)row.get(aliasFieldTipoDestinatario) + "/" + (String)row.get(aliasFieldDestinatario));
                    } else {
                        risultato = this.getLabelCredenzialeFieldGroupBy((String)risultato, this.distribServizioSearch, new StringBuilder());
                        r.setRisultato("___API___" + (String)risultato);
                    }
                    Number somma = StatsUtils.converToNumber(row.get("somma"));
                    if (somma != null) {
                        r.setSomma(somma);
                    } else {
                        r.setSomma((Number)0);
                    }
                    res.add((ResDistribuzione)r);
                }
            }
            return res;
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (NotFoundException e) {
            StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente.");
            return new ArrayList<ResDistribuzione>();
        }
    }

    private IExpression createDistribuzioneServizioExpression(IServiceSearchWithoutId<?> dao, StatisticaModel model, boolean isCount) throws ServiceException {
        IExpression expr = null;
        StatisticheGiornaliereService.logDebug("creo Expression per distribuzione Servizio!");
        List listaSoggettiGestione = this.distribServizioSearch.getSoggettiGestione();
        try {
            IExpression[] orSoggetti;
            EsitoUtils esitoUtils = new EsitoUtils(log, this.distribServizioSearch.getProtocollo());
            expr = dao.newExpression();
            expr.between(model.DATA, (Object)this.distribServizioSearch.getDataInizio(), (Object)this.distribServizioSearch.getDataFine());
            StatisticheUtils.selezionaRecordValidi((IExpression)expr, (StatisticaModel)model);
            String protocollo = null;
            if (this.distribServizioSearch.isSetFiltroProtocollo()) {
                protocollo = this.distribServizioSearch.getProtocollo();
                this.impostaTipiCompatibiliConProtocollo(dao, model, expr, protocollo, this.distribServizioSearch.getTipologiaRicercaEnum());
            }
            if (this.distribServizioSearch.getPermessiUtenteOperatore() != null) {
                IExpression permessi = this.distribServizioSearch.getPermessiUtenteOperatore().toExpression(dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                expr.and(new IExpression[]{permessi});
            }
            if (Utility.isFiltroDominioAbilitato() && this.distribServizioSearch.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.distribServizioSearch.getSoggettoLocale()) && !"--".equals(this.distribServizioSearch.getSoggettoLocale())) {
                String tipoSoggettoLocale = this.distribServizioSearch.getTipoSoggettoLocale();
                String nomeSoggettoLocale = this.distribServizioSearch.getSoggettoLocale();
                String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                expr.and().equals(model.ID_PORTA, (Object)idPorta);
            }
            esitoUtils.setExpression(expr, this.distribServizioSearch.getEsitoGruppo(), this.distribServizioSearch.getEsitoDettaglio(), this.distribServizioSearch.getEsitoDettaglioPersonalizzato(), this.distribServizioSearch.getEsitoContesto(), this.distribServizioSearch.isEscludiRichiesteScartate(), model.ESITO, model.ESITO_CONTESTO, dao.newExpression());
            if (this.distribServizioSearch.getTipologiaRicercaEnum() == null || TipologiaRicerca.all.equals((Object)this.distribServizioSearch.getTipologiaRicercaEnum())) {
                boolean trafficoSoggetto = StringUtils.isNotBlank((String)this.distribServizioSearch.getTrafficoPerSoggetto());
                boolean soggetto = !listaSoggettiGestione.isEmpty();
                String tipoTrafficoSoggetto = null;
                String nomeTrafficoSoggetto = null;
                if (trafficoSoggetto) {
                    tipoTrafficoSoggetto = this.distribServizioSearch.getTipoTrafficoPerSoggetto();
                    nomeTrafficoSoggetto = this.distribServizioSearch.getTrafficoPerSoggetto();
                }
                IExpression e1 = dao.newExpression();
                IExpression e2 = dao.newExpression();
                if (trafficoSoggetto && soggetto) {
                    expr.and();
                    if (!listaSoggettiGestione.isEmpty()) {
                        IExpression[] orSoggetti2 = new IExpression[listaSoggettiGestione.size()];
                        IExpression[] orSoggetti22 = new IExpression[listaSoggettiGestione.size()];
                        int i = 0;
                        for (Soggetto sog : listaSoggettiGestione) {
                            IExpression se = dao.newExpression();
                            IExpression se2 = dao.newExpression();
                            se.equals(model.TIPO_MITTENTE, (Object)sog.getTipoSoggetto());
                            se.and().equals(model.MITTENTE, (Object)sog.getNomeSoggetto());
                            orSoggetti2[i] = se;
                            se2.equals(model.TIPO_DESTINATARIO, (Object)sog.getTipoSoggetto());
                            se2.and().equals(model.DESTINATARIO, (Object)sog.getNomeSoggetto());
                            orSoggetti22[i] = se2;
                            ++i;
                        }
                        e1.or(orSoggetti2);
                        e2.or(orSoggetti22);
                    }
                    e1.and().equals(model.TIPO_DESTINATARIO, (Object)tipoTrafficoSoggetto);
                    e1.and().equals(model.DESTINATARIO, (Object)nomeTrafficoSoggetto);
                    e2.and().equals(model.TIPO_MITTENTE, (Object)tipoTrafficoSoggetto);
                    e2.and().equals(model.MITTENTE, (Object)nomeTrafficoSoggetto);
                    expr.or(e1, e2);
                } else if (trafficoSoggetto && !soggetto) {
                    expr.and();
                    e1.equals(model.TIPO_DESTINATARIO, (Object)tipoTrafficoSoggetto);
                    e1.and().equals(model.DESTINATARIO, (Object)nomeTrafficoSoggetto);
                    e2.equals(model.TIPO_MITTENTE, (Object)tipoTrafficoSoggetto);
                    e2.and().equals(model.MITTENTE, (Object)nomeTrafficoSoggetto);
                    expr.or(e1, e2);
                } else if (!trafficoSoggetto && soggetto) {
                    expr.and();
                    if (!listaSoggettiGestione.isEmpty()) {
                        IExpression[] orSoggetti3 = new IExpression[listaSoggettiGestione.size()];
                        IExpression[] orSoggetti2 = new IExpression[listaSoggettiGestione.size()];
                        int i = 0;
                        for (Soggetto sog : listaSoggettiGestione) {
                            IExpression se = dao.newExpression();
                            IExpression se2 = dao.newExpression();
                            se.equals(model.TIPO_MITTENTE, (Object)sog.getTipoSoggetto());
                            se.and().equals(model.MITTENTE, (Object)sog.getNomeSoggetto());
                            orSoggetti3[i] = se;
                            se2.equals(model.TIPO_DESTINATARIO, (Object)sog.getTipoSoggetto());
                            se2.and().equals(model.DESTINATARIO, (Object)sog.getNomeSoggetto());
                            orSoggetti2[i] = se2;
                            ++i;
                        }
                        e1.or(orSoggetti3);
                        e2.or(orSoggetti2);
                    }
                    expr.or(e1, e2);
                }
            } else if (TipologiaRicerca.ingresso.equals((Object)this.distribServizioSearch.getTipologiaRicercaEnum())) {
                expr.and().notEquals(model.TIPO_PORTA, (Object)"delegata");
                if (!listaSoggettiGestione.isEmpty()) {
                    expr.and();
                    orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_DESTINATARIO, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.DESTINATARIO, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    expr.or(orSoggetti);
                }
                boolean ignoreSetMittente = this.isIgnoreSetMittente(this.distribServizioSearch);
                if (StringUtils.isNotBlank((String)this.distribServizioSearch.getNomeMittente()) && !ignoreSetMittente) {
                    expr.and().equals(model.TIPO_MITTENTE, (Object)this.distribServizioSearch.getTipoMittente());
                    expr.and().equals(model.MITTENTE, (Object)this.distribServizioSearch.getNomeMittente());
                }
            } else {
                expr.and().notEquals(model.TIPO_PORTA, (Object)"applicativa");
                if (!listaSoggettiGestione.isEmpty()) {
                    expr.and();
                    orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_MITTENTE, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.MITTENTE, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    expr.or(orSoggetti);
                }
                if (StringUtils.isNotBlank((String)this.distribServizioSearch.getNomeDestinatario())) {
                    expr.and().equals(model.TIPO_DESTINATARIO, (Object)this.distribServizioSearch.getTipoDestinatario());
                    expr.and().equals(model.DESTINATARIO, (Object)this.distribServizioSearch.getNomeDestinatario());
                }
            }
            this.impostaFiltroDatiMittente(expr, this.distribServizioSearch, model, isCount);
            this.impostaFiltroGruppo(expr, this.distribServizioSearch, model, isCount);
            this.impostaFiltroApi(expr, this.distribServizioSearch, model, isCount);
            this.impostaFiltroIdClusterOrCanale(expr, this.distribServizioSearch, model, isCount);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribServizioSearch.getNumeroDimensioni())) {
                expr.addGroupBy(model.DATA);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribServizioSearch.getNumeroDimensioni())) {
                this.impostaGroupByFiltro3dCustom(expr, model, this.distribServizioSearch, this.distribServizioSearch.getNumeroDimensioniCustom());
            }
            if (this.distribServizioSearch.isDistribuzionePerImplementazioneApi()) {
                expr.notEquals(model.TIPO_SERVIZIO, (Object)"-");
                expr.notEquals(model.SERVIZIO, (Object)"-");
                expr.notEquals(model.VERSIONE_SERVIZIO, (Object)Costanti.INFORMAZIONE_VERSIONE_NON_DISPONIBILE);
                expr.addGroupBy(model.TIPO_SERVIZIO);
                expr.addGroupBy(model.SERVIZIO);
                expr.addGroupBy(model.VERSIONE_SERVIZIO);
                expr.notEquals(model.TIPO_DESTINATARIO, (Object)"-");
                expr.notEquals(model.DESTINATARIO, (Object)"-");
                expr.addGroupBy(model.TIPO_DESTINATARIO);
                expr.addGroupBy(model.DESTINATARIO);
            } else {
                expr.notEquals(model.URI_API, (Object)"-");
                expr.addGroupBy(model.URI_API);
            }
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (CoreException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        return expr;
    }

    @Override
    public int countAllDistribuzioneAzione() throws ServiceException {
        try {
            NonNegativeNumber nnn;
            StatisticType tipologia = this.checkStatisticType(this.distribAzioneSearch);
            StatisticaModel model = null;
            IStatisticaGiornalieraServiceSearch dao = null;
            switch (tipologia) {
                case GIORNALIERA: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    dao = this.statGiornaliereSearchDAO;
                    break;
                }
                case MENSILE: {
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    dao = this.statMensileSearchDAO;
                    break;
                }
                case ORARIA: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    dao = this.statOrariaSearchDAO;
                    break;
                }
                case SETTIMANALE: {
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    dao = this.statSettimanaleSearchDAO;
                }
            }
            if (dao == null) {
                throw new ServiceException("DAO unknown");
            }
            if (model == null) {
                throw new ServiceException("Model unknown");
            }
            List<Index> forceIndexes = null;
            try {
                forceIndexes = this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexDistribuzioneAzioneCount(this.govwayMonitorProperties.getExternalForceIndexRepository()));
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
            IExpression gByExpr = this.createDistribuzioneAzioneExpression((IServiceSearchWithoutId<?>)dao, model, true);
            if (forceIndexes != null && !forceIndexes.isEmpty()) {
                for (Index index : forceIndexes) {
                    gByExpr.addForceIndex(index);
                }
            }
            return (nnn = dao.count(gByExpr)) != null ? (int)nnn.longValue() : 0;
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<ResDistribuzione> findAllDistribuzioneAzione() throws ServiceException {
        return this.executeDistribuzioneAzione(null, null);
    }

    @Override
    public List<ResDistribuzione> findAllDistribuzioneAzione(int start, int limit) throws ServiceException {
        return this.executeDistribuzioneAzione(start, limit);
    }

    private IExpression createDistribuzioneAzioneExpression(IServiceSearchWithoutId<?> dao, StatisticaModel model, boolean isCount) throws ServiceException {
        IExpression expr = null;
        StatisticheGiornaliereService.logDebug("creo Expression per distribuzione Azione!");
        List listaSoggettiGestione = this.distribAzioneSearch.getSoggettiGestione();
        try {
            IExpression[] orSoggetti;
            EsitoUtils esitoUtils = new EsitoUtils(log, this.distribAzioneSearch.getProtocollo());
            expr = dao.newExpression();
            expr.between(model.DATA, (Object)this.distribAzioneSearch.getDataInizio(), (Object)this.distribAzioneSearch.getDataFine());
            StatisticheUtils.selezionaRecordValidi((IExpression)expr, (StatisticaModel)model);
            String protocollo = null;
            if (this.distribAzioneSearch.isSetFiltroProtocollo()) {
                protocollo = this.distribAzioneSearch.getProtocollo();
                this.impostaTipiCompatibiliConProtocollo(dao, model, expr, protocollo, this.distribAzioneSearch.getTipologiaRicercaEnum());
            }
            if (this.distribAzioneSearch.getPermessiUtenteOperatore() != null) {
                IExpression permessi = this.distribAzioneSearch.getPermessiUtenteOperatore().toExpression(dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                expr.and(new IExpression[]{permessi});
            }
            if (Utility.isFiltroDominioAbilitato() && this.distribAzioneSearch.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.distribAzioneSearch.getSoggettoLocale()) && !"--".equals(this.distribAzioneSearch.getSoggettoLocale())) {
                String tipoSoggettoLocale = this.distribAzioneSearch.getTipoSoggettoLocale();
                String nomeSoggettoLocale = this.distribAzioneSearch.getSoggettoLocale();
                String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                expr.and().equals(model.ID_PORTA, (Object)idPorta);
            }
            esitoUtils.setExpression(expr, this.distribAzioneSearch.getEsitoGruppo(), this.distribAzioneSearch.getEsitoDettaglio(), this.distribAzioneSearch.getEsitoDettaglioPersonalizzato(), this.distribAzioneSearch.getEsitoContesto(), this.distribAzioneSearch.isEscludiRichiesteScartate(), model.ESITO, model.ESITO_CONTESTO, dao.newExpression());
            if (this.distribAzioneSearch.getTipologiaRicercaEnum() == null || TipologiaRicerca.all.equals((Object)this.distribAzioneSearch.getTipologiaRicercaEnum())) {
                boolean trafficoSoggetto = StringUtils.isNotBlank((String)this.distribAzioneSearch.getTrafficoPerSoggetto());
                boolean soggetto = !listaSoggettiGestione.isEmpty();
                String tipoTrafficoSoggetto = null;
                String nomeTrafficoSoggetto = null;
                if (trafficoSoggetto) {
                    tipoTrafficoSoggetto = this.distribAzioneSearch.getTipoTrafficoPerSoggetto();
                    nomeTrafficoSoggetto = this.distribAzioneSearch.getTrafficoPerSoggetto();
                }
                IExpression e1 = dao.newExpression();
                IExpression e2 = dao.newExpression();
                if (trafficoSoggetto && soggetto) {
                    expr.and();
                    if (!listaSoggettiGestione.isEmpty()) {
                        IExpression[] orSoggetti2 = new IExpression[listaSoggettiGestione.size()];
                        IExpression[] orSoggetti22 = new IExpression[listaSoggettiGestione.size()];
                        int i = 0;
                        for (Soggetto sog : listaSoggettiGestione) {
                            IExpression se = dao.newExpression();
                            IExpression se2 = dao.newExpression();
                            se.equals(model.TIPO_MITTENTE, (Object)sog.getTipoSoggetto());
                            se.and().equals(model.MITTENTE, (Object)sog.getNomeSoggetto());
                            orSoggetti2[i] = se;
                            se2.equals(model.TIPO_DESTINATARIO, (Object)sog.getTipoSoggetto());
                            se2.and().equals(model.DESTINATARIO, (Object)sog.getNomeSoggetto());
                            orSoggetti22[i] = se2;
                            ++i;
                        }
                        e1.or(orSoggetti2);
                        e2.or(orSoggetti22);
                    }
                    e1.and().equals(model.TIPO_DESTINATARIO, (Object)tipoTrafficoSoggetto);
                    e1.and().equals(model.DESTINATARIO, (Object)nomeTrafficoSoggetto);
                    e2.and().equals(model.TIPO_MITTENTE, (Object)tipoTrafficoSoggetto);
                    e2.and().equals(model.MITTENTE, (Object)nomeTrafficoSoggetto);
                    expr.or(e1, e2);
                } else if (trafficoSoggetto && !soggetto) {
                    expr.and();
                    e1.equals(model.TIPO_DESTINATARIO, (Object)tipoTrafficoSoggetto);
                    e1.and().equals(model.DESTINATARIO, (Object)nomeTrafficoSoggetto);
                    e2.equals(model.TIPO_MITTENTE, (Object)tipoTrafficoSoggetto);
                    e2.and().equals(model.MITTENTE, (Object)nomeTrafficoSoggetto);
                    expr.or(e1, e2);
                } else if (!trafficoSoggetto && soggetto) {
                    expr.and();
                    if (!listaSoggettiGestione.isEmpty()) {
                        IExpression[] orSoggetti3 = new IExpression[listaSoggettiGestione.size()];
                        IExpression[] orSoggetti2 = new IExpression[listaSoggettiGestione.size()];
                        int i = 0;
                        for (Soggetto sog : listaSoggettiGestione) {
                            IExpression se = dao.newExpression();
                            IExpression se2 = dao.newExpression();
                            se.equals(model.TIPO_MITTENTE, (Object)sog.getTipoSoggetto());
                            se.and().equals(model.MITTENTE, (Object)sog.getNomeSoggetto());
                            orSoggetti3[i] = se;
                            se2.equals(model.TIPO_DESTINATARIO, (Object)sog.getTipoSoggetto());
                            se2.and().equals(model.DESTINATARIO, (Object)sog.getNomeSoggetto());
                            orSoggetti2[i] = se2;
                            ++i;
                        }
                        e1.or(orSoggetti3);
                        e2.or(orSoggetti2);
                    }
                    expr.or(e1, e2);
                }
            } else if (TipologiaRicerca.ingresso.equals((Object)this.distribAzioneSearch.getTipologiaRicercaEnum())) {
                expr.and().notEquals(model.TIPO_PORTA, (Object)"delegata");
                if (!listaSoggettiGestione.isEmpty()) {
                    expr.and();
                    orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_DESTINATARIO, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.DESTINATARIO, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    expr.or(orSoggetti);
                }
                boolean ignoreSetMittente = this.isIgnoreSetMittente(this.distribAzioneSearch);
                if (StringUtils.isNotBlank((String)this.distribAzioneSearch.getNomeMittente()) && !ignoreSetMittente) {
                    expr.and().equals(model.TIPO_MITTENTE, (Object)this.distribAzioneSearch.getTipoMittente());
                    expr.and().equals(model.MITTENTE, (Object)this.distribAzioneSearch.getNomeMittente());
                }
            } else {
                expr.and().notEquals(model.TIPO_PORTA, (Object)"applicativa");
                if (!listaSoggettiGestione.isEmpty()) {
                    expr.and();
                    orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_MITTENTE, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.MITTENTE, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    expr.or(orSoggetti);
                }
                if (StringUtils.isNotBlank((String)this.distribAzioneSearch.getNomeDestinatario())) {
                    expr.and().equals(model.TIPO_DESTINATARIO, (Object)this.distribAzioneSearch.getTipoDestinatario());
                    expr.and().equals(model.DESTINATARIO, (Object)this.distribAzioneSearch.getNomeDestinatario());
                }
            }
            if (StringUtils.isNotBlank((String)this.distribAzioneSearch.getNomeServizio())) {
                IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)this.distribAzioneSearch.getNomeServizio());
                expr.and().equals(model.TIPO_DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getTipo()).equals(model.DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getNome()).equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo()).equals(model.SERVIZIO, (Object)idServizio.getNome()).equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
            }
            this.impostaFiltroDatiMittente(expr, this.distribAzioneSearch, model, isCount);
            this.impostaFiltroGruppo(expr, this.distribAzioneSearch, model, isCount);
            this.impostaFiltroApi(expr, this.distribAzioneSearch, model, isCount);
            this.impostaFiltroIdClusterOrCanale(expr, this.distribAzioneSearch, model, isCount);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                expr.addGroupBy(model.DATA);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                this.impostaGroupByFiltro3dCustom(expr, model, this.distribAzioneSearch, this.distribAzioneSearch.getNumeroDimensioniCustom());
            }
            expr.notEquals(model.AZIONE, (Object)"-");
            expr.addGroupBy(model.AZIONE);
            expr.notEquals(model.TIPO_SERVIZIO, (Object)"-");
            expr.notEquals(model.SERVIZIO, (Object)"-");
            expr.notEquals(model.VERSIONE_SERVIZIO, (Object)Costanti.INFORMAZIONE_VERSIONE_NON_DISPONIBILE);
            expr.addGroupBy(model.TIPO_SERVIZIO);
            expr.addGroupBy(model.SERVIZIO);
            expr.addGroupBy(model.VERSIONE_SERVIZIO);
            expr.notEquals(model.TIPO_DESTINATARIO, (Object)"-");
            expr.notEquals(model.DESTINATARIO, (Object)"-");
            expr.addGroupBy(model.TIPO_DESTINATARIO);
            expr.addGroupBy(model.DESTINATARIO);
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (CoreException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        return expr;
    }

    private List<ResDistribuzione> executeDistribuzioneAzione(Integer start, Integer limit) throws ServiceException {
        try {
            SortOrder s;
            StatisticType tipologia = this.checkStatisticType(this.distribAzioneSearch);
            StatisticaModel model = null;
            switch (tipologia) {
                case GIORNALIERA: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    this.dao = this.statGiornaliereSearchDAO;
                    break;
                }
                case MENSILE: {
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    this.dao = this.statMensileSearchDAO;
                    break;
                }
                case ORARIA: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    this.dao = this.statOrariaSearchDAO;
                    break;
                }
                case SETTIMANALE: {
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    this.dao = this.statSettimanaleSearchDAO;
                }
            }
            if (this.dao == null) {
                throw new ServiceException("DAO unknown");
            }
            if (model == null) {
                throw new ServiceException("Model unknown");
            }
            ISQLFieldConverter fieldConverter = ((IDBServiceUtilities)this.dao).getFieldConverter();
            IExpression gByExpr = this.createDistribuzioneAzioneExpression(this.dao, model, false);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                s = this.distribAzioneSearch.getSortOrder() != null ? this.distribAzioneSearch.getSortOrder() : SortOrder.ASC;
                gByExpr.sortOrder(s).addOrder(model.DATA);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                s = this.distribAzioneSearch.getSortOrder() != null ? this.distribAzioneSearch.getSortOrder() : SortOrder.ASC;
                this.impostaSortOrder3dCustom(gByExpr, model, this.distribAzioneSearch, this.distribAzioneSearch.getNumeroDimensioniCustom(), s);
            }
            gByExpr.sortOrder(SortOrder.ASC).addOrder(model.AZIONE);
            gByExpr.sortOrder(SortOrder.ASC).addOrder(model.TIPO_SERVIZIO);
            gByExpr.sortOrder(SortOrder.ASC).addOrder(model.SERVIZIO);
            gByExpr.sortOrder(SortOrder.ASC).addOrder(model.VERSIONE_SERVIZIO);
            gByExpr.sortOrder(SortOrder.ASC).addOrder(model.TIPO_DESTINATARIO);
            gByExpr.sortOrder(SortOrder.ASC).addOrder(model.DESTINATARIO);
            List<Index> forceIndexes = null;
            try {
                forceIndexes = this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexDistribuzioneAzioneGroupBy(this.govwayMonitorProperties.getExternalForceIndexRepository()));
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
            if (forceIndexes != null && !forceIndexes.isEmpty()) {
                for (Index index : forceIndexes) {
                    gByExpr.addForceIndex(index);
                }
            }
            UnionExpression unionExpr = new UnionExpression(gByExpr);
            ArrayList<String> aliases3dCustom = new ArrayList<String>();
            String aliasFieldAzione = "azione";
            String aliasFieldTipoServizio = "tipo_servizio";
            String aliasFieldServizio = "servizio";
            String aliasFieldVersioneServizio = "versione_servizio";
            String aliasFieldTipoDestinatario = "tipo_destinatario";
            String aliasFieldDestinatario = "destinatario";
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                unionExpr.addSelectField(model.DATA, ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                this.impostaSelectField3dCustom(unionExpr, model, this.distribAzioneSearch, this.distribAzioneSearch.getNumeroDimensioniCustom(), aliases3dCustom);
            }
            unionExpr.addSelectField(model.AZIONE, aliasFieldAzione);
            unionExpr.addSelectField(model.TIPO_SERVIZIO, aliasFieldTipoServizio);
            unionExpr.addSelectField(model.SERVIZIO, aliasFieldServizio);
            unionExpr.addSelectField(model.VERSIONE_SERVIZIO, aliasFieldVersioneServizio);
            unionExpr.addSelectField(model.TIPO_DESTINATARIO, aliasFieldTipoDestinatario);
            unionExpr.addSelectField(model.DESTINATARIO, aliasFieldDestinatario);
            IExpression fakeExpr = this.dao.newExpression();
            UnionExpression unionExprFake = new UnionExpression(fakeExpr);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                unionExprFake.addSelectField((IField)new ConstantField(ALIAS_FIELD_DATA_3D, (Object)FALSA_UNION_DEFAULT_VALUE_TIMESTAMP, model.DATA.getFieldType()), ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                this.impostaSelectField3dCustomFake(unionExprFake, model, this.distribAzioneSearch, this.distribAzioneSearch.getNumeroDimensioniCustom(), aliases3dCustom);
            }
            unionExprFake.addSelectField((IField)new ConstantField(aliasFieldAzione, (Object)FALSA_UNION_DEFAULT_VALUE, model.AZIONE.getFieldType()), aliasFieldAzione);
            unionExprFake.addSelectField((IField)new ConstantField(aliasFieldTipoServizio, (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_SERVIZIO.getFieldType()), aliasFieldTipoServizio);
            unionExprFake.addSelectField((IField)new ConstantField(aliasFieldServizio, (Object)FALSA_UNION_DEFAULT_VALUE, model.SERVIZIO.getFieldType()), aliasFieldServizio);
            unionExprFake.addSelectField((IField)new ConstantField(aliasFieldVersioneServizio, (Object)FALSA_UNION_DEFAULT_VALUE_VERSIONE, model.VERSIONE_SERVIZIO.getFieldType()), aliasFieldVersioneServizio);
            unionExprFake.addSelectField((IField)new ConstantField(aliasFieldTipoDestinatario, (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_DESTINATARIO.getFieldType()), aliasFieldTipoDestinatario);
            unionExprFake.addSelectField((IField)new ConstantField(aliasFieldDestinatario, (Object)FALSA_UNION_DEFAULT_VALUE, model.DESTINATARIO.getFieldType()), aliasFieldDestinatario);
            Union union = new Union();
            union.setUnionAll(true);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                union.addField(ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    union.addField(a3dCustom);
                }
            }
            union.addField(aliasFieldAzione);
            union.addField(aliasFieldTipoServizio);
            union.addField(aliasFieldServizio);
            union.addField(aliasFieldVersioneServizio);
            union.addField(aliasFieldTipoDestinatario);
            union.addField(aliasFieldDestinatario);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                union.addGroupBy(ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    union.addGroupBy(a3dCustom);
                }
            }
            union.addGroupBy(aliasFieldAzione);
            union.addGroupBy(aliasFieldTipoServizio);
            union.addGroupBy(aliasFieldServizio);
            union.addGroupBy(aliasFieldVersioneServizio);
            union.addGroupBy(aliasFieldTipoDestinatario);
            union.addGroupBy(aliasFieldDestinatario);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                SortOrder s2 = this.distribAzioneSearch.getSortOrder() != null ? this.distribAzioneSearch.getSortOrder() : SortOrder.ASC;
                union.addOrderBy(ALIAS_FIELD_DATA_3D, s2);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    SortOrder s3 = this.distribAzioneSearch.getSortOrder() != null ? this.distribAzioneSearch.getSortOrder() : SortOrder.ASC;
                    union.addOrderBy(a3dCustom, s3);
                }
            }
            TipoVisualizzazione tipoVisualizzazione = this.distribAzioneSearch.getTipoVisualizzazione();
            String sommaAliasName = "somma";
            String datoParamAliasName = "dato";
            block10 : switch (tipoVisualizzazione) {
                case DIMENSIONE_TRANSAZIONI: {
                    TipoBanda tipoBanda = this.distribAzioneSearch.getTipoBanda();
                    union.addOrderBy(sommaAliasName, SortOrder.DESC);
                    union.addField(sommaAliasName, Function.SUM, datoParamAliasName);
                    switch (tipoBanda) {
                        case COMPLESSIVA: {
                            unionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA, Function.SUM, datoParamAliasName));
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_complessiva", (Object)0, model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA.getFieldType()), Function.SUM, datoParamAliasName));
                            break;
                        }
                        case INTERNA: {
                            unionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_INTERNA, Function.SUM, datoParamAliasName));
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_interna", (Object)0, model.DIMENSIONI_BYTES_BANDA_INTERNA.getFieldType()), Function.SUM, datoParamAliasName));
                            break;
                        }
                        case ESTERNA: {
                            unionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_ESTERNA, Function.SUM, datoParamAliasName));
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_esterna", (Object)0, model.DIMENSIONI_BYTES_BANDA_ESTERNA.getFieldType()), Function.SUM, datoParamAliasName));
                        }
                    }
                    break;
                }
                case NUMERO_TRANSAZIONI: {
                    union.addOrderBy(sommaAliasName, SortOrder.DESC);
                    union.addField(sommaAliasName, Function.SUM, datoParamAliasName);
                    unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("numero_transazioni", (Object)0, model.NUMERO_TRANSAZIONI.getFieldType()), Function.SUM, datoParamAliasName));
                    unionExpr.addSelectFunctionField(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, datoParamAliasName));
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    TipoLatenza tipoLatenza = this.distribAzioneSearch.getTipoLatenza();
                    union.addOrderBy(sommaAliasName, SortOrder.DESC);
                    union.addField(sommaAliasName, Function.SUM, datoParamAliasName);
                    switch (tipoLatenza) {
                        case LATENZA_PORTA: {
                            fakeExpr.isNotNull(model.LATENZA_PORTA);
                            gByExpr.isNotNull(model.LATENZA_PORTA);
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_porta", (Object)0, model.LATENZA_PORTA.getFieldType()), Function.SUM, datoParamAliasName));
                            unionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_PORTA, (IField)model.NUMERO_TRANSAZIONI, (String)datoParamAliasName));
                            break block10;
                        }
                        case LATENZA_SERVIZIO: {
                            fakeExpr.isNotNull(model.LATENZA_SERVIZIO);
                            gByExpr.isNotNull(model.LATENZA_SERVIZIO);
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_servizio", (Object)0, model.LATENZA_SERVIZIO.getFieldType()), Function.SUM, datoParamAliasName));
                            unionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_SERVIZIO, (IField)model.NUMERO_TRANSAZIONI, (String)datoParamAliasName));
                            break block10;
                        }
                    }
                    fakeExpr.isNotNull(model.LATENZA_TOTALE);
                    gByExpr.isNotNull(model.LATENZA_TOTALE);
                    unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_totale", (Object)0, model.LATENZA_TOTALE.getFieldType()), Function.SUM, datoParamAliasName));
                    unionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_TOTALE, (IField)model.NUMERO_TRANSAZIONI, (String)datoParamAliasName));
                    break;
                }
            }
            ArrayList<ResDistribuzione> res = new ArrayList<ResDistribuzione>();
            if (start != null) {
                union.setOffset(start);
            }
            if (start != null) {
                union.setLimit(limit);
            }
            this.timeoutEvent = false;
            List list = null;
            if (this.timeoutRicerche == null) {
                list = this.dao.union(union, new UnionExpression[]{unionExpr, unionExprFake});
            } else {
                try {
                    list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.dao.union(union, new UnionExpression[]{unionExpr, unionExprFake})).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof NotFoundException) {
                        throw (NotFoundException)e.getCause();
                    }
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                }
            }
            if (list != null) {
                for (Map row : list) {
                    String risultato = (String)row.get(aliasFieldAzione);
                    if (risultato != null && risultato.contains(FALSA_UNION_DEFAULT_VALUE)) continue;
                    ResDistribuzione3D r = null;
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                        r = new ResDistribuzione3D();
                        Date data = (Date)row.get(ALIAS_FIELD_DATA_3D);
                        r.setData(data);
                        r.setDataFormattata(StatsUtils.formatDate(tipologia, data));
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribAzioneSearch.getNumeroDimensioni())) {
                        r = new ResDistribuzione3DCustom();
                        StringBuilder resFailure = new StringBuilder();
                        try {
                            BooleanNullable bSkip = BooleanNullable.NULL();
                            String customData = this.getCustomData(row, this.distribAzioneSearch.getNumeroDimensioniCustom(), this.distribAzioneSearch, resFailure, bSkip);
                            if (bSkip != null && bSkip.getValue() != null && bSkip.getValue().booleanValue()) continue;
                            if (customData == null) {
                                if (resFailure.length() <= 0) {
                                    resFailure.append("-?-");
                                }
                                throw new CoreException("Informazione personalizzata non presente");
                            }
                            ((ResDistribuzione3DCustom)r).setDatoCustom(customData);
                        }
                        catch (Exception t) {
                            ((ResDistribuzione3DCustom)r).setDatoCustom("Azione '" + risultato + "' - " + resFailure.toString());
                            StatisticheGiornaliereService.logError("Traduzione Azione(" + risultato + ") '" + resFailure.toString() + "' non riuscita: " + t.getMessage(), t);
                        }
                    } else {
                        r = new ResDistribuzione();
                    }
                    r.setRisultato(risultato);
                    r.getParentMap().put("0", (String)row.get(aliasFieldTipoServizio) + "/" + (String)row.get(aliasFieldServizio) + ":" + row.get(aliasFieldVersioneServizio));
                    r.getParentMap().put("1", (String)row.get(aliasFieldTipoDestinatario) + "/" + (String)row.get(aliasFieldDestinatario));
                    Number somma = StatsUtils.converToNumber(row.get(sommaAliasName));
                    if (somma != null) {
                        r.setSomma(somma);
                    } else {
                        r.setSomma((Number)0);
                    }
                    res.add((ResDistribuzione)r);
                }
            }
            return res;
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (NotFoundException e) {
            StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente.");
            return new ArrayList<ResDistribuzione>();
        }
    }

    @Override
    public int countAllDistribuzioneServizioApplicativo() throws ServiceException {
        try {
            NonNegativeNumber nnn;
            StatisticType tipologia = this.checkStatisticType(this.distribSaSearch);
            StatisticaModel model = null;
            IStatisticaGiornalieraServiceSearch dao = null;
            switch (tipologia) {
                case GIORNALIERA: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    dao = this.statGiornaliereSearchDAO;
                    break;
                }
                case MENSILE: {
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    dao = this.statMensileSearchDAO;
                    break;
                }
                case ORARIA: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    dao = this.statOrariaSearchDAO;
                    break;
                }
                case SETTIMANALE: {
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    dao = this.statSettimanaleSearchDAO;
                }
            }
            if (dao == null) {
                throw new ServiceException("Dao sconosciuto");
            }
            boolean forceErogazione = false;
            boolean forceFruizione = false;
            if (this.distribSaSearch.getTipologiaRicercaEnum() == null || TipologiaRicerca.all.equals((Object)this.distribSaSearch.getTipologiaRicercaEnum())) {
                forceErogazione = true;
                forceFruizione = true;
            } else if (TipologiaRicerca.ingresso.equals((Object)this.distribSaSearch.getTipologiaRicercaEnum())) {
                forceErogazione = true;
            } else {
                forceFruizione = true;
            }
            List<Index> forceIndexes = null;
            try {
                forceIndexes = this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexDistribuzioneServizioApplicativoCount(this.govwayMonitorProperties.getExternalForceIndexRepository()));
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
            if (forceErogazione || forceFruizione) {
                Object nnn2;
                IExpression expr;
                int count = 0;
                if (forceErogazione) {
                    expr = this.createDistribuzioneServizioApplicativoExpression((IServiceSearchWithoutId<?>)dao, model, true, forceErogazione, false);
                    if (forceIndexes != null && !forceIndexes.isEmpty()) {
                        for (Index index : forceIndexes) {
                            expr.addForceIndex(index);
                        }
                    }
                    int valoreLetto = (nnn2 = dao.count(expr)) != null ? (int)nnn2.longValue() : 0;
                    count += valoreLetto;
                }
                if (forceFruizione) {
                    expr = this.createDistribuzioneServizioApplicativoExpression((IServiceSearchWithoutId<?>)dao, model, true, false, forceFruizione);
                    if (forceIndexes != null && !forceIndexes.isEmpty()) {
                        nnn2 = forceIndexes.iterator();
                        while (nnn2.hasNext()) {
                            Index index = (Index)nnn2.next();
                            expr.addForceIndex(index);
                        }
                    }
                    int valoreLetto = (nnn2 = dao.count(expr)) != null ? (int)nnn2.longValue() : 0;
                    count += valoreLetto;
                }
                return count;
            }
            IExpression expr = this.createDistribuzioneServizioApplicativoExpression((IServiceSearchWithoutId<?>)dao, model, true, false, false);
            if (forceIndexes != null && !forceIndexes.isEmpty()) {
                for (Index index : forceIndexes) {
                    expr.addForceIndex(index);
                }
            }
            return (nnn = dao.count(expr)) != null ? (int)nnn.longValue() : 0;
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<ResDistribuzione> findAllDistribuzioneServizioApplicativo() throws ServiceException {
        return this.executeDistribuzioneServizioApplicativo(null, null);
    }

    @Override
    public List<ResDistribuzione> findAllDistribuzioneServizioApplicativo(int start, int limit) throws ServiceException {
        return this.executeDistribuzioneServizioApplicativo(start, limit);
    }

    private List<ResDistribuzione> executeDistribuzioneServizioApplicativo(Integer start, Integer limit) throws ServiceException {
        try {
            Object s;
            StatisticType tipologia = this.checkStatisticType(this.distribSaSearch);
            StatisticaModel model = null;
            switch (tipologia) {
                case GIORNALIERA: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    this.dao = this.statGiornaliereSearchDAO;
                    break;
                }
                case MENSILE: {
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    this.dao = this.statMensileSearchDAO;
                    break;
                }
                case ORARIA: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    this.dao = this.statOrariaSearchDAO;
                    break;
                }
                case SETTIMANALE: {
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    this.dao = this.statSettimanaleSearchDAO;
                }
            }
            if (this.dao == null) {
                throw new ServiceException("DAO unknown");
            }
            if (model == null) {
                throw new ServiceException("Model unknown");
            }
            ISQLFieldConverter fieldConverter = ((IDBServiceUtilities)this.dao).getFieldConverter();
            boolean forceErogazione = false;
            boolean forceFruizione = false;
            if (this.distribSaSearch.getTipologiaRicercaEnum() == null || TipologiaRicerca.all.equals((Object)this.distribSaSearch.getTipologiaRicercaEnum())) {
                forceErogazione = true;
                forceFruizione = true;
            } else if (TipologiaRicerca.ingresso.equals((Object)this.distribSaSearch.getTipologiaRicercaEnum())) {
                forceErogazione = true;
            } else {
                forceFruizione = true;
            }
            List<Index> forceIndexes = null;
            try {
                forceIndexes = this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexDistribuzioneServizioApplicativoGroupBy(this.govwayMonitorProperties.getExternalForceIndexRepository()));
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
            IExpression gByExpr = null;
            IExpression gByExprErogazione = null;
            IExpression gByExprFruizione = null;
            IExpression fakeExpr = null;
            IField credenzialeFieldGroupBy = this.getCredenzialeFieldGroupBy(this.distribSaSearch, model);
            if (forceErogazione || forceFruizione) {
                if (forceErogazione) {
                    gByExprErogazione = this.createDistribuzioneServizioApplicativoExpression(this.dao, model, false, forceErogazione, false);
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSaSearch.getNumeroDimensioni())) {
                        s = this.distribSaSearch.getSortOrder() != null ? this.distribSaSearch.getSortOrder() : SortOrder.ASC;
                        gByExprErogazione.sortOrder((SortOrder)s).addOrder(model.DATA);
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSaSearch.getNumeroDimensioni())) {
                        s = this.distribSaSearch.getSortOrder() != null ? this.distribSaSearch.getSortOrder() : SortOrder.ASC;
                        this.impostaSortOrder3dCustom(gByExprErogazione, model, this.distribSaSearch, this.distribSaSearch.getNumeroDimensioniCustom(), (SortOrder)s);
                    }
                    gByExprErogazione.sortOrder(SortOrder.ASC).addOrder(credenzialeFieldGroupBy);
                    if (StringUtils.isNotEmpty((String)this.distribSaSearch.getRiconoscimento()) && this.distribSaSearch.getRiconoscimento().equals("applicativo") && !"commons.identificazione.token.label".equals(this.distribSaSearch.getIdentificazione())) {
                        gByExprErogazione.sortOrder(SortOrder.ASC).addOrder(model.TIPO_MITTENTE);
                        gByExprErogazione.sortOrder(SortOrder.ASC).addOrder(model.MITTENTE);
                    }
                    if (forceIndexes != null && !forceIndexes.isEmpty()) {
                        for (Index index : forceIndexes) {
                            gByExprErogazione.addForceIndex(index);
                        }
                    }
                }
                if (forceFruizione) {
                    gByExprFruizione = this.createDistribuzioneServizioApplicativoExpression(this.dao, model, false, false, forceFruizione);
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSaSearch.getNumeroDimensioni())) {
                        s = this.distribSaSearch.getSortOrder() != null ? this.distribSaSearch.getSortOrder() : SortOrder.ASC;
                        gByExprFruizione.sortOrder((SortOrder)s).addOrder(model.DATA);
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSaSearch.getNumeroDimensioni())) {
                        s = this.distribSaSearch.getSortOrder() != null ? this.distribSaSearch.getSortOrder() : SortOrder.ASC;
                        this.impostaSortOrder3dCustom(gByExprFruizione, model, this.distribSaSearch, this.distribSaSearch.getNumeroDimensioniCustom(), (SortOrder)s);
                    }
                    gByExprFruizione.sortOrder(SortOrder.ASC).addOrder(credenzialeFieldGroupBy);
                    if (StringUtils.isNotEmpty((String)this.distribSaSearch.getRiconoscimento()) && this.distribSaSearch.getRiconoscimento().equals("applicativo") && !"commons.identificazione.token.label".equals(this.distribSaSearch.getIdentificazione())) {
                        gByExprFruizione.sortOrder(SortOrder.ASC).addOrder(model.TIPO_MITTENTE);
                        gByExprFruizione.sortOrder(SortOrder.ASC).addOrder(model.MITTENTE);
                    }
                    if (forceIndexes != null && !forceIndexes.isEmpty()) {
                        for (Index index : forceIndexes) {
                            gByExprFruizione.addForceIndex(index);
                        }
                    }
                }
            } else {
                gByExpr = this.createDistribuzioneServizioApplicativoExpression(this.dao, model, false, false, false);
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSaSearch.getNumeroDimensioni())) {
                    s = this.distribSaSearch.getSortOrder() != null ? this.distribSaSearch.getSortOrder() : SortOrder.ASC;
                    gByExpr.sortOrder((SortOrder)s).addOrder(model.DATA);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSaSearch.getNumeroDimensioni())) {
                    s = this.distribSaSearch.getSortOrder() != null ? this.distribSaSearch.getSortOrder() : SortOrder.ASC;
                    this.impostaSortOrder3dCustom(gByExpr, model, this.distribSaSearch, this.distribSaSearch.getNumeroDimensioniCustom(), (SortOrder)s);
                }
                gByExpr.sortOrder(SortOrder.ASC).addOrder(credenzialeFieldGroupBy);
                if (forceIndexes != null && !forceIndexes.isEmpty()) {
                    for (Index index : forceIndexes) {
                        gByExpr.addForceIndex(index);
                    }
                }
            }
            ArrayList<String> aliases3dCustom = new ArrayList<String>();
            String aliasFieldCredenzialeMittente = "credenziale_mittente";
            String aliasFieldTipoSoggetto = "tipo_soggetto";
            String aliasFieldSoggetto = "soggetto";
            UnionExpression unionExpr = null;
            UnionExpression unionExprFake = null;
            UnionExpression unionExprErogatore = null;
            UnionExpression unionExprFruitore = null;
            if (forceErogazione || forceFruizione) {
                if (forceErogazione) {
                    unionExprErogatore = new UnionExpression(gByExprErogazione);
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSaSearch.getNumeroDimensioni())) {
                        unionExprErogatore.addSelectField(model.DATA, ALIAS_FIELD_DATA_3D);
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSaSearch.getNumeroDimensioni())) {
                        this.impostaSelectField3dCustom(unionExprErogatore, model, this.distribSaSearch, this.distribSaSearch.getNumeroDimensioniCustom(), aliases3dCustom);
                    }
                    unionExprErogatore.addSelectField(credenzialeFieldGroupBy, aliasFieldCredenzialeMittente);
                    if (StringUtils.isNotEmpty((String)this.distribSaSearch.getRiconoscimento()) && this.distribSaSearch.getRiconoscimento().equals("applicativo") && !"commons.identificazione.token.label".equals(this.distribSaSearch.getIdentificazione())) {
                        unionExprErogatore.addSelectField(model.TIPO_MITTENTE, aliasFieldTipoSoggetto);
                        unionExprErogatore.addSelectField(model.MITTENTE, aliasFieldSoggetto);
                    }
                }
                if (forceFruizione) {
                    unionExprFruitore = new UnionExpression(gByExprFruizione);
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSaSearch.getNumeroDimensioni())) {
                        unionExprFruitore.addSelectField(model.DATA, ALIAS_FIELD_DATA_3D);
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSaSearch.getNumeroDimensioni())) {
                        this.impostaSelectField3dCustom(unionExprFruitore, model, this.distribSaSearch, this.distribSaSearch.getNumeroDimensioniCustom(), aliases3dCustom);
                    }
                    unionExprFruitore.addSelectField(credenzialeFieldGroupBy, aliasFieldCredenzialeMittente);
                    if (StringUtils.isNotEmpty((String)this.distribSaSearch.getRiconoscimento()) && this.distribSaSearch.getRiconoscimento().equals("applicativo") && !"commons.identificazione.token.label".equals(this.distribSaSearch.getIdentificazione())) {
                        unionExprFruitore.addSelectField(model.TIPO_MITTENTE, aliasFieldTipoSoggetto);
                        unionExprFruitore.addSelectField(model.MITTENTE, aliasFieldSoggetto);
                    }
                }
                if (unionExprErogatore == null || unionExprFruitore == null) {
                    fakeExpr = this.dao.newExpression();
                    unionExprFake = new UnionExpression(fakeExpr);
                    if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSaSearch.getNumeroDimensioni())) {
                        unionExprFake.addSelectField((IField)new ConstantField(ALIAS_FIELD_DATA_3D, (Object)FALSA_UNION_DEFAULT_VALUE_TIMESTAMP, model.DATA.getFieldType()), ALIAS_FIELD_DATA_3D);
                    } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSaSearch.getNumeroDimensioni())) {
                        this.impostaSelectField3dCustomFake(unionExprFake, model, this.distribSaSearch, this.distribSaSearch.getNumeroDimensioniCustom(), aliases3dCustom);
                    }
                    unionExprFake.addSelectField((IField)new ConstantField(aliasFieldCredenzialeMittente, (Object)FALSA_UNION_DEFAULT_VALUE, credenzialeFieldGroupBy.getFieldType()), aliasFieldCredenzialeMittente);
                    if (StringUtils.isNotEmpty((String)this.distribSaSearch.getRiconoscimento()) && this.distribSaSearch.getRiconoscimento().equals("applicativo") && !"commons.identificazione.token.label".equals(this.distribSaSearch.getIdentificazione())) {
                        unionExprFake.addSelectField((IField)new ConstantField(aliasFieldTipoSoggetto, (Object)FALSA_UNION_DEFAULT_VALUE, String.class), aliasFieldTipoSoggetto);
                        unionExprFake.addSelectField((IField)new ConstantField(aliasFieldSoggetto, (Object)FALSA_UNION_DEFAULT_VALUE, String.class), aliasFieldSoggetto);
                    }
                }
            } else {
                unionExpr = new UnionExpression(gByExpr);
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSaSearch.getNumeroDimensioni())) {
                    unionExpr.addSelectField(model.DATA, ALIAS_FIELD_DATA_3D);
                } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSaSearch.getNumeroDimensioni())) {
                    this.impostaSelectField3dCustom(unionExpr, model, this.distribSaSearch, this.distribSaSearch.getNumeroDimensioniCustom(), aliases3dCustom);
                }
                unionExpr.addSelectField(credenzialeFieldGroupBy, aliasFieldCredenzialeMittente);
                fakeExpr = this.dao.newExpression();
                unionExprFake = new UnionExpression(fakeExpr);
                unionExprFake.addSelectField((IField)new ConstantField(aliasFieldCredenzialeMittente, (Object)FALSA_UNION_DEFAULT_VALUE, credenzialeFieldGroupBy.getFieldType()), aliasFieldCredenzialeMittente);
            }
            Union union = new Union();
            union.setUnionAll(true);
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSaSearch.getNumeroDimensioni())) {
                union.addField(ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSaSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    union.addField(a3dCustom);
                }
            }
            union.addField(aliasFieldCredenzialeMittente);
            if ((forceErogazione || forceFruizione) && StringUtils.isNotEmpty((String)this.distribSaSearch.getRiconoscimento()) && this.distribSaSearch.getRiconoscimento().equals("applicativo") && !"commons.identificazione.token.label".equals(this.distribSaSearch.getIdentificazione())) {
                union.addField(aliasFieldTipoSoggetto);
                union.addField(aliasFieldSoggetto);
            }
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSaSearch.getNumeroDimensioni())) {
                union.addGroupBy(ALIAS_FIELD_DATA_3D);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSaSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    union.addGroupBy(a3dCustom);
                }
            }
            union.addGroupBy(aliasFieldCredenzialeMittente);
            if ((forceErogazione || forceFruizione) && StringUtils.isNotEmpty((String)this.distribSaSearch.getRiconoscimento()) && this.distribSaSearch.getRiconoscimento().equals("applicativo") && !"commons.identificazione.token.label".equals(this.distribSaSearch.getIdentificazione())) {
                union.addGroupBy(aliasFieldTipoSoggetto);
                union.addGroupBy(aliasFieldSoggetto);
            }
            UnionExpression[] uExpressions = new UnionExpression[2];
            int indexUE = 0;
            boolean fake = false;
            if (forceErogazione) {
                uExpressions[indexUE++] = unionExprErogatore;
            }
            if (forceFruizione) {
                uExpressions[indexUE++] = unionExprFruitore;
            }
            if (indexUE == 0) {
                uExpressions[indexUE++] = unionExpr;
            }
            if (indexUE == 1) {
                uExpressions[indexUE] = unionExprFake;
                fake = true;
            }
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSaSearch.getNumeroDimensioni())) {
                SortOrder s2 = this.distribSaSearch.getSortOrder() != null ? this.distribSaSearch.getSortOrder() : SortOrder.ASC;
                union.addOrderBy(ALIAS_FIELD_DATA_3D, s2);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSaSearch.getNumeroDimensioni())) {
                for (String a3dCustom : aliases3dCustom) {
                    SortOrder s3 = this.distribSaSearch.getSortOrder() != null ? this.distribSaSearch.getSortOrder() : SortOrder.ASC;
                    union.addOrderBy(a3dCustom, s3);
                }
            }
            TipoVisualizzazione tipoVisualizzazione = this.distribSaSearch.getTipoVisualizzazione();
            String sommaAliasName = "somma";
            String datoParamAliasName = "dato";
            block17 : switch (tipoVisualizzazione) {
                case DIMENSIONE_TRANSAZIONI: {
                    TipoBanda tipoBanda = this.distribSaSearch.getTipoBanda();
                    union.addOrderBy(sommaAliasName, SortOrder.DESC);
                    union.addField(sommaAliasName, Function.SUM, datoParamAliasName);
                    switch (tipoBanda) {
                        case COMPLESSIVA: {
                            if (unionExprErogatore != null) {
                                unionExprErogatore.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA, Function.SUM, datoParamAliasName));
                            }
                            if (unionExprFruitore != null) {
                                unionExprFruitore.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA, Function.SUM, datoParamAliasName));
                            }
                            if (unionExpr != null) {
                                unionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA, Function.SUM, datoParamAliasName));
                            }
                            if (unionExprFake == null) break;
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_complessiva", (Object)0, model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA.getFieldType()), Function.SUM, datoParamAliasName));
                            break;
                        }
                        case INTERNA: {
                            if (unionExprErogatore != null) {
                                unionExprErogatore.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_INTERNA, Function.SUM, datoParamAliasName));
                            }
                            if (unionExprFruitore != null) {
                                unionExprFruitore.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_INTERNA, Function.SUM, datoParamAliasName));
                            }
                            if (unionExpr != null) {
                                unionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_INTERNA, Function.SUM, datoParamAliasName));
                            }
                            if (unionExprFake == null) break;
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_interna", (Object)0, model.DIMENSIONI_BYTES_BANDA_INTERNA.getFieldType()), Function.SUM, datoParamAliasName));
                            break;
                        }
                        case ESTERNA: {
                            if (unionExprErogatore != null) {
                                unionExprErogatore.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_ESTERNA, Function.SUM, datoParamAliasName));
                            }
                            if (unionExprFruitore != null) {
                                unionExprFruitore.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_ESTERNA, Function.SUM, datoParamAliasName));
                            }
                            if (unionExpr != null) {
                                unionExpr.addSelectFunctionField(new FunctionField(model.DIMENSIONI_BYTES_BANDA_ESTERNA, Function.SUM, datoParamAliasName));
                            }
                            if (unionExprFake == null) break;
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_esterna", (Object)0, model.DIMENSIONI_BYTES_BANDA_ESTERNA.getFieldType()), Function.SUM, datoParamAliasName));
                        }
                    }
                    break;
                }
                case NUMERO_TRANSAZIONI: {
                    union.addOrderBy(sommaAliasName, SortOrder.DESC);
                    union.addField(sommaAliasName, Function.SUM, datoParamAliasName);
                    if (unionExprErogatore != null) {
                        unionExprErogatore.addSelectFunctionField(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, datoParamAliasName));
                    }
                    if (unionExprFruitore != null) {
                        unionExprFruitore.addSelectFunctionField(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, datoParamAliasName));
                    }
                    if (unionExpr != null) {
                        unionExpr.addSelectFunctionField(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, datoParamAliasName));
                    }
                    if (unionExprFake == null) break;
                    unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("numero_transazioni", (Object)0, model.NUMERO_TRANSAZIONI.getFieldType()), Function.SUM, datoParamAliasName));
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    TipoLatenza tipoLatenza = this.distribSaSearch.getTipoLatenza();
                    String datoParamRichiesteAliasName = "dato_richieste";
                    union.addOrderBy(sommaAliasName, SortOrder.DESC);
                    if (fake) {
                        union.addField(sommaAliasName, Function.SUM, datoParamAliasName);
                    } else {
                        union.addField("somma_richieste", Function.SUM, datoParamRichiesteAliasName);
                        union.addCustomField(sommaAliasName, StatisticheUtils.getSqlCalcolaMedia((String)datoParamAliasName, (String)datoParamRichiesteAliasName));
                        if (unionExprErogatore != null) {
                            unionExprErogatore.addSelectFunctionField(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, datoParamRichiesteAliasName));
                        }
                        if (unionExprFruitore != null) {
                            unionExprFruitore.addSelectFunctionField(new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, datoParamRichiesteAliasName));
                        }
                    }
                    switch (tipoLatenza) {
                        case LATENZA_PORTA: {
                            if (unionExprErogatore != null) {
                                gByExprErogazione.isNotNull(model.LATENZA_PORTA);
                                unionExprErogatore.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_PORTA, (IField)model.NUMERO_TRANSAZIONI, (String)datoParamAliasName));
                            }
                            if (unionExprFruitore != null) {
                                gByExprFruizione.isNotNull(model.LATENZA_PORTA);
                                unionExprFruitore.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_PORTA, (IField)model.NUMERO_TRANSAZIONI, (String)datoParamAliasName));
                            }
                            if (unionExpr != null) {
                                gByExpr.isNotNull(model.LATENZA_PORTA);
                                unionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_PORTA, (IField)model.NUMERO_TRANSAZIONI, (String)datoParamAliasName));
                            }
                            if (unionExprFake == null) break block17;
                            fakeExpr.isNotNull(model.LATENZA_PORTA);
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_porta", (Object)0, model.LATENZA_PORTA.getFieldType()), Function.SUM, datoParamAliasName));
                            break block17;
                        }
                        case LATENZA_SERVIZIO: {
                            if (unionExprErogatore != null) {
                                gByExprErogazione.isNotNull(model.LATENZA_SERVIZIO);
                                unionExprErogatore.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_SERVIZIO, (IField)model.NUMERO_TRANSAZIONI, (String)datoParamAliasName));
                            }
                            if (unionExprFruitore != null) {
                                gByExprFruizione.isNotNull(model.LATENZA_SERVIZIO);
                                unionExprFruitore.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_SERVIZIO, (IField)model.NUMERO_TRANSAZIONI, (String)datoParamAliasName));
                            }
                            if (unionExpr != null) {
                                gByExpr.isNotNull(model.LATENZA_SERVIZIO);
                                unionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_SERVIZIO, (IField)model.NUMERO_TRANSAZIONI, (String)datoParamAliasName));
                            }
                            if (unionExprFake == null) break block17;
                            fakeExpr.isNotNull(model.LATENZA_SERVIZIO);
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_servizio", (Object)0, model.LATENZA_SERVIZIO.getFieldType()), Function.SUM, datoParamAliasName));
                            break block17;
                        }
                    }
                    if (unionExprErogatore != null) {
                        gByExprErogazione.isNotNull(model.LATENZA_TOTALE);
                        unionExprErogatore.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_TOTALE, (IField)model.NUMERO_TRANSAZIONI, (String)datoParamAliasName));
                    }
                    if (unionExprFruitore != null) {
                        gByExprFruizione.isNotNull(model.LATENZA_TOTALE);
                        unionExprFruitore.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_TOTALE, (IField)model.NUMERO_TRANSAZIONI, (String)datoParamAliasName));
                    }
                    if (unionExpr != null) {
                        gByExpr.isNotNull(model.LATENZA_TOTALE);
                        unionExpr.addSelectFunctionField(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_TOTALE, (IField)model.NUMERO_TRANSAZIONI, (String)datoParamAliasName));
                    }
                    if (unionExprFake == null) break;
                    fakeExpr.isNotNull(model.LATENZA_TOTALE);
                    unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_totale", (Object)0, model.LATENZA_TOTALE.getFieldType()), Function.SUM, datoParamAliasName));
                    break;
                }
            }
            ArrayList<ResDistribuzione> res = new ArrayList<ResDistribuzione>();
            boolean countApplicativo = false;
            int elementi = 0;
            if (start != null && limit != null && !this.distribSaSearch.isUseCount()) {
                countApplicativo = true;
            }
            if (!countApplicativo && start != null) {
                union.setOffset(start);
            }
            if (!countApplicativo && start != null && limit != null) {
                union.setLimit(limit);
            }
            this.timeoutEvent = false;
            List list = null;
            if (this.timeoutRicerche == null) {
                list = this.dao.union(union, uExpressions);
            } else {
                try {
                    list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.dao.union(union, uExpressions)).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof NotFoundException) {
                        throw (NotFoundException)e.getCause();
                    }
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                }
            }
            if (list != null) {
                for (Map row : list) {
                    Number somma;
                    boolean addSoggetto;
                    ResDistribuzione3D r;
                    String risultato;
                    block177: {
                        risultato = (String)row.get(aliasFieldCredenzialeMittente);
                        if (FALSA_UNION_DEFAULT_VALUE.equals(risultato) || risultato != null && risultato.contains(FALSA_UNION_DEFAULT_VALUE)) continue;
                        r = null;
                        if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSaSearch.getNumeroDimensioni())) {
                            r = new ResDistribuzione3D();
                            Date data = (Date)row.get(ALIAS_FIELD_DATA_3D);
                            r.setData(data);
                            r.setDataFormattata(StatsUtils.formatDate(tipologia, data));
                        } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSaSearch.getNumeroDimensioni())) {
                            r = new ResDistribuzione3DCustom();
                            StringBuilder resFailure = new StringBuilder();
                            try {
                                BooleanNullable bSkip = BooleanNullable.NULL();
                                String customData = this.getCustomData(row, this.distribSaSearch.getNumeroDimensioniCustom(), this.distribSaSearch, resFailure, bSkip);
                                if (bSkip != null && bSkip.getValue() != null && bSkip.getValue().booleanValue()) continue;
                                if (customData == null) {
                                    if (resFailure.length() <= 0) {
                                        resFailure.append("-?-");
                                    }
                                    throw new CoreException("Informazione personalizzata non presente");
                                }
                                ((ResDistribuzione3DCustom)r).setDatoCustom(customData);
                            }
                            catch (Exception t) {
                                ((ResDistribuzione3DCustom)r).setDatoCustom("SA '" + risultato + "' - " + resFailure.toString());
                                StatisticheGiornaliereService.logError("Traduzione SA(" + risultato + ") '" + resFailure.toString() + "' non riuscita: " + t.getMessage(), t);
                            }
                        } else {
                            r = new ResDistribuzione();
                        }
                        String risultatoIdLongCredenzialeMittente = risultato;
                        StringBuilder sbTipoCredenziale = new StringBuilder();
                        risultato = this.getLabelCredenzialeFieldGroupBy(risultato, this.distribSaSearch, sbTipoCredenziale);
                        addSoggetto = true;
                        if (StringUtils.isNotEmpty((String)this.distribSaSearch.getRiconoscimento())) {
                            if (this.distribSaSearch.getRiconoscimento().equals("applicativo")) {
                                if (StringUtils.isNotBlank((String)this.distribSaSearch.getIdentificazione()) && "commons.identificazione.token.label".equals(this.distribSaSearch.getIdentificazione())) {
                                    try {
                                        IDServizioApplicativo idApplicativo = CredenzialeTokenClient.convertApplicationDBValueToOriginal((String)risultato);
                                        if (idApplicativo == null) continue;
                                        r.getParentMap().put("0", idApplicativo.getIdSoggettoProprietario().getTipo() + "/" + idApplicativo.getIdSoggettoProprietario().getNome());
                                        try {
                                            if (CredenzialeTokenClient.isClientIdDBValue((String)risultato)) {
                                                String clientId = CredenzialeTokenClient.convertClientIdDBValueToOriginal((String)risultato);
                                                r.getParentMap().put("1", clientId);
                                            } else {
                                                r.getParentMap().put("1", "-");
                                            }
                                        }
                                        catch (Exception tAppId) {
                                            StatisticheGiornaliereService.logError(tAppId.getMessage(), tAppId);
                                            r.getParentMap().put("1", "-");
                                        }
                                        risultato = idApplicativo.getNome();
                                        addSoggetto = false;
                                    }
                                    catch (Exception tApp) {
                                        StatisticheGiornaliereService.logError(tApp.getMessage(), tApp);
                                        continue;
                                    }
                                }
                            } else if (this.distribSaSearch.getRiconoscimento().equals("tokenInfo")) {
                                try {
                                    TipoCredenzialeMittente tcm = TipoCredenzialeMittente.toEnumConstant((String)this.distribSaSearch.getTokenClaim(), (boolean)true);
                                    if (TipoCredenzialeMittente.TOKEN_CLIENT_ID.equals((Object)tcm)) {
                                        boolean add = false;
                                        try {
                                            IDServizioApplicativo idApplicativo = CredenzialeTokenClient.convertApplicationDBValueToOriginal((String)risultato);
                                            if (idApplicativo != null) {
                                                String soggetto = NamingUtils.getLabelSoggetto((IDSoggetto)idApplicativo.getIdSoggettoProprietario());
                                                r.getParentMap().put("0", idApplicativo.getNome());
                                                r.getParentMap().put("1", soggetto);
                                                add = true;
                                            }
                                        }
                                        catch (Exception tApp) {
                                            StatisticheGiornaliereService.logError(tApp.getMessage(), tApp);
                                        }
                                        if (!add) {
                                            r.getParentMap().put("0", "-");
                                            r.getParentMap().put("1", "-");
                                        }
                                        risultato = CredenzialeTokenClient.convertClientIdDBValueToOriginal((String)risultato);
                                        break block177;
                                    }
                                    if (!TipoCredenzialeMittente.PDND_ORGANIZATION_NAME.equals((Object)tcm)) break block177;
                                    String organizzazione = null;
                                    try {
                                        MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, log);
                                        CredenzialeMittente credenzialeMittentePDNDOrganization = mBeanUtilsService.getCredenzialeMittenteByReferenceFromCache(TipoCredenzialeMittente.PDND_ORGANIZATION_NAME, Long.valueOf(Long.parseLong(risultatoIdLongCredenzialeMittente)));
                                        if (credenzialeMittentePDNDOrganization != null) {
                                            organizzazione = credenzialeMittentePDNDOrganization.getCredenziale();
                                        }
                                    }
                                    catch (Exception tApp) {
                                        StatisticheGiornaliereService.logError(tApp.getMessage(), tApp);
                                    }
                                    if (organizzazione == null) continue;
                                    String categoria = null;
                                    String extIdOrigin = null;
                                    String extIdCode = null;
                                    Object extId = null;
                                    String categoriaIdPdnd = null;
                                    try {
                                        MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, log);
                                        CredenzialeMittente credenzialeMittentePDNDjson = mBeanUtilsService.getCredenzialeMittenteByReferenceFromCache(TipoCredenzialeMittente.PDND_ORGANIZATION_JSON, Long.valueOf(Long.parseLong(risultatoIdLongCredenzialeMittente)));
                                        if (credenzialeMittentePDNDjson != null && credenzialeMittentePDNDjson.getCredenziale() != null) {
                                            PDNDTokenInfoDetails d = new PDNDTokenInfoDetails();
                                            d.setDetails(credenzialeMittentePDNDjson.getCredenziale());
                                            PDNDTokenInfo info = new PDNDTokenInfo();
                                            info.setOrganization(d);
                                            categoria = info.getOrganizationCategory(log);
                                            extIdOrigin = info.getOrganizationExternalOrigin(log);
                                            extIdCode = info.getOrganizationExternalId(log);
                                            extId = extIdOrigin != null && extIdCode != null ? extIdOrigin + " " + extIdCode : (extIdOrigin != null ? extIdOrigin : extIdCode);
                                            categoriaIdPdnd = info.getOrganizationId(log);
                                        }
                                    }
                                    catch (Exception tApp) {
                                        StatisticheGiornaliereService.logError(tApp.getMessage(), tApp);
                                    }
                                    if (categoria == null) {
                                        categoria = "-";
                                    }
                                    if (extId == null) {
                                        extId = "-";
                                    }
                                    if (categoriaIdPdnd == null) {
                                        categoriaIdPdnd = "-";
                                    }
                                    IDServizioApplicativo idApplicativo = null;
                                    if (this.isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato) {
                                        try {
                                            idApplicativo = CredenzialeTokenClient.convertApplicationDBValueToOriginal((String)risultato);
                                        }
                                        catch (Exception tApp) {
                                            StatisticheGiornaliereService.logError(tApp.getMessage(), tApp);
                                        }
                                    }
                                    String clientId = risultato = CredenzialeTokenClient.convertClientIdDBValueToOriginal((String)risultato);
                                    risultato = organizzazione;
                                    r.getParentMap().put("0", clientId);
                                    r.getParentMap().put("1", extId);
                                    r.getParentMap().put("2", categoria);
                                    r.getParentMap().put("3", categoriaIdPdnd);
                                    if (!this.isDistribuzioneTokenClientIdInformazioniPDNDAggiungiInformazioneApplicativoRegistrato) break block177;
                                    if (idApplicativo != null) {
                                        String soggetto = NamingUtils.getLabelSoggetto((IDSoggetto)idApplicativo.getIdSoggettoProprietario());
                                        r.getParentMap().put("4", idApplicativo.getNome());
                                        r.getParentMap().put("5", soggetto);
                                        break block177;
                                    }
                                    r.getParentMap().put("4", "-");
                                    r.getParentMap().put("5", "-");
                                }
                                catch (Exception t) {
                                    StatisticheGiornaliereService.logError(t.getMessage(), t);
                                }
                            } else if (this.distribSaSearch.getRiconoscimento().equals("identificativoAutenticato")) {
                                String tipoCredenziale = this.convertToTipoCredenziale(sbTipoCredenziale.toString());
                                r.getParentMap().put("0", tipoCredenziale);
                            }
                        }
                    }
                    r.setRisultato(risultato);
                    if ((forceErogazione || forceFruizione) && StringUtils.isNotEmpty((String)this.distribSaSearch.getRiconoscimento()) && this.distribSaSearch.getRiconoscimento().equals("applicativo") && addSoggetto) {
                        r.getParentMap().put("0", (String)row.get(aliasFieldTipoSoggetto) + "/" + (String)row.get(aliasFieldSoggetto));
                    }
                    if ((somma = StatsUtils.converToNumber(row.get(sommaAliasName))) != null) {
                        r.setSomma(somma);
                    } else {
                        r.setSomma((Number)0);
                    }
                    if (countApplicativo) {
                        if (++elementi <= start) continue;
                        if (res.size() >= limit) break;
                    }
                    res.add((ResDistribuzione)r);
                }
            }
            return res;
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (NotFoundException e) {
            StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente.");
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        return new ArrayList<ResDistribuzione>();
    }

    private String convertToTipoCredenziale(String tipo) {
        String[] tmp;
        String tipoCredenziale = "-";
        if (tipo.length() > 0 && tipo.contains("_") && (tmp = tipo.split("_")) != null && tmp.length > 1 && tmp[1] != null && StringUtils.isNotEmpty((String)tmp[1])) {
            tipoCredenziale = tmp[1];
        }
        if (TipoAutenticazione.SSL.getValue().equals(tipoCredenziale)) {
            tipoCredenziale = TipoAutenticazione.SSL.getLabel();
        } else if (TipoAutenticazione.BASIC.getValue().equals(tipoCredenziale)) {
            tipoCredenziale = TipoAutenticazione.BASIC.getLabel();
        } else if (TipoAutenticazione.APIKEY.getValue().equals(tipoCredenziale)) {
            tipoCredenziale = TipoAutenticazione.APIKEY.getLabel();
        } else if (TipoAutenticazione.PRINCIPAL.getValue().equals(tipoCredenziale)) {
            tipoCredenziale = TipoAutenticazione.PRINCIPAL.getLabel();
        }
        return tipoCredenziale;
    }

    private IExpression createDistribuzioneServizioApplicativoExpression(IServiceSearchWithoutId<?> dao, StatisticaModel model, boolean isCount, boolean forceErogazione, boolean forceFruizione) throws ServiceException {
        IExpression expr = null;
        StatisticheGiornaliereService.logDebug("creo Expression per distribuzione sa!");
        List listaSoggettiGestione = this.distribSaSearch.getSoggettiGestione();
        try {
            IExpression[] orSoggetti;
            EsitoUtils esitoUtils = new EsitoUtils(log, this.distribSaSearch.getProtocollo());
            expr = dao.newExpression();
            expr.between(model.DATA, (Object)this.distribSaSearch.getDataInizio(), (Object)this.distribSaSearch.getDataFine());
            StatisticheUtils.selezionaRecordValidi((IExpression)expr, (StatisticaModel)model);
            String protocollo = null;
            if (this.distribSaSearch.isSetFiltroProtocollo()) {
                protocollo = this.distribSaSearch.getProtocollo();
                this.impostaTipiCompatibiliConProtocollo(dao, model, expr, protocollo, this.distribSaSearch.getTipologiaRicercaEnum());
            }
            if (this.distribSaSearch.getPermessiUtenteOperatore() != null) {
                IExpression permessi = this.distribSaSearch.getPermessiUtenteOperatore().toExpression(dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                expr.and(new IExpression[]{permessi});
            }
            if (Utility.isFiltroDominioAbilitato() && this.distribSaSearch.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.distribSaSearch.getSoggettoLocale()) && !"--".equals(this.distribSaSearch.getSoggettoLocale())) {
                String tipoSoggettoLocale = this.distribSaSearch.getTipoSoggettoLocale();
                String nomeSoggettoLocale = this.distribSaSearch.getSoggettoLocale();
                String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                expr.and().equals(model.ID_PORTA, (Object)idPorta);
            }
            if (StringUtils.isNotBlank((String)this.distribSaSearch.getNomeAzione())) {
                expr.and().equals(model.AZIONE, (Object)this.distribSaSearch.getNomeAzione());
            }
            if (StringUtils.isNotBlank((String)this.distribSaSearch.getNomeServizio())) {
                IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)this.distribSaSearch.getNomeServizio());
                expr.and().equals(model.TIPO_DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getTipo()).equals(model.DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getNome()).equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo()).equals(model.SERVIZIO, (Object)idServizio.getNome()).equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
            }
            esitoUtils.setExpression(expr, this.distribSaSearch.getEsitoGruppo(), this.distribSaSearch.getEsitoDettaglio(), this.distribSaSearch.getEsitoDettaglioPersonalizzato(), this.distribSaSearch.getEsitoContesto(), this.distribSaSearch.isEscludiRichiesteScartate(), model.ESITO, model.ESITO_CONTESTO, dao.newExpression());
            if (!(forceErogazione || forceFruizione || this.distribSaSearch.getTipologiaRicercaEnum() != null && !TipologiaRicerca.all.equals((Object)this.distribSaSearch.getTipologiaRicercaEnum()))) {
                boolean trafficoSoggetto = StringUtils.isNotBlank((String)this.distribSaSearch.getTrafficoPerSoggetto());
                boolean soggetto = !listaSoggettiGestione.isEmpty();
                String tipoTrafficoSoggetto = null;
                String nomeTrafficoSoggetto = null;
                if (trafficoSoggetto) {
                    tipoTrafficoSoggetto = this.distribSaSearch.getTipoTrafficoPerSoggetto();
                    nomeTrafficoSoggetto = this.distribSaSearch.getTrafficoPerSoggetto();
                }
                IExpression e1 = dao.newExpression();
                IExpression e2 = dao.newExpression();
                if (trafficoSoggetto && soggetto) {
                    expr.and();
                    if (!listaSoggettiGestione.isEmpty()) {
                        IExpression[] orSoggetti2 = new IExpression[listaSoggettiGestione.size()];
                        IExpression[] orSoggetti22 = new IExpression[listaSoggettiGestione.size()];
                        int i = 0;
                        for (Soggetto sog : listaSoggettiGestione) {
                            IExpression se = dao.newExpression();
                            IExpression se2 = dao.newExpression();
                            se.equals(model.TIPO_MITTENTE, (Object)sog.getTipoSoggetto());
                            se.and().equals(model.MITTENTE, (Object)sog.getNomeSoggetto());
                            orSoggetti2[i] = se;
                            se2.equals(model.TIPO_DESTINATARIO, (Object)sog.getTipoSoggetto());
                            se2.and().equals(model.DESTINATARIO, (Object)sog.getNomeSoggetto());
                            orSoggetti22[i] = se2;
                            ++i;
                        }
                        e1.or(orSoggetti2);
                        e2.or(orSoggetti22);
                    }
                    e1.and().equals(model.TIPO_DESTINATARIO, (Object)tipoTrafficoSoggetto);
                    e1.and().equals(model.DESTINATARIO, (Object)nomeTrafficoSoggetto);
                    e2.and().equals(model.TIPO_MITTENTE, (Object)tipoTrafficoSoggetto);
                    e2.and().equals(model.MITTENTE, (Object)nomeTrafficoSoggetto);
                    expr.or(e1, e2);
                } else if (trafficoSoggetto && !soggetto) {
                    expr.and();
                    e1.equals(model.TIPO_DESTINATARIO, (Object)tipoTrafficoSoggetto);
                    e1.and().equals(model.DESTINATARIO, (Object)nomeTrafficoSoggetto);
                    e2.equals(model.TIPO_MITTENTE, (Object)tipoTrafficoSoggetto);
                    e2.and().equals(model.MITTENTE, (Object)nomeTrafficoSoggetto);
                    expr.or(e1, e2);
                } else if (!trafficoSoggetto && soggetto) {
                    expr.and();
                    if (!listaSoggettiGestione.isEmpty()) {
                        IExpression[] orSoggetti3 = new IExpression[listaSoggettiGestione.size()];
                        IExpression[] orSoggetti2 = new IExpression[listaSoggettiGestione.size()];
                        int i = 0;
                        for (Soggetto sog : listaSoggettiGestione) {
                            IExpression se = dao.newExpression();
                            IExpression se2 = dao.newExpression();
                            se.equals(model.TIPO_MITTENTE, (Object)sog.getTipoSoggetto());
                            se.and().equals(model.MITTENTE, (Object)sog.getNomeSoggetto());
                            orSoggetti3[i] = se;
                            se2.equals(model.TIPO_DESTINATARIO, (Object)sog.getTipoSoggetto());
                            se2.and().equals(model.DESTINATARIO, (Object)sog.getNomeSoggetto());
                            orSoggetti2[i] = se2;
                            ++i;
                        }
                        e1.or(orSoggetti3);
                        e2.or(orSoggetti2);
                    }
                    expr.or(e1, e2);
                }
            } else if (forceErogazione || TipologiaRicerca.ingresso.equals((Object)this.distribSaSearch.getTipologiaRicercaEnum())) {
                expr.and().notEquals(model.TIPO_PORTA, (Object)"delegata");
                if (!listaSoggettiGestione.isEmpty()) {
                    expr.and();
                    orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_DESTINATARIO, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.DESTINATARIO, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    expr.or(orSoggetti);
                }
                boolean ignoreSetMittente = this.isIgnoreSetMittente(this.distribSaSearch);
                if (StringUtils.isNotBlank((String)this.distribSaSearch.getNomeMittente()) && !ignoreSetMittente) {
                    expr.and().equals(model.TIPO_MITTENTE, (Object)this.distribSaSearch.getTipoMittente());
                    expr.and().equals(model.MITTENTE, (Object)this.distribSaSearch.getNomeMittente());
                }
            } else {
                expr.and().notEquals(model.TIPO_PORTA, (Object)"applicativa");
                if (!listaSoggettiGestione.isEmpty()) {
                    expr.and();
                    orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_MITTENTE, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.MITTENTE, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    expr.or(orSoggetti);
                }
                if (StringUtils.isNotBlank((String)this.distribSaSearch.getNomeDestinatario())) {
                    expr.and().equals(model.TIPO_DESTINATARIO, (Object)this.distribSaSearch.getTipoDestinatario());
                    expr.and().equals(model.DESTINATARIO, (Object)this.distribSaSearch.getNomeDestinatario());
                }
            }
            if (NumeroDimensioni.DIMENSIONI_3.equals(this.distribSaSearch.getNumeroDimensioni())) {
                expr.addGroupBy(model.DATA);
            } else if (NumeroDimensioni.DIMENSIONI_3_CUSTOM.equals(this.distribSaSearch.getNumeroDimensioni())) {
                this.impostaGroupByFiltro3dCustom(expr, model, this.distribSaSearch, this.distribSaSearch.getNumeroDimensioniCustom());
            }
            this.impostaGroupByFiltroDatiMittente(expr, this.distribSaSearch, model, isCount);
            this.impostaFiltroGruppo(expr, this.distribSaSearch, model, isCount);
            this.impostaFiltroApi(expr, this.distribSaSearch, model, isCount);
            this.impostaFiltroIdClusterOrCanale(expr, this.distribSaSearch, model, isCount);
            if (StringUtils.isNotEmpty((String)this.distribSaSearch.getRiconoscimento()) && this.distribSaSearch.getRiconoscimento().equals("applicativo") && !"commons.identificazione.token.label".equals(this.distribSaSearch.getIdentificazione())) {
                expr.notEquals(model.TIPO_MITTENTE, (Object)"-");
                expr.notEquals(model.MITTENTE, (Object)"-");
                expr.addGroupBy(model.TIPO_MITTENTE);
                expr.addGroupBy(model.MITTENTE);
            }
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (CoreException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        return expr;
    }

    @Override
    public int countAllDistribuzionePersonalizzata() throws ServiceException {
        try {
            NonNegativeNumber nnn = this.executeDistribuzionePersonalizzataCount();
            return nnn != null ? (int)nnn.longValue() : 0;
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public List<ResDistribuzione> findAllDistribuzionePersonalizzata() throws ServiceException {
        try {
            List<ResDistribuzione> res = this.executeDistribuzionePersonalizzataSearch(false, false, -1, -1);
            return res;
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
    }

    @Override
    public List<ResDistribuzione> findAllDistribuzionePersonalizzata(int start, int limit) throws ServiceException {
        try {
            List<ResDistribuzione> res = this.executeDistribuzionePersonalizzataSearch(false, true, start, limit);
            return res;
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
    }

    private List<ResDistribuzione> executeDistribuzionePersonalizzataSearch(boolean isCount, boolean isPaginated, int offset, int limit) throws ServiceException {
        StatisticaModel model = null;
        StatisticaContenutiModel modelContenuti = null;
        StatisticType tipologia = this.statistichePersonalizzateSearch.getModalitaTemporale();
        try {
            switch (tipologia) {
                case GIORNALIERA: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    modelContenuti = StatisticaGiornaliera.model().STATISTICA_GIORNALIERA_CONTENUTI;
                    this.dao = this.statGiornaliereSearchDAO;
                    break;
                }
                case MENSILE: {
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    modelContenuti = StatisticaMensile.model().STATISTICA_MENSILE_CONTENUTI;
                    this.dao = this.statMensileSearchDAO;
                    break;
                }
                case ORARIA: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    modelContenuti = StatisticaOraria.model().STATISTICA_ORARIA_CONTENUTI;
                    this.dao = this.statOrariaSearchDAO;
                    break;
                }
                case SETTIMANALE: {
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    modelContenuti = StatisticaSettimanale.model().STATISTICA_SETTIMANALE_CONTENUTI;
                    this.dao = this.statSettimanaleSearchDAO;
                }
            }
            if (this.dao == null) {
                throw new ServiceException("DAO unknown");
            }
            if (model == null) {
                throw new ServiceException("Model unknown");
            }
            if (modelContenuti == null) {
                throw new ServiceException("ModelContenuti unknown");
            }
            List<Index> forceIndexes = null;
            try {
                forceIndexes = isCount ? this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexPersonalizzataDistribuzioneCount(tipologia, this.govwayMonitorProperties.getExternalForceIndexRepository())) : this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexPersonalizzataDistribuzioneGroupBy(tipologia, this.govwayMonitorProperties.getExternalForceIndexRepository()));
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
            IExpression gByExpr = this.createDistribuzionePersonalizzataExpression(this.dao, model, modelContenuti, isCount);
            gByExpr.sortOrder(SortOrder.ASC).addOrder(modelContenuti.RISORSA_VALORE);
            if (forceIndexes != null && !forceIndexes.isEmpty()) {
                for (Index index : forceIndexes) {
                    gByExpr.addForceIndex(index);
                }
            }
            UnionExpression unionExpr = new UnionExpression(gByExpr);
            unionExpr.addSelectField(modelContenuti.RISORSA_VALORE, "nome_risorsa");
            IExpression fakeExpr = this.dao.newExpression();
            UnionExpression unionExprFake = new UnionExpression(fakeExpr);
            unionExprFake.addSelectField((IField)new ConstantField("nome_risorsa", (Object)FALSA_UNION_DEFAULT_VALUE, modelContenuti.RISORSA_VALORE.getFieldType()), "nome_risorsa");
            Union union = new Union();
            union.setUnionAll(true);
            union.addField("nome_risorsa");
            union.addGroupBy("nome_risorsa");
            TipoVisualizzazione tipoVisualizzazione = this.statistichePersonalizzateSearch.getTipoVisualizzazione();
            block9 : switch (tipoVisualizzazione) {
                case DIMENSIONE_TRANSAZIONI: {
                    TipoBanda tipoBanda = this.statistichePersonalizzateSearch.getTipoBanda();
                    union.addOrderBy("somma", SortOrder.DESC);
                    union.addField("somma", Function.SUM, "dato");
                    switch (tipoBanda) {
                        case COMPLESSIVA: {
                            unionExpr.addSelectFunctionField(new FunctionField(modelContenuti.DIMENSIONI_BYTES_BANDA_COMPLESSIVA, Function.SUM, "dato"));
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_complessiva", (Object)0, modelContenuti.DIMENSIONI_BYTES_BANDA_COMPLESSIVA.getFieldType()), Function.SUM, "dato"));
                            break;
                        }
                        case INTERNA: {
                            unionExpr.addSelectFunctionField(new FunctionField(modelContenuti.DIMENSIONI_BYTES_BANDA_INTERNA, Function.SUM, "dato"));
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_interna", (Object)0, modelContenuti.DIMENSIONI_BYTES_BANDA_INTERNA.getFieldType()), Function.SUM, "dato"));
                            break;
                        }
                        case ESTERNA: {
                            unionExpr.addSelectFunctionField(new FunctionField(modelContenuti.DIMENSIONI_BYTES_BANDA_ESTERNA, Function.SUM, "dato"));
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("banda_esterna", (Object)0, modelContenuti.DIMENSIONI_BYTES_BANDA_ESTERNA.getFieldType()), Function.SUM, "dato"));
                        }
                    }
                    break;
                }
                case NUMERO_TRANSAZIONI: {
                    union.addOrderBy("somma", SortOrder.DESC);
                    union.addField("somma", Function.SUM, "dato");
                    unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("numero_transazioni", (Object)0, modelContenuti.NUMERO_TRANSAZIONI.getFieldType()), Function.SUM, "dato"));
                    unionExpr.addSelectFunctionField(new FunctionField(modelContenuti.NUMERO_TRANSAZIONI, Function.SUM, "dato"));
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    TipoLatenza tipoLatenza = this.statistichePersonalizzateSearch.getTipoLatenza();
                    union.addOrderBy("somma", SortOrder.DESC);
                    union.addField("somma", Function.AVG, "dato");
                    switch (tipoLatenza) {
                        case LATENZA_PORTA: {
                            fakeExpr.isNotNull(modelContenuti.LATENZA_PORTA);
                            gByExpr.isNotNull(modelContenuti.LATENZA_PORTA);
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_porta", (Object)1, modelContenuti.LATENZA_PORTA.getFieldType()), Function.AVG, "dato"));
                            unionExpr.addSelectFunctionField(new FunctionField(modelContenuti.LATENZA_PORTA, Function.AVG, "dato"));
                            break block9;
                        }
                        case LATENZA_SERVIZIO: {
                            fakeExpr.isNotNull(modelContenuti.LATENZA_SERVIZIO);
                            gByExpr.isNotNull(modelContenuti.LATENZA_SERVIZIO);
                            unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_servizio", (Object)1, modelContenuti.LATENZA_SERVIZIO.getFieldType()), Function.AVG, "dato"));
                            unionExpr.addSelectFunctionField(new FunctionField(modelContenuti.LATENZA_SERVIZIO, Function.AVG, "dato"));
                            break block9;
                        }
                    }
                    fakeExpr.isNotNull(modelContenuti.LATENZA_TOTALE);
                    gByExpr.isNotNull(modelContenuti.LATENZA_TOTALE);
                    unionExprFake.addSelectFunctionField(new FunctionField((IField)new ConstantField("latenza_totale", (Object)1, modelContenuti.LATENZA_TOTALE.getFieldType()), Function.AVG, "dato"));
                    unionExpr.addSelectFunctionField(new FunctionField(modelContenuti.LATENZA_TOTALE, Function.AVG, "dato"));
                    break;
                }
            }
            if (isPaginated) {
                union.setOffset(Integer.valueOf(offset));
            }
            if (isPaginated) {
                union.setLimit(Integer.valueOf(limit));
            }
            this.timeoutEvent = false;
            List list = null;
            if (this.timeoutRicerche == null) {
                list = this.dao.union(union, new UnionExpression[]{unionExpr, unionExprFake});
            } else {
                try {
                    list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.dao.union(union, new UnionExpression[]{unionExpr, unionExprFake})).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof NotFoundException) {
                        throw (NotFoundException)e.getCause();
                    }
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                }
            }
            ArrayList<ResDistribuzione> res = new ArrayList<ResDistribuzione>();
            if (list != null) {
                for (Map row : list) {
                    ResDistribuzione r = new ResDistribuzione();
                    r.setRisultato((String)row.get("nome_risorsa"));
                    Number somma = StatsUtils.converToNumber(row.get("somma"));
                    if (somma != null) {
                        r.setSomma(somma);
                    } else {
                        r.setSomma((Number)0);
                    }
                    if (r.getRisultato().contains(FALSA_UNION_DEFAULT_VALUE)) continue;
                    res.add(r);
                }
            }
            return res;
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotFoundException e) {
            StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente.");
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        return new ArrayList<ResDistribuzione>();
    }

    private NonNegativeNumber executeDistribuzionePersonalizzataCount() throws ServiceException, NotImplementedException {
        StatisticaModel model = null;
        IStatisticaGiornalieraServiceSearch dao = null;
        StatisticaContenutiModel modelContenuti = null;
        StatisticType tipologia = this.statistichePersonalizzateSearch.getModalitaTemporale();
        switch (tipologia) {
            case GIORNALIERA: {
                model = StatisticaGiornaliera.model().STATISTICA_BASE;
                modelContenuti = StatisticaGiornaliera.model().STATISTICA_GIORNALIERA_CONTENUTI;
                dao = this.statGiornaliereSearchDAO;
                break;
            }
            case MENSILE: {
                model = StatisticaMensile.model().STATISTICA_BASE;
                modelContenuti = StatisticaMensile.model().STATISTICA_MENSILE_CONTENUTI;
                dao = this.statMensileSearchDAO;
                break;
            }
            case ORARIA: {
                model = StatisticaOraria.model().STATISTICA_BASE;
                modelContenuti = StatisticaOraria.model().STATISTICA_ORARIA_CONTENUTI;
                dao = this.statOrariaSearchDAO;
                break;
            }
            case SETTIMANALE: {
                model = StatisticaSettimanale.model().STATISTICA_BASE;
                modelContenuti = StatisticaSettimanale.model().STATISTICA_SETTIMANALE_CONTENUTI;
                dao = this.statSettimanaleSearchDAO;
            }
        }
        if (dao == null) {
            throw new ServiceException("DAO unknown");
        }
        if (model == null) {
            throw new ServiceException("Model unknown");
        }
        if (modelContenuti == null) {
            throw new ServiceException("ModelContenuti unknown");
        }
        List<Index> forceIndexes = null;
        try {
            forceIndexes = this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexPersonalizzataDistribuzioneCount(tipologia, this.govwayMonitorProperties.getExternalForceIndexRepository()));
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
        IExpression expr = this.createDistribuzionePersonalizzataExpression((IServiceSearchWithoutId<?>)dao, model, modelContenuti, true);
        if (forceIndexes != null && !forceIndexes.isEmpty()) {
            for (Index index : forceIndexes) {
                try {
                    expr.addForceIndex(index);
                }
                catch (Exception e) {
                    throw new ServiceException(e.getMessage(), (Throwable)e);
                }
            }
        }
        return dao.count(expr);
    }

    private IExpression createDistribuzionePersonalizzataExpression(IServiceSearchWithoutId<?> dao, StatisticaModel model, StatisticaContenutiModel modelContenuti, boolean isCount) throws ServiceException {
        IExpression expr = null;
        FilterImpl report = (FilterImpl)this.statistichePersonalizzateSearch.getFiltroReport();
        try {
            expr = this.parseStatistichePersonalizzateFilter(dao, model, modelContenuti);
            expr.and();
            this.impostaFiltroDatiMittente(expr, this.statistichePersonalizzateSearch, model, isCount);
            this.impostaFiltroGruppo(expr, this.statistichePersonalizzateSearch, model, isCount);
            this.impostaFiltroApi(expr, this.statistichePersonalizzateSearch, model, isCount);
            this.impostaFiltroIdClusterOrCanale(expr, this.statistichePersonalizzateSearch, model, isCount);
            String nomeStatisticaPersonalizzata = this.statistichePersonalizzateSearch.getStatisticaSelezionata().getIdConfigurazioneStatistica();
            if (report != null && report.getIdStatistic() != null) {
                expr.like(modelContenuti.RISORSA_NOME, nomeStatisticaPersonalizzata + "-" + report.getIdStatistic(), LikeMode.EXACT);
            } else {
                expr.like(modelContenuti.RISORSA_NOME, nomeStatisticaPersonalizzata, LikeMode.EXACT);
            }
            if (report != null) {
                expr.and(new IExpression[]{report.getExpression()});
            }
            expr.addGroupBy(modelContenuti.RISORSA_VALORE);
            if (!isCount) {
                expr.sortOrder(SortOrder.ASC).addOrder(modelContenuti.RISORSA_VALORE);
            }
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (UtilsException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ServiceException e) {
            throw e;
        }
        return expr;
    }

    @Override
    public Map<String, List<Res>> findAllAndamentoTemporalePersonalizzato() throws ServiceException {
        Map<String, List<Res>> res = this.executeAndamentoTemporalePersonalizzatoSearch(false, true, -1, -1);
        return res;
    }

    @Override
    public Map<String, List<Res>> findAllAndamentoTemporalePersonalizzato(int start, int limit) throws ServiceException {
        Map<String, List<Res>> res = this.executeAndamentoTemporalePersonalizzatoSearch(false, true, start, limit);
        return res;
    }

    private Map<String, List<Res>> executeAndamentoTemporalePersonalizzatoSearch(boolean isCount, boolean isPaginated, int offset, int limit) throws ServiceException {
        StatisticaModel model = null;
        StatisticaContenutiModel modelContenuti = null;
        StatisticType tipologia = this.statistichePersonalizzateSearch.getModalitaTemporale();
        try {
            Res r;
            switch (tipologia) {
                case GIORNALIERA: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    modelContenuti = StatisticaGiornaliera.model().STATISTICA_GIORNALIERA_CONTENUTI;
                    this.dao = this.statGiornaliereSearchDAO;
                    break;
                }
                case MENSILE: {
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    modelContenuti = StatisticaMensile.model().STATISTICA_MENSILE_CONTENUTI;
                    this.dao = this.statMensileSearchDAO;
                    break;
                }
                case ORARIA: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    modelContenuti = StatisticaOraria.model().STATISTICA_ORARIA_CONTENUTI;
                    this.dao = this.statOrariaSearchDAO;
                    break;
                }
                case SETTIMANALE: {
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    modelContenuti = StatisticaSettimanale.model().STATISTICA_SETTIMANALE_CONTENUTI;
                    this.dao = this.statSettimanaleSearchDAO;
                }
            }
            if (this.dao == null) {
                throw new ServiceException("DAO unknown");
            }
            if (model == null) {
                throw new ServiceException("Model unknown");
            }
            if (modelContenuti == null) {
                throw new ServiceException("ModelContenuti unknown");
            }
            ISQLFieldConverter fieldConverter = ((IDBServiceUtilities)this.dao).getFieldConverter();
            List<Index> forceIndexes = null;
            try {
                forceIndexes = isCount ? this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexPersonalizzataAndamentoTemporaleCount(tipologia, this.govwayMonitorProperties.getExternalForceIndexRepository())) : this.convertForceIndexList((IModel<?>)model, this.govwayMonitorProperties.getStatisticheForceIndexPersonalizzataAndamentoTemporaleGroupBy(tipologia, this.govwayMonitorProperties.getExternalForceIndexRepository()));
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
            IExpression expr = this.createAndamentoTemporalePersonalizzatoExpression(this.dao, model, modelContenuti, isCount);
            boolean isLatenza = false;
            boolean isLatenza_totale = false;
            boolean isLatenza_servizio = false;
            boolean isLatenza_porta = false;
            boolean isBanda = false;
            boolean isBanda_complessiva = false;
            boolean isBanda_interna = false;
            boolean isBanda_esterna = false;
            ArrayList<FunctionField> listaFunzioni = new ArrayList<FunctionField>();
            TipoVisualizzazione tipoVisualizzazione = this.statistichePersonalizzateSearch.getTipoVisualizzazione();
            block10 : switch (tipoVisualizzazione) {
                case DIMENSIONE_TRANSAZIONI: {
                    isBanda = true;
                    TipoBanda tipoBanda = this.statistichePersonalizzateSearch.getTipoBanda();
                    switch (tipoBanda) {
                        case COMPLESSIVA: {
                            listaFunzioni.add(new FunctionField(modelContenuti.DIMENSIONI_BYTES_BANDA_COMPLESSIVA, Function.SUM, "somma_banda_complessiva"));
                            isBanda_complessiva = true;
                            break;
                        }
                        case INTERNA: {
                            listaFunzioni.add(new FunctionField(modelContenuti.DIMENSIONI_BYTES_BANDA_INTERNA, Function.SUM, "somma_banda_interna"));
                            isBanda_interna = true;
                            break;
                        }
                        case ESTERNA: {
                            listaFunzioni.add(new FunctionField(modelContenuti.DIMENSIONI_BYTES_BANDA_ESTERNA, Function.SUM, "somma_banda_esterna"));
                            isBanda_esterna = true;
                        }
                    }
                    break;
                }
                case NUMERO_TRANSAZIONI: {
                    listaFunzioni.add(new FunctionField(modelContenuti.NUMERO_TRANSAZIONI, Function.SUM, "somma"));
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    isLatenza = true;
                    TipoLatenza tipoLatenza = this.statistichePersonalizzateSearch.getTipoLatenza();
                    switch (tipoLatenza) {
                        case LATENZA_PORTA: {
                            expr.isNotNull(modelContenuti.LATENZA_PORTA);
                            listaFunzioni.add(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)modelContenuti.LATENZA_PORTA, (IField)modelContenuti.NUMERO_TRANSAZIONI, (String)"somma_latenza_porta"));
                            isLatenza_porta = true;
                            break block10;
                        }
                        case LATENZA_SERVIZIO: {
                            expr.isNotNull(modelContenuti.LATENZA_SERVIZIO);
                            listaFunzioni.add(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)modelContenuti.LATENZA_SERVIZIO, (IField)modelContenuti.NUMERO_TRANSAZIONI, (String)"somma_latenza_servizio"));
                            isLatenza_servizio = true;
                            break block10;
                        }
                    }
                    expr.isNotNull(modelContenuti.LATENZA_TOTALE);
                    listaFunzioni.add(StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)modelContenuti.LATENZA_TOTALE, (IField)modelContenuti.NUMERO_TRANSAZIONI, (String)"somma_latenza_totale"));
                    isLatenza_totale = true;
                }
            }
            if (forceIndexes != null && !forceIndexes.isEmpty()) {
                for (Index index : forceIndexes) {
                    expr.addForceIndex(index);
                }
            }
            this.timeoutEvent = false;
            List list = null;
            if (!isPaginated) {
                if (this.timeoutRicerche == null) {
                    list = this.dao.groupBy(expr, listaFunzioni.toArray(new FunctionField[listaFunzioni.size()]));
                } else {
                    try {
                        list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.dao.groupBy(expr, listaFunzioni.toArray(new FunctionField[listaFunzioni.size()]))).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        StatisticheGiornaliereService.logError(e.getMessage(), e);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() instanceof NotFoundException) {
                            throw (NotFoundException)e.getCause();
                        }
                        if (e.getCause() instanceof ServiceException) {
                            throw (ServiceException)e.getCause();
                        }
                        if (e.getCause() instanceof NotImplementedException) {
                            throw (NotImplementedException)e.getCause();
                        }
                        StatisticheGiornaliereService.logError(e.getMessage(), e);
                    }
                    catch (TimeoutException e) {
                        this.timeoutEvent = true;
                        StatisticheGiornaliereService.logError(e.getMessage(), e);
                        return null;
                    }
                }
            } else {
                IPaginatedExpression pagExpr = this.dao.toPaginatedExpression(expr);
                pagExpr.offset(offset).limit(limit);
                if (this.timeoutRicerche == null) {
                    list = this.dao.groupBy(pagExpr, listaFunzioni.toArray(new FunctionField[listaFunzioni.size()]));
                } else {
                    try {
                        list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.dao.groupBy(pagExpr, listaFunzioni.toArray(new FunctionField[listaFunzioni.size()]))).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        StatisticheGiornaliereService.logError(e.getMessage(), e);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() instanceof NotFoundException) {
                            throw (NotFoundException)e.getCause();
                        }
                        if (e.getCause() instanceof ServiceException) {
                            throw (ServiceException)e.getCause();
                        }
                        if (e.getCause() instanceof NotImplementedException) {
                            throw (NotImplementedException)e.getCause();
                        }
                        StatisticheGiornaliereService.logError(e.getMessage(), e);
                    }
                    catch (TimeoutException e) {
                        this.timeoutEvent = true;
                        StatisticheGiornaliereService.logError(e.getMessage(), e);
                        return null;
                    }
                }
            }
            TreeMap<String, List<Res>> mapRisultati = new TreeMap<String, List<Res>>();
            TreeMap<String, List<Date>> mapDateUsate = new TreeMap<String, List<Date>>();
            ArrayList<Date> listaDateUtilizzate = new ArrayList<Date>();
            if (list != null) {
                for (Map row : list) {
                    Date data;
                    String valoreRisorsa = (String)row.get(GenericJDBCUtilities.getAlias((Object)modelContenuti.RISORSA_VALORE));
                    List<Object> res = null;
                    List<Date> datePerRes = null;
                    boolean nuovaEntry = true;
                    if (mapRisultati.containsKey(valoreRisorsa)) {
                        nuovaEntry = false;
                        res = mapRisultati.get(valoreRisorsa);
                        datePerRes = (List)mapDateUsate.get(valoreRisorsa);
                    }
                    if (nuovaEntry) {
                        res = new ArrayList();
                        datePerRes = new ArrayList();
                    }
                    if (!listaDateUtilizzate.contains(data = (Date)row.get(GenericJDBCUtilities.getAlias((Object)model.DATA)))) {
                        listaDateUtilizzate.add(data);
                    }
                    if (!datePerRes.contains(data)) {
                        datePerRes.add(data);
                    }
                    r = new Res();
                    r.setId(data != null ? Long.valueOf(data.getTime()) : null);
                    r.setRisultato(data);
                    if (isLatenza) {
                        Number obLT = StatsUtils.converToNumber(row.get("somma_latenza_totale"));
                        Number obLS = StatsUtils.converToNumber(row.get("somma_latenza_servizio"));
                        Number obLP = StatsUtils.converToNumber(row.get("somma_latenza_porta"));
                        if (obLT != null) {
                            r.inserisciSomma(obLT);
                        } else if (isLatenza_totale) {
                            r.inserisciSomma((Number)0);
                        }
                        if (obLS != null) {
                            r.inserisciSomma(obLS);
                        } else if (isLatenza_servizio) {
                            r.inserisciSomma((Number)0);
                        }
                        if (obLP != null) {
                            r.inserisciSomma(obLP);
                        } else if (isLatenza_porta) {
                            r.inserisciSomma((Number)0);
                        }
                    } else if (isBanda) {
                        Number obBandaComplessiva = StatsUtils.converToNumber(row.get("somma_banda_complessiva"));
                        Number obBandaInterna = StatsUtils.converToNumber(row.get("somma_banda_interna"));
                        Number obBandaEsterna = StatsUtils.converToNumber(row.get("somma_banda_esterna"));
                        if (obBandaComplessiva != null) {
                            r.inserisciSomma(obBandaComplessiva);
                        } else if (isBanda_complessiva) {
                            r.inserisciSomma((Number)0);
                        }
                        if (obBandaInterna != null) {
                            r.inserisciSomma(obBandaInterna);
                        } else if (isBanda_interna) {
                            r.inserisciSomma((Number)0);
                        }
                        if (obBandaEsterna != null) {
                            r.inserisciSomma(obBandaEsterna);
                        } else if (isBanda_esterna) {
                            r.inserisciSomma((Number)0);
                        }
                    } else {
                        Number obSm = StatsUtils.converToNumber(row.get("somma"));
                        if (obSm != null) {
                            r.setSomma(obSm);
                        } else {
                            r.setSomma((Number)0);
                        }
                    }
                    res.add(r);
                    if (!nuovaEntry) continue;
                    mapRisultati.put(valoreRisorsa, res);
                    mapDateUsate.put(valoreRisorsa, datePerRes);
                }
            }
            for (String val : mapRisultati.keySet()) {
                List<Res> entries = mapRisultati.get(val);
                List dateVal = (List)mapDateUsate.get(val);
                Collections.sort(listaDateUtilizzate);
                ArrayList<Res> listaResOrdinata = new ArrayList<Res>();
                for (Date data : listaDateUtilizzate) {
                    if (!dateVal.contains(data)) {
                        r = new Res();
                        r.setId(data != null ? Long.valueOf(data.getTime()) : null);
                        r.setRisultato(data);
                        r.inserisciSomma((Number)0);
                        listaResOrdinata.add(r);
                        continue;
                    }
                    Res tmpRes = null;
                    for (Res res2 : entries) {
                        if (res2.getId().longValue() != data.getTime()) continue;
                        tmpRes = res2;
                        break;
                    }
                    if (tmpRes == null) continue;
                    listaResOrdinata.add(tmpRes);
                }
                entries.clear();
                entries.addAll(listaResOrdinata);
            }
            return mapRisultati;
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (UtilsException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (NotFoundException e) {
            StatisticheGiornaliereService.logDebug("Nessuna statistica trovata per la ricerca corrente.");
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        return null;
    }

    private IExpression createAndamentoTemporalePersonalizzatoExpression(IServiceSearchWithoutId<?> dao, StatisticaModel model, StatisticaContenutiModel modelContenuti, boolean isCount) throws ServiceException, UtilsException {
        IExpression expr = null;
        FilterImpl report = (FilterImpl)this.statistichePersonalizzateSearch.getFiltroReport();
        try {
            String[] valoriRisorsa;
            expr = this.parseStatistichePersonalizzateFilter(dao, model, modelContenuti);
            this.impostaFiltroDatiMittente(expr, this.statistichePersonalizzateSearch, model, isCount);
            this.impostaFiltroGruppo(expr, this.statistichePersonalizzateSearch, model, isCount);
            this.impostaFiltroApi(expr, this.statistichePersonalizzateSearch, model, isCount);
            this.impostaFiltroIdClusterOrCanale(expr, this.statistichePersonalizzateSearch, model, isCount);
            String nomeStatisticaPersonalizzata = this.statistichePersonalizzateSearch.getStatisticaSelezionata().getIdConfigurazioneStatistica();
            if (report != null && report.getIdStatistic() != null) {
                expr.like(modelContenuti.RISORSA_NOME, nomeStatisticaPersonalizzata + "-" + report.getIdStatistic(), LikeMode.EXACT);
            } else {
                expr.like(modelContenuti.RISORSA_NOME, nomeStatisticaPersonalizzata, LikeMode.EXACT);
            }
            if (report != null) {
                expr.and(new IExpression[]{report.getExpression()});
            }
            if ((valoriRisorsa = this.statistichePersonalizzateSearch.getValoriRisorsa()) != null && valoriRisorsa.length > 0) {
                expr.in(modelContenuti.RISORSA_VALORE, Arrays.asList(valoriRisorsa));
            }
            expr.addGroupBy(model.DATA).addGroupBy(modelContenuti.RISORSA_VALORE);
            if (!isCount) {
                expr.sortOrder(SortOrder.ASC).addOrder(model.DATA, SortOrder.ASC).addOrder(modelContenuti.RISORSA_VALORE, SortOrder.ASC);
            }
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ServiceException e) {
            throw e;
        }
        return expr;
    }

    private IExpression parseStatistichePersonalizzateFilter(IServiceSearchWithoutId<?> dao, StatisticaModel model, StatisticaContenutiModel modelContenuti) throws ServiceException {
        IExpression expr = null;
        List listaSoggettiGestione = this.statistichePersonalizzateSearch.getSoggettiGestione();
        try {
            IExpression[] orSoggetti;
            EsitoUtils esitoUtils = new EsitoUtils(log, this.statistichePersonalizzateSearch.getProtocollo());
            expr = dao.newExpression();
            expr.between(model.DATA, (Object)this.statistichePersonalizzateSearch.getDataInizio(), (Object)this.statistichePersonalizzateSearch.getDataFine());
            StatisticheUtils.selezionaRecordValidi((IExpression)expr, (StatisticaModel)model);
            String protocollo = null;
            if (this.statistichePersonalizzateSearch.isSetFiltroProtocollo()) {
                protocollo = this.statistichePersonalizzateSearch.getProtocollo();
                this.impostaTipiCompatibiliConProtocollo(dao, model, expr, protocollo, this.statistichePersonalizzateSearch.getTipologiaRicercaEnum());
            }
            if (this.statistichePersonalizzateSearch.getPermessiUtenteOperatore() != null) {
                IExpression permessi = this.statistichePersonalizzateSearch.getPermessiUtenteOperatore().toExpression(dao, model.ID_PORTA, model.TIPO_DESTINATARIO, model.DESTINATARIO, model.TIPO_SERVIZIO, model.SERVIZIO, model.VERSIONE_SERVIZIO);
                expr.and(new IExpression[]{permessi});
            }
            if (Utility.isFiltroDominioAbilitato() && this.statistichePersonalizzateSearch.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.statistichePersonalizzateSearch.getSoggettoLocale()) && !"--".equals(this.statistichePersonalizzateSearch.getSoggettoLocale())) {
                String tipoSoggettoLocale = this.statistichePersonalizzateSearch.getTipoSoggettoLocale();
                String nomeSoggettoLocale = this.statistichePersonalizzateSearch.getSoggettoLocale();
                String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                expr.and().equals(model.ID_PORTA, (Object)idPorta);
            }
            if (StringUtils.isNotBlank((String)this.statistichePersonalizzateSearch.getNomeAzione())) {
                expr.and().equals(model.AZIONE, (Object)this.statistichePersonalizzateSearch.getNomeAzione());
            }
            if (StringUtils.isNotBlank((String)this.statistichePersonalizzateSearch.getNomeServizio())) {
                IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)this.statistichePersonalizzateSearch.getNomeServizio());
                expr.and().equals(model.TIPO_DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getTipo()).equals(model.DESTINATARIO, (Object)idServizio.getSoggettoErogatore().getNome()).equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo()).equals(model.SERVIZIO, (Object)idServizio.getNome()).equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
            }
            esitoUtils.setExpression(expr, this.statistichePersonalizzateSearch.getEsitoGruppo(), this.statistichePersonalizzateSearch.getEsitoDettaglio(), this.statistichePersonalizzateSearch.getEsitoDettaglioPersonalizzato(), this.statistichePersonalizzateSearch.getEsitoContesto(), this.statistichePersonalizzateSearch.isEscludiRichiesteScartate(), model.ESITO, model.ESITO_CONTESTO, dao.newExpression());
            if (this.statistichePersonalizzateSearch.getTipologiaRicercaEnum() == null || TipologiaRicerca.all.equals((Object)this.statistichePersonalizzateSearch.getTipologiaRicercaEnum())) {
                boolean trafficoSoggetto = StringUtils.isNotBlank((String)this.statistichePersonalizzateSearch.getTrafficoPerSoggetto());
                boolean soggetto = !listaSoggettiGestione.isEmpty();
                String tipoTrafficoSoggetto = null;
                String nomeTrafficoSoggetto = null;
                if (trafficoSoggetto) {
                    tipoTrafficoSoggetto = this.statistichePersonalizzateSearch.getTipoTrafficoPerSoggetto();
                    nomeTrafficoSoggetto = this.statistichePersonalizzateSearch.getTrafficoPerSoggetto();
                }
                IExpression e1 = dao.newExpression();
                IExpression e2 = dao.newExpression();
                if (trafficoSoggetto && soggetto) {
                    expr.and();
                    if (!listaSoggettiGestione.isEmpty()) {
                        IExpression[] orSoggetti2 = new IExpression[listaSoggettiGestione.size()];
                        IExpression[] orSoggetti22 = new IExpression[listaSoggettiGestione.size()];
                        int i = 0;
                        for (Soggetto sog : listaSoggettiGestione) {
                            IExpression se = dao.newExpression();
                            IExpression se2 = dao.newExpression();
                            se.equals(model.TIPO_MITTENTE, (Object)sog.getTipoSoggetto());
                            se.and().equals(model.MITTENTE, (Object)sog.getNomeSoggetto());
                            orSoggetti2[i] = se;
                            se2.equals(model.TIPO_DESTINATARIO, (Object)sog.getTipoSoggetto());
                            se2.and().equals(model.DESTINATARIO, (Object)sog.getNomeSoggetto());
                            orSoggetti22[i] = se2;
                            ++i;
                        }
                        e1.or(orSoggetti2);
                        e2.or(orSoggetti22);
                    }
                    e1.and().equals(model.TIPO_DESTINATARIO, (Object)tipoTrafficoSoggetto);
                    e1.and().equals(model.DESTINATARIO, (Object)nomeTrafficoSoggetto);
                    e2.and().equals(model.TIPO_MITTENTE, (Object)tipoTrafficoSoggetto);
                    e2.and().equals(model.MITTENTE, (Object)nomeTrafficoSoggetto);
                    expr.or(e1, e2);
                } else if (trafficoSoggetto && !soggetto) {
                    expr.and();
                    e1.equals(model.TIPO_DESTINATARIO, (Object)tipoTrafficoSoggetto);
                    e1.and().equals(model.DESTINATARIO, (Object)nomeTrafficoSoggetto);
                    e2.equals(model.TIPO_MITTENTE, (Object)tipoTrafficoSoggetto);
                    e2.and().equals(model.MITTENTE, (Object)nomeTrafficoSoggetto);
                    expr.or(e1, e2);
                } else if (!trafficoSoggetto && soggetto) {
                    expr.and();
                    if (!listaSoggettiGestione.isEmpty()) {
                        IExpression[] orSoggetti3 = new IExpression[listaSoggettiGestione.size()];
                        IExpression[] orSoggetti2 = new IExpression[listaSoggettiGestione.size()];
                        int i = 0;
                        for (Soggetto sog : listaSoggettiGestione) {
                            IExpression se = dao.newExpression();
                            IExpression se2 = dao.newExpression();
                            se.equals(model.TIPO_MITTENTE, (Object)sog.getTipoSoggetto());
                            se.and().equals(model.MITTENTE, (Object)sog.getNomeSoggetto());
                            orSoggetti3[i] = se;
                            se2.equals(model.TIPO_DESTINATARIO, (Object)sog.getTipoSoggetto());
                            se2.and().equals(model.DESTINATARIO, (Object)sog.getNomeSoggetto());
                            orSoggetti2[i] = se2;
                            ++i;
                        }
                        e1.or(orSoggetti3);
                        e2.or(orSoggetti2);
                    }
                    expr.or(e1, e2);
                }
            } else if (TipologiaRicerca.ingresso.equals((Object)this.statistichePersonalizzateSearch.getTipologiaRicercaEnum())) {
                expr.and().equals(model.TIPO_PORTA, (Object)"applicativa");
                if (!listaSoggettiGestione.isEmpty()) {
                    expr.and();
                    orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_DESTINATARIO, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.DESTINATARIO, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    expr.or(orSoggetti);
                }
                boolean ignoreSetMittente = this.isIgnoreSetMittente(this.statistichePersonalizzateSearch);
                if (StringUtils.isNotBlank((String)this.statistichePersonalizzateSearch.getNomeMittente()) && !ignoreSetMittente) {
                    expr.and().equals(model.TIPO_MITTENTE, (Object)this.statistichePersonalizzateSearch.getTipoMittente());
                    expr.and().equals(model.MITTENTE, (Object)this.statistichePersonalizzateSearch.getNomeMittente());
                }
            } else {
                expr.and().equals(model.TIPO_PORTA, (Object)"delegata");
                if (!listaSoggettiGestione.isEmpty()) {
                    expr.and();
                    orSoggetti = new IExpression[listaSoggettiGestione.size()];
                    int i = 0;
                    for (Soggetto soggetto : listaSoggettiGestione) {
                        IExpression se = dao.newExpression();
                        se.equals(model.TIPO_MITTENTE, (Object)soggetto.getTipoSoggetto());
                        se.and().equals(model.MITTENTE, (Object)soggetto.getNomeSoggetto());
                        orSoggetti[i] = se;
                        ++i;
                    }
                    expr.or(orSoggetti);
                }
                if (StringUtils.isNotBlank((String)this.statistichePersonalizzateSearch.getNomeDestinatario())) {
                    expr.and().equals(model.TIPO_DESTINATARIO, (Object)this.statistichePersonalizzateSearch.getTipoDestinatario());
                    expr.and().equals(model.DESTINATARIO, (Object)this.statistichePersonalizzateSearch.getNomeDestinatario());
                }
            }
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (CoreException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        return expr;
    }

    @Override
    public List<String> getValoriRisorse() throws ServiceException {
        StatisticheGiornaliereService.logDebug("Leggo i valori delle risorse per la statistica: " + this.statistichePersonalizzateSearch.getNomeStatisticaPersonalizzata());
        ArrayList<String> valori = new ArrayList<String>();
        StatisticaModel model = null;
        IStatisticaGiornalieraServiceSearch dao = null;
        StatisticaContenutiModel modelContenuti = null;
        StatisticType tipologia = this.statistichePersonalizzateSearch.getModalitaTemporale();
        switch (tipologia) {
            case GIORNALIERA: {
                model = StatisticaGiornaliera.model().STATISTICA_BASE;
                modelContenuti = StatisticaGiornaliera.model().STATISTICA_GIORNALIERA_CONTENUTI;
                dao = this.statGiornaliereSearchDAO;
                break;
            }
            case MENSILE: {
                model = StatisticaMensile.model().STATISTICA_BASE;
                modelContenuti = StatisticaMensile.model().STATISTICA_MENSILE_CONTENUTI;
                dao = this.statMensileSearchDAO;
                break;
            }
            case ORARIA: {
                model = StatisticaOraria.model().STATISTICA_BASE;
                modelContenuti = StatisticaOraria.model().STATISTICA_ORARIA_CONTENUTI;
                dao = this.statOrariaSearchDAO;
                break;
            }
            case SETTIMANALE: {
                model = StatisticaSettimanale.model().STATISTICA_BASE;
                modelContenuti = StatisticaSettimanale.model().STATISTICA_SETTIMANALE_CONTENUTI;
                dao = this.statSettimanaleSearchDAO;
            }
        }
        if (dao == null) {
            throw new ServiceException("DAO unknown");
        }
        if (model == null) {
            throw new ServiceException("Model unknown");
        }
        if (modelContenuti == null) {
            throw new ServiceException("ModelContenuti unknown");
        }
        try {
            Parameter<?> p;
            IExpression expr = this.parseStatistichePersonalizzateFilter((IServiceSearchWithoutId<?>)dao, model, modelContenuti);
            expr.and();
            this.impostaFiltroDatiMittente(expr, this.statistichePersonalizzateSearch, model, false);
            this.impostaFiltroGruppo(expr, this.statistichePersonalizzateSearch, model, false);
            this.impostaFiltroApi(expr, this.statistichePersonalizzateSearch, model, false);
            this.impostaFiltroIdClusterOrCanale(expr, this.statistichePersonalizzateSearch, model, false);
            boolean resourceStats = false;
            if ("__StatisticByResource__".equals(this.statistichePersonalizzateSearch.getStatisticaSelezionata().getIdConfigurazioneStatistica()) && this.statistichePersonalizzateSearch.getStatisticaSelezionataParameters() != null && this.statistichePersonalizzateSearch.getStatisticaSelezionataParameters().size() > 0 && (p = this.statistichePersonalizzateSearch.getStatisticaSelezionataParameters().get(0)) != null && "Risorsa".equals(p.getId())) {
                try {
                    if (p.getValue() != null) {
                        String resouceName = p.getValueAsString();
                        expr.like(modelContenuti.RISORSA_NOME, this.statistichePersonalizzateSearch.getStatisticaSelezionata().getIdConfigurazioneStatistica() + "-" + resouceName, LikeMode.EXACT);
                        resourceStats = true;
                    }
                }
                catch (Exception e) {
                    StatisticheGiornaliereService.logError(e.getMessage(), e);
                }
            }
            if (!resourceStats) {
                IExpression orName = dao.newExpression();
                orName.or();
                orName.like(modelContenuti.RISORSA_NOME, this.statistichePersonalizzateSearch.getStatisticaSelezionata().getIdConfigurazioneStatistica(), LikeMode.EXACT);
                orName.like(modelContenuti.RISORSA_NOME, this.statistichePersonalizzateSearch.getStatisticaSelezionata().getIdConfigurazioneStatistica() + "-", LikeMode.START);
                expr.and(new IExpression[]{orName});
            }
            expr.sortOrder(SortOrder.ASC).addOrder(modelContenuti.RISORSA_VALORE);
            IPaginatedExpression pagExpr = dao.toPaginatedExpression(expr);
            List select = dao.select(pagExpr, true, modelContenuti.RISORSA_VALORE);
            if (select != null && select.size() > 0) {
                for (Object object : select) {
                    valori.add((String)object);
                }
            }
        }
        catch (ServiceException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw e;
        }
        catch (UtilsException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (ExpressionException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (NotImplementedException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            throw new ServiceException((Throwable)e);
        }
        catch (NotFoundException e) {
            StatisticheGiornaliereService.logDebug(e.getMessage(), e);
        }
        return valori;
    }

    private void impostaTipiCompatibiliConProtocollo(IServiceSearchWithoutId<?> dao, StatisticaModel model, IExpression expr, String protocollo, TipologiaRicerca tipologiaRicercaParam) throws ExpressionNotImplementedException, ExpressionException {
        IExpression expressionTipoServiziCompatibili = null;
        try {
            if (protocollo != null) {
                expressionTipoServiziCompatibili = DynamicUtilsServiceEngine.getExpressionTipiServiziCompatibiliConProtocollo(dao, (IField)model.TIPO_SERVIZIO, (String)protocollo);
            }
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError("Si e' verificato un errore durante il calcolo dei tipi servizio compatibili con il protocollo scelto: " + e.getMessage(), e);
        }
        if (expressionTipoServiziCompatibili != null) {
            expr.and(new IExpression[]{expressionTipoServiziCompatibili});
        }
        IExpression expressionTipoSoggettiMittenteCompatibili = null;
        try {
            if (protocollo != null) {
                if (tipologiaRicercaParam == null || TipologiaRicerca.all.equals((Object)tipologiaRicercaParam) || TipologiaRicerca.ingresso.equals((Object)tipologiaRicercaParam)) {
                    expressionTipoSoggettiMittenteCompatibili = dao.newExpression();
                    expressionTipoSoggettiMittenteCompatibili.or();
                    expressionTipoSoggettiMittenteCompatibili.isNull(model.TIPO_MITTENTE);
                    expressionTipoSoggettiMittenteCompatibili.equals(model.TIPO_MITTENTE, (Object)"-");
                    expressionTipoSoggettiMittenteCompatibili.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(dao, (IField)model.TIPO_MITTENTE, (String)protocollo)});
                } else {
                    expressionTipoSoggettiMittenteCompatibili = DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(dao, (IField)model.TIPO_MITTENTE, (String)protocollo);
                }
            }
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError("Si e' verificato un errore durante il calcolo dei tipi soggetto mittente compatibili con il protocollo scelto: " + e.getMessage(), e);
        }
        if (expressionTipoSoggettiMittenteCompatibili != null) {
            expr.and(new IExpression[]{expressionTipoSoggettiMittenteCompatibili});
        }
        IExpression expressionTipoSoggettiDestinatarioCompatibili = null;
        try {
            if (protocollo != null) {
                expressionTipoSoggettiDestinatarioCompatibili = DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(dao, (IField)model.TIPO_DESTINATARIO, (String)protocollo);
            }
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError("Si e' verificato un errore durante il calcolo dei tipi soggetto destinatario compatibili con il protocollo scelto: " + e.getMessage(), e);
        }
        if (expressionTipoSoggettiDestinatarioCompatibili != null) {
            expr.and(new IExpression[]{expressionTipoSoggettiDestinatarioCompatibili});
        }
    }

    private IField getCredenzialeField(CredenzialeMittente credenzialeMittente, StatisticaModel model) throws ServiceException {
        IField fieldCredenziale = null;
        String credenzialeTipo = credenzialeMittente.getTipo();
        if (credenzialeTipo.startsWith("trasporto")) {
            fieldCredenziale = model.TRASPORTO_MITTENTE;
        } else {
            TipoCredenzialeMittente tcm = null;
            try {
                tcm = TipoCredenzialeMittente.toEnumConstant((String)credenzialeTipo, (boolean)true);
            }
            catch (NotFoundException e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
            switch (tcm) {
                case TOKEN_CLIENT_ID: {
                    fieldCredenziale = model.TOKEN_CLIENT_ID;
                    break;
                }
                case TOKEN_EMAIL: {
                    fieldCredenziale = model.TOKEN_MAIL;
                    break;
                }
                case TOKEN_ISSUER: {
                    fieldCredenziale = model.TOKEN_ISSUER;
                    break;
                }
                case TOKEN_SUBJECT: {
                    fieldCredenziale = model.TOKEN_SUBJECT;
                    break;
                }
                case TOKEN_USERNAME: {
                    fieldCredenziale = model.TOKEN_USERNAME;
                    break;
                }
                case CLIENT_ADDRESS: {
                    return model.CLIENT_ADDRESS;
                }
                case GRUPPI: {
                    return model.GRUPPI;
                }
                case API: {
                    return model.URI_API;
                }
            }
        }
        return fieldCredenziale;
    }

    private List<CredenzialeMittente> getIdCredenzialiFromFilter(BaseSearchForm searchForm, ICredenzialeMittenteService credenzialeMittentiService, boolean isCount) {
        List<Object> findAll = new ArrayList<CredenzialeMittente>();
        try {
            CaseSensitiveMatch caseSensitiveMatch = CaseSensitiveMatch.valueOf((String)searchForm.getMittenteCaseSensitiveType());
            TipoMatch match = TipoMatch.valueOf((String)searchForm.getMittenteMatchingType());
            boolean ricercaEsatta = TipoMatch.EQUALS.equals((Object)match);
            boolean caseSensitive = CaseSensitiveMatch.SENSITIVE.equals((Object)caseSensitiveMatch);
            IPaginatedExpression pagExpr = null;
            if (searchForm.getRiconoscimento().equals("identificativoAutenticato")) {
                CredenzialeSearchTrasporto searchTrasporto = new CredenzialeSearchTrasporto(searchForm.getAutenticazione());
                pagExpr = searchTrasporto.createExpression(credenzialeMittentiService, searchForm.getValoreRiconoscimento(), ricercaEsatta, caseSensitive);
            }
            if (searchForm.getRiconoscimento().equals("ip")) {
                caseSensitive = true;
                boolean socketAddress = false;
                boolean trasportAddress = false;
                boolean and = false;
                if (ricercaEsatta) {
                    if ("socket".equals(searchForm.getClientAddressMode())) {
                        socketAddress = true;
                    } else if ("transport".equals(searchForm.getClientAddressMode())) {
                        trasportAddress = true;
                    } else {
                        socketAddress = true;
                        trasportAddress = true;
                    }
                }
                CredenzialeSearchClientAddress searchClientAddress = new CredenzialeSearchClientAddress(socketAddress, trasportAddress, and);
                pagExpr = searchClientAddress.createExpression(credenzialeMittentiService, searchForm.getValoreRiconoscimento(), ricercaEsatta, caseSensitive);
            }
            boolean searchByRefCredentials = false;
            if (searchForm.getRiconoscimento().equals("tokenInfo")) {
                TipoCredenzialeMittente tcm = TipoCredenzialeMittente.toEnumConstant((String)searchForm.getTokenClaim(), (boolean)true);
                CredenzialeSearchTokenClient searchToken = null;
                Object valoreRiconoscimento = searchForm.getValoreRiconoscimento();
                if (TipoCredenzialeMittente.TOKEN_CLIENT_ID.equals((Object)tcm)) {
                    searchToken = new CredenzialeSearchTokenClient(true, false, true);
                } else if (TipoCredenzialeMittente.PDND_ORGANIZATION_EXTERNAL_ID.equals((Object)tcm) || TipoCredenzialeMittente.PDND_ORGANIZATION_CONSUMER_ID.equals((Object)tcm)) {
                    searchToken = new CredenzialeSearchToken(TipoCredenzialeMittente.PDND_ORGANIZATION_JSON);
                    searchByRefCredentials = true;
                    if (ricercaEsatta) {
                        valoreRiconoscimento = "\"" + (String)valoreRiconoscimento + "\"";
                    }
                    ricercaEsatta = false;
                } else {
                    searchToken = new CredenzialeSearchToken(tcm);
                    searchByRefCredentials = TipoCredenzialeMittente.PDND_ORGANIZATION_NAME.equals((Object)tcm);
                }
                pagExpr = searchToken.createExpression(credenzialeMittentiService, (String)valoreRiconoscimento, ricercaEsatta, caseSensitive);
            }
            findAll = credenzialeMittentiService.findAll(pagExpr);
            if (searchByRefCredentials) {
                findAll = CredenzialiMittenteUtils.translateByRef(findAll, (ICredenzialeMittenteService)credenzialeMittentiService);
            }
        }
        catch (ExpressionException | ExpressionNotImplementedException | NotFoundException | NotImplementedException | ServiceException | UtilsException e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        return findAll;
    }

    private void impostaFiltroDatiMittente(IExpression filter, BaseSearchForm searchForm, StatisticaModel model, boolean isCount) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        if (StringUtils.isNotEmpty((String)searchForm.getRiconoscimento())) {
            if (searchForm.getRiconoscimento().equals("applicativo")) {
                if (StringUtils.isNotBlank((String)searchForm.getIdentificazione()) && StringUtils.isNotBlank((String)searchForm.getServizioApplicativo())) {
                    if ("commons.identificazione.trasporto.label".equals(searchForm.getIdentificazione())) {
                        filter.and().equals(model.SERVIZIO_APPLICATIVO, (Object)searchForm.getServizioApplicativo());
                    } else if ("commons.identificazione.token.label".equals(searchForm.getIdentificazione())) {
                        boolean soggettoDefined;
                        boolean bl = soggettoDefined = StringUtils.isNotBlank((String)searchForm.getNomeMittente()) && StringUtils.isNotBlank((String)searchForm.getTipoMittente());
                        if (soggettoDefined) {
                            IDSoggetto idSoggetto = new IDSoggetto(searchForm.getTipoMittente(), searchForm.getNomeMittente());
                            IDServizioApplicativo idSA = new IDServizioApplicativo();
                            idSA.setIdSoggettoProprietario(idSoggetto);
                            idSA.setNome(searchForm.getServizioApplicativo());
                            String idSAasString = CredenzialeTokenClient.getApplicationAsString((IDServizioApplicativo)idSA);
                            String dbValue = CredenzialeTokenClient.getApplicationDBValue((String)idSAasString);
                            CredenzialeSearchTokenClient searchToken = new CredenzialeSearchTokenClient(false, true, false);
                            searchToken.disableConvertToDBValue();
                            boolean ricercaEsatta = false;
                            boolean caseSensitive = true;
                            try {
                                IPaginatedExpression pagExpr = searchToken.createExpression(this.credenzialiMittenteDAO, dbValue, ricercaEsatta, caseSensitive);
                                List listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
                                this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, model);
                            }
                            catch (Exception e) {
                                throw new ServiceException(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
            } else if (!searchForm.getRiconoscimento().equals("soggetto") && (searchForm.getRiconoscimento().equals("identificativoAutenticato") || searchForm.getRiconoscimento().equals("ip") || searchForm.getRiconoscimento().equals("tokenInfo"))) {
                List<CredenzialeMittente> listaCredenzialiMittente = this.getIdCredenzialiFromFilter(searchForm, this.credenzialiMittenteDAO, isCount);
                this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, model);
            }
        }
    }

    private void impostaFiltroGruppo(IExpression filter, BaseSearchForm searchForm, StatisticaModel model, boolean isCount) throws UtilsException, ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        if (StringUtils.isNotEmpty((String)searchForm.getGruppo())) {
            CredenzialeSearchGruppo searchGruppi = new CredenzialeSearchGruppo();
            IPaginatedExpression pagExpr = searchGruppi.createExpression(this.credenzialiMittenteDAO, searchForm.getGruppo(), true, true);
            List listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
            this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, model);
        }
    }

    private void impostaFiltroApi(IExpression filter, BaseSearchForm searchForm, StatisticaModel model, boolean isCount) throws UtilsException, ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        if (StringUtils.isNotEmpty((String)searchForm.getApi())) {
            CredenzialeSearchApi searchApi = new CredenzialeSearchApi();
            IPaginatedExpression pagExpr = searchApi.createExpression(this.credenzialiMittenteDAO, searchForm.getApi(), true, true);
            List listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
            this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, model);
        }
    }

    private void impostaFiltroIdClusterOrCanale(IExpression filter, BaseSearchForm searchForm, StatisticaModel model, boolean isCount) throws UtilsException, ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        if (StringUtils.isNotEmpty((String)searchForm.getClusterId())) {
            if (this.clusterDinamico) {
                List<String> listId = this.getClusterIdDinamici(searchForm.getClusterId().trim(), this.clusterDinamicoRefresh);
                if (listId != null && !listId.isEmpty()) {
                    filter.and().in(model.CLUSTER_ID, listId);
                } else {
                    filter.and().equals(model.CLUSTER_ID, (Object)"--");
                }
            } else {
                filter.and().equals(model.CLUSTER_ID, (Object)searchForm.getClusterId().trim());
            }
        } else if (StringUtils.isNotEmpty((String)searchForm.getCanale())) {
            List listId = searchForm.getIdClusterByCanale(searchForm.getCanale());
            if (listId != null && !listId.isEmpty()) {
                filter.and().in(model.CLUSTER_ID, (Collection)listId);
            } else {
                filter.and().equals(model.CLUSTER_ID, (Object)"--");
            }
        }
    }

    private void impostaGroupByFiltroDatiMittente(IExpression filter, BaseSearchForm searchForm, StatisticaModel model, boolean isCount) throws ExpressionNotImplementedException, ExpressionException, NotFoundException {
        if (StringUtils.isNotEmpty((String)searchForm.getRiconoscimento())) {
            if (searchForm.getRiconoscimento().equals("applicativo")) {
                if (StringUtils.isNotBlank((String)this.distribSaSearch.getIdentificazione()) && "commons.identificazione.token.label".equals(this.distribSaSearch.getIdentificazione())) {
                    filter.notEquals(model.TOKEN_CLIENT_ID, (Object)"-");
                    filter.addGroupBy(model.TOKEN_CLIENT_ID);
                } else {
                    filter.notEquals(model.SERVIZIO_APPLICATIVO, (Object)"-");
                    filter.addGroupBy(model.SERVIZIO_APPLICATIVO);
                }
            } else {
                if (searchForm.getRiconoscimento().equals("soggetto")) {
                    return;
                }
                if (searchForm.getRiconoscimento().equals("identificativoAutenticato")) {
                    filter.notEquals(model.TRASPORTO_MITTENTE, (Object)"-");
                    filter.addGroupBy(model.TRASPORTO_MITTENTE);
                } else if (searchForm.getRiconoscimento().equals("ip")) {
                    filter.notEquals(model.CLIENT_ADDRESS, (Object)"-");
                    filter.addGroupBy(model.CLIENT_ADDRESS);
                } else if (searchForm.getRiconoscimento().equals("tokenInfo")) {
                    TipoCredenzialeMittente tcm = TipoCredenzialeMittente.toEnumConstant((String)searchForm.getTokenClaim(), (boolean)true);
                    switch (tcm) {
                        case TOKEN_CLIENT_ID: 
                        case PDND_ORGANIZATION_NAME: {
                            filter.notEquals(model.TOKEN_CLIENT_ID, (Object)"-");
                            filter.addGroupBy(model.TOKEN_CLIENT_ID);
                            break;
                        }
                        case TOKEN_EMAIL: {
                            filter.notEquals(model.TOKEN_MAIL, (Object)"-");
                            filter.addGroupBy(model.TOKEN_MAIL);
                            break;
                        }
                        case TOKEN_ISSUER: {
                            filter.notEquals(model.TOKEN_ISSUER, (Object)"-");
                            filter.addGroupBy(model.TOKEN_ISSUER);
                            break;
                        }
                        case TOKEN_SUBJECT: {
                            filter.notEquals(model.TOKEN_SUBJECT, (Object)"-");
                            filter.addGroupBy(model.TOKEN_SUBJECT);
                            break;
                        }
                        case TOKEN_USERNAME: {
                            filter.notEquals(model.TOKEN_USERNAME, (Object)"-");
                            filter.addGroupBy(model.TOKEN_USERNAME);
                            break;
                        }
                        case CLIENT_ADDRESS: {
                            filter.notEquals(model.CLIENT_ADDRESS, (Object)"-");
                            filter.addGroupBy(model.CLIENT_ADDRESS);
                            break;
                        }
                        case GRUPPI: {
                            filter.notEquals(model.GRUPPI, (Object)"-");
                            filter.addGroupBy(model.GRUPPI);
                            break;
                        }
                        case API: {
                            filter.notEquals(model.URI_API, (Object)"-");
                            filter.addGroupBy(model.URI_API);
                            break;
                        }
                    }
                }
            }
        }
    }

    private IField getCredenzialeFieldGroupBy(BaseSearchForm searchForm, StatisticaModel model) throws NotFoundException {
        if (StringUtils.isNotEmpty((String)searchForm.getRiconoscimento())) {
            if (searchForm.getRiconoscimento().equals("applicativo")) {
                if (StringUtils.isNotBlank((String)this.distribSaSearch.getIdentificazione()) && "commons.identificazione.token.label".equals(this.distribSaSearch.getIdentificazione())) {
                    return model.TOKEN_CLIENT_ID;
                }
                return model.SERVIZIO_APPLICATIVO;
            }
            if (searchForm.getRiconoscimento().equals("soggetto")) {
                return null;
            }
            if (searchForm.getRiconoscimento().equals("identificativoAutenticato")) {
                return model.TRASPORTO_MITTENTE;
            }
            if (searchForm.getRiconoscimento().equals("ip")) {
                return model.CLIENT_ADDRESS;
            }
            if (searchForm.getRiconoscimento().equals("tokenInfo")) {
                TipoCredenzialeMittente tcm = TipoCredenzialeMittente.toEnumConstant((String)searchForm.getTokenClaim(), (boolean)true);
                switch (tcm) {
                    case TOKEN_CLIENT_ID: {
                        return model.TOKEN_CLIENT_ID;
                    }
                    case TOKEN_EMAIL: {
                        return model.TOKEN_MAIL;
                    }
                    case TOKEN_ISSUER: {
                        return model.TOKEN_ISSUER;
                    }
                    case TOKEN_SUBJECT: {
                        return model.TOKEN_SUBJECT;
                    }
                    case TOKEN_USERNAME: {
                        return model.TOKEN_USERNAME;
                    }
                    case CLIENT_ADDRESS: {
                        return model.CLIENT_ADDRESS;
                    }
                    case GRUPPI: {
                        return model.GRUPPI;
                    }
                    case API: {
                        return model.URI_API;
                    }
                    case PDND_ORGANIZATION_NAME: 
                    case PDND_ORGANIZATION_EXTERNAL_ID: 
                    case PDND_ORGANIZATION_CONSUMER_ID: {
                        return model.TOKEN_CLIENT_ID;
                    }
                }
            }
        }
        return null;
    }

    private String getLabelCredenzialeFieldGroupBy(String risultato, BaseSearchForm searchForm, StringBuilder sbTipoCredenziale) {
        try {
            if (StringUtils.isNotEmpty((String)searchForm.getRiconoscimento())) {
                if (searchForm.getRiconoscimento().equals("applicativo")) {
                    if (StringUtils.isNotBlank((String)this.distribSaSearch.getIdentificazione()) && "commons.identificazione.token.label".equals(this.distribSaSearch.getIdentificazione())) {
                        if (StringUtils.isNotEmpty((String)risultato)) {
                            MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, log);
                            CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(risultato)));
                            if (credenzialeMittente != null && credenzialeMittente.getTipo() != null) {
                                sbTipoCredenziale.append(credenzialeMittente.getTipo());
                            }
                            return credenzialeMittente != null ? credenzialeMittente.getCredenziale() : risultato;
                        }
                        return risultato;
                    }
                    return risultato;
                }
                if (searchForm.getRiconoscimento().equals("soggetto")) {
                    return risultato;
                }
                if (searchForm.getRiconoscimento().equals("identificativoAutenticato")) {
                    if (StringUtils.isNotEmpty((String)risultato)) {
                        MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, log);
                        CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(risultato)));
                        if (credenzialeMittente != null && credenzialeMittente.getTipo() != null) {
                            sbTipoCredenziale.append(credenzialeMittente.getTipo());
                        }
                        return credenzialeMittente != null ? credenzialeMittente.getCredenziale() : risultato;
                    }
                } else if (searchForm.getRiconoscimento().equals("ip")) {
                    if (StringUtils.isNotEmpty((String)risultato)) {
                        MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, log);
                        CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(risultato)));
                        if (credenzialeMittente != null && credenzialeMittente.getTipo() != null) {
                            sbTipoCredenziale.append(credenzialeMittente.getTipo());
                        }
                        String credenziale = credenzialeMittente != null ? credenzialeMittente.getCredenziale() : null;
                        return this.getLabelCredenzialeFieldGroupByIndirizzoIp(credenziale, risultato);
                    }
                } else if (searchForm.getRiconoscimento().equals("tokenInfo")) {
                    TipoCredenzialeMittente tcm = TipoCredenzialeMittente.toEnumConstant((String)searchForm.getTokenClaim(), (boolean)true);
                    CredenzialeMittente credenzialeMittente = null;
                    if (StringUtils.isNotEmpty((String)risultato)) {
                        switch (tcm) {
                            case TOKEN_CLIENT_ID: 
                            case TOKEN_EMAIL: 
                            case TOKEN_ISSUER: 
                            case TOKEN_SUBJECT: 
                            case TOKEN_USERNAME: 
                            case PDND_ORGANIZATION_NAME: {
                                MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, log);
                                credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(risultato)));
                                if (credenzialeMittente != null && credenzialeMittente.getTipo() != null) {
                                    sbTipoCredenziale.append(credenzialeMittente.getTipo());
                                }
                                return credenzialeMittente != null ? credenzialeMittente.getCredenziale() : risultato;
                            }
                        }
                    }
                }
            } else if (!this.distribServizioSearch.isDistribuzionePerImplementazioneApi() && StringUtils.isNotEmpty((String)risultato)) {
                MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, log);
                CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(risultato)));
                return credenzialeMittente != null ? credenzialeMittente.getCredenziale() : risultato;
            }
        }
        catch (NotFoundException e) {
            StatisticheGiornaliereService.logDebug(e.getMessage(), e);
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
        }
        return risultato;
    }

    private String getLabelCredenzialeFieldGroupByIndirizzoIp(String credenziale, String risultato) {
        if (credenziale != null) {
            StringBuilder bf = new StringBuilder();
            if (CredenzialeClientAddress.isSocketAddressDBValue((String)credenziale)) {
                bf.append(CredenzialeClientAddress.convertSocketDBValueToOriginal((String)credenziale));
                if (CredenzialeClientAddress.isTransportAddressDBValue((String)credenziale)) {
                    bf.append(" (X-Forwarded-For: ");
                    bf.append(CredenzialeClientAddress.convertTransportDBValueToOriginal((String)credenziale));
                    bf.append(")");
                }
            } else if (CredenzialeClientAddress.isTransportAddressDBValue((String)credenziale)) {
                bf.append(CredenzialeClientAddress.convertTransportDBValueToOriginal((String)credenziale));
            }
            return bf.length() > 0 ? bf.toString() : risultato;
        }
        return risultato;
    }

    private void addListaCredenzialiMittente(IExpression filter, List<CredenzialeMittente> listaCredenzialiMittente, StatisticaModel model) throws ExpressionNotImplementedException, ExpressionException {
        if (listaCredenzialiMittente.isEmpty()) {
            Calendar c = Calendar.getInstance();
            Date d = new Date();
            c.setTime(d);
            c.set(1, 2100);
            filter.and().equals(model.DATA, (Object)c.getTime());
        } else {
            CredenzialeMittente credenzialeMittente = listaCredenzialiMittente.get(0);
            IField fieldCredenziale = null;
            try {
                fieldCredenziale = this.getCredenzialeField(credenzialeMittente, model);
            }
            catch (ServiceException e) {
                throw new ExpressionException(e.getMessage(), (Throwable)e);
            }
            if (listaCredenzialiMittente.size() == 1) {
                filter.and().equals(fieldCredenziale, (Object)credenzialeMittente.getId().toString());
            } else {
                ArrayList<String> ids = new ArrayList<String>();
                for (CredenzialeMittente cMittente : listaCredenzialiMittente) {
                    ids.add(cMittente.getId().toString());
                }
                filter.and().in(fieldCredenziale, ids);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getHostnames(String gruppo, int refreshSecondsInterval) {
        Connection con = null;
        List<String> lNull = null;
        try {
            con = this.driverConfigurazioneDB.getConnection("StatisticheGiornaliereService.getHostnames");
            List list = DynamicClusterManager.getHostnames((Connection)con, (String)this.driverConfigurazioneDB.getTipoDB(), (String)gruppo, (int)refreshSecondsInterval);
            return list;
        }
        catch (Exception e) {
            StatisticheGiornaliereService.logError(e.getMessage(), e);
            List<String> list = lNull;
            return list;
        }
        finally {
            try {
                this.driverConfigurazioneDB.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<String> getClusterIdDinamici(String gruppo, int refreshSecondsInterval) {
        List<String> l = this.getHostnames(gruppo, refreshSecondsInterval);
        ArrayList<String> list = null;
        if (l != null && !l.isEmpty()) {
            list = new ArrayList<String>();
            for (String id : l) {
                list.add(DynamicClusterManager.hashClusterId((String)id));
            }
        }
        return list;
    }

    @Override
    public boolean isTimeoutEvent() {
        return this.timeoutEvent;
    }

    private boolean isIgnoreSetMittente(BaseSearchForm searchForm) {
        boolean ignoreSetMittente = false;
        if (StringUtils.isNotEmpty((String)searchForm.getRiconoscimento()) && searchForm.getRiconoscimento().equals("applicativo") && StringUtils.isNotBlank((String)searchForm.getIdentificazione()) && StringUtils.isNotBlank((String)searchForm.getServizioApplicativo()) && "commons.identificazione.token.label".equals(searchForm.getIdentificazione())) {
            ignoreSetMittente = true;
        }
        return ignoreSetMittente;
    }

    private void impostaGroupByFiltro3dCustom(IExpression filter, StatisticaModel model, StatsSearchForm form, DimensioneCustom dc) throws ExpressionNotImplementedException, ExpressionException {
        if (dc != null) {
            switch (dc) {
                case TAG: {
                    filter.notEquals(model.GRUPPI, (Object)"-");
                    filter.addGroupBy(model.GRUPPI);
                    break;
                }
                case API: {
                    filter.notEquals(model.URI_API, (Object)"-");
                    filter.addGroupBy(model.URI_API);
                    break;
                }
                case IMPLEMENTAZIONE_API: {
                    this.impostaGroupByFiltro3dCustomImplementazioneApi(filter, model);
                    break;
                }
                case OPERAZIONE: {
                    filter.notEquals(model.AZIONE, (Object)"-");
                    filter.addGroupBy(model.AZIONE);
                    break;
                }
                case SOGGETTO_LOCALE: {
                    this.impostaGroupByFiltro3dCustomSoggettoLocale(filter, model, form);
                    break;
                }
                case SOGGETTO_REMOTO: {
                    this.impostaGroupByFiltro3dCustomSoggettoRemoto(filter, model, form);
                    break;
                }
                case SOGGETTO_FRUITORE: {
                    this.impostaGroupByFiltro3dCustomSoggettoFruitore(filter, model);
                    break;
                }
                case SOGGETTO_EROGATORE: {
                    this.impostaGroupByFiltro3dCustomSoggettoErogatore(filter, model);
                    break;
                }
                case TOKEN_CLIENT_ID: 
                case TOKEN_PDND_ORGANIZATION: 
                case TOKEN_PDND_ORGANIZATION_EXTERNAL_ID: 
                case TOKEN_PDND_ORGANIZATION_CONSUMER_ID: 
                case APPLICATIVO_TOKEN: {
                    filter.notEquals(model.TOKEN_CLIENT_ID, (Object)"-");
                    filter.addGroupBy(model.TOKEN_CLIENT_ID);
                    break;
                }
                case TOKEN_ISSUER: {
                    filter.notEquals(model.TOKEN_ISSUER, (Object)"-");
                    filter.addGroupBy(model.TOKEN_ISSUER);
                    break;
                }
                case TOKEN_SUBJECT: {
                    filter.notEquals(model.TOKEN_SUBJECT, (Object)"-");
                    filter.addGroupBy(model.TOKEN_SUBJECT);
                    break;
                }
                case TOKEN_USERNAME: {
                    filter.notEquals(model.TOKEN_USERNAME, (Object)"-");
                    filter.addGroupBy(model.TOKEN_USERNAME);
                    break;
                }
                case TOKEN_EMAIL: {
                    filter.notEquals(model.TOKEN_MAIL, (Object)"-");
                    filter.addGroupBy(model.TOKEN_MAIL);
                    break;
                }
                case APPLICATIVO_TRASPORTO: {
                    filter.notEquals(model.SERVIZIO_APPLICATIVO, (Object)"-");
                    filter.addGroupBy(model.SERVIZIO_APPLICATIVO);
                    filter.notEquals(model.TIPO_MITTENTE, (Object)"-");
                    filter.addGroupBy(model.TIPO_MITTENTE);
                    filter.notEquals(model.MITTENTE, (Object)"-");
                    filter.addGroupBy(model.MITTENTE);
                    break;
                }
                case INDIRIZZO_IP: {
                    filter.notEquals(model.CLIENT_ADDRESS, (Object)"-");
                    filter.addGroupBy(model.CLIENT_ADDRESS);
                    break;
                }
                case PRINCIPAL: {
                    filter.notEquals(model.TRASPORTO_MITTENTE, (Object)"-");
                    filter.addGroupBy(model.TRASPORTO_MITTENTE);
                    break;
                }
                case ESITO: {
                    filter.notEquals(model.ESITO, (Object)Costanti.INFORMAZIONE_ESITO_NON_DISPONIBILE);
                    filter.addGroupBy(model.ESITO);
                }
            }
        } else {
            throw new ExpressionException(MESSAGE_3D_CUSTOM_INFORMAZIONE_NON_INDICATA);
        }
    }

    private void impostaGroupByFiltro3dCustomImplementazioneApi(IExpression filter, StatisticaModel model) throws ExpressionNotImplementedException, ExpressionException {
        filter.notEquals(model.TIPO_DESTINATARIO, (Object)"-");
        filter.notEquals(model.DESTINATARIO, (Object)"-");
        filter.notEquals(model.TIPO_SERVIZIO, (Object)"-");
        filter.notEquals(model.SERVIZIO, (Object)"-");
        filter.notEquals(model.VERSIONE_SERVIZIO, (Object)Costanti.INFORMAZIONE_VERSIONE_NON_DISPONIBILE);
        filter.addGroupBy(model.TIPO_DESTINATARIO);
        filter.addGroupBy(model.DESTINATARIO);
        filter.addGroupBy(model.TIPO_SERVIZIO);
        filter.addGroupBy(model.SERVIZIO);
        filter.addGroupBy(model.VERSIONE_SERVIZIO);
    }

    private void impostaGroupByFiltro3dCustomSoggettoLocale(IExpression filter, StatisticaModel model, StatsSearchForm form) throws ExpressionNotImplementedException, ExpressionException {
        if (TipologiaRicerca.ingresso.equals((Object)form.getTipologiaRicercaEnum())) {
            filter.notEquals(model.TIPO_DESTINATARIO, (Object)"-");
            filter.notEquals(model.DESTINATARIO, (Object)"-");
            filter.addGroupBy(model.TIPO_DESTINATARIO);
            filter.addGroupBy(model.DESTINATARIO);
        } else if (TipologiaRicerca.uscita.equals((Object)form.getTipologiaRicercaEnum())) {
            filter.notEquals(model.TIPO_MITTENTE, (Object)"-");
            filter.notEquals(model.MITTENTE, (Object)"-");
            filter.addGroupBy(model.TIPO_MITTENTE);
            filter.addGroupBy(model.MITTENTE);
        }
    }

    private void impostaGroupByFiltro3dCustomSoggettoRemoto(IExpression filter, StatisticaModel model, StatsSearchForm form) throws ExpressionNotImplementedException, ExpressionException {
        if (TipologiaRicerca.ingresso.equals((Object)form.getTipologiaRicercaEnum())) {
            filter.notEquals(model.TIPO_MITTENTE, (Object)"-");
            filter.notEquals(model.MITTENTE, (Object)"-");
            filter.addGroupBy(model.TIPO_MITTENTE);
            filter.addGroupBy(model.MITTENTE);
        } else if (TipologiaRicerca.uscita.equals((Object)form.getTipologiaRicercaEnum())) {
            filter.notEquals(model.TIPO_DESTINATARIO, (Object)"-");
            filter.notEquals(model.DESTINATARIO, (Object)"-");
            filter.addGroupBy(model.TIPO_DESTINATARIO);
            filter.addGroupBy(model.DESTINATARIO);
        }
    }

    private void impostaGroupByFiltro3dCustomSoggettoFruitore(IExpression filter, StatisticaModel model) throws ExpressionNotImplementedException, ExpressionException {
        filter.notEquals(model.TIPO_MITTENTE, (Object)"-");
        filter.notEquals(model.MITTENTE, (Object)"-");
        filter.addGroupBy(model.TIPO_MITTENTE);
        filter.addGroupBy(model.MITTENTE);
    }

    private void impostaGroupByFiltro3dCustomSoggettoErogatore(IExpression filter, StatisticaModel model) throws ExpressionNotImplementedException, ExpressionException {
        filter.notEquals(model.TIPO_DESTINATARIO, (Object)"-");
        filter.notEquals(model.DESTINATARIO, (Object)"-");
        filter.addGroupBy(model.TIPO_DESTINATARIO);
        filter.addGroupBy(model.DESTINATARIO);
    }

    private void impostaSortOrder3dCustom(IExpression filter, StatisticaModel model, StatsSearchForm form, DimensioneCustom dc, SortOrder s) throws ExpressionNotImplementedException, ExpressionException {
        if (dc != null) {
            filter.sortOrder(s);
            switch (dc) {
                case TAG: {
                    filter.addOrder(model.GRUPPI);
                    break;
                }
                case API: {
                    filter.addOrder(model.URI_API);
                    break;
                }
                case IMPLEMENTAZIONE_API: {
                    filter.addOrder(model.TIPO_DESTINATARIO);
                    filter.addOrder(model.DESTINATARIO);
                    filter.addOrder(model.TIPO_SERVIZIO);
                    filter.addOrder(model.SERVIZIO);
                    filter.addOrder(model.VERSIONE_SERVIZIO);
                    break;
                }
                case OPERAZIONE: {
                    filter.addOrder(model.AZIONE);
                    break;
                }
                case SOGGETTO_LOCALE: {
                    if (TipologiaRicerca.ingresso.equals((Object)form.getTipologiaRicercaEnum())) {
                        filter.addOrder(model.TIPO_DESTINATARIO);
                        filter.addOrder(model.DESTINATARIO);
                        break;
                    }
                    filter.addOrder(model.TIPO_MITTENTE);
                    filter.addOrder(model.MITTENTE);
                    break;
                }
                case SOGGETTO_REMOTO: {
                    if (TipologiaRicerca.ingresso.equals((Object)form.getTipologiaRicercaEnum())) {
                        filter.addOrder(model.TIPO_MITTENTE);
                        filter.addOrder(model.MITTENTE);
                        break;
                    }
                    filter.addOrder(model.TIPO_DESTINATARIO);
                    filter.addOrder(model.DESTINATARIO);
                    break;
                }
                case SOGGETTO_FRUITORE: {
                    filter.addOrder(model.TIPO_MITTENTE);
                    filter.addOrder(model.MITTENTE);
                    break;
                }
                case SOGGETTO_EROGATORE: {
                    filter.addOrder(model.TIPO_DESTINATARIO);
                    filter.addOrder(model.DESTINATARIO);
                    break;
                }
                case TOKEN_CLIENT_ID: 
                case TOKEN_PDND_ORGANIZATION: 
                case TOKEN_PDND_ORGANIZATION_EXTERNAL_ID: 
                case TOKEN_PDND_ORGANIZATION_CONSUMER_ID: 
                case APPLICATIVO_TOKEN: {
                    filter.addOrder(model.TOKEN_CLIENT_ID);
                    break;
                }
                case TOKEN_ISSUER: {
                    filter.addOrder(model.TOKEN_ISSUER);
                    break;
                }
                case TOKEN_SUBJECT: {
                    filter.addOrder(model.TOKEN_SUBJECT);
                    break;
                }
                case TOKEN_USERNAME: {
                    filter.addOrder(model.TOKEN_USERNAME);
                    break;
                }
                case TOKEN_EMAIL: {
                    filter.addOrder(model.TOKEN_MAIL);
                    break;
                }
                case APPLICATIVO_TRASPORTO: {
                    filter.addOrder(model.SERVIZIO_APPLICATIVO);
                    filter.addOrder(model.TIPO_MITTENTE);
                    filter.addOrder(model.MITTENTE);
                    break;
                }
                case INDIRIZZO_IP: {
                    filter.addOrder(model.CLIENT_ADDRESS);
                    break;
                }
                case PRINCIPAL: {
                    filter.addOrder(model.TRASPORTO_MITTENTE);
                    break;
                }
                case ESITO: {
                    filter.addOrder(model.ESITO);
                }
            }
        } else {
            throw new ExpressionException(MESSAGE_3D_CUSTOM_INFORMAZIONE_NON_INDICATA);
        }
    }

    private void impostaSelectField3dCustom(UnionExpression expr, StatisticaModel model, StatsSearchForm form, DimensioneCustom dc, List<String> aliases) throws ExpressionException {
        if (dc != null) {
            switch (dc) {
                case TAG: {
                    String a = "c3d_tag";
                    expr.addSelectField(model.GRUPPI, a);
                    this.addAlias(aliases, a);
                    break;
                }
                case API: {
                    String a = "c3d_api";
                    expr.addSelectField(model.URI_API, a);
                    this.addAlias(aliases, a);
                    break;
                }
                case IMPLEMENTAZIONE_API: {
                    this.impostaSelectField3dCustomApiImplementation(expr, model, aliases);
                    break;
                }
                case OPERAZIONE: {
                    String a = "c3d_op";
                    expr.addSelectField(model.AZIONE, a);
                    this.addAlias(aliases, a);
                    break;
                }
                case SOGGETTO_LOCALE: {
                    this.impostaSelectField3dCustomSoggettoLocale(expr, model, form, aliases);
                    break;
                }
                case SOGGETTO_REMOTO: {
                    this.impostaSelectField3dCustomSoggettoRemoto(expr, model, form, aliases);
                    break;
                }
                case SOGGETTO_FRUITORE: {
                    this.impostaSelectField3dCustomSoggettoFruitore(expr, model, aliases);
                    break;
                }
                case SOGGETTO_EROGATORE: {
                    this.impostaSelectField3dCustomSoggettoErogatore(expr, model, aliases);
                    break;
                }
                case TOKEN_CLIENT_ID: 
                case TOKEN_PDND_ORGANIZATION: 
                case TOKEN_PDND_ORGANIZATION_EXTERNAL_ID: 
                case TOKEN_PDND_ORGANIZATION_CONSUMER_ID: 
                case APPLICATIVO_TOKEN: {
                    String a = "c3d_tc";
                    expr.addSelectField(model.TOKEN_CLIENT_ID, a);
                    this.addAlias(aliases, a);
                    break;
                }
                case TOKEN_ISSUER: {
                    String a = "c3d_ti";
                    expr.addSelectField(model.TOKEN_ISSUER, a);
                    this.addAlias(aliases, a);
                    break;
                }
                case TOKEN_SUBJECT: {
                    String a = "c3d_ts";
                    expr.addSelectField(model.TOKEN_SUBJECT, a);
                    this.addAlias(aliases, a);
                    break;
                }
                case TOKEN_USERNAME: {
                    String a = "c3d_tu";
                    expr.addSelectField(model.TOKEN_USERNAME, a);
                    this.addAlias(aliases, a);
                    break;
                }
                case TOKEN_EMAIL: {
                    String a = "c3d_te";
                    expr.addSelectField(model.TOKEN_MAIL, a);
                    this.addAlias(aliases, a);
                    break;
                }
                case APPLICATIVO_TRASPORTO: {
                    this.impostaSelectField3dCustomServizioApplicativoTrasporto(expr, model, aliases);
                    break;
                }
                case PRINCIPAL: {
                    String a = "c3d_p";
                    expr.addSelectField(model.TRASPORTO_MITTENTE, a);
                    this.addAlias(aliases, a);
                    break;
                }
                case INDIRIZZO_IP: {
                    String a = "c3d_ip";
                    expr.addSelectField(model.CLIENT_ADDRESS, a);
                    this.addAlias(aliases, a);
                    break;
                }
                case ESITO: {
                    String a = "c3d_e";
                    expr.addSelectField(model.ESITO, a);
                    this.addAlias(aliases, a);
                    break;
                }
            }
        } else {
            throw new ExpressionException(MESSAGE_3D_CUSTOM_INFORMAZIONE_NON_INDICATA);
        }
    }

    private void impostaSelectField3dCustomApiImplementation(UnionExpression expr, StatisticaModel model, List<String> aliases) throws ExpressionException {
        String aTD = "c3d_td";
        expr.addSelectField(model.TIPO_DESTINATARIO, aTD);
        this.addAlias(aliases, aTD);
        String aD = "c3d_d";
        expr.addSelectField(model.DESTINATARIO, aD);
        this.addAlias(aliases, aD);
        String aTS = "c3d_ts";
        expr.addSelectField(model.TIPO_SERVIZIO, aTS);
        this.addAlias(aliases, aTS);
        String aS = "c3d_s";
        expr.addSelectField(model.SERVIZIO, aS);
        this.addAlias(aliases, aS);
        String aVS = "c3d_vs";
        expr.addSelectField(model.VERSIONE_SERVIZIO, aVS);
        this.addAlias(aliases, aVS);
    }

    private void impostaSelectField3dCustomSoggettoLocale(UnionExpression expr, StatisticaModel model, StatsSearchForm form, List<String> aliases) throws ExpressionException {
        String aT = "c3d_tipo";
        String aN = "c3d_nome";
        if (TipologiaRicerca.ingresso.equals((Object)form.getTipologiaRicercaEnum())) {
            expr.addSelectField(model.TIPO_DESTINATARIO, aT);
            expr.addSelectField(model.DESTINATARIO, aN);
        } else {
            expr.addSelectField(model.TIPO_MITTENTE, aT);
            expr.addSelectField(model.MITTENTE, aN);
        }
        this.addAlias(aliases, aT);
        this.addAlias(aliases, aN);
    }

    private void impostaSelectField3dCustomSoggettoRemoto(UnionExpression expr, StatisticaModel model, StatsSearchForm form, List<String> aliases) throws ExpressionException {
        String aT = "c3d_tipo";
        String aN = "c3d_nome";
        if (TipologiaRicerca.ingresso.equals((Object)form.getTipologiaRicercaEnum())) {
            expr.addSelectField(model.TIPO_MITTENTE, aT);
            expr.addSelectField(model.MITTENTE, aN);
        } else {
            expr.addSelectField(model.TIPO_DESTINATARIO, aT);
            expr.addSelectField(model.DESTINATARIO, aN);
        }
        this.addAlias(aliases, aT);
        this.addAlias(aliases, aN);
    }

    private void impostaSelectField3dCustomSoggettoFruitore(UnionExpression expr, StatisticaModel model, List<String> aliases) throws ExpressionException {
        String aT = "c3d_tipo";
        String aN = "c3d_nome";
        expr.addSelectField(model.TIPO_MITTENTE, aT);
        expr.addSelectField(model.MITTENTE, aN);
        this.addAlias(aliases, aT);
        this.addAlias(aliases, aN);
    }

    private void impostaSelectField3dCustomSoggettoErogatore(UnionExpression expr, StatisticaModel model, List<String> aliases) throws ExpressionException {
        String aT = "c3d_tipo";
        String aN = "c3d_nome";
        expr.addSelectField(model.TIPO_DESTINATARIO, aT);
        expr.addSelectField(model.DESTINATARIO, aN);
        this.addAlias(aliases, aT);
        this.addAlias(aliases, aN);
    }

    private void impostaSelectField3dCustomServizioApplicativoTrasporto(UnionExpression expr, StatisticaModel model, List<String> aliases) throws ExpressionException {
        String aSA = "c3d_sa";
        String aT = "c3d_tipo";
        String aN = "c3d_nome";
        expr.addSelectField(model.SERVIZIO_APPLICATIVO, aSA);
        expr.addSelectField(model.TIPO_MITTENTE, aT);
        expr.addSelectField(model.MITTENTE, aN);
        this.addAlias(aliases, aSA);
        this.addAlias(aliases, aT);
        this.addAlias(aliases, aN);
    }

    private void impostaSelectField3dCustomFake(UnionExpression expr, StatisticaModel model, StatsSearchForm form, DimensioneCustom dc, List<String> aliases) throws ExpressionException {
        if (dc != null) {
            switch (dc) {
                case TAG: {
                    String a = "c3d_tag";
                    expr.addSelectField((IField)new ConstantField(a, (Object)FALSA_UNION_DEFAULT_VALUE, model.GRUPPI.getFieldType()), a);
                    this.addAlias(aliases, a);
                    break;
                }
                case API: {
                    String a = "c3d_api";
                    expr.addSelectField((IField)new ConstantField(a, (Object)FALSA_UNION_DEFAULT_VALUE, model.URI_API.getFieldType()), a);
                    this.addAlias(aliases, a);
                    break;
                }
                case IMPLEMENTAZIONE_API: {
                    this.impostaSelectField3dCustomFakeApiImplementation(expr, model, aliases);
                    break;
                }
                case OPERAZIONE: {
                    String a = "c3d_op";
                    expr.addSelectField((IField)new ConstantField(a, (Object)FALSA_UNION_DEFAULT_VALUE, model.AZIONE.getFieldType()), a);
                    this.addAlias(aliases, a);
                    break;
                }
                case SOGGETTO_LOCALE: {
                    this.impostaSelectField3dCustomFakeSoggettoLocale(expr, model, form, aliases);
                    break;
                }
                case SOGGETTO_REMOTO: {
                    this.impostaSelectField3dCustomFakeSoggettoRemoto(expr, model, form, aliases);
                    break;
                }
                case SOGGETTO_FRUITORE: {
                    this.impostaSelectField3dCustomFakeSoggettoFruitore(expr, model, aliases);
                    break;
                }
                case SOGGETTO_EROGATORE: {
                    this.impostaSelectField3dCustomFakeSoggettoErogatore(expr, model, aliases);
                    break;
                }
                case TOKEN_CLIENT_ID: 
                case TOKEN_PDND_ORGANIZATION: 
                case TOKEN_PDND_ORGANIZATION_EXTERNAL_ID: 
                case TOKEN_PDND_ORGANIZATION_CONSUMER_ID: 
                case APPLICATIVO_TOKEN: {
                    String a = "c3d_tc";
                    expr.addSelectField((IField)new ConstantField(a, (Object)FALSA_UNION_DEFAULT_VALUE, model.TOKEN_CLIENT_ID.getFieldType()), a);
                    this.addAlias(aliases, a);
                    break;
                }
                case TOKEN_ISSUER: {
                    String a = "c3d_ti";
                    expr.addSelectField((IField)new ConstantField(a, (Object)FALSA_UNION_DEFAULT_VALUE, model.TOKEN_ISSUER.getFieldType()), a);
                    this.addAlias(aliases, a);
                    break;
                }
                case TOKEN_SUBJECT: {
                    String a = "c3d_ts";
                    expr.addSelectField((IField)new ConstantField(a, (Object)FALSA_UNION_DEFAULT_VALUE, model.TOKEN_SUBJECT.getFieldType()), a);
                    this.addAlias(aliases, a);
                    break;
                }
                case TOKEN_USERNAME: {
                    String a = "c3d_tu";
                    expr.addSelectField((IField)new ConstantField(a, (Object)FALSA_UNION_DEFAULT_VALUE, model.TOKEN_USERNAME.getFieldType()), a);
                    this.addAlias(aliases, a);
                    break;
                }
                case TOKEN_EMAIL: {
                    String a = "c3d_te";
                    expr.addSelectField((IField)new ConstantField(a, (Object)FALSA_UNION_DEFAULT_VALUE, model.TOKEN_MAIL.getFieldType()), a);
                    this.addAlias(aliases, a);
                    break;
                }
                case APPLICATIVO_TRASPORTO: {
                    this.impostaSelectField3dCustomFakeServizioApplicativoTrasporto(expr, model, aliases);
                    break;
                }
                case PRINCIPAL: {
                    String a = "c3d_p";
                    expr.addSelectField((IField)new ConstantField(a, (Object)FALSA_UNION_DEFAULT_VALUE, model.TRASPORTO_MITTENTE.getFieldType()), a);
                    this.addAlias(aliases, a);
                    break;
                }
                case INDIRIZZO_IP: {
                    String a = "c3d_ip";
                    expr.addSelectField((IField)new ConstantField(a, (Object)FALSA_UNION_DEFAULT_VALUE, model.CLIENT_ADDRESS.getFieldType()), a);
                    this.addAlias(aliases, a);
                    break;
                }
                case ESITO: {
                    String a = "c3d_e";
                    expr.addSelectField((IField)new ConstantField(a, (Object)FALSA_UNION_DEFAULT_VALUE_INT, model.ESITO.getFieldType()), a);
                    this.addAlias(aliases, a);
                    break;
                }
            }
        } else {
            throw new ExpressionException(MESSAGE_3D_CUSTOM_INFORMAZIONE_NON_INDICATA);
        }
    }

    private void impostaSelectField3dCustomFakeApiImplementation(UnionExpression expr, StatisticaModel model, List<String> aliases) throws ExpressionException {
        String aTD = "c3d_td";
        expr.addSelectField((IField)new ConstantField(aTD, (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_DESTINATARIO.getFieldType()), aTD);
        this.addAlias(aliases, aTD);
        String aD = "c3d_d";
        expr.addSelectField((IField)new ConstantField(aD, (Object)FALSA_UNION_DEFAULT_VALUE, model.DESTINATARIO.getFieldType()), aD);
        this.addAlias(aliases, aD);
        String aTS = "c3d_ts";
        expr.addSelectField((IField)new ConstantField(aTS, (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_SERVIZIO.getFieldType()), aTS);
        this.addAlias(aliases, aTS);
        String aS = "c3d_s";
        expr.addSelectField((IField)new ConstantField(aS, (Object)FALSA_UNION_DEFAULT_VALUE, model.SERVIZIO.getFieldType()), aS);
        this.addAlias(aliases, aS);
        String aVS = "c3d_vs";
        expr.addSelectField((IField)new ConstantField(aVS, (Object)FALSA_UNION_DEFAULT_VALUE_VERSIONE, model.VERSIONE_SERVIZIO.getFieldType()), aVS);
        this.addAlias(aliases, aVS);
    }

    private void impostaSelectField3dCustomFakeSoggettoLocale(UnionExpression expr, StatisticaModel model, StatsSearchForm form, List<String> aliases) throws ExpressionException {
        String aT = "c3d_tipo";
        String aN = "c3d_nome";
        if (TipologiaRicerca.ingresso.equals((Object)form.getTipologiaRicercaEnum())) {
            expr.addSelectField((IField)new ConstantField(aT, (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_DESTINATARIO.getFieldType()), aT);
            expr.addSelectField((IField)new ConstantField(aN, (Object)FALSA_UNION_DEFAULT_VALUE, model.DESTINATARIO.getFieldType()), aN);
        } else {
            expr.addSelectField((IField)new ConstantField(aT, (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_MITTENTE.getFieldType()), aT);
            expr.addSelectField((IField)new ConstantField(aN, (Object)FALSA_UNION_DEFAULT_VALUE, model.MITTENTE.getFieldType()), aN);
        }
        this.addAlias(aliases, aT);
        this.addAlias(aliases, aN);
    }

    private void impostaSelectField3dCustomFakeSoggettoRemoto(UnionExpression expr, StatisticaModel model, StatsSearchForm form, List<String> aliases) throws ExpressionException {
        String aT = "c3d_tipo";
        String aN = "c3d_nome";
        if (TipologiaRicerca.ingresso.equals((Object)form.getTipologiaRicercaEnum())) {
            expr.addSelectField((IField)new ConstantField(aT, (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_MITTENTE.getFieldType()), aT);
            expr.addSelectField((IField)new ConstantField(aN, (Object)FALSA_UNION_DEFAULT_VALUE, model.MITTENTE.getFieldType()), aN);
        } else {
            expr.addSelectField((IField)new ConstantField(aT, (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_DESTINATARIO.getFieldType()), aT);
            expr.addSelectField((IField)new ConstantField(aN, (Object)FALSA_UNION_DEFAULT_VALUE, model.DESTINATARIO.getFieldType()), aN);
        }
        this.addAlias(aliases, aT);
        this.addAlias(aliases, aN);
    }

    private void impostaSelectField3dCustomFakeSoggettoFruitore(UnionExpression expr, StatisticaModel model, List<String> aliases) throws ExpressionException {
        String aT = "c3d_tipo";
        String aN = "c3d_nome";
        expr.addSelectField((IField)new ConstantField(aT, (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_MITTENTE.getFieldType()), aT);
        expr.addSelectField((IField)new ConstantField(aN, (Object)FALSA_UNION_DEFAULT_VALUE, model.MITTENTE.getFieldType()), aN);
        this.addAlias(aliases, aT);
        this.addAlias(aliases, aN);
    }

    private void impostaSelectField3dCustomFakeSoggettoErogatore(UnionExpression expr, StatisticaModel model, List<String> aliases) throws ExpressionException {
        String aT = "c3d_tipo";
        String aN = "c3d_nome";
        expr.addSelectField((IField)new ConstantField(aT, (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_DESTINATARIO.getFieldType()), aT);
        expr.addSelectField((IField)new ConstantField(aN, (Object)FALSA_UNION_DEFAULT_VALUE, model.DESTINATARIO.getFieldType()), aN);
        this.addAlias(aliases, aT);
        this.addAlias(aliases, aN);
    }

    private void impostaSelectField3dCustomFakeServizioApplicativoTrasporto(UnionExpression expr, StatisticaModel model, List<String> aliases) throws ExpressionException {
        String aSA = "c3d_sa";
        String aT = "c3d_tipo";
        String aN = "c3d_nome";
        expr.addSelectField((IField)new ConstantField(aSA, (Object)FALSA_UNION_DEFAULT_VALUE, model.SERVIZIO_APPLICATIVO.getFieldType()), aSA);
        expr.addSelectField((IField)new ConstantField(aT, (Object)FALSA_UNION_DEFAULT_VALUE, model.TIPO_MITTENTE.getFieldType()), aT);
        expr.addSelectField((IField)new ConstantField(aN, (Object)FALSA_UNION_DEFAULT_VALUE, model.MITTENTE.getFieldType()), aN);
        this.addAlias(aliases, aSA);
        this.addAlias(aliases, aT);
        this.addAlias(aliases, aN);
    }

    private void addAlias(List<String> aliases, String a) {
        if (!aliases.contains(a)) {
            aliases.add(a);
        }
    }

    private String getCustomData(Map<String, Object> row, DimensioneCustom dc, StatsSearchForm form, StringBuilder res, BooleanNullable bSkip) throws NumberFormatException, ServiceException, MultipleResultException, NotFoundException, NotImplementedException, DriverRegistroServiziException, ProtocolException, ExpressionException, CoreException {
        if (dc != null) {
            switch (dc) {
                case TAG: {
                    return this.getCustomDataCredenzialeNormalize(row, res, "tag");
                }
                case API: {
                    return this.getCustomDataApi(row, form, res);
                }
                case IMPLEMENTAZIONE_API: {
                    return this.getCustomDataApiImplementation(row, res);
                }
                case OPERAZIONE: {
                    return this.getCustomData(row, res, "op");
                }
                case SOGGETTO_LOCALE: 
                case SOGGETTO_REMOTO: 
                case SOGGETTO_FRUITORE: 
                case SOGGETTO_EROGATORE: {
                    return this.getCustomDataSoggetto(row, res);
                }
                case TOKEN_CLIENT_ID: {
                    return this.getCustomDataCredenzialeTokenClient(row, res, "tc", false, bSkip);
                }
                case APPLICATIVO_TOKEN: {
                    return this.getCustomDataCredenzialeTokenClient(row, res, "tc", true, bSkip);
                }
                case TOKEN_PDND_ORGANIZATION: {
                    return this.getCustomDataCredenzialeTokenPDNDOrganization(row, res, "tc", bSkip);
                }
                case TOKEN_PDND_ORGANIZATION_EXTERNAL_ID: {
                    return this.getCustomDataCredenzialeTokenPDNDOrganizationExternalId(row, res, "tc", bSkip);
                }
                case TOKEN_PDND_ORGANIZATION_CONSUMER_ID: {
                    return this.getCustomDataCredenzialeTokenPDNDOrganizationConsumerId(row, res, "tc", bSkip);
                }
                case TOKEN_ISSUER: {
                    return this.getCustomDataCredenziale(row, res, "ti");
                }
                case TOKEN_SUBJECT: {
                    return this.getCustomDataCredenziale(row, res, "ts");
                }
                case TOKEN_USERNAME: {
                    return this.getCustomDataCredenziale(row, res, "tu");
                }
                case TOKEN_EMAIL: {
                    return this.getCustomDataCredenziale(row, res, "te");
                }
                case APPLICATIVO_TRASPORTO: {
                    return this.getCustomDataApplicativoTrasporto(row, res);
                }
                case PRINCIPAL: {
                    return this.getCustomDataCredenzialePrincipal(row, res, "p");
                }
                case INDIRIZZO_IP: {
                    return this.getCustomDataCredenzialeIndirizzoIp(row, res, "ip");
                }
                case ESITO: {
                    return this.getCustomDataEsito(row, res, form, "e");
                }
            }
        } else {
            throw new ExpressionException(MESSAGE_3D_CUSTOM_INFORMAZIONE_NON_INDICATA);
        }
        return null;
    }

    private String getCustomData(Map<String, Object> row, StringBuilder res, String alias) throws NumberFormatException {
        Object oRisultato = row.get(ALIAS_FIELD_DATA_3D_CUSTOM + alias);
        res.append(oRisultato);
        if (oRisultato instanceof String) {
            return (String)oRisultato;
        }
        return null;
    }

    private String getCustomDataCredenziale(Map<String, Object> row, StringBuilder res, String alias) throws NumberFormatException, ServiceException, MultipleResultException, NotFoundException, NotImplementedException {
        Object oRisultato = row.get(ALIAS_FIELD_DATA_3D_CUSTOM + alias);
        res.append(oRisultato);
        String v = this.getCustomDataCredenzialeMittente(oRisultato);
        if (v != null && StringUtils.isNotEmpty((String)v)) {
            return v;
        }
        if (oRisultato instanceof String) {
            return (String)oRisultato;
        }
        return null;
    }

    private String getCustomDataCredenzialeNormalize(Map<String, Object> row, StringBuilder res, String alias) throws NumberFormatException, ServiceException, MultipleResultException, NotFoundException, NotImplementedException {
        String s;
        Object oRisultato = row.get(ALIAS_FIELD_DATA_3D_CUSTOM + alias);
        res.append(oRisultato);
        String tagValue = this.getCustomDataCredenzialeMittente(oRisultato);
        if (tagValue != null && StringUtils.isNotEmpty((String)tagValue) && (s = AbstractCredenzialeList.normalize((String)tagValue)) != null) {
            return s;
        }
        if (oRisultato instanceof String) {
            return (String)oRisultato;
        }
        return null;
    }

    private String getCustomDataCredenzialeTokenClient(Map<String, Object> row, StringBuilder res, String alias, boolean applicativo, BooleanNullable bSkip) throws CoreException, NumberFormatException, ServiceException, MultipleResultException, NotFoundException, NotImplementedException, ProtocolException {
        Object oRisultato = row.get(ALIAS_FIELD_DATA_3D_CUSTOM + alias);
        res.append(oRisultato);
        String rValue = this.getCustomDataCredenzialeMittente(oRisultato);
        if (rValue != null && StringUtils.isNotEmpty((String)rValue)) {
            if (applicativo) {
                IDServizioApplicativo idApplicativo = CredenzialeTokenClient.convertApplicationDBValueToOriginal((String)rValue);
                if (idApplicativo != null) {
                    return NamingUtils.getLabelServizioApplicativo((IDServizioApplicativo)idApplicativo);
                }
                bSkip.setValue(Boolean.valueOf(true));
            } else {
                return CredenzialeTokenClient.convertClientIdDBValueToOriginal((String)rValue);
            }
        }
        if (applicativo) {
            bSkip.setValue(Boolean.valueOf(true));
        }
        if (oRisultato instanceof String) {
            return (String)oRisultato;
        }
        return null;
    }

    private String getCustomDataCredenzialeTokenPDNDOrganization(Map<String, Object> row, StringBuilder res, String alias, BooleanNullable bSkip) throws NumberFormatException, ServiceException, NotFoundException, NotImplementedException {
        Object oRisultato = row.get(ALIAS_FIELD_DATA_3D_CUSTOM + alias);
        res.append(oRisultato);
        if (oRisultato instanceof String) {
            String risultato = (String)oRisultato;
            String organizzazione = null;
            try {
                MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, log);
                CredenzialeMittente credenzialeMittentePDNDOrganization = mBeanUtilsService.getCredenzialeMittenteByReferenceFromCache(TipoCredenzialeMittente.PDND_ORGANIZATION_NAME, Long.valueOf(Long.parseLong(risultato)));
                if (credenzialeMittentePDNDOrganization != null) {
                    organizzazione = credenzialeMittentePDNDOrganization.getCredenziale();
                }
            }
            catch (Exception tApp) {
                StatisticheGiornaliereService.logError(tApp.getMessage(), tApp);
            }
            if (organizzazione == null) {
                bSkip.setValue(Boolean.valueOf(true));
            } else {
                return organizzazione;
            }
        }
        bSkip.setValue(Boolean.valueOf(true));
        return null;
    }

    private String getCustomDataCredenzialeTokenPDNDOrganizationExternalId(Map<String, Object> row, StringBuilder res, String alias, BooleanNullable bSkip) throws NumberFormatException, ServiceException, NotFoundException, NotImplementedException {
        Object oRisultato = row.get(ALIAS_FIELD_DATA_3D_CUSTOM + alias);
        res.append(oRisultato);
        if (oRisultato instanceof String) {
            String risultato = (String)oRisultato;
            String pdndOrganizationExternalId = null;
            try {
                String json = this.getCustomDataCredenzialeTokenPDNDOrganizationJson(row, res, alias, bSkip, risultato);
                if (json != null) {
                    pdndOrganizationExternalId = this.getCustomDataCredenzialeTokenPDNDOrganizationExternalId(json);
                }
            }
            catch (Exception tApp) {
                StatisticheGiornaliereService.logError(tApp.getMessage(), tApp);
            }
            if (pdndOrganizationExternalId == null) {
                bSkip.setValue(Boolean.valueOf(true));
            } else {
                return pdndOrganizationExternalId;
            }
        }
        bSkip.setValue(Boolean.valueOf(true));
        return null;
    }

    private String getCustomDataCredenzialeTokenPDNDOrganizationExternalId(String json) throws ProtocolException {
        Object pdndOrganizationExternalId = null;
        String origin = PDNDTokenInfo.readOrganizationExternalOriginFromJson((Logger)log, (String)json);
        String id = PDNDTokenInfo.readOrganizationExternalIdFromJson((Logger)log, (String)json);
        if (origin != null && StringUtils.isNotEmpty((String)origin) && id != null && StringUtils.isNotEmpty((String)id)) {
            pdndOrganizationExternalId = origin + " " + id;
        } else if (origin != null && StringUtils.isNotEmpty((String)origin)) {
            pdndOrganizationExternalId = origin;
        } else if (id != null && StringUtils.isNotEmpty((String)id)) {
            pdndOrganizationExternalId = id;
        }
        return pdndOrganizationExternalId;
    }

    private String getCustomDataCredenzialeTokenPDNDOrganizationConsumerId(Map<String, Object> row, StringBuilder res, String alias, BooleanNullable bSkip) throws NumberFormatException, ServiceException, NotFoundException, NotImplementedException {
        Object oRisultato = row.get(ALIAS_FIELD_DATA_3D_CUSTOM + alias);
        res.append(oRisultato);
        if (oRisultato instanceof String) {
            String risultato = (String)oRisultato;
            String pdndConsumerId = null;
            try {
                String id;
                String json = this.getCustomDataCredenzialeTokenPDNDOrganizationJson(row, res, alias, bSkip, risultato);
                if (json != null && (id = PDNDTokenInfo.readOrganizationIdFromJson((Logger)log, (String)json)) != null && StringUtils.isNotEmpty((String)id)) {
                    pdndConsumerId = id;
                }
            }
            catch (Exception tApp) {
                StatisticheGiornaliereService.logError(tApp.getMessage(), tApp);
            }
            if (pdndConsumerId == null) {
                bSkip.setValue(Boolean.valueOf(true));
            } else {
                return pdndConsumerId;
            }
        }
        bSkip.setValue(Boolean.valueOf(true));
        return null;
    }

    private String getCustomDataCredenzialeTokenPDNDOrganizationJson(Map<String, Object> row, StringBuilder res, String alias, BooleanNullable bSkip, String risultato) throws NumberFormatException, ServiceException, NotFoundException, NotImplementedException {
        try {
            MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, log);
            CredenzialeMittente credenzialeMittentePDNDOrganization = mBeanUtilsService.getCredenzialeMittenteByReferenceFromCache(TipoCredenzialeMittente.PDND_ORGANIZATION_JSON, Long.valueOf(Long.parseLong(risultato)));
            if (credenzialeMittentePDNDOrganization != null) {
                return credenzialeMittentePDNDOrganization.getCredenziale();
            }
        }
        catch (Exception tApp) {
            StatisticheGiornaliereService.logError(tApp.getMessage(), tApp);
        }
        return null;
    }

    private String getCustomDataApplicativoTrasporto(Map<String, Object> row, StringBuilder res) throws ProtocolException {
        IDServizioApplicativo idSA = new IDServizioApplicativo();
        idSA.setNome((String)row.get("c3d_sa"));
        idSA.setIdSoggettoProprietario(new IDSoggetto((String)row.get("c3d_tipo"), (String)row.get("c3d_nome")));
        res.append(idSA.toFormatString());
        return NamingUtils.getLabelServizioApplicativo((IDServizioApplicativo)idSA);
    }

    private String getCustomDataCredenzialePrincipal(Map<String, Object> row, StringBuilder res, String alias) throws NumberFormatException, ServiceException, MultipleResultException, NotFoundException, NotImplementedException {
        Object oRisultato = row.get(ALIAS_FIELD_DATA_3D_CUSTOM + alias);
        res.append(oRisultato);
        if (oRisultato instanceof String) {
            MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, log);
            String risultato = (String)oRisultato;
            CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(risultato)));
            if (credenzialeMittente != null) {
                String tipoCredenziale = this.convertToTipoCredenziale(credenzialeMittente.getTipo());
                return "[" + tipoCredenziale + "] " + credenzialeMittente.getCredenziale();
            }
            return risultato;
        }
        return null;
    }

    private String getCustomDataCredenzialeIndirizzoIp(Map<String, Object> row, StringBuilder res, String alias) throws NumberFormatException, ServiceException, MultipleResultException, NotFoundException, NotImplementedException {
        Object oRisultato = row.get(ALIAS_FIELD_DATA_3D_CUSTOM + alias);
        res.append(oRisultato);
        String v = this.getCustomDataCredenzialeMittente(oRisultato);
        if (oRisultato instanceof String && v != null && StringUtils.isNotEmpty((String)v)) {
            return this.getLabelCredenzialeFieldGroupByIndirizzoIp(v, (String)oRisultato);
        }
        if (oRisultato instanceof String) {
            return (String)oRisultato;
        }
        return null;
    }

    private String getCustomDataApi(Map<String, Object> row, StatsSearchForm form, StringBuilder res) throws ProtocolException, NumberFormatException, ServiceException, MultipleResultException, NotFoundException, NotImplementedException {
        IDAccordo idAccordo;
        Object oRisultato = row.get("c3d_api");
        res.append(oRisultato);
        String s = this.getCustomDataCredenzialeMittente(oRisultato);
        if (s != null && StringUtils.isNotEmpty((String)s) && (idAccordo = this.getIDAccordoFromUriSafe(s)) != null) {
            return NamingUtils.getLabelAccordoServizioParteComune((String)form.getProtocollo(), (IDAccordo)idAccordo);
        }
        return s;
    }

    private String getCustomDataApiImplementation(Map<String, Object> row, StringBuilder res) throws ProtocolException, DriverRegistroServiziException {
        IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues((String)row.get("c3d_ts"), (String)row.get("c3d_s"), (String)row.get("c3d_td"), (String)row.get("c3d_d"), ((Integer)row.get("c3d_vs")).intValue());
        res.append(idServizio.toString());
        return NamingUtils.getLabelAccordoServizioParteSpecifica((IDServizio)idServizio);
    }

    private String getCustomDataSoggetto(Map<String, Object> row, StringBuilder res) throws ProtocolException {
        IDSoggetto idSoggetto = new IDSoggetto((String)row.get("c3d_tipo"), (String)row.get("c3d_nome"));
        res.append(idSoggetto.toString());
        return NamingUtils.getLabelSoggetto((IDSoggetto)idSoggetto);
    }

    private String getCustomDataCredenzialeMittente(Object oRisultato) throws NumberFormatException, ServiceException, MultipleResultException, NotFoundException, NotImplementedException {
        if (oRisultato instanceof String) {
            MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, log);
            String risultato = (String)oRisultato;
            CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(risultato)));
            return credenzialeMittente != null ? credenzialeMittente.getCredenziale() : risultato;
        }
        return null;
    }

    private IDAccordo getIDAccordoFromUriSafe(String s) {
        if (s != null) {
            try {
                return IDAccordoFactory.getInstance().getIDAccordoFromUri(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String getCustomDataEsito(Map<String, Object> row, StringBuilder res, StatsSearchForm form, String alias) throws NumberFormatException, ServiceException, ProtocolException {
        EsitiProperties esitiProperties = null;
        try {
            esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)form.getProtocollo());
        }
        catch (Exception t) {
            StatisticheGiornaliereService.logError("EsitiProperties reader non disponibile: " + t.getMessage(), t);
        }
        if (esitiProperties == null) {
            throw new ServiceException("EsitiProperties unavailable");
        }
        Object oRisultato = row.get(ALIAS_FIELD_DATA_3D_CUSTOM + alias);
        res.append(oRisultato);
        if (oRisultato instanceof String) {
            int esito = Integer.parseInt((String)oRisultato);
            return esitiProperties.getEsitoLabel(Integer.valueOf(esito));
        }
        if (oRisultato instanceof Integer) {
            int esito = (Integer)oRisultato;
            return esitiProperties.getEsitoLabel(Integer.valueOf(esito));
        }
        if (oRisultato instanceof Long) {
            int esito = ((Long)oRisultato).intValue();
            return esitiProperties.getEsitoLabel(Integer.valueOf(esito));
        }
        return null;
    }

    static {
        try {
            FALSA_UNION_DEFAULT_VALUE_TIMESTAMP = DateUtils.getSimpleDateFormatDay().parse("1970-01-01");
        }
        catch (ParseException e) {
            log.error("Errore durante la init della data fake ", (Throwable)e);
        }
    }
}

