/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.datamodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.web.monitor.core.datamodel.BaseDataModel;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.statistiche.bean.NumeroDimensioni;
import org.openspcoop2.web.monitor.statistiche.bean.StatsSearchForm;
import org.openspcoop2.web.monitor.statistiche.dao.IStatisticheGiornaliere;
import org.openspcoop2.web.monitor.statistiche.dao.StatisticheGiornaliereService;
import org.openspcoop2.web.monitor.statistiche.mbean.DistribuzionePerSABean;
import org.slf4j.Logger;

public class DistribuzioneSADM
extends BaseDataModel<String, ResDistribuzione, IStatisticheGiornaliere> {
    private static final long serialVersionUID = 500153520162806619L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private transient StatsSearchForm search;
    private boolean visualizzaComandiExport = false;

    public void setSearch(StatsSearchForm search) {
        this.search = search;
    }

    public int getRowCount() {
        try {
            this.visualizzaComandiExport = false;
            int count = ((IStatisticheGiornaliere)this.getDataProvider()).countAllDistribuzioneServizioApplicativo();
            if (count > 0) {
                this.visualizzaComandiExport = true;
            }
            return count;
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) throws IOException {
        block12: {
            try {
                if (this.detached) {
                    for (String key : this.wrappedKeys) {
                        this.setRowKey(key);
                        visitor.process(context, (Object)key, argument);
                    }
                    break block12;
                }
                int start = ((SequenceRange)range).getFirstRow();
                int limit = ((SequenceRange)range).getRows();
                StatisticheGiornaliereService sgs = null;
                if (this.getDataProvider() instanceof StatisticheGiornaliereService) {
                    sgs = (StatisticheGiornaliereService)this.getDataProvider();
                }
                boolean countApplicativo = false;
                if (sgs != null && sgs.getDistribSaSearch() != null && !sgs.getDistribSaSearch().isUseCount()) {
                    countApplicativo = true;
                    start = sgs.getDistribSaSearch().getStart();
                    limit = sgs.getDistribSaSearch().getLimit();
                }
                this.wrappedKeys = new ArrayList();
                if (NumeroDimensioni.DIMENSIONI_3.equals(this.search.getNumeroDimensioni())) {
                    this.search.setSortOrder(SortOrder.DESC);
                }
                List<Object> list = new ArrayList();
                try {
                    list = ((IStatisticheGiornaliere)this.getDataProvider()).findAllDistribuzioneServizioApplicativo(start, limit);
                }
                catch (ServiceException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                list = DistribuzionePerSABean.calcolaLabels(list, ((StatisticheGiornaliereService)this.getDataProvider()).getDistribSaSearch().getProtocollo(), ((StatisticheGiornaliereService)this.getDataProvider()).getDistribSaSearch());
                if (countApplicativo) {
                    this.currentSearchSize = list != null ? list.size() : 0;
                    this.search.setCurrentSearchSize(this.currentSearchSize);
                }
                if (list != null) {
                    for (ResDistribuzione resDistribuzione : list) {
                        this.wrappedData.put(resDistribuzione.getRisultato(), resDistribuzione);
                        this.wrappedKeys.add(resDistribuzione.getRisultato());
                        visitor.process(context, (Object)resDistribuzione.getRisultato(), argument);
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean isVisualizzaComandiExport() {
        return this.visualizzaComandiExport;
    }

    public void setVisualizzaComandiExport(boolean visualizzaComandiExport) {
        this.visualizzaComandiExport = visualizzaComandiExport;
    }

    public boolean isTimeoutEvent() {
        return ((IStatisticheGiornaliere)this.getDataProvider()).isTimeoutEvent();
    }

    public boolean isFirstEnabled() {
        StatisticheGiornaliereService sgs = null;
        if (this.getDataProvider() instanceof StatisticheGiornaliereService) {
            sgs = (StatisticheGiornaliereService)this.getDataProvider();
        }
        if (this.search != null && sgs != null && sgs.getDistribSaSearch() != null && !sgs.getDistribSaSearch().isUseCount()) {
            return sgs.getDistribSaSearch().getStart() != null && sgs.getDistribSaSearch().getStart() > 0;
        }
        return false;
    }

    public boolean isPrevEnabled() {
        return this.isFirstEnabled();
    }

    public boolean isNextEnabled() {
        StatisticheGiornaliereService sgs = null;
        if (this.getDataProvider() instanceof StatisticheGiornaliereService) {
            sgs = (StatisticheGiornaliereService)this.getDataProvider();
        }
        if (this.search != null && sgs != null && sgs.getDistribSaSearch() != null && !sgs.getDistribSaSearch().isUseCount()) {
            return this.search.getCurrentSearchSize() != null && this.search.getLimit() != null && this.search.getCurrentSearchSize().intValue() == this.search.getLimit().intValue();
        }
        return false;
    }

    public String getRecordLabel() {
        return null;
    }

    public String nextPage() {
        Integer currentPage;
        StatisticheGiornaliereService sgs = null;
        if (this.getDataProvider() instanceof StatisticheGiornaliereService) {
            sgs = (StatisticheGiornaliereService)this.getDataProvider();
        }
        if (sgs != null && sgs.getDistribSaSearch() != null && !sgs.getDistribSaSearch().isUseCount() && sgs.getDistribSaSearch().getStart() != null && sgs.getDistribSaSearch().getLimit() != null) {
            int start = sgs.getDistribSaSearch().getStart();
            int limit = sgs.getDistribSaSearch().getLimit();
            int newStart = start + limit;
            sgs.getDistribSaSearch().setStart(newStart);
        }
        if ((currentPage = this.getCurrentPage()) != null) {
            this.setCurrentPage(currentPage + 1);
        } else {
            this.setCurrentPage(1);
        }
        this.update();
        return null;
    }

    public String prevPage() {
        Integer currentPage;
        StatisticheGiornaliereService sgs = null;
        if (this.getDataProvider() instanceof StatisticheGiornaliereService) {
            sgs = (StatisticheGiornaliereService)this.getDataProvider();
        }
        if (sgs != null && sgs.getDistribSaSearch() != null && !sgs.getDistribSaSearch().isUseCount() && sgs.getDistribSaSearch().getStart() != null && sgs.getDistribSaSearch().getLimit() != null) {
            int start = sgs.getDistribSaSearch().getStart();
            int limit = sgs.getDistribSaSearch().getLimit();
            int newStart = start - limit;
            sgs.getDistribSaSearch().setStart(newStart);
        }
        if ((currentPage = this.getCurrentPage()) != null) {
            this.setCurrentPage(currentPage - 1);
        } else {
            this.setCurrentPage(1);
        }
        this.update();
        return null;
    }

    public String firstPage() {
        StatisticheGiornaliereService sgs = null;
        if (this.getDataProvider() instanceof StatisticheGiornaliereService) {
            sgs = (StatisticheGiornaliereService)this.getDataProvider();
        }
        if (sgs != null && sgs.getDistribSaSearch() != null && !sgs.getDistribSaSearch().isUseCount() && sgs.getDistribSaSearch().getStart() != null && sgs.getDistribSaSearch().getLimit() != null) {
            sgs.getDistribSaSearch().setStart(0);
        }
        this.setCurrentPage(1);
        this.update();
        return null;
    }
}

