/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.export;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperCsvExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperXlsExporterBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.jasperreports.engine.JRDataSource;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteComune;
import org.openspcoop2.core.commons.search.PortaApplicativa;
import org.openspcoop2.core.config.AttributeAuthority;
import org.openspcoop2.core.config.AutorizzazioneScope;
import org.openspcoop2.core.config.ConfigurazioneHandler;
import org.openspcoop2.core.config.ConfigurazioneMessageHandlers;
import org.openspcoop2.core.config.ConfigurazionePortaHandler;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.CorrelazioneApplicativa;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.DumpConfigurazioneRegola;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.GestioneTokenAutenticazione;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.InvocazionePorta;
import org.openspcoop2.core.config.MessageSecurity;
import org.openspcoop2.core.config.MtomProcessor;
import org.openspcoop2.core.config.MtomProcessorFlow;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneServizioApplicativo;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneSoggetto;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneToken;
import org.openspcoop2.core.config.PortaApplicativaAzione;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataAutorizzazioneToken;
import org.openspcoop2.core.config.PortaDelegataAzione;
import org.openspcoop2.core.config.PortaDelegataServizioApplicativo;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.Scope;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.Trasformazioni;
import org.openspcoop2.core.config.ValidazioneContenutiApplicativi;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.CredenzialeTipo;
import org.openspcoop2.core.config.constants.RuoloTipoMatch;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.TipoAutorizzazione;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.web.monitor.core.report.Templates;
import org.openspcoop2.web.monitor.statistiche.bean.ConfigurazioneGenerale;
import org.openspcoop2.web.monitor.statistiche.bean.DettaglioPA;
import org.openspcoop2.web.monitor.statistiche.bean.DettaglioPD;
import org.openspcoop2.web.monitor.statistiche.bean.DettaglioRateLimiting;
import org.openspcoop2.web.monitor.statistiche.utils.ConfigurazioniUtils;
import org.openspcoop2.web.monitor.statistiche.utils.IgnoreCaseComp;
import org.openspcoop2.web.monitor.transazioni.exporter.ExportException;
import org.slf4j.Logger;

public class ConfigurazioniCsvExporter {
    private Logger log = null;
    private List<String> chiaviColonne = null;
    private List<String> labelColonne = null;
    private PddRuolo ruolo = null;
    private String formato;

    public ConfigurazioniCsvExporter(Logger log, PddRuolo ruolo, String formato) {
        this.log = log;
        this.ruolo = ruolo;
        this.formato = formato;
        this.chiaviColonne = new ArrayList<String>();
        this.labelColonne = new ArrayList<String>();
        this.init();
    }

    public void init() {
        if (this.ruolo.equals((Object)PddRuolo.DELEGATA)) {
            this.labelColonne.add("Profilo Interoperabilit\u00e0");
            this.labelColonne.add("Tipo API");
            this.labelColonne.add("API");
            this.labelColonne.add("PortType");
            this.labelColonne.add("Fruitore");
            this.labelColonne.add("Erogatore");
            this.labelColonne.add("Implementazione API");
            this.labelColonne.add("Azione/Risorsa");
            this.labelColonne.add("Gruppo");
            this.labelColonne.add("Stato");
            this.labelColonne.add("URL di Invocazione");
            this.labelColonne.add("Modalit\u00e0 Identificazione Azione");
            this.labelColonne.add("Pattern");
            this.labelColonne.add("Force Interface Based");
            this.labelColonne.add("CORS");
            this.labelColonne.add("Token (Stato)");
            this.labelColonne.add("Token (Opzionale)");
            this.labelColonne.add("Token (Policy)");
            this.labelColonne.add("Token (Validazione JWT)");
            this.labelColonne.add("Token (Introspection)");
            this.labelColonne.add("Token (UserInfo)");
            this.labelColonne.add("Token (Token Forward) ");
            this.labelColonne.add("Autenticazione (Token Issuer)");
            this.labelColonne.add("Autenticazione (Token ClientID)");
            this.labelColonne.add("Autenticazione (Token Subject)");
            this.labelColonne.add("Autenticazione (Token Username)");
            this.labelColonne.add("Autenticazione (Token eMail)");
            this.labelColonne.add("Autenticazione (Stato)");
            this.labelColonne.add("Autenticazione (Opzionale)");
            this.labelColonne.add("Autenticazione (proprieta)");
            this.labelColonne.add("AttributeAuthority (attributi)");
            this.labelColonne.add("Autorizzazione (Stato)");
            this.labelColonne.add("Autorizzazione (proprieta)");
            this.labelColonne.add("Autorizzazione Trasporto (Richiedenti)");
            this.labelColonne.add("Autorizzazione Trasporto (Applicativi Autorizzati)");
            this.labelColonne.add("Autorizzazione Trasporto (Ruoli)");
            this.labelColonne.add("Autorizzazione Trasporto (Ruoli Richiesti)");
            this.labelColonne.add("Autorizzazione Trasporto (Ruoli Autorizzati)");
            this.labelColonne.add("Autorizzazione Token (Richiedenti)");
            this.labelColonne.add("Autorizzazione Token (Applicativi Autorizzati)");
            this.labelColonne.add("Autorizzazione Token (Ruoli)");
            this.labelColonne.add("Autorizzazione Token (Ruoli Richiesti)");
            this.labelColonne.add("Autorizzazione Token (Ruoli Autorizzati)");
            this.labelColonne.add("Autorizzazione Token (Claims)");
            this.labelColonne.add("Autorizzazione Token (Scope)");
            this.labelColonne.add("Scope Richiesti");
            this.labelColonne.add("Scope");
            this.labelColonne.add("Autorizzazione Contenuti (Stato)");
            this.labelColonne.add("Autorizzazione Contenuti (proprieta)");
            this.labelColonne.add("RateLimiting");
            this.labelColonne.add("Validazione (Stato)");
            this.labelColonne.add("Validazione (Tipo)");
            this.labelColonne.add("Validazione (Accetta MTOM)");
            this.labelColonne.add("Caching Risposta");
            this.labelColonne.add("Sicurezza Messaggio (Stato)");
            this.labelColonne.add("Schema Sicurezza (Richiesta)");
            this.labelColonne.add("Schema Sicurezza (Risposta)");
            this.labelColonne.add("MTOM (Richiesta)");
            this.labelColonne.add("MTOM (Risposta)");
            this.labelColonne.add("Trasformazioni");
            this.labelColonne.add("Correlazione Applicativa (Richiesta)");
            this.labelColonne.add("Correlazione Applicativa (Risposta)");
            this.labelColonne.add("Registrazione Messaggi");
            this.labelColonne.add("Propriet\u00e0");
            this.labelColonne.add("Metadati");
            this.labelColonne.add("Handlers");
            this.labelColonne.add("Configurazioni Profilo Interoperabilit\u00e0");
            this.labelColonne.add("Connettore (Tipo)");
            this.labelColonne.add("Connettore (Endpoint)");
            this.labelColonne.add("Connettore (Debug)");
            this.labelColonne.add("Connettore (Username)");
            this.labelColonne.add("Connettore (Token)");
            this.labelColonne.add("Connettore (API Key)");
            this.labelColonne.add("Connettore (App Id)");
            this.labelColonne.add("Connettore (Proxy Endpoint)");
            this.labelColonne.add("Connettore (Proxy Username)");
            this.labelColonne.add("Connettore (SSL Type)");
            this.labelColonne.add("Connettore (Hostname Verifier)");
            this.labelColonne.add("Connettore (KeyStore)");
            this.labelColonne.add("Connettore (TrustStore)");
            this.labelColonne.add("Connettore (KeyStore Location)");
            this.labelColonne.add("Connettore (TrustStore Location)");
            this.labelColonne.add("Connettore (Client Certificate)");
            this.labelColonne.add("Connettore (Altre Configurazioni)");
            this.labelColonne.add("Porta Delegata");
        } else {
            this.labelColonne.add("Profilo Interoperabilit\u00e0");
            this.labelColonne.add("Tipo API");
            this.labelColonne.add("API");
            this.labelColonne.add("PortType");
            this.labelColonne.add("Erogatore");
            this.labelColonne.add("Implementazione API");
            this.labelColonne.add("Azione/Risorsa");
            this.labelColonne.add("Gruppo");
            this.labelColonne.add("Stato");
            this.labelColonne.add("URL di Invocazione");
            this.labelColonne.add("Modalit\u00e0 Identificazione Azione");
            this.labelColonne.add("Pattern");
            this.labelColonne.add("Force Interface Based");
            this.labelColonne.add("CORS");
            this.labelColonne.add("Token (Stato)");
            this.labelColonne.add("Token (Opzionale)");
            this.labelColonne.add("Token (Policy)");
            this.labelColonne.add("Token (Validazione JWT)");
            this.labelColonne.add("Token (Introspection)");
            this.labelColonne.add("Token (UserInfo)");
            this.labelColonne.add("Token (Token Forward) ");
            this.labelColonne.add("Autenticazione (Token Issuer)");
            this.labelColonne.add("Autenticazione (Token ClientID)");
            this.labelColonne.add("Autenticazione (Token Subject)");
            this.labelColonne.add("Autenticazione (Token Username)");
            this.labelColonne.add("Autenticazione (Token eMail)");
            this.labelColonne.add("Autenticazione (Stato)");
            this.labelColonne.add("Autenticazione (Opzionale)");
            this.labelColonne.add("Autenticazione (proprieta)");
            this.labelColonne.add("AttributeAuthority (attributi)");
            this.labelColonne.add("Autorizzazione (Stato)");
            this.labelColonne.add("Autorizzazione (proprieta)");
            this.labelColonne.add("Autorizzazione Trasporto (Richiedenti)");
            this.labelColonne.add("Autorizzazione Trasporto (Soggetti Autorizzati)");
            this.labelColonne.add("Autorizzazione Trasporto (Applicativi Autorizzati)");
            this.labelColonne.add("Autorizzazione Trasporto (Ruoli)");
            this.labelColonne.add("Autorizzazione Trasporto (Ruoli Richiesti)");
            this.labelColonne.add("Autorizzazione Trasporto (Ruoli Autorizzati)");
            this.labelColonne.add("Autorizzazione Token (Richiedenti)");
            this.labelColonne.add("Autorizzazione Token (Applicativi Autorizzati)");
            this.labelColonne.add("Autorizzazione Token (Ruoli)");
            this.labelColonne.add("Autorizzazione Token (Ruoli Richiesti)");
            this.labelColonne.add("Autorizzazione Token (Ruoli Autorizzati)");
            this.labelColonne.add("Autorizzazione Token (Claims)");
            this.labelColonne.add("Autorizzazione Token (Scope)");
            this.labelColonne.add("Scope Richiesti");
            this.labelColonne.add("Scope");
            this.labelColonne.add("Autorizzazione Contenuti (Stato)");
            this.labelColonne.add("Autorizzazione Contenuti (proprieta)");
            this.labelColonne.add("RateLimiting");
            this.labelColonne.add("Validazione (Stato)");
            this.labelColonne.add("Validazione (Tipo)");
            this.labelColonne.add("Validazione (Accetta MTOM)");
            this.labelColonne.add("Caching Risposta");
            this.labelColonne.add("Sicurezza Messaggio (Stato)");
            this.labelColonne.add("Schema Sicurezza (Richiesta)");
            this.labelColonne.add("Schema Sicurezza (Risposta)");
            this.labelColonne.add("MTOM (Richiesta)");
            this.labelColonne.add("MTOM (Risposta)");
            this.labelColonne.add("Trasformazioni");
            this.labelColonne.add("Correlazione Applicativa (Richiesta)");
            this.labelColonne.add("Correlazione Applicativa (Risposta)");
            this.labelColonne.add("Registrazione Messaggi");
            this.labelColonne.add("Propriet\u00e0");
            this.labelColonne.add("Metadati");
            this.labelColonne.add("Handlers");
            this.labelColonne.add("Configurazioni Profilo Interoperabilit\u00e0");
            this.labelColonne.add("MessageBox");
            this.labelColonne.add("Sbustamento SOAP");
            this.labelColonne.add("Sbustamento Protocollo");
            this.labelColonne.add("Connettore (Tipo)");
            this.labelColonne.add("Connettore (Endpoint)");
            this.labelColonne.add("Connettore (Debug)");
            this.labelColonne.add("Connettore (Username)");
            this.labelColonne.add("Connettore (Token)");
            this.labelColonne.add("Connettore (API Key)");
            this.labelColonne.add("Connettore (App Id)");
            this.labelColonne.add("Connettore (Proxy Endpoint)");
            this.labelColonne.add("Connettore (Proxy Username)");
            this.labelColonne.add("Connettore (SSL Type)");
            this.labelColonne.add("Connettore (Hostname Verifier)");
            this.labelColonne.add("Connettore (KeyStore)");
            this.labelColonne.add("Connettore (TrustStore)");
            this.labelColonne.add("Connettore (KeyStore Location)");
            this.labelColonne.add("Connettore (TrustStore Location)");
            this.labelColonne.add("Connettore (Client Certificate)");
            this.labelColonne.add("Connettore (Altre Configurazioni)");
            this.labelColonne.add("Porta Applicativa");
            this.labelColonne.add("Connettore Multiplo");
            this.labelColonne.add("Applicativo Server");
        }
        for (int i = 0; i < this.labelColonne.size(); ++i) {
            this.chiaviColonne.add("col_" + i);
        }
    }

    public String exportConfigurazioni(List<ConfigurazioneGenerale> listaConfigurazioni, OutputStream out) throws Exception {
        String errMsg = null;
        DRDataSource dataSource = this.creaDatasourceConfigurazioni(this.chiaviColonne, this.log);
        this.popolaDataSourceExport(dataSource, listaConfigurazioni);
        JasperReportBuilder reportBuilder = this.creaReportBuilder((JRDataSource)dataSource, this.log);
        if (this.formato.equals("csv")) {
            this.esportaCsv(out, reportBuilder, this.chiaviColonne, this.labelColonne);
        } else if (this.formato.equals("xls")) {
            this.esportaXls(out, reportBuilder, this.chiaviColonne, this.labelColonne);
        } else {
            throw new ExportException("Formato export [" + this.formato + "] non valido.");
        }
        return errMsg;
    }

    public void esportaXls(OutputStream outputStream, JasperReportBuilder report, List<String> chiaviColonne, List<String> labelColonne) throws Exception {
        JasperXlsExporterBuilder builder = (JasperXlsExporterBuilder)((JasperXlsExporterBuilder)((JasperXlsExporterBuilder)((JasperXlsExporterBuilder)DynamicReports.export.xlsExporter(outputStream).setDetectCellType(Boolean.valueOf(true))).setIgnorePageMargins(Boolean.valueOf(true))).setWhitePageBackground(Boolean.valueOf(false))).setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true));
        ArrayList<TextColumnBuilder> colonne = new ArrayList<TextColumnBuilder>();
        for (int i = 0; i < labelColonne.size(); ++i) {
            String label = labelColonne.get(i);
            String keyColonna = chiaviColonne.get(i);
            TextColumnBuilder nomeColumn = DynamicReports.col.column(label, keyColonna, (DRIDataType)DynamicReports.type.stringType());
            colonne.add(nomeColumn);
        }
        ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)report.setColumnTitleStyle((ReportStyleBuilder)Templates.columnTitleStyle)).addProperty("net.sf.jasperreports.export.csv.exclude.origin.keep.first.band.1", "columnHeader")).ignorePageWidth()).ignorePagination()).columns(colonne.toArray(new ColumnBuilder[colonne.size()]));
        report.toXls(builder);
    }

    public void esportaCsv(OutputStream outputStream, JasperReportBuilder report, List<String> chiaviColonne, List<String> labelColonne) throws Exception {
        ArrayList<TextColumnBuilder> colonne = new ArrayList<TextColumnBuilder>();
        for (int i = 0; i < labelColonne.size(); ++i) {
            String label = labelColonne.get(i);
            String keyColonna = chiaviColonne.get(i);
            TextColumnBuilder nomeColumn = DynamicReports.col.column(label, keyColonna, (DRIDataType)DynamicReports.type.stringType());
            colonne.add(nomeColumn);
        }
        ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)report.setColumnTitleStyle((ReportStyleBuilder)Templates.columnTitleStyle)).addProperty("net.sf.jasperreports.export.csv.exclude.origin.keep.first.band.1", "columnHeader")).ignorePageWidth()).ignorePagination()).columns(colonne.toArray(new ColumnBuilder[colonne.size()]));
        JasperCsvExporterBuilder builder = DynamicReports.export.csvExporter(outputStream);
        report.toCsv(builder);
    }

    public JasperReportBuilder creaReportBuilder(JRDataSource dataSource, Logger log) throws Exception {
        JasperReportBuilder builder = DynamicReports.report();
        builder.setDataSource(dataSource);
        return builder;
    }

    private DRDataSource creaDatasourceConfigurazioni(List<String> colonneSelezionate, Logger log) throws Exception {
        ArrayList<String> header = new ArrayList<String>();
        header.addAll(colonneSelezionate);
        DRDataSource dataSource = new DRDataSource(header.toArray(new String[header.size()]));
        return dataSource;
    }

    private void popolaDataSourceExport(DRDataSource dataSource, List<ConfigurazioneGenerale> lstConfigurazioni) throws Exception {
        for (ConfigurazioneGenerale configurazione : lstConfigurazioni) {
            if (this.ruolo.equals((Object)PddRuolo.DELEGATA)) {
                this.addLinePD(dataSource, configurazione);
                continue;
            }
            List<DettaglioPA.DettaglioSA> listaSA = configurazione.getPa().getListaSA();
            if (listaSA == null || listaSA.size() <= 1) {
                DettaglioPA.DettaglioSA dettaglioSA = listaSA != null && listaSA.size() > 0 ? listaSA.get(0) : null;
                this.addLinePA(dataSource, configurazione, dettaglioSA);
                continue;
            }
            DettaglioPA dettaglioPA = configurazione.getPa();
            org.openspcoop2.core.config.PortaApplicativa paOp2 = dettaglioPA.getPortaApplicativaOp2();
            ArrayList<String> orderFix = new ArrayList<String>();
            HashMap<String, DettaglioPA.DettaglioSA> mapIds = new HashMap<String, DettaglioPA.DettaglioSA>();
            for (DettaglioPA.DettaglioSA dettaglioSA : listaSA) {
                ServizioApplicativo saOp2;
                String nomePAConnettore = null;
                if (dettaglioSA != null && StringUtils.isNotEmpty((String)(saOp2 = dettaglioSA.getSaOp2()).getNome()) && paOp2.sizeServizioApplicativoList() > 0) {
                    for (PortaApplicativaServizioApplicativo pasa : paOp2.getServizioApplicativoList()) {
                        if (!saOp2.getNome().equals(pasa.getNome()) || pasa.getDatiConnettore() == null || !StringUtils.isNotEmpty((String)pasa.getDatiConnettore().getNome())) continue;
                        nomePAConnettore = pasa.getDatiConnettore().getNome();
                    }
                }
                nomePAConnettore = nomePAConnettore == null ? "Default" : nomePAConnettore;
                Object checkNome = nomePAConnettore;
                int index = 1;
                while (orderFix.contains(checkNome)) {
                    checkNome = nomePAConnettore + "###" + index;
                    ++index;
                }
                nomePAConnettore = checkNome;
                orderFix.add(nomePAConnettore);
                mapIds.put(nomePAConnettore, dettaglioSA);
            }
            Collections.sort(orderFix, new IgnoreCaseComp());
            for (String nomeConnettore : orderFix) {
                this.addLinePA(dataSource, configurazione, (DettaglioPA.DettaglioSA)mapIds.get(nomeConnettore));
            }
        }
    }

    private void addLinePA(DRDataSource dataSource, ConfigurazioneGenerale configurazione, DettaglioPA.DettaglioSA dettaglioSA) throws Exception {
        ServizioApplicativo saOp2;
        ServizioApplicativo saOp22;
        String statoMessageSecurity;
        Object sb;
        String match;
        IdAccordoServizioParteComune aspc;
        ArrayList<Object> oneLine = new ArrayList<Object>();
        DettaglioPA dettaglioPA = configurazione.getPa();
        org.openspcoop2.core.config.PortaApplicativa paOp2 = dettaglioPA.getPortaApplicativaOp2();
        PortaApplicativa portaApplicativa = dettaglioPA.getPortaApplicativa();
        PortaApplicativaAzione paAzione = paOp2.getAzione();
        MappingErogazionePortaApplicativa mappingPA = dettaglioPA.getMappingErogazionePortaApplicativaOp2();
        org.openspcoop2.core.config.PortaApplicativa paOp2Default = dettaglioPA.getPortaApplicativaDefaultOp2();
        DettaglioRateLimiting rateLimiting = dettaglioPA.getRateLimiting();
        String protocollo = configurazione.getProtocollo();
        if (StringUtils.isNotEmpty((String)protocollo)) {
            oneLine.add(NamingUtils.getLabelProtocollo((String)protocollo));
        } else {
            oneLine.add("");
        }
        if (dettaglioPA.getIdAccordoServizioParteComune() != null) {
            aspc = dettaglioPA.getIdAccordoServizioParteComune();
            if (aspc.getServiceBinding() != null) {
                oneLine.add(aspc.getServiceBinding());
            } else {
                oneLine.add("");
            }
        } else {
            oneLine.add("");
        }
        if (dettaglioPA.getIdAccordoServizioParteComune() != null) {
            aspc = dettaglioPA.getIdAccordoServizioParteComune();
            String nomeAspc = aspc.getNome();
            Integer versioneAspc = aspc.getVersione();
            String nomeReferenteAspc = aspc.getIdSoggetto() != null ? aspc.getIdSoggetto().getNome() : null;
            String tipoReferenteAspc = aspc.getIdSoggetto() != null ? aspc.getIdSoggetto().getTipo() : null;
            oneLine.add(NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)IDAccordoFactory.getInstance().getIDAccordoFromValues(nomeAspc, tipoReferenteAspc, nomeReferenteAspc, versioneAspc)));
        } else {
            oneLine.add("");
        }
        if (StringUtils.isNotEmpty((String)dettaglioPA.getPortType())) {
            oneLine.add(dettaglioPA.getPortType());
        } else {
            oneLine.add("");
        }
        if (StringUtils.isNotEmpty((String)configurazione.getErogatore())) {
            oneLine.add(configurazione.getErogatore());
        } else {
            oneLine.add("");
        }
        if (StringUtils.isNotEmpty((String)configurazione.getServizio())) {
            oneLine.add(configurazione.getServizio());
        } else {
            oneLine.add("");
        }
        if (StringUtils.isNotEmpty((String)portaApplicativa.getNomeAzione())) {
            oneLine.add(portaApplicativa.getNomeAzione());
        } else {
            List<String> azioni = dettaglioPA.getAzioni();
            if (paAzione == null && (azioni == null || azioni.size() == 0)) {
                oneLine.add("Utilizzo del Servizio senza azione");
            } else {
                StringBuilder sb2 = new StringBuilder();
                if (azioni != null && azioni.size() > 0) {
                    for (String azione : azioni) {
                        if (sb2.length() > 0) {
                            sb2.append("\n");
                        }
                        sb2.append(azione);
                    }
                }
                oneLine.add(sb2.toString());
            }
        }
        if (mappingPA != null && mappingPA.getDescrizione() != null) {
            oneLine.add(mappingPA.getDescrizione());
        } else {
            oneLine.add("");
        }
        if (StringUtils.isNotEmpty((String)configurazione.getStato())) {
            oneLine.add(configurazione.getStato());
        } else {
            oneLine.add("");
        }
        String urlInvocazione = dettaglioPA.getUrlInvocazione();
        if (StringUtils.isNotEmpty((String)urlInvocazione)) {
            oneLine.add(urlInvocazione);
        } else {
            oneLine.add("");
        }
        if (paAzione != null) {
            if (paAzione.getIdentificazione() != null) {
                oneLine.add(paAzione.getIdentificazione().toString());
            } else {
                oneLine.add("");
            }
            if (StringUtils.isNotEmpty((String)paAzione.getPattern())) {
                oneLine.add(paAzione.getPattern());
            } else {
                oneLine.add("");
            }
            if (paAzione.getForceInterfaceBased() != null) {
                oneLine.add(paAzione.getForceInterfaceBased().getValue());
            } else {
                oneLine.add("");
            }
        } else {
            oneLine.add("");
            oneLine.add("");
            oneLine.add("");
        }
        if (paOp2Default != null) {
            if (paOp2Default.getGestioneCors() != null) {
                oneLine.add(paOp2Default.getGestioneCors().getStato().getValue());
            } else {
                oneLine.add("default");
            }
        } else if (paOp2.getGestioneCors() != null) {
            oneLine.add(paOp2.getGestioneCors().getStato().getValue());
        } else {
            oneLine.add("default");
        }
        GestioneToken gestioneToken = paOp2.getGestioneToken();
        GestioneTokenAutenticazione gestioneTokenAutenticazione = null;
        if (gestioneToken != null) {
            StatoFunzionalita tokenOpzionale;
            gestioneTokenAutenticazione = gestioneToken.getAutenticazione();
            String policy = gestioneToken.getPolicy();
            StatoFunzionalita statoFunzionalita = tokenOpzionale = gestioneToken.getTokenOpzionale() != null ? gestioneToken.getTokenOpzionale() : StatoFunzionalita.DISABILITATO;
            if (policy != null) {
                oneLine.add(StatoFunzionalita.ABILITATO.getValue());
                oneLine.add(tokenOpzionale.getValue());
                oneLine.add(policy);
                oneLine.add(gestioneToken.getValidazione() != null ? gestioneToken.getValidazione().getValue() : "");
                oneLine.add(gestioneToken.getIntrospection() != null ? gestioneToken.getIntrospection().getValue() : "");
                oneLine.add(gestioneToken.getUserInfo() != null ? gestioneToken.getUserInfo().getValue() : "");
                oneLine.add(gestioneToken.getForward() != null ? gestioneToken.getForward().getValue() : "");
            } else {
                oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
                oneLine.add(tokenOpzionale.getValue());
                oneLine.add("");
                oneLine.add("");
                oneLine.add("");
                oneLine.add("");
                oneLine.add("");
            }
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
            oneLine.add("");
            oneLine.add("");
            oneLine.add("");
            oneLine.add("");
            oneLine.add("");
        }
        if (gestioneTokenAutenticazione != null) {
            oneLine.add(gestioneTokenAutenticazione.getIssuer() != null ? gestioneTokenAutenticazione.getIssuer().getValue() : StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(gestioneTokenAutenticazione.getClientId() != null ? gestioneTokenAutenticazione.getClientId().getValue() : StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(gestioneTokenAutenticazione.getSubject() != null ? gestioneTokenAutenticazione.getSubject().getValue() : StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(gestioneTokenAutenticazione.getUsername() != null ? gestioneTokenAutenticazione.getUsername().getValue() : StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(gestioneTokenAutenticazione.getEmail() != null ? gestioneTokenAutenticazione.getEmail().getValue() : StatoFunzionalita.DISABILITATO.getValue());
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
        }
        if (dettaglioPA.isSupportatoAutenticazione()) {
            if ("none".equals(paOp2.getAutenticazione())) {
                oneLine.add(CostantiConfigurazione.DISABILITATO.getValue());
            } else {
                oneLine.add(paOp2.getAutenticazione());
            }
            if (CostantiConfigurazione.ABILITATO.equals((Object)paOp2.getAutenticazioneOpzionale())) {
                oneLine.add(CostantiConfigurazione.ABILITATO.getValue());
            } else {
                oneLine.add(CostantiConfigurazione.DISABILITATO.getValue());
            }
            oneLine.add(this.toStringProprieta(paOp2.getProprietaAutenticazioneList()));
        } else {
            oneLine.add("");
            oneLine.add("");
            oneLine.add("");
        }
        oneLine.add(this.toStringAttributeAuthority(paOp2.getAttributeAuthorityList()));
        String autorizzazione = paOp2.getAutorizzazione();
        if ("none".equals(autorizzazione)) {
            oneLine.add(CostantiConfigurazione.DISABILITATO.getValue());
        } else if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.XACML_POLICY.getValue().toLowerCase())) {
            oneLine.add(TipoAutorizzazione.XACML_POLICY.getValue());
        } else if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase()) || autorizzazione.toLowerCase().contains(TipoAutorizzazione.AUTHENTICATED.getValue().toLowerCase())) {
            oneLine.add(CostantiConfigurazione.ABILITATO.getValue());
        } else {
            oneLine.add(autorizzazione);
        }
        oneLine.add(this.toStringProprieta(paOp2.getProprietaAutorizzazioneList()));
        if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.AUTHENTICATED.getValue().toLowerCase())) {
            StringBuilder sb3;
            oneLine.add(StatoFunzionalita.ABILITATO.getValue());
            if (paOp2.getSoggetti() != null && paOp2.getSoggetti().sizeSoggettoList() > 0) {
                sb3 = new StringBuilder();
                for (PortaApplicativaAutorizzazioneSoggetto soggetto : paOp2.getSoggetti().getSoggettoList()) {
                    if (sb3.length() > 0) {
                        sb3.append("\n");
                    }
                    sb3.append(soggetto.getTipo() + "/" + soggetto.getNome());
                }
                oneLine.add(sb3.toString());
            } else {
                oneLine.add("");
            }
            if (paOp2.getServiziApplicativiAutorizzati() != null && paOp2.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0) {
                sb3 = new StringBuilder();
                for (PortaApplicativaAutorizzazioneServizioApplicativo sa : paOp2.getServiziApplicativiAutorizzati().getServizioApplicativoList()) {
                    if (sb3.length() > 0) {
                        sb3.append("\n");
                    }
                    sb3.append(sa.getNome() + " soggetto:" + sa.getTipoSoggettoProprietario() + "/" + sa.getNomeSoggettoProprietario());
                }
                oneLine.add(sb3.toString());
            } else {
                oneLine.add("");
            }
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
            oneLine.add("");
        }
        if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase())) {
            oneLine.add(StatoFunzionalita.ABILITATO.getValue());
            List<String> ruoli = dettaglioPA.getRuoli();
            match = dettaglioPA.getMatchRuoli();
            oneLine.add(match);
            if (paOp2.getRuoli() != null) {
                sb = new StringBuilder();
                for (String ruolo : ruoli) {
                    if (((StringBuilder)sb).length() > 0) {
                        ((StringBuilder)sb).append("\n");
                    }
                    ((StringBuilder)sb).append(ruolo);
                }
                oneLine.add(((StringBuilder)sb).toString());
            } else {
                oneLine.add("");
            }
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
            oneLine.add("");
        }
        PortaApplicativaAutorizzazioneToken autorizzazioneToken = paOp2.getAutorizzazioneToken();
        if (autorizzazioneToken != null && StatoFunzionalita.ABILITATO.equals((Object)autorizzazioneToken.getAutorizzazioneApplicativi()) || dettaglioPA.isModiSicurezzaMessaggio()) {
            oneLine.add(StatoFunzionalita.ABILITATO.getValue());
            StringBuilder sb4 = new StringBuilder();
            if (dettaglioPA.isModiSicurezzaMessaggio()) {
                if (paOp2.getServiziApplicativiAutorizzati() != null && paOp2.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0) {
                    for (Object sa : paOp2.getServiziApplicativiAutorizzati().getServizioApplicativoList()) {
                        if (sb4.length() > 0) {
                            sb4.append("\n");
                        }
                        sb4.append(sa.getNome() + " soggetto:" + sa.getTipoSoggettoProprietario() + "/" + sa.getNomeSoggettoProprietario());
                    }
                }
            } else if (autorizzazioneToken.getServiziApplicativi() != null && autorizzazioneToken.getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                for (Object sa : autorizzazioneToken.getServiziApplicativi().getServizioApplicativoList()) {
                    if (sb4.length() > 0) {
                        sb4.append("\n");
                    }
                    sb4.append(sa.getNome() + " soggetto:" + sa.getTipoSoggettoProprietario() + "/" + sa.getNomeSoggettoProprietario());
                }
            }
            oneLine.add(sb4.toString());
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
        }
        if (autorizzazioneToken != null && StatoFunzionalita.ABILITATO.equals((Object)autorizzazioneToken.getAutorizzazioneRuoli())) {
            oneLine.add(StatoFunzionalita.ABILITATO.getValue());
            match = autorizzazioneToken.getRuoli() != null && autorizzazioneToken.getRuoli().getMatch() != null ? (RuoloTipoMatch.ANY.equals((Object)autorizzazioneToken.getRuoli().getMatch()) ? "almeno uno" : "tutti") : "";
            oneLine.add(match);
            if (autorizzazioneToken.getRuoli() != null && autorizzazioneToken.getRuoli().sizeRuoloList() > 0) {
                sb = new StringBuilder();
                for (String ruolo : autorizzazioneToken.getRuoli().getRuoloList()) {
                    if (((StringBuilder)sb).length() > 0) {
                        ((StringBuilder)sb).append("\n");
                    }
                    ((StringBuilder)sb).append(ruolo.getNome());
                }
                oneLine.add(((StringBuilder)sb).toString());
            } else {
                oneLine.add("");
            }
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
            oneLine.add("");
        }
        if (gestioneToken != null) {
            if (StringUtils.isNotEmpty((String)gestioneToken.getOptions())) {
                oneLine.add(gestioneToken.getOptions());
            } else {
                oneLine.add("");
            }
        } else {
            oneLine.add("");
        }
        AutorizzazioneScope scope = paOp2.getScope();
        if (scope != null) {
            oneLine.add(scope.getStato() != null ? scope.getStato().getValue() : "");
            oneLine.add(scope.getMatch() != null ? scope.getMatch().getValue() : "");
            if (scope.getScopeList() != null) {
                sb = new StringBuilder();
                for (Scope scopeS : scope.getScopeList()) {
                    if (((StringBuilder)sb).length() > 0) {
                        ((StringBuilder)sb).append("\n");
                    }
                    ((StringBuilder)sb).append(scopeS.getNome());
                }
                oneLine.add(((StringBuilder)sb).toString());
            } else {
                oneLine.add("");
            }
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
            oneLine.add("");
        }
        String autorizzazioneContenuti = paOp2.getAutorizzazioneContenuto();
        if ("none".equals(autorizzazioneContenuti)) {
            oneLine.add(CostantiConfigurazione.DISABILITATO.getValue());
        } else if ("builtIn".equals(autorizzazioneContenuti)) {
            oneLine.add(CostantiConfigurazione.ABILITATO.getValue());
        } else {
            oneLine.add(autorizzazioneContenuti);
        }
        oneLine.add(this.toStringProprieta(paOp2.getProprietaAutorizzazioneContenutoList()));
        if (rateLimiting != null) {
            oneLine.add(rateLimiting.getAsCSVRecord());
        } else {
            oneLine.add("");
        }
        ValidazioneContenutiApplicativi validazioneContenutiApplicativi = paOp2.getValidazioneContenutiApplicativi();
        if (validazioneContenutiApplicativi != null) {
            oneLine.add(validazioneContenutiApplicativi.getStato().getValue());
            oneLine.add(validazioneContenutiApplicativi.getTipo().getValue());
            oneLine.add(validazioneContenutiApplicativi.getAcceptMtomMessage().getValue());
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
            oneLine.add("");
        }
        if (paOp2.getResponseCaching() != null) {
            oneLine.add(paOp2.getResponseCaching().getStato().getValue());
        } else {
            oneLine.add("default");
        }
        MessageSecurity messageSecurity = paOp2.getMessageSecurity();
        String requestMode = null;
        String responseMode = null;
        if (messageSecurity != null) {
            if (messageSecurity.getRequestFlow() != null) {
                requestMode = messageSecurity.getRequestFlow().getMode();
            }
            if (messageSecurity.getResponseFlow() != null) {
                responseMode = messageSecurity.getResponseFlow().getMode();
            }
        }
        if (StringUtils.isNotEmpty((String)(statoMessageSecurity = paOp2.getStatoMessageSecurity()))) {
            oneLine.add(statoMessageSecurity);
            if (StatoFunzionalita.ABILITATO.getValue().equals(statoMessageSecurity)) {
                if (StringUtils.isNotEmpty((String)requestMode)) {
                    if (requestMode.equals("default")) {
                        oneLine.add("Configurazione Manuale");
                    } else {
                        oneLine.add(requestMode);
                    }
                } else {
                    oneLine.add("Nessuno");
                }
                if (StringUtils.isNotEmpty((String)responseMode)) {
                    if (responseMode.equals("default")) {
                        oneLine.add("Configurazione Manuale");
                    } else {
                        oneLine.add(responseMode);
                    }
                } else {
                    oneLine.add("Nessuno");
                }
            } else {
                oneLine.add("");
                oneLine.add("");
            }
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
            oneLine.add("");
        }
        MtomProcessor mtomProcessor = paOp2.getMtomProcessor();
        if (mtomProcessor != null) {
            MtomProcessorFlow requestFlow = mtomProcessor.getRequestFlow();
            if (requestFlow != null) {
                oneLine.add(requestFlow.getMode().getValue());
            } else {
                oneLine.add("");
            }
            MtomProcessorFlow responseFlow = mtomProcessor.getResponseFlow();
            if (responseFlow != null) {
                oneLine.add(responseFlow.getMode().getValue());
            } else {
                oneLine.add("");
            }
        } else {
            oneLine.add("");
            oneLine.add("");
        }
        oneLine.add(this.toStringTrasformazioni(paOp2.getTrasformazioni()));
        int numCorrelazioneReq = 0;
        int numCorrelazioneRes = 0;
        CorrelazioneApplicativa ca = paOp2.getCorrelazioneApplicativa();
        if (ca != null) {
            numCorrelazioneReq = ca.sizeElementoList();
        }
        if (paOp2.getCorrelazioneApplicativaRisposta() != null) {
            numCorrelazioneRes = paOp2.getCorrelazioneApplicativaRisposta().sizeElementoList();
        }
        if (numCorrelazioneReq > 0) {
            oneLine.add(StatoFunzionalita.ABILITATO.getValue());
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
        }
        if (numCorrelazioneRes > 0) {
            oneLine.add(StatoFunzionalita.ABILITATO.getValue());
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
        }
        oneLine.add(this.toStringDump(paOp2.getDump()));
        oneLine.add(this.toStringProprieta(paOp2.getProprietaList()));
        if (StringUtils.isNotEmpty((String)paOp2.getIntegrazione())) {
            oneLine.add(paOp2.getIntegrazione());
        } else {
            oneLine.add("");
        }
        oneLine.add(this.toStringHandlers(paOp2.getConfigurazioneHandler()));
        if (StringUtils.isNotEmpty((String)dettaglioPA.getConfigurazioneProfilo())) {
            oneLine.add(dettaglioPA.getConfigurazioneProfilo());
        } else {
            oneLine.add("");
        }
        if (dettaglioSA != null) {
            ServizioApplicativo saOp23 = dettaglioSA.getSaOp2();
            if (saOp23.getInvocazioneServizio() != null) {
                if (StringUtils.isNotEmpty((String)saOp23.getInvocazioneServizio().getGetMessage().getValue())) {
                    oneLine.add(saOp23.getInvocazioneServizio().getGetMessage().getValue());
                } else {
                    oneLine.add("");
                }
                if (StringUtils.isNotEmpty((String)saOp23.getInvocazioneServizio().getSbustamentoSoap().getValue())) {
                    oneLine.add(saOp23.getInvocazioneServizio().getSbustamentoSoap().getValue());
                } else {
                    oneLine.add("");
                }
                if (StringUtils.isNotEmpty((String)saOp23.getInvocazioneServizio().getSbustamentoInformazioniProtocollo().getValue())) {
                    oneLine.add(saOp23.getInvocazioneServizio().getSbustamentoInformazioniProtocollo().getValue());
                } else {
                    oneLine.add("");
                }
                if (saOp23.getInvocazioneServizio().getConnettore() != null) {
                    Connettore connettore = saOp23.getInvocazioneServizio().getConnettore();
                    oneLine.addAll(this.printConnettore(connettore, "Tipo", saOp23.getInvocazioneServizio().getCredenziali(), saOp23.getInvocazioneServizio().getGetMessage(), saOp23.getInvocazionePorta()));
                } else {
                    for (int i = 0; i < 17; ++i) {
                        oneLine.add("");
                    }
                }
            } else {
                for (int i = 0; i < 20; ++i) {
                    oneLine.add("");
                }
            }
        } else {
            for (int i = 0; i < 21; ++i) {
                oneLine.add("");
            }
        }
        if (StringUtils.isNotEmpty((String)portaApplicativa.getNome())) {
            oneLine.add(portaApplicativa.getNome());
        } else {
            oneLine.add("");
        }
        String nomePAConnettore = "";
        if (dettaglioSA != null && StringUtils.isNotEmpty((String)(saOp22 = dettaglioSA.getSaOp2()).getNome()) && paOp2.sizeServizioApplicativoList() > 0) {
            for (PortaApplicativaServizioApplicativo pasa : paOp2.getServizioApplicativoList()) {
                if (!saOp22.getNome().equals(pasa.getNome()) || pasa.getDatiConnettore() == null || !StringUtils.isNotEmpty((String)pasa.getDatiConnettore().getNome())) continue;
                nomePAConnettore = pasa.getDatiConnettore().getNome();
            }
        }
        oneLine.add(nomePAConnettore);
        String nomeApplicativoServer = "";
        if (dettaglioSA != null && (StringUtils.isNotEmpty((String)(saOp2 = dettaglioSA.getSaOp2()).getNome()) && "server".equals(saOp2.getTipo()) || "clientORserver".equals(saOp2.getTipo()))) {
            nomeApplicativoServer = saOp2.getNome();
        }
        oneLine.add(nomeApplicativoServer);
        dataSource.add(oneLine.toArray(new Object[oneLine.size()]));
    }

    private void addLinePD(DRDataSource dataSource, ConfigurazioneGenerale configurazione) throws Exception {
        String statoMessageSecurity;
        Object sb;
        String match;
        IdAccordoServizioParteComune aspc;
        ArrayList<Object> oneLine = new ArrayList<Object>();
        DettaglioPD dettaglioPD = configurazione.getPd();
        PortaDelegata pdOp2 = dettaglioPD.getPortaDelegataOp2();
        PortaDelegata pdOp2Default = dettaglioPD.getPortaDelegataDefaultOp2();
        org.openspcoop2.core.commons.search.PortaDelegata portaDelegata = dettaglioPD.getPortaDelegata();
        PortaDelegataAzione pdAzione = pdOp2.getAzione();
        MappingFruizionePortaDelegata mappingPD = dettaglioPD.getMappingFruizionePortaDelegataOp2();
        DettaglioRateLimiting rateLimiting = dettaglioPD.getRateLimiting();
        String protocollo = configurazione.getProtocollo();
        if (StringUtils.isNotEmpty((String)protocollo)) {
            oneLine.add(NamingUtils.getLabelProtocollo((String)protocollo));
        } else {
            oneLine.add("");
        }
        if (dettaglioPD.getIdAccordoServizioParteComune() != null) {
            aspc = dettaglioPD.getIdAccordoServizioParteComune();
            if (aspc.getServiceBinding() != null) {
                oneLine.add(aspc.getServiceBinding());
            } else {
                oneLine.add("");
            }
        } else {
            oneLine.add("");
        }
        if (dettaglioPD.getIdAccordoServizioParteComune() != null) {
            aspc = dettaglioPD.getIdAccordoServizioParteComune();
            String nomeAspc = aspc.getNome();
            Integer versioneAspc = aspc.getVersione();
            String nomeReferenteAspc = aspc.getIdSoggetto() != null ? aspc.getIdSoggetto().getNome() : null;
            String tipoReferenteAspc = aspc.getIdSoggetto() != null ? aspc.getIdSoggetto().getTipo() : null;
            oneLine.add(NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)IDAccordoFactory.getInstance().getIDAccordoFromValues(nomeAspc, tipoReferenteAspc, nomeReferenteAspc, versioneAspc)));
        } else {
            oneLine.add("");
        }
        if (StringUtils.isNotEmpty((String)dettaglioPD.getPortType())) {
            oneLine.add(dettaglioPD.getPortType());
        } else {
            oneLine.add("");
        }
        if (StringUtils.isNotEmpty((String)configurazione.getFruitore())) {
            oneLine.add(configurazione.getFruitore());
        } else {
            oneLine.add("");
        }
        if (StringUtils.isNotEmpty((String)configurazione.getErogatore())) {
            oneLine.add(configurazione.getErogatore());
        } else {
            oneLine.add("");
        }
        if (StringUtils.isNotEmpty((String)configurazione.getServizio())) {
            oneLine.add(configurazione.getServizio());
        } else {
            oneLine.add("");
        }
        if (StringUtils.isNotEmpty((String)portaDelegata.getNomeAzione()) && pdAzione != null && CostantiConfigurazione.PORTA_DELEGATA_AZIONE_STATIC.equals((Object)pdAzione.getIdentificazione())) {
            oneLine.add(portaDelegata.getNomeAzione());
        } else {
            List<String> azioni = dettaglioPD.getAzioni();
            if (pdAzione == null && (azioni == null || azioni.size() == 0)) {
                oneLine.add("Utilizzo del Servizio senza azione");
            } else {
                StringBuilder sb3 = new StringBuilder();
                if (azioni != null && azioni.size() > 0) {
                    for (String azione : azioni) {
                        if (sb3.length() > 0) {
                            sb3.append("\n");
                        }
                        sb3.append(azione);
                    }
                }
                oneLine.add(sb3.toString());
            }
        }
        if (mappingPD != null && mappingPD.getDescrizione() != null) {
            oneLine.add(mappingPD.getDescrizione());
        } else {
            oneLine.add("");
        }
        if (StringUtils.isNotEmpty((String)configurazione.getStato())) {
            oneLine.add(configurazione.getStato());
        } else {
            oneLine.add("");
        }
        String urlInvocazione = dettaglioPD.getUrlInvocazione();
        if (StringUtils.isNotEmpty((String)urlInvocazione)) {
            oneLine.add(urlInvocazione);
        } else {
            oneLine.add("");
        }
        if (pdAzione != null) {
            if (pdAzione.getIdentificazione() != null) {
                oneLine.add(pdAzione.getIdentificazione().toString());
            } else {
                oneLine.add("");
            }
            if (StringUtils.isNotEmpty((String)pdAzione.getPattern())) {
                oneLine.add(pdAzione.getPattern());
            } else {
                oneLine.add("");
            }
            if (pdAzione.getForceInterfaceBased() != null) {
                oneLine.add(pdAzione.getForceInterfaceBased().getValue());
            } else {
                oneLine.add("");
            }
        } else {
            oneLine.add("");
            oneLine.add("");
            oneLine.add("");
        }
        if (pdOp2Default != null) {
            if (pdOp2Default.getGestioneCors() != null) {
                oneLine.add(pdOp2Default.getGestioneCors().getStato().getValue());
            } else {
                oneLine.add("default");
            }
        } else if (pdOp2.getGestioneCors() != null) {
            oneLine.add(pdOp2.getGestioneCors().getStato().getValue());
        } else {
            oneLine.add("default");
        }
        GestioneToken gestioneToken = pdOp2.getGestioneToken();
        GestioneTokenAutenticazione gestioneTokenAutenticazione = null;
        if (gestioneToken != null) {
            StatoFunzionalita tokenOpzionale;
            gestioneTokenAutenticazione = gestioneToken.getAutenticazione();
            String policy = gestioneToken.getPolicy();
            StatoFunzionalita statoFunzionalita = tokenOpzionale = gestioneToken.getTokenOpzionale() != null ? gestioneToken.getTokenOpzionale() : StatoFunzionalita.DISABILITATO;
            if (policy != null) {
                oneLine.add(StatoFunzionalita.ABILITATO.getValue());
                oneLine.add(tokenOpzionale.getValue());
                oneLine.add(policy);
                oneLine.add(gestioneToken.getValidazione() != null ? gestioneToken.getValidazione().getValue() : "");
                oneLine.add(gestioneToken.getIntrospection() != null ? gestioneToken.getIntrospection().getValue() : "");
                oneLine.add(gestioneToken.getUserInfo() != null ? gestioneToken.getUserInfo().getValue() : "");
                oneLine.add(gestioneToken.getForward() != null ? gestioneToken.getForward().getValue() : "");
            } else {
                oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
                oneLine.add(tokenOpzionale.getValue());
                oneLine.add("");
                oneLine.add("");
                oneLine.add("");
                oneLine.add("");
                oneLine.add("");
            }
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
            oneLine.add("");
            oneLine.add("");
            oneLine.add("");
            oneLine.add("");
            oneLine.add("");
        }
        if (gestioneTokenAutenticazione != null) {
            oneLine.add(gestioneTokenAutenticazione.getIssuer() != null ? gestioneTokenAutenticazione.getIssuer().getValue() : StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(gestioneTokenAutenticazione.getClientId() != null ? gestioneTokenAutenticazione.getClientId().getValue() : StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(gestioneTokenAutenticazione.getSubject() != null ? gestioneTokenAutenticazione.getSubject().getValue() : StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(gestioneTokenAutenticazione.getUsername() != null ? gestioneTokenAutenticazione.getUsername().getValue() : StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(gestioneTokenAutenticazione.getEmail() != null ? gestioneTokenAutenticazione.getEmail().getValue() : StatoFunzionalita.DISABILITATO.getValue());
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
        }
        if ("none".equals(pdOp2.getAutenticazione())) {
            oneLine.add(CostantiConfigurazione.DISABILITATO.getValue());
        } else {
            oneLine.add(pdOp2.getAutenticazione());
        }
        if (CostantiConfigurazione.ABILITATO.equals((Object)pdOp2.getAutenticazioneOpzionale())) {
            oneLine.add(CostantiConfigurazione.ABILITATO.getValue());
        } else {
            oneLine.add(CostantiConfigurazione.DISABILITATO.getValue());
        }
        oneLine.add(this.toStringProprieta(pdOp2.getProprietaAutenticazioneList()));
        oneLine.add(this.toStringAttributeAuthority(pdOp2.getAttributeAuthorityList()));
        String autorizzazione = pdOp2.getAutorizzazione();
        if ("none".equals(autorizzazione)) {
            oneLine.add(CostantiConfigurazione.DISABILITATO.getValue());
        } else if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.XACML_POLICY.getValue().toLowerCase())) {
            oneLine.add(TipoAutorizzazione.XACML_POLICY.getValue());
        } else if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase()) || autorizzazione.toLowerCase().contains(TipoAutorizzazione.AUTHENTICATED.getValue().toLowerCase())) {
            oneLine.add(CostantiConfigurazione.ABILITATO.getValue());
        } else {
            oneLine.add(autorizzazione);
        }
        oneLine.add(this.toStringProprieta(pdOp2.getProprietaAutorizzazioneList()));
        if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.AUTHENTICATED.getValue().toLowerCase())) {
            oneLine.add(StatoFunzionalita.ABILITATO.getValue());
            List<String> sa = dettaglioPD.getSa();
            StringBuilder sb2 = new StringBuilder();
            for (String string : sa) {
                if (sb2.length() > 0) {
                    sb2.append("\n");
                }
                sb2.append(string);
            }
            oneLine.add(sb2.toString());
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
        }
        if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase())) {
            oneLine.add(StatoFunzionalita.ABILITATO.getValue());
            List<String> ruoli = dettaglioPD.getRuoli();
            match = dettaglioPD.getMatchRuoli();
            oneLine.add(match);
            if (pdOp2.getRuoli() != null) {
                sb = new StringBuilder();
                for (String ruolo : ruoli) {
                    if (((StringBuilder)sb).length() > 0) {
                        ((StringBuilder)sb).append("\n");
                    }
                    ((StringBuilder)sb).append(ruolo);
                }
                oneLine.add(((StringBuilder)sb).toString());
            } else {
                oneLine.add("");
            }
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
            oneLine.add("");
        }
        PortaDelegataAutorizzazioneToken autorizzazioneToken = pdOp2.getAutorizzazioneToken();
        if (autorizzazioneToken != null && StatoFunzionalita.ABILITATO.equals((Object)autorizzazioneToken.getAutorizzazioneApplicativi())) {
            oneLine.add(StatoFunzionalita.ABILITATO.getValue());
            StringBuilder sb2 = new StringBuilder();
            if (autorizzazioneToken.getServiziApplicativi() != null && autorizzazioneToken.getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                for (PortaDelegataServizioApplicativo portaDelegataServizioApplicativo : autorizzazioneToken.getServiziApplicativi().getServizioApplicativoList()) {
                    if (sb2.length() > 0) {
                        sb2.append("\n");
                    }
                    sb2.append(portaDelegataServizioApplicativo.getNome());
                }
            }
            oneLine.add(sb2.toString());
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
        }
        if (autorizzazioneToken != null && StatoFunzionalita.ABILITATO.equals((Object)autorizzazioneToken.getAutorizzazioneRuoli())) {
            oneLine.add(StatoFunzionalita.ABILITATO.getValue());
            match = autorizzazioneToken.getRuoli() != null && autorizzazioneToken.getRuoli().getMatch() != null ? (RuoloTipoMatch.ANY.equals((Object)autorizzazioneToken.getRuoli().getMatch()) ? "almeno uno" : "tutti") : "";
            oneLine.add(match);
            if (autorizzazioneToken.getRuoli() != null && autorizzazioneToken.getRuoli().sizeRuoloList() > 0) {
                sb = new StringBuilder();
                for (String ruolo : autorizzazioneToken.getRuoli().getRuoloList()) {
                    if (((StringBuilder)sb).length() > 0) {
                        ((StringBuilder)sb).append("\n");
                    }
                    ((StringBuilder)sb).append(ruolo.getNome());
                }
                oneLine.add(((StringBuilder)sb).toString());
            } else {
                oneLine.add("");
            }
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
            oneLine.add("");
        }
        if (gestioneToken != null) {
            if (StringUtils.isNotEmpty((String)gestioneToken.getOptions())) {
                oneLine.add(gestioneToken.getOptions());
            } else {
                oneLine.add("");
            }
        } else {
            oneLine.add("");
        }
        AutorizzazioneScope scope = pdOp2.getScope();
        if (scope != null) {
            oneLine.add(scope.getStato().getValue());
            oneLine.add(scope.getMatch().getValue());
            if (scope.getScopeList() != null) {
                sb = new StringBuilder();
                for (Scope scopeS : scope.getScopeList()) {
                    if (((StringBuilder)sb).length() > 0) {
                        ((StringBuilder)sb).append("\n");
                    }
                    ((StringBuilder)sb).append(scopeS.getNome());
                }
                oneLine.add(((StringBuilder)sb).toString());
            } else {
                oneLine.add("");
            }
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
            oneLine.add("");
        }
        String autorizzazioneContenuti = pdOp2.getAutorizzazioneContenuto();
        if ("none".equals(autorizzazioneContenuti)) {
            oneLine.add(CostantiConfigurazione.DISABILITATO.getValue());
        } else if ("builtIn".equals(autorizzazioneContenuti)) {
            oneLine.add(CostantiConfigurazione.ABILITATO.getValue());
        } else {
            oneLine.add(autorizzazioneContenuti);
        }
        oneLine.add(this.toStringProprieta(pdOp2.getProprietaAutorizzazioneContenutoList()));
        if (rateLimiting != null) {
            oneLine.add(rateLimiting.getAsCSVRecord());
        } else {
            oneLine.add("");
        }
        ValidazioneContenutiApplicativi validazioneContenutiApplicativi = pdOp2.getValidazioneContenutiApplicativi();
        if (validazioneContenutiApplicativi != null) {
            oneLine.add(validazioneContenutiApplicativi.getStato().getValue());
            oneLine.add(validazioneContenutiApplicativi.getTipo().getValue());
            oneLine.add(validazioneContenutiApplicativi.getAcceptMtomMessage().getValue());
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
            oneLine.add("");
        }
        if (pdOp2.getResponseCaching() != null) {
            oneLine.add(pdOp2.getResponseCaching().getStato().getValue());
        } else {
            oneLine.add("default");
        }
        MessageSecurity messageSecurity = pdOp2.getMessageSecurity();
        String requestMode = null;
        String responseMode = null;
        if (messageSecurity != null) {
            if (messageSecurity.getRequestFlow() != null) {
                requestMode = messageSecurity.getRequestFlow().getMode();
            }
            if (messageSecurity.getResponseFlow() != null) {
                responseMode = messageSecurity.getResponseFlow().getMode();
            }
        }
        if (StringUtils.isNotEmpty((String)(statoMessageSecurity = pdOp2.getStatoMessageSecurity()))) {
            oneLine.add(statoMessageSecurity);
            if (StatoFunzionalita.ABILITATO.getValue().equals(statoMessageSecurity)) {
                if (StringUtils.isNotEmpty((String)requestMode)) {
                    if (requestMode.equals("default")) {
                        oneLine.add("Configurazione Manuale");
                    } else {
                        oneLine.add(requestMode);
                    }
                } else {
                    oneLine.add("Nessuno");
                }
                if (StringUtils.isNotEmpty((String)responseMode)) {
                    if (responseMode.equals("default")) {
                        oneLine.add("Configurazione Manuale");
                    } else {
                        oneLine.add(responseMode);
                    }
                } else {
                    oneLine.add("Nessuno");
                }
            } else {
                oneLine.add("");
                oneLine.add("");
            }
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
            oneLine.add("");
            oneLine.add("");
        }
        MtomProcessor mtomProcessor = pdOp2.getMtomProcessor();
        if (mtomProcessor != null) {
            MtomProcessorFlow requestFlow = mtomProcessor.getRequestFlow();
            if (requestFlow != null) {
                oneLine.add(requestFlow.getMode().getValue());
            } else {
                oneLine.add("");
            }
            MtomProcessorFlow responseFlow = mtomProcessor.getResponseFlow();
            if (responseFlow != null) {
                oneLine.add(responseFlow.getMode().getValue());
            } else {
                oneLine.add("");
            }
        } else {
            oneLine.add("");
            oneLine.add("");
        }
        oneLine.add(this.toStringTrasformazioni(pdOp2.getTrasformazioni()));
        int numCorrelazioneReq = 0;
        int numCorrelazioneRes = 0;
        CorrelazioneApplicativa ca = pdOp2.getCorrelazioneApplicativa();
        if (ca != null) {
            numCorrelazioneReq = ca.sizeElementoList();
        }
        if (pdOp2.getCorrelazioneApplicativaRisposta() != null) {
            numCorrelazioneRes = pdOp2.getCorrelazioneApplicativaRisposta().sizeElementoList();
        }
        if (numCorrelazioneReq > 0) {
            oneLine.add(StatoFunzionalita.ABILITATO.getValue());
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
        }
        if (numCorrelazioneRes > 0) {
            oneLine.add(StatoFunzionalita.ABILITATO.getValue());
        } else {
            oneLine.add(StatoFunzionalita.DISABILITATO.getValue());
        }
        oneLine.add(this.toStringDump(pdOp2.getDump()));
        oneLine.add(this.toStringProprieta(pdOp2.getProprietaList()));
        if (StringUtils.isNotEmpty((String)pdOp2.getIntegrazione())) {
            oneLine.add(pdOp2.getIntegrazione());
        } else {
            oneLine.add("");
        }
        oneLine.add(this.toStringHandlers(pdOp2.getConfigurazioneHandler()));
        if (StringUtils.isNotEmpty((String)dettaglioPD.getConfigurazioneProfilo())) {
            oneLine.add(dettaglioPD.getConfigurazioneProfilo());
        } else {
            oneLine.add("");
        }
        if (dettaglioPD.getConnettore() != null) {
            Connettore connettore = dettaglioPD.getConnettore();
            oneLine.addAll(this.printConnettore(connettore, "Modalit\u00e0 Inoltro", null, null, null));
        } else {
            for (int i = 0; i < 17; ++i) {
                oneLine.add("");
            }
        }
        if (StringUtils.isNotEmpty((String)portaDelegata.getNome())) {
            oneLine.add(portaDelegata.getNome());
        } else {
            oneLine.add("");
        }
        dataSource.add(oneLine.toArray(new Object[oneLine.size()]));
    }

    public List<Object> printConnettore(Connettore connettore, String labelTipoConnettore, InvocazioneCredenziali invCredenziali, StatoFunzionalita integrationManager, InvocazionePorta invocazionePorta) {
        String username;
        ArrayList<Object> oneLine = new ArrayList<Object>();
        HashMap<Integer, Object> mapProperties = new HashMap<Integer, Object>();
        mapProperties.put(1, connettore.getTipo());
        if (TipiConnettore.HTTP.getNome().equals(connettore.getTipo()) || TipiConnettore.HTTPS.getNome().equals(connettore.getTipo())) {
            String proxy;
            String apiKey;
            String token;
            mapProperties.put(2, ConfigurazioniUtils.getProperty("location", connettore.getPropertyList()));
            boolean find = false;
            if (integrationManager != null && StatoFunzionalita.ABILITATO.equals((Object)integrationManager) && invocazionePorta != null && invocazionePorta.sizeCredenzialiList() > 0) {
                for (Object c : invocazionePorta.getCredenzialiList()) {
                    if (!CredenzialeTipo.BASIC.equals((Object)c.getTipo()) || c.getUser() == null || !StringUtils.isNotEmpty((String)c.getUser())) continue;
                    find = true;
                    mapProperties.put(4, c.getUser());
                }
            }
            if (!find) {
                if (invCredenziali != null) {
                    mapProperties.put(4, invCredenziali.getUser());
                } else {
                    username = ConfigurazioniUtils.getProperty("user", connettore.getPropertyList());
                    if (username != null) {
                        mapProperties.put(4, username);
                    }
                }
            }
            if ((token = ConfigurazioniUtils.getProperty("tokenPolicy", connettore.getPropertyList())) != null) {
                mapProperties.put(5, token);
            }
            if ((apiKey = ConfigurazioniUtils.getProperty("apiKey", connettore.getPropertyList())) != null && StringUtils.isNotEmpty((String)apiKey)) {
                String apiKeyHeader = ConfigurazioniUtils.getProperty("apiKeyHeader", connettore.getPropertyList());
                if (apiKeyHeader == null || StringUtils.isEmpty((String)apiKeyHeader)) {
                    apiKeyHeader = "X-API-KEY";
                }
                mapProperties.put(6, apiKeyHeader + ": ***");
                String appId = ConfigurazioniUtils.getProperty("appId", connettore.getPropertyList());
                if (appId != null && StringUtils.isNotEmpty((String)appId)) {
                    String appIdHeader = ConfigurazioniUtils.getProperty("appIdHeader", connettore.getPropertyList());
                    if (appIdHeader == null || StringUtils.isEmpty((String)appIdHeader)) {
                        appIdHeader = "X-APP-ID";
                    }
                    mapProperties.put(7, appIdHeader + ": " + appId);
                }
            }
            if (TipiConnettore.HTTPS.getNome().equals(connettore.getTipo())) {
                String certAlias;
                String v;
                mapProperties.put(10, ConfigurazioniUtils.getProperty("sslType", connettore.getPropertyList()));
                mapProperties.put(11, ConfigurazioniUtils.getProperty("hostnameVerifier", connettore.getPropertyList()));
                mapProperties.put(13, ConfigurazioniUtils.getProperty("trustStoreType", connettore.getPropertyList()));
                boolean trustAllCerts = false;
                if (connettore.getProperties().containsKey("trustAllCerts") && "true".equalsIgnoreCase(v = ConfigurazioniUtils.getProperty("trustAllCerts", connettore.getPropertyList()))) {
                    trustAllCerts = true;
                }
                if (trustAllCerts) {
                    mapProperties.put(15, "Trust all certificates");
                } else {
                    mapProperties.put(15, ConfigurazioniUtils.getProperty("trustStoreLocation", connettore.getPropertyList()));
                }
                boolean invioCertificatoClient = false;
                String cert = ConfigurazioniUtils.getProperty("keyStoreLocation", connettore.getPropertyList());
                if (cert != null) {
                    mapProperties.put(14, cert);
                    invioCertificatoClient = true;
                }
                if (invioCertificatoClient) {
                    mapProperties.put(12, ConfigurazioniUtils.getProperty("keyStoreType", connettore.getPropertyList()));
                }
                Object invioCertificatoClientLabel = "" + invioCertificatoClient;
                if (invioCertificatoClient && (certAlias = ConfigurazioniUtils.getProperty("keyAlias", connettore.getPropertyList())) != null && StringUtils.isNotEmpty((String)certAlias)) {
                    invioCertificatoClientLabel = certAlias;
                }
                mapProperties.put(16, invioCertificatoClientLabel);
            }
            if ((proxy = ConfigurazioniUtils.getProperty("proxyType", connettore.getPropertyList())) != null) {
                mapProperties.put(8, ConfigurazioniUtils.getProperty("proxyHostname", connettore.getPropertyList()) + ":" + ConfigurazioniUtils.getProperty("proxyPort", connettore.getPropertyList()));
                String username2 = ConfigurazioniUtils.getProperty("proxyUsername", connettore.getPropertyList());
                if (username2 != null) {
                    mapProperties.put(9, username2);
                }
            }
        } else if (TipiConnettore.JMS.getNome().equals(connettore.getTipo())) {
            mapProperties.put(2, ConfigurazioniUtils.getProperty("location", connettore.getPropertyList()));
            StringBuilder sb = new StringBuilder();
            sb.append("Tipo JMS").append(": ").append(ConfigurazioniUtils.getProperty("tipo", connettore.getPropertyList())).append("\n");
            sb.append("Connection Factory").append(": ").append(ConfigurazioniUtils.getProperty("connection-factory", connettore.getPropertyList())).append("\n");
            sb.append("SendAs").append(": ").append(ConfigurazioniUtils.getProperty("send-as", connettore.getPropertyList()));
            mapProperties.put(17, sb.toString());
            if (invCredenziali != null) {
                mapProperties.put(4, invCredenziali.getUser());
            } else {
                username = ConfigurazioniUtils.getProperty("user", connettore.getPropertyList());
                if (username != null) {
                    mapProperties.put(4, username);
                }
            }
        } else if (TipiConnettore.FILE.getNome().equals(connettore.getTipo())) {
            StringBuilder sb = new StringBuilder();
            sb.append("OutputFile").append(": ").append(ConfigurazioniUtils.getProperty("outputFile", connettore.getPropertyList())).append("\n");
            sb.append("OutputFile (Header)").append(": ").append(ConfigurazioniUtils.getProperty("outputFileHeaders", connettore.getPropertyList())).append("\n");
            String risposta = ConfigurazioniUtils.getProperty("response", connettore.getPropertyList());
            if (risposta != null) {
                sb.append("InputFile").append(": ").append(ConfigurazioniUtils.getProperty("inputFile", connettore.getPropertyList())).append("\n");
                sb.append("InputFile (Header)").append(": ").append(ConfigurazioniUtils.getProperty("inputFileHeaders", connettore.getPropertyList()));
            }
            mapProperties.put(17, sb.toString());
        } else if (TipiConnettore.NULL.getNome().equals(connettore.getTipo())) {
            mapProperties.put(2, "govway://dev/null");
        } else if (TipiConnettore.NULLECHO.getNome().equals(connettore.getTipo())) {
            mapProperties.put(2, "govway://echo");
        } else if (TipiConnettore.STATUS.getNome().equals(connettore.getTipo())) {
            mapProperties.put(2, "govway://status");
            StringBuilder sb = new StringBuilder();
            sb.append("Tipo Risposta").append(": ").append(ConfigurazioniUtils.getProperty("statusResponseType", connettore.getPropertyList())).append("\n");
            sb.append("Verifica Connettivit\u00e0").append(": ").append(ConfigurazioniUtils.getProperty("testConnectivity", connettore.getPropertyList())).append("\n");
            if (ConfigurazioniUtils.getProperty("period", connettore.getPropertyList()) != null) {
                sb.append("Verifica Statistica").append(": ").append(ConfigurazioniUtils.getProperty("period", connettore.getPropertyList())).append("\n");
                sb.append("Intervallo Osservazione").append(": ").append(ConfigurazioniUtils.getProperty("periodValue", connettore.getPropertyList())).append("\n");
            }
            if (ConfigurazioniUtils.getProperty("statLifetime", connettore.getPropertyList()) != null) {
                sb.append("Cache Life Time").append(": ").append(ConfigurazioniUtils.getProperty("statLifetime", connettore.getPropertyList())).append("\n");
            }
            mapProperties.put(17, sb.toString());
        } else if (integrationManager != null && StatoFunzionalita.ABILITATO.equals((Object)integrationManager)) {
            boolean find = false;
            if (invocazionePorta != null && invocazionePorta.sizeCredenzialiList() > 0) {
                for (Object c : invocazionePorta.getCredenzialiList()) {
                    if (!CredenzialeTipo.BASIC.equals((Object)c.getTipo()) || c.getUser() == null || !StringUtils.isNotEmpty((String)c.getUser())) continue;
                    find = true;
                    mapProperties.put(4, c.getUser());
                }
            }
            if (!find) {
                if (invCredenziali != null) {
                    mapProperties.put(4, invCredenziali.getUser());
                } else {
                    username = ConfigurazioniUtils.getProperty("user", connettore.getPropertyList());
                    if (username != null) {
                        mapProperties.put(4, username);
                    }
                }
            }
        } else {
            List list = connettore.getPropertyList();
            if (list != null && !list.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Property property : list) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(property.getNome()).append(": ").append(property.getValore());
                }
                mapProperties.put(17, sb.toString());
            }
        }
        String debug = "false";
        if (ConfigurazioniUtils.getProperty("debug", connettore.getPropertyList()) != null) {
            debug = ConfigurazioniUtils.getProperty("debug", connettore.getPropertyList());
        }
        mapProperties.put(3, debug);
        for (int i = 1; i < 18; ++i) {
            String valoreProprieta = (String)mapProperties.get(i);
            if (StringUtils.isNotEmpty((String)valoreProprieta)) {
                oneLine.add(valoreProprieta);
                continue;
            }
            oneLine.add("");
        }
        return oneLine;
    }

    private String toStringProprieta(List<Proprieta> list) {
        StringBuilder sb = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            for (Proprieta p : list) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(p.getNome());
                sb.append("=");
                sb.append(p.getValore());
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "";
    }

    private String toStringAttributeAuthority(List<AttributeAuthority> list) {
        StringBuilder sb = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            for (AttributeAuthority aa : list) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(aa.getNome());
                sb.append("=");
                if (aa.sizeAttributoList() <= 0) continue;
                boolean first = true;
                for (Object attr : aa.getAttributoList()) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(attr);
                    first = false;
                }
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "";
    }

    private String toStringTrasformazioni(Trasformazioni trasformazioni) {
        StringBuilder sb = new StringBuilder();
        if (trasformazioni != null && trasformazioni.sizeRegolaList() > 0) {
            for (TrasformazioneRegola regola : trasformazioni.getRegolaList()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(regola.getNome());
                sb.append(" ");
                sb.append(regola.getStato().getValue());
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "";
    }

    private String toStringDump(DumpConfigurazione dump) {
        StringBuilder sb = new StringBuilder();
        if (dump != null) {
            if (StatoFunzionalita.ABILITATO.equals((Object)dump.getRealtime())) {
                sb.append("\n");
                sb.append("richiesta-ingresso ").append(this.toStringDumpRegola(dump.getRichiestaIngresso()));
                sb.append("\n");
                sb.append("richiesta-uscita ").append(this.toStringDumpRegola(dump.getRichiestaUscita()));
                sb.append("\n");
                sb.append("risposta-ingresso ").append(this.toStringDumpRegola(dump.getRispostaIngresso()));
                sb.append("\n");
                sb.append("risposta-uscita ").append(this.toStringDumpRegola(dump.getRispostaUscita()));
            } else {
                sb.append("default");
            }
        } else {
            sb.append("default");
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "";
    }

    private String toStringDumpRegola(DumpConfigurazioneRegola regola) {
        StringBuilder sb = new StringBuilder();
        if (regola != null) {
            sb.append("header:").append(regola.getHeaders());
            sb.append(" ");
            sb.append("payload:").append(regola.getPayload());
        } else {
            sb.append(CostantiConfigurazione.DISABILITATO.getValue());
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "";
    }

    private String toStringHandlers(ConfigurazionePortaHandler config) {
        StringBuilder sb = new StringBuilder();
        if (config != null) {
            if (config.getRequest() != null) {
                sb.append(this.toStringMessageHandlers(config.getRequest(), "request"));
            }
            if (config.getResponse() != null) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(this.toStringMessageHandlers(config.getResponse(), "response"));
            }
        }
        if (sb.length() > 0) {
            sb.append("default");
            return sb.toString();
        }
        return "";
    }

    private String toStringMessageHandlers(ConfigurazioneMessageHandlers hdr, String role) {
        int i;
        StringBuilder sb = new StringBuilder("");
        if (hdr.sizePreInList() > 0) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(role).append("-pre-in:");
            i = 0;
            for (ConfigurazioneHandler h : hdr.getPreInList()) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(h.getTipo());
                ++i;
            }
        }
        if (hdr.sizeInList() > 0) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(role).append("-in:");
            i = 0;
            for (ConfigurazioneHandler h : hdr.getInList()) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(h.getTipo());
                ++i;
            }
        }
        if (hdr.sizeInProtocolInfoList() > 0) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(role).append("-in-profile-info:");
            i = 0;
            for (ConfigurazioneHandler h : hdr.getInProtocolInfoList()) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(h.getTipo());
                ++i;
            }
        }
        if (hdr.sizeOutList() > 0) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(role).append("-out:");
            i = 0;
            for (ConfigurazioneHandler h : hdr.getOutList()) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(h.getTipo());
                ++i;
            }
        }
        if (hdr.sizePostOutList() > 0) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(role).append("-post-out:");
            i = 0;
            for (ConfigurazioneHandler h : hdr.getPostOutList()) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(h.getTipo());
                ++i;
            }
        }
        return sb.toString();
    }
}

